"""
Handles publishing arrays, videos, and cameras.

CamCtrl handles sending and receiving commands to specific camera (or array/video) publishers
VideoHandlerThread updates the frames for the global displayer, since OpenCV can only update on the main thread
get_cam_ids gets the ids for all cameras that OpenCV can detect
pub_cam_thread continually publishes updates to arrays, videos, and cameras
np_cam simulates numpy arrays as OpenCV cameras
"""

from . import subscriber_dictionary
from .frame_updater import FrameUpdater, read_updates
from .get_frame_ids import get_cam_ids
from .np_to_opencv import NpCam
from .frame_publishing import pub_cam_thread
