# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AddClusterInstancesRequest(AbstractModel):
    """AddClusterInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _InstanceIdList: 云主机ID列表
        :type InstanceIdList: list of str
        :param _OsName: 操作系统名称
        :type OsName: str
        :param _ImageId: 操作系统镜像ID
        :type ImageId: str
        :param _Password: 重装系统密码设置
        :type Password: str
        :param _KeyId: 重装系统，关联密钥设置
        :type KeyId: str
        :param _SgId: 安全组设置
        :type SgId: str
        :param _InstanceImportMode: 云主机导入方式，虚拟机集群必填，容器集群不填写此字段，R：重装TSF系统镜像，M：手动安装agent
        :type InstanceImportMode: str
        :param _OsCustomizeType: 镜像定制类型
        :type OsCustomizeType: str
        :param _FeatureIdList: 镜像特征ID列表
        :type FeatureIdList: list of str
        :param _InstanceAdvancedSettings: 实例额外需要设置参数信息
        :type InstanceAdvancedSettings: :class:`tencentcloud.tsf.v20180326.models.InstanceAdvancedSettings`
        :param _SecurityGroupIds: 安全组 ID 列表
        :type SecurityGroupIds: list of str
        """
        self._ClusterId = None
        self._InstanceIdList = None
        self._OsName = None
        self._ImageId = None
        self._Password = None
        self._KeyId = None
        self._SgId = None
        self._InstanceImportMode = None
        self._OsCustomizeType = None
        self._FeatureIdList = None
        self._InstanceAdvancedSettings = None
        self._SecurityGroupIds = None

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceIdList(self):
        """云主机ID列表
        :rtype: list of str
        """
        return self._InstanceIdList

    @InstanceIdList.setter
    def InstanceIdList(self, InstanceIdList):
        self._InstanceIdList = InstanceIdList

    @property
    def OsName(self):
        """操作系统名称
        :rtype: str
        """
        return self._OsName

    @OsName.setter
    def OsName(self, OsName):
        self._OsName = OsName

    @property
    def ImageId(self):
        """操作系统镜像ID
        :rtype: str
        """
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def Password(self):
        """重装系统密码设置
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def KeyId(self):
        """重装系统，关联密钥设置
        :rtype: str
        """
        return self._KeyId

    @KeyId.setter
    def KeyId(self, KeyId):
        self._KeyId = KeyId

    @property
    def SgId(self):
        """安全组设置
        :rtype: str
        """
        return self._SgId

    @SgId.setter
    def SgId(self, SgId):
        self._SgId = SgId

    @property
    def InstanceImportMode(self):
        """云主机导入方式，虚拟机集群必填，容器集群不填写此字段，R：重装TSF系统镜像，M：手动安装agent
        :rtype: str
        """
        return self._InstanceImportMode

    @InstanceImportMode.setter
    def InstanceImportMode(self, InstanceImportMode):
        self._InstanceImportMode = InstanceImportMode

    @property
    def OsCustomizeType(self):
        """镜像定制类型
        :rtype: str
        """
        return self._OsCustomizeType

    @OsCustomizeType.setter
    def OsCustomizeType(self, OsCustomizeType):
        self._OsCustomizeType = OsCustomizeType

    @property
    def FeatureIdList(self):
        """镜像特征ID列表
        :rtype: list of str
        """
        return self._FeatureIdList

    @FeatureIdList.setter
    def FeatureIdList(self, FeatureIdList):
        self._FeatureIdList = FeatureIdList

    @property
    def InstanceAdvancedSettings(self):
        """实例额外需要设置参数信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.InstanceAdvancedSettings`
        """
        return self._InstanceAdvancedSettings

    @InstanceAdvancedSettings.setter
    def InstanceAdvancedSettings(self, InstanceAdvancedSettings):
        self._InstanceAdvancedSettings = InstanceAdvancedSettings

    @property
    def SecurityGroupIds(self):
        """安全组 ID 列表
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceIdList = params.get("InstanceIdList")
        self._OsName = params.get("OsName")
        self._ImageId = params.get("ImageId")
        self._Password = params.get("Password")
        self._KeyId = params.get("KeyId")
        self._SgId = params.get("SgId")
        self._InstanceImportMode = params.get("InstanceImportMode")
        self._OsCustomizeType = params.get("OsCustomizeType")
        self._FeatureIdList = params.get("FeatureIdList")
        if params.get("InstanceAdvancedSettings") is not None:
            self._InstanceAdvancedSettings = InstanceAdvancedSettings()
            self._InstanceAdvancedSettings._deserialize(params.get("InstanceAdvancedSettings"))
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddClusterInstancesResponse(AbstractModel):
    """AddClusterInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 添加云主机的返回列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.AddInstanceResult`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """添加云主机的返回列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.AddInstanceResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = AddInstanceResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class AddInstanceResult(AbstractModel):
    """添加实例到集群的结果

    """

    def __init__(self):
        r"""
        :param _FailedInstanceIds: 添加集群失败的节点列表
        :type FailedInstanceIds: list of str
        :param _SuccInstanceIds: 添加集群成功的节点列表
        :type SuccInstanceIds: list of str
        :param _TimeoutInstanceIds: 添加集群超时的节点列表
        :type TimeoutInstanceIds: list of str
        :param _FailedReasons: 失败的节点的失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedReasons: list of str
        """
        self._FailedInstanceIds = None
        self._SuccInstanceIds = None
        self._TimeoutInstanceIds = None
        self._FailedReasons = None

    @property
    def FailedInstanceIds(self):
        """添加集群失败的节点列表
        :rtype: list of str
        """
        return self._FailedInstanceIds

    @FailedInstanceIds.setter
    def FailedInstanceIds(self, FailedInstanceIds):
        self._FailedInstanceIds = FailedInstanceIds

    @property
    def SuccInstanceIds(self):
        """添加集群成功的节点列表
        :rtype: list of str
        """
        return self._SuccInstanceIds

    @SuccInstanceIds.setter
    def SuccInstanceIds(self, SuccInstanceIds):
        self._SuccInstanceIds = SuccInstanceIds

    @property
    def TimeoutInstanceIds(self):
        """添加集群超时的节点列表
        :rtype: list of str
        """
        return self._TimeoutInstanceIds

    @TimeoutInstanceIds.setter
    def TimeoutInstanceIds(self, TimeoutInstanceIds):
        self._TimeoutInstanceIds = TimeoutInstanceIds

    @property
    def FailedReasons(self):
        """失败的节点的失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._FailedReasons

    @FailedReasons.setter
    def FailedReasons(self, FailedReasons):
        self._FailedReasons = FailedReasons


    def _deserialize(self, params):
        self._FailedInstanceIds = params.get("FailedInstanceIds")
        self._SuccInstanceIds = params.get("SuccInstanceIds")
        self._TimeoutInstanceIds = params.get("TimeoutInstanceIds")
        self._FailedReasons = params.get("FailedReasons")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddInstancesRequest(AbstractModel):
    """AddInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _InstanceIdList: 云主机ID列表
        :type InstanceIdList: list of str
        :param _OsName: 操作系统名称
        :type OsName: str
        :param _ImageId: 操作系统镜像ID
        :type ImageId: str
        :param _Password: 重装系统密码设置
        :type Password: str
        :param _KeyId: 重装系统，关联密钥设置
        :type KeyId: str
        :param _SgId: 安全组设置
        :type SgId: str
        :param _InstanceImportMode: 云主机导入方式，虚拟机集群必填，容器集群不填写此字段，R：重装TSF系统镜像，M：手动安装agent
        :type InstanceImportMode: str
        :param _SecurityGroupIds: 安全组id
        :type SecurityGroupIds: str
        """
        self._ClusterId = None
        self._InstanceIdList = None
        self._OsName = None
        self._ImageId = None
        self._Password = None
        self._KeyId = None
        self._SgId = None
        self._InstanceImportMode = None
        self._SecurityGroupIds = None

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceIdList(self):
        """云主机ID列表
        :rtype: list of str
        """
        return self._InstanceIdList

    @InstanceIdList.setter
    def InstanceIdList(self, InstanceIdList):
        self._InstanceIdList = InstanceIdList

    @property
    def OsName(self):
        """操作系统名称
        :rtype: str
        """
        return self._OsName

    @OsName.setter
    def OsName(self, OsName):
        self._OsName = OsName

    @property
    def ImageId(self):
        """操作系统镜像ID
        :rtype: str
        """
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def Password(self):
        """重装系统密码设置
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def KeyId(self):
        """重装系统，关联密钥设置
        :rtype: str
        """
        return self._KeyId

    @KeyId.setter
    def KeyId(self, KeyId):
        self._KeyId = KeyId

    @property
    def SgId(self):
        """安全组设置
        :rtype: str
        """
        return self._SgId

    @SgId.setter
    def SgId(self, SgId):
        self._SgId = SgId

    @property
    def InstanceImportMode(self):
        """云主机导入方式，虚拟机集群必填，容器集群不填写此字段，R：重装TSF系统镜像，M：手动安装agent
        :rtype: str
        """
        return self._InstanceImportMode

    @InstanceImportMode.setter
    def InstanceImportMode(self, InstanceImportMode):
        self._InstanceImportMode = InstanceImportMode

    @property
    def SecurityGroupIds(self):
        """安全组id
        :rtype: str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceIdList = params.get("InstanceIdList")
        self._OsName = params.get("OsName")
        self._ImageId = params.get("ImageId")
        self._Password = params.get("Password")
        self._KeyId = params.get("KeyId")
        self._SgId = params.get("SgId")
        self._InstanceImportMode = params.get("InstanceImportMode")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddInstancesResponse(AbstractModel):
    """AddInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 添加云主机是否成功
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """添加云主机是否成功
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class AdvanceSettings(AbstractModel):
    """高级选项设置

    """

    def __init__(self):
        r"""
        :param _SubTaskConcurrency: 子任务单机并发数限制，默认值为2
        :type SubTaskConcurrency: int
        """
        self._SubTaskConcurrency = None

    @property
    def SubTaskConcurrency(self):
        """子任务单机并发数限制，默认值为2
        :rtype: int
        """
        return self._SubTaskConcurrency

    @SubTaskConcurrency.setter
    def SubTaskConcurrency(self, SubTaskConcurrency):
        self._SubTaskConcurrency = SubTaskConcurrency


    def _deserialize(self, params):
        self._SubTaskConcurrency = params.get("SubTaskConcurrency")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Affinity(AbstractModel):
    """亲和规则

    """

    def __init__(self):
        r"""
        :param _Scope: 亲和性范围
        :type Scope: str
        :param _Weight: 亲和规则的权重
        :type Weight: str
        :param _Paths: -
        :type Paths: list of CommonOption
        """
        self._Scope = None
        self._Weight = None
        self._Paths = None

    @property
    def Scope(self):
        """亲和性范围
        :rtype: str
        """
        return self._Scope

    @Scope.setter
    def Scope(self, Scope):
        self._Scope = Scope

    @property
    def Weight(self):
        """亲和规则的权重
        :rtype: str
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def Paths(self):
        """-
        :rtype: list of CommonOption
        """
        return self._Paths

    @Paths.setter
    def Paths(self, Paths):
        self._Paths = Paths


    def _deserialize(self, params):
        self._Scope = params.get("Scope")
        self._Weight = params.get("Weight")
        if params.get("Paths") is not None:
            self._Paths = []
            for item in params.get("Paths"):
                obj = CommonOption()
                obj._deserialize(item)
                self._Paths.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AgentProfile(AbstractModel):
    """部署javaagent的类型、版本信息

    """

    def __init__(self):
        r"""
        :param _AgentType: Agent类型
        :type AgentType: str
        :param _AgentVersion: Agent版本号
        :type AgentVersion: str
        """
        self._AgentType = None
        self._AgentVersion = None

    @property
    def AgentType(self):
        """Agent类型
        :rtype: str
        """
        return self._AgentType

    @AgentType.setter
    def AgentType(self, AgentType):
        self._AgentType = AgentType

    @property
    def AgentVersion(self):
        """Agent版本号
        :rtype: str
        """
        return self._AgentVersion

    @AgentVersion.setter
    def AgentVersion(self, AgentVersion):
        self._AgentVersion = AgentVersion


    def _deserialize(self, params):
        self._AgentType = params.get("AgentType")
        self._AgentVersion = params.get("AgentVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiDefinitionDescr(AbstractModel):
    """API 对象类型描述

    """

    def __init__(self):
        r"""
        :param _Name: 对象名称
        :type Name: str
        :param _Properties: 对象属性列表
        :type Properties: list of PropertyField
        """
        self._Name = None
        self._Properties = None

    @property
    def Name(self):
        """对象名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Properties(self):
        """对象属性列表
        :rtype: list of PropertyField
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("Properties") is not None:
            self._Properties = []
            for item in params.get("Properties"):
                obj = PropertyField()
                obj._deserialize(item)
                self._Properties.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiDetailInfo(AbstractModel):
    """API 明细

    """

    def __init__(self):
        r"""
        :param _ApiId: API ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ApiId: str
        :param _NamespaceId: 命名空间ID
注意：此字段可能返回 null，表示取不到有效值。
        :type NamespaceId: str
        :param _NamespaceName: 命名空间名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NamespaceName: str
        :param _MicroserviceId: 服务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type MicroserviceId: str
        :param _MicroserviceName: 服务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type MicroserviceName: str
        :param _Path: API 请求路径
注意：此字段可能返回 null，表示取不到有效值。
        :type Path: str
        :param _PathMapping: Api 映射路径
注意：此字段可能返回 null，表示取不到有效值。
        :type PathMapping: str
        :param _Method: 请求方法
注意：此字段可能返回 null，表示取不到有效值。
        :type Method: str
        :param _GroupId: 所属分组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupId: str
        :param _UsableStatus: 是否禁用
注意：此字段可能返回 null，表示取不到有效值。
        :type UsableStatus: str
        :param _ReleaseStatus: 发布状态
注意：此字段可能返回 null，表示取不到有效值。
        :type ReleaseStatus: str
        :param _RateLimitStatus: 开启限流
注意：此字段可能返回 null，表示取不到有效值。
        :type RateLimitStatus: str
        :param _MockStatus: 是否开启mock
注意：此字段可能返回 null，表示取不到有效值。
        :type MockStatus: str
        :param _CreatedTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreatedTime: str
        :param _UpdatedTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdatedTime: str
        :param _ReleasedTime: 发布时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ReleasedTime: str
        :param _GroupName: 所属分组名称
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupName: str
        :param _Timeout: API 超时，单位毫秒
注意：此字段可能返回 null，表示取不到有效值。
        :type Timeout: int
        :param _Host: Api所在服务host
注意：此字段可能返回 null，表示取不到有效值。
        :type Host: str
        :param _ApiType: API类型。 ms ： 微服务API； external :外部服务Api
注意：此字段可能返回 null，表示取不到有效值。
        :type ApiType: str
        :param _Description: Api描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _ApiMatchType: API路径匹配类型。normal：普通API；wildcard：通配API。
注意：此字段可能返回 null，表示取不到有效值。
        :type ApiMatchType: str
        :param _RpcExt: RPC 额外信息
注意：此字段可能返回 null，表示取不到有效值。
        :type RpcExt: str
        :param _GatewayDeployGroupId: 部署组id
注意：此字段可能返回 null，表示取不到有效值。
        :type GatewayDeployGroupId: str
        :param _Md5: md5
注意：此字段可能返回 null，表示取不到有效值。
        :type Md5: str
        :param _RpcType: RPC 类型
注意：此字段可能返回 null，表示取不到有效值。
        :type RpcType: str
        """
        self._ApiId = None
        self._NamespaceId = None
        self._NamespaceName = None
        self._MicroserviceId = None
        self._MicroserviceName = None
        self._Path = None
        self._PathMapping = None
        self._Method = None
        self._GroupId = None
        self._UsableStatus = None
        self._ReleaseStatus = None
        self._RateLimitStatus = None
        self._MockStatus = None
        self._CreatedTime = None
        self._UpdatedTime = None
        self._ReleasedTime = None
        self._GroupName = None
        self._Timeout = None
        self._Host = None
        self._ApiType = None
        self._Description = None
        self._ApiMatchType = None
        self._RpcExt = None
        self._GatewayDeployGroupId = None
        self._Md5 = None
        self._RpcType = None

    @property
    def ApiId(self):
        """API ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApiId

    @ApiId.setter
    def ApiId(self, ApiId):
        self._ApiId = ApiId

    @property
    def NamespaceId(self):
        """命名空间ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def NamespaceName(self):
        """命名空间名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def MicroserviceId(self):
        """服务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MicroserviceId

    @MicroserviceId.setter
    def MicroserviceId(self, MicroserviceId):
        self._MicroserviceId = MicroserviceId

    @property
    def MicroserviceName(self):
        """服务名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MicroserviceName

    @MicroserviceName.setter
    def MicroserviceName(self, MicroserviceName):
        self._MicroserviceName = MicroserviceName

    @property
    def Path(self):
        """API 请求路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def PathMapping(self):
        """Api 映射路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PathMapping

    @PathMapping.setter
    def PathMapping(self, PathMapping):
        self._PathMapping = PathMapping

    @property
    def Method(self):
        """请求方法
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Method

    @Method.setter
    def Method(self, Method):
        self._Method = Method

    @property
    def GroupId(self):
        """所属分组ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def UsableStatus(self):
        """是否禁用
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UsableStatus

    @UsableStatus.setter
    def UsableStatus(self, UsableStatus):
        self._UsableStatus = UsableStatus

    @property
    def ReleaseStatus(self):
        """发布状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReleaseStatus

    @ReleaseStatus.setter
    def ReleaseStatus(self, ReleaseStatus):
        self._ReleaseStatus = ReleaseStatus

    @property
    def RateLimitStatus(self):
        """开启限流
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RateLimitStatus

    @RateLimitStatus.setter
    def RateLimitStatus(self, RateLimitStatus):
        self._RateLimitStatus = RateLimitStatus

    @property
    def MockStatus(self):
        """是否开启mock
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MockStatus

    @MockStatus.setter
    def MockStatus(self, MockStatus):
        self._MockStatus = MockStatus

    @property
    def CreatedTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def UpdatedTime(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdatedTime

    @UpdatedTime.setter
    def UpdatedTime(self, UpdatedTime):
        self._UpdatedTime = UpdatedTime

    @property
    def ReleasedTime(self):
        """发布时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReleasedTime

    @ReleasedTime.setter
    def ReleasedTime(self, ReleasedTime):
        self._ReleasedTime = ReleasedTime

    @property
    def GroupName(self):
        """所属分组名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Timeout(self):
        """API 超时，单位毫秒
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Timeout

    @Timeout.setter
    def Timeout(self, Timeout):
        self._Timeout = Timeout

    @property
    def Host(self):
        """Api所在服务host
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def ApiType(self):
        """API类型。 ms ： 微服务API； external :外部服务Api
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApiType

    @ApiType.setter
    def ApiType(self, ApiType):
        self._ApiType = ApiType

    @property
    def Description(self):
        """Api描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ApiMatchType(self):
        """API路径匹配类型。normal：普通API；wildcard：通配API。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApiMatchType

    @ApiMatchType.setter
    def ApiMatchType(self, ApiMatchType):
        self._ApiMatchType = ApiMatchType

    @property
    def RpcExt(self):
        """RPC 额外信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RpcExt

    @RpcExt.setter
    def RpcExt(self, RpcExt):
        self._RpcExt = RpcExt

    @property
    def GatewayDeployGroupId(self):
        """部署组id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GatewayDeployGroupId

    @GatewayDeployGroupId.setter
    def GatewayDeployGroupId(self, GatewayDeployGroupId):
        self._GatewayDeployGroupId = GatewayDeployGroupId

    @property
    def Md5(self):
        """md5
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def RpcType(self):
        """RPC 类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RpcType

    @RpcType.setter
    def RpcType(self, RpcType):
        self._RpcType = RpcType


    def _deserialize(self, params):
        self._ApiId = params.get("ApiId")
        self._NamespaceId = params.get("NamespaceId")
        self._NamespaceName = params.get("NamespaceName")
        self._MicroserviceId = params.get("MicroserviceId")
        self._MicroserviceName = params.get("MicroserviceName")
        self._Path = params.get("Path")
        self._PathMapping = params.get("PathMapping")
        self._Method = params.get("Method")
        self._GroupId = params.get("GroupId")
        self._UsableStatus = params.get("UsableStatus")
        self._ReleaseStatus = params.get("ReleaseStatus")
        self._RateLimitStatus = params.get("RateLimitStatus")
        self._MockStatus = params.get("MockStatus")
        self._CreatedTime = params.get("CreatedTime")
        self._UpdatedTime = params.get("UpdatedTime")
        self._ReleasedTime = params.get("ReleasedTime")
        self._GroupName = params.get("GroupName")
        self._Timeout = params.get("Timeout")
        self._Host = params.get("Host")
        self._ApiType = params.get("ApiType")
        self._Description = params.get("Description")
        self._ApiMatchType = params.get("ApiMatchType")
        self._RpcExt = params.get("RpcExt")
        self._GatewayDeployGroupId = params.get("GatewayDeployGroupId")
        self._Md5 = params.get("Md5")
        self._RpcType = params.get("RpcType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiDetailResponse(AbstractModel):
    """ApiDetailResponse描述

    """

    def __init__(self):
        r"""
        :param _Request: API 请求参数
        :type Request: list of ApiRequestDescr
        :param _Response: API 响应参数
注意：此字段可能返回 null，表示取不到有效值。
        :type Response: list of ApiResponseDescr
        :param _Definitions: API 复杂结构定义
        :type Definitions: list of ApiDefinitionDescr
        :param _RequestContentType: API 的 content type
注意：此字段可能返回 null，表示取不到有效值。
        :type RequestContentType: str
        :param _CanRun: API  能否调试
        :type CanRun: bool
        :param _Status: API 状态 0:离线 1:在线，默认0
        :type Status: int
        :param _Description: API 描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        """
        self._Request = None
        self._Response = None
        self._Definitions = None
        self._RequestContentType = None
        self._CanRun = None
        self._Status = None
        self._Description = None

    @property
    def Request(self):
        """API 请求参数
        :rtype: list of ApiRequestDescr
        """
        return self._Request

    @Request.setter
    def Request(self, Request):
        self._Request = Request

    @property
    def Response(self):
        """API 响应参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ApiResponseDescr
        """
        return self._Response

    @Response.setter
    def Response(self, Response):
        self._Response = Response

    @property
    def Definitions(self):
        """API 复杂结构定义
        :rtype: list of ApiDefinitionDescr
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def RequestContentType(self):
        """API 的 content type
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RequestContentType

    @RequestContentType.setter
    def RequestContentType(self, RequestContentType):
        self._RequestContentType = RequestContentType

    @property
    def CanRun(self):
        """API  能否调试
        :rtype: bool
        """
        return self._CanRun

    @CanRun.setter
    def CanRun(self, CanRun):
        self._CanRun = CanRun

    @property
    def Status(self):
        """API 状态 0:离线 1:在线，默认0
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Description(self):
        """API 描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        if params.get("Request") is not None:
            self._Request = []
            for item in params.get("Request"):
                obj = ApiRequestDescr()
                obj._deserialize(item)
                self._Request.append(obj)
        if params.get("Response") is not None:
            self._Response = []
            for item in params.get("Response"):
                obj = ApiResponseDescr()
                obj._deserialize(item)
                self._Response.append(obj)
        if params.get("Definitions") is not None:
            self._Definitions = []
            for item in params.get("Definitions"):
                obj = ApiDefinitionDescr()
                obj._deserialize(item)
                self._Definitions.append(obj)
        self._RequestContentType = params.get("RequestContentType")
        self._CanRun = params.get("CanRun")
        self._Status = params.get("Status")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiGroupInfo(AbstractModel):
    """API分组信息

    """

    def __init__(self):
        r"""
        :param _GroupId: Api Group Id
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupId: str
        :param _GroupName: Api Group 名称
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupName: str
        :param _GroupContext: 分组上下文
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupContext: str
        :param _AuthType: 鉴权类型。 secret： 密钥鉴权； none:无鉴权
注意：此字段可能返回 null，表示取不到有效值。
        :type AuthType: str
        :param _Status: 发布状态, drafted: 未发布。 released: 发布
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _CreatedTime: 分组创建时间 如:2019-06-20 15:51:28
注意：此字段可能返回 null，表示取不到有效值。
        :type CreatedTime: str
        :param _UpdatedTime: 分组更新时间 如:2019-06-20 15:51:28
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdatedTime: str
        :param _BindedGatewayDeployGroups: api分组已绑定的网关部署组
注意：此字段可能返回 null，表示取不到有效值。
        :type BindedGatewayDeployGroups: list of GatewayDeployGroup
        :param _ApiCount: api 个数
注意：此字段可能返回 null，表示取不到有效值。
        :type ApiCount: int
        :param _AclMode: 访问group的ACL类型
注意：此字段可能返回 null，表示取不到有效值。
        :type AclMode: str
        :param _Description: 描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _GroupType: 分组类型。 ms： 微服务分组； external:外部Api分组
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupType: str
        :param _GatewayInstanceType: 网关实例的类型
注意：此字段可能返回 null，表示取不到有效值。
        :type GatewayInstanceType: str
        :param _GatewayInstanceId: 网关实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type GatewayInstanceId: str
        :param _NamespaceNameKey: 命名空间参数key值
注意：此字段可能返回 null，表示取不到有效值。
        :type NamespaceNameKey: str
        :param _ServiceNameKey: 微服务名参数key值
注意：此字段可能返回 null，表示取不到有效值。
        :type ServiceNameKey: str
        :param _NamespaceNameKeyPosition: 命名空间参数位置，path，header或query，默认是path
注意：此字段可能返回 null，表示取不到有效值。
        :type NamespaceNameKeyPosition: str
        :param _ServiceNameKeyPosition: 微服务名参数位置，path，header或query，默认是path
注意：此字段可能返回 null，表示取不到有效值。
        :type ServiceNameKeyPosition: str
        :param _GatewayInstanceIdList: 网关实例ID列表
注意：此字段可能返回 null，表示取不到有效值。
        :type GatewayInstanceIdList: list of str
        """
        self._GroupId = None
        self._GroupName = None
        self._GroupContext = None
        self._AuthType = None
        self._Status = None
        self._CreatedTime = None
        self._UpdatedTime = None
        self._BindedGatewayDeployGroups = None
        self._ApiCount = None
        self._AclMode = None
        self._Description = None
        self._GroupType = None
        self._GatewayInstanceType = None
        self._GatewayInstanceId = None
        self._NamespaceNameKey = None
        self._ServiceNameKey = None
        self._NamespaceNameKeyPosition = None
        self._ServiceNameKeyPosition = None
        self._GatewayInstanceIdList = None

    @property
    def GroupId(self):
        """Api Group Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupName(self):
        """Api Group 名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def GroupContext(self):
        """分组上下文
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupContext

    @GroupContext.setter
    def GroupContext(self, GroupContext):
        self._GroupContext = GroupContext

    @property
    def AuthType(self):
        """鉴权类型。 secret： 密钥鉴权； none:无鉴权
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AuthType

    @AuthType.setter
    def AuthType(self, AuthType):
        self._AuthType = AuthType

    @property
    def Status(self):
        """发布状态, drafted: 未发布。 released: 发布
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreatedTime(self):
        """分组创建时间 如:2019-06-20 15:51:28
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def UpdatedTime(self):
        """分组更新时间 如:2019-06-20 15:51:28
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdatedTime

    @UpdatedTime.setter
    def UpdatedTime(self, UpdatedTime):
        self._UpdatedTime = UpdatedTime

    @property
    def BindedGatewayDeployGroups(self):
        """api分组已绑定的网关部署组
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of GatewayDeployGroup
        """
        return self._BindedGatewayDeployGroups

    @BindedGatewayDeployGroups.setter
    def BindedGatewayDeployGroups(self, BindedGatewayDeployGroups):
        self._BindedGatewayDeployGroups = BindedGatewayDeployGroups

    @property
    def ApiCount(self):
        """api 个数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ApiCount

    @ApiCount.setter
    def ApiCount(self, ApiCount):
        self._ApiCount = ApiCount

    @property
    def AclMode(self):
        """访问group的ACL类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AclMode

    @AclMode.setter
    def AclMode(self, AclMode):
        self._AclMode = AclMode

    @property
    def Description(self):
        """描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def GroupType(self):
        """分组类型。 ms： 微服务分组； external:外部Api分组
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupType

    @GroupType.setter
    def GroupType(self, GroupType):
        self._GroupType = GroupType

    @property
    def GatewayInstanceType(self):
        """网关实例的类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GatewayInstanceType

    @GatewayInstanceType.setter
    def GatewayInstanceType(self, GatewayInstanceType):
        self._GatewayInstanceType = GatewayInstanceType

    @property
    def GatewayInstanceId(self):
        """网关实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GatewayInstanceId

    @GatewayInstanceId.setter
    def GatewayInstanceId(self, GatewayInstanceId):
        self._GatewayInstanceId = GatewayInstanceId

    @property
    def NamespaceNameKey(self):
        """命名空间参数key值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NamespaceNameKey

    @NamespaceNameKey.setter
    def NamespaceNameKey(self, NamespaceNameKey):
        self._NamespaceNameKey = NamespaceNameKey

    @property
    def ServiceNameKey(self):
        """微服务名参数key值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ServiceNameKey

    @ServiceNameKey.setter
    def ServiceNameKey(self, ServiceNameKey):
        self._ServiceNameKey = ServiceNameKey

    @property
    def NamespaceNameKeyPosition(self):
        """命名空间参数位置，path，header或query，默认是path
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NamespaceNameKeyPosition

    @NamespaceNameKeyPosition.setter
    def NamespaceNameKeyPosition(self, NamespaceNameKeyPosition):
        self._NamespaceNameKeyPosition = NamespaceNameKeyPosition

    @property
    def ServiceNameKeyPosition(self):
        """微服务名参数位置，path，header或query，默认是path
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ServiceNameKeyPosition

    @ServiceNameKeyPosition.setter
    def ServiceNameKeyPosition(self, ServiceNameKeyPosition):
        self._ServiceNameKeyPosition = ServiceNameKeyPosition

    @property
    def GatewayInstanceIdList(self):
        """网关实例ID列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._GatewayInstanceIdList

    @GatewayInstanceIdList.setter
    def GatewayInstanceIdList(self, GatewayInstanceIdList):
        self._GatewayInstanceIdList = GatewayInstanceIdList


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._GroupName = params.get("GroupName")
        self._GroupContext = params.get("GroupContext")
        self._AuthType = params.get("AuthType")
        self._Status = params.get("Status")
        self._CreatedTime = params.get("CreatedTime")
        self._UpdatedTime = params.get("UpdatedTime")
        if params.get("BindedGatewayDeployGroups") is not None:
            self._BindedGatewayDeployGroups = []
            for item in params.get("BindedGatewayDeployGroups"):
                obj = GatewayDeployGroup()
                obj._deserialize(item)
                self._BindedGatewayDeployGroups.append(obj)
        self._ApiCount = params.get("ApiCount")
        self._AclMode = params.get("AclMode")
        self._Description = params.get("Description")
        self._GroupType = params.get("GroupType")
        self._GatewayInstanceType = params.get("GatewayInstanceType")
        self._GatewayInstanceId = params.get("GatewayInstanceId")
        self._NamespaceNameKey = params.get("NamespaceNameKey")
        self._ServiceNameKey = params.get("ServiceNameKey")
        self._NamespaceNameKeyPosition = params.get("NamespaceNameKeyPosition")
        self._ServiceNameKeyPosition = params.get("ServiceNameKeyPosition")
        self._GatewayInstanceIdList = params.get("GatewayInstanceIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiInfo(AbstractModel):
    """微服务网关API信息

    """

    def __init__(self):
        r"""
        :param _NamespaceId: 命名空间Id，若为外部API,为固定值："namespace-external"
        :type NamespaceId: str
        :param _MicroserviceId: 服务Id，若为外部API,为固定值："ms-external"
        :type MicroserviceId: str
        :param _Path: API path
        :type Path: str
        :param _Method: Api 请求
        :type Method: str
        :param _PathMapping: 请求映射
        :type PathMapping: str
        :param _Host: api所在服务host,限定外部Api填写。格式: `http://127.0.0.1:8080`
        :type Host: str
        :param _Description: api描述信息
        :type Description: str
        """
        self._NamespaceId = None
        self._MicroserviceId = None
        self._Path = None
        self._Method = None
        self._PathMapping = None
        self._Host = None
        self._Description = None

    @property
    def NamespaceId(self):
        """命名空间Id，若为外部API,为固定值："namespace-external"
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def MicroserviceId(self):
        """服务Id，若为外部API,为固定值："ms-external"
        :rtype: str
        """
        return self._MicroserviceId

    @MicroserviceId.setter
    def MicroserviceId(self, MicroserviceId):
        self._MicroserviceId = MicroserviceId

    @property
    def Path(self):
        """API path
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Method(self):
        """Api 请求
        :rtype: str
        """
        return self._Method

    @Method.setter
    def Method(self, Method):
        self._Method = Method

    @property
    def PathMapping(self):
        """请求映射
        :rtype: str
        """
        return self._PathMapping

    @PathMapping.setter
    def PathMapping(self, PathMapping):
        self._PathMapping = PathMapping

    @property
    def Host(self):
        """api所在服务host,限定外部Api填写。格式: `http://127.0.0.1:8080`
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def Description(self):
        """api描述信息
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._NamespaceId = params.get("NamespaceId")
        self._MicroserviceId = params.get("MicroserviceId")
        self._Path = params.get("Path")
        self._Method = params.get("Method")
        self._PathMapping = params.get("PathMapping")
        self._Host = params.get("Host")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiRateLimitRule(AbstractModel):
    """微服务网关API限流规则

    """

    def __init__(self):
        r"""
        :param _RuleId: rule Id
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleId: str
        :param _ApiId: API ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ApiId: str
        :param _RuleName: 限流名称
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleName: str
        :param _MaxQps: 最大限流qps
注意：此字段可能返回 null，表示取不到有效值。
        :type MaxQps: int
        :param _UsableStatus: 生效/禁用, enabled/disabled
注意：此字段可能返回 null，表示取不到有效值。
        :type UsableStatus: str
        :param _RuleContent: 规则内容
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleContent: str
        :param _TsfRuleId: Tsf Rule ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TsfRuleId: str
        :param _Description: 描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _CreatedTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreatedTime: str
        :param _UpdatedTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdatedTime: str
        :param _Limit: 分页参数limit
注意：此字段可能返回 null，表示取不到有效值。
        :type Limit: int
        :param _Offset: 分页参数offset
注意：此字段可能返回 null，表示取不到有效值。
        :type Offset: int
        :param _AppId: AppId
注意：此字段可能返回 null，表示取不到有效值。
        :type AppId: str
        """
        self._RuleId = None
        self._ApiId = None
        self._RuleName = None
        self._MaxQps = None
        self._UsableStatus = None
        self._RuleContent = None
        self._TsfRuleId = None
        self._Description = None
        self._CreatedTime = None
        self._UpdatedTime = None
        self._Limit = None
        self._Offset = None
        self._AppId = None

    @property
    def RuleId(self):
        """rule Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ApiId(self):
        """API ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApiId

    @ApiId.setter
    def ApiId(self, ApiId):
        self._ApiId = ApiId

    @property
    def RuleName(self):
        """限流名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def MaxQps(self):
        """最大限流qps
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._MaxQps

    @MaxQps.setter
    def MaxQps(self, MaxQps):
        self._MaxQps = MaxQps

    @property
    def UsableStatus(self):
        """生效/禁用, enabled/disabled
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UsableStatus

    @UsableStatus.setter
    def UsableStatus(self, UsableStatus):
        self._UsableStatus = UsableStatus

    @property
    def RuleContent(self):
        """规则内容
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RuleContent

    @RuleContent.setter
    def RuleContent(self, RuleContent):
        self._RuleContent = RuleContent

    @property
    def TsfRuleId(self):
        """Tsf Rule ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TsfRuleId

    @TsfRuleId.setter
    def TsfRuleId(self, TsfRuleId):
        self._TsfRuleId = TsfRuleId

    @property
    def Description(self):
        """描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreatedTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def UpdatedTime(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdatedTime

    @UpdatedTime.setter
    def UpdatedTime(self, UpdatedTime):
        self._UpdatedTime = UpdatedTime

    @property
    def Limit(self):
        """分页参数limit
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """分页参数offset
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def AppId(self):
        """AppId
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ApiId = params.get("ApiId")
        self._RuleName = params.get("RuleName")
        self._MaxQps = params.get("MaxQps")
        self._UsableStatus = params.get("UsableStatus")
        self._RuleContent = params.get("RuleContent")
        self._TsfRuleId = params.get("TsfRuleId")
        self._Description = params.get("Description")
        self._CreatedTime = params.get("CreatedTime")
        self._UpdatedTime = params.get("UpdatedTime")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._AppId = params.get("AppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiRequestDescr(AbstractModel):
    """ApiRequestDescr

    """

    def __init__(self):
        r"""
        :param _Name: 参数名称
        :type Name: str
        :param _Type: 参数类型
        :type Type: str
        :param _In: 参数位置
        :type In: str
        :param _Description: 参数描述
        :type Description: str
        :param _Required: 参数是否必须
        :type Required: bool
        :param _DefaultValue: 参数的默认值
注意：此字段可能返回 null，表示取不到有效值。
        :type DefaultValue: str
        """
        self._Name = None
        self._Type = None
        self._In = None
        self._Description = None
        self._Required = None
        self._DefaultValue = None

    @property
    def Name(self):
        """参数名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        """参数类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def In(self):
        """参数位置
        :rtype: str
        """
        return self._In

    @In.setter
    def In(self, In):
        self._In = In

    @property
    def Description(self):
        """参数描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Required(self):
        """参数是否必须
        :rtype: bool
        """
        return self._Required

    @Required.setter
    def Required(self, Required):
        self._Required = Required

    @property
    def DefaultValue(self):
        """参数的默认值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DefaultValue

    @DefaultValue.setter
    def DefaultValue(self, DefaultValue):
        self._DefaultValue = DefaultValue


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._In = params.get("In")
        self._Description = params.get("Description")
        self._Required = params.get("Required")
        self._DefaultValue = params.get("DefaultValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiResponseDescr(AbstractModel):
    """API 响应的参数结构描述

    """

    def __init__(self):
        r"""
        :param _Name: 参数描述
        :type Name: str
        :param _Type: 参数类型
        :type Type: str
        :param _Description: 参数描述
        :type Description: str
        """
        self._Name = None
        self._Type = None
        self._Description = None

    @property
    def Name(self):
        """参数描述
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        """参数类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Description(self):
        """参数描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiUseStatisticsEntity(AbstractModel):
    """API 日统计数据点

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _Count: 次数
        :type Count: str
        :param _Ratio: 比率
        :type Ratio: str
        """
        self._Name = None
        self._Count = None
        self._Ratio = None

    @property
    def Name(self):
        """名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Count(self):
        """次数
        :rtype: str
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Ratio(self):
        """比率
        :rtype: str
        """
        return self._Ratio

    @Ratio.setter
    def Ratio(self, Ratio):
        self._Ratio = Ratio


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Count = params.get("Count")
        self._Ratio = params.get("Ratio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApiVersionArray(AbstractModel):
    """API版本数组

    """

    def __init__(self):
        r"""
        :param _ApplicationId: App ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationId: str
        :param _ApplicationName: App 名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationName: str
        :param _PkgVersion: App 包版本
注意：此字段可能返回 null，表示取不到有效值。
        :type PkgVersion: str
        """
        self._ApplicationId = None
        self._ApplicationName = None
        self._PkgVersion = None

    @property
    def ApplicationId(self):
        """App ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        """App 名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def PkgVersion(self):
        """App 包版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PkgVersion

    @PkgVersion.setter
    def PkgVersion(self, PkgVersion):
        self._PkgVersion = PkgVersion


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._PkgVersion = params.get("PkgVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplicationAttribute(AbstractModel):
    """应用列表其它字段

    """

    def __init__(self):
        r"""
        :param _InstanceCount: 总实例个数
        :type InstanceCount: int
        :param _RunInstanceCount: 运行实例个数
        :type RunInstanceCount: int
        :param _GroupCount: 应用下部署组个数
        :type GroupCount: int
        :param _RunningGroupCount: 运行中部署组个数
        :type RunningGroupCount: str
        :param _AbnormalCount: 异常部署组个数
        :type AbnormalCount: str
        """
        self._InstanceCount = None
        self._RunInstanceCount = None
        self._GroupCount = None
        self._RunningGroupCount = None
        self._AbnormalCount = None

    @property
    def InstanceCount(self):
        """总实例个数
        :rtype: int
        """
        return self._InstanceCount

    @InstanceCount.setter
    def InstanceCount(self, InstanceCount):
        self._InstanceCount = InstanceCount

    @property
    def RunInstanceCount(self):
        """运行实例个数
        :rtype: int
        """
        return self._RunInstanceCount

    @RunInstanceCount.setter
    def RunInstanceCount(self, RunInstanceCount):
        self._RunInstanceCount = RunInstanceCount

    @property
    def GroupCount(self):
        """应用下部署组个数
        :rtype: int
        """
        return self._GroupCount

    @GroupCount.setter
    def GroupCount(self, GroupCount):
        self._GroupCount = GroupCount

    @property
    def RunningGroupCount(self):
        """运行中部署组个数
        :rtype: str
        """
        return self._RunningGroupCount

    @RunningGroupCount.setter
    def RunningGroupCount(self, RunningGroupCount):
        self._RunningGroupCount = RunningGroupCount

    @property
    def AbnormalCount(self):
        """异常部署组个数
        :rtype: str
        """
        return self._AbnormalCount

    @AbnormalCount.setter
    def AbnormalCount(self, AbnormalCount):
        self._AbnormalCount = AbnormalCount


    def _deserialize(self, params):
        self._InstanceCount = params.get("InstanceCount")
        self._RunInstanceCount = params.get("RunInstanceCount")
        self._GroupCount = params.get("GroupCount")
        self._RunningGroupCount = params.get("RunningGroupCount")
        self._AbnormalCount = params.get("AbnormalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplicationForPage(AbstractModel):
    """分页的应用描述信息字段

    """

    def __init__(self):
        r"""
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        :param _ApplicationName: 应用名称
        :type ApplicationName: str
        :param _ApplicationDesc: 应用描述
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationDesc: str
        :param _ApplicationType: 应用类型
        :type ApplicationType: str
        :param _MicroserviceType: 微服务类型
        :type MicroserviceType: str
        :param _ProgLang: 编程语言
        :type ProgLang: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        :param _ApplicationResourceType: 应用资源类型
        :type ApplicationResourceType: str
        :param _ApplicationRuntimeType: 应用runtime类型
        :type ApplicationRuntimeType: str
        :param _ApigatewayServiceId: Apigateway的serviceId
        :type ApigatewayServiceId: str
        :param _ApplicationRemarkName: 应用备注名
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationRemarkName: str
        :param _ServiceConfigList: 服务配置信息列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ServiceConfigList: list of ServiceConfig
        :param _IgnoreCreateImageRepository: IgnoreCreateImageRepository
        :type IgnoreCreateImageRepository: bool
        :param _ApmInstanceId: Apm业务系统id
注意：此字段可能返回 null，表示取不到有效值。
        :type ApmInstanceId: str
        :param _ApmInstanceName: Apm业务系统Name
注意：此字段可能返回 null，表示取不到有效值。
        :type ApmInstanceName: str
        :param _SyncDeleteImageRepository: 同步删除镜像仓库
注意：此字段可能返回 null，表示取不到有效值。
        :type SyncDeleteImageRepository: bool
        :param _MicroserviceSubType: 应用微服务子类型
注意：此字段可能返回 null，表示取不到有效值。
        :type MicroserviceSubType: str
        :param _ProgramLanguage: 应用编程语言类型
        :type ProgramLanguage: str
        :param _FrameworkType: 开发框架类型[SpringCloud，Dubbo，Go-GRPC，Other]
        :type FrameworkType: str
        :param _ServiceGovernanceConfig: 注册配置治理信息
        :type ServiceGovernanceConfig: :class:`tencentcloud.tsf.v20180326.models.ServiceGovernanceConfig`
        :param _MicroserviceTypeList: 微服务类型列表
注意：此字段可能返回 null，表示取不到有效值。
        :type MicroserviceTypeList: list of str
        :param _CreateSameNameImageRepository: 是否同时创建镜像仓库
        :type CreateSameNameImageRepository: bool
        """
        self._ApplicationId = None
        self._ApplicationName = None
        self._ApplicationDesc = None
        self._ApplicationType = None
        self._MicroserviceType = None
        self._ProgLang = None
        self._CreateTime = None
        self._UpdateTime = None
        self._ApplicationResourceType = None
        self._ApplicationRuntimeType = None
        self._ApigatewayServiceId = None
        self._ApplicationRemarkName = None
        self._ServiceConfigList = None
        self._IgnoreCreateImageRepository = None
        self._ApmInstanceId = None
        self._ApmInstanceName = None
        self._SyncDeleteImageRepository = None
        self._MicroserviceSubType = None
        self._ProgramLanguage = None
        self._FrameworkType = None
        self._ServiceGovernanceConfig = None
        self._MicroserviceTypeList = None
        self._CreateSameNameImageRepository = None

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        """应用名称
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationDesc(self):
        """应用描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationDesc

    @ApplicationDesc.setter
    def ApplicationDesc(self, ApplicationDesc):
        self._ApplicationDesc = ApplicationDesc

    @property
    def ApplicationType(self):
        """应用类型
        :rtype: str
        """
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType

    @property
    def MicroserviceType(self):
        """微服务类型
        :rtype: str
        """
        return self._MicroserviceType

    @MicroserviceType.setter
    def MicroserviceType(self, MicroserviceType):
        self._MicroserviceType = MicroserviceType

    @property
    def ProgLang(self):
        """编程语言
        :rtype: str
        """
        return self._ProgLang

    @ProgLang.setter
    def ProgLang(self, ProgLang):
        self._ProgLang = ProgLang

    @property
    def CreateTime(self):
        """创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """更新时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def ApplicationResourceType(self):
        """应用资源类型
        :rtype: str
        """
        return self._ApplicationResourceType

    @ApplicationResourceType.setter
    def ApplicationResourceType(self, ApplicationResourceType):
        self._ApplicationResourceType = ApplicationResourceType

    @property
    def ApplicationRuntimeType(self):
        """应用runtime类型
        :rtype: str
        """
        return self._ApplicationRuntimeType

    @ApplicationRuntimeType.setter
    def ApplicationRuntimeType(self, ApplicationRuntimeType):
        self._ApplicationRuntimeType = ApplicationRuntimeType

    @property
    def ApigatewayServiceId(self):
        """Apigateway的serviceId
        :rtype: str
        """
        return self._ApigatewayServiceId

    @ApigatewayServiceId.setter
    def ApigatewayServiceId(self, ApigatewayServiceId):
        self._ApigatewayServiceId = ApigatewayServiceId

    @property
    def ApplicationRemarkName(self):
        """应用备注名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationRemarkName

    @ApplicationRemarkName.setter
    def ApplicationRemarkName(self, ApplicationRemarkName):
        self._ApplicationRemarkName = ApplicationRemarkName

    @property
    def ServiceConfigList(self):
        """服务配置信息列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ServiceConfig
        """
        return self._ServiceConfigList

    @ServiceConfigList.setter
    def ServiceConfigList(self, ServiceConfigList):
        self._ServiceConfigList = ServiceConfigList

    @property
    def IgnoreCreateImageRepository(self):
        """IgnoreCreateImageRepository
        :rtype: bool
        """
        return self._IgnoreCreateImageRepository

    @IgnoreCreateImageRepository.setter
    def IgnoreCreateImageRepository(self, IgnoreCreateImageRepository):
        self._IgnoreCreateImageRepository = IgnoreCreateImageRepository

    @property
    def ApmInstanceId(self):
        """Apm业务系统id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApmInstanceId

    @ApmInstanceId.setter
    def ApmInstanceId(self, ApmInstanceId):
        self._ApmInstanceId = ApmInstanceId

    @property
    def ApmInstanceName(self):
        """Apm业务系统Name
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApmInstanceName

    @ApmInstanceName.setter
    def ApmInstanceName(self, ApmInstanceName):
        self._ApmInstanceName = ApmInstanceName

    @property
    def SyncDeleteImageRepository(self):
        """同步删除镜像仓库
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._SyncDeleteImageRepository

    @SyncDeleteImageRepository.setter
    def SyncDeleteImageRepository(self, SyncDeleteImageRepository):
        self._SyncDeleteImageRepository = SyncDeleteImageRepository

    @property
    def MicroserviceSubType(self):
        """应用微服务子类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MicroserviceSubType

    @MicroserviceSubType.setter
    def MicroserviceSubType(self, MicroserviceSubType):
        self._MicroserviceSubType = MicroserviceSubType

    @property
    def ProgramLanguage(self):
        """应用编程语言类型
        :rtype: str
        """
        return self._ProgramLanguage

    @ProgramLanguage.setter
    def ProgramLanguage(self, ProgramLanguage):
        self._ProgramLanguage = ProgramLanguage

    @property
    def FrameworkType(self):
        """开发框架类型[SpringCloud，Dubbo，Go-GRPC，Other]
        :rtype: str
        """
        return self._FrameworkType

    @FrameworkType.setter
    def FrameworkType(self, FrameworkType):
        self._FrameworkType = FrameworkType

    @property
    def ServiceGovernanceConfig(self):
        """注册配置治理信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ServiceGovernanceConfig`
        """
        return self._ServiceGovernanceConfig

    @ServiceGovernanceConfig.setter
    def ServiceGovernanceConfig(self, ServiceGovernanceConfig):
        self._ServiceGovernanceConfig = ServiceGovernanceConfig

    @property
    def MicroserviceTypeList(self):
        """微服务类型列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._MicroserviceTypeList

    @MicroserviceTypeList.setter
    def MicroserviceTypeList(self, MicroserviceTypeList):
        self._MicroserviceTypeList = MicroserviceTypeList

    @property
    def CreateSameNameImageRepository(self):
        """是否同时创建镜像仓库
        :rtype: bool
        """
        return self._CreateSameNameImageRepository

    @CreateSameNameImageRepository.setter
    def CreateSameNameImageRepository(self, CreateSameNameImageRepository):
        self._CreateSameNameImageRepository = CreateSameNameImageRepository


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._ApplicationDesc = params.get("ApplicationDesc")
        self._ApplicationType = params.get("ApplicationType")
        self._MicroserviceType = params.get("MicroserviceType")
        self._ProgLang = params.get("ProgLang")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._ApplicationResourceType = params.get("ApplicationResourceType")
        self._ApplicationRuntimeType = params.get("ApplicationRuntimeType")
        self._ApigatewayServiceId = params.get("ApigatewayServiceId")
        self._ApplicationRemarkName = params.get("ApplicationRemarkName")
        if params.get("ServiceConfigList") is not None:
            self._ServiceConfigList = []
            for item in params.get("ServiceConfigList"):
                obj = ServiceConfig()
                obj._deserialize(item)
                self._ServiceConfigList.append(obj)
        self._IgnoreCreateImageRepository = params.get("IgnoreCreateImageRepository")
        self._ApmInstanceId = params.get("ApmInstanceId")
        self._ApmInstanceName = params.get("ApmInstanceName")
        self._SyncDeleteImageRepository = params.get("SyncDeleteImageRepository")
        self._MicroserviceSubType = params.get("MicroserviceSubType")
        self._ProgramLanguage = params.get("ProgramLanguage")
        self._FrameworkType = params.get("FrameworkType")
        if params.get("ServiceGovernanceConfig") is not None:
            self._ServiceGovernanceConfig = ServiceGovernanceConfig()
            self._ServiceGovernanceConfig._deserialize(params.get("ServiceGovernanceConfig"))
        self._MicroserviceTypeList = params.get("MicroserviceTypeList")
        self._CreateSameNameImageRepository = params.get("CreateSameNameImageRepository")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateBusinessLogConfigRequest(AbstractModel):
    """AssociateBusinessLogConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: TSF分组ID
        :type GroupId: str
        :param _ConfigIdList: 日志配置项ID列表
        :type ConfigIdList: list of str
        """
        self._GroupId = None
        self._ConfigIdList = None

    @property
    def GroupId(self):
        """TSF分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def ConfigIdList(self):
        """日志配置项ID列表
        :rtype: list of str
        """
        return self._ConfigIdList

    @ConfigIdList.setter
    def ConfigIdList(self, ConfigIdList):
        self._ConfigIdList = ConfigIdList


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._ConfigIdList = params.get("ConfigIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateBusinessLogConfigResponse(AbstractModel):
    """AssociateBusinessLogConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 操作结果
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """操作结果
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class AssociateConfigWithGroupRequest(AbstractModel):
    """AssociateConfigWithGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置项id
        :type ConfigId: str
        :param _Groups: 部署组信息
        :type Groups: list of GroupInfo
        :param _SelectAll: 是否选择全部投递，1 表示全部，0或不填表示非全部
        :type SelectAll: int
        :param _NamespaceId: 命名空间id
        :type NamespaceId: str
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _SearchWord: 模糊搜索关键词
        :type SearchWord: str
        """
        self._ConfigId = None
        self._Groups = None
        self._SelectAll = None
        self._NamespaceId = None
        self._ClusterId = None
        self._SearchWord = None

    @property
    def ConfigId(self):
        """配置项id
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def Groups(self):
        """部署组信息
        :rtype: list of GroupInfo
        """
        return self._Groups

    @Groups.setter
    def Groups(self, Groups):
        self._Groups = Groups

    @property
    def SelectAll(self):
        """是否选择全部投递，1 表示全部，0或不填表示非全部
        :rtype: int
        """
        return self._SelectAll

    @SelectAll.setter
    def SelectAll(self, SelectAll):
        self._SelectAll = SelectAll

    @property
    def NamespaceId(self):
        """命名空间id
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def ClusterId(self):
        """集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def SearchWord(self):
        """模糊搜索关键词
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        if params.get("Groups") is not None:
            self._Groups = []
            for item in params.get("Groups"):
                obj = GroupInfo()
                obj._deserialize(item)
                self._Groups.append(obj)
        self._SelectAll = params.get("SelectAll")
        self._NamespaceId = params.get("NamespaceId")
        self._ClusterId = params.get("ClusterId")
        self._SearchWord = params.get("SearchWord")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateConfigWithGroupResponse(AbstractModel):
    """AssociateConfigWithGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 绑定是否成功
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """绑定是否成功
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class AvailableZoneScatterScheduleRule(AbstractModel):
    """打散调度规则

    """

    def __init__(self):
        r"""
        :param _ScatterDimension: -
        :type ScatterDimension: str
        :param _MaxUnbalanceQuantity: -
        :type MaxUnbalanceQuantity: int
        :param _IsForceSchedule: -
        :type IsForceSchedule: bool
        :param _Paths: -
        :type Paths: list of CommonOption
        """
        self._ScatterDimension = None
        self._MaxUnbalanceQuantity = None
        self._IsForceSchedule = None
        self._Paths = None

    @property
    def ScatterDimension(self):
        """-
        :rtype: str
        """
        return self._ScatterDimension

    @ScatterDimension.setter
    def ScatterDimension(self, ScatterDimension):
        self._ScatterDimension = ScatterDimension

    @property
    def MaxUnbalanceQuantity(self):
        """-
        :rtype: int
        """
        return self._MaxUnbalanceQuantity

    @MaxUnbalanceQuantity.setter
    def MaxUnbalanceQuantity(self, MaxUnbalanceQuantity):
        self._MaxUnbalanceQuantity = MaxUnbalanceQuantity

    @property
    def IsForceSchedule(self):
        """-
        :rtype: bool
        """
        return self._IsForceSchedule

    @IsForceSchedule.setter
    def IsForceSchedule(self, IsForceSchedule):
        self._IsForceSchedule = IsForceSchedule

    @property
    def Paths(self):
        """-
        :rtype: list of CommonOption
        """
        return self._Paths

    @Paths.setter
    def Paths(self, Paths):
        self._Paths = Paths


    def _deserialize(self, params):
        self._ScatterDimension = params.get("ScatterDimension")
        self._MaxUnbalanceQuantity = params.get("MaxUnbalanceQuantity")
        self._IsForceSchedule = params.get("IsForceSchedule")
        if params.get("Paths") is not None:
            self._Paths = []
            for item in params.get("Paths"):
                obj = CommonOption()
                obj._deserialize(item)
                self._Paths.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindApiGroupRequest(AbstractModel):
    """BindApiGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupGatewayList: 分组绑定网关列表
        :type GroupGatewayList: list of GatewayGroupIds
        """
        self._GroupGatewayList = None

    @property
    def GroupGatewayList(self):
        """分组绑定网关列表
        :rtype: list of GatewayGroupIds
        """
        return self._GroupGatewayList

    @GroupGatewayList.setter
    def GroupGatewayList(self, GroupGatewayList):
        self._GroupGatewayList = GroupGatewayList


    def _deserialize(self, params):
        if params.get("GroupGatewayList") is not None:
            self._GroupGatewayList = []
            for item in params.get("GroupGatewayList"):
                obj = GatewayGroupIds()
                obj._deserialize(item)
                self._GroupGatewayList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindApiGroupResponse(AbstractModel):
    """BindApiGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 返回结果，成功失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """返回结果，成功失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class BindPluginRequest(AbstractModel):
    """BindPlugin请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PluginInstanceList: 分组/API绑定插件列表
        :type PluginInstanceList: list of GatewayPluginBoundParam
        """
        self._PluginInstanceList = None

    @property
    def PluginInstanceList(self):
        """分组/API绑定插件列表
        :rtype: list of GatewayPluginBoundParam
        """
        return self._PluginInstanceList

    @PluginInstanceList.setter
    def PluginInstanceList(self, PluginInstanceList):
        self._PluginInstanceList = PluginInstanceList


    def _deserialize(self, params):
        if params.get("PluginInstanceList") is not None:
            self._PluginInstanceList = []
            for item in params.get("PluginInstanceList"):
                obj = GatewayPluginBoundParam()
                obj._deserialize(item)
                self._PluginInstanceList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindPluginResponse(AbstractModel):
    """BindPlugin返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 返回结果，成功：true，失败：false。
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """返回结果，成功：true，失败：false。
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class BusinesLogConfigAssociatedGroup(AbstractModel):
    """业务日志配置关联部署组信息

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupId: str
        :param _GroupName: 部署组名称
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupName: str
        :param _ApplicationId: 部署组所属应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationId: str
        :param _ApplicationName: 部署组所属应用名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationName: str
        :param _ApplicationType: 部署组所属应用类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationType: str
        :param _NamespaceId: 部署组所属命名空间ID
注意：此字段可能返回 null，表示取不到有效值。
        :type NamespaceId: str
        :param _NamespaceName: 部署组所属命名空间名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NamespaceName: str
        :param _ClusterId: 部署组所属集群ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterId: str
        :param _ClusterName: 部署组所属集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterName: str
        :param _ClusterType: 部署组所属集群类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterType: str
        :param _AssociatedTime: 部署组关联日志配置时间
注意：此字段可能返回 null，表示取不到有效值。
        :type AssociatedTime: str
        """
        self._GroupId = None
        self._GroupName = None
        self._ApplicationId = None
        self._ApplicationName = None
        self._ApplicationType = None
        self._NamespaceId = None
        self._NamespaceName = None
        self._ClusterId = None
        self._ClusterName = None
        self._ClusterType = None
        self._AssociatedTime = None

    @property
    def GroupId(self):
        """部署组ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupName(self):
        """部署组名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def ApplicationId(self):
        """部署组所属应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        """部署组所属应用名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationType(self):
        """部署组所属应用类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType

    @property
    def NamespaceId(self):
        """部署组所属命名空间ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def NamespaceName(self):
        """部署组所属命名空间名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def ClusterId(self):
        """部署组所属集群ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        """部署组所属集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterType(self):
        """部署组所属集群类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def AssociatedTime(self):
        """部署组关联日志配置时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AssociatedTime

    @AssociatedTime.setter
    def AssociatedTime(self, AssociatedTime):
        self._AssociatedTime = AssociatedTime


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._GroupName = params.get("GroupName")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._ApplicationType = params.get("ApplicationType")
        self._NamespaceId = params.get("NamespaceId")
        self._NamespaceName = params.get("NamespaceName")
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._ClusterType = params.get("ClusterType")
        self._AssociatedTime = params.get("AssociatedTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BusinessLogConfig(AbstractModel):
    """业务日志配置

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置项ID
        :type ConfigId: str
        :param _ConfigName: 配置项名称
        :type ConfigName: str
        :param _ConfigPath: 配置项日志路径
        :type ConfigPath: str
        :param _ConfigDesc: 配置项描述
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigDesc: str
        :param _ConfigTags: 配置项标签
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigTags: str
        :param _ConfigPipeline: 配置项对应的ES管道
        :type ConfigPipeline: str
        :param _ConfigCreateTime: 配置项创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigCreateTime: str
        :param _ConfigUpdateTime: 配置项更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigUpdateTime: str
        :param _ConfigSchema: 配置项解析规则
        :type ConfigSchema: :class:`tencentcloud.tsf.v20180326.models.BusinessLogConfigSchema`
        :param _ConfigAssociatedGroups: 配置项关联部署组
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigAssociatedGroups: list of BusinesLogConfigAssociatedGroup
        :param _ConfigAssociatedGroupList: 配置项关联部署组
        :type ConfigAssociatedGroupList: list of BusinessLogConfigAssociatedGroup
        :param _FilebeatConfigEnable: 是否开启filebeat高级配置开关
        :type FilebeatConfigEnable: bool
        :param _FilebeatCloseTimeout: close_timeout参数
        :type FilebeatCloseTimeout: int
        """
        self._ConfigId = None
        self._ConfigName = None
        self._ConfigPath = None
        self._ConfigDesc = None
        self._ConfigTags = None
        self._ConfigPipeline = None
        self._ConfigCreateTime = None
        self._ConfigUpdateTime = None
        self._ConfigSchema = None
        self._ConfigAssociatedGroups = None
        self._ConfigAssociatedGroupList = None
        self._FilebeatConfigEnable = None
        self._FilebeatCloseTimeout = None

    @property
    def ConfigId(self):
        """配置项ID
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def ConfigName(self):
        """配置项名称
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigPath(self):
        """配置项日志路径
        :rtype: str
        """
        return self._ConfigPath

    @ConfigPath.setter
    def ConfigPath(self, ConfigPath):
        self._ConfigPath = ConfigPath

    @property
    def ConfigDesc(self):
        """配置项描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigDesc

    @ConfigDesc.setter
    def ConfigDesc(self, ConfigDesc):
        self._ConfigDesc = ConfigDesc

    @property
    def ConfigTags(self):
        """配置项标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigTags

    @ConfigTags.setter
    def ConfigTags(self, ConfigTags):
        self._ConfigTags = ConfigTags

    @property
    def ConfigPipeline(self):
        """配置项对应的ES管道
        :rtype: str
        """
        return self._ConfigPipeline

    @ConfigPipeline.setter
    def ConfigPipeline(self, ConfigPipeline):
        self._ConfigPipeline = ConfigPipeline

    @property
    def ConfigCreateTime(self):
        """配置项创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigCreateTime

    @ConfigCreateTime.setter
    def ConfigCreateTime(self, ConfigCreateTime):
        self._ConfigCreateTime = ConfigCreateTime

    @property
    def ConfigUpdateTime(self):
        """配置项更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigUpdateTime

    @ConfigUpdateTime.setter
    def ConfigUpdateTime(self, ConfigUpdateTime):
        self._ConfigUpdateTime = ConfigUpdateTime

    @property
    def ConfigSchema(self):
        """配置项解析规则
        :rtype: :class:`tencentcloud.tsf.v20180326.models.BusinessLogConfigSchema`
        """
        return self._ConfigSchema

    @ConfigSchema.setter
    def ConfigSchema(self, ConfigSchema):
        self._ConfigSchema = ConfigSchema

    @property
    def ConfigAssociatedGroups(self):
        warnings.warn("parameter `ConfigAssociatedGroups` is deprecated", DeprecationWarning) 

        """配置项关联部署组
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of BusinesLogConfigAssociatedGroup
        """
        return self._ConfigAssociatedGroups

    @ConfigAssociatedGroups.setter
    def ConfigAssociatedGroups(self, ConfigAssociatedGroups):
        warnings.warn("parameter `ConfigAssociatedGroups` is deprecated", DeprecationWarning) 

        self._ConfigAssociatedGroups = ConfigAssociatedGroups

    @property
    def ConfigAssociatedGroupList(self):
        """配置项关联部署组
        :rtype: list of BusinessLogConfigAssociatedGroup
        """
        return self._ConfigAssociatedGroupList

    @ConfigAssociatedGroupList.setter
    def ConfigAssociatedGroupList(self, ConfigAssociatedGroupList):
        self._ConfigAssociatedGroupList = ConfigAssociatedGroupList

    @property
    def FilebeatConfigEnable(self):
        """是否开启filebeat高级配置开关
        :rtype: bool
        """
        return self._FilebeatConfigEnable

    @FilebeatConfigEnable.setter
    def FilebeatConfigEnable(self, FilebeatConfigEnable):
        self._FilebeatConfigEnable = FilebeatConfigEnable

    @property
    def FilebeatCloseTimeout(self):
        """close_timeout参数
        :rtype: int
        """
        return self._FilebeatCloseTimeout

    @FilebeatCloseTimeout.setter
    def FilebeatCloseTimeout(self, FilebeatCloseTimeout):
        self._FilebeatCloseTimeout = FilebeatCloseTimeout


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        self._ConfigName = params.get("ConfigName")
        self._ConfigPath = params.get("ConfigPath")
        self._ConfigDesc = params.get("ConfigDesc")
        self._ConfigTags = params.get("ConfigTags")
        self._ConfigPipeline = params.get("ConfigPipeline")
        self._ConfigCreateTime = params.get("ConfigCreateTime")
        self._ConfigUpdateTime = params.get("ConfigUpdateTime")
        if params.get("ConfigSchema") is not None:
            self._ConfigSchema = BusinessLogConfigSchema()
            self._ConfigSchema._deserialize(params.get("ConfigSchema"))
        if params.get("ConfigAssociatedGroups") is not None:
            self._ConfigAssociatedGroups = []
            for item in params.get("ConfigAssociatedGroups"):
                obj = BusinesLogConfigAssociatedGroup()
                obj._deserialize(item)
                self._ConfigAssociatedGroups.append(obj)
        if params.get("ConfigAssociatedGroupList") is not None:
            self._ConfigAssociatedGroupList = []
            for item in params.get("ConfigAssociatedGroupList"):
                obj = BusinessLogConfigAssociatedGroup()
                obj._deserialize(item)
                self._ConfigAssociatedGroupList.append(obj)
        self._FilebeatConfigEnable = params.get("FilebeatConfigEnable")
        self._FilebeatCloseTimeout = params.get("FilebeatCloseTimeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BusinessLogConfigAssociatedGroup(AbstractModel):
    """业务日志配置关联部署组信息

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID
        :type GroupId: str
        :param _GroupName: 部署组名称
        :type GroupName: str
        :param _ApplicationId: 部署组所属应用ID
        :type ApplicationId: str
        :param _ApplicationName: 部署组所属应用名称
        :type ApplicationName: str
        :param _ApplicationType: 部署组所属应用类型
        :type ApplicationType: str
        :param _NamespaceId: 部署组所属命名空间ID
        :type NamespaceId: str
        :param _NamespaceName: 部署组所属命名空间名称
        :type NamespaceName: str
        :param _ClusterId: 部署组所属集群ID
        :type ClusterId: str
        :param _ClusterName: 部署组所属集群名称
        :type ClusterName: str
        :param _ClusterType: 部署组所属集群类型
        :type ClusterType: str
        :param _AssociatedTime: 部署组关联日志配置时间
        :type AssociatedTime: str
        """
        self._GroupId = None
        self._GroupName = None
        self._ApplicationId = None
        self._ApplicationName = None
        self._ApplicationType = None
        self._NamespaceId = None
        self._NamespaceName = None
        self._ClusterId = None
        self._ClusterName = None
        self._ClusterType = None
        self._AssociatedTime = None

    @property
    def GroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupName(self):
        """部署组名称
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def ApplicationId(self):
        """部署组所属应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        """部署组所属应用名称
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationType(self):
        """部署组所属应用类型
        :rtype: str
        """
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType

    @property
    def NamespaceId(self):
        """部署组所属命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def NamespaceName(self):
        """部署组所属命名空间名称
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def ClusterId(self):
        """部署组所属集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        """部署组所属集群名称
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterType(self):
        """部署组所属集群类型
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def AssociatedTime(self):
        """部署组关联日志配置时间
        :rtype: str
        """
        return self._AssociatedTime

    @AssociatedTime.setter
    def AssociatedTime(self, AssociatedTime):
        self._AssociatedTime = AssociatedTime


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._GroupName = params.get("GroupName")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._ApplicationType = params.get("ApplicationType")
        self._NamespaceId = params.get("NamespaceId")
        self._NamespaceName = params.get("NamespaceName")
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._ClusterType = params.get("ClusterType")
        self._AssociatedTime = params.get("AssociatedTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BusinessLogConfigSchema(AbstractModel):
    """业务日志配置解析规则

    """

    def __init__(self):
        r"""
        :param _SchemaType: 解析规则类型
        :type SchemaType: int
        :param _SchemaContent: 解析规则内容
注意：此字段可能返回 null，表示取不到有效值。
        :type SchemaContent: str
        :param _SchemaDateFormat: 解析规则时间格式
注意：此字段可能返回 null，表示取不到有效值。
        :type SchemaDateFormat: str
        :param _SchemaMultilinePattern: 解析规则对应的多行匹配规则
注意：此字段可能返回 null，表示取不到有效值。
        :type SchemaMultilinePattern: str
        :param _SchemaCreateTime: 解析规则创建时间
        :type SchemaCreateTime: str
        :param _SchemaPatternLayout: 用户填写的解析规则
注意：此字段可能返回 null，表示取不到有效值。
        :type SchemaPatternLayout: str
        """
        self._SchemaType = None
        self._SchemaContent = None
        self._SchemaDateFormat = None
        self._SchemaMultilinePattern = None
        self._SchemaCreateTime = None
        self._SchemaPatternLayout = None

    @property
    def SchemaType(self):
        """解析规则类型
        :rtype: int
        """
        return self._SchemaType

    @SchemaType.setter
    def SchemaType(self, SchemaType):
        self._SchemaType = SchemaType

    @property
    def SchemaContent(self):
        """解析规则内容
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SchemaContent

    @SchemaContent.setter
    def SchemaContent(self, SchemaContent):
        self._SchemaContent = SchemaContent

    @property
    def SchemaDateFormat(self):
        """解析规则时间格式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SchemaDateFormat

    @SchemaDateFormat.setter
    def SchemaDateFormat(self, SchemaDateFormat):
        self._SchemaDateFormat = SchemaDateFormat

    @property
    def SchemaMultilinePattern(self):
        """解析规则对应的多行匹配规则
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SchemaMultilinePattern

    @SchemaMultilinePattern.setter
    def SchemaMultilinePattern(self, SchemaMultilinePattern):
        self._SchemaMultilinePattern = SchemaMultilinePattern

    @property
    def SchemaCreateTime(self):
        """解析规则创建时间
        :rtype: str
        """
        return self._SchemaCreateTime

    @SchemaCreateTime.setter
    def SchemaCreateTime(self, SchemaCreateTime):
        self._SchemaCreateTime = SchemaCreateTime

    @property
    def SchemaPatternLayout(self):
        """用户填写的解析规则
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SchemaPatternLayout

    @SchemaPatternLayout.setter
    def SchemaPatternLayout(self, SchemaPatternLayout):
        self._SchemaPatternLayout = SchemaPatternLayout


    def _deserialize(self, params):
        self._SchemaType = params.get("SchemaType")
        self._SchemaContent = params.get("SchemaContent")
        self._SchemaDateFormat = params.get("SchemaDateFormat")
        self._SchemaMultilinePattern = params.get("SchemaMultilinePattern")
        self._SchemaCreateTime = params.get("SchemaCreateTime")
        self._SchemaPatternLayout = params.get("SchemaPatternLayout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BusinessLogV2(AbstractModel):
    """业务日志

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例ID
        :type InstanceId: str
        :param _Content: 日志内容
        :type Content: str
        :param _Timestamp: 日志时间戳
        :type Timestamp: int
        :param _InstanceIp: 实例IP
        :type InstanceIp: str
        :param _LogId: 日志ID
        :type LogId: str
        :param _GroupId: 部署组ID
        :type GroupId: str
        """
        self._InstanceId = None
        self._Content = None
        self._Timestamp = None
        self._InstanceIp = None
        self._LogId = None
        self._GroupId = None

    @property
    def InstanceId(self):
        """实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Content(self):
        """日志内容
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def Timestamp(self):
        """日志时间戳
        :rtype: int
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def InstanceIp(self):
        """实例IP
        :rtype: str
        """
        return self._InstanceIp

    @InstanceIp.setter
    def InstanceIp(self, InstanceIp):
        self._InstanceIp = InstanceIp

    @property
    def LogId(self):
        """日志ID
        :rtype: str
        """
        return self._LogId

    @LogId.setter
    def LogId(self, LogId):
        self._LogId = LogId

    @property
    def GroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Content = params.get("Content")
        self._Timestamp = params.get("Timestamp")
        self._InstanceIp = params.get("InstanceIp")
        self._LogId = params.get("LogId")
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ChangeApiUsableStatusRequest(AbstractModel):
    """ChangeApiUsableStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApiId: API ID
        :type ApiId: str
        :param _UsableStatus: 切换状态，enabled/disabled
        :type UsableStatus: str
        """
        self._ApiId = None
        self._UsableStatus = None

    @property
    def ApiId(self):
        """API ID
        :rtype: str
        """
        return self._ApiId

    @ApiId.setter
    def ApiId(self, ApiId):
        self._ApiId = ApiId

    @property
    def UsableStatus(self):
        """切换状态，enabled/disabled
        :rtype: str
        """
        return self._UsableStatus

    @UsableStatus.setter
    def UsableStatus(self, UsableStatus):
        self._UsableStatus = UsableStatus


    def _deserialize(self, params):
        self._ApiId = params.get("ApiId")
        self._UsableStatus = params.get("UsableStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ChangeApiUsableStatusResponse(AbstractModel):
    """ChangeApiUsableStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: API 信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ApiDetailInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """API 信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ApiDetailInfo`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ApiDetailInfo()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class Cluster(AbstractModel):
    """集群

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _ClusterDesc: 集群描述
        :type ClusterDesc: str
        :param _ClusterType: 集群类型
        :type ClusterType: str
        :param _VpcId: 集群所属私有网络ID
        :type VpcId: str
        :param _ClusterStatus: 集群状态
        :type ClusterStatus: str
        :param _ClusterCIDR: 集群CIDR
        :type ClusterCIDR: str
        :param _ClusterTotalCpu: 集群总CPU，单位: 核
        :type ClusterTotalCpu: float
        :param _ClusterTotalMem: 集群总内存，单位: G
        :type ClusterTotalMem: float
        :param _ClusterUsedCpu: 集群已使用CPU，单位: 核
        :type ClusterUsedCpu: float
        :param _ClusterUsedMem: 集群已使用内存，单位: G
        :type ClusterUsedMem: float
        :param _InstanceCount: 集群机器实例数量
        :type InstanceCount: int
        :param _RunInstanceCount: 集群可用的机器实例数量
        :type RunInstanceCount: int
        :param _NormalInstanceCount: 集群正常状态的机器实例数量
        :type NormalInstanceCount: int
        :param _DeleteFlag: 删除标记：true：可以删除；false：不可删除
        :type DeleteFlag: bool
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        :param _TsfRegionId: 集群所属TSF地域ID
        :type TsfRegionId: str
        :param _TsfRegionName: 集群所属TSF地域名称
        :type TsfRegionName: str
        :param _TsfZoneId: 集群所属TSF可用区ID
        :type TsfZoneId: str
        :param _TsfZoneName: 集群所属TSF可用区名称
        :type TsfZoneName: str
        :param _DeleteFlagReason: 集群不可删除的原因
        :type DeleteFlagReason: str
        :param _ClusterLimitCpu: 集群最大CPU限制，单位：核
        :type ClusterLimitCpu: float
        :param _ClusterLimitMem: 集群最大内存限制，单位：G
        :type ClusterLimitMem: float
        :param _RunServiceInstanceCount: 集群可用的服务实例数量
        :type RunServiceInstanceCount: int
        :param _SubnetId: 集群所属子网ID
        :type SubnetId: str
        :param _OperationInfo: 返回给前端的控制信息
        :type OperationInfo: :class:`tencentcloud.tsf.v20180326.models.OperationInfo`
        :param _ClusterVersion: 集群版本
        :type ClusterVersion: str
        """
        self._ClusterId = None
        self._ClusterName = None
        self._ClusterDesc = None
        self._ClusterType = None
        self._VpcId = None
        self._ClusterStatus = None
        self._ClusterCIDR = None
        self._ClusterTotalCpu = None
        self._ClusterTotalMem = None
        self._ClusterUsedCpu = None
        self._ClusterUsedMem = None
        self._InstanceCount = None
        self._RunInstanceCount = None
        self._NormalInstanceCount = None
        self._DeleteFlag = None
        self._CreateTime = None
        self._UpdateTime = None
        self._TsfRegionId = None
        self._TsfRegionName = None
        self._TsfZoneId = None
        self._TsfZoneName = None
        self._DeleteFlagReason = None
        self._ClusterLimitCpu = None
        self._ClusterLimitMem = None
        self._RunServiceInstanceCount = None
        self._SubnetId = None
        self._OperationInfo = None
        self._ClusterVersion = None

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        """集群名称
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterDesc(self):
        """集群描述
        :rtype: str
        """
        return self._ClusterDesc

    @ClusterDesc.setter
    def ClusterDesc(self, ClusterDesc):
        self._ClusterDesc = ClusterDesc

    @property
    def ClusterType(self):
        """集群类型
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def VpcId(self):
        """集群所属私有网络ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ClusterStatus(self):
        """集群状态
        :rtype: str
        """
        return self._ClusterStatus

    @ClusterStatus.setter
    def ClusterStatus(self, ClusterStatus):
        self._ClusterStatus = ClusterStatus

    @property
    def ClusterCIDR(self):
        """集群CIDR
        :rtype: str
        """
        return self._ClusterCIDR

    @ClusterCIDR.setter
    def ClusterCIDR(self, ClusterCIDR):
        self._ClusterCIDR = ClusterCIDR

    @property
    def ClusterTotalCpu(self):
        """集群总CPU，单位: 核
        :rtype: float
        """
        return self._ClusterTotalCpu

    @ClusterTotalCpu.setter
    def ClusterTotalCpu(self, ClusterTotalCpu):
        self._ClusterTotalCpu = ClusterTotalCpu

    @property
    def ClusterTotalMem(self):
        """集群总内存，单位: G
        :rtype: float
        """
        return self._ClusterTotalMem

    @ClusterTotalMem.setter
    def ClusterTotalMem(self, ClusterTotalMem):
        self._ClusterTotalMem = ClusterTotalMem

    @property
    def ClusterUsedCpu(self):
        """集群已使用CPU，单位: 核
        :rtype: float
        """
        return self._ClusterUsedCpu

    @ClusterUsedCpu.setter
    def ClusterUsedCpu(self, ClusterUsedCpu):
        self._ClusterUsedCpu = ClusterUsedCpu

    @property
    def ClusterUsedMem(self):
        """集群已使用内存，单位: G
        :rtype: float
        """
        return self._ClusterUsedMem

    @ClusterUsedMem.setter
    def ClusterUsedMem(self, ClusterUsedMem):
        self._ClusterUsedMem = ClusterUsedMem

    @property
    def InstanceCount(self):
        """集群机器实例数量
        :rtype: int
        """
        return self._InstanceCount

    @InstanceCount.setter
    def InstanceCount(self, InstanceCount):
        self._InstanceCount = InstanceCount

    @property
    def RunInstanceCount(self):
        """集群可用的机器实例数量
        :rtype: int
        """
        return self._RunInstanceCount

    @RunInstanceCount.setter
    def RunInstanceCount(self, RunInstanceCount):
        self._RunInstanceCount = RunInstanceCount

    @property
    def NormalInstanceCount(self):
        """集群正常状态的机器实例数量
        :rtype: int
        """
        return self._NormalInstanceCount

    @NormalInstanceCount.setter
    def NormalInstanceCount(self, NormalInstanceCount):
        self._NormalInstanceCount = NormalInstanceCount

    @property
    def DeleteFlag(self):
        """删除标记：true：可以删除；false：不可删除
        :rtype: bool
        """
        return self._DeleteFlag

    @DeleteFlag.setter
    def DeleteFlag(self, DeleteFlag):
        self._DeleteFlag = DeleteFlag

    @property
    def CreateTime(self):
        """创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """更新时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def TsfRegionId(self):
        """集群所属TSF地域ID
        :rtype: str
        """
        return self._TsfRegionId

    @TsfRegionId.setter
    def TsfRegionId(self, TsfRegionId):
        self._TsfRegionId = TsfRegionId

    @property
    def TsfRegionName(self):
        """集群所属TSF地域名称
        :rtype: str
        """
        return self._TsfRegionName

    @TsfRegionName.setter
    def TsfRegionName(self, TsfRegionName):
        self._TsfRegionName = TsfRegionName

    @property
    def TsfZoneId(self):
        """集群所属TSF可用区ID
        :rtype: str
        """
        return self._TsfZoneId

    @TsfZoneId.setter
    def TsfZoneId(self, TsfZoneId):
        self._TsfZoneId = TsfZoneId

    @property
    def TsfZoneName(self):
        """集群所属TSF可用区名称
        :rtype: str
        """
        return self._TsfZoneName

    @TsfZoneName.setter
    def TsfZoneName(self, TsfZoneName):
        self._TsfZoneName = TsfZoneName

    @property
    def DeleteFlagReason(self):
        """集群不可删除的原因
        :rtype: str
        """
        return self._DeleteFlagReason

    @DeleteFlagReason.setter
    def DeleteFlagReason(self, DeleteFlagReason):
        self._DeleteFlagReason = DeleteFlagReason

    @property
    def ClusterLimitCpu(self):
        """集群最大CPU限制，单位：核
        :rtype: float
        """
        return self._ClusterLimitCpu

    @ClusterLimitCpu.setter
    def ClusterLimitCpu(self, ClusterLimitCpu):
        self._ClusterLimitCpu = ClusterLimitCpu

    @property
    def ClusterLimitMem(self):
        """集群最大内存限制，单位：G
        :rtype: float
        """
        return self._ClusterLimitMem

    @ClusterLimitMem.setter
    def ClusterLimitMem(self, ClusterLimitMem):
        self._ClusterLimitMem = ClusterLimitMem

    @property
    def RunServiceInstanceCount(self):
        """集群可用的服务实例数量
        :rtype: int
        """
        return self._RunServiceInstanceCount

    @RunServiceInstanceCount.setter
    def RunServiceInstanceCount(self, RunServiceInstanceCount):
        self._RunServiceInstanceCount = RunServiceInstanceCount

    @property
    def SubnetId(self):
        """集群所属子网ID
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def OperationInfo(self):
        """返回给前端的控制信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.OperationInfo`
        """
        return self._OperationInfo

    @OperationInfo.setter
    def OperationInfo(self, OperationInfo):
        self._OperationInfo = OperationInfo

    @property
    def ClusterVersion(self):
        """集群版本
        :rtype: str
        """
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._ClusterDesc = params.get("ClusterDesc")
        self._ClusterType = params.get("ClusterType")
        self._VpcId = params.get("VpcId")
        self._ClusterStatus = params.get("ClusterStatus")
        self._ClusterCIDR = params.get("ClusterCIDR")
        self._ClusterTotalCpu = params.get("ClusterTotalCpu")
        self._ClusterTotalMem = params.get("ClusterTotalMem")
        self._ClusterUsedCpu = params.get("ClusterUsedCpu")
        self._ClusterUsedMem = params.get("ClusterUsedMem")
        self._InstanceCount = params.get("InstanceCount")
        self._RunInstanceCount = params.get("RunInstanceCount")
        self._NormalInstanceCount = params.get("NormalInstanceCount")
        self._DeleteFlag = params.get("DeleteFlag")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._TsfRegionId = params.get("TsfRegionId")
        self._TsfRegionName = params.get("TsfRegionName")
        self._TsfZoneId = params.get("TsfZoneId")
        self._TsfZoneName = params.get("TsfZoneName")
        self._DeleteFlagReason = params.get("DeleteFlagReason")
        self._ClusterLimitCpu = params.get("ClusterLimitCpu")
        self._ClusterLimitMem = params.get("ClusterLimitMem")
        self._RunServiceInstanceCount = params.get("RunServiceInstanceCount")
        self._SubnetId = params.get("SubnetId")
        if params.get("OperationInfo") is not None:
            self._OperationInfo = OperationInfo()
            self._OperationInfo._deserialize(params.get("OperationInfo"))
        self._ClusterVersion = params.get("ClusterVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterV2(AbstractModel):
    """集群详情

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ClusterName: 集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterName: str
        :param _ClusterDesc: 集群描述
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterDesc: str
        :param _ClusterType: 集群类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterType: str
        :param _VpcId: 集群所属私有网络ID
注意：此字段可能返回 null，表示取不到有效值。
        :type VpcId: str
        :param _ClusterStatus: 集群状态
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterStatus: str
        :param _ClusterCIDR: 集群CIDR
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterCIDR: str
        :param _ClusterTotalCpu: 集群总CPU，单位: 核
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterTotalCpu: float
        :param _ClusterTotalMem: 集群总内存，单位: G
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterTotalMem: float
        :param _ClusterUsedCpu: 集群已使用CPU，单位: 核
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterUsedCpu: float
        :param _ClusterUsedMem: 集群已使用内存，单位: G
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterUsedMem: float
        :param _InstanceCount: 集群机器实例数量
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceCount: int
        :param _RunInstanceCount: 集群运行中的机器实例数量
注意：此字段可能返回 null，表示取不到有效值。
        :type RunInstanceCount: int
        :param _NormalInstanceCount: 集群正常状态的机器实例数量
注意：此字段可能返回 null，表示取不到有效值。
        :type NormalInstanceCount: int
        :param _DeleteFlag: 删除标记：true：可以删除；false：不可删除
注意：此字段可能返回 null，表示取不到有效值。
        :type DeleteFlag: bool
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _TsfRegionId: 集群所属TSF地域ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TsfRegionId: str
        :param _TsfRegionName: 集群所属TSF地域名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TsfRegionName: str
        :param _TsfZoneId: 集群所属TSF可用区ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TsfZoneId: str
        :param _TsfZoneName: 集群所属TSF可用区名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TsfZoneName: str
        :param _DeleteFlagReason: 集群不可删除的原因
注意：此字段可能返回 null，表示取不到有效值。
        :type DeleteFlagReason: str
        :param _SubnetId: 集群所属私有网络子网ID
注意：此字段可能返回 null，表示取不到有效值。
        :type SubnetId: str
        :param _ClusterLimitCpu: 集群剩余 cpu limit
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterLimitCpu: str
        :param _ClusterLimitMem: 集群剩余 memory limit
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterLimitMem: str
        :param _RunServiceInstanceCount: 运行服务实例数
注意：此字段可能返回 null，表示取不到有效值。
        :type RunServiceInstanceCount: int
        :param _OperationInfo: 给前端的按钮控制信息
注意：此字段可能返回 null，表示取不到有效值。
        :type OperationInfo: :class:`tencentcloud.tsf.v20180326.models.OperationInfo`
        :param _ClusterVersion: 容器集群版本
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterVersion: str
        :param _GroupCount: 部署组总数
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupCount: int
        :param _RunGroupCount: 运行中部署组数
注意：此字段可能返回 null，表示取不到有效值。
        :type RunGroupCount: int
        :param _StopGroupCount: 停止中部署组数
注意：此字段可能返回 null，表示取不到有效值。
        :type StopGroupCount: int
        :param _AbnormalGroupCount: 异常部署组数
注意：此字段可能返回 null，表示取不到有效值。
        :type AbnormalGroupCount: int
        :param _ClusterRemarkName: 集群备注名
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterRemarkName: str
        :param _KuberneteApiServer: api地址
注意：此字段可能返回 null，表示取不到有效值。
        :type KuberneteApiServer: str
        :param _KuberneteNativeType: K : kubeconfig, S : service account
注意：此字段可能返回 null，表示取不到有效值。
        :type KuberneteNativeType: str
        :param _KuberneteNativeSecret: native secret
注意：此字段可能返回 null，表示取不到有效值。
        :type KuberneteNativeSecret: str
        :param _EnableLogCollection: 是否开启cls日志功能
        :type EnableLogCollection: bool
        :param _Reason: 集群状态的原因
        :type Reason: str
        """
        self._ClusterId = None
        self._ClusterName = None
        self._ClusterDesc = None
        self._ClusterType = None
        self._VpcId = None
        self._ClusterStatus = None
        self._ClusterCIDR = None
        self._ClusterTotalCpu = None
        self._ClusterTotalMem = None
        self._ClusterUsedCpu = None
        self._ClusterUsedMem = None
        self._InstanceCount = None
        self._RunInstanceCount = None
        self._NormalInstanceCount = None
        self._DeleteFlag = None
        self._CreateTime = None
        self._UpdateTime = None
        self._TsfRegionId = None
        self._TsfRegionName = None
        self._TsfZoneId = None
        self._TsfZoneName = None
        self._DeleteFlagReason = None
        self._SubnetId = None
        self._ClusterLimitCpu = None
        self._ClusterLimitMem = None
        self._RunServiceInstanceCount = None
        self._OperationInfo = None
        self._ClusterVersion = None
        self._GroupCount = None
        self._RunGroupCount = None
        self._StopGroupCount = None
        self._AbnormalGroupCount = None
        self._ClusterRemarkName = None
        self._KuberneteApiServer = None
        self._KuberneteNativeType = None
        self._KuberneteNativeSecret = None
        self._EnableLogCollection = None
        self._Reason = None

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        """集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterDesc(self):
        """集群描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterDesc

    @ClusterDesc.setter
    def ClusterDesc(self, ClusterDesc):
        self._ClusterDesc = ClusterDesc

    @property
    def ClusterType(self):
        """集群类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def VpcId(self):
        """集群所属私有网络ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ClusterStatus(self):
        """集群状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterStatus

    @ClusterStatus.setter
    def ClusterStatus(self, ClusterStatus):
        self._ClusterStatus = ClusterStatus

    @property
    def ClusterCIDR(self):
        """集群CIDR
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterCIDR

    @ClusterCIDR.setter
    def ClusterCIDR(self, ClusterCIDR):
        self._ClusterCIDR = ClusterCIDR

    @property
    def ClusterTotalCpu(self):
        """集群总CPU，单位: 核
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._ClusterTotalCpu

    @ClusterTotalCpu.setter
    def ClusterTotalCpu(self, ClusterTotalCpu):
        self._ClusterTotalCpu = ClusterTotalCpu

    @property
    def ClusterTotalMem(self):
        """集群总内存，单位: G
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._ClusterTotalMem

    @ClusterTotalMem.setter
    def ClusterTotalMem(self, ClusterTotalMem):
        self._ClusterTotalMem = ClusterTotalMem

    @property
    def ClusterUsedCpu(self):
        """集群已使用CPU，单位: 核
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._ClusterUsedCpu

    @ClusterUsedCpu.setter
    def ClusterUsedCpu(self, ClusterUsedCpu):
        self._ClusterUsedCpu = ClusterUsedCpu

    @property
    def ClusterUsedMem(self):
        """集群已使用内存，单位: G
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._ClusterUsedMem

    @ClusterUsedMem.setter
    def ClusterUsedMem(self, ClusterUsedMem):
        self._ClusterUsedMem = ClusterUsedMem

    @property
    def InstanceCount(self):
        """集群机器实例数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._InstanceCount

    @InstanceCount.setter
    def InstanceCount(self, InstanceCount):
        self._InstanceCount = InstanceCount

    @property
    def RunInstanceCount(self):
        """集群运行中的机器实例数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RunInstanceCount

    @RunInstanceCount.setter
    def RunInstanceCount(self, RunInstanceCount):
        self._RunInstanceCount = RunInstanceCount

    @property
    def NormalInstanceCount(self):
        """集群正常状态的机器实例数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._NormalInstanceCount

    @NormalInstanceCount.setter
    def NormalInstanceCount(self, NormalInstanceCount):
        self._NormalInstanceCount = NormalInstanceCount

    @property
    def DeleteFlag(self):
        """删除标记：true：可以删除；false：不可删除
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._DeleteFlag

    @DeleteFlag.setter
    def DeleteFlag(self, DeleteFlag):
        self._DeleteFlag = DeleteFlag

    @property
    def CreateTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def TsfRegionId(self):
        """集群所属TSF地域ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TsfRegionId

    @TsfRegionId.setter
    def TsfRegionId(self, TsfRegionId):
        self._TsfRegionId = TsfRegionId

    @property
    def TsfRegionName(self):
        """集群所属TSF地域名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TsfRegionName

    @TsfRegionName.setter
    def TsfRegionName(self, TsfRegionName):
        self._TsfRegionName = TsfRegionName

    @property
    def TsfZoneId(self):
        """集群所属TSF可用区ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TsfZoneId

    @TsfZoneId.setter
    def TsfZoneId(self, TsfZoneId):
        self._TsfZoneId = TsfZoneId

    @property
    def TsfZoneName(self):
        """集群所属TSF可用区名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TsfZoneName

    @TsfZoneName.setter
    def TsfZoneName(self, TsfZoneName):
        self._TsfZoneName = TsfZoneName

    @property
    def DeleteFlagReason(self):
        """集群不可删除的原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DeleteFlagReason

    @DeleteFlagReason.setter
    def DeleteFlagReason(self, DeleteFlagReason):
        self._DeleteFlagReason = DeleteFlagReason

    @property
    def SubnetId(self):
        """集群所属私有网络子网ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def ClusterLimitCpu(self):
        """集群剩余 cpu limit
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterLimitCpu

    @ClusterLimitCpu.setter
    def ClusterLimitCpu(self, ClusterLimitCpu):
        self._ClusterLimitCpu = ClusterLimitCpu

    @property
    def ClusterLimitMem(self):
        """集群剩余 memory limit
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterLimitMem

    @ClusterLimitMem.setter
    def ClusterLimitMem(self, ClusterLimitMem):
        self._ClusterLimitMem = ClusterLimitMem

    @property
    def RunServiceInstanceCount(self):
        """运行服务实例数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RunServiceInstanceCount

    @RunServiceInstanceCount.setter
    def RunServiceInstanceCount(self, RunServiceInstanceCount):
        self._RunServiceInstanceCount = RunServiceInstanceCount

    @property
    def OperationInfo(self):
        """给前端的按钮控制信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.OperationInfo`
        """
        return self._OperationInfo

    @OperationInfo.setter
    def OperationInfo(self, OperationInfo):
        self._OperationInfo = OperationInfo

    @property
    def ClusterVersion(self):
        """容器集群版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def GroupCount(self):
        """部署组总数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._GroupCount

    @GroupCount.setter
    def GroupCount(self, GroupCount):
        self._GroupCount = GroupCount

    @property
    def RunGroupCount(self):
        """运行中部署组数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RunGroupCount

    @RunGroupCount.setter
    def RunGroupCount(self, RunGroupCount):
        self._RunGroupCount = RunGroupCount

    @property
    def StopGroupCount(self):
        """停止中部署组数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._StopGroupCount

    @StopGroupCount.setter
    def StopGroupCount(self, StopGroupCount):
        self._StopGroupCount = StopGroupCount

    @property
    def AbnormalGroupCount(self):
        """异常部署组数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._AbnormalGroupCount

    @AbnormalGroupCount.setter
    def AbnormalGroupCount(self, AbnormalGroupCount):
        self._AbnormalGroupCount = AbnormalGroupCount

    @property
    def ClusterRemarkName(self):
        """集群备注名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterRemarkName

    @ClusterRemarkName.setter
    def ClusterRemarkName(self, ClusterRemarkName):
        self._ClusterRemarkName = ClusterRemarkName

    @property
    def KuberneteApiServer(self):
        """api地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._KuberneteApiServer

    @KuberneteApiServer.setter
    def KuberneteApiServer(self, KuberneteApiServer):
        self._KuberneteApiServer = KuberneteApiServer

    @property
    def KuberneteNativeType(self):
        """K : kubeconfig, S : service account
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._KuberneteNativeType

    @KuberneteNativeType.setter
    def KuberneteNativeType(self, KuberneteNativeType):
        self._KuberneteNativeType = KuberneteNativeType

    @property
    def KuberneteNativeSecret(self):
        """native secret
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._KuberneteNativeSecret

    @KuberneteNativeSecret.setter
    def KuberneteNativeSecret(self, KuberneteNativeSecret):
        self._KuberneteNativeSecret = KuberneteNativeSecret

    @property
    def EnableLogCollection(self):
        """是否开启cls日志功能
        :rtype: bool
        """
        return self._EnableLogCollection

    @EnableLogCollection.setter
    def EnableLogCollection(self, EnableLogCollection):
        self._EnableLogCollection = EnableLogCollection

    @property
    def Reason(self):
        """集群状态的原因
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._ClusterDesc = params.get("ClusterDesc")
        self._ClusterType = params.get("ClusterType")
        self._VpcId = params.get("VpcId")
        self._ClusterStatus = params.get("ClusterStatus")
        self._ClusterCIDR = params.get("ClusterCIDR")
        self._ClusterTotalCpu = params.get("ClusterTotalCpu")
        self._ClusterTotalMem = params.get("ClusterTotalMem")
        self._ClusterUsedCpu = params.get("ClusterUsedCpu")
        self._ClusterUsedMem = params.get("ClusterUsedMem")
        self._InstanceCount = params.get("InstanceCount")
        self._RunInstanceCount = params.get("RunInstanceCount")
        self._NormalInstanceCount = params.get("NormalInstanceCount")
        self._DeleteFlag = params.get("DeleteFlag")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._TsfRegionId = params.get("TsfRegionId")
        self._TsfRegionName = params.get("TsfRegionName")
        self._TsfZoneId = params.get("TsfZoneId")
        self._TsfZoneName = params.get("TsfZoneName")
        self._DeleteFlagReason = params.get("DeleteFlagReason")
        self._SubnetId = params.get("SubnetId")
        self._ClusterLimitCpu = params.get("ClusterLimitCpu")
        self._ClusterLimitMem = params.get("ClusterLimitMem")
        self._RunServiceInstanceCount = params.get("RunServiceInstanceCount")
        if params.get("OperationInfo") is not None:
            self._OperationInfo = OperationInfo()
            self._OperationInfo._deserialize(params.get("OperationInfo"))
        self._ClusterVersion = params.get("ClusterVersion")
        self._GroupCount = params.get("GroupCount")
        self._RunGroupCount = params.get("RunGroupCount")
        self._StopGroupCount = params.get("StopGroupCount")
        self._AbnormalGroupCount = params.get("AbnormalGroupCount")
        self._ClusterRemarkName = params.get("ClusterRemarkName")
        self._KuberneteApiServer = params.get("KuberneteApiServer")
        self._KuberneteNativeType = params.get("KuberneteNativeType")
        self._KuberneteNativeSecret = params.get("KuberneteNativeSecret")
        self._EnableLogCollection = params.get("EnableLogCollection")
        self._Reason = params.get("Reason")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonOption(AbstractModel):
    """通用选项

    """

    def __init__(self):
        r"""
        :param _LabelName: -
        :type LabelName: str
        :param _Operator: -
        :type Operator: str
        :param _LabelValue: -
        :type LabelValue: str
        """
        self._LabelName = None
        self._Operator = None
        self._LabelValue = None

    @property
    def LabelName(self):
        """-
        :rtype: str
        """
        return self._LabelName

    @LabelName.setter
    def LabelName(self, LabelName):
        self._LabelName = LabelName

    @property
    def Operator(self):
        """-
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def LabelValue(self):
        """-
        :rtype: str
        """
        return self._LabelValue

    @LabelValue.setter
    def LabelValue(self, LabelValue):
        self._LabelValue = LabelValue


    def _deserialize(self, params):
        self._LabelName = params.get("LabelName")
        self._Operator = params.get("Operator")
        self._LabelValue = params.get("LabelValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonRef(AbstractModel):
    """ValueFrom 通用结构

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _Key: Key值
        :type Key: str
        """
        self._Name = None
        self._Key = None

    @property
    def Name(self):
        """名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Key(self):
        """Key值
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Key = params.get("Key")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Config(AbstractModel):
    """配置项

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置项ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigId: str
        :param _ConfigName: 配置项名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigName: str
        :param _ConfigVersion: 配置项版本
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigVersion: str
        :param _ConfigVersionDesc: 配置项版本描述
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigVersionDesc: str
        :param _ConfigValue: 配置项值
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigValue: str
        :param _ConfigType: 配置项类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigType: str
        :param _CreationTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreationTime: str
        :param _ApplicationId: 应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationId: str
        :param _ApplicationName: 应用名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationName: str
        :param _DeleteFlag: 删除标识，true：可以删除；false：不可删除
注意：此字段可能返回 null，表示取不到有效值。
        :type DeleteFlag: bool
        :param _LastUpdateTime: 最后更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LastUpdateTime: str
        :param _ConfigVersionCount: 配置项版本数量
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigVersionCount: int
        """
        self._ConfigId = None
        self._ConfigName = None
        self._ConfigVersion = None
        self._ConfigVersionDesc = None
        self._ConfigValue = None
        self._ConfigType = None
        self._CreationTime = None
        self._ApplicationId = None
        self._ApplicationName = None
        self._DeleteFlag = None
        self._LastUpdateTime = None
        self._ConfigVersionCount = None

    @property
    def ConfigId(self):
        """配置项ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def ConfigName(self):
        """配置项名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigVersion(self):
        """配置项版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigVersion

    @ConfigVersion.setter
    def ConfigVersion(self, ConfigVersion):
        self._ConfigVersion = ConfigVersion

    @property
    def ConfigVersionDesc(self):
        """配置项版本描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigVersionDesc

    @ConfigVersionDesc.setter
    def ConfigVersionDesc(self, ConfigVersionDesc):
        self._ConfigVersionDesc = ConfigVersionDesc

    @property
    def ConfigValue(self):
        """配置项值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigValue

    @ConfigValue.setter
    def ConfigValue(self, ConfigValue):
        self._ConfigValue = ConfigValue

    @property
    def ConfigType(self):
        """配置项类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigType

    @ConfigType.setter
    def ConfigType(self, ConfigType):
        self._ConfigType = ConfigType

    @property
    def CreationTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreationTime

    @CreationTime.setter
    def CreationTime(self, CreationTime):
        self._CreationTime = CreationTime

    @property
    def ApplicationId(self):
        """应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        """应用名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def DeleteFlag(self):
        """删除标识，true：可以删除；false：不可删除
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._DeleteFlag

    @DeleteFlag.setter
    def DeleteFlag(self, DeleteFlag):
        self._DeleteFlag = DeleteFlag

    @property
    def LastUpdateTime(self):
        """最后更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LastUpdateTime

    @LastUpdateTime.setter
    def LastUpdateTime(self, LastUpdateTime):
        self._LastUpdateTime = LastUpdateTime

    @property
    def ConfigVersionCount(self):
        """配置项版本数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ConfigVersionCount

    @ConfigVersionCount.setter
    def ConfigVersionCount(self, ConfigVersionCount):
        self._ConfigVersionCount = ConfigVersionCount


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        self._ConfigName = params.get("ConfigName")
        self._ConfigVersion = params.get("ConfigVersion")
        self._ConfigVersionDesc = params.get("ConfigVersionDesc")
        self._ConfigValue = params.get("ConfigValue")
        self._ConfigType = params.get("ConfigType")
        self._CreationTime = params.get("CreationTime")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._DeleteFlag = params.get("DeleteFlag")
        self._LastUpdateTime = params.get("LastUpdateTime")
        self._ConfigVersionCount = params.get("ConfigVersionCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfigMapOption(AbstractModel):
    """ConfigMap可选项

    """

    def __init__(self):
        r"""
        :param _Key: -
        :type Key: str
        :param _Path: -
        :type Path: str
        :param _Mode: -
        :type Mode: str
        """
        self._Key = None
        self._Path = None
        self._Mode = None

    @property
    def Key(self):
        """-
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Path(self):
        """-
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Mode(self):
        """-
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Path = params.get("Path")
        self._Mode = params.get("Mode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfigRelease(AbstractModel):
    """配置项发布信息

    """

    def __init__(self):
        r"""
        :param _ConfigReleaseId: 配置项发布ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigReleaseId: str
        :param _ConfigId: 配置项ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigId: str
        :param _ConfigName: 配置项名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigName: str
        :param _ConfigVersion: 配置项版本
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigVersion: str
        :param _ReleaseTime: 发布时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ReleaseTime: str
        :param _GroupId: 部署组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupId: str
        :param _GroupName: 部署组名称
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupName: str
        :param _NamespaceId: 命名空间ID
注意：此字段可能返回 null，表示取不到有效值。
        :type NamespaceId: str
        :param _NamespaceName: 命名空间名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NamespaceName: str
        :param _ClusterId: 集群ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterId: str
        :param _ClusterName: 集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterName: str
        :param _ReleaseDesc: 发布描述
注意：此字段可能返回 null，表示取不到有效值。
        :type ReleaseDesc: str
        :param _ApplicationId: 应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationId: str
        :param _ConfigCenters: 配置中心发布情况
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigCenters: list of TsfConfigCenter
        :param _DaulStatus: DUAL_STATUS_WRITE_REGISTRATION_ON 双写&&双注册开启

DUAL_STATUS_WRITE_REGISTRATION_OFF 双写&&双注册关闭
注意：此字段可能返回 null，表示取不到有效值。
        :type DaulStatus: str
        """
        self._ConfigReleaseId = None
        self._ConfigId = None
        self._ConfigName = None
        self._ConfigVersion = None
        self._ReleaseTime = None
        self._GroupId = None
        self._GroupName = None
        self._NamespaceId = None
        self._NamespaceName = None
        self._ClusterId = None
        self._ClusterName = None
        self._ReleaseDesc = None
        self._ApplicationId = None
        self._ConfigCenters = None
        self._DaulStatus = None

    @property
    def ConfigReleaseId(self):
        """配置项发布ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigReleaseId

    @ConfigReleaseId.setter
    def ConfigReleaseId(self, ConfigReleaseId):
        self._ConfigReleaseId = ConfigReleaseId

    @property
    def ConfigId(self):
        """配置项ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def ConfigName(self):
        """配置项名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigVersion(self):
        """配置项版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigVersion

    @ConfigVersion.setter
    def ConfigVersion(self, ConfigVersion):
        self._ConfigVersion = ConfigVersion

    @property
    def ReleaseTime(self):
        """发布时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReleaseTime

    @ReleaseTime.setter
    def ReleaseTime(self, ReleaseTime):
        self._ReleaseTime = ReleaseTime

    @property
    def GroupId(self):
        """部署组ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupName(self):
        """部署组名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def NamespaceId(self):
        """命名空间ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def NamespaceName(self):
        """命名空间名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def ClusterId(self):
        """集群ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        """集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ReleaseDesc(self):
        """发布描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReleaseDesc

    @ReleaseDesc.setter
    def ReleaseDesc(self, ReleaseDesc):
        self._ReleaseDesc = ReleaseDesc

    @property
    def ApplicationId(self):
        """应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ConfigCenters(self):
        """配置中心发布情况
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TsfConfigCenter
        """
        return self._ConfigCenters

    @ConfigCenters.setter
    def ConfigCenters(self, ConfigCenters):
        self._ConfigCenters = ConfigCenters

    @property
    def DaulStatus(self):
        """DUAL_STATUS_WRITE_REGISTRATION_ON 双写&&双注册开启

DUAL_STATUS_WRITE_REGISTRATION_OFF 双写&&双注册关闭
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DaulStatus

    @DaulStatus.setter
    def DaulStatus(self, DaulStatus):
        self._DaulStatus = DaulStatus


    def _deserialize(self, params):
        self._ConfigReleaseId = params.get("ConfigReleaseId")
        self._ConfigId = params.get("ConfigId")
        self._ConfigName = params.get("ConfigName")
        self._ConfigVersion = params.get("ConfigVersion")
        self._ReleaseTime = params.get("ReleaseTime")
        self._GroupId = params.get("GroupId")
        self._GroupName = params.get("GroupName")
        self._NamespaceId = params.get("NamespaceId")
        self._NamespaceName = params.get("NamespaceName")
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._ReleaseDesc = params.get("ReleaseDesc")
        self._ApplicationId = params.get("ApplicationId")
        if params.get("ConfigCenters") is not None:
            self._ConfigCenters = []
            for item in params.get("ConfigCenters"):
                obj = TsfConfigCenter()
                obj._deserialize(item)
                self._ConfigCenters.append(obj)
        self._DaulStatus = params.get("DaulStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfigReleaseLog(AbstractModel):
    """配置项发布日志

    """

    def __init__(self):
        r"""
        :param _ConfigReleaseLogId: 配置项发布日志ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigReleaseLogId: str
        :param _ConfigId: 配置项ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigId: str
        :param _ConfigName: 配置项名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigName: str
        :param _ConfigVersion: 配置项版本
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigVersion: str
        :param _GroupId: 部署组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupId: str
        :param _GroupName: 部署组名称
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupName: str
        :param _NamespaceId: 命名空间ID
注意：此字段可能返回 null，表示取不到有效值。
        :type NamespaceId: str
        :param _NamespaceName: 命名空间名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NamespaceName: str
        :param _ClusterId: 集群ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterId: str
        :param _ClusterName: 集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterName: str
        :param _ReleaseTime: 发布时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ReleaseTime: str
        :param _ReleaseDesc: 发布描述
注意：此字段可能返回 null，表示取不到有效值。
        :type ReleaseDesc: str
        :param _ReleaseStatus: 发布状态
注意：此字段可能返回 null，表示取不到有效值。
        :type ReleaseStatus: str
        :param _LastConfigId: 上次发布的配置项ID
注意：此字段可能返回 null，表示取不到有效值。
        :type LastConfigId: str
        :param _LastConfigName: 上次发布的配置项名称
注意：此字段可能返回 null，表示取不到有效值。
        :type LastConfigName: str
        :param _LastConfigVersion: 上次发布的配置项版本
注意：此字段可能返回 null，表示取不到有效值。
        :type LastConfigVersion: str
        :param _RollbackFlag: 回滚标识
注意：此字段可能返回 null，表示取不到有效值。
        :type RollbackFlag: bool
        :param _ReleasedConfigCenter: 发布成功的配置中心
 ALL/EXCLUSIVE/SHARE/NONE

全部发布成功，独占发布成功，共享发布成功，全部发布失败
注意：此字段可能返回 null，表示取不到有效值。
        :type ReleasedConfigCenter: str
        """
        self._ConfigReleaseLogId = None
        self._ConfigId = None
        self._ConfigName = None
        self._ConfigVersion = None
        self._GroupId = None
        self._GroupName = None
        self._NamespaceId = None
        self._NamespaceName = None
        self._ClusterId = None
        self._ClusterName = None
        self._ReleaseTime = None
        self._ReleaseDesc = None
        self._ReleaseStatus = None
        self._LastConfigId = None
        self._LastConfigName = None
        self._LastConfigVersion = None
        self._RollbackFlag = None
        self._ReleasedConfigCenter = None

    @property
    def ConfigReleaseLogId(self):
        """配置项发布日志ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigReleaseLogId

    @ConfigReleaseLogId.setter
    def ConfigReleaseLogId(self, ConfigReleaseLogId):
        self._ConfigReleaseLogId = ConfigReleaseLogId

    @property
    def ConfigId(self):
        """配置项ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def ConfigName(self):
        """配置项名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigVersion(self):
        """配置项版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigVersion

    @ConfigVersion.setter
    def ConfigVersion(self, ConfigVersion):
        self._ConfigVersion = ConfigVersion

    @property
    def GroupId(self):
        """部署组ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupName(self):
        """部署组名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def NamespaceId(self):
        """命名空间ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def NamespaceName(self):
        """命名空间名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def ClusterId(self):
        """集群ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        """集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ReleaseTime(self):
        """发布时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReleaseTime

    @ReleaseTime.setter
    def ReleaseTime(self, ReleaseTime):
        self._ReleaseTime = ReleaseTime

    @property
    def ReleaseDesc(self):
        """发布描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReleaseDesc

    @ReleaseDesc.setter
    def ReleaseDesc(self, ReleaseDesc):
        self._ReleaseDesc = ReleaseDesc

    @property
    def ReleaseStatus(self):
        """发布状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReleaseStatus

    @ReleaseStatus.setter
    def ReleaseStatus(self, ReleaseStatus):
        self._ReleaseStatus = ReleaseStatus

    @property
    def LastConfigId(self):
        """上次发布的配置项ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LastConfigId

    @LastConfigId.setter
    def LastConfigId(self, LastConfigId):
        self._LastConfigId = LastConfigId

    @property
    def LastConfigName(self):
        """上次发布的配置项名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LastConfigName

    @LastConfigName.setter
    def LastConfigName(self, LastConfigName):
        self._LastConfigName = LastConfigName

    @property
    def LastConfigVersion(self):
        """上次发布的配置项版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LastConfigVersion

    @LastConfigVersion.setter
    def LastConfigVersion(self, LastConfigVersion):
        self._LastConfigVersion = LastConfigVersion

    @property
    def RollbackFlag(self):
        """回滚标识
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._RollbackFlag

    @RollbackFlag.setter
    def RollbackFlag(self, RollbackFlag):
        self._RollbackFlag = RollbackFlag

    @property
    def ReleasedConfigCenter(self):
        """发布成功的配置中心
 ALL/EXCLUSIVE/SHARE/NONE

全部发布成功，独占发布成功，共享发布成功，全部发布失败
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReleasedConfigCenter

    @ReleasedConfigCenter.setter
    def ReleasedConfigCenter(self, ReleasedConfigCenter):
        self._ReleasedConfigCenter = ReleasedConfigCenter


    def _deserialize(self, params):
        self._ConfigReleaseLogId = params.get("ConfigReleaseLogId")
        self._ConfigId = params.get("ConfigId")
        self._ConfigName = params.get("ConfigName")
        self._ConfigVersion = params.get("ConfigVersion")
        self._GroupId = params.get("GroupId")
        self._GroupName = params.get("GroupName")
        self._NamespaceId = params.get("NamespaceId")
        self._NamespaceName = params.get("NamespaceName")
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._ReleaseTime = params.get("ReleaseTime")
        self._ReleaseDesc = params.get("ReleaseDesc")
        self._ReleaseStatus = params.get("ReleaseStatus")
        self._LastConfigId = params.get("LastConfigId")
        self._LastConfigName = params.get("LastConfigName")
        self._LastConfigVersion = params.get("LastConfigVersion")
        self._RollbackFlag = params.get("RollbackFlag")
        self._ReleasedConfigCenter = params.get("ReleasedConfigCenter")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfigTemplate(AbstractModel):
    """配置模板对象

    """

    def __init__(self):
        r"""
        :param _ConfigTemplateId: 配置模板Id
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigTemplateId: str
        :param _ConfigTemplateName: 配置模板名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigTemplateName: str
        :param _ConfigTemplateDesc: 配置模板描述
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigTemplateDesc: str
        :param _ConfigTemplateType: 配置模板对应的微服务框架
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigTemplateType: str
        :param _ConfigTemplateValue: 配置模板数据
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigTemplateValue: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        """
        self._ConfigTemplateId = None
        self._ConfigTemplateName = None
        self._ConfigTemplateDesc = None
        self._ConfigTemplateType = None
        self._ConfigTemplateValue = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def ConfigTemplateId(self):
        """配置模板Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigTemplateId

    @ConfigTemplateId.setter
    def ConfigTemplateId(self, ConfigTemplateId):
        self._ConfigTemplateId = ConfigTemplateId

    @property
    def ConfigTemplateName(self):
        """配置模板名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigTemplateName

    @ConfigTemplateName.setter
    def ConfigTemplateName(self, ConfigTemplateName):
        self._ConfigTemplateName = ConfigTemplateName

    @property
    def ConfigTemplateDesc(self):
        """配置模板描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigTemplateDesc

    @ConfigTemplateDesc.setter
    def ConfigTemplateDesc(self, ConfigTemplateDesc):
        self._ConfigTemplateDesc = ConfigTemplateDesc

    @property
    def ConfigTemplateType(self):
        """配置模板对应的微服务框架
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigTemplateType

    @ConfigTemplateType.setter
    def ConfigTemplateType(self, ConfigTemplateType):
        self._ConfigTemplateType = ConfigTemplateType

    @property
    def ConfigTemplateValue(self):
        """配置模板数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigTemplateValue

    @ConfigTemplateValue.setter
    def ConfigTemplateValue(self, ConfigTemplateValue):
        self._ConfigTemplateValue = ConfigTemplateValue

    @property
    def CreateTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._ConfigTemplateId = params.get("ConfigTemplateId")
        self._ConfigTemplateName = params.get("ConfigTemplateName")
        self._ConfigTemplateDesc = params.get("ConfigTemplateDesc")
        self._ConfigTemplateType = params.get("ConfigTemplateType")
        self._ConfigTemplateValue = params.get("ConfigTemplateValue")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainGroup(AbstractModel):
    """部署组列表（应用下钻界面的）

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID
        :type GroupId: str
        :param _GroupName: 分组名称
        :type GroupName: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _Server: 镜像server
        :type Server: str
        :param _RepoName: 镜像名，如/tsf/nginx
        :type RepoName: str
        :param _TagName: 镜像版本名称
        :type TagName: str
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _NamespaceId: 命名空间ID
        :type NamespaceId: str
        :param _NamespaceName: 命名空间名称
        :type NamespaceName: str
        :param _CpuRequest: 初始分配的 CPU 核数，对应 K8S request
        :type CpuRequest: str
        :param _CpuLimit: 最大分配的 CPU 核数，对应 K8S limit
        :type CpuLimit: str
        :param _MemRequest: 初始分配的内存 MiB 数，对应 K8S request
        :type MemRequest: str
        :param _MemLimit: 最大分配的内存 MiB 数，对应 K8S limit
        :type MemLimit: str
        :param _Alias: 部署组备注
        :type Alias: str
        :param _KubeInjectEnable: KubeInjectEnable值
        :type KubeInjectEnable: bool
        :param _UpdatedTime: 更新时间
        :type UpdatedTime: str
        """
        self._GroupId = None
        self._GroupName = None
        self._CreateTime = None
        self._Server = None
        self._RepoName = None
        self._TagName = None
        self._ClusterId = None
        self._ClusterName = None
        self._NamespaceId = None
        self._NamespaceName = None
        self._CpuRequest = None
        self._CpuLimit = None
        self._MemRequest = None
        self._MemLimit = None
        self._Alias = None
        self._KubeInjectEnable = None
        self._UpdatedTime = None

    @property
    def GroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupName(self):
        """分组名称
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def CreateTime(self):
        """创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Server(self):
        """镜像server
        :rtype: str
        """
        return self._Server

    @Server.setter
    def Server(self, Server):
        self._Server = Server

    @property
    def RepoName(self):
        """镜像名，如/tsf/nginx
        :rtype: str
        """
        return self._RepoName

    @RepoName.setter
    def RepoName(self, RepoName):
        self._RepoName = RepoName

    @property
    def TagName(self):
        """镜像版本名称
        :rtype: str
        """
        return self._TagName

    @TagName.setter
    def TagName(self, TagName):
        self._TagName = TagName

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        """集群名称
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def NamespaceId(self):
        """命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def NamespaceName(self):
        """命名空间名称
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def CpuRequest(self):
        """初始分配的 CPU 核数，对应 K8S request
        :rtype: str
        """
        return self._CpuRequest

    @CpuRequest.setter
    def CpuRequest(self, CpuRequest):
        self._CpuRequest = CpuRequest

    @property
    def CpuLimit(self):
        """最大分配的 CPU 核数，对应 K8S limit
        :rtype: str
        """
        return self._CpuLimit

    @CpuLimit.setter
    def CpuLimit(self, CpuLimit):
        self._CpuLimit = CpuLimit

    @property
    def MemRequest(self):
        """初始分配的内存 MiB 数，对应 K8S request
        :rtype: str
        """
        return self._MemRequest

    @MemRequest.setter
    def MemRequest(self, MemRequest):
        self._MemRequest = MemRequest

    @property
    def MemLimit(self):
        """最大分配的内存 MiB 数，对应 K8S limit
        :rtype: str
        """
        return self._MemLimit

    @MemLimit.setter
    def MemLimit(self, MemLimit):
        self._MemLimit = MemLimit

    @property
    def Alias(self):
        """部署组备注
        :rtype: str
        """
        return self._Alias

    @Alias.setter
    def Alias(self, Alias):
        self._Alias = Alias

    @property
    def KubeInjectEnable(self):
        """KubeInjectEnable值
        :rtype: bool
        """
        return self._KubeInjectEnable

    @KubeInjectEnable.setter
    def KubeInjectEnable(self, KubeInjectEnable):
        self._KubeInjectEnable = KubeInjectEnable

    @property
    def UpdatedTime(self):
        """更新时间
        :rtype: str
        """
        return self._UpdatedTime

    @UpdatedTime.setter
    def UpdatedTime(self, UpdatedTime):
        self._UpdatedTime = UpdatedTime


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._GroupName = params.get("GroupName")
        self._CreateTime = params.get("CreateTime")
        self._Server = params.get("Server")
        self._RepoName = params.get("RepoName")
        self._TagName = params.get("TagName")
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._NamespaceId = params.get("NamespaceId")
        self._NamespaceName = params.get("NamespaceName")
        self._CpuRequest = params.get("CpuRequest")
        self._CpuLimit = params.get("CpuLimit")
        self._MemRequest = params.get("MemRequest")
        self._MemLimit = params.get("MemLimit")
        self._Alias = params.get("Alias")
        self._KubeInjectEnable = params.get("KubeInjectEnable")
        self._UpdatedTime = params.get("UpdatedTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainGroupResult(AbstractModel):
    """部署组列表（应用下钻）

    """

    def __init__(self):
        r"""
        :param _Content: 部署组列表
        :type Content: list of ContainGroup
        :param _TotalCount: 总记录数
        :type TotalCount: int
        """
        self._Content = None
        self._TotalCount = None

    @property
    def Content(self):
        """部署组列表
        :rtype: list of ContainGroup
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def TotalCount(self):
        """总记录数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        if params.get("Content") is not None:
            self._Content = []
            for item in params.get("Content"):
                obj = ContainGroup()
                obj._deserialize(item)
                self._Content.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerEvent(AbstractModel):
    """返回容器的事件，比如 k8s deployment 或者 pod 的 events

    """

    def __init__(self):
        r"""
        :param _FirstTimestamp: 第一次出现的时间，以 ms 为单位的时间戳
        :type FirstTimestamp: int
        :param _LastTimestamp: 最后一次出现的时间，以 ms 为单位的时间戳
        :type LastTimestamp: int
        :param _Type: 级别
        :type Type: str
        :param _Kind: 资源类型
        :type Kind: str
        :param _Name: 资源名称
        :type Name: str
        :param _Reason: 内容
        :type Reason: str
        :param _Message: 详细描述
        :type Message: str
        :param _Count: 出现次数
        :type Count: int
        """
        self._FirstTimestamp = None
        self._LastTimestamp = None
        self._Type = None
        self._Kind = None
        self._Name = None
        self._Reason = None
        self._Message = None
        self._Count = None

    @property
    def FirstTimestamp(self):
        """第一次出现的时间，以 ms 为单位的时间戳
        :rtype: int
        """
        return self._FirstTimestamp

    @FirstTimestamp.setter
    def FirstTimestamp(self, FirstTimestamp):
        self._FirstTimestamp = FirstTimestamp

    @property
    def LastTimestamp(self):
        """最后一次出现的时间，以 ms 为单位的时间戳
        :rtype: int
        """
        return self._LastTimestamp

    @LastTimestamp.setter
    def LastTimestamp(self, LastTimestamp):
        self._LastTimestamp = LastTimestamp

    @property
    def Type(self):
        """级别
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Kind(self):
        """资源类型
        :rtype: str
        """
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def Name(self):
        """资源名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Reason(self):
        """内容
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def Message(self):
        """详细描述
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Count(self):
        """出现次数
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count


    def _deserialize(self, params):
        self._FirstTimestamp = params.get("FirstTimestamp")
        self._LastTimestamp = params.get("LastTimestamp")
        self._Type = params.get("Type")
        self._Kind = params.get("Kind")
        self._Name = params.get("Name")
        self._Reason = params.get("Reason")
        self._Message = params.get("Message")
        self._Count = params.get("Count")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerGroupDeploy(AbstractModel):
    """获取部署组

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组id
        :type GroupId: str
        :param _GroupName: 分组名称
        :type GroupName: str
        :param _InstanceNum: 实例总数
        :type InstanceNum: int
        :param _CurrentNum: 已启动实例总数
        :type CurrentNum: int
        :param _Server: 镜像server
注意：此字段可能返回 null，表示取不到有效值。
        :type Server: str
        :param _Reponame: 镜像名，如/tsf/nginx
注意：此字段可能返回 null，表示取不到有效值。
        :type Reponame: str
        :param _TagName: 镜像版本名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TagName: str
        :param _CpuRequest: 业务容器初始分配的 CPU 核数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :type CpuRequest: str
        :param _CpuLimit: 业务容器最大分配的 CPU 核数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :type CpuLimit: str
        :param _MemRequest: 业务容器初始分配的内存 MiB 数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :type MemRequest: str
        :param _MemLimit: 业务容器最大分配的内存 MiB 数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :type MemLimit: str
        :param _AccessType: 0:公网 1:集群内访问 2：NodePort
注意：此字段可能返回 null，表示取不到有效值。
        :type AccessType: int
        :param _ProtocolPorts: 端口映射
        :type ProtocolPorts: list of ProtocolPort
        :param _UpdateType: 更新方式：0:快速更新 1:滚动更新
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateType: int
        :param _UpdateIvl: 更新间隔,单位秒
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateIvl: int
        :param _JvmOpts: jvm参数
注意：此字段可能返回 null，表示取不到有效值。
        :type JvmOpts: str
        :param _SubnetId: 子网id
注意：此字段可能返回 null，表示取不到有效值。
        :type SubnetId: str
        :param _AgentCpuRequest: agent容器初始分配的 CPU 核数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentCpuRequest: str
        :param _AgentCpuLimit: agent容器最大分配的 CPU 核数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentCpuLimit: str
        :param _AgentMemRequest: agent容器初始分配的内存 MiB 数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentMemRequest: str
        :param _AgentMemLimit: agent容器最大分配的内存 MiB 数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentMemLimit: str
        :param _IstioCpuRequest: istioproxy容器初始分配的 CPU 核数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :type IstioCpuRequest: str
        :param _IstioCpuLimit: istioproxy容器最大分配的 CPU 核数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :type IstioCpuLimit: str
        :param _IstioMemRequest: istioproxy容器初始分配的内存 MiB 数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :type IstioMemRequest: str
        :param _IstioMemLimit: istioproxy容器最大分配的内存 MiB 数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :type IstioMemLimit: str
        :param _Envs: 部署组的环境变量数组，这里没有展示 tsf 使用的环境变量，只展示了用户设置的环境变量。
注意：此字段可能返回 null，表示取不到有效值。
        :type Envs: list of Env
        :param _HealthCheckSettings: 健康检查配置信息，若不指定该参数，则默认不设置健康检查。
注意：此字段可能返回 null，表示取不到有效值。
        :type HealthCheckSettings: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSettings`
        :param _DeployAgent: 是否部署Agent容器
        :type DeployAgent: bool
        :param _Alias: 部署组备注
注意：此字段可能返回 null，表示取不到有效值。
        :type Alias: str
        :param _DisableService: 是否创建 k8s service
        :type DisableService: bool
        :param _HeadlessService: service 是否为 headless 类型
        :type HeadlessService: bool
        :param _TcrRepoInfo: TcrRepoInfo值
注意：此字段可能返回 null，表示取不到有效值。
        :type TcrRepoInfo: :class:`tencentcloud.tsf.v20180326.models.TcrRepoInfo`
        :param _VolumeInfos: 数据卷信息，list
注意：此字段可能返回 null，表示取不到有效值。
        :type VolumeInfos: list of VolumeInfo
        :param _VolumeMountInfos: 数据卷挂载信息，list
注意：此字段可能返回 null，表示取不到有效值。
        :type VolumeMountInfos: list of VolumeMountInfo
        :param _KubeInjectEnable: KubeInjectEnable值
注意：此字段可能返回 null，表示取不到有效值。
        :type KubeInjectEnable: bool
        :param _RepoType: 仓库类型 (person, tcr)
        :type RepoType: str
        :param _WarmupSetting: 预热配置设置
        :type WarmupSetting: :class:`tencentcloud.tsf.v20180326.models.WarmupSetting`
        :param _GatewayConfig: Envoy网关服务配置
注意：此字段可能返回 null，表示取不到有效值。
        :type GatewayConfig: :class:`tencentcloud.tsf.v20180326.models.GatewayConfig`
        :param _ContainerName: 容器名称
        :type ContainerName: str
        :param _AdditionalContainerList: 附加容器列表
        :type AdditionalContainerList: list of GroupContainerInfo
        :param _InternalContainerList: 内部容器列表
        :type InternalContainerList: list of GroupContainerInfo
        :param _ServiceSettingList: service列表
        :type ServiceSettingList: list of ServiceSetting
        """
        self._GroupId = None
        self._GroupName = None
        self._InstanceNum = None
        self._CurrentNum = None
        self._Server = None
        self._Reponame = None
        self._TagName = None
        self._CpuRequest = None
        self._CpuLimit = None
        self._MemRequest = None
        self._MemLimit = None
        self._AccessType = None
        self._ProtocolPorts = None
        self._UpdateType = None
        self._UpdateIvl = None
        self._JvmOpts = None
        self._SubnetId = None
        self._AgentCpuRequest = None
        self._AgentCpuLimit = None
        self._AgentMemRequest = None
        self._AgentMemLimit = None
        self._IstioCpuRequest = None
        self._IstioCpuLimit = None
        self._IstioMemRequest = None
        self._IstioMemLimit = None
        self._Envs = None
        self._HealthCheckSettings = None
        self._DeployAgent = None
        self._Alias = None
        self._DisableService = None
        self._HeadlessService = None
        self._TcrRepoInfo = None
        self._VolumeInfos = None
        self._VolumeMountInfos = None
        self._KubeInjectEnable = None
        self._RepoType = None
        self._WarmupSetting = None
        self._GatewayConfig = None
        self._ContainerName = None
        self._AdditionalContainerList = None
        self._InternalContainerList = None
        self._ServiceSettingList = None

    @property
    def GroupId(self):
        """部署组id
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupName(self):
        """分组名称
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def InstanceNum(self):
        """实例总数
        :rtype: int
        """
        return self._InstanceNum

    @InstanceNum.setter
    def InstanceNum(self, InstanceNum):
        self._InstanceNum = InstanceNum

    @property
    def CurrentNum(self):
        """已启动实例总数
        :rtype: int
        """
        return self._CurrentNum

    @CurrentNum.setter
    def CurrentNum(self, CurrentNum):
        self._CurrentNum = CurrentNum

    @property
    def Server(self):
        """镜像server
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Server

    @Server.setter
    def Server(self, Server):
        self._Server = Server

    @property
    def Reponame(self):
        """镜像名，如/tsf/nginx
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Reponame

    @Reponame.setter
    def Reponame(self, Reponame):
        self._Reponame = Reponame

    @property
    def TagName(self):
        """镜像版本名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TagName

    @TagName.setter
    def TagName(self, TagName):
        self._TagName = TagName

    @property
    def CpuRequest(self):
        """业务容器初始分配的 CPU 核数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CpuRequest

    @CpuRequest.setter
    def CpuRequest(self, CpuRequest):
        self._CpuRequest = CpuRequest

    @property
    def CpuLimit(self):
        """业务容器最大分配的 CPU 核数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CpuLimit

    @CpuLimit.setter
    def CpuLimit(self, CpuLimit):
        self._CpuLimit = CpuLimit

    @property
    def MemRequest(self):
        """业务容器初始分配的内存 MiB 数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MemRequest

    @MemRequest.setter
    def MemRequest(self, MemRequest):
        self._MemRequest = MemRequest

    @property
    def MemLimit(self):
        """业务容器最大分配的内存 MiB 数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MemLimit

    @MemLimit.setter
    def MemLimit(self, MemLimit):
        self._MemLimit = MemLimit

    @property
    def AccessType(self):
        """0:公网 1:集群内访问 2：NodePort
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._AccessType

    @AccessType.setter
    def AccessType(self, AccessType):
        self._AccessType = AccessType

    @property
    def ProtocolPorts(self):
        """端口映射
        :rtype: list of ProtocolPort
        """
        return self._ProtocolPorts

    @ProtocolPorts.setter
    def ProtocolPorts(self, ProtocolPorts):
        self._ProtocolPorts = ProtocolPorts

    @property
    def UpdateType(self):
        """更新方式：0:快速更新 1:滚动更新
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._UpdateType

    @UpdateType.setter
    def UpdateType(self, UpdateType):
        self._UpdateType = UpdateType

    @property
    def UpdateIvl(self):
        """更新间隔,单位秒
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._UpdateIvl

    @UpdateIvl.setter
    def UpdateIvl(self, UpdateIvl):
        self._UpdateIvl = UpdateIvl

    @property
    def JvmOpts(self):
        """jvm参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._JvmOpts

    @JvmOpts.setter
    def JvmOpts(self, JvmOpts):
        self._JvmOpts = JvmOpts

    @property
    def SubnetId(self):
        """子网id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def AgentCpuRequest(self):
        """agent容器初始分配的 CPU 核数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AgentCpuRequest

    @AgentCpuRequest.setter
    def AgentCpuRequest(self, AgentCpuRequest):
        self._AgentCpuRequest = AgentCpuRequest

    @property
    def AgentCpuLimit(self):
        """agent容器最大分配的 CPU 核数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AgentCpuLimit

    @AgentCpuLimit.setter
    def AgentCpuLimit(self, AgentCpuLimit):
        self._AgentCpuLimit = AgentCpuLimit

    @property
    def AgentMemRequest(self):
        """agent容器初始分配的内存 MiB 数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AgentMemRequest

    @AgentMemRequest.setter
    def AgentMemRequest(self, AgentMemRequest):
        self._AgentMemRequest = AgentMemRequest

    @property
    def AgentMemLimit(self):
        """agent容器最大分配的内存 MiB 数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AgentMemLimit

    @AgentMemLimit.setter
    def AgentMemLimit(self, AgentMemLimit):
        self._AgentMemLimit = AgentMemLimit

    @property
    def IstioCpuRequest(self):
        """istioproxy容器初始分配的 CPU 核数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._IstioCpuRequest

    @IstioCpuRequest.setter
    def IstioCpuRequest(self, IstioCpuRequest):
        self._IstioCpuRequest = IstioCpuRequest

    @property
    def IstioCpuLimit(self):
        """istioproxy容器最大分配的 CPU 核数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._IstioCpuLimit

    @IstioCpuLimit.setter
    def IstioCpuLimit(self, IstioCpuLimit):
        self._IstioCpuLimit = IstioCpuLimit

    @property
    def IstioMemRequest(self):
        """istioproxy容器初始分配的内存 MiB 数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._IstioMemRequest

    @IstioMemRequest.setter
    def IstioMemRequest(self, IstioMemRequest):
        self._IstioMemRequest = IstioMemRequest

    @property
    def IstioMemLimit(self):
        """istioproxy容器最大分配的内存 MiB 数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._IstioMemLimit

    @IstioMemLimit.setter
    def IstioMemLimit(self, IstioMemLimit):
        self._IstioMemLimit = IstioMemLimit

    @property
    def Envs(self):
        """部署组的环境变量数组，这里没有展示 tsf 使用的环境变量，只展示了用户设置的环境变量。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Env
        """
        return self._Envs

    @Envs.setter
    def Envs(self, Envs):
        self._Envs = Envs

    @property
    def HealthCheckSettings(self):
        """健康检查配置信息，若不指定该参数，则默认不设置健康检查。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSettings`
        """
        return self._HealthCheckSettings

    @HealthCheckSettings.setter
    def HealthCheckSettings(self, HealthCheckSettings):
        self._HealthCheckSettings = HealthCheckSettings

    @property
    def DeployAgent(self):
        """是否部署Agent容器
        :rtype: bool
        """
        return self._DeployAgent

    @DeployAgent.setter
    def DeployAgent(self, DeployAgent):
        self._DeployAgent = DeployAgent

    @property
    def Alias(self):
        """部署组备注
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Alias

    @Alias.setter
    def Alias(self, Alias):
        self._Alias = Alias

    @property
    def DisableService(self):
        """是否创建 k8s service
        :rtype: bool
        """
        return self._DisableService

    @DisableService.setter
    def DisableService(self, DisableService):
        self._DisableService = DisableService

    @property
    def HeadlessService(self):
        """service 是否为 headless 类型
        :rtype: bool
        """
        return self._HeadlessService

    @HeadlessService.setter
    def HeadlessService(self, HeadlessService):
        self._HeadlessService = HeadlessService

    @property
    def TcrRepoInfo(self):
        """TcrRepoInfo值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TcrRepoInfo`
        """
        return self._TcrRepoInfo

    @TcrRepoInfo.setter
    def TcrRepoInfo(self, TcrRepoInfo):
        self._TcrRepoInfo = TcrRepoInfo

    @property
    def VolumeInfos(self):
        """数据卷信息，list
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of VolumeInfo
        """
        return self._VolumeInfos

    @VolumeInfos.setter
    def VolumeInfos(self, VolumeInfos):
        self._VolumeInfos = VolumeInfos

    @property
    def VolumeMountInfos(self):
        """数据卷挂载信息，list
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of VolumeMountInfo
        """
        return self._VolumeMountInfos

    @VolumeMountInfos.setter
    def VolumeMountInfos(self, VolumeMountInfos):
        self._VolumeMountInfos = VolumeMountInfos

    @property
    def KubeInjectEnable(self):
        """KubeInjectEnable值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._KubeInjectEnable

    @KubeInjectEnable.setter
    def KubeInjectEnable(self, KubeInjectEnable):
        self._KubeInjectEnable = KubeInjectEnable

    @property
    def RepoType(self):
        """仓库类型 (person, tcr)
        :rtype: str
        """
        return self._RepoType

    @RepoType.setter
    def RepoType(self, RepoType):
        self._RepoType = RepoType

    @property
    def WarmupSetting(self):
        """预热配置设置
        :rtype: :class:`tencentcloud.tsf.v20180326.models.WarmupSetting`
        """
        return self._WarmupSetting

    @WarmupSetting.setter
    def WarmupSetting(self, WarmupSetting):
        self._WarmupSetting = WarmupSetting

    @property
    def GatewayConfig(self):
        """Envoy网关服务配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.GatewayConfig`
        """
        return self._GatewayConfig

    @GatewayConfig.setter
    def GatewayConfig(self, GatewayConfig):
        self._GatewayConfig = GatewayConfig

    @property
    def ContainerName(self):
        """容器名称
        :rtype: str
        """
        return self._ContainerName

    @ContainerName.setter
    def ContainerName(self, ContainerName):
        self._ContainerName = ContainerName

    @property
    def AdditionalContainerList(self):
        """附加容器列表
        :rtype: list of GroupContainerInfo
        """
        return self._AdditionalContainerList

    @AdditionalContainerList.setter
    def AdditionalContainerList(self, AdditionalContainerList):
        self._AdditionalContainerList = AdditionalContainerList

    @property
    def InternalContainerList(self):
        """内部容器列表
        :rtype: list of GroupContainerInfo
        """
        return self._InternalContainerList

    @InternalContainerList.setter
    def InternalContainerList(self, InternalContainerList):
        self._InternalContainerList = InternalContainerList

    @property
    def ServiceSettingList(self):
        """service列表
        :rtype: list of ServiceSetting
        """
        return self._ServiceSettingList

    @ServiceSettingList.setter
    def ServiceSettingList(self, ServiceSettingList):
        self._ServiceSettingList = ServiceSettingList


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._GroupName = params.get("GroupName")
        self._InstanceNum = params.get("InstanceNum")
        self._CurrentNum = params.get("CurrentNum")
        self._Server = params.get("Server")
        self._Reponame = params.get("Reponame")
        self._TagName = params.get("TagName")
        self._CpuRequest = params.get("CpuRequest")
        self._CpuLimit = params.get("CpuLimit")
        self._MemRequest = params.get("MemRequest")
        self._MemLimit = params.get("MemLimit")
        self._AccessType = params.get("AccessType")
        if params.get("ProtocolPorts") is not None:
            self._ProtocolPorts = []
            for item in params.get("ProtocolPorts"):
                obj = ProtocolPort()
                obj._deserialize(item)
                self._ProtocolPorts.append(obj)
        self._UpdateType = params.get("UpdateType")
        self._UpdateIvl = params.get("UpdateIvl")
        self._JvmOpts = params.get("JvmOpts")
        self._SubnetId = params.get("SubnetId")
        self._AgentCpuRequest = params.get("AgentCpuRequest")
        self._AgentCpuLimit = params.get("AgentCpuLimit")
        self._AgentMemRequest = params.get("AgentMemRequest")
        self._AgentMemLimit = params.get("AgentMemLimit")
        self._IstioCpuRequest = params.get("IstioCpuRequest")
        self._IstioCpuLimit = params.get("IstioCpuLimit")
        self._IstioMemRequest = params.get("IstioMemRequest")
        self._IstioMemLimit = params.get("IstioMemLimit")
        if params.get("Envs") is not None:
            self._Envs = []
            for item in params.get("Envs"):
                obj = Env()
                obj._deserialize(item)
                self._Envs.append(obj)
        if params.get("HealthCheckSettings") is not None:
            self._HealthCheckSettings = HealthCheckSettings()
            self._HealthCheckSettings._deserialize(params.get("HealthCheckSettings"))
        self._DeployAgent = params.get("DeployAgent")
        self._Alias = params.get("Alias")
        self._DisableService = params.get("DisableService")
        self._HeadlessService = params.get("HeadlessService")
        if params.get("TcrRepoInfo") is not None:
            self._TcrRepoInfo = TcrRepoInfo()
            self._TcrRepoInfo._deserialize(params.get("TcrRepoInfo"))
        if params.get("VolumeInfos") is not None:
            self._VolumeInfos = []
            for item in params.get("VolumeInfos"):
                obj = VolumeInfo()
                obj._deserialize(item)
                self._VolumeInfos.append(obj)
        if params.get("VolumeMountInfos") is not None:
            self._VolumeMountInfos = []
            for item in params.get("VolumeMountInfos"):
                obj = VolumeMountInfo()
                obj._deserialize(item)
                self._VolumeMountInfos.append(obj)
        self._KubeInjectEnable = params.get("KubeInjectEnable")
        self._RepoType = params.get("RepoType")
        if params.get("WarmupSetting") is not None:
            self._WarmupSetting = WarmupSetting()
            self._WarmupSetting._deserialize(params.get("WarmupSetting"))
        if params.get("GatewayConfig") is not None:
            self._GatewayConfig = GatewayConfig()
            self._GatewayConfig._deserialize(params.get("GatewayConfig"))
        self._ContainerName = params.get("ContainerName")
        if params.get("AdditionalContainerList") is not None:
            self._AdditionalContainerList = []
            for item in params.get("AdditionalContainerList"):
                obj = GroupContainerInfo()
                obj._deserialize(item)
                self._AdditionalContainerList.append(obj)
        if params.get("InternalContainerList") is not None:
            self._InternalContainerList = []
            for item in params.get("InternalContainerList"):
                obj = GroupContainerInfo()
                obj._deserialize(item)
                self._InternalContainerList.append(obj)
        if params.get("ServiceSettingList") is not None:
            self._ServiceSettingList = []
            for item in params.get("ServiceSettingList"):
                obj = ServiceSetting()
                obj._deserialize(item)
                self._ServiceSettingList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerGroupDetail(AbstractModel):
    """容器部署组详情

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID
        :type GroupId: str
        :param _GroupName: 分组名称
        :type GroupName: str
        :param _InstanceNum: 实例总数
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceNum: int
        :param _CurrentNum: 已启动实例总数
        :type CurrentNum: int
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _Server: 镜像server
注意：此字段可能返回 null，表示取不到有效值。
        :type Server: str
        :param _Reponame: 镜像名，如/tsf/nginx
注意：此字段可能返回 null，表示取不到有效值。
        :type Reponame: str
        :param _TagName: 镜像版本名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TagName: str
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _NamespaceId: 命名空间ID
        :type NamespaceId: str
        :param _NamespaceName: 命名空间名称
        :type NamespaceName: str
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        :param _LbIp: 负载均衡ip
        :type LbIp: str
        :param _ApplicationType: 应用类型
        :type ApplicationType: str
        :param _ClusterIp: Service ip
        :type ClusterIp: str
        :param _NodePort: NodePort端口，只有公网和NodePort访问方式才有值
注意：此字段可能返回 null，表示取不到有效值。
        :type NodePort: int
        :param _CpuLimit: 最大分配的 CPU 核数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :type CpuLimit: str
        :param _MemLimit: 最大分配的内存 MiB 数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :type MemLimit: str
        :param _AccessType: 0:公网 1:集群内访问 2：NodePort
注意：此字段可能返回 null，表示取不到有效值。
        :type AccessType: int
        :param _UpdateType: 更新方式：0:快速更新 1:滚动更新
        :type UpdateType: int
        :param _UpdateIvl: 更新间隔,单位秒
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateIvl: int
        :param _ProtocolPorts: 端口数组对象
        :type ProtocolPorts: list of ProtocolPort
        :param _Envs: 环境变量数组对象
        :type Envs: list of Env
        :param _ApplicationName: 应用名称
        :type ApplicationName: str
        :param _Message: pod错误信息描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Message: str
        :param _Status: 部署组状态
        :type Status: str
        :param _MicroserviceType: 服务类型
        :type MicroserviceType: str
        :param _CpuRequest: 初始分配的 CPU 核数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :type CpuRequest: str
        :param _MemRequest: 初始分配的内存 MiB 数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :type MemRequest: str
        :param _SubnetId: 子网id
注意：此字段可能返回 null，表示取不到有效值。
        :type SubnetId: str
        :param _GroupResourceType: 部署组资源类型
        :type GroupResourceType: str
        :param _InstanceCount: 部署组实例个数
        :type InstanceCount: int
        :param _UpdatedTime: 部署组更新时间戳
        :type UpdatedTime: int
        :param _MaxSurge: kubernetes滚动更新策略的MaxSurge参数
注意：此字段可能返回 null，表示取不到有效值。
        :type MaxSurge: str
        :param _MaxUnavailable: kubernetes滚动更新策略的MaxUnavailable参数
注意：此字段可能返回 null，表示取不到有效值。
        :type MaxUnavailable: str
        :param _HealthCheckSettings: 部署组健康检查设置
注意：此字段可能返回 null，表示取不到有效值。
        :type HealthCheckSettings: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSettings`
        :param _AllowPlainYamlDeploy: 允许PlainYamlDeploy
        :type AllowPlainYamlDeploy: bool
        :param _IsNotEqualServiceConfig: 是否不等于ServiceConfig
注意：此字段可能返回 null，表示取不到有效值。
        :type IsNotEqualServiceConfig: bool
        :param _RepoName: 仓库名
注意：此字段可能返回 null，表示取不到有效值。
        :type RepoName: str
        :param _Alias: 别名
注意：此字段可能返回 null，表示取不到有效值。
        :type Alias: str
        """
        self._GroupId = None
        self._GroupName = None
        self._InstanceNum = None
        self._CurrentNum = None
        self._CreateTime = None
        self._Server = None
        self._Reponame = None
        self._TagName = None
        self._ClusterId = None
        self._ClusterName = None
        self._NamespaceId = None
        self._NamespaceName = None
        self._ApplicationId = None
        self._LbIp = None
        self._ApplicationType = None
        self._ClusterIp = None
        self._NodePort = None
        self._CpuLimit = None
        self._MemLimit = None
        self._AccessType = None
        self._UpdateType = None
        self._UpdateIvl = None
        self._ProtocolPorts = None
        self._Envs = None
        self._ApplicationName = None
        self._Message = None
        self._Status = None
        self._MicroserviceType = None
        self._CpuRequest = None
        self._MemRequest = None
        self._SubnetId = None
        self._GroupResourceType = None
        self._InstanceCount = None
        self._UpdatedTime = None
        self._MaxSurge = None
        self._MaxUnavailable = None
        self._HealthCheckSettings = None
        self._AllowPlainYamlDeploy = None
        self._IsNotEqualServiceConfig = None
        self._RepoName = None
        self._Alias = None

    @property
    def GroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupName(self):
        """分组名称
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def InstanceNum(self):
        """实例总数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._InstanceNum

    @InstanceNum.setter
    def InstanceNum(self, InstanceNum):
        self._InstanceNum = InstanceNum

    @property
    def CurrentNum(self):
        """已启动实例总数
        :rtype: int
        """
        return self._CurrentNum

    @CurrentNum.setter
    def CurrentNum(self, CurrentNum):
        self._CurrentNum = CurrentNum

    @property
    def CreateTime(self):
        """创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Server(self):
        """镜像server
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Server

    @Server.setter
    def Server(self, Server):
        self._Server = Server

    @property
    def Reponame(self):
        """镜像名，如/tsf/nginx
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Reponame

    @Reponame.setter
    def Reponame(self, Reponame):
        self._Reponame = Reponame

    @property
    def TagName(self):
        """镜像版本名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TagName

    @TagName.setter
    def TagName(self, TagName):
        self._TagName = TagName

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        """集群名称
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def NamespaceId(self):
        """命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def NamespaceName(self):
        """命名空间名称
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def LbIp(self):
        """负载均衡ip
        :rtype: str
        """
        return self._LbIp

    @LbIp.setter
    def LbIp(self, LbIp):
        self._LbIp = LbIp

    @property
    def ApplicationType(self):
        """应用类型
        :rtype: str
        """
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType

    @property
    def ClusterIp(self):
        """Service ip
        :rtype: str
        """
        return self._ClusterIp

    @ClusterIp.setter
    def ClusterIp(self, ClusterIp):
        self._ClusterIp = ClusterIp

    @property
    def NodePort(self):
        """NodePort端口，只有公网和NodePort访问方式才有值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._NodePort

    @NodePort.setter
    def NodePort(self, NodePort):
        self._NodePort = NodePort

    @property
    def CpuLimit(self):
        """最大分配的 CPU 核数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CpuLimit

    @CpuLimit.setter
    def CpuLimit(self, CpuLimit):
        self._CpuLimit = CpuLimit

    @property
    def MemLimit(self):
        """最大分配的内存 MiB 数，对应 K8S limit
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MemLimit

    @MemLimit.setter
    def MemLimit(self, MemLimit):
        self._MemLimit = MemLimit

    @property
    def AccessType(self):
        """0:公网 1:集群内访问 2：NodePort
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._AccessType

    @AccessType.setter
    def AccessType(self, AccessType):
        self._AccessType = AccessType

    @property
    def UpdateType(self):
        """更新方式：0:快速更新 1:滚动更新
        :rtype: int
        """
        return self._UpdateType

    @UpdateType.setter
    def UpdateType(self, UpdateType):
        self._UpdateType = UpdateType

    @property
    def UpdateIvl(self):
        """更新间隔,单位秒
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._UpdateIvl

    @UpdateIvl.setter
    def UpdateIvl(self, UpdateIvl):
        self._UpdateIvl = UpdateIvl

    @property
    def ProtocolPorts(self):
        """端口数组对象
        :rtype: list of ProtocolPort
        """
        return self._ProtocolPorts

    @ProtocolPorts.setter
    def ProtocolPorts(self, ProtocolPorts):
        self._ProtocolPorts = ProtocolPorts

    @property
    def Envs(self):
        """环境变量数组对象
        :rtype: list of Env
        """
        return self._Envs

    @Envs.setter
    def Envs(self, Envs):
        self._Envs = Envs

    @property
    def ApplicationName(self):
        """应用名称
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def Message(self):
        """pod错误信息描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Status(self):
        """部署组状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def MicroserviceType(self):
        """服务类型
        :rtype: str
        """
        return self._MicroserviceType

    @MicroserviceType.setter
    def MicroserviceType(self, MicroserviceType):
        self._MicroserviceType = MicroserviceType

    @property
    def CpuRequest(self):
        """初始分配的 CPU 核数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CpuRequest

    @CpuRequest.setter
    def CpuRequest(self, CpuRequest):
        self._CpuRequest = CpuRequest

    @property
    def MemRequest(self):
        """初始分配的内存 MiB 数，对应 K8S request
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MemRequest

    @MemRequest.setter
    def MemRequest(self, MemRequest):
        self._MemRequest = MemRequest

    @property
    def SubnetId(self):
        """子网id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def GroupResourceType(self):
        """部署组资源类型
        :rtype: str
        """
        return self._GroupResourceType

    @GroupResourceType.setter
    def GroupResourceType(self, GroupResourceType):
        self._GroupResourceType = GroupResourceType

    @property
    def InstanceCount(self):
        """部署组实例个数
        :rtype: int
        """
        return self._InstanceCount

    @InstanceCount.setter
    def InstanceCount(self, InstanceCount):
        self._InstanceCount = InstanceCount

    @property
    def UpdatedTime(self):
        """部署组更新时间戳
        :rtype: int
        """
        return self._UpdatedTime

    @UpdatedTime.setter
    def UpdatedTime(self, UpdatedTime):
        self._UpdatedTime = UpdatedTime

    @property
    def MaxSurge(self):
        """kubernetes滚动更新策略的MaxSurge参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MaxSurge

    @MaxSurge.setter
    def MaxSurge(self, MaxSurge):
        self._MaxSurge = MaxSurge

    @property
    def MaxUnavailable(self):
        """kubernetes滚动更新策略的MaxUnavailable参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MaxUnavailable

    @MaxUnavailable.setter
    def MaxUnavailable(self, MaxUnavailable):
        self._MaxUnavailable = MaxUnavailable

    @property
    def HealthCheckSettings(self):
        """部署组健康检查设置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSettings`
        """
        return self._HealthCheckSettings

    @HealthCheckSettings.setter
    def HealthCheckSettings(self, HealthCheckSettings):
        self._HealthCheckSettings = HealthCheckSettings

    @property
    def AllowPlainYamlDeploy(self):
        """允许PlainYamlDeploy
        :rtype: bool
        """
        return self._AllowPlainYamlDeploy

    @AllowPlainYamlDeploy.setter
    def AllowPlainYamlDeploy(self, AllowPlainYamlDeploy):
        self._AllowPlainYamlDeploy = AllowPlainYamlDeploy

    @property
    def IsNotEqualServiceConfig(self):
        """是否不等于ServiceConfig
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IsNotEqualServiceConfig

    @IsNotEqualServiceConfig.setter
    def IsNotEqualServiceConfig(self, IsNotEqualServiceConfig):
        self._IsNotEqualServiceConfig = IsNotEqualServiceConfig

    @property
    def RepoName(self):
        """仓库名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RepoName

    @RepoName.setter
    def RepoName(self, RepoName):
        self._RepoName = RepoName

    @property
    def Alias(self):
        """别名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Alias

    @Alias.setter
    def Alias(self, Alias):
        self._Alias = Alias


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._GroupName = params.get("GroupName")
        self._InstanceNum = params.get("InstanceNum")
        self._CurrentNum = params.get("CurrentNum")
        self._CreateTime = params.get("CreateTime")
        self._Server = params.get("Server")
        self._Reponame = params.get("Reponame")
        self._TagName = params.get("TagName")
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._NamespaceId = params.get("NamespaceId")
        self._NamespaceName = params.get("NamespaceName")
        self._ApplicationId = params.get("ApplicationId")
        self._LbIp = params.get("LbIp")
        self._ApplicationType = params.get("ApplicationType")
        self._ClusterIp = params.get("ClusterIp")
        self._NodePort = params.get("NodePort")
        self._CpuLimit = params.get("CpuLimit")
        self._MemLimit = params.get("MemLimit")
        self._AccessType = params.get("AccessType")
        self._UpdateType = params.get("UpdateType")
        self._UpdateIvl = params.get("UpdateIvl")
        if params.get("ProtocolPorts") is not None:
            self._ProtocolPorts = []
            for item in params.get("ProtocolPorts"):
                obj = ProtocolPort()
                obj._deserialize(item)
                self._ProtocolPorts.append(obj)
        if params.get("Envs") is not None:
            self._Envs = []
            for item in params.get("Envs"):
                obj = Env()
                obj._deserialize(item)
                self._Envs.append(obj)
        self._ApplicationName = params.get("ApplicationName")
        self._Message = params.get("Message")
        self._Status = params.get("Status")
        self._MicroserviceType = params.get("MicroserviceType")
        self._CpuRequest = params.get("CpuRequest")
        self._MemRequest = params.get("MemRequest")
        self._SubnetId = params.get("SubnetId")
        self._GroupResourceType = params.get("GroupResourceType")
        self._InstanceCount = params.get("InstanceCount")
        self._UpdatedTime = params.get("UpdatedTime")
        self._MaxSurge = params.get("MaxSurge")
        self._MaxUnavailable = params.get("MaxUnavailable")
        if params.get("HealthCheckSettings") is not None:
            self._HealthCheckSettings = HealthCheckSettings()
            self._HealthCheckSettings._deserialize(params.get("HealthCheckSettings"))
        self._AllowPlainYamlDeploy = params.get("AllowPlainYamlDeploy")
        self._IsNotEqualServiceConfig = params.get("IsNotEqualServiceConfig")
        self._RepoName = params.get("RepoName")
        self._Alias = params.get("Alias")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerGroupOther(AbstractModel):
    """部署组列表-其它字段

    """

    def __init__(self):
        r"""
        :param _InstanceNum: 实例总数
        :type InstanceNum: int
        :param _CurrentNum: 已启动实例总数
        :type CurrentNum: int
        :param _LbDns: 负载均衡DNS地址
        :type LbDns: str
        :param _LbIp: 负载均衡ip
        :type LbIp: str
        :param _ClusterIp: Service ip
        :type ClusterIp: str
        :param _Status: 服务状态，请参考后面的状态定义
        :type Status: str
        :param _Message: 服务状态，请参考后面的状态定义
        :type Message: str
        :param _Envs: 环境变量
        :type Envs: list of Env
        :param _NodePort: Service NodePort
注意：此字段可能返回 null，表示取不到有效值。
        :type NodePort: int
        :param _SubnetId: 子网ID
注意：此字段可能返回 null，表示取不到有效值。
        :type SubnetId: str
        :param _HealthCheckSettings: 健康检查相关字段
注意：此字段可能返回 null，表示取不到有效值。
        :type HealthCheckSettings: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSettings`
        :param _IsNotEqualServiceConfig: 服务配置信息是否匹配
        :type IsNotEqualServiceConfig: bool
        """
        self._InstanceNum = None
        self._CurrentNum = None
        self._LbDns = None
        self._LbIp = None
        self._ClusterIp = None
        self._Status = None
        self._Message = None
        self._Envs = None
        self._NodePort = None
        self._SubnetId = None
        self._HealthCheckSettings = None
        self._IsNotEqualServiceConfig = None

    @property
    def InstanceNum(self):
        """实例总数
        :rtype: int
        """
        return self._InstanceNum

    @InstanceNum.setter
    def InstanceNum(self, InstanceNum):
        self._InstanceNum = InstanceNum

    @property
    def CurrentNum(self):
        """已启动实例总数
        :rtype: int
        """
        return self._CurrentNum

    @CurrentNum.setter
    def CurrentNum(self, CurrentNum):
        self._CurrentNum = CurrentNum

    @property
    def LbDns(self):
        """负载均衡DNS地址
        :rtype: str
        """
        return self._LbDns

    @LbDns.setter
    def LbDns(self, LbDns):
        self._LbDns = LbDns

    @property
    def LbIp(self):
        """负载均衡ip
        :rtype: str
        """
        return self._LbIp

    @LbIp.setter
    def LbIp(self, LbIp):
        self._LbIp = LbIp

    @property
    def ClusterIp(self):
        """Service ip
        :rtype: str
        """
        return self._ClusterIp

    @ClusterIp.setter
    def ClusterIp(self, ClusterIp):
        self._ClusterIp = ClusterIp

    @property
    def Status(self):
        """服务状态，请参考后面的状态定义
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Message(self):
        """服务状态，请参考后面的状态定义
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Envs(self):
        """环境变量
        :rtype: list of Env
        """
        return self._Envs

    @Envs.setter
    def Envs(self, Envs):
        self._Envs = Envs

    @property
    def NodePort(self):
        """Service NodePort
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._NodePort

    @NodePort.setter
    def NodePort(self, NodePort):
        self._NodePort = NodePort

    @property
    def SubnetId(self):
        """子网ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def HealthCheckSettings(self):
        """健康检查相关字段
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSettings`
        """
        return self._HealthCheckSettings

    @HealthCheckSettings.setter
    def HealthCheckSettings(self, HealthCheckSettings):
        self._HealthCheckSettings = HealthCheckSettings

    @property
    def IsNotEqualServiceConfig(self):
        """服务配置信息是否匹配
        :rtype: bool
        """
        return self._IsNotEqualServiceConfig

    @IsNotEqualServiceConfig.setter
    def IsNotEqualServiceConfig(self, IsNotEqualServiceConfig):
        self._IsNotEqualServiceConfig = IsNotEqualServiceConfig


    def _deserialize(self, params):
        self._InstanceNum = params.get("InstanceNum")
        self._CurrentNum = params.get("CurrentNum")
        self._LbDns = params.get("LbDns")
        self._LbIp = params.get("LbIp")
        self._ClusterIp = params.get("ClusterIp")
        self._Status = params.get("Status")
        self._Message = params.get("Message")
        if params.get("Envs") is not None:
            self._Envs = []
            for item in params.get("Envs"):
                obj = Env()
                obj._deserialize(item)
                self._Envs.append(obj)
        self._NodePort = params.get("NodePort")
        self._SubnetId = params.get("SubnetId")
        if params.get("HealthCheckSettings") is not None:
            self._HealthCheckSettings = HealthCheckSettings()
            self._HealthCheckSettings._deserialize(params.get("HealthCheckSettings"))
        self._IsNotEqualServiceConfig = params.get("IsNotEqualServiceConfig")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContinueRunFailedTaskBatchRequest(AbstractModel):
    """ContinueRunFailedTaskBatch请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchId: 批次ID。
        :type BatchId: str
        """
        self._BatchId = None

    @property
    def BatchId(self):
        """批次ID。
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContinueRunFailedTaskBatchResponse(AbstractModel):
    """ContinueRunFailedTaskBatch返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: true：操作成功、false：操作失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """true：操作成功、false：操作失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CosCredentials(AbstractModel):
    """cos临时账号信息

    """

    def __init__(self):
        r"""
        :param _SessionToken: 会话Token
        :type SessionToken: str
        :param _TmpAppId: 临时应用ID
        :type TmpAppId: str
        :param _TmpSecretId: 临时调用者身份ID
        :type TmpSecretId: str
        :param _TmpSecretKey: 临时密钥
        :type TmpSecretKey: str
        :param _ExpiredTime: 过期时间
        :type ExpiredTime: int
        :param _Domain: 所在域
        :type Domain: str
        """
        self._SessionToken = None
        self._TmpAppId = None
        self._TmpSecretId = None
        self._TmpSecretKey = None
        self._ExpiredTime = None
        self._Domain = None

    @property
    def SessionToken(self):
        """会话Token
        :rtype: str
        """
        return self._SessionToken

    @SessionToken.setter
    def SessionToken(self, SessionToken):
        self._SessionToken = SessionToken

    @property
    def TmpAppId(self):
        """临时应用ID
        :rtype: str
        """
        return self._TmpAppId

    @TmpAppId.setter
    def TmpAppId(self, TmpAppId):
        self._TmpAppId = TmpAppId

    @property
    def TmpSecretId(self):
        """临时调用者身份ID
        :rtype: str
        """
        return self._TmpSecretId

    @TmpSecretId.setter
    def TmpSecretId(self, TmpSecretId):
        self._TmpSecretId = TmpSecretId

    @property
    def TmpSecretKey(self):
        """临时密钥
        :rtype: str
        """
        return self._TmpSecretKey

    @TmpSecretKey.setter
    def TmpSecretKey(self, TmpSecretKey):
        self._TmpSecretKey = TmpSecretKey

    @property
    def ExpiredTime(self):
        """过期时间
        :rtype: int
        """
        return self._ExpiredTime

    @ExpiredTime.setter
    def ExpiredTime(self, ExpiredTime):
        self._ExpiredTime = ExpiredTime

    @property
    def Domain(self):
        """所在域
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._SessionToken = params.get("SessionToken")
        self._TmpAppId = params.get("TmpAppId")
        self._TmpSecretId = params.get("TmpSecretId")
        self._TmpSecretKey = params.get("TmpSecretKey")
        self._ExpiredTime = params.get("ExpiredTime")
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosDownloadInfo(AbstractModel):
    """Cos下载所需信息

    """

    def __init__(self):
        r"""
        :param _Bucket: 桶名称
        :type Bucket: str
        :param _Region: 地域
        :type Region: str
        :param _Path: 路径
        :type Path: str
        :param _Credentials: 鉴权信息
        :type Credentials: :class:`tencentcloud.tsf.v20180326.models.CosCredentials`
        """
        self._Bucket = None
        self._Region = None
        self._Path = None
        self._Credentials = None

    @property
    def Bucket(self):
        """桶名称
        :rtype: str
        """
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        """地域
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Path(self):
        """路径
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Credentials(self):
        """鉴权信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.CosCredentials`
        """
        return self._Credentials

    @Credentials.setter
    def Credentials(self, Credentials):
        self._Credentials = Credentials


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        self._Path = params.get("Path")
        if params.get("Credentials") is not None:
            self._Credentials = CosCredentials()
            self._Credentials._deserialize(params.get("Credentials"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosUploadInfo(AbstractModel):
    """cos上传所需信息

    """

    def __init__(self):
        r"""
        :param _PkgId: 程序包ID
        :type PkgId: str
        :param _Bucket: 桶
        :type Bucket: str
        :param _Region: 目标地域
        :type Region: str
        :param _Path: 存储路径
        :type Path: str
        :param _Credentials: 鉴权信息
        :type Credentials: :class:`tencentcloud.tsf.v20180326.models.CosCredentials`
        """
        self._PkgId = None
        self._Bucket = None
        self._Region = None
        self._Path = None
        self._Credentials = None

    @property
    def PkgId(self):
        """程序包ID
        :rtype: str
        """
        return self._PkgId

    @PkgId.setter
    def PkgId(self, PkgId):
        self._PkgId = PkgId

    @property
    def Bucket(self):
        """桶
        :rtype: str
        """
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        """目标地域
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Path(self):
        """存储路径
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Credentials(self):
        """鉴权信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.CosCredentials`
        """
        return self._Credentials

    @Credentials.setter
    def Credentials(self, Credentials):
        self._Credentials = Credentials


    def _deserialize(self, params):
        self._PkgId = params.get("PkgId")
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        self._Path = params.get("Path")
        if params.get("Credentials") is not None:
            self._Credentials = CosCredentials()
            self._Credentials._deserialize(params.get("Credentials"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAllGatewayApiAsyncRequest(AbstractModel):
    """CreateAllGatewayApiAsync请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: API分组ID
        :type GroupId: str
        :param _MicroserviceId: 微服务ID
        :type MicroserviceId: str
        :param _NamespaceId: 命名空间ID
        :type NamespaceId: str
        """
        self._GroupId = None
        self._MicroserviceId = None
        self._NamespaceId = None

    @property
    def GroupId(self):
        """API分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def MicroserviceId(self):
        """微服务ID
        :rtype: str
        """
        return self._MicroserviceId

    @MicroserviceId.setter
    def MicroserviceId(self, MicroserviceId):
        self._MicroserviceId = MicroserviceId

    @property
    def NamespaceId(self):
        """命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._MicroserviceId = params.get("MicroserviceId")
        self._NamespaceId = params.get("NamespaceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAllGatewayApiAsyncResponse(AbstractModel):
    """CreateAllGatewayApiAsync返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 是否成功
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """是否成功
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateApiGroupRequest(AbstractModel):
    """CreateApiGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupName: 分组名称, 不能包含中文
        :type GroupName: str
        :param _GroupContext: 分组上下文
        :type GroupContext: str
        :param _AuthType: 鉴权类型。secret： 密钥鉴权； none:无鉴权
        :type AuthType: str
        :param _Description: 备注
        :type Description: str
        :param _GroupType: 分组类型,默认ms。 ms： 微服务分组； external:外部Api分组
        :type GroupType: str
        :param _GatewayInstanceId: 网关实体ID
        :type GatewayInstanceId: str
        :param _NamespaceNameKey: 命名空间参数key值
        :type NamespaceNameKey: str
        :param _ServiceNameKey: 微服务名参数key值
        :type ServiceNameKey: str
        :param _NamespaceNameKeyPosition: 命名空间参数位置，path，header或query，默认是path
        :type NamespaceNameKeyPosition: str
        :param _ServiceNameKeyPosition: 微服务名参数位置，path，header或query，默认是path
        :type ServiceNameKeyPosition: str
        """
        self._GroupName = None
        self._GroupContext = None
        self._AuthType = None
        self._Description = None
        self._GroupType = None
        self._GatewayInstanceId = None
        self._NamespaceNameKey = None
        self._ServiceNameKey = None
        self._NamespaceNameKeyPosition = None
        self._ServiceNameKeyPosition = None

    @property
    def GroupName(self):
        """分组名称, 不能包含中文
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def GroupContext(self):
        """分组上下文
        :rtype: str
        """
        return self._GroupContext

    @GroupContext.setter
    def GroupContext(self, GroupContext):
        self._GroupContext = GroupContext

    @property
    def AuthType(self):
        """鉴权类型。secret： 密钥鉴权； none:无鉴权
        :rtype: str
        """
        return self._AuthType

    @AuthType.setter
    def AuthType(self, AuthType):
        self._AuthType = AuthType

    @property
    def Description(self):
        """备注
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def GroupType(self):
        """分组类型,默认ms。 ms： 微服务分组； external:外部Api分组
        :rtype: str
        """
        return self._GroupType

    @GroupType.setter
    def GroupType(self, GroupType):
        self._GroupType = GroupType

    @property
    def GatewayInstanceId(self):
        """网关实体ID
        :rtype: str
        """
        return self._GatewayInstanceId

    @GatewayInstanceId.setter
    def GatewayInstanceId(self, GatewayInstanceId):
        self._GatewayInstanceId = GatewayInstanceId

    @property
    def NamespaceNameKey(self):
        """命名空间参数key值
        :rtype: str
        """
        return self._NamespaceNameKey

    @NamespaceNameKey.setter
    def NamespaceNameKey(self, NamespaceNameKey):
        self._NamespaceNameKey = NamespaceNameKey

    @property
    def ServiceNameKey(self):
        """微服务名参数key值
        :rtype: str
        """
        return self._ServiceNameKey

    @ServiceNameKey.setter
    def ServiceNameKey(self, ServiceNameKey):
        self._ServiceNameKey = ServiceNameKey

    @property
    def NamespaceNameKeyPosition(self):
        """命名空间参数位置，path，header或query，默认是path
        :rtype: str
        """
        return self._NamespaceNameKeyPosition

    @NamespaceNameKeyPosition.setter
    def NamespaceNameKeyPosition(self, NamespaceNameKeyPosition):
        self._NamespaceNameKeyPosition = NamespaceNameKeyPosition

    @property
    def ServiceNameKeyPosition(self):
        """微服务名参数位置，path，header或query，默认是path
        :rtype: str
        """
        return self._ServiceNameKeyPosition

    @ServiceNameKeyPosition.setter
    def ServiceNameKeyPosition(self, ServiceNameKeyPosition):
        self._ServiceNameKeyPosition = ServiceNameKeyPosition


    def _deserialize(self, params):
        self._GroupName = params.get("GroupName")
        self._GroupContext = params.get("GroupContext")
        self._AuthType = params.get("AuthType")
        self._Description = params.get("Description")
        self._GroupType = params.get("GroupType")
        self._GatewayInstanceId = params.get("GatewayInstanceId")
        self._NamespaceNameKey = params.get("NamespaceNameKey")
        self._ServiceNameKey = params.get("ServiceNameKey")
        self._NamespaceNameKeyPosition = params.get("NamespaceNameKeyPosition")
        self._ServiceNameKeyPosition = params.get("ServiceNameKeyPosition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateApiGroupResponse(AbstractModel):
    """CreateApiGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: API分组ID
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """API分组ID
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateApiRateLimitRuleRequest(AbstractModel):
    """CreateApiRateLimitRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApiId: Api Id
        :type ApiId: str
        :param _MaxQps: qps值
        :type MaxQps: int
        :param _UsableStatus: 开启/禁用，enabled/disabled, 不传默认开启
        :type UsableStatus: str
        """
        self._ApiId = None
        self._MaxQps = None
        self._UsableStatus = None

    @property
    def ApiId(self):
        """Api Id
        :rtype: str
        """
        return self._ApiId

    @ApiId.setter
    def ApiId(self, ApiId):
        self._ApiId = ApiId

    @property
    def MaxQps(self):
        """qps值
        :rtype: int
        """
        return self._MaxQps

    @MaxQps.setter
    def MaxQps(self, MaxQps):
        self._MaxQps = MaxQps

    @property
    def UsableStatus(self):
        """开启/禁用，enabled/disabled, 不传默认开启
        :rtype: str
        """
        return self._UsableStatus

    @UsableStatus.setter
    def UsableStatus(self, UsableStatus):
        self._UsableStatus = UsableStatus


    def _deserialize(self, params):
        self._ApiId = params.get("ApiId")
        self._MaxQps = params.get("MaxQps")
        self._UsableStatus = params.get("UsableStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateApiRateLimitRuleResponse(AbstractModel):
    """CreateApiRateLimitRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 是否成功
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """是否成功
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateApiRateLimitRuleWithDetailRespRequest(AbstractModel):
    """CreateApiRateLimitRuleWithDetailResp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApiId: Api Id
        :type ApiId: str
        :param _MaxQps: qps值
        :type MaxQps: int
        :param _UsableStatus: 开启/禁用，enabled/disabled, 不传默认开启
        :type UsableStatus: str
        """
        self._ApiId = None
        self._MaxQps = None
        self._UsableStatus = None

    @property
    def ApiId(self):
        """Api Id
        :rtype: str
        """
        return self._ApiId

    @ApiId.setter
    def ApiId(self, ApiId):
        self._ApiId = ApiId

    @property
    def MaxQps(self):
        """qps值
        :rtype: int
        """
        return self._MaxQps

    @MaxQps.setter
    def MaxQps(self, MaxQps):
        self._MaxQps = MaxQps

    @property
    def UsableStatus(self):
        """开启/禁用，enabled/disabled, 不传默认开启
        :rtype: str
        """
        return self._UsableStatus

    @UsableStatus.setter
    def UsableStatus(self, UsableStatus):
        self._UsableStatus = UsableStatus


    def _deserialize(self, params):
        self._ApiId = params.get("ApiId")
        self._MaxQps = params.get("MaxQps")
        self._UsableStatus = params.get("UsableStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateApiRateLimitRuleWithDetailRespResponse(AbstractModel):
    """CreateApiRateLimitRuleWithDetailResp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 创建的规则 ID
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ApiRateLimitRule`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """创建的规则 ID
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ApiRateLimitRule`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ApiRateLimitRule()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateApplicationRequest(AbstractModel):
    """CreateApplication请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplicationName: 应用名称
        :type ApplicationName: str
        :param _ApplicationType: 应用类型，V：虚拟机应用；C：容器应用；S：serverless应用
        :type ApplicationType: str
        :param _MicroserviceType: 应用微服务类型，M：service mesh应用；N：普通应用；G：网关应用
        :type MicroserviceType: str
        :param _ApplicationDesc: 应用描述
        :type ApplicationDesc: str
        :param _ApplicationLogConfig: 应用日志配置项，废弃参数
        :type ApplicationLogConfig: str
        :param _ApplicationResourceType: 应用资源类型，废弃参数
        :type ApplicationResourceType: str
        :param _ApplicationRuntimeType: 应用runtime类型
        :type ApplicationRuntimeType: str
        :param _ProgramId: 需要绑定的数据集ID
        :type ProgramId: str
        :param _ServiceConfigList: 服务配置信息列表
        :type ServiceConfigList: list of ServiceConfig
        :param _IgnoreCreateImageRepository: 忽略创建镜像仓库
        :type IgnoreCreateImageRepository: bool
        :param _ProgramIdList: 数据集id列表
        :type ProgramIdList: list of str
        :param _ApmInstanceId: apm业务系统id
        :type ApmInstanceId: str
        :param _ProgramLanguage: 编程语言:  Java；C/C++；Python；Go；Other
        :type ProgramLanguage: str
        :param _FrameworkType: 开发框架-SpringCloud/Dubbo/Go-GRPC/Other
        :type FrameworkType: str
        :param _ServiceGovernanceConfig: 注册配置治理
        :type ServiceGovernanceConfig: :class:`tencentcloud.tsf.v20180326.models.ServiceGovernanceConfig`
        :param _CreateSameNameImageRepository: 是否创建并关联同名镜像仓库
        :type CreateSameNameImageRepository: bool
        """
        self._ApplicationName = None
        self._ApplicationType = None
        self._MicroserviceType = None
        self._ApplicationDesc = None
        self._ApplicationLogConfig = None
        self._ApplicationResourceType = None
        self._ApplicationRuntimeType = None
        self._ProgramId = None
        self._ServiceConfigList = None
        self._IgnoreCreateImageRepository = None
        self._ProgramIdList = None
        self._ApmInstanceId = None
        self._ProgramLanguage = None
        self._FrameworkType = None
        self._ServiceGovernanceConfig = None
        self._CreateSameNameImageRepository = None

    @property
    def ApplicationName(self):
        """应用名称
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationType(self):
        """应用类型，V：虚拟机应用；C：容器应用；S：serverless应用
        :rtype: str
        """
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType

    @property
    def MicroserviceType(self):
        """应用微服务类型，M：service mesh应用；N：普通应用；G：网关应用
        :rtype: str
        """
        return self._MicroserviceType

    @MicroserviceType.setter
    def MicroserviceType(self, MicroserviceType):
        self._MicroserviceType = MicroserviceType

    @property
    def ApplicationDesc(self):
        """应用描述
        :rtype: str
        """
        return self._ApplicationDesc

    @ApplicationDesc.setter
    def ApplicationDesc(self, ApplicationDesc):
        self._ApplicationDesc = ApplicationDesc

    @property
    def ApplicationLogConfig(self):
        warnings.warn("parameter `ApplicationLogConfig` is deprecated", DeprecationWarning) 

        """应用日志配置项，废弃参数
        :rtype: str
        """
        return self._ApplicationLogConfig

    @ApplicationLogConfig.setter
    def ApplicationLogConfig(self, ApplicationLogConfig):
        warnings.warn("parameter `ApplicationLogConfig` is deprecated", DeprecationWarning) 

        self._ApplicationLogConfig = ApplicationLogConfig

    @property
    def ApplicationResourceType(self):
        warnings.warn("parameter `ApplicationResourceType` is deprecated", DeprecationWarning) 

        """应用资源类型，废弃参数
        :rtype: str
        """
        return self._ApplicationResourceType

    @ApplicationResourceType.setter
    def ApplicationResourceType(self, ApplicationResourceType):
        warnings.warn("parameter `ApplicationResourceType` is deprecated", DeprecationWarning) 

        self._ApplicationResourceType = ApplicationResourceType

    @property
    def ApplicationRuntimeType(self):
        """应用runtime类型
        :rtype: str
        """
        return self._ApplicationRuntimeType

    @ApplicationRuntimeType.setter
    def ApplicationRuntimeType(self, ApplicationRuntimeType):
        self._ApplicationRuntimeType = ApplicationRuntimeType

    @property
    def ProgramId(self):
        """需要绑定的数据集ID
        :rtype: str
        """
        return self._ProgramId

    @ProgramId.setter
    def ProgramId(self, ProgramId):
        self._ProgramId = ProgramId

    @property
    def ServiceConfigList(self):
        """服务配置信息列表
        :rtype: list of ServiceConfig
        """
        return self._ServiceConfigList

    @ServiceConfigList.setter
    def ServiceConfigList(self, ServiceConfigList):
        self._ServiceConfigList = ServiceConfigList

    @property
    def IgnoreCreateImageRepository(self):
        """忽略创建镜像仓库
        :rtype: bool
        """
        return self._IgnoreCreateImageRepository

    @IgnoreCreateImageRepository.setter
    def IgnoreCreateImageRepository(self, IgnoreCreateImageRepository):
        self._IgnoreCreateImageRepository = IgnoreCreateImageRepository

    @property
    def ProgramIdList(self):
        """数据集id列表
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList

    @property
    def ApmInstanceId(self):
        """apm业务系统id
        :rtype: str
        """
        return self._ApmInstanceId

    @ApmInstanceId.setter
    def ApmInstanceId(self, ApmInstanceId):
        self._ApmInstanceId = ApmInstanceId

    @property
    def ProgramLanguage(self):
        """编程语言:  Java；C/C++；Python；Go；Other
        :rtype: str
        """
        return self._ProgramLanguage

    @ProgramLanguage.setter
    def ProgramLanguage(self, ProgramLanguage):
        self._ProgramLanguage = ProgramLanguage

    @property
    def FrameworkType(self):
        """开发框架-SpringCloud/Dubbo/Go-GRPC/Other
        :rtype: str
        """
        return self._FrameworkType

    @FrameworkType.setter
    def FrameworkType(self, FrameworkType):
        self._FrameworkType = FrameworkType

    @property
    def ServiceGovernanceConfig(self):
        """注册配置治理
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ServiceGovernanceConfig`
        """
        return self._ServiceGovernanceConfig

    @ServiceGovernanceConfig.setter
    def ServiceGovernanceConfig(self, ServiceGovernanceConfig):
        self._ServiceGovernanceConfig = ServiceGovernanceConfig

    @property
    def CreateSameNameImageRepository(self):
        """是否创建并关联同名镜像仓库
        :rtype: bool
        """
        return self._CreateSameNameImageRepository

    @CreateSameNameImageRepository.setter
    def CreateSameNameImageRepository(self, CreateSameNameImageRepository):
        self._CreateSameNameImageRepository = CreateSameNameImageRepository


    def _deserialize(self, params):
        self._ApplicationName = params.get("ApplicationName")
        self._ApplicationType = params.get("ApplicationType")
        self._MicroserviceType = params.get("MicroserviceType")
        self._ApplicationDesc = params.get("ApplicationDesc")
        self._ApplicationLogConfig = params.get("ApplicationLogConfig")
        self._ApplicationResourceType = params.get("ApplicationResourceType")
        self._ApplicationRuntimeType = params.get("ApplicationRuntimeType")
        self._ProgramId = params.get("ProgramId")
        if params.get("ServiceConfigList") is not None:
            self._ServiceConfigList = []
            for item in params.get("ServiceConfigList"):
                obj = ServiceConfig()
                obj._deserialize(item)
                self._ServiceConfigList.append(obj)
        self._IgnoreCreateImageRepository = params.get("IgnoreCreateImageRepository")
        self._ProgramIdList = params.get("ProgramIdList")
        self._ApmInstanceId = params.get("ApmInstanceId")
        self._ProgramLanguage = params.get("ProgramLanguage")
        self._FrameworkType = params.get("FrameworkType")
        if params.get("ServiceGovernanceConfig") is not None:
            self._ServiceGovernanceConfig = ServiceGovernanceConfig()
            self._ServiceGovernanceConfig._deserialize(params.get("ServiceGovernanceConfig"))
        self._CreateSameNameImageRepository = params.get("CreateSameNameImageRepository")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateApplicationResponse(AbstractModel):
    """CreateApplication返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 应用ID
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """应用ID
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateClusterRequest(AbstractModel):
    """CreateCluster请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _ClusterType: 集群类型
        :type ClusterType: str
        :param _VpcId: 私有网络ID
        :type VpcId: str
        :param _ClusterCIDR: 分配给集群容器和服务IP的CIDR
        :type ClusterCIDR: str
        :param _ClusterDesc: 集群备注
        :type ClusterDesc: str
        :param _TsfRegionId: 集群所属TSF地域
        :type TsfRegionId: str
        :param _TsfZoneId: 集群所属TSF可用区
        :type TsfZoneId: str
        :param _SubnetId: 私有网络子网ID
        :type SubnetId: str
        :param _ClusterVersion: 集群版本
        :type ClusterVersion: str
        :param _MaxNodePodNum: 集群中每个Node上最大的Pod数量。取值范围4～256。不为2的幂值时会向上取最接近的2的幂值。
        :type MaxNodePodNum: int
        :param _MaxClusterServiceNum: 集群最大的service数量。取值范围32～32768，不为2的幂值时会向上取最接近的2的幂值。
        :type MaxClusterServiceNum: int
        :param _ProgramId: 需要绑定的数据集ID
        :type ProgramId: str
        :param _KuberneteApiServer: api地址
        :type KuberneteApiServer: str
        :param _KuberneteNativeType: K : kubeconfig, S : service account
        :type KuberneteNativeType: str
        :param _KuberneteNativeSecret: native secret
        :type KuberneteNativeSecret: str
        :param _ProgramIdList: 无
        :type ProgramIdList: list of str
        :param _EnableLogCollection: 是否开启cls日志功能
        :type EnableLogCollection: bool
        """
        self._ClusterName = None
        self._ClusterType = None
        self._VpcId = None
        self._ClusterCIDR = None
        self._ClusterDesc = None
        self._TsfRegionId = None
        self._TsfZoneId = None
        self._SubnetId = None
        self._ClusterVersion = None
        self._MaxNodePodNum = None
        self._MaxClusterServiceNum = None
        self._ProgramId = None
        self._KuberneteApiServer = None
        self._KuberneteNativeType = None
        self._KuberneteNativeSecret = None
        self._ProgramIdList = None
        self._EnableLogCollection = None

    @property
    def ClusterName(self):
        """集群名称
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterType(self):
        """集群类型
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def VpcId(self):
        """私有网络ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ClusterCIDR(self):
        """分配给集群容器和服务IP的CIDR
        :rtype: str
        """
        return self._ClusterCIDR

    @ClusterCIDR.setter
    def ClusterCIDR(self, ClusterCIDR):
        self._ClusterCIDR = ClusterCIDR

    @property
    def ClusterDesc(self):
        """集群备注
        :rtype: str
        """
        return self._ClusterDesc

    @ClusterDesc.setter
    def ClusterDesc(self, ClusterDesc):
        self._ClusterDesc = ClusterDesc

    @property
    def TsfRegionId(self):
        """集群所属TSF地域
        :rtype: str
        """
        return self._TsfRegionId

    @TsfRegionId.setter
    def TsfRegionId(self, TsfRegionId):
        self._TsfRegionId = TsfRegionId

    @property
    def TsfZoneId(self):
        """集群所属TSF可用区
        :rtype: str
        """
        return self._TsfZoneId

    @TsfZoneId.setter
    def TsfZoneId(self, TsfZoneId):
        self._TsfZoneId = TsfZoneId

    @property
    def SubnetId(self):
        """私有网络子网ID
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def ClusterVersion(self):
        """集群版本
        :rtype: str
        """
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def MaxNodePodNum(self):
        """集群中每个Node上最大的Pod数量。取值范围4～256。不为2的幂值时会向上取最接近的2的幂值。
        :rtype: int
        """
        return self._MaxNodePodNum

    @MaxNodePodNum.setter
    def MaxNodePodNum(self, MaxNodePodNum):
        self._MaxNodePodNum = MaxNodePodNum

    @property
    def MaxClusterServiceNum(self):
        """集群最大的service数量。取值范围32～32768，不为2的幂值时会向上取最接近的2的幂值。
        :rtype: int
        """
        return self._MaxClusterServiceNum

    @MaxClusterServiceNum.setter
    def MaxClusterServiceNum(self, MaxClusterServiceNum):
        self._MaxClusterServiceNum = MaxClusterServiceNum

    @property
    def ProgramId(self):
        """需要绑定的数据集ID
        :rtype: str
        """
        return self._ProgramId

    @ProgramId.setter
    def ProgramId(self, ProgramId):
        self._ProgramId = ProgramId

    @property
    def KuberneteApiServer(self):
        """api地址
        :rtype: str
        """
        return self._KuberneteApiServer

    @KuberneteApiServer.setter
    def KuberneteApiServer(self, KuberneteApiServer):
        self._KuberneteApiServer = KuberneteApiServer

    @property
    def KuberneteNativeType(self):
        """K : kubeconfig, S : service account
        :rtype: str
        """
        return self._KuberneteNativeType

    @KuberneteNativeType.setter
    def KuberneteNativeType(self, KuberneteNativeType):
        self._KuberneteNativeType = KuberneteNativeType

    @property
    def KuberneteNativeSecret(self):
        """native secret
        :rtype: str
        """
        return self._KuberneteNativeSecret

    @KuberneteNativeSecret.setter
    def KuberneteNativeSecret(self, KuberneteNativeSecret):
        self._KuberneteNativeSecret = KuberneteNativeSecret

    @property
    def ProgramIdList(self):
        """无
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList

    @property
    def EnableLogCollection(self):
        """是否开启cls日志功能
        :rtype: bool
        """
        return self._EnableLogCollection

    @EnableLogCollection.setter
    def EnableLogCollection(self, EnableLogCollection):
        self._EnableLogCollection = EnableLogCollection


    def _deserialize(self, params):
        self._ClusterName = params.get("ClusterName")
        self._ClusterType = params.get("ClusterType")
        self._VpcId = params.get("VpcId")
        self._ClusterCIDR = params.get("ClusterCIDR")
        self._ClusterDesc = params.get("ClusterDesc")
        self._TsfRegionId = params.get("TsfRegionId")
        self._TsfZoneId = params.get("TsfZoneId")
        self._SubnetId = params.get("SubnetId")
        self._ClusterVersion = params.get("ClusterVersion")
        self._MaxNodePodNum = params.get("MaxNodePodNum")
        self._MaxClusterServiceNum = params.get("MaxClusterServiceNum")
        self._ProgramId = params.get("ProgramId")
        self._KuberneteApiServer = params.get("KuberneteApiServer")
        self._KuberneteNativeType = params.get("KuberneteNativeType")
        self._KuberneteNativeSecret = params.get("KuberneteNativeSecret")
        self._ProgramIdList = params.get("ProgramIdList")
        self._EnableLogCollection = params.get("EnableLogCollection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterResponse(AbstractModel):
    """CreateCluster返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 集群ID
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """集群ID
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateConfigRequest(AbstractModel):
    """CreateConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigName: 配置项名称
        :type ConfigName: str
        :param _ConfigVersion: 配置项版本
        :type ConfigVersion: str
        :param _ConfigValue: 配置项值
        :type ConfigValue: str
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        :param _ConfigVersionDesc: 配置项版本描述
        :type ConfigVersionDesc: str
        :param _ConfigType: 配置项值类型
        :type ConfigType: str
        :param _EncodeWithBase64: Base64编码的配置项
        :type EncodeWithBase64: bool
        :param _ProgramIdList: 无
        :type ProgramIdList: list of str
        """
        self._ConfigName = None
        self._ConfigVersion = None
        self._ConfigValue = None
        self._ApplicationId = None
        self._ConfigVersionDesc = None
        self._ConfigType = None
        self._EncodeWithBase64 = None
        self._ProgramIdList = None

    @property
    def ConfigName(self):
        """配置项名称
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigVersion(self):
        """配置项版本
        :rtype: str
        """
        return self._ConfigVersion

    @ConfigVersion.setter
    def ConfigVersion(self, ConfigVersion):
        self._ConfigVersion = ConfigVersion

    @property
    def ConfigValue(self):
        """配置项值
        :rtype: str
        """
        return self._ConfigValue

    @ConfigValue.setter
    def ConfigValue(self, ConfigValue):
        self._ConfigValue = ConfigValue

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ConfigVersionDesc(self):
        """配置项版本描述
        :rtype: str
        """
        return self._ConfigVersionDesc

    @ConfigVersionDesc.setter
    def ConfigVersionDesc(self, ConfigVersionDesc):
        self._ConfigVersionDesc = ConfigVersionDesc

    @property
    def ConfigType(self):
        """配置项值类型
        :rtype: str
        """
        return self._ConfigType

    @ConfigType.setter
    def ConfigType(self, ConfigType):
        self._ConfigType = ConfigType

    @property
    def EncodeWithBase64(self):
        """Base64编码的配置项
        :rtype: bool
        """
        return self._EncodeWithBase64

    @EncodeWithBase64.setter
    def EncodeWithBase64(self, EncodeWithBase64):
        self._EncodeWithBase64 = EncodeWithBase64

    @property
    def ProgramIdList(self):
        """无
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList


    def _deserialize(self, params):
        self._ConfigName = params.get("ConfigName")
        self._ConfigVersion = params.get("ConfigVersion")
        self._ConfigValue = params.get("ConfigValue")
        self._ApplicationId = params.get("ApplicationId")
        self._ConfigVersionDesc = params.get("ConfigVersionDesc")
        self._ConfigType = params.get("ConfigType")
        self._EncodeWithBase64 = params.get("EncodeWithBase64")
        self._ProgramIdList = params.get("ProgramIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateConfigResponse(AbstractModel):
    """CreateConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: true：创建成功；false：创建失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """true：创建成功；false：创建失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateConfigTemplateRequest(AbstractModel):
    """CreateConfigTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigTemplateName: 配置模板名称
        :type ConfigTemplateName: str
        :param _ConfigTemplateType: 配置模板对应的微服务框架
        :type ConfigTemplateType: str
        :param _ConfigTemplateValue: 配置模板数据
        :type ConfigTemplateValue: str
        :param _ConfigTemplateDesc: 配置模板描述
        :type ConfigTemplateDesc: str
        :param _ProgramIdList: 无
        :type ProgramIdList: list of str
        """
        self._ConfigTemplateName = None
        self._ConfigTemplateType = None
        self._ConfigTemplateValue = None
        self._ConfigTemplateDesc = None
        self._ProgramIdList = None

    @property
    def ConfigTemplateName(self):
        """配置模板名称
        :rtype: str
        """
        return self._ConfigTemplateName

    @ConfigTemplateName.setter
    def ConfigTemplateName(self, ConfigTemplateName):
        self._ConfigTemplateName = ConfigTemplateName

    @property
    def ConfigTemplateType(self):
        """配置模板对应的微服务框架
        :rtype: str
        """
        return self._ConfigTemplateType

    @ConfigTemplateType.setter
    def ConfigTemplateType(self, ConfigTemplateType):
        self._ConfigTemplateType = ConfigTemplateType

    @property
    def ConfigTemplateValue(self):
        """配置模板数据
        :rtype: str
        """
        return self._ConfigTemplateValue

    @ConfigTemplateValue.setter
    def ConfigTemplateValue(self, ConfigTemplateValue):
        self._ConfigTemplateValue = ConfigTemplateValue

    @property
    def ConfigTemplateDesc(self):
        """配置模板描述
        :rtype: str
        """
        return self._ConfigTemplateDesc

    @ConfigTemplateDesc.setter
    def ConfigTemplateDesc(self, ConfigTemplateDesc):
        self._ConfigTemplateDesc = ConfigTemplateDesc

    @property
    def ProgramIdList(self):
        """无
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList


    def _deserialize(self, params):
        self._ConfigTemplateName = params.get("ConfigTemplateName")
        self._ConfigTemplateType = params.get("ConfigTemplateType")
        self._ConfigTemplateValue = params.get("ConfigTemplateValue")
        self._ConfigTemplateDesc = params.get("ConfigTemplateDesc")
        self._ProgramIdList = params.get("ProgramIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateConfigTemplateResponse(AbstractModel):
    """CreateConfigTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: true：创建成功；false：创建失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """true：创建成功；false：创建失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateConfigTemplateWithDetailRespRequest(AbstractModel):
    """CreateConfigTemplateWithDetailResp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigTemplateName: 配置模板名称
        :type ConfigTemplateName: str
        :param _ConfigTemplateType: 配置模板对应的微服务框架
        :type ConfigTemplateType: str
        :param _ConfigTemplateValue: 配置模板数据
        :type ConfigTemplateValue: str
        :param _ConfigTemplateDesc: 配置模板描述
        :type ConfigTemplateDesc: str
        :param _ProgramIdList: 无
        :type ProgramIdList: list of str
        """
        self._ConfigTemplateName = None
        self._ConfigTemplateType = None
        self._ConfigTemplateValue = None
        self._ConfigTemplateDesc = None
        self._ProgramIdList = None

    @property
    def ConfigTemplateName(self):
        """配置模板名称
        :rtype: str
        """
        return self._ConfigTemplateName

    @ConfigTemplateName.setter
    def ConfigTemplateName(self, ConfigTemplateName):
        self._ConfigTemplateName = ConfigTemplateName

    @property
    def ConfigTemplateType(self):
        """配置模板对应的微服务框架
        :rtype: str
        """
        return self._ConfigTemplateType

    @ConfigTemplateType.setter
    def ConfigTemplateType(self, ConfigTemplateType):
        self._ConfigTemplateType = ConfigTemplateType

    @property
    def ConfigTemplateValue(self):
        """配置模板数据
        :rtype: str
        """
        return self._ConfigTemplateValue

    @ConfigTemplateValue.setter
    def ConfigTemplateValue(self, ConfigTemplateValue):
        self._ConfigTemplateValue = ConfigTemplateValue

    @property
    def ConfigTemplateDesc(self):
        """配置模板描述
        :rtype: str
        """
        return self._ConfigTemplateDesc

    @ConfigTemplateDesc.setter
    def ConfigTemplateDesc(self, ConfigTemplateDesc):
        self._ConfigTemplateDesc = ConfigTemplateDesc

    @property
    def ProgramIdList(self):
        """无
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList


    def _deserialize(self, params):
        self._ConfigTemplateName = params.get("ConfigTemplateName")
        self._ConfigTemplateType = params.get("ConfigTemplateType")
        self._ConfigTemplateValue = params.get("ConfigTemplateValue")
        self._ConfigTemplateDesc = params.get("ConfigTemplateDesc")
        self._ProgramIdList = params.get("ProgramIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateConfigTemplateWithDetailRespResponse(AbstractModel):
    """CreateConfigTemplateWithDetailResp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 创建成功，返回 ID
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ConfigTemplate`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """创建成功，返回 ID
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ConfigTemplate`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ConfigTemplate()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateConfigWithDetailRespRequest(AbstractModel):
    """CreateConfigWithDetailResp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigName: 配置项名称
        :type ConfigName: str
        :param _ConfigVersion: 配置项版本
        :type ConfigVersion: str
        :param _ConfigValue: 配置项值
        :type ConfigValue: str
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        :param _ConfigVersionDesc: 配置项版本描述
        :type ConfigVersionDesc: str
        :param _ConfigType: 配置项值类型
        :type ConfigType: str
        :param _EncodeWithBase64: Base64编码的配置项
        :type EncodeWithBase64: bool
        :param _ProgramIdList: 无
        :type ProgramIdList: list of str
        """
        self._ConfigName = None
        self._ConfigVersion = None
        self._ConfigValue = None
        self._ApplicationId = None
        self._ConfigVersionDesc = None
        self._ConfigType = None
        self._EncodeWithBase64 = None
        self._ProgramIdList = None

    @property
    def ConfigName(self):
        """配置项名称
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigVersion(self):
        """配置项版本
        :rtype: str
        """
        return self._ConfigVersion

    @ConfigVersion.setter
    def ConfigVersion(self, ConfigVersion):
        self._ConfigVersion = ConfigVersion

    @property
    def ConfigValue(self):
        """配置项值
        :rtype: str
        """
        return self._ConfigValue

    @ConfigValue.setter
    def ConfigValue(self, ConfigValue):
        self._ConfigValue = ConfigValue

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ConfigVersionDesc(self):
        """配置项版本描述
        :rtype: str
        """
        return self._ConfigVersionDesc

    @ConfigVersionDesc.setter
    def ConfigVersionDesc(self, ConfigVersionDesc):
        self._ConfigVersionDesc = ConfigVersionDesc

    @property
    def ConfigType(self):
        """配置项值类型
        :rtype: str
        """
        return self._ConfigType

    @ConfigType.setter
    def ConfigType(self, ConfigType):
        self._ConfigType = ConfigType

    @property
    def EncodeWithBase64(self):
        """Base64编码的配置项
        :rtype: bool
        """
        return self._EncodeWithBase64

    @EncodeWithBase64.setter
    def EncodeWithBase64(self, EncodeWithBase64):
        self._EncodeWithBase64 = EncodeWithBase64

    @property
    def ProgramIdList(self):
        """无
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList


    def _deserialize(self, params):
        self._ConfigName = params.get("ConfigName")
        self._ConfigVersion = params.get("ConfigVersion")
        self._ConfigValue = params.get("ConfigValue")
        self._ApplicationId = params.get("ApplicationId")
        self._ConfigVersionDesc = params.get("ConfigVersionDesc")
        self._ConfigType = params.get("ConfigType")
        self._EncodeWithBase64 = params.get("EncodeWithBase64")
        self._ProgramIdList = params.get("ProgramIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateConfigWithDetailRespResponse(AbstractModel):
    """CreateConfigWithDetailResp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 配置项
        :type Result: :class:`tencentcloud.tsf.v20180326.models.Config`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """配置项
        :rtype: :class:`tencentcloud.tsf.v20180326.models.Config`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = Config()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateContainGroupRequest(AbstractModel):
    """CreateContainGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplicationId: 分组所属应用ID
        :type ApplicationId: str
        :param _NamespaceId: 分组所属命名空间ID
        :type NamespaceId: str
        :param _GroupName: 分组名称字段，长度1~60，字母或下划线开头，可包含字母数字下划线
        :type GroupName: str
        :param _InstanceNum: 实例数量
        :type InstanceNum: int
        :param _AccessType: 0:公网 1:集群内访问 2：NodePort
        :type AccessType: int
        :param _ProtocolPorts: 数组对象，见下方定义
        :type ProtocolPorts: list of ProtocolPort
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _CpuLimit: 最大分配 CPU 核数，对应 K8S limit
        :type CpuLimit: str
        :param _MemLimit: 最大分配内存 MiB 数，对应 K8S limit
        :type MemLimit: str
        :param _GroupComment: 分组备注字段，长度应不大于200字符
        :type GroupComment: str
        :param _UpdateType: 更新方式：0:快速更新 1:滚动更新
        :type UpdateType: int
        :param _UpdateIvl: 滚动更新必填，更新间隔
        :type UpdateIvl: int
        :param _CpuRequest: 初始分配的 CPU 核数，对应 K8S request
        :type CpuRequest: str
        :param _MemRequest: 初始分配的内存 MiB 数，对应 K8S request
        :type MemRequest: str
        :param _GroupResourceType: 部署组资源类型；
DEF — 默认资源类型；
GW — 网关资源类型；
        :type GroupResourceType: str
        :param _SubnetId: 子网ID
        :type SubnetId: str
        :param _AgentCpuRequest: agent 容器分配的 CPU 核数，对应 K8S 的 request
        :type AgentCpuRequest: str
        :param _AgentCpuLimit: agent 容器最大的 CPU 核数，对应 K8S 的 limit
        :type AgentCpuLimit: str
        :param _AgentMemRequest: agent 容器分配的内存 MiB 数，对应 K8S 的 request
        :type AgentMemRequest: str
        :param _AgentMemLimit: agent 容器最大的内存 MiB 数，对应 K8S 的 limit
        :type AgentMemLimit: str
        :param _IstioCpuRequest: istioproxy 容器分配的 CPU 核数，对应 K8S 的 request
        :type IstioCpuRequest: str
        :param _IstioCpuLimit: istioproxy 容器最大的 CPU 核数，对应 K8S 的 limit
        :type IstioCpuLimit: str
        :param _IstioMemRequest: istioproxy 容器分配的内存 MiB 数，对应 K8S 的 request
        :type IstioMemRequest: str
        :param _IstioMemLimit: istioproxy 容器最大的内存 MiB 数，对应 K8S 的 limit
        :type IstioMemLimit: str
        """
        self._ApplicationId = None
        self._NamespaceId = None
        self._GroupName = None
        self._InstanceNum = None
        self._AccessType = None
        self._ProtocolPorts = None
        self._ClusterId = None
        self._CpuLimit = None
        self._MemLimit = None
        self._GroupComment = None
        self._UpdateType = None
        self._UpdateIvl = None
        self._CpuRequest = None
        self._MemRequest = None
        self._GroupResourceType = None
        self._SubnetId = None
        self._AgentCpuRequest = None
        self._AgentCpuLimit = None
        self._AgentMemRequest = None
        self._AgentMemLimit = None
        self._IstioCpuRequest = None
        self._IstioCpuLimit = None
        self._IstioMemRequest = None
        self._IstioMemLimit = None

    @property
    def ApplicationId(self):
        """分组所属应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def NamespaceId(self):
        """分组所属命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def GroupName(self):
        """分组名称字段，长度1~60，字母或下划线开头，可包含字母数字下划线
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def InstanceNum(self):
        """实例数量
        :rtype: int
        """
        return self._InstanceNum

    @InstanceNum.setter
    def InstanceNum(self, InstanceNum):
        self._InstanceNum = InstanceNum

    @property
    def AccessType(self):
        """0:公网 1:集群内访问 2：NodePort
        :rtype: int
        """
        return self._AccessType

    @AccessType.setter
    def AccessType(self, AccessType):
        self._AccessType = AccessType

    @property
    def ProtocolPorts(self):
        """数组对象，见下方定义
        :rtype: list of ProtocolPort
        """
        return self._ProtocolPorts

    @ProtocolPorts.setter
    def ProtocolPorts(self, ProtocolPorts):
        self._ProtocolPorts = ProtocolPorts

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def CpuLimit(self):
        """最大分配 CPU 核数，对应 K8S limit
        :rtype: str
        """
        return self._CpuLimit

    @CpuLimit.setter
    def CpuLimit(self, CpuLimit):
        self._CpuLimit = CpuLimit

    @property
    def MemLimit(self):
        """最大分配内存 MiB 数，对应 K8S limit
        :rtype: str
        """
        return self._MemLimit

    @MemLimit.setter
    def MemLimit(self, MemLimit):
        self._MemLimit = MemLimit

    @property
    def GroupComment(self):
        """分组备注字段，长度应不大于200字符
        :rtype: str
        """
        return self._GroupComment

    @GroupComment.setter
    def GroupComment(self, GroupComment):
        self._GroupComment = GroupComment

    @property
    def UpdateType(self):
        """更新方式：0:快速更新 1:滚动更新
        :rtype: int
        """
        return self._UpdateType

    @UpdateType.setter
    def UpdateType(self, UpdateType):
        self._UpdateType = UpdateType

    @property
    def UpdateIvl(self):
        """滚动更新必填，更新间隔
        :rtype: int
        """
        return self._UpdateIvl

    @UpdateIvl.setter
    def UpdateIvl(self, UpdateIvl):
        self._UpdateIvl = UpdateIvl

    @property
    def CpuRequest(self):
        """初始分配的 CPU 核数，对应 K8S request
        :rtype: str
        """
        return self._CpuRequest

    @CpuRequest.setter
    def CpuRequest(self, CpuRequest):
        self._CpuRequest = CpuRequest

    @property
    def MemRequest(self):
        """初始分配的内存 MiB 数，对应 K8S request
        :rtype: str
        """
        return self._MemRequest

    @MemRequest.setter
    def MemRequest(self, MemRequest):
        self._MemRequest = MemRequest

    @property
    def GroupResourceType(self):
        """部署组资源类型；
DEF — 默认资源类型；
GW — 网关资源类型；
        :rtype: str
        """
        return self._GroupResourceType

    @GroupResourceType.setter
    def GroupResourceType(self, GroupResourceType):
        self._GroupResourceType = GroupResourceType

    @property
    def SubnetId(self):
        """子网ID
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def AgentCpuRequest(self):
        """agent 容器分配的 CPU 核数，对应 K8S 的 request
        :rtype: str
        """
        return self._AgentCpuRequest

    @AgentCpuRequest.setter
    def AgentCpuRequest(self, AgentCpuRequest):
        self._AgentCpuRequest = AgentCpuRequest

    @property
    def AgentCpuLimit(self):
        """agent 容器最大的 CPU 核数，对应 K8S 的 limit
        :rtype: str
        """
        return self._AgentCpuLimit

    @AgentCpuLimit.setter
    def AgentCpuLimit(self, AgentCpuLimit):
        self._AgentCpuLimit = AgentCpuLimit

    @property
    def AgentMemRequest(self):
        """agent 容器分配的内存 MiB 数，对应 K8S 的 request
        :rtype: str
        """
        return self._AgentMemRequest

    @AgentMemRequest.setter
    def AgentMemRequest(self, AgentMemRequest):
        self._AgentMemRequest = AgentMemRequest

    @property
    def AgentMemLimit(self):
        """agent 容器最大的内存 MiB 数，对应 K8S 的 limit
        :rtype: str
        """
        return self._AgentMemLimit

    @AgentMemLimit.setter
    def AgentMemLimit(self, AgentMemLimit):
        self._AgentMemLimit = AgentMemLimit

    @property
    def IstioCpuRequest(self):
        """istioproxy 容器分配的 CPU 核数，对应 K8S 的 request
        :rtype: str
        """
        return self._IstioCpuRequest

    @IstioCpuRequest.setter
    def IstioCpuRequest(self, IstioCpuRequest):
        self._IstioCpuRequest = IstioCpuRequest

    @property
    def IstioCpuLimit(self):
        """istioproxy 容器最大的 CPU 核数，对应 K8S 的 limit
        :rtype: str
        """
        return self._IstioCpuLimit

    @IstioCpuLimit.setter
    def IstioCpuLimit(self, IstioCpuLimit):
        self._IstioCpuLimit = IstioCpuLimit

    @property
    def IstioMemRequest(self):
        """istioproxy 容器分配的内存 MiB 数，对应 K8S 的 request
        :rtype: str
        """
        return self._IstioMemRequest

    @IstioMemRequest.setter
    def IstioMemRequest(self, IstioMemRequest):
        self._IstioMemRequest = IstioMemRequest

    @property
    def IstioMemLimit(self):
        """istioproxy 容器最大的内存 MiB 数，对应 K8S 的 limit
        :rtype: str
        """
        return self._IstioMemLimit

    @IstioMemLimit.setter
    def IstioMemLimit(self, IstioMemLimit):
        self._IstioMemLimit = IstioMemLimit


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._NamespaceId = params.get("NamespaceId")
        self._GroupName = params.get("GroupName")
        self._InstanceNum = params.get("InstanceNum")
        self._AccessType = params.get("AccessType")
        if params.get("ProtocolPorts") is not None:
            self._ProtocolPorts = []
            for item in params.get("ProtocolPorts"):
                obj = ProtocolPort()
                obj._deserialize(item)
                self._ProtocolPorts.append(obj)
        self._ClusterId = params.get("ClusterId")
        self._CpuLimit = params.get("CpuLimit")
        self._MemLimit = params.get("MemLimit")
        self._GroupComment = params.get("GroupComment")
        self._UpdateType = params.get("UpdateType")
        self._UpdateIvl = params.get("UpdateIvl")
        self._CpuRequest = params.get("CpuRequest")
        self._MemRequest = params.get("MemRequest")
        self._GroupResourceType = params.get("GroupResourceType")
        self._SubnetId = params.get("SubnetId")
        self._AgentCpuRequest = params.get("AgentCpuRequest")
        self._AgentCpuLimit = params.get("AgentCpuLimit")
        self._AgentMemRequest = params.get("AgentMemRequest")
        self._AgentMemLimit = params.get("AgentMemLimit")
        self._IstioCpuRequest = params.get("IstioCpuRequest")
        self._IstioCpuLimit = params.get("IstioCpuLimit")
        self._IstioMemRequest = params.get("IstioMemRequest")
        self._IstioMemLimit = params.get("IstioMemLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateContainGroupResponse(AbstractModel):
    """CreateContainGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 返回创建成功的部署组ID，返回null表示失败
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """返回创建成功的部署组ID，返回null表示失败
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateFileConfigRequest(AbstractModel):
    """CreateFileConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigName: 配置项名称
        :type ConfigName: str
        :param _ConfigVersion: 配置项版本
        :type ConfigVersion: str
        :param _ConfigFileName: 配置项文件名
        :type ConfigFileName: str
        :param _ConfigFileValue: 配置项文件内容（原始内容编码需要 utf-8 格式，如果 ConfigFileCode 为 gbk，后台会进行转换）
        :type ConfigFileValue: str
        :param _ApplicationId: 配置项关联应用ID
        :type ApplicationId: str
        :param _ConfigFilePath: 发布路径
        :type ConfigFilePath: str
        :param _ConfigVersionDesc: 配置项版本描述
        :type ConfigVersionDesc: str
        :param _ConfigFileCode: 配置项文件编码，utf-8 或 gbk。注：如果选择 gbk，需要新版本 tsf-consul-template （公有云虚拟机需要使用 1.32 tsf-agent，容器需要从文档中获取最新的 tsf-consul-template-docker.tar.gz）的支持
        :type ConfigFileCode: str
        :param _ConfigPostCmd: 后置命令
        :type ConfigPostCmd: str
        :param _EncodeWithBase64: Base64编码的配置项
        :type EncodeWithBase64: bool
        :param _ProgramIdList: 无
        :type ProgramIdList: list of str
        """
        self._ConfigName = None
        self._ConfigVersion = None
        self._ConfigFileName = None
        self._ConfigFileValue = None
        self._ApplicationId = None
        self._ConfigFilePath = None
        self._ConfigVersionDesc = None
        self._ConfigFileCode = None
        self._ConfigPostCmd = None
        self._EncodeWithBase64 = None
        self._ProgramIdList = None

    @property
    def ConfigName(self):
        """配置项名称
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigVersion(self):
        """配置项版本
        :rtype: str
        """
        return self._ConfigVersion

    @ConfigVersion.setter
    def ConfigVersion(self, ConfigVersion):
        self._ConfigVersion = ConfigVersion

    @property
    def ConfigFileName(self):
        """配置项文件名
        :rtype: str
        """
        return self._ConfigFileName

    @ConfigFileName.setter
    def ConfigFileName(self, ConfigFileName):
        self._ConfigFileName = ConfigFileName

    @property
    def ConfigFileValue(self):
        """配置项文件内容（原始内容编码需要 utf-8 格式，如果 ConfigFileCode 为 gbk，后台会进行转换）
        :rtype: str
        """
        return self._ConfigFileValue

    @ConfigFileValue.setter
    def ConfigFileValue(self, ConfigFileValue):
        self._ConfigFileValue = ConfigFileValue

    @property
    def ApplicationId(self):
        """配置项关联应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ConfigFilePath(self):
        """发布路径
        :rtype: str
        """
        return self._ConfigFilePath

    @ConfigFilePath.setter
    def ConfigFilePath(self, ConfigFilePath):
        self._ConfigFilePath = ConfigFilePath

    @property
    def ConfigVersionDesc(self):
        """配置项版本描述
        :rtype: str
        """
        return self._ConfigVersionDesc

    @ConfigVersionDesc.setter
    def ConfigVersionDesc(self, ConfigVersionDesc):
        self._ConfigVersionDesc = ConfigVersionDesc

    @property
    def ConfigFileCode(self):
        """配置项文件编码，utf-8 或 gbk。注：如果选择 gbk，需要新版本 tsf-consul-template （公有云虚拟机需要使用 1.32 tsf-agent，容器需要从文档中获取最新的 tsf-consul-template-docker.tar.gz）的支持
        :rtype: str
        """
        return self._ConfigFileCode

    @ConfigFileCode.setter
    def ConfigFileCode(self, ConfigFileCode):
        self._ConfigFileCode = ConfigFileCode

    @property
    def ConfigPostCmd(self):
        """后置命令
        :rtype: str
        """
        return self._ConfigPostCmd

    @ConfigPostCmd.setter
    def ConfigPostCmd(self, ConfigPostCmd):
        self._ConfigPostCmd = ConfigPostCmd

    @property
    def EncodeWithBase64(self):
        """Base64编码的配置项
        :rtype: bool
        """
        return self._EncodeWithBase64

    @EncodeWithBase64.setter
    def EncodeWithBase64(self, EncodeWithBase64):
        self._EncodeWithBase64 = EncodeWithBase64

    @property
    def ProgramIdList(self):
        """无
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList


    def _deserialize(self, params):
        self._ConfigName = params.get("ConfigName")
        self._ConfigVersion = params.get("ConfigVersion")
        self._ConfigFileName = params.get("ConfigFileName")
        self._ConfigFileValue = params.get("ConfigFileValue")
        self._ApplicationId = params.get("ApplicationId")
        self._ConfigFilePath = params.get("ConfigFilePath")
        self._ConfigVersionDesc = params.get("ConfigVersionDesc")
        self._ConfigFileCode = params.get("ConfigFileCode")
        self._ConfigPostCmd = params.get("ConfigPostCmd")
        self._EncodeWithBase64 = params.get("EncodeWithBase64")
        self._ProgramIdList = params.get("ProgramIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateFileConfigResponse(AbstractModel):
    """CreateFileConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: true：创建成功；false：创建失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """true：创建成功；false：创建失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateFileConfigWithDetailRespRequest(AbstractModel):
    """CreateFileConfigWithDetailResp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigName: 配置项名称
        :type ConfigName: str
        :param _ConfigVersion: 配置项版本
        :type ConfigVersion: str
        :param _ConfigFileName: 配置项文件名
        :type ConfigFileName: str
        :param _ConfigFileValue: 配置项文件内容（原始内容编码需要 utf-8 格式，如果 ConfigFileCode 为 gbk，后台会进行转换）
        :type ConfigFileValue: str
        :param _ApplicationId: 配置项关联应用ID
        :type ApplicationId: str
        :param _ConfigFilePath: 发布路径
        :type ConfigFilePath: str
        :param _ConfigVersionDesc: 配置项版本描述
        :type ConfigVersionDesc: str
        :param _ConfigFileCode: 配置项文件编码，utf-8 或 gbk。注：如果选择 gbk，需要新版本 tsf-consul-template （公有云虚拟机需要使用 1.32 tsf-agent，容器需要从文档中获取最新的 tsf-consul-template-docker.tar.gz）的支持
        :type ConfigFileCode: str
        :param _ConfigPostCmd: 后置命令
        :type ConfigPostCmd: str
        :param _EncodeWithBase64: Base64编码的配置项
        :type EncodeWithBase64: bool
        :param _ProgramIdList: 无
        :type ProgramIdList: list of str
        """
        self._ConfigName = None
        self._ConfigVersion = None
        self._ConfigFileName = None
        self._ConfigFileValue = None
        self._ApplicationId = None
        self._ConfigFilePath = None
        self._ConfigVersionDesc = None
        self._ConfigFileCode = None
        self._ConfigPostCmd = None
        self._EncodeWithBase64 = None
        self._ProgramIdList = None

    @property
    def ConfigName(self):
        """配置项名称
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigVersion(self):
        """配置项版本
        :rtype: str
        """
        return self._ConfigVersion

    @ConfigVersion.setter
    def ConfigVersion(self, ConfigVersion):
        self._ConfigVersion = ConfigVersion

    @property
    def ConfigFileName(self):
        """配置项文件名
        :rtype: str
        """
        return self._ConfigFileName

    @ConfigFileName.setter
    def ConfigFileName(self, ConfigFileName):
        self._ConfigFileName = ConfigFileName

    @property
    def ConfigFileValue(self):
        """配置项文件内容（原始内容编码需要 utf-8 格式，如果 ConfigFileCode 为 gbk，后台会进行转换）
        :rtype: str
        """
        return self._ConfigFileValue

    @ConfigFileValue.setter
    def ConfigFileValue(self, ConfigFileValue):
        self._ConfigFileValue = ConfigFileValue

    @property
    def ApplicationId(self):
        """配置项关联应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ConfigFilePath(self):
        """发布路径
        :rtype: str
        """
        return self._ConfigFilePath

    @ConfigFilePath.setter
    def ConfigFilePath(self, ConfigFilePath):
        self._ConfigFilePath = ConfigFilePath

    @property
    def ConfigVersionDesc(self):
        """配置项版本描述
        :rtype: str
        """
        return self._ConfigVersionDesc

    @ConfigVersionDesc.setter
    def ConfigVersionDesc(self, ConfigVersionDesc):
        self._ConfigVersionDesc = ConfigVersionDesc

    @property
    def ConfigFileCode(self):
        """配置项文件编码，utf-8 或 gbk。注：如果选择 gbk，需要新版本 tsf-consul-template （公有云虚拟机需要使用 1.32 tsf-agent，容器需要从文档中获取最新的 tsf-consul-template-docker.tar.gz）的支持
        :rtype: str
        """
        return self._ConfigFileCode

    @ConfigFileCode.setter
    def ConfigFileCode(self, ConfigFileCode):
        self._ConfigFileCode = ConfigFileCode

    @property
    def ConfigPostCmd(self):
        """后置命令
        :rtype: str
        """
        return self._ConfigPostCmd

    @ConfigPostCmd.setter
    def ConfigPostCmd(self, ConfigPostCmd):
        self._ConfigPostCmd = ConfigPostCmd

    @property
    def EncodeWithBase64(self):
        """Base64编码的配置项
        :rtype: bool
        """
        return self._EncodeWithBase64

    @EncodeWithBase64.setter
    def EncodeWithBase64(self, EncodeWithBase64):
        self._EncodeWithBase64 = EncodeWithBase64

    @property
    def ProgramIdList(self):
        """无
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList


    def _deserialize(self, params):
        self._ConfigName = params.get("ConfigName")
        self._ConfigVersion = params.get("ConfigVersion")
        self._ConfigFileName = params.get("ConfigFileName")
        self._ConfigFileValue = params.get("ConfigFileValue")
        self._ApplicationId = params.get("ApplicationId")
        self._ConfigFilePath = params.get("ConfigFilePath")
        self._ConfigVersionDesc = params.get("ConfigVersionDesc")
        self._ConfigFileCode = params.get("ConfigFileCode")
        self._ConfigPostCmd = params.get("ConfigPostCmd")
        self._EncodeWithBase64 = params.get("EncodeWithBase64")
        self._ProgramIdList = params.get("ProgramIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateFileConfigWithDetailRespResponse(AbstractModel):
    """CreateFileConfigWithDetailResp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 文件配置项
        :type Result: :class:`tencentcloud.tsf.v20180326.models.FileConfig`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """文件配置项
        :rtype: :class:`tencentcloud.tsf.v20180326.models.FileConfig`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = FileConfig()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateGatewayApiRequest(AbstractModel):
    """CreateGatewayApi请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: API 分组ID
        :type GroupId: str
        :param _ApiList: Api信息
        :type ApiList: list of ApiInfo
        :param _ProgramIdList: 无
        :type ProgramIdList: list of str
        """
        self._GroupId = None
        self._ApiList = None
        self._ProgramIdList = None

    @property
    def GroupId(self):
        """API 分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def ApiList(self):
        """Api信息
        :rtype: list of ApiInfo
        """
        return self._ApiList

    @ApiList.setter
    def ApiList(self, ApiList):
        self._ApiList = ApiList

    @property
    def ProgramIdList(self):
        """无
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        if params.get("ApiList") is not None:
            self._ApiList = []
            for item in params.get("ApiList"):
                obj = ApiInfo()
                obj._deserialize(item)
                self._ApiList.append(obj)
        self._ProgramIdList = params.get("ProgramIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateGatewayApiResponse(AbstractModel):
    """CreateGatewayApi返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 是否成功
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """是否成功
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateGroupRequest(AbstractModel):
    """CreateGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplicationId: 部署组所属的应用ID
        :type ApplicationId: str
        :param _NamespaceId: 部署组所属命名空间ID
        :type NamespaceId: str
        :param _GroupName: 部署组名称
        :type GroupName: str
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _GroupDesc: 部署组描述
        :type GroupDesc: str
        :param _GroupResourceType: 部署组资源类型；DEF 表示默认资源类型；GW 表示网关资源类型
        :type GroupResourceType: str
        :param _Alias: 部署组备注
        :type Alias: str
        :param _Tags: 标签列表
        :type Tags: list of Tag
        """
        self._ApplicationId = None
        self._NamespaceId = None
        self._GroupName = None
        self._ClusterId = None
        self._GroupDesc = None
        self._GroupResourceType = None
        self._Alias = None
        self._Tags = None

    @property
    def ApplicationId(self):
        """部署组所属的应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def NamespaceId(self):
        """部署组所属命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def GroupName(self):
        """部署组名称
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def GroupDesc(self):
        """部署组描述
        :rtype: str
        """
        return self._GroupDesc

    @GroupDesc.setter
    def GroupDesc(self, GroupDesc):
        self._GroupDesc = GroupDesc

    @property
    def GroupResourceType(self):
        """部署组资源类型；DEF 表示默认资源类型；GW 表示网关资源类型
        :rtype: str
        """
        return self._GroupResourceType

    @GroupResourceType.setter
    def GroupResourceType(self, GroupResourceType):
        self._GroupResourceType = GroupResourceType

    @property
    def Alias(self):
        """部署组备注
        :rtype: str
        """
        return self._Alias

    @Alias.setter
    def Alias(self, Alias):
        self._Alias = Alias

    @property
    def Tags(self):
        """标签列表
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._NamespaceId = params.get("NamespaceId")
        self._GroupName = params.get("GroupName")
        self._ClusterId = params.get("ClusterId")
        self._GroupDesc = params.get("GroupDesc")
        self._GroupResourceType = params.get("GroupResourceType")
        self._Alias = params.get("Alias")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateGroupResponse(AbstractModel):
    """CreateGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: groupId， null表示创建失败
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """groupId， null表示创建失败
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateLaneRequest(AbstractModel):
    """CreateLane请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LaneName: 泳道名称
        :type LaneName: str
        :param _Remark: 泳道备注
        :type Remark: str
        :param _LaneGroupList: 泳道部署组信息
        :type LaneGroupList: list of LaneGroup
        :param _ProgramIdList: 无
        :type ProgramIdList: list of str
        """
        self._LaneName = None
        self._Remark = None
        self._LaneGroupList = None
        self._ProgramIdList = None

    @property
    def LaneName(self):
        """泳道名称
        :rtype: str
        """
        return self._LaneName

    @LaneName.setter
    def LaneName(self, LaneName):
        self._LaneName = LaneName

    @property
    def Remark(self):
        """泳道备注
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def LaneGroupList(self):
        """泳道部署组信息
        :rtype: list of LaneGroup
        """
        return self._LaneGroupList

    @LaneGroupList.setter
    def LaneGroupList(self, LaneGroupList):
        self._LaneGroupList = LaneGroupList

    @property
    def ProgramIdList(self):
        """无
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList


    def _deserialize(self, params):
        self._LaneName = params.get("LaneName")
        self._Remark = params.get("Remark")
        if params.get("LaneGroupList") is not None:
            self._LaneGroupList = []
            for item in params.get("LaneGroupList"):
                obj = LaneGroup()
                obj._deserialize(item)
                self._LaneGroupList.append(obj)
        self._ProgramIdList = params.get("ProgramIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLaneResponse(AbstractModel):
    """CreateLane返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 泳道ID
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """泳道ID
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateLaneRuleRequest(AbstractModel):
    """CreateLaneRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleName: 泳道规则名称
        :type RuleName: str
        :param _Remark: 泳道规则备注
        :type Remark: str
        :param _RuleTagList: 泳道规则标签列表
        :type RuleTagList: list of LaneRuleTag
        :param _RuleTagRelationship: 泳道规则标签关系
        :type RuleTagRelationship: str
        :param _LaneId: 泳道Id
        :type LaneId: str
        :param _ProgramIdList: 无
        :type ProgramIdList: list of str
        """
        self._RuleName = None
        self._Remark = None
        self._RuleTagList = None
        self._RuleTagRelationship = None
        self._LaneId = None
        self._ProgramIdList = None

    @property
    def RuleName(self):
        """泳道规则名称
        :rtype: str
        """
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Remark(self):
        """泳道规则备注
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def RuleTagList(self):
        """泳道规则标签列表
        :rtype: list of LaneRuleTag
        """
        return self._RuleTagList

    @RuleTagList.setter
    def RuleTagList(self, RuleTagList):
        self._RuleTagList = RuleTagList

    @property
    def RuleTagRelationship(self):
        """泳道规则标签关系
        :rtype: str
        """
        return self._RuleTagRelationship

    @RuleTagRelationship.setter
    def RuleTagRelationship(self, RuleTagRelationship):
        self._RuleTagRelationship = RuleTagRelationship

    @property
    def LaneId(self):
        """泳道Id
        :rtype: str
        """
        return self._LaneId

    @LaneId.setter
    def LaneId(self, LaneId):
        self._LaneId = LaneId

    @property
    def ProgramIdList(self):
        """无
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList


    def _deserialize(self, params):
        self._RuleName = params.get("RuleName")
        self._Remark = params.get("Remark")
        if params.get("RuleTagList") is not None:
            self._RuleTagList = []
            for item in params.get("RuleTagList"):
                obj = LaneRuleTag()
                obj._deserialize(item)
                self._RuleTagList.append(obj)
        self._RuleTagRelationship = params.get("RuleTagRelationship")
        self._LaneId = params.get("LaneId")
        self._ProgramIdList = params.get("ProgramIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLaneRuleResponse(AbstractModel):
    """CreateLaneRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 泳道规则Id
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """泳道规则Id
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateMicroserviceRequest(AbstractModel):
    """CreateMicroservice请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NamespaceId: 命名空间ID
        :type NamespaceId: str
        :param _MicroserviceName: 微服务名称
        :type MicroserviceName: str
        :param _MicroserviceDesc: 微服务描述信息
        :type MicroserviceDesc: str
        """
        self._NamespaceId = None
        self._MicroserviceName = None
        self._MicroserviceDesc = None

    @property
    def NamespaceId(self):
        """命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def MicroserviceName(self):
        """微服务名称
        :rtype: str
        """
        return self._MicroserviceName

    @MicroserviceName.setter
    def MicroserviceName(self, MicroserviceName):
        self._MicroserviceName = MicroserviceName

    @property
    def MicroserviceDesc(self):
        """微服务描述信息
        :rtype: str
        """
        return self._MicroserviceDesc

    @MicroserviceDesc.setter
    def MicroserviceDesc(self, MicroserviceDesc):
        self._MicroserviceDesc = MicroserviceDesc


    def _deserialize(self, params):
        self._NamespaceId = params.get("NamespaceId")
        self._MicroserviceName = params.get("MicroserviceName")
        self._MicroserviceDesc = params.get("MicroserviceDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMicroserviceResponse(AbstractModel):
    """CreateMicroservice返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 新增微服务是否成功。
true：操作成功。
false：操作失败。
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """新增微服务是否成功。
true：操作成功。
false：操作失败。
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateMicroserviceWithDetailRespRequest(AbstractModel):
    """CreateMicroserviceWithDetailResp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NamespaceId: 命名空间ID
        :type NamespaceId: str
        :param _MicroserviceName: 微服务名称
        :type MicroserviceName: str
        :param _MicroserviceDesc: 微服务描述信息
        :type MicroserviceDesc: str
        """
        self._NamespaceId = None
        self._MicroserviceName = None
        self._MicroserviceDesc = None

    @property
    def NamespaceId(self):
        """命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def MicroserviceName(self):
        """微服务名称
        :rtype: str
        """
        return self._MicroserviceName

    @MicroserviceName.setter
    def MicroserviceName(self, MicroserviceName):
        self._MicroserviceName = MicroserviceName

    @property
    def MicroserviceDesc(self):
        """微服务描述信息
        :rtype: str
        """
        return self._MicroserviceDesc

    @MicroserviceDesc.setter
    def MicroserviceDesc(self, MicroserviceDesc):
        self._MicroserviceDesc = MicroserviceDesc


    def _deserialize(self, params):
        self._NamespaceId = params.get("NamespaceId")
        self._MicroserviceName = params.get("MicroserviceName")
        self._MicroserviceDesc = params.get("MicroserviceDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMicroserviceWithDetailRespResponse(AbstractModel):
    """CreateMicroserviceWithDetailResp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 微服务ID
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """微服务ID
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateNamespaceRequest(AbstractModel):
    """CreateNamespace请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NamespaceName: 命名空间名称
        :type NamespaceName: str
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _NamespaceDesc: 命名空间描述
        :type NamespaceDesc: str
        :param _NamespaceResourceType: 命名空间资源类型(默认值为DEF)
        :type NamespaceResourceType: str
        :param _NamespaceType: 是否是全局命名空间(默认是DEF，表示普通命名空间；GLOBAL表示全局命名空间)
        :type NamespaceType: str
        :param _NamespaceId: 命名空间ID
        :type NamespaceId: str
        :param _IsHaEnable: 是否开启高可用，1 表示开启，0 表示不开启
        :type IsHaEnable: str
        :param _ProgramId: 需要绑定的数据集ID
        :type ProgramId: str
        :param _ProgramIdList: 需要绑定的数据集ID
        :type ProgramIdList: list of str
        """
        self._NamespaceName = None
        self._ClusterId = None
        self._NamespaceDesc = None
        self._NamespaceResourceType = None
        self._NamespaceType = None
        self._NamespaceId = None
        self._IsHaEnable = None
        self._ProgramId = None
        self._ProgramIdList = None

    @property
    def NamespaceName(self):
        """命名空间名称
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceDesc(self):
        """命名空间描述
        :rtype: str
        """
        return self._NamespaceDesc

    @NamespaceDesc.setter
    def NamespaceDesc(self, NamespaceDesc):
        self._NamespaceDesc = NamespaceDesc

    @property
    def NamespaceResourceType(self):
        """命名空间资源类型(默认值为DEF)
        :rtype: str
        """
        return self._NamespaceResourceType

    @NamespaceResourceType.setter
    def NamespaceResourceType(self, NamespaceResourceType):
        self._NamespaceResourceType = NamespaceResourceType

    @property
    def NamespaceType(self):
        """是否是全局命名空间(默认是DEF，表示普通命名空间；GLOBAL表示全局命名空间)
        :rtype: str
        """
        return self._NamespaceType

    @NamespaceType.setter
    def NamespaceType(self, NamespaceType):
        self._NamespaceType = NamespaceType

    @property
    def NamespaceId(self):
        """命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def IsHaEnable(self):
        """是否开启高可用，1 表示开启，0 表示不开启
        :rtype: str
        """
        return self._IsHaEnable

    @IsHaEnable.setter
    def IsHaEnable(self, IsHaEnable):
        self._IsHaEnable = IsHaEnable

    @property
    def ProgramId(self):
        """需要绑定的数据集ID
        :rtype: str
        """
        return self._ProgramId

    @ProgramId.setter
    def ProgramId(self, ProgramId):
        self._ProgramId = ProgramId

    @property
    def ProgramIdList(self):
        """需要绑定的数据集ID
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList


    def _deserialize(self, params):
        self._NamespaceName = params.get("NamespaceName")
        self._ClusterId = params.get("ClusterId")
        self._NamespaceDesc = params.get("NamespaceDesc")
        self._NamespaceResourceType = params.get("NamespaceResourceType")
        self._NamespaceType = params.get("NamespaceType")
        self._NamespaceId = params.get("NamespaceId")
        self._IsHaEnable = params.get("IsHaEnable")
        self._ProgramId = params.get("ProgramId")
        self._ProgramIdList = params.get("ProgramIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNamespaceResponse(AbstractModel):
    """CreateNamespace返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 成功时为命名空间ID，失败为null
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """成功时为命名空间ID，失败为null
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreatePathRewritesRequest(AbstractModel):
    """CreatePathRewrites请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PathRewrites: 路径重写列表
        :type PathRewrites: :class:`tencentcloud.tsf.v20180326.models.PathRewriteCreateObject`
        """
        self._PathRewrites = None

    @property
    def PathRewrites(self):
        """路径重写列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.PathRewriteCreateObject`
        """
        return self._PathRewrites

    @PathRewrites.setter
    def PathRewrites(self, PathRewrites):
        self._PathRewrites = PathRewrites


    def _deserialize(self, params):
        if params.get("PathRewrites") is not None:
            self._PathRewrites = PathRewriteCreateObject()
            self._PathRewrites._deserialize(params.get("PathRewrites"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePathRewritesResponse(AbstractModel):
    """CreatePathRewrites返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: true/false
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """true/false
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreatePathRewritesWithDetailRespRequest(AbstractModel):
    """CreatePathRewritesWithDetailResp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PathRewrites: 路径重写列表
        :type PathRewrites: list of PathRewriteCreateObject
        """
        self._PathRewrites = None

    @property
    def PathRewrites(self):
        """路径重写列表
        :rtype: list of PathRewriteCreateObject
        """
        return self._PathRewrites

    @PathRewrites.setter
    def PathRewrites(self, PathRewrites):
        self._PathRewrites = PathRewrites


    def _deserialize(self, params):
        if params.get("PathRewrites") is not None:
            self._PathRewrites = []
            for item in params.get("PathRewrites"):
                obj = PathRewriteCreateObject()
                obj._deserialize(item)
                self._PathRewrites.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePathRewritesWithDetailRespResponse(AbstractModel):
    """CreatePathRewritesWithDetailResp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 返回路径重写规则 ID
        :type Result: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """返回路径重写规则 ID
        :rtype: list of str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateProgramRequest(AbstractModel):
    """CreateProgram请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProgramName: 数据集名称
        :type ProgramName: str
        :param _ProgramDesc: 数据集描述
        :type ProgramDesc: str
        :param _ProgramItemList: 数据项列表，传入null或空数组时不新增
        :type ProgramItemList: list of ProgramItem
        """
        self._ProgramName = None
        self._ProgramDesc = None
        self._ProgramItemList = None

    @property
    def ProgramName(self):
        """数据集名称
        :rtype: str
        """
        return self._ProgramName

    @ProgramName.setter
    def ProgramName(self, ProgramName):
        self._ProgramName = ProgramName

    @property
    def ProgramDesc(self):
        """数据集描述
        :rtype: str
        """
        return self._ProgramDesc

    @ProgramDesc.setter
    def ProgramDesc(self, ProgramDesc):
        self._ProgramDesc = ProgramDesc

    @property
    def ProgramItemList(self):
        """数据项列表，传入null或空数组时不新增
        :rtype: list of ProgramItem
        """
        return self._ProgramItemList

    @ProgramItemList.setter
    def ProgramItemList(self, ProgramItemList):
        self._ProgramItemList = ProgramItemList


    def _deserialize(self, params):
        self._ProgramName = params.get("ProgramName")
        self._ProgramDesc = params.get("ProgramDesc")
        if params.get("ProgramItemList") is not None:
            self._ProgramItemList = []
            for item in params.get("ProgramItemList"):
                obj = ProgramItem()
                obj._deserialize(item)
                self._ProgramItemList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProgramResponse(AbstractModel):
    """CreateProgram返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: true: 创建成功；false: 创建失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """true: 创建成功；false: 创建失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreatePublicConfigRequest(AbstractModel):
    """CreatePublicConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigName: 配置项名称
        :type ConfigName: str
        :param _ConfigVersion: 配置项版本
        :type ConfigVersion: str
        :param _ConfigValue: 配置项值，总是接收yaml格式的内容
        :type ConfigValue: str
        :param _ConfigVersionDesc: 配置项版本描述
        :type ConfigVersionDesc: str
        :param _ConfigType: 配置项类型
        :type ConfigType: str
        :param _EncodeWithBase64: Base64编码的配置项
        :type EncodeWithBase64: bool
        :param _ProgramIdList: 无
        :type ProgramIdList: list of str
        """
        self._ConfigName = None
        self._ConfigVersion = None
        self._ConfigValue = None
        self._ConfigVersionDesc = None
        self._ConfigType = None
        self._EncodeWithBase64 = None
        self._ProgramIdList = None

    @property
    def ConfigName(self):
        """配置项名称
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigVersion(self):
        """配置项版本
        :rtype: str
        """
        return self._ConfigVersion

    @ConfigVersion.setter
    def ConfigVersion(self, ConfigVersion):
        self._ConfigVersion = ConfigVersion

    @property
    def ConfigValue(self):
        """配置项值，总是接收yaml格式的内容
        :rtype: str
        """
        return self._ConfigValue

    @ConfigValue.setter
    def ConfigValue(self, ConfigValue):
        self._ConfigValue = ConfigValue

    @property
    def ConfigVersionDesc(self):
        """配置项版本描述
        :rtype: str
        """
        return self._ConfigVersionDesc

    @ConfigVersionDesc.setter
    def ConfigVersionDesc(self, ConfigVersionDesc):
        self._ConfigVersionDesc = ConfigVersionDesc

    @property
    def ConfigType(self):
        """配置项类型
        :rtype: str
        """
        return self._ConfigType

    @ConfigType.setter
    def ConfigType(self, ConfigType):
        self._ConfigType = ConfigType

    @property
    def EncodeWithBase64(self):
        """Base64编码的配置项
        :rtype: bool
        """
        return self._EncodeWithBase64

    @EncodeWithBase64.setter
    def EncodeWithBase64(self, EncodeWithBase64):
        self._EncodeWithBase64 = EncodeWithBase64

    @property
    def ProgramIdList(self):
        """无
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList


    def _deserialize(self, params):
        self._ConfigName = params.get("ConfigName")
        self._ConfigVersion = params.get("ConfigVersion")
        self._ConfigValue = params.get("ConfigValue")
        self._ConfigVersionDesc = params.get("ConfigVersionDesc")
        self._ConfigType = params.get("ConfigType")
        self._EncodeWithBase64 = params.get("EncodeWithBase64")
        self._ProgramIdList = params.get("ProgramIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePublicConfigResponse(AbstractModel):
    """CreatePublicConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: true：创建成功；false：创建失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """true：创建成功；false：创建失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreatePublicConfigWithDetailRespRequest(AbstractModel):
    """CreatePublicConfigWithDetailResp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigName: 配置项名称
        :type ConfigName: str
        :param _ConfigVersion: 配置项版本
        :type ConfigVersion: str
        :param _ConfigValue: 配置项值，总是接收yaml格式的内容
        :type ConfigValue: str
        :param _ConfigVersionDesc: 配置项版本描述
        :type ConfigVersionDesc: str
        :param _ConfigType: 配置项类型
        :type ConfigType: str
        :param _EncodeWithBase64: Base64编码的配置项
        :type EncodeWithBase64: bool
        :param _ProgramIdList: 无
        :type ProgramIdList: list of str
        """
        self._ConfigName = None
        self._ConfigVersion = None
        self._ConfigValue = None
        self._ConfigVersionDesc = None
        self._ConfigType = None
        self._EncodeWithBase64 = None
        self._ProgramIdList = None

    @property
    def ConfigName(self):
        """配置项名称
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigVersion(self):
        """配置项版本
        :rtype: str
        """
        return self._ConfigVersion

    @ConfigVersion.setter
    def ConfigVersion(self, ConfigVersion):
        self._ConfigVersion = ConfigVersion

    @property
    def ConfigValue(self):
        """配置项值，总是接收yaml格式的内容
        :rtype: str
        """
        return self._ConfigValue

    @ConfigValue.setter
    def ConfigValue(self, ConfigValue):
        self._ConfigValue = ConfigValue

    @property
    def ConfigVersionDesc(self):
        """配置项版本描述
        :rtype: str
        """
        return self._ConfigVersionDesc

    @ConfigVersionDesc.setter
    def ConfigVersionDesc(self, ConfigVersionDesc):
        self._ConfigVersionDesc = ConfigVersionDesc

    @property
    def ConfigType(self):
        """配置项类型
        :rtype: str
        """
        return self._ConfigType

    @ConfigType.setter
    def ConfigType(self, ConfigType):
        self._ConfigType = ConfigType

    @property
    def EncodeWithBase64(self):
        """Base64编码的配置项
        :rtype: bool
        """
        return self._EncodeWithBase64

    @EncodeWithBase64.setter
    def EncodeWithBase64(self, EncodeWithBase64):
        self._EncodeWithBase64 = EncodeWithBase64

    @property
    def ProgramIdList(self):
        """无
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList


    def _deserialize(self, params):
        self._ConfigName = params.get("ConfigName")
        self._ConfigVersion = params.get("ConfigVersion")
        self._ConfigValue = params.get("ConfigValue")
        self._ConfigVersionDesc = params.get("ConfigVersionDesc")
        self._ConfigType = params.get("ConfigType")
        self._EncodeWithBase64 = params.get("EncodeWithBase64")
        self._ProgramIdList = params.get("ProgramIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePublicConfigWithDetailRespResponse(AbstractModel):
    """CreatePublicConfigWithDetailResp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 公共配置项 ID
        :type Result: :class:`tencentcloud.tsf.v20180326.models.Config`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """公共配置项 ID
        :rtype: :class:`tencentcloud.tsf.v20180326.models.Config`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = Config()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateRepositoryRequest(AbstractModel):
    """CreateRepository请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RepositoryName: 仓库名称
        :type RepositoryName: str
        :param _RepositoryType: 仓库类型（默认仓库：default，私有仓库：private）
        :type RepositoryType: str
        :param _BucketName: 仓库所在桶名称
        :type BucketName: str
        :param _BucketRegion: 仓库所在桶地域
        :type BucketRegion: str
        :param _Directory: 目录
        :type Directory: str
        :param _RepositoryDesc: 仓库描述
        :type RepositoryDesc: str
        """
        self._RepositoryName = None
        self._RepositoryType = None
        self._BucketName = None
        self._BucketRegion = None
        self._Directory = None
        self._RepositoryDesc = None

    @property
    def RepositoryName(self):
        """仓库名称
        :rtype: str
        """
        return self._RepositoryName

    @RepositoryName.setter
    def RepositoryName(self, RepositoryName):
        self._RepositoryName = RepositoryName

    @property
    def RepositoryType(self):
        """仓库类型（默认仓库：default，私有仓库：private）
        :rtype: str
        """
        return self._RepositoryType

    @RepositoryType.setter
    def RepositoryType(self, RepositoryType):
        self._RepositoryType = RepositoryType

    @property
    def BucketName(self):
        """仓库所在桶名称
        :rtype: str
        """
        return self._BucketName

    @BucketName.setter
    def BucketName(self, BucketName):
        self._BucketName = BucketName

    @property
    def BucketRegion(self):
        """仓库所在桶地域
        :rtype: str
        """
        return self._BucketRegion

    @BucketRegion.setter
    def BucketRegion(self, BucketRegion):
        self._BucketRegion = BucketRegion

    @property
    def Directory(self):
        """目录
        :rtype: str
        """
        return self._Directory

    @Directory.setter
    def Directory(self, Directory):
        self._Directory = Directory

    @property
    def RepositoryDesc(self):
        """仓库描述
        :rtype: str
        """
        return self._RepositoryDesc

    @RepositoryDesc.setter
    def RepositoryDesc(self, RepositoryDesc):
        self._RepositoryDesc = RepositoryDesc


    def _deserialize(self, params):
        self._RepositoryName = params.get("RepositoryName")
        self._RepositoryType = params.get("RepositoryType")
        self._BucketName = params.get("BucketName")
        self._BucketRegion = params.get("BucketRegion")
        self._Directory = params.get("Directory")
        self._RepositoryDesc = params.get("RepositoryDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRepositoryResponse(AbstractModel):
    """CreateRepository返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 创建仓库是否成功
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """创建仓库是否成功
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateTaskFlowRequest(AbstractModel):
    """CreateTaskFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowName: 工作流名称
        :type FlowName: str
        :param _TriggerRule: 触发方式
        :type TriggerRule: :class:`tencentcloud.tsf.v20180326.models.TaskRule`
        :param _FlowEdges: 工作流任务节点列表
        :type FlowEdges: list of TaskFlowEdge
        :param _TimeOut: 工作流执行超时时间
        :type TimeOut: int
        :param _ProgramIdList: 无
        :type ProgramIdList: list of str
        """
        self._FlowName = None
        self._TriggerRule = None
        self._FlowEdges = None
        self._TimeOut = None
        self._ProgramIdList = None

    @property
    def FlowName(self):
        """工作流名称
        :rtype: str
        """
        return self._FlowName

    @FlowName.setter
    def FlowName(self, FlowName):
        self._FlowName = FlowName

    @property
    def TriggerRule(self):
        """触发方式
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TaskRule`
        """
        return self._TriggerRule

    @TriggerRule.setter
    def TriggerRule(self, TriggerRule):
        self._TriggerRule = TriggerRule

    @property
    def FlowEdges(self):
        """工作流任务节点列表
        :rtype: list of TaskFlowEdge
        """
        return self._FlowEdges

    @FlowEdges.setter
    def FlowEdges(self, FlowEdges):
        self._FlowEdges = FlowEdges

    @property
    def TimeOut(self):
        """工作流执行超时时间
        :rtype: int
        """
        return self._TimeOut

    @TimeOut.setter
    def TimeOut(self, TimeOut):
        self._TimeOut = TimeOut

    @property
    def ProgramIdList(self):
        """无
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList


    def _deserialize(self, params):
        self._FlowName = params.get("FlowName")
        if params.get("TriggerRule") is not None:
            self._TriggerRule = TaskRule()
            self._TriggerRule._deserialize(params.get("TriggerRule"))
        if params.get("FlowEdges") is not None:
            self._FlowEdges = []
            for item in params.get("FlowEdges"):
                obj = TaskFlowEdge()
                obj._deserialize(item)
                self._FlowEdges.append(obj)
        self._TimeOut = params.get("TimeOut")
        self._ProgramIdList = params.get("ProgramIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskFlowResponse(AbstractModel):
    """CreateTaskFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 工作流 ID
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """工作流 ID
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateTaskRequest(AbstractModel):
    """CreateTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskName: 任务名称，任务长度64字符
        :type TaskName: str
        :param _TaskContent: 任务内容，长度限制65536个字节
        :type TaskContent: str
        :param _ExecuteType: 执行类型，unicast/broadcast
        :type ExecuteType: str
        :param _TaskType: 任务类型,java
        :type TaskType: str
        :param _TimeOut: 任务超时时间， 时间单位 ms
        :type TimeOut: int
        :param _GroupId: 部署组ID
        :type GroupId: str
        :param _TaskRule: 触发规则
        :type TaskRule: :class:`tencentcloud.tsf.v20180326.models.TaskRule`
        :param _RetryCount: 重试次数，0 <= RetryCount<= 10
        :type RetryCount: int
        :param _RetryInterval: 重试间隔， 0 <= RetryInterval <= 600000， 时间单位 ms
        :type RetryInterval: int
        :param _ShardCount: 分片数量
        :type ShardCount: int
        :param _ShardArguments: 分片参数
        :type ShardArguments: list of ShardArgument
        :param _SuccessOperator: 判断任务成功的操作符
        :type SuccessOperator: str
        :param _SuccessRatio: 判断任务成功率的阈值，如100
        :type SuccessRatio: str
        :param _AdvanceSettings: 高级设置
        :type AdvanceSettings: :class:`tencentcloud.tsf.v20180326.models.AdvanceSettings`
        :param _TaskArgument: 任务参数，长度限制10000个字符
        :type TaskArgument: str
        :param _ProgramIdList: 无
        :type ProgramIdList: list of str
        """
        self._TaskName = None
        self._TaskContent = None
        self._ExecuteType = None
        self._TaskType = None
        self._TimeOut = None
        self._GroupId = None
        self._TaskRule = None
        self._RetryCount = None
        self._RetryInterval = None
        self._ShardCount = None
        self._ShardArguments = None
        self._SuccessOperator = None
        self._SuccessRatio = None
        self._AdvanceSettings = None
        self._TaskArgument = None
        self._ProgramIdList = None

    @property
    def TaskName(self):
        """任务名称，任务长度64字符
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskContent(self):
        """任务内容，长度限制65536个字节
        :rtype: str
        """
        return self._TaskContent

    @TaskContent.setter
    def TaskContent(self, TaskContent):
        self._TaskContent = TaskContent

    @property
    def ExecuteType(self):
        """执行类型，unicast/broadcast
        :rtype: str
        """
        return self._ExecuteType

    @ExecuteType.setter
    def ExecuteType(self, ExecuteType):
        self._ExecuteType = ExecuteType

    @property
    def TaskType(self):
        """任务类型,java
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TimeOut(self):
        """任务超时时间， 时间单位 ms
        :rtype: int
        """
        return self._TimeOut

    @TimeOut.setter
    def TimeOut(self, TimeOut):
        self._TimeOut = TimeOut

    @property
    def GroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def TaskRule(self):
        """触发规则
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TaskRule`
        """
        return self._TaskRule

    @TaskRule.setter
    def TaskRule(self, TaskRule):
        self._TaskRule = TaskRule

    @property
    def RetryCount(self):
        """重试次数，0 <= RetryCount<= 10
        :rtype: int
        """
        return self._RetryCount

    @RetryCount.setter
    def RetryCount(self, RetryCount):
        self._RetryCount = RetryCount

    @property
    def RetryInterval(self):
        """重试间隔， 0 <= RetryInterval <= 600000， 时间单位 ms
        :rtype: int
        """
        return self._RetryInterval

    @RetryInterval.setter
    def RetryInterval(self, RetryInterval):
        self._RetryInterval = RetryInterval

    @property
    def ShardCount(self):
        """分片数量
        :rtype: int
        """
        return self._ShardCount

    @ShardCount.setter
    def ShardCount(self, ShardCount):
        self._ShardCount = ShardCount

    @property
    def ShardArguments(self):
        """分片参数
        :rtype: list of ShardArgument
        """
        return self._ShardArguments

    @ShardArguments.setter
    def ShardArguments(self, ShardArguments):
        self._ShardArguments = ShardArguments

    @property
    def SuccessOperator(self):
        """判断任务成功的操作符
        :rtype: str
        """
        return self._SuccessOperator

    @SuccessOperator.setter
    def SuccessOperator(self, SuccessOperator):
        self._SuccessOperator = SuccessOperator

    @property
    def SuccessRatio(self):
        """判断任务成功率的阈值，如100
        :rtype: str
        """
        return self._SuccessRatio

    @SuccessRatio.setter
    def SuccessRatio(self, SuccessRatio):
        self._SuccessRatio = SuccessRatio

    @property
    def AdvanceSettings(self):
        """高级设置
        :rtype: :class:`tencentcloud.tsf.v20180326.models.AdvanceSettings`
        """
        return self._AdvanceSettings

    @AdvanceSettings.setter
    def AdvanceSettings(self, AdvanceSettings):
        self._AdvanceSettings = AdvanceSettings

    @property
    def TaskArgument(self):
        """任务参数，长度限制10000个字符
        :rtype: str
        """
        return self._TaskArgument

    @TaskArgument.setter
    def TaskArgument(self, TaskArgument):
        self._TaskArgument = TaskArgument

    @property
    def ProgramIdList(self):
        """无
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList


    def _deserialize(self, params):
        self._TaskName = params.get("TaskName")
        self._TaskContent = params.get("TaskContent")
        self._ExecuteType = params.get("ExecuteType")
        self._TaskType = params.get("TaskType")
        self._TimeOut = params.get("TimeOut")
        self._GroupId = params.get("GroupId")
        if params.get("TaskRule") is not None:
            self._TaskRule = TaskRule()
            self._TaskRule._deserialize(params.get("TaskRule"))
        self._RetryCount = params.get("RetryCount")
        self._RetryInterval = params.get("RetryInterval")
        self._ShardCount = params.get("ShardCount")
        if params.get("ShardArguments") is not None:
            self._ShardArguments = []
            for item in params.get("ShardArguments"):
                obj = ShardArgument()
                obj._deserialize(item)
                self._ShardArguments.append(obj)
        self._SuccessOperator = params.get("SuccessOperator")
        self._SuccessRatio = params.get("SuccessRatio")
        if params.get("AdvanceSettings") is not None:
            self._AdvanceSettings = AdvanceSettings()
            self._AdvanceSettings._deserialize(params.get("AdvanceSettings"))
        self._TaskArgument = params.get("TaskArgument")
        self._ProgramIdList = params.get("ProgramIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskResponse(AbstractModel):
    """CreateTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 任务ID
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """任务ID
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateUnitNamespacesRequest(AbstractModel):
    """CreateUnitNamespaces请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayInstanceId: 网关实体ID
        :type GatewayInstanceId: str
        :param _UnitNamespaceList: 单元化命名空间对象列表
        :type UnitNamespaceList: list of UnitNamespace
        """
        self._GatewayInstanceId = None
        self._UnitNamespaceList = None

    @property
    def GatewayInstanceId(self):
        """网关实体ID
        :rtype: str
        """
        return self._GatewayInstanceId

    @GatewayInstanceId.setter
    def GatewayInstanceId(self, GatewayInstanceId):
        self._GatewayInstanceId = GatewayInstanceId

    @property
    def UnitNamespaceList(self):
        """单元化命名空间对象列表
        :rtype: list of UnitNamespace
        """
        return self._UnitNamespaceList

    @UnitNamespaceList.setter
    def UnitNamespaceList(self, UnitNamespaceList):
        self._UnitNamespaceList = UnitNamespaceList


    def _deserialize(self, params):
        self._GatewayInstanceId = params.get("GatewayInstanceId")
        if params.get("UnitNamespaceList") is not None:
            self._UnitNamespaceList = []
            for item in params.get("UnitNamespaceList"):
                obj = UnitNamespace()
                obj._deserialize(item)
                self._UnitNamespaceList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateUnitNamespacesResponse(AbstractModel):
    """CreateUnitNamespaces返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 是否成功
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """是否成功
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateUnitRuleRequest(AbstractModel):
    """CreateUnitRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayInstanceId: 网关实体ID
        :type GatewayInstanceId: str
        :param _Name: 规则名称
        :type Name: str
        :param _Description: 规则描述
        :type Description: str
        :param _UnitRuleItemList: 规则项列表
        :type UnitRuleItemList: list of UnitRuleItem
        """
        self._GatewayInstanceId = None
        self._Name = None
        self._Description = None
        self._UnitRuleItemList = None

    @property
    def GatewayInstanceId(self):
        """网关实体ID
        :rtype: str
        """
        return self._GatewayInstanceId

    @GatewayInstanceId.setter
    def GatewayInstanceId(self, GatewayInstanceId):
        self._GatewayInstanceId = GatewayInstanceId

    @property
    def Name(self):
        """规则名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        """规则描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def UnitRuleItemList(self):
        """规则项列表
        :rtype: list of UnitRuleItem
        """
        return self._UnitRuleItemList

    @UnitRuleItemList.setter
    def UnitRuleItemList(self, UnitRuleItemList):
        self._UnitRuleItemList = UnitRuleItemList


    def _deserialize(self, params):
        self._GatewayInstanceId = params.get("GatewayInstanceId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        if params.get("UnitRuleItemList") is not None:
            self._UnitRuleItemList = []
            for item in params.get("UnitRuleItemList"):
                obj = UnitRuleItem()
                obj._deserialize(item)
                self._UnitRuleItemList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateUnitRuleResponse(AbstractModel):
    """CreateUnitRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 是否成功，成功：true，失败：false。；
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """是否成功，成功：true，失败：false。；
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateUnitRuleWithDetailRespRequest(AbstractModel):
    """CreateUnitRuleWithDetailResp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayInstanceId: 网关实体ID
        :type GatewayInstanceId: str
        :param _Name: 规则名称
        :type Name: str
        :param _Description: 规则描述
        :type Description: str
        :param _UnitRuleItemList: 规则项列表
        :type UnitRuleItemList: list of UnitRuleItem
        """
        self._GatewayInstanceId = None
        self._Name = None
        self._Description = None
        self._UnitRuleItemList = None

    @property
    def GatewayInstanceId(self):
        """网关实体ID
        :rtype: str
        """
        return self._GatewayInstanceId

    @GatewayInstanceId.setter
    def GatewayInstanceId(self, GatewayInstanceId):
        self._GatewayInstanceId = GatewayInstanceId

    @property
    def Name(self):
        """规则名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        """规则描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def UnitRuleItemList(self):
        """规则项列表
        :rtype: list of UnitRuleItem
        """
        return self._UnitRuleItemList

    @UnitRuleItemList.setter
    def UnitRuleItemList(self, UnitRuleItemList):
        self._UnitRuleItemList = UnitRuleItemList


    def _deserialize(self, params):
        self._GatewayInstanceId = params.get("GatewayInstanceId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        if params.get("UnitRuleItemList") is not None:
            self._UnitRuleItemList = []
            for item in params.get("UnitRuleItemList"):
                obj = UnitRuleItem()
                obj._deserialize(item)
                self._UnitRuleItemList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateUnitRuleWithDetailRespResponse(AbstractModel):
    """CreateUnitRuleWithDetailResp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 单元化规则信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.UnitRule`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """单元化规则信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.UnitRule`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = UnitRule()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CurvePoint(AbstractModel):
    """构成监控数据图的曲线坐标点

    """

    def __init__(self):
        r"""
        :param _Label: 当前坐标 X轴的值 当前是日期格式:"yyyy-MM-dd HH:mm:ss"
        :type Label: str
        :param _Value: 当前坐标 Y轴的值
        :type Value: str
        :param _Timestamp: 该坐标点时间戳
        :type Timestamp: str
        """
        self._Label = None
        self._Value = None
        self._Timestamp = None

    @property
    def Label(self):
        """当前坐标 X轴的值 当前是日期格式:"yyyy-MM-dd HH:mm:ss"
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Value(self):
        """当前坐标 Y轴的值
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Timestamp(self):
        """该坐标点时间戳
        :rtype: str
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp


    def _deserialize(self, params):
        self._Label = params.get("Label")
        self._Value = params.get("Value")
        self._Timestamp = params.get("Timestamp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomPodSchedule(AbstractModel):
    """自定义Pod调度规则

    """

    def __init__(self):
        r"""
        :param _ForceSchedule: -
        :type ForceSchedule: :class:`tencentcloud.tsf.v20180326.models.ForceSchedule`
        :param _TrySchedule: -
        :type TrySchedule: :class:`tencentcloud.tsf.v20180326.models.TrySchedule`
        """
        self._ForceSchedule = None
        self._TrySchedule = None

    @property
    def ForceSchedule(self):
        """-
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ForceSchedule`
        """
        return self._ForceSchedule

    @ForceSchedule.setter
    def ForceSchedule(self, ForceSchedule):
        self._ForceSchedule = ForceSchedule

    @property
    def TrySchedule(self):
        """-
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TrySchedule`
        """
        return self._TrySchedule

    @TrySchedule.setter
    def TrySchedule(self, TrySchedule):
        self._TrySchedule = TrySchedule


    def _deserialize(self, params):
        if params.get("ForceSchedule") is not None:
            self._ForceSchedule = ForceSchedule()
            self._ForceSchedule._deserialize(params.get("ForceSchedule"))
        if params.get("TrySchedule") is not None:
            self._TrySchedule = TrySchedule()
            self._TrySchedule._deserialize(params.get("TrySchedule"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomTolerateSchedule(AbstractModel):
    """自定义容忍调度规则列表

    """

    def __init__(self):
        r"""
        :param _Key: -
        :type Key: str
        :param _Operator: -
        :type Operator: str
        :param _Value: -
        :type Value: str
        :param _Effect: -
        :type Effect: str
        :param _TolerationSeconds: -
        :type TolerationSeconds: int
        """
        self._Key = None
        self._Operator = None
        self._Value = None
        self._Effect = None
        self._TolerationSeconds = None

    @property
    def Key(self):
        """-
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Operator(self):
        """-
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def Value(self):
        """-
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Effect(self):
        """-
        :rtype: str
        """
        return self._Effect

    @Effect.setter
    def Effect(self, Effect):
        self._Effect = Effect

    @property
    def TolerationSeconds(self):
        """-
        :rtype: int
        """
        return self._TolerationSeconds

    @TolerationSeconds.setter
    def TolerationSeconds(self, TolerationSeconds):
        self._TolerationSeconds = TolerationSeconds


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Operator = params.get("Operator")
        self._Value = params.get("Value")
        self._Effect = params.get("Effect")
        self._TolerationSeconds = params.get("TolerationSeconds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteApiGroupRequest(AbstractModel):
    """DeleteApiGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: API 分组ID
        :type GroupId: str
        """
        self._GroupId = None

    @property
    def GroupId(self):
        """API 分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteApiGroupResponse(AbstractModel):
    """DeleteApiGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 成功失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """成功失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteApiRateLimitRuleRequest(AbstractModel):
    """DeleteApiRateLimitRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 限流规则ID
        :type RuleId: str
        """
        self._RuleId = None

    @property
    def RuleId(self):
        """限流规则ID
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteApiRateLimitRuleResponse(AbstractModel):
    """DeleteApiRateLimitRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 是否成功
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """是否成功
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteApplicationRequest(AbstractModel):
    """DeleteApplication请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        :param _SyncDeleteImageRepository: 是否删除镜像仓库
        :type SyncDeleteImageRepository: bool
        """
        self._ApplicationId = None
        self._SyncDeleteImageRepository = None

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def SyncDeleteImageRepository(self):
        """是否删除镜像仓库
        :rtype: bool
        """
        return self._SyncDeleteImageRepository

    @SyncDeleteImageRepository.setter
    def SyncDeleteImageRepository(self, SyncDeleteImageRepository):
        self._SyncDeleteImageRepository = SyncDeleteImageRepository


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._SyncDeleteImageRepository = params.get("SyncDeleteImageRepository")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteApplicationResponse(AbstractModel):
    """DeleteApplication返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 删除应用操作是否成功。
true：操作成功。
false：操作失败。
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """删除应用操作是否成功。
true：操作成功。
false：操作失败。
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteClusterRequest(AbstractModel):
    """DeleteCluster请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _Unbind: 是否只解绑，不删除容器集群，默认不传则删除容器集群。
        :type Unbind: bool
        """
        self._ClusterId = None
        self._Unbind = None

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Unbind(self):
        """是否只解绑，不删除容器集群，默认不传则删除容器集群。
        :rtype: bool
        """
        return self._Unbind

    @Unbind.setter
    def Unbind(self, Unbind):
        self._Unbind = Unbind


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Unbind = params.get("Unbind")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClusterResponse(AbstractModel):
    """DeleteCluster返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 删除集群操作是否成功。
true：操作成功。
false：操作失败。
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """删除集群操作是否成功。
true：操作成功。
false：操作失败。
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteConfigRequest(AbstractModel):
    """DeleteConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置项ID
        :type ConfigId: str
        """
        self._ConfigId = None

    @property
    def ConfigId(self):
        """配置项ID
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteConfigResponse(AbstractModel):
    """DeleteConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: true：删除成功；false：删除失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """true：删除成功；false：删除失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteConfigTemplateRequest(AbstractModel):
    """DeleteConfigTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigTemplateId: 无
        :type ConfigTemplateId: str
        """
        self._ConfigTemplateId = None

    @property
    def ConfigTemplateId(self):
        """无
        :rtype: str
        """
        return self._ConfigTemplateId

    @ConfigTemplateId.setter
    def ConfigTemplateId(self, ConfigTemplateId):
        self._ConfigTemplateId = ConfigTemplateId


    def _deserialize(self, params):
        self._ConfigTemplateId = params.get("ConfigTemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteConfigTemplateResponse(AbstractModel):
    """DeleteConfigTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: true：删除成功；false：删除失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """true：删除成功；false：删除失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteContainerGroupRequest(AbstractModel):
    """DeleteContainerGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID，分组唯一标识
        :type GroupId: str
        """
        self._GroupId = None

    @property
    def GroupId(self):
        """部署组ID，分组唯一标识
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteContainerGroupResponse(AbstractModel):
    """DeleteContainerGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 删除操作是否成功：
true：成功
false：失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """删除操作是否成功：
true：成功
false：失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteFileConfigRequest(AbstractModel):
    """DeleteFileConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 文件配置项ID
        :type ConfigId: str
        """
        self._ConfigId = None

    @property
    def ConfigId(self):
        """文件配置项ID
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFileConfigResponse(AbstractModel):
    """DeleteFileConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 删除结果
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """删除结果
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteGatewayApiRequest(AbstractModel):
    """DeleteGatewayApi请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 分组ID
        :type GroupId: str
        :param _ApiList: Api ID 数组
        :type ApiList: list of str
        """
        self._GroupId = None
        self._ApiList = None

    @property
    def GroupId(self):
        """分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def ApiList(self):
        """Api ID 数组
        :rtype: list of str
        """
        return self._ApiList

    @ApiList.setter
    def ApiList(self, ApiList):
        self._ApiList = ApiList


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._ApiList = params.get("ApiList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteGatewayApiResponse(AbstractModel):
    """DeleteGatewayApi返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 是否成功
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """是否成功
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteGroupRequest(AbstractModel):
    """DeleteGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID
        :type GroupId: str
        """
        self._GroupId = None

    @property
    def GroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteGroupResponse(AbstractModel):
    """DeleteGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 删除部署组操作是否成功。
true：操作成功。
false：操作失败。
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """删除部署组操作是否成功。
true：操作成功。
false：操作失败。
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteImageTag(AbstractModel):
    """需要删除的镜像版本

    """

    def __init__(self):
        r"""
        :param _RepoName: 仓库名，如/tsf/nginx
        :type RepoName: str
        :param _TagName: 版本号:如V1
        :type TagName: str
        """
        self._RepoName = None
        self._TagName = None

    @property
    def RepoName(self):
        """仓库名，如/tsf/nginx
        :rtype: str
        """
        return self._RepoName

    @RepoName.setter
    def RepoName(self, RepoName):
        self._RepoName = RepoName

    @property
    def TagName(self):
        """版本号:如V1
        :rtype: str
        """
        return self._TagName

    @TagName.setter
    def TagName(self, TagName):
        self._TagName = TagName


    def _deserialize(self, params):
        self._RepoName = params.get("RepoName")
        self._TagName = params.get("TagName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteImageTagsRequest(AbstractModel):
    """DeleteImageTags请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageTags: 镜像版本数组
        :type ImageTags: list of DeleteImageTag
        :param _RepoType: 企业: tcr ；个人: personal或者不填
        :type RepoType: str
        """
        self._ImageTags = None
        self._RepoType = None

    @property
    def ImageTags(self):
        """镜像版本数组
        :rtype: list of DeleteImageTag
        """
        return self._ImageTags

    @ImageTags.setter
    def ImageTags(self, ImageTags):
        self._ImageTags = ImageTags

    @property
    def RepoType(self):
        """企业: tcr ；个人: personal或者不填
        :rtype: str
        """
        return self._RepoType

    @RepoType.setter
    def RepoType(self, RepoType):
        self._RepoType = RepoType


    def _deserialize(self, params):
        if params.get("ImageTags") is not None:
            self._ImageTags = []
            for item in params.get("ImageTags"):
                obj = DeleteImageTag()
                obj._deserialize(item)
                self._ImageTags.append(obj)
        self._RepoType = params.get("RepoType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteImageTagsResponse(AbstractModel):
    """DeleteImageTags返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 批量删除操作是否成功。
true：成功。
false：失败。
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """批量删除操作是否成功。
true：成功。
false：失败。
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteLaneRequest(AbstractModel):
    """DeleteLane请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LaneId: 泳道Idl
        :type LaneId: str
        """
        self._LaneId = None

    @property
    def LaneId(self):
        """泳道Idl
        :rtype: str
        """
        return self._LaneId

    @LaneId.setter
    def LaneId(self, LaneId):
        self._LaneId = LaneId


    def _deserialize(self, params):
        self._LaneId = params.get("LaneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLaneResponse(AbstractModel):
    """DeleteLane返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 删除成功: true / 删除失败: false
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """删除成功: true / 删除失败: false
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteLaneRuleRequest(AbstractModel):
    """DeleteLaneRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 泳道规则Id
        :type RuleId: str
        """
        self._RuleId = None

    @property
    def RuleId(self):
        """泳道规则Id
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLaneRuleResponse(AbstractModel):
    """DeleteLaneRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 操作状态
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """操作状态
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteMicroserviceRequest(AbstractModel):
    """DeleteMicroservice请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MicroserviceId: 微服务ID
        :type MicroserviceId: str
        """
        self._MicroserviceId = None

    @property
    def MicroserviceId(self):
        """微服务ID
        :rtype: str
        """
        return self._MicroserviceId

    @MicroserviceId.setter
    def MicroserviceId(self, MicroserviceId):
        self._MicroserviceId = MicroserviceId


    def _deserialize(self, params):
        self._MicroserviceId = params.get("MicroserviceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMicroserviceResponse(AbstractModel):
    """DeleteMicroservice返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 删除微服务是否成功。
true：操作成功。
false：操作失败。
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """删除微服务是否成功。
true：操作成功。
false：操作失败。
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteNamespaceRequest(AbstractModel):
    """DeleteNamespace请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NamespaceId: 命名空间ID
        :type NamespaceId: str
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._NamespaceId = None
        self._ClusterId = None

    @property
    def NamespaceId(self):
        """命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._NamespaceId = params.get("NamespaceId")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNamespaceResponse(AbstractModel):
    """DeleteNamespace返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 删除命名空间是否成功。
true：删除成功。
false：删除失败。
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """删除命名空间是否成功。
true：删除成功。
false：删除失败。
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeletePathRewritesRequest(AbstractModel):
    """DeletePathRewrites请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PathRewriteIds: 路径重写规则IDs
        :type PathRewriteIds: list of str
        """
        self._PathRewriteIds = None

    @property
    def PathRewriteIds(self):
        """路径重写规则IDs
        :rtype: list of str
        """
        return self._PathRewriteIds

    @PathRewriteIds.setter
    def PathRewriteIds(self, PathRewriteIds):
        self._PathRewriteIds = PathRewriteIds


    def _deserialize(self, params):
        self._PathRewriteIds = params.get("PathRewriteIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePathRewritesResponse(AbstractModel):
    """DeletePathRewrites返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: true/false
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """true/false
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeletePkgsRequest(AbstractModel):
    """DeletePkgs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        :param _PkgIds: 需要删除的程序包ID列表
        :type PkgIds: list of str
        :param _RepositoryType: 程序包仓库类型
        :type RepositoryType: str
        :param _RepositoryId: 程序包仓库id
        :type RepositoryId: str
        """
        self._ApplicationId = None
        self._PkgIds = None
        self._RepositoryType = None
        self._RepositoryId = None

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def PkgIds(self):
        """需要删除的程序包ID列表
        :rtype: list of str
        """
        return self._PkgIds

    @PkgIds.setter
    def PkgIds(self, PkgIds):
        self._PkgIds = PkgIds

    @property
    def RepositoryType(self):
        """程序包仓库类型
        :rtype: str
        """
        return self._RepositoryType

    @RepositoryType.setter
    def RepositoryType(self, RepositoryType):
        self._RepositoryType = RepositoryType

    @property
    def RepositoryId(self):
        """程序包仓库id
        :rtype: str
        """
        return self._RepositoryId

    @RepositoryId.setter
    def RepositoryId(self, RepositoryId):
        self._RepositoryId = RepositoryId


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._PkgIds = params.get("PkgIds")
        self._RepositoryType = params.get("RepositoryType")
        self._RepositoryId = params.get("RepositoryId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePkgsResponse(AbstractModel):
    """DeletePkgs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePublicConfigRequest(AbstractModel):
    """DeletePublicConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置项ID
        :type ConfigId: str
        """
        self._ConfigId = None

    @property
    def ConfigId(self):
        """配置项ID
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePublicConfigResponse(AbstractModel):
    """DeletePublicConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: true：删除成功；false：删除失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """true：删除成功；false：删除失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteRepositoryRequest(AbstractModel):
    """DeleteRepository请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RepositoryId: 仓库ID
        :type RepositoryId: str
        """
        self._RepositoryId = None

    @property
    def RepositoryId(self):
        """仓库ID
        :rtype: str
        """
        return self._RepositoryId

    @RepositoryId.setter
    def RepositoryId(self, RepositoryId):
        self._RepositoryId = RepositoryId


    def _deserialize(self, params):
        self._RepositoryId = params.get("RepositoryId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRepositoryResponse(AbstractModel):
    """DeleteRepository返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 删除仓库是否成功
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """删除仓库是否成功
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteServerlessGroupRequest(AbstractModel):
    """DeleteServerlessGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: groupId，分组唯一标识
        :type GroupId: str
        """
        self._GroupId = None

    @property
    def GroupId(self):
        """groupId，分组唯一标识
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteServerlessGroupResponse(AbstractModel):
    """DeleteServerlessGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 结果true：成功；false：失败。
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """结果true：成功；false：失败。
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteTaskRequest(AbstractModel):
    """DeleteTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTaskResponse(AbstractModel):
    """DeleteTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 删除成功or失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """删除成功or失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteUnitNamespacesRequest(AbstractModel):
    """DeleteUnitNamespaces请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayInstanceId: 网关实体ID
        :type GatewayInstanceId: str
        :param _UnitNamespaceList: 单元化命名空间ID数组
        :type UnitNamespaceList: list of str
        """
        self._GatewayInstanceId = None
        self._UnitNamespaceList = None

    @property
    def GatewayInstanceId(self):
        """网关实体ID
        :rtype: str
        """
        return self._GatewayInstanceId

    @GatewayInstanceId.setter
    def GatewayInstanceId(self, GatewayInstanceId):
        self._GatewayInstanceId = GatewayInstanceId

    @property
    def UnitNamespaceList(self):
        """单元化命名空间ID数组
        :rtype: list of str
        """
        return self._UnitNamespaceList

    @UnitNamespaceList.setter
    def UnitNamespaceList(self, UnitNamespaceList):
        self._UnitNamespaceList = UnitNamespaceList


    def _deserialize(self, params):
        self._GatewayInstanceId = params.get("GatewayInstanceId")
        self._UnitNamespaceList = params.get("UnitNamespaceList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteUnitNamespacesResponse(AbstractModel):
    """DeleteUnitNamespaces返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 是否成功
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """是否成功
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteUnitRuleRequest(AbstractModel):
    """DeleteUnitRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 规则ID
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """规则ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteUnitRuleResponse(AbstractModel):
    """DeleteUnitRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 是否成功
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """是否成功
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeliveryConfigBindGroup(AbstractModel):
    """描述投递配置项绑定的部署组

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置id
        :type ConfigId: str
        :param _ConfigName: 配置名
        :type ConfigName: str
        :param _CollectPath: 采集路径
        :type CollectPath: list of str
        :param _Groups: 关联部署组信息
        :type Groups: list of GroupInfo
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _KafkaVIp: KafkaVIp
注意：此字段可能返回 null，表示取不到有效值。
        :type KafkaVIp: str
        :param _KafkaAddress: KafkaAddress
注意：此字段可能返回 null，表示取不到有效值。
        :type KafkaAddress: str
        :param _KafkaVPort: KafkaVPort
注意：此字段可能返回 null，表示取不到有效值。
        :type KafkaVPort: str
        :param _Topic: Topic
        :type Topic: str
        :param _LineRule: LineRule
注意：此字段可能返回 null，表示取不到有效值。
        :type LineRule: str
        :param _CustomRule: CustomRule
注意：此字段可能返回 null，表示取不到有效值。
        :type CustomRule: str
        :param _EnableGlobalLineRule: EnableGlobalLineRule
注意：此字段可能返回 null，表示取不到有效值。
        :type EnableGlobalLineRule: bool
        :param _EnableAuth: EnableAuth
        :type EnableAuth: bool
        :param _Username: Username
注意：此字段可能返回 null，表示取不到有效值。
        :type Username: str
        :param _Password: Password
注意：此字段可能返回 null，表示取不到有效值。
        :type Password: str
        :param _KafkaInfos: KafkaInfos
注意：此字段可能返回 null，表示取不到有效值。
        :type KafkaInfos: list of DeliveryKafkaInfo
        """
        self._ConfigId = None
        self._ConfigName = None
        self._CollectPath = None
        self._Groups = None
        self._CreateTime = None
        self._KafkaVIp = None
        self._KafkaAddress = None
        self._KafkaVPort = None
        self._Topic = None
        self._LineRule = None
        self._CustomRule = None
        self._EnableGlobalLineRule = None
        self._EnableAuth = None
        self._Username = None
        self._Password = None
        self._KafkaInfos = None

    @property
    def ConfigId(self):
        """配置id
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def ConfigName(self):
        """配置名
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def CollectPath(self):
        """采集路径
        :rtype: list of str
        """
        return self._CollectPath

    @CollectPath.setter
    def CollectPath(self, CollectPath):
        self._CollectPath = CollectPath

    @property
    def Groups(self):
        """关联部署组信息
        :rtype: list of GroupInfo
        """
        return self._Groups

    @Groups.setter
    def Groups(self, Groups):
        self._Groups = Groups

    @property
    def CreateTime(self):
        """创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def KafkaVIp(self):
        """KafkaVIp
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._KafkaVIp

    @KafkaVIp.setter
    def KafkaVIp(self, KafkaVIp):
        self._KafkaVIp = KafkaVIp

    @property
    def KafkaAddress(self):
        """KafkaAddress
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._KafkaAddress

    @KafkaAddress.setter
    def KafkaAddress(self, KafkaAddress):
        self._KafkaAddress = KafkaAddress

    @property
    def KafkaVPort(self):
        """KafkaVPort
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._KafkaVPort

    @KafkaVPort.setter
    def KafkaVPort(self, KafkaVPort):
        self._KafkaVPort = KafkaVPort

    @property
    def Topic(self):
        """Topic
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def LineRule(self):
        """LineRule
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LineRule

    @LineRule.setter
    def LineRule(self, LineRule):
        self._LineRule = LineRule

    @property
    def CustomRule(self):
        """CustomRule
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CustomRule

    @CustomRule.setter
    def CustomRule(self, CustomRule):
        self._CustomRule = CustomRule

    @property
    def EnableGlobalLineRule(self):
        """EnableGlobalLineRule
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._EnableGlobalLineRule

    @EnableGlobalLineRule.setter
    def EnableGlobalLineRule(self, EnableGlobalLineRule):
        self._EnableGlobalLineRule = EnableGlobalLineRule

    @property
    def EnableAuth(self):
        """EnableAuth
        :rtype: bool
        """
        return self._EnableAuth

    @EnableAuth.setter
    def EnableAuth(self, EnableAuth):
        self._EnableAuth = EnableAuth

    @property
    def Username(self):
        """Username
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Username

    @Username.setter
    def Username(self, Username):
        self._Username = Username

    @property
    def Password(self):
        """Password
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def KafkaInfos(self):
        """KafkaInfos
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DeliveryKafkaInfo
        """
        return self._KafkaInfos

    @KafkaInfos.setter
    def KafkaInfos(self, KafkaInfos):
        self._KafkaInfos = KafkaInfos


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        self._ConfigName = params.get("ConfigName")
        self._CollectPath = params.get("CollectPath")
        if params.get("Groups") is not None:
            self._Groups = []
            for item in params.get("Groups"):
                obj = GroupInfo()
                obj._deserialize(item)
                self._Groups.append(obj)
        self._CreateTime = params.get("CreateTime")
        self._KafkaVIp = params.get("KafkaVIp")
        self._KafkaAddress = params.get("KafkaAddress")
        self._KafkaVPort = params.get("KafkaVPort")
        self._Topic = params.get("Topic")
        self._LineRule = params.get("LineRule")
        self._CustomRule = params.get("CustomRule")
        self._EnableGlobalLineRule = params.get("EnableGlobalLineRule")
        self._EnableAuth = params.get("EnableAuth")
        self._Username = params.get("Username")
        self._Password = params.get("Password")
        if params.get("KafkaInfos") is not None:
            self._KafkaInfos = []
            for item in params.get("KafkaInfos"):
                obj = DeliveryKafkaInfo()
                obj._deserialize(item)
                self._KafkaInfos.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeliveryConfigBindGroups(AbstractModel):
    """描述配置项绑定的部署组

    """

    def __init__(self):
        r"""
        :param _TotalCount: 公共条数
        :type TotalCount: int
        :param _Content: 内容
        :type Content: list of DeliveryConfigBindGroup
        """
        self._TotalCount = None
        self._Content = None

    @property
    def TotalCount(self):
        """公共条数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Content(self):
        """内容
        :rtype: list of DeliveryConfigBindGroup
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Content") is not None:
            self._Content = []
            for item in params.get("Content"):
                obj = DeliveryConfigBindGroup()
                obj._deserialize(item)
                self._Content.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeliveryKafkaInfo(AbstractModel):
    """kafka投递的topic和path的信息

    """

    def __init__(self):
        r"""
        :param _Topic: 投递kafka的topic
        :type Topic: str
        :param _Path: 采集日志的path
        :type Path: list of str
        :param _LineRule: default，默认换行符分行
time，按时间分行
custom, 选了custom那么CustomRule就要填入具体的自定义值
        :type LineRule: str
        :param _CustomRule: 自定义的分行值
        :type CustomRule: str
        """
        self._Topic = None
        self._Path = None
        self._LineRule = None
        self._CustomRule = None

    @property
    def Topic(self):
        """投递kafka的topic
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def Path(self):
        """采集日志的path
        :rtype: list of str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def LineRule(self):
        """default，默认换行符分行
time，按时间分行
custom, 选了custom那么CustomRule就要填入具体的自定义值
        :rtype: str
        """
        return self._LineRule

    @LineRule.setter
    def LineRule(self, LineRule):
        self._LineRule = LineRule

    @property
    def CustomRule(self):
        """自定义的分行值
        :rtype: str
        """
        return self._CustomRule

    @CustomRule.setter
    def CustomRule(self, CustomRule):
        self._CustomRule = CustomRule


    def _deserialize(self, params):
        self._Topic = params.get("Topic")
        self._Path = params.get("Path")
        self._LineRule = params.get("LineRule")
        self._CustomRule = params.get("CustomRule")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeployContainerGroupRequest(AbstractModel):
    """DeployContainerGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID，分组唯一标识
        :type GroupId: str
        :param _TagName: 镜像版本名称,如v1
        :type TagName: str
        :param _InstanceNum: 实例数量
        :type InstanceNum: int
        :param _Server: 镜像server
        :type Server: str
        :param _Reponame: 旧版镜像名，如/tsf/nginx
        :type Reponame: str
        :param _CpuLimit: 业务容器最大的 CPU 核数，对应 K8S 的 limit；不填时默认为 request 的 2 倍
        :type CpuLimit: str
        :param _MemLimit: 业务容器最大的内存 MiB 数，对应 K8S 的 limit；不填时默认为 request 的 2 倍
        :type MemLimit: str
        :param _JvmOpts: jvm参数
        :type JvmOpts: str
        :param _CpuRequest: 业务容器分配的 CPU 核数，对应 K8S 的 request，默认0.25
        :type CpuRequest: str
        :param _MemRequest: 业务容器分配的内存 MiB 数，对应 K8S 的 request，默认640 MiB
        :type MemRequest: str
        :param _DoNotStart: 是否不立即启动
        :type DoNotStart: bool
        :param _RepoName: （优先使用）新版镜像名，如/tsf/nginx
        :type RepoName: str
        :param _UpdateType: 更新方式：0:快速更新 1:滚动更新
        :type UpdateType: int
        :param _UpdateIvl: 滚动更新必填，更新间隔
        :type UpdateIvl: int
        :param _AgentCpuRequest: agent 容器分配的 CPU 核数，对应 K8S 的 request
        :type AgentCpuRequest: str
        :param _AgentCpuLimit: agent 容器最大的 CPU 核数，对应 K8S 的 limit
        :type AgentCpuLimit: str
        :param _AgentMemRequest: agent 容器分配的内存 MiB 数，对应 K8S 的 request
        :type AgentMemRequest: str
        :param _AgentMemLimit: agent 容器最大的内存 MiB 数，对应 K8S 的 limit
        :type AgentMemLimit: str
        :param _IstioCpuRequest: istioproxy 容器分配的 CPU 核数，对应 K8S 的 request
        :type IstioCpuRequest: str
        :param _IstioCpuLimit: istioproxy 容器最大的 CPU 核数，对应 K8S 的 limit
        :type IstioCpuLimit: str
        :param _IstioMemRequest: istioproxy 容器分配的内存 MiB 数，对应 K8S 的 request
        :type IstioMemRequest: str
        :param _IstioMemLimit: istioproxy 容器最大的内存 MiB 数，对应 K8S 的 limit
        :type IstioMemLimit: str
        :param _MaxSurge: kubernetes滚动更新策略的MaxSurge参数
        :type MaxSurge: str
        :param _MaxUnavailable: kubernetes滚动更新策略的MaxUnavailable参数
        :type MaxUnavailable: str
        :param _HealthCheckSettings: 健康检查配置信息，若不指定该参数，则默认不设置健康检查。
        :type HealthCheckSettings: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSettings`
        :param _Envs: 部署组应用运行的环境变量。若不指定该参数，则默认不设置额外的环境变量。
        :type Envs: list of Env
        :param _ServiceSetting: 容器部署组的网络设置。
        :type ServiceSetting: :class:`tencentcloud.tsf.v20180326.models.ServiceSetting`
        :param _DeployAgent: 是否部署 agent 容器。若不指定该参数，则默认不部署 agent 容器。
        :type DeployAgent: bool
        :param _SchedulingStrategy: 节点调度策略。若不指定该参数，则默认不使用节点调度策略。
        :type SchedulingStrategy: :class:`tencentcloud.tsf.v20180326.models.SchedulingStrategy`
        :param _IncrementalDeployment: 是否进行增量部署，默认为false，全量更新
        :type IncrementalDeployment: bool
        :param _RepoType: tcr或者不填
        :type RepoType: str
        :param _VolumeInfos: 数据卷信息-废弃，请用VolumeInfoList参数
        :type VolumeInfos: :class:`tencentcloud.tsf.v20180326.models.VolumeInfo`
        :param _VolumeMountInfos: 数据卷挂载点信息-废弃，请用VolumeMountInfoList参数
        :type VolumeMountInfos: :class:`tencentcloud.tsf.v20180326.models.VolumeMountInfo`
        :param _VolumeInfoList: 数据卷信息，list
        :type VolumeInfoList: list of VolumeInfo
        :param _VolumeMountInfoList: 数据卷挂载点信息，list
        :type VolumeMountInfoList: list of VolumeMountInfo
        :param _VolumeClean: 是否清除数据卷信息，默认false
        :type VolumeClean: bool
        :param _AgentProfileList: javaagent信息: SERVICE_AGENT/OT_AGENT
        :type AgentProfileList: list of AgentProfile
        :param _WarmupSetting: 预热配置信息
        :type WarmupSetting: :class:`tencentcloud.tsf.v20180326.models.WarmupSetting`
        """
        self._GroupId = None
        self._TagName = None
        self._InstanceNum = None
        self._Server = None
        self._Reponame = None
        self._CpuLimit = None
        self._MemLimit = None
        self._JvmOpts = None
        self._CpuRequest = None
        self._MemRequest = None
        self._DoNotStart = None
        self._RepoName = None
        self._UpdateType = None
        self._UpdateIvl = None
        self._AgentCpuRequest = None
        self._AgentCpuLimit = None
        self._AgentMemRequest = None
        self._AgentMemLimit = None
        self._IstioCpuRequest = None
        self._IstioCpuLimit = None
        self._IstioMemRequest = None
        self._IstioMemLimit = None
        self._MaxSurge = None
        self._MaxUnavailable = None
        self._HealthCheckSettings = None
        self._Envs = None
        self._ServiceSetting = None
        self._DeployAgent = None
        self._SchedulingStrategy = None
        self._IncrementalDeployment = None
        self._RepoType = None
        self._VolumeInfos = None
        self._VolumeMountInfos = None
        self._VolumeInfoList = None
        self._VolumeMountInfoList = None
        self._VolumeClean = None
        self._AgentProfileList = None
        self._WarmupSetting = None

    @property
    def GroupId(self):
        """部署组ID，分组唯一标识
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def TagName(self):
        """镜像版本名称,如v1
        :rtype: str
        """
        return self._TagName

    @TagName.setter
    def TagName(self, TagName):
        self._TagName = TagName

    @property
    def InstanceNum(self):
        """实例数量
        :rtype: int
        """
        return self._InstanceNum

    @InstanceNum.setter
    def InstanceNum(self, InstanceNum):
        self._InstanceNum = InstanceNum

    @property
    def Server(self):
        """镜像server
        :rtype: str
        """
        return self._Server

    @Server.setter
    def Server(self, Server):
        self._Server = Server

    @property
    def Reponame(self):
        warnings.warn("parameter `Reponame` is deprecated", DeprecationWarning) 

        """旧版镜像名，如/tsf/nginx
        :rtype: str
        """
        return self._Reponame

    @Reponame.setter
    def Reponame(self, Reponame):
        warnings.warn("parameter `Reponame` is deprecated", DeprecationWarning) 

        self._Reponame = Reponame

    @property
    def CpuLimit(self):
        """业务容器最大的 CPU 核数，对应 K8S 的 limit；不填时默认为 request 的 2 倍
        :rtype: str
        """
        return self._CpuLimit

    @CpuLimit.setter
    def CpuLimit(self, CpuLimit):
        self._CpuLimit = CpuLimit

    @property
    def MemLimit(self):
        """业务容器最大的内存 MiB 数，对应 K8S 的 limit；不填时默认为 request 的 2 倍
        :rtype: str
        """
        return self._MemLimit

    @MemLimit.setter
    def MemLimit(self, MemLimit):
        self._MemLimit = MemLimit

    @property
    def JvmOpts(self):
        """jvm参数
        :rtype: str
        """
        return self._JvmOpts

    @JvmOpts.setter
    def JvmOpts(self, JvmOpts):
        self._JvmOpts = JvmOpts

    @property
    def CpuRequest(self):
        """业务容器分配的 CPU 核数，对应 K8S 的 request，默认0.25
        :rtype: str
        """
        return self._CpuRequest

    @CpuRequest.setter
    def CpuRequest(self, CpuRequest):
        self._CpuRequest = CpuRequest

    @property
    def MemRequest(self):
        """业务容器分配的内存 MiB 数，对应 K8S 的 request，默认640 MiB
        :rtype: str
        """
        return self._MemRequest

    @MemRequest.setter
    def MemRequest(self, MemRequest):
        self._MemRequest = MemRequest

    @property
    def DoNotStart(self):
        """是否不立即启动
        :rtype: bool
        """
        return self._DoNotStart

    @DoNotStart.setter
    def DoNotStart(self, DoNotStart):
        self._DoNotStart = DoNotStart

    @property
    def RepoName(self):
        """（优先使用）新版镜像名，如/tsf/nginx
        :rtype: str
        """
        return self._RepoName

    @RepoName.setter
    def RepoName(self, RepoName):
        self._RepoName = RepoName

    @property
    def UpdateType(self):
        """更新方式：0:快速更新 1:滚动更新
        :rtype: int
        """
        return self._UpdateType

    @UpdateType.setter
    def UpdateType(self, UpdateType):
        self._UpdateType = UpdateType

    @property
    def UpdateIvl(self):
        """滚动更新必填，更新间隔
        :rtype: int
        """
        return self._UpdateIvl

    @UpdateIvl.setter
    def UpdateIvl(self, UpdateIvl):
        self._UpdateIvl = UpdateIvl

    @property
    def AgentCpuRequest(self):
        """agent 容器分配的 CPU 核数，对应 K8S 的 request
        :rtype: str
        """
        return self._AgentCpuRequest

    @AgentCpuRequest.setter
    def AgentCpuRequest(self, AgentCpuRequest):
        self._AgentCpuRequest = AgentCpuRequest

    @property
    def AgentCpuLimit(self):
        """agent 容器最大的 CPU 核数，对应 K8S 的 limit
        :rtype: str
        """
        return self._AgentCpuLimit

    @AgentCpuLimit.setter
    def AgentCpuLimit(self, AgentCpuLimit):
        self._AgentCpuLimit = AgentCpuLimit

    @property
    def AgentMemRequest(self):
        """agent 容器分配的内存 MiB 数，对应 K8S 的 request
        :rtype: str
        """
        return self._AgentMemRequest

    @AgentMemRequest.setter
    def AgentMemRequest(self, AgentMemRequest):
        self._AgentMemRequest = AgentMemRequest

    @property
    def AgentMemLimit(self):
        """agent 容器最大的内存 MiB 数，对应 K8S 的 limit
        :rtype: str
        """
        return self._AgentMemLimit

    @AgentMemLimit.setter
    def AgentMemLimit(self, AgentMemLimit):
        self._AgentMemLimit = AgentMemLimit

    @property
    def IstioCpuRequest(self):
        """istioproxy 容器分配的 CPU 核数，对应 K8S 的 request
        :rtype: str
        """
        return self._IstioCpuRequest

    @IstioCpuRequest.setter
    def IstioCpuRequest(self, IstioCpuRequest):
        self._IstioCpuRequest = IstioCpuRequest

    @property
    def IstioCpuLimit(self):
        """istioproxy 容器最大的 CPU 核数，对应 K8S 的 limit
        :rtype: str
        """
        return self._IstioCpuLimit

    @IstioCpuLimit.setter
    def IstioCpuLimit(self, IstioCpuLimit):
        self._IstioCpuLimit = IstioCpuLimit

    @property
    def IstioMemRequest(self):
        """istioproxy 容器分配的内存 MiB 数，对应 K8S 的 request
        :rtype: str
        """
        return self._IstioMemRequest

    @IstioMemRequest.setter
    def IstioMemRequest(self, IstioMemRequest):
        self._IstioMemRequest = IstioMemRequest

    @property
    def IstioMemLimit(self):
        """istioproxy 容器最大的内存 MiB 数，对应 K8S 的 limit
        :rtype: str
        """
        return self._IstioMemLimit

    @IstioMemLimit.setter
    def IstioMemLimit(self, IstioMemLimit):
        self._IstioMemLimit = IstioMemLimit

    @property
    def MaxSurge(self):
        """kubernetes滚动更新策略的MaxSurge参数
        :rtype: str
        """
        return self._MaxSurge

    @MaxSurge.setter
    def MaxSurge(self, MaxSurge):
        self._MaxSurge = MaxSurge

    @property
    def MaxUnavailable(self):
        """kubernetes滚动更新策略的MaxUnavailable参数
        :rtype: str
        """
        return self._MaxUnavailable

    @MaxUnavailable.setter
    def MaxUnavailable(self, MaxUnavailable):
        self._MaxUnavailable = MaxUnavailable

    @property
    def HealthCheckSettings(self):
        """健康检查配置信息，若不指定该参数，则默认不设置健康检查。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSettings`
        """
        return self._HealthCheckSettings

    @HealthCheckSettings.setter
    def HealthCheckSettings(self, HealthCheckSettings):
        self._HealthCheckSettings = HealthCheckSettings

    @property
    def Envs(self):
        """部署组应用运行的环境变量。若不指定该参数，则默认不设置额外的环境变量。
        :rtype: list of Env
        """
        return self._Envs

    @Envs.setter
    def Envs(self, Envs):
        self._Envs = Envs

    @property
    def ServiceSetting(self):
        """容器部署组的网络设置。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ServiceSetting`
        """
        return self._ServiceSetting

    @ServiceSetting.setter
    def ServiceSetting(self, ServiceSetting):
        self._ServiceSetting = ServiceSetting

    @property
    def DeployAgent(self):
        """是否部署 agent 容器。若不指定该参数，则默认不部署 agent 容器。
        :rtype: bool
        """
        return self._DeployAgent

    @DeployAgent.setter
    def DeployAgent(self, DeployAgent):
        self._DeployAgent = DeployAgent

    @property
    def SchedulingStrategy(self):
        """节点调度策略。若不指定该参数，则默认不使用节点调度策略。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.SchedulingStrategy`
        """
        return self._SchedulingStrategy

    @SchedulingStrategy.setter
    def SchedulingStrategy(self, SchedulingStrategy):
        self._SchedulingStrategy = SchedulingStrategy

    @property
    def IncrementalDeployment(self):
        """是否进行增量部署，默认为false，全量更新
        :rtype: bool
        """
        return self._IncrementalDeployment

    @IncrementalDeployment.setter
    def IncrementalDeployment(self, IncrementalDeployment):
        self._IncrementalDeployment = IncrementalDeployment

    @property
    def RepoType(self):
        """tcr或者不填
        :rtype: str
        """
        return self._RepoType

    @RepoType.setter
    def RepoType(self, RepoType):
        self._RepoType = RepoType

    @property
    def VolumeInfos(self):
        """数据卷信息-废弃，请用VolumeInfoList参数
        :rtype: :class:`tencentcloud.tsf.v20180326.models.VolumeInfo`
        """
        return self._VolumeInfos

    @VolumeInfos.setter
    def VolumeInfos(self, VolumeInfos):
        self._VolumeInfos = VolumeInfos

    @property
    def VolumeMountInfos(self):
        """数据卷挂载点信息-废弃，请用VolumeMountInfoList参数
        :rtype: :class:`tencentcloud.tsf.v20180326.models.VolumeMountInfo`
        """
        return self._VolumeMountInfos

    @VolumeMountInfos.setter
    def VolumeMountInfos(self, VolumeMountInfos):
        self._VolumeMountInfos = VolumeMountInfos

    @property
    def VolumeInfoList(self):
        """数据卷信息，list
        :rtype: list of VolumeInfo
        """
        return self._VolumeInfoList

    @VolumeInfoList.setter
    def VolumeInfoList(self, VolumeInfoList):
        self._VolumeInfoList = VolumeInfoList

    @property
    def VolumeMountInfoList(self):
        """数据卷挂载点信息，list
        :rtype: list of VolumeMountInfo
        """
        return self._VolumeMountInfoList

    @VolumeMountInfoList.setter
    def VolumeMountInfoList(self, VolumeMountInfoList):
        self._VolumeMountInfoList = VolumeMountInfoList

    @property
    def VolumeClean(self):
        """是否清除数据卷信息，默认false
        :rtype: bool
        """
        return self._VolumeClean

    @VolumeClean.setter
    def VolumeClean(self, VolumeClean):
        self._VolumeClean = VolumeClean

    @property
    def AgentProfileList(self):
        """javaagent信息: SERVICE_AGENT/OT_AGENT
        :rtype: list of AgentProfile
        """
        return self._AgentProfileList

    @AgentProfileList.setter
    def AgentProfileList(self, AgentProfileList):
        self._AgentProfileList = AgentProfileList

    @property
    def WarmupSetting(self):
        """预热配置信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.WarmupSetting`
        """
        return self._WarmupSetting

    @WarmupSetting.setter
    def WarmupSetting(self, WarmupSetting):
        self._WarmupSetting = WarmupSetting


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._TagName = params.get("TagName")
        self._InstanceNum = params.get("InstanceNum")
        self._Server = params.get("Server")
        self._Reponame = params.get("Reponame")
        self._CpuLimit = params.get("CpuLimit")
        self._MemLimit = params.get("MemLimit")
        self._JvmOpts = params.get("JvmOpts")
        self._CpuRequest = params.get("CpuRequest")
        self._MemRequest = params.get("MemRequest")
        self._DoNotStart = params.get("DoNotStart")
        self._RepoName = params.get("RepoName")
        self._UpdateType = params.get("UpdateType")
        self._UpdateIvl = params.get("UpdateIvl")
        self._AgentCpuRequest = params.get("AgentCpuRequest")
        self._AgentCpuLimit = params.get("AgentCpuLimit")
        self._AgentMemRequest = params.get("AgentMemRequest")
        self._AgentMemLimit = params.get("AgentMemLimit")
        self._IstioCpuRequest = params.get("IstioCpuRequest")
        self._IstioCpuLimit = params.get("IstioCpuLimit")
        self._IstioMemRequest = params.get("IstioMemRequest")
        self._IstioMemLimit = params.get("IstioMemLimit")
        self._MaxSurge = params.get("MaxSurge")
        self._MaxUnavailable = params.get("MaxUnavailable")
        if params.get("HealthCheckSettings") is not None:
            self._HealthCheckSettings = HealthCheckSettings()
            self._HealthCheckSettings._deserialize(params.get("HealthCheckSettings"))
        if params.get("Envs") is not None:
            self._Envs = []
            for item in params.get("Envs"):
                obj = Env()
                obj._deserialize(item)
                self._Envs.append(obj)
        if params.get("ServiceSetting") is not None:
            self._ServiceSetting = ServiceSetting()
            self._ServiceSetting._deserialize(params.get("ServiceSetting"))
        self._DeployAgent = params.get("DeployAgent")
        if params.get("SchedulingStrategy") is not None:
            self._SchedulingStrategy = SchedulingStrategy()
            self._SchedulingStrategy._deserialize(params.get("SchedulingStrategy"))
        self._IncrementalDeployment = params.get("IncrementalDeployment")
        self._RepoType = params.get("RepoType")
        if params.get("VolumeInfos") is not None:
            self._VolumeInfos = VolumeInfo()
            self._VolumeInfos._deserialize(params.get("VolumeInfos"))
        if params.get("VolumeMountInfos") is not None:
            self._VolumeMountInfos = VolumeMountInfo()
            self._VolumeMountInfos._deserialize(params.get("VolumeMountInfos"))
        if params.get("VolumeInfoList") is not None:
            self._VolumeInfoList = []
            for item in params.get("VolumeInfoList"):
                obj = VolumeInfo()
                obj._deserialize(item)
                self._VolumeInfoList.append(obj)
        if params.get("VolumeMountInfoList") is not None:
            self._VolumeMountInfoList = []
            for item in params.get("VolumeMountInfoList"):
                obj = VolumeMountInfo()
                obj._deserialize(item)
                self._VolumeMountInfoList.append(obj)
        self._VolumeClean = params.get("VolumeClean")
        if params.get("AgentProfileList") is not None:
            self._AgentProfileList = []
            for item in params.get("AgentProfileList"):
                obj = AgentProfile()
                obj._deserialize(item)
                self._AgentProfileList.append(obj)
        if params.get("WarmupSetting") is not None:
            self._WarmupSetting = WarmupSetting()
            self._WarmupSetting._deserialize(params.get("WarmupSetting"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeployContainerGroupResponse(AbstractModel):
    """DeployContainerGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 部署容器应用是否成功。
true：成功。
false：失败。
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """部署容器应用是否成功。
true：成功。
false：失败。
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeployGroupRequest(AbstractModel):
    """DeployGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID
        :type GroupId: str
        :param _PkgId: 程序包ID
        :type PkgId: str
        :param _StartupParameters: 部署组启动参数
        :type StartupParameters: str
        :param _DeployDesc: 部署应用描述信息
        :type DeployDesc: str
        :param _ForceStart: 是否允许强制启动
        :type ForceStart: bool
        :param _EnableHealthCheck: 是否开启健康检查
        :type EnableHealthCheck: bool
        :param _HealthCheckSettings: 开启健康检查时，配置健康检查
        :type HealthCheckSettings: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSettings`
        :param _UpdateType: 部署方式，0表示快速更新，1表示滚动更新
        :type UpdateType: int
        :param _DeployBetaEnable: 是否启用beta批次
        :type DeployBetaEnable: bool
        :param _DeployBatch: 滚动发布每个批次参与的实例比率
        :type DeployBatch: list of float
        :param _DeployExeMode: 滚动发布的执行方式，auto表示自动， manual表示手动
        :type DeployExeMode: str
        :param _DeployWaitTime: 滚动发布每个批次的时间间隔
        :type DeployWaitTime: int
        :param _StartScript: 启动脚本 base64编码
        :type StartScript: str
        :param _StopScript: 停止脚本 base64编码
        :type StopScript: str
        :param _IncrementalDeployment: 是否进行增量部署，默认为false，全量更新
        :type IncrementalDeployment: bool
        :param _JdkName: JDK名称: konaJDK或openJDK
        :type JdkName: str
        :param _JdkVersion: konaJDK版本：8、11和17
openJDK版本：8、17
        :type JdkVersion: str
        :param _AgentProfileList: 部署agent的类型、版本
        :type AgentProfileList: list of AgentProfile
        :param _WarmupSetting: 预热参数配置
        :type WarmupSetting: :class:`tencentcloud.tsf.v20180326.models.WarmupSetting`
        :param _EnableBatchHealthCheck: 开启分批健康检查
        :type EnableBatchHealthCheck: bool
        """
        self._GroupId = None
        self._PkgId = None
        self._StartupParameters = None
        self._DeployDesc = None
        self._ForceStart = None
        self._EnableHealthCheck = None
        self._HealthCheckSettings = None
        self._UpdateType = None
        self._DeployBetaEnable = None
        self._DeployBatch = None
        self._DeployExeMode = None
        self._DeployWaitTime = None
        self._StartScript = None
        self._StopScript = None
        self._IncrementalDeployment = None
        self._JdkName = None
        self._JdkVersion = None
        self._AgentProfileList = None
        self._WarmupSetting = None
        self._EnableBatchHealthCheck = None

    @property
    def GroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def PkgId(self):
        """程序包ID
        :rtype: str
        """
        return self._PkgId

    @PkgId.setter
    def PkgId(self, PkgId):
        self._PkgId = PkgId

    @property
    def StartupParameters(self):
        """部署组启动参数
        :rtype: str
        """
        return self._StartupParameters

    @StartupParameters.setter
    def StartupParameters(self, StartupParameters):
        self._StartupParameters = StartupParameters

    @property
    def DeployDesc(self):
        """部署应用描述信息
        :rtype: str
        """
        return self._DeployDesc

    @DeployDesc.setter
    def DeployDesc(self, DeployDesc):
        self._DeployDesc = DeployDesc

    @property
    def ForceStart(self):
        """是否允许强制启动
        :rtype: bool
        """
        return self._ForceStart

    @ForceStart.setter
    def ForceStart(self, ForceStart):
        self._ForceStart = ForceStart

    @property
    def EnableHealthCheck(self):
        """是否开启健康检查
        :rtype: bool
        """
        return self._EnableHealthCheck

    @EnableHealthCheck.setter
    def EnableHealthCheck(self, EnableHealthCheck):
        self._EnableHealthCheck = EnableHealthCheck

    @property
    def HealthCheckSettings(self):
        """开启健康检查时，配置健康检查
        :rtype: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSettings`
        """
        return self._HealthCheckSettings

    @HealthCheckSettings.setter
    def HealthCheckSettings(self, HealthCheckSettings):
        self._HealthCheckSettings = HealthCheckSettings

    @property
    def UpdateType(self):
        """部署方式，0表示快速更新，1表示滚动更新
        :rtype: int
        """
        return self._UpdateType

    @UpdateType.setter
    def UpdateType(self, UpdateType):
        self._UpdateType = UpdateType

    @property
    def DeployBetaEnable(self):
        """是否启用beta批次
        :rtype: bool
        """
        return self._DeployBetaEnable

    @DeployBetaEnable.setter
    def DeployBetaEnable(self, DeployBetaEnable):
        self._DeployBetaEnable = DeployBetaEnable

    @property
    def DeployBatch(self):
        """滚动发布每个批次参与的实例比率
        :rtype: list of float
        """
        return self._DeployBatch

    @DeployBatch.setter
    def DeployBatch(self, DeployBatch):
        self._DeployBatch = DeployBatch

    @property
    def DeployExeMode(self):
        """滚动发布的执行方式，auto表示自动， manual表示手动
        :rtype: str
        """
        return self._DeployExeMode

    @DeployExeMode.setter
    def DeployExeMode(self, DeployExeMode):
        self._DeployExeMode = DeployExeMode

    @property
    def DeployWaitTime(self):
        """滚动发布每个批次的时间间隔
        :rtype: int
        """
        return self._DeployWaitTime

    @DeployWaitTime.setter
    def DeployWaitTime(self, DeployWaitTime):
        self._DeployWaitTime = DeployWaitTime

    @property
    def StartScript(self):
        """启动脚本 base64编码
        :rtype: str
        """
        return self._StartScript

    @StartScript.setter
    def StartScript(self, StartScript):
        self._StartScript = StartScript

    @property
    def StopScript(self):
        """停止脚本 base64编码
        :rtype: str
        """
        return self._StopScript

    @StopScript.setter
    def StopScript(self, StopScript):
        self._StopScript = StopScript

    @property
    def IncrementalDeployment(self):
        """是否进行增量部署，默认为false，全量更新
        :rtype: bool
        """
        return self._IncrementalDeployment

    @IncrementalDeployment.setter
    def IncrementalDeployment(self, IncrementalDeployment):
        self._IncrementalDeployment = IncrementalDeployment

    @property
    def JdkName(self):
        """JDK名称: konaJDK或openJDK
        :rtype: str
        """
        return self._JdkName

    @JdkName.setter
    def JdkName(self, JdkName):
        self._JdkName = JdkName

    @property
    def JdkVersion(self):
        """konaJDK版本：8、11和17
openJDK版本：8、17
        :rtype: str
        """
        return self._JdkVersion

    @JdkVersion.setter
    def JdkVersion(self, JdkVersion):
        self._JdkVersion = JdkVersion

    @property
    def AgentProfileList(self):
        """部署agent的类型、版本
        :rtype: list of AgentProfile
        """
        return self._AgentProfileList

    @AgentProfileList.setter
    def AgentProfileList(self, AgentProfileList):
        self._AgentProfileList = AgentProfileList

    @property
    def WarmupSetting(self):
        """预热参数配置
        :rtype: :class:`tencentcloud.tsf.v20180326.models.WarmupSetting`
        """
        return self._WarmupSetting

    @WarmupSetting.setter
    def WarmupSetting(self, WarmupSetting):
        self._WarmupSetting = WarmupSetting

    @property
    def EnableBatchHealthCheck(self):
        """开启分批健康检查
        :rtype: bool
        """
        return self._EnableBatchHealthCheck

    @EnableBatchHealthCheck.setter
    def EnableBatchHealthCheck(self, EnableBatchHealthCheck):
        self._EnableBatchHealthCheck = EnableBatchHealthCheck


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._PkgId = params.get("PkgId")
        self._StartupParameters = params.get("StartupParameters")
        self._DeployDesc = params.get("DeployDesc")
        self._ForceStart = params.get("ForceStart")
        self._EnableHealthCheck = params.get("EnableHealthCheck")
        if params.get("HealthCheckSettings") is not None:
            self._HealthCheckSettings = HealthCheckSettings()
            self._HealthCheckSettings._deserialize(params.get("HealthCheckSettings"))
        self._UpdateType = params.get("UpdateType")
        self._DeployBetaEnable = params.get("DeployBetaEnable")
        self._DeployBatch = params.get("DeployBatch")
        self._DeployExeMode = params.get("DeployExeMode")
        self._DeployWaitTime = params.get("DeployWaitTime")
        self._StartScript = params.get("StartScript")
        self._StopScript = params.get("StopScript")
        self._IncrementalDeployment = params.get("IncrementalDeployment")
        self._JdkName = params.get("JdkName")
        self._JdkVersion = params.get("JdkVersion")
        if params.get("AgentProfileList") is not None:
            self._AgentProfileList = []
            for item in params.get("AgentProfileList"):
                obj = AgentProfile()
                obj._deserialize(item)
                self._AgentProfileList.append(obj)
        if params.get("WarmupSetting") is not None:
            self._WarmupSetting = WarmupSetting()
            self._WarmupSetting._deserialize(params.get("WarmupSetting"))
        self._EnableBatchHealthCheck = params.get("EnableBatchHealthCheck")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeployGroupResponse(AbstractModel):
    """DeployGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 任务ID
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TaskId`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """任务ID
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TaskId`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TaskId()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeApiDetailRequest(AbstractModel):
    """DescribeApiDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MicroserviceId: 微服务id
        :type MicroserviceId: str
        :param _Path: 请求路径
        :type Path: str
        :param _Method: 请求方法
        :type Method: str
        :param _PkgVersion: 包版本
        :type PkgVersion: str
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        """
        self._MicroserviceId = None
        self._Path = None
        self._Method = None
        self._PkgVersion = None
        self._ApplicationId = None

    @property
    def MicroserviceId(self):
        """微服务id
        :rtype: str
        """
        return self._MicroserviceId

    @MicroserviceId.setter
    def MicroserviceId(self, MicroserviceId):
        self._MicroserviceId = MicroserviceId

    @property
    def Path(self):
        """请求路径
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Method(self):
        """请求方法
        :rtype: str
        """
        return self._Method

    @Method.setter
    def Method(self, Method):
        self._Method = Method

    @property
    def PkgVersion(self):
        """包版本
        :rtype: str
        """
        return self._PkgVersion

    @PkgVersion.setter
    def PkgVersion(self, PkgVersion):
        self._PkgVersion = PkgVersion

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId


    def _deserialize(self, params):
        self._MicroserviceId = params.get("MicroserviceId")
        self._Path = params.get("Path")
        self._Method = params.get("Method")
        self._PkgVersion = params.get("PkgVersion")
        self._ApplicationId = params.get("ApplicationId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApiDetailResponse(AbstractModel):
    """DescribeApiDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: API 详情
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ApiDetailResponse`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """API 详情
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ApiDetailResponse`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ApiDetailResponse()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeApiGroupRequest(AbstractModel):
    """DescribeApiGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: API 分组ID
        :type GroupId: str
        """
        self._GroupId = None

    @property
    def GroupId(self):
        """API 分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApiGroupResponse(AbstractModel):
    """DescribeApiGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: API分组信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ApiGroupInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """API分组信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ApiGroupInfo`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ApiGroupInfo()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeApiGroupsRequest(AbstractModel):
    """DescribeApiGroups请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchWord: 搜索关键字
        :type SearchWord: str
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Limit: 每页条数，默认为20
        :type Limit: int
        :param _GroupType: 分组类型。 ms： 微服务分组； external:外部Api分组
        :type GroupType: str
        :param _AuthType: 鉴权类型。 secret： 密钥鉴权； none:无鉴权
        :type AuthType: str
        :param _Status: 发布状态, drafted: 未发布。 released: 发布
        :type Status: str
        :param _OrderBy: 排序字段："created_time"或"group_context"
        :type OrderBy: str
        :param _OrderType: 排序类型：0(ASC)或1(DESC)
        :type OrderType: int
        :param _GatewayInstanceId: 网关实体ID
        :type GatewayInstanceId: str
        """
        self._SearchWord = None
        self._Offset = None
        self._Limit = None
        self._GroupType = None
        self._AuthType = None
        self._Status = None
        self._OrderBy = None
        self._OrderType = None
        self._GatewayInstanceId = None

    @property
    def SearchWord(self):
        """搜索关键字
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def Offset(self):
        """偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """每页条数，默认为20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def GroupType(self):
        """分组类型。 ms： 微服务分组； external:外部Api分组
        :rtype: str
        """
        return self._GroupType

    @GroupType.setter
    def GroupType(self, GroupType):
        self._GroupType = GroupType

    @property
    def AuthType(self):
        """鉴权类型。 secret： 密钥鉴权； none:无鉴权
        :rtype: str
        """
        return self._AuthType

    @AuthType.setter
    def AuthType(self, AuthType):
        self._AuthType = AuthType

    @property
    def Status(self):
        """发布状态, drafted: 未发布。 released: 发布
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def OrderBy(self):
        """排序字段："created_time"或"group_context"
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        """排序类型：0(ASC)或1(DESC)
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def GatewayInstanceId(self):
        """网关实体ID
        :rtype: str
        """
        return self._GatewayInstanceId

    @GatewayInstanceId.setter
    def GatewayInstanceId(self, GatewayInstanceId):
        self._GatewayInstanceId = GatewayInstanceId


    def _deserialize(self, params):
        self._SearchWord = params.get("SearchWord")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._GroupType = params.get("GroupType")
        self._AuthType = params.get("AuthType")
        self._Status = params.get("Status")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        self._GatewayInstanceId = params.get("GatewayInstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApiGroupsResponse(AbstractModel):
    """DescribeApiGroups返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 翻页结构体
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageApiGroupInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """翻页结构体
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageApiGroupInfo`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageApiGroupInfo()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeApiRateLimitRulesRequest(AbstractModel):
    """DescribeApiRateLimitRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApiId: Api ID
        :type ApiId: str
        """
        self._ApiId = None

    @property
    def ApiId(self):
        """Api ID
        :rtype: str
        """
        return self._ApiId

    @ApiId.setter
    def ApiId(self, ApiId):
        self._ApiId = ApiId


    def _deserialize(self, params):
        self._ApiId = params.get("ApiId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApiRateLimitRulesResponse(AbstractModel):
    """DescribeApiRateLimitRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 限流结果
        :type Result: list of ApiRateLimitRule
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """限流结果
        :rtype: list of ApiRateLimitRule
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = []
            for item in params.get("Result"):
                obj = ApiRateLimitRule()
                obj._deserialize(item)
                self._Result.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeApiUseDetailRequest(AbstractModel):
    """DescribeApiUseDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayDeployGroupId: 网关部署组ID
        :type GatewayDeployGroupId: str
        :param _ApiId: 网关分组Api ID
        :type ApiId: str
        :param _StartTime: 查询的日期,格式：yyyy-MM-dd HH:mm:ss
        :type StartTime: str
        :param _EndTime: 查询的日期,格式：yyyy-MM-dd HH:mm:ss
        :type EndTime: str
        """
        self._GatewayDeployGroupId = None
        self._ApiId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def GatewayDeployGroupId(self):
        """网关部署组ID
        :rtype: str
        """
        return self._GatewayDeployGroupId

    @GatewayDeployGroupId.setter
    def GatewayDeployGroupId(self, GatewayDeployGroupId):
        self._GatewayDeployGroupId = GatewayDeployGroupId

    @property
    def ApiId(self):
        """网关分组Api ID
        :rtype: str
        """
        return self._ApiId

    @ApiId.setter
    def ApiId(self, ApiId):
        self._ApiId = ApiId

    @property
    def StartTime(self):
        """查询的日期,格式：yyyy-MM-dd HH:mm:ss
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """查询的日期,格式：yyyy-MM-dd HH:mm:ss
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._GatewayDeployGroupId = params.get("GatewayDeployGroupId")
        self._ApiId = params.get("ApiId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApiUseDetailResponse(AbstractModel):
    """DescribeApiUseDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 日使用统计对象
        :type Result: :class:`tencentcloud.tsf.v20180326.models.GroupApiUseStatistics`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """日使用统计对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.GroupApiUseStatistics`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = GroupApiUseStatistics()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeApiVersionsRequest(AbstractModel):
    """DescribeApiVersions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MicroserviceId: 微服务ID
        :type MicroserviceId: str
        :param _Path: API 请求路径
        :type Path: str
        :param _Method: 请求方法
        :type Method: str
        """
        self._MicroserviceId = None
        self._Path = None
        self._Method = None

    @property
    def MicroserviceId(self):
        """微服务ID
        :rtype: str
        """
        return self._MicroserviceId

    @MicroserviceId.setter
    def MicroserviceId(self, MicroserviceId):
        self._MicroserviceId = MicroserviceId

    @property
    def Path(self):
        """API 请求路径
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Method(self):
        """请求方法
        :rtype: str
        """
        return self._Method

    @Method.setter
    def Method(self, Method):
        self._Method = Method


    def _deserialize(self, params):
        self._MicroserviceId = params.get("MicroserviceId")
        self._Path = params.get("Path")
        self._Method = params.get("Method")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApiVersionsResponse(AbstractModel):
    """DescribeApiVersions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: API版本列表
        :type Result: list of ApiVersionArray
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """API版本列表
        :rtype: list of ApiVersionArray
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = []
            for item in params.get("Result"):
                obj = ApiVersionArray()
                obj._deserialize(item)
                self._Result.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeApplicationAttributeRequest(AbstractModel):
    """DescribeApplicationAttribute请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        """
        self._ApplicationId = None

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationAttributeResponse(AbstractModel):
    """DescribeApplicationAttribute返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 应用列表其它字段返回参数
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ApplicationAttribute`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """应用列表其它字段返回参数
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ApplicationAttribute`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ApplicationAttribute()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeApplicationRequest(AbstractModel):
    """DescribeApplication请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        """
        self._ApplicationId = None

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationResponse(AbstractModel):
    """DescribeApplication返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 应用信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ApplicationForPage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """应用信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ApplicationForPage`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ApplicationForPage()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeApplicationsRequest(AbstractModel):
    """DescribeApplications请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchWord: 搜索字段
        :type SearchWord: str
        :param _OrderBy: 排序字段
        :type OrderBy: str
        :param _OrderType: 排序类型
        :type OrderType: int
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 分页个数
        :type Limit: int
        :param _ApplicationType: 应用类型
        :type ApplicationType: str
        :param _MicroserviceType: 应用的微服务类型
        :type MicroserviceType: str
        :param _ApplicationResourceTypeList: 应用资源类型数组
        :type ApplicationResourceTypeList: list of str
        :param _ApplicationIdList: IdList
        :type ApplicationIdList: list of str
        :param _MicroserviceTypeList: 查询多种微服务类型的应用
        :type MicroserviceTypeList: list of str
        """
        self._SearchWord = None
        self._OrderBy = None
        self._OrderType = None
        self._Offset = None
        self._Limit = None
        self._ApplicationType = None
        self._MicroserviceType = None
        self._ApplicationResourceTypeList = None
        self._ApplicationIdList = None
        self._MicroserviceTypeList = None

    @property
    def SearchWord(self):
        """搜索字段
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def OrderBy(self):
        """排序字段
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        """排序类型
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页个数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ApplicationType(self):
        """应用类型
        :rtype: str
        """
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType

    @property
    def MicroserviceType(self):
        """应用的微服务类型
        :rtype: str
        """
        return self._MicroserviceType

    @MicroserviceType.setter
    def MicroserviceType(self, MicroserviceType):
        self._MicroserviceType = MicroserviceType

    @property
    def ApplicationResourceTypeList(self):
        """应用资源类型数组
        :rtype: list of str
        """
        return self._ApplicationResourceTypeList

    @ApplicationResourceTypeList.setter
    def ApplicationResourceTypeList(self, ApplicationResourceTypeList):
        self._ApplicationResourceTypeList = ApplicationResourceTypeList

    @property
    def ApplicationIdList(self):
        """IdList
        :rtype: list of str
        """
        return self._ApplicationIdList

    @ApplicationIdList.setter
    def ApplicationIdList(self, ApplicationIdList):
        self._ApplicationIdList = ApplicationIdList

    @property
    def MicroserviceTypeList(self):
        """查询多种微服务类型的应用
        :rtype: list of str
        """
        return self._MicroserviceTypeList

    @MicroserviceTypeList.setter
    def MicroserviceTypeList(self, MicroserviceTypeList):
        self._MicroserviceTypeList = MicroserviceTypeList


    def _deserialize(self, params):
        self._SearchWord = params.get("SearchWord")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ApplicationType = params.get("ApplicationType")
        self._MicroserviceType = params.get("MicroserviceType")
        self._ApplicationResourceTypeList = params.get("ApplicationResourceTypeList")
        self._ApplicationIdList = params.get("ApplicationIdList")
        self._MicroserviceTypeList = params.get("MicroserviceTypeList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationsResponse(AbstractModel):
    """DescribeApplications返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 应用分页列表信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageApplication`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """应用分页列表信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageApplication`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageApplication()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeBasicResourceUsageRequest(AbstractModel):
    """DescribeBasicResourceUsage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _All: 是否拥有权限查询全租户的，默认 true。注：无论 true 还是 false，PackageSpaceUsed 和 ConsulInstanceCount  都是全租户的
        :type All: bool
        """
        self._All = None

    @property
    def All(self):
        """是否拥有权限查询全租户的，默认 true。注：无论 true 还是 false，PackageSpaceUsed 和 ConsulInstanceCount  都是全租户的
        :rtype: bool
        """
        return self._All

    @All.setter
    def All(self, All):
        self._All = All


    def _deserialize(self, params):
        self._All = params.get("All")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBasicResourceUsageResponse(AbstractModel):
    """DescribeBasicResourceUsage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: TSF基本资源信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.OverviewBasicResourceUsage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """TSF基本资源信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.OverviewBasicResourceUsage`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = OverviewBasicResourceUsage()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeBusinessLogConfigRequest(AbstractModel):
    """DescribeBusinessLogConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置项ID
        :type ConfigId: str
        """
        self._ConfigId = None

    @property
    def ConfigId(self):
        """配置项ID
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBusinessLogConfigResponse(AbstractModel):
    """DescribeBusinessLogConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 日志配置项
        :type Result: :class:`tencentcloud.tsf.v20180326.models.BusinessLogConfig`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """日志配置项
        :rtype: :class:`tencentcloud.tsf.v20180326.models.BusinessLogConfig`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = BusinessLogConfig()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeBusinessLogConfigsRequest(AbstractModel):
    """DescribeBusinessLogConfigs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量，取值范围大于等于0，默认值为0
        :type Offset: int
        :param _Limit: 单页请求配置数量，取值范围[1, 50]，默认值为10
        :type Limit: int
        :param _SearchWord: 模糊匹配关键词
        :type SearchWord: str
        :param _DisableProgramAuthCheck: 无
        :type DisableProgramAuthCheck: bool
        :param _ConfigIdList: 无
        :type ConfigIdList: list of str
        """
        self._Offset = None
        self._Limit = None
        self._SearchWord = None
        self._DisableProgramAuthCheck = None
        self._ConfigIdList = None

    @property
    def Offset(self):
        """偏移量，取值范围大于等于0，默认值为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """单页请求配置数量，取值范围[1, 50]，默认值为10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchWord(self):
        """模糊匹配关键词
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def DisableProgramAuthCheck(self):
        """无
        :rtype: bool
        """
        return self._DisableProgramAuthCheck

    @DisableProgramAuthCheck.setter
    def DisableProgramAuthCheck(self, DisableProgramAuthCheck):
        self._DisableProgramAuthCheck = DisableProgramAuthCheck

    @property
    def ConfigIdList(self):
        """无
        :rtype: list of str
        """
        return self._ConfigIdList

    @ConfigIdList.setter
    def ConfigIdList(self, ConfigIdList):
        self._ConfigIdList = ConfigIdList


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchWord = params.get("SearchWord")
        self._DisableProgramAuthCheck = params.get("DisableProgramAuthCheck")
        self._ConfigIdList = params.get("ConfigIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBusinessLogConfigsResponse(AbstractModel):
    """DescribeBusinessLogConfigs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 业务日志配置列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageBusinessLogConfig`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """业务日志配置列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageBusinessLogConfig`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageBusinessLogConfig()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeClusterInstancesRequest(AbstractModel):
    """DescribeClusterInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _SearchWord: 搜索字段
        :type SearchWord: str
        :param _OrderBy: 排序字段
        :type OrderBy: str
        :param _OrderType: 排序类型
        :type OrderType: int
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 分页个数
        :type Limit: int
        """
        self._ClusterId = None
        self._SearchWord = None
        self._OrderBy = None
        self._OrderType = None
        self._Offset = None
        self._Limit = None

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def SearchWord(self):
        """搜索字段
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def OrderBy(self):
        """排序字段
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        """排序类型
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页个数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._SearchWord = params.get("SearchWord")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterInstancesResponse(AbstractModel):
    """DescribeClusterInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 集群机器实例分页信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageInstance`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """集群机器实例分页信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageInstance`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageInstance()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeClustersRequest(AbstractModel):
    """DescribeClusters请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchWord: 搜索词
        :type SearchWord: str
        :param _OrderBy: 排序字段
        :type OrderBy: str
        :param _OrderType: 排序方式
        :type OrderType: int
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 分页个数
        :type Limit: int
        :param _ClusterType: 集群类型
        :type ClusterType: str
        :param _ClusterIdList: idList
        :type ClusterIdList: list of str
        """
        self._SearchWord = None
        self._OrderBy = None
        self._OrderType = None
        self._Offset = None
        self._Limit = None
        self._ClusterType = None
        self._ClusterIdList = None

    @property
    def SearchWord(self):
        """搜索词
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def OrderBy(self):
        """排序字段
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        """排序方式
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页个数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ClusterType(self):
        """集群类型
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def ClusterIdList(self):
        """idList
        :rtype: list of str
        """
        return self._ClusterIdList

    @ClusterIdList.setter
    def ClusterIdList(self, ClusterIdList):
        self._ClusterIdList = ClusterIdList


    def _deserialize(self, params):
        self._SearchWord = params.get("SearchWord")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ClusterType = params.get("ClusterType")
        self._ClusterIdList = params.get("ClusterIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClustersResponse(AbstractModel):
    """DescribeClusters返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: Cluster分页信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageClusterV2`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """Cluster分页信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageClusterV2`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageClusterV2()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeConfigReleaseLogsRequest(AbstractModel):
    """DescribeConfigReleaseLogs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID，不传入时查询全量
        :type GroupId: str
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Limit: 每页条数，默认为20
        :type Limit: int
        :param _NamespaceId: 命名空间ID，不传入时查询全量
        :type NamespaceId: str
        :param _ClusterId: 集群ID，不传入时查询全量
        :type ClusterId: str
        :param _ApplicationId: 应用ID，不传入时查询全量
        :type ApplicationId: str
        """
        self._GroupId = None
        self._Offset = None
        self._Limit = None
        self._NamespaceId = None
        self._ClusterId = None
        self._ApplicationId = None

    @property
    def GroupId(self):
        """部署组ID，不传入时查询全量
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def Offset(self):
        """偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """每页条数，默认为20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def NamespaceId(self):
        """命名空间ID，不传入时查询全量
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def ClusterId(self):
        """集群ID，不传入时查询全量
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ApplicationId(self):
        """应用ID，不传入时查询全量
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._NamespaceId = params.get("NamespaceId")
        self._ClusterId = params.get("ClusterId")
        self._ApplicationId = params.get("ApplicationId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeConfigReleaseLogsResponse(AbstractModel):
    """DescribeConfigReleaseLogs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 分页的配置项发布历史列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfigReleaseLog`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """分页的配置项发布历史列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfigReleaseLog`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageConfigReleaseLog()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeConfigReleasesRequest(AbstractModel):
    """DescribeConfigReleases请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigName: 配置项名称，不传入时查询全量
        :type ConfigName: str
        :param _GroupId: 部署组ID，不传入时查询全量
        :type GroupId: str
        :param _NamespaceId: 命名空间ID，不传入时查询全量
        :type NamespaceId: str
        :param _ClusterId: 集群ID，不传入时查询全量
        :type ClusterId: str
        :param _Limit: 每页条数
        :type Limit: int
        :param _Offset: 偏移量
        :type Offset: int
        :param _ConfigId: 配置ID，不传入时查询全量
        :type ConfigId: str
        :param _ApplicationId: 应用ID，不传入时查询全量
        :type ApplicationId: str
        """
        self._ConfigName = None
        self._GroupId = None
        self._NamespaceId = None
        self._ClusterId = None
        self._Limit = None
        self._Offset = None
        self._ConfigId = None
        self._ApplicationId = None

    @property
    def ConfigName(self):
        """配置项名称，不传入时查询全量
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def GroupId(self):
        """部署组ID，不传入时查询全量
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def NamespaceId(self):
        """命名空间ID，不传入时查询全量
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def ClusterId(self):
        """集群ID，不传入时查询全量
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Limit(self):
        """每页条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def ConfigId(self):
        """配置ID，不传入时查询全量
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def ApplicationId(self):
        """应用ID，不传入时查询全量
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId


    def _deserialize(self, params):
        self._ConfigName = params.get("ConfigName")
        self._GroupId = params.get("GroupId")
        self._NamespaceId = params.get("NamespaceId")
        self._ClusterId = params.get("ClusterId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._ConfigId = params.get("ConfigId")
        self._ApplicationId = params.get("ApplicationId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeConfigReleasesResponse(AbstractModel):
    """DescribeConfigReleases返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 分页的配置发布信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfigRelease`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """分页的配置发布信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfigRelease`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageConfigRelease()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeConfigRequest(AbstractModel):
    """DescribeConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置项ID
        :type ConfigId: str
        """
        self._ConfigId = None

    @property
    def ConfigId(self):
        """配置项ID
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeConfigResponse(AbstractModel):
    """DescribeConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 配置项
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.tsf.v20180326.models.Config`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """配置项
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.Config`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = Config()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeConfigSummaryRequest(AbstractModel):
    """DescribeConfigSummary请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplicationId: 应用ID，不传入时查询全量
        :type ApplicationId: str
        :param _SearchWord: 查询关键字，模糊查询：应用名称，配置项名称，不传入时查询全量
        :type SearchWord: str
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Limit: 每页条数，默认为20
        :type Limit: int
        :param _OrderBy: 按时间排序：creation_time；按名称排序：config_name
        :type OrderBy: str
        :param _OrderType: 升序传 0，降序传 1
        :type OrderType: int
        :param _ConfigTagList: 无
        :type ConfigTagList: list of str
        :param _DisableProgramAuthCheck: 无
        :type DisableProgramAuthCheck: bool
        :param _ConfigIdList: 无
        :type ConfigIdList: list of str
        """
        self._ApplicationId = None
        self._SearchWord = None
        self._Offset = None
        self._Limit = None
        self._OrderBy = None
        self._OrderType = None
        self._ConfigTagList = None
        self._DisableProgramAuthCheck = None
        self._ConfigIdList = None

    @property
    def ApplicationId(self):
        """应用ID，不传入时查询全量
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def SearchWord(self):
        """查询关键字，模糊查询：应用名称，配置项名称，不传入时查询全量
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def Offset(self):
        """偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """每页条数，默认为20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderBy(self):
        """按时间排序：creation_time；按名称排序：config_name
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        """升序传 0，降序传 1
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def ConfigTagList(self):
        """无
        :rtype: list of str
        """
        return self._ConfigTagList

    @ConfigTagList.setter
    def ConfigTagList(self, ConfigTagList):
        self._ConfigTagList = ConfigTagList

    @property
    def DisableProgramAuthCheck(self):
        """无
        :rtype: bool
        """
        return self._DisableProgramAuthCheck

    @DisableProgramAuthCheck.setter
    def DisableProgramAuthCheck(self, DisableProgramAuthCheck):
        self._DisableProgramAuthCheck = DisableProgramAuthCheck

    @property
    def ConfigIdList(self):
        """无
        :rtype: list of str
        """
        return self._ConfigIdList

    @ConfigIdList.setter
    def ConfigIdList(self, ConfigIdList):
        self._ConfigIdList = ConfigIdList


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._SearchWord = params.get("SearchWord")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        self._ConfigTagList = params.get("ConfigTagList")
        self._DisableProgramAuthCheck = params.get("DisableProgramAuthCheck")
        self._ConfigIdList = params.get("ConfigIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeConfigSummaryResponse(AbstractModel):
    """DescribeConfigSummary返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 配置项分页对象
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfig`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """配置项分页对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfig`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageConfig()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeConfigTemplateRequest(AbstractModel):
    """DescribeConfigTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigTemplateId: 配置模板Id
        :type ConfigTemplateId: str
        """
        self._ConfigTemplateId = None

    @property
    def ConfigTemplateId(self):
        """配置模板Id
        :rtype: str
        """
        return self._ConfigTemplateId

    @ConfigTemplateId.setter
    def ConfigTemplateId(self, ConfigTemplateId):
        self._ConfigTemplateId = ConfigTemplateId


    def _deserialize(self, params):
        self._ConfigTemplateId = params.get("ConfigTemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeConfigTemplateResponse(AbstractModel):
    """DescribeConfigTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 导入结果
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ConfigTemplate`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """导入结果
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ConfigTemplate`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ConfigTemplate()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeConfigsRequest(AbstractModel):
    """DescribeConfigs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplicationId: 应用ID，不传入时查询全量
        :type ApplicationId: str
        :param _ConfigId: 配置项ID，不传入时查询全量，高优先级
        :type ConfigId: str
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 每页条数
        :type Limit: int
        :param _ConfigIdList: 配置项ID列表，不传入时查询全量，低优先级
        :type ConfigIdList: list of str
        :param _ConfigName: 配置项名称，精确查询，不传入时查询全量
        :type ConfigName: str
        :param _ConfigVersion: 配置项版本，精确查询，不传入时查询全量
        :type ConfigVersion: str
        """
        self._ApplicationId = None
        self._ConfigId = None
        self._Offset = None
        self._Limit = None
        self._ConfigIdList = None
        self._ConfigName = None
        self._ConfigVersion = None

    @property
    def ApplicationId(self):
        """应用ID，不传入时查询全量
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ConfigId(self):
        """配置项ID，不传入时查询全量，高优先级
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """每页条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ConfigIdList(self):
        """配置项ID列表，不传入时查询全量，低优先级
        :rtype: list of str
        """
        return self._ConfigIdList

    @ConfigIdList.setter
    def ConfigIdList(self, ConfigIdList):
        self._ConfigIdList = ConfigIdList

    @property
    def ConfigName(self):
        """配置项名称，精确查询，不传入时查询全量
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigVersion(self):
        """配置项版本，精确查询，不传入时查询全量
        :rtype: str
        """
        return self._ConfigVersion

    @ConfigVersion.setter
    def ConfigVersion(self, ConfigVersion):
        self._ConfigVersion = ConfigVersion


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._ConfigId = params.get("ConfigId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ConfigIdList = params.get("ConfigIdList")
        self._ConfigName = params.get("ConfigName")
        self._ConfigVersion = params.get("ConfigVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeConfigsResponse(AbstractModel):
    """DescribeConfigs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 分页后的配置项列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfig`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """分页后的配置项列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfig`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageConfig()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeContainerEventsRequest(AbstractModel):
    """DescribeContainerEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceType: event 的资源类型, group 或者 instance
        :type ResourceType: str
        :param _ResourceId: event 的资源 id
        :type ResourceId: str
        :param _Offset: 偏移量，取值从0开始
        :type Offset: int
        :param _Limit: 分页个数，默认为20， 取值应为1~50
        :type Limit: int
        :param _GroupId: 当类型是 instance 时需要
        :type GroupId: str
        :param _Kind: event的资源kind
        :type Kind: str
        :param _Type: event 的type
        :type Type: str
        :param _ResourceName: 资源名称
        :type ResourceName: str
        :param _SearchWord: 关键词查询
        :type SearchWord: str
        """
        self._ResourceType = None
        self._ResourceId = None
        self._Offset = None
        self._Limit = None
        self._GroupId = None
        self._Kind = None
        self._Type = None
        self._ResourceName = None
        self._SearchWord = None

    @property
    def ResourceType(self):
        """event 的资源类型, group 或者 instance
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ResourceId(self):
        """event 的资源 id
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def Offset(self):
        """偏移量，取值从0开始
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页个数，默认为20， 取值应为1~50
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def GroupId(self):
        """当类型是 instance 时需要
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def Kind(self):
        """event的资源kind
        :rtype: str
        """
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def Type(self):
        """event 的type
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ResourceName(self):
        """资源名称
        :rtype: str
        """
        return self._ResourceName

    @ResourceName.setter
    def ResourceName(self, ResourceName):
        self._ResourceName = ResourceName

    @property
    def SearchWord(self):
        """关键词查询
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord


    def _deserialize(self, params):
        self._ResourceType = params.get("ResourceType")
        self._ResourceId = params.get("ResourceId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._GroupId = params.get("GroupId")
        self._Kind = params.get("Kind")
        self._Type = params.get("Type")
        self._ResourceName = params.get("ResourceName")
        self._SearchWord = params.get("SearchWord")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeContainerEventsResponse(AbstractModel):
    """DescribeContainerEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: events 分页列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageContainerEvent`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """events 分页列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageContainerEvent`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageContainerEvent()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeContainerGroupAttributeRequest(AbstractModel):
    """DescribeContainerGroupAttribute请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID
        :type GroupId: str
        """
        self._GroupId = None

    @property
    def GroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeContainerGroupAttributeResponse(AbstractModel):
    """DescribeContainerGroupAttribute返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 部署组列表-其它字段
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ContainerGroupOther`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """部署组列表-其它字段
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ContainerGroupOther`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ContainerGroupOther()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeContainerGroupDeployInfoRequest(AbstractModel):
    """DescribeContainerGroupDeployInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 实例所属 groupId
        :type GroupId: str
        """
        self._GroupId = None

    @property
    def GroupId(self):
        """实例所属 groupId
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeContainerGroupDeployInfoResponse(AbstractModel):
    """DescribeContainerGroupDeployInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 获取部署组
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ContainerGroupDeploy`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """获取部署组
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ContainerGroupDeploy`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ContainerGroupDeploy()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeContainerGroupDetailRequest(AbstractModel):
    """DescribeContainerGroupDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 分组ID
        :type GroupId: str
        """
        self._GroupId = None

    @property
    def GroupId(self):
        """分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeContainerGroupDetailResponse(AbstractModel):
    """DescribeContainerGroupDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 容器部署组详情
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ContainerGroupDetail`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """容器部署组详情
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ContainerGroupDetail`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ContainerGroupDetail()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeContainerGroupsRequest(AbstractModel):
    """DescribeContainerGroups请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplicationId: 分组所属应用ID。
        :type ApplicationId: str
        :param _SearchWord: 搜索字段，模糊搜索groupName字段
        :type SearchWord: str
        :param _OrderBy: 排序字段，默认为 createTime字段，支持id， name， createTime
        :type OrderBy: str
        :param _OrderType: 排序方式，默认为1：倒序排序，0：正序，1：倒序
        :type OrderType: int
        :param _Offset: 偏移量，取值从0开始
        :type Offset: int
        :param _Limit: 分页个数，默认为20， 取值应为1~50
        :type Limit: int
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _NamespaceId: 命名空间 ID
        :type NamespaceId: str
        """
        self._ApplicationId = None
        self._SearchWord = None
        self._OrderBy = None
        self._OrderType = None
        self._Offset = None
        self._Limit = None
        self._ClusterId = None
        self._NamespaceId = None

    @property
    def ApplicationId(self):
        """分组所属应用ID。
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def SearchWord(self):
        """搜索字段，模糊搜索groupName字段
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def OrderBy(self):
        """排序字段，默认为 createTime字段，支持id， name， createTime
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        """排序方式，默认为1：倒序排序，0：正序，1：倒序
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def Offset(self):
        """偏移量，取值从0开始
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页个数，默认为20， 取值应为1~50
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        """命名空间 ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._SearchWord = params.get("SearchWord")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeContainerGroupsResponse(AbstractModel):
    """DescribeContainerGroups返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 查询的权限数据对象
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ContainGroupResult`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """查询的权限数据对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ContainGroupResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ContainGroupResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeCreateGatewayApiStatusRequest(AbstractModel):
    """DescribeCreateGatewayApiStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 所属分组ID
        :type GroupId: str
        :param _MicroserviceId: 微服务ID
        :type MicroserviceId: str
        """
        self._GroupId = None
        self._MicroserviceId = None

    @property
    def GroupId(self):
        """所属分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def MicroserviceId(self):
        """微服务ID
        :rtype: str
        """
        return self._MicroserviceId

    @MicroserviceId.setter
    def MicroserviceId(self, MicroserviceId):
        self._MicroserviceId = MicroserviceId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._MicroserviceId = params.get("MicroserviceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCreateGatewayApiStatusResponse(AbstractModel):
    """DescribeCreateGatewayApiStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 是否已完成导入任务
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """是否已完成导入任务
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DescribeDeliveryConfigByGroupIdRequest(AbstractModel):
    """DescribeDeliveryConfigByGroupId请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组id
        :type GroupId: str
        """
        self._GroupId = None

    @property
    def GroupId(self):
        """部署组id
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDeliveryConfigByGroupIdResponse(AbstractModel):
    """DescribeDeliveryConfigByGroupId返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 投递kafka配置项
        :type Result: :class:`tencentcloud.tsf.v20180326.models.SimpleKafkaDeliveryConfig`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """投递kafka配置项
        :rtype: :class:`tencentcloud.tsf.v20180326.models.SimpleKafkaDeliveryConfig`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = SimpleKafkaDeliveryConfig()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeDeliveryConfigRequest(AbstractModel):
    """DescribeDeliveryConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 投递配置id
        :type ConfigId: str
        """
        self._ConfigId = None

    @property
    def ConfigId(self):
        """投递配置id
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDeliveryConfigResponse(AbstractModel):
    """DescribeDeliveryConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 投递kafka配置
        :type Result: :class:`tencentcloud.tsf.v20180326.models.KafkaDeliveryConfig`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """投递kafka配置
        :rtype: :class:`tencentcloud.tsf.v20180326.models.KafkaDeliveryConfig`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = KafkaDeliveryConfig()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeDeliveryConfigsRequest(AbstractModel):
    """DescribeDeliveryConfigs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchWord: 关键字
        :type SearchWord: str
        :param _Offset: 偏移
        :type Offset: int
        :param _Limit: 搜索条数
        :type Limit: int
        :param _ProgramIdList: 数据集idList
        :type ProgramIdList: list of str
        :param _ConfigIdList: ConfigIdList
        :type ConfigIdList: list of str
        """
        self._SearchWord = None
        self._Offset = None
        self._Limit = None
        self._ProgramIdList = None
        self._ConfigIdList = None

    @property
    def SearchWord(self):
        """关键字
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def Offset(self):
        """偏移
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """搜索条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ProgramIdList(self):
        """数据集idList
        :rtype: list of str
        """
        return self._ProgramIdList

    @ProgramIdList.setter
    def ProgramIdList(self, ProgramIdList):
        self._ProgramIdList = ProgramIdList

    @property
    def ConfigIdList(self):
        """ConfigIdList
        :rtype: list of str
        """
        return self._ConfigIdList

    @ConfigIdList.setter
    def ConfigIdList(self, ConfigIdList):
        self._ConfigIdList = ConfigIdList


    def _deserialize(self, params):
        self._SearchWord = params.get("SearchWord")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ProgramIdList = params.get("ProgramIdList")
        self._ConfigIdList = params.get("ConfigIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDeliveryConfigsResponse(AbstractModel):
    """DescribeDeliveryConfigs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 投递项关联部署组信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.DeliveryConfigBindGroups`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """投递项关联部署组信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.DeliveryConfigBindGroups`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = DeliveryConfigBindGroups()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeDownloadInfoRequest(AbstractModel):
    """DescribeDownloadInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        :param _PkgId: 程序包ID
        :type PkgId: str
        :param _RepositoryId: 程序包仓库ID
        :type RepositoryId: str
        :param _RepositoryType: 程序包仓库类型
        :type RepositoryType: str
        """
        self._ApplicationId = None
        self._PkgId = None
        self._RepositoryId = None
        self._RepositoryType = None

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def PkgId(self):
        """程序包ID
        :rtype: str
        """
        return self._PkgId

    @PkgId.setter
    def PkgId(self, PkgId):
        self._PkgId = PkgId

    @property
    def RepositoryId(self):
        """程序包仓库ID
        :rtype: str
        """
        return self._RepositoryId

    @RepositoryId.setter
    def RepositoryId(self, RepositoryId):
        self._RepositoryId = RepositoryId

    @property
    def RepositoryType(self):
        """程序包仓库类型
        :rtype: str
        """
        return self._RepositoryType

    @RepositoryType.setter
    def RepositoryType(self, RepositoryType):
        self._RepositoryType = RepositoryType


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._PkgId = params.get("PkgId")
        self._RepositoryId = params.get("RepositoryId")
        self._RepositoryType = params.get("RepositoryType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDownloadInfoResponse(AbstractModel):
    """DescribeDownloadInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: COS鉴权信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.CosDownloadInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """COS鉴权信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.CosDownloadInfo`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = CosDownloadInfo()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeEnabledUnitRuleRequest(AbstractModel):
    """DescribeEnabledUnitRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayInstanceId: 网关实体ID
        :type GatewayInstanceId: str
        """
        self._GatewayInstanceId = None

    @property
    def GatewayInstanceId(self):
        """网关实体ID
        :rtype: str
        """
        return self._GatewayInstanceId

    @GatewayInstanceId.setter
    def GatewayInstanceId(self, GatewayInstanceId):
        self._GatewayInstanceId = GatewayInstanceId


    def _deserialize(self, params):
        self._GatewayInstanceId = params.get("GatewayInstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEnabledUnitRuleResponse(AbstractModel):
    """DescribeEnabledUnitRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 单元化规则对象
        :type Result: :class:`tencentcloud.tsf.v20180326.models.UnitRule`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """单元化规则对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.UnitRule`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = UnitRule()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeFileConfigReleasesRequest(AbstractModel):
    """DescribeFileConfigReleases请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置项ID
        :type ConfigId: str
        :param _ConfigName: 配置项名称
        :type ConfigName: str
        :param _GroupId: 部署组ID
        :type GroupId: str
        :param _NamespaceId: 命名空间ID
        :type NamespaceId: str
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 每页条数
        :type Limit: int
        """
        self._ConfigId = None
        self._ConfigName = None
        self._GroupId = None
        self._NamespaceId = None
        self._ClusterId = None
        self._ApplicationId = None
        self._Offset = None
        self._Limit = None

    @property
    def ConfigId(self):
        """配置项ID
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def ConfigName(self):
        """配置项名称
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def GroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def NamespaceId(self):
        """命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """每页条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        self._ConfigName = params.get("ConfigName")
        self._GroupId = params.get("GroupId")
        self._NamespaceId = params.get("NamespaceId")
        self._ClusterId = params.get("ClusterId")
        self._ApplicationId = params.get("ApplicationId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFileConfigReleasesResponse(AbstractModel):
    """DescribeFileConfigReleases返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 配置项发布信息列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageFileConfigRelease`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """配置项发布信息列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageFileConfigRelease`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageFileConfigRelease()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeFileConfigsRequest(AbstractModel):
    """DescribeFileConfigs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置项ID
        :type ConfigId: str
        :param _ConfigIdList: 配置项ID列表
        :type ConfigIdList: list of str
        :param _ConfigName: 配置项名称
        :type ConfigName: str
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 每页条数
        :type Limit: int
        :param _ConfigVersion: 配置项版本
        :type ConfigVersion: str
        """
        self._ConfigId = None
        self._ConfigIdList = None
        self._ConfigName = None
        self._ApplicationId = None
        self._Offset = None
        self._Limit = None
        self._ConfigVersion = None

    @property
    def ConfigId(self):
        """配置项ID
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def ConfigIdList(self):
        """配置项ID列表
        :rtype: list of str
        """
        return self._ConfigIdList

    @ConfigIdList.setter
    def ConfigIdList(self, ConfigIdList):
        self._ConfigIdList = ConfigIdList

    @property
    def ConfigName(self):
        """配置项名称
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """每页条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ConfigVersion(self):
        """配置项版本
        :rtype: str
        """
        return self._ConfigVersion

    @ConfigVersion.setter
    def ConfigVersion(self, ConfigVersion):
        self._ConfigVersion = ConfigVersion


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        self._ConfigIdList = params.get("ConfigIdList")
        self._ConfigName = params.get("ConfigName")
        self._ApplicationId = params.get("ApplicationId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ConfigVersion = params.get("ConfigVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFileConfigsResponse(AbstractModel):
    """DescribeFileConfigs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 文件配置项列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageFileConfig`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """文件配置项列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageFileConfig`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageFileConfig()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeFlowLastBatchStateRequest(AbstractModel):
    """DescribeFlowLastBatchState请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 工作流 ID
        :type FlowId: str
        """
        self._FlowId = None

    @property
    def FlowId(self):
        """工作流 ID
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFlowLastBatchStateResponse(AbstractModel):
    """DescribeFlowLastBatchState返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 工作流批次最新状态
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TaskFlowLastBatchState`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """工作流批次最新状态
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TaskFlowLastBatchState`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TaskFlowLastBatchState()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeGatewayAllGroupApisRequest(AbstractModel):
    """DescribeGatewayAllGroupApis请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayDeployGroupId: 网关部署组ID
        :type GatewayDeployGroupId: str
        :param _SearchWord: 搜索关键字，支持命名空间名称或服务名称
        :type SearchWord: str
        """
        self._GatewayDeployGroupId = None
        self._SearchWord = None

    @property
    def GatewayDeployGroupId(self):
        """网关部署组ID
        :rtype: str
        """
        return self._GatewayDeployGroupId

    @GatewayDeployGroupId.setter
    def GatewayDeployGroupId(self, GatewayDeployGroupId):
        self._GatewayDeployGroupId = GatewayDeployGroupId

    @property
    def SearchWord(self):
        """搜索关键字，支持命名空间名称或服务名称
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord


    def _deserialize(self, params):
        self._GatewayDeployGroupId = params.get("GatewayDeployGroupId")
        self._SearchWord = params.get("SearchWord")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGatewayAllGroupApisResponse(AbstractModel):
    """DescribeGatewayAllGroupApis返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 网关分组和API列表信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.GatewayVo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """网关分组和API列表信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.GatewayVo`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = GatewayVo()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeGatewayApisRequest(AbstractModel):
    """DescribeGatewayApis请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 分组ID
        :type GroupId: str
        :param _Offset: 翻页偏移量
        :type Offset: int
        :param _Limit: 每页的记录数
        :type Limit: int
        :param _SearchWord: 搜索关键字，支持 API path
        :type SearchWord: str
        :param _GatewayDeployGroupId: 部署组ID
        :type GatewayDeployGroupId: str
        :param _ReleaseStatus: 发布状态, drafted(未发布)/released(已发布)/releasing(发布中)/failed(发布失败)
        :type ReleaseStatus: str
        """
        self._GroupId = None
        self._Offset = None
        self._Limit = None
        self._SearchWord = None
        self._GatewayDeployGroupId = None
        self._ReleaseStatus = None

    @property
    def GroupId(self):
        """分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def Offset(self):
        """翻页偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """每页的记录数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchWord(self):
        """搜索关键字，支持 API path
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def GatewayDeployGroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GatewayDeployGroupId

    @GatewayDeployGroupId.setter
    def GatewayDeployGroupId(self, GatewayDeployGroupId):
        self._GatewayDeployGroupId = GatewayDeployGroupId

    @property
    def ReleaseStatus(self):
        """发布状态, drafted(未发布)/released(已发布)/releasing(发布中)/failed(发布失败)
        :rtype: str
        """
        return self._ReleaseStatus

    @ReleaseStatus.setter
    def ReleaseStatus(self, ReleaseStatus):
        self._ReleaseStatus = ReleaseStatus


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchWord = params.get("SearchWord")
        self._GatewayDeployGroupId = params.get("GatewayDeployGroupId")
        self._ReleaseStatus = params.get("ReleaseStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGatewayApisResponse(AbstractModel):
    """DescribeGatewayApis返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 翻页结构
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageApiDetailInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """翻页结构
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageApiDetailInfo`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageApiDetailInfo()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeGatewayMonitorOverviewRequest(AbstractModel):
    """DescribeGatewayMonitorOverview请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayDeployGroupId: 网关部署组ID
        :type GatewayDeployGroupId: str
        """
        self._GatewayDeployGroupId = None

    @property
    def GatewayDeployGroupId(self):
        """网关部署组ID
        :rtype: str
        """
        return self._GatewayDeployGroupId

    @GatewayDeployGroupId.setter
    def GatewayDeployGroupId(self, GatewayDeployGroupId):
        self._GatewayDeployGroupId = GatewayDeployGroupId


    def _deserialize(self, params):
        self._GatewayDeployGroupId = params.get("GatewayDeployGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGatewayMonitorOverviewResponse(AbstractModel):
    """DescribeGatewayMonitorOverview返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 监控概览对象
        :type Result: :class:`tencentcloud.tsf.v20180326.models.MonitorOverview`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """监控概览对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.MonitorOverview`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = MonitorOverview()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeGroupAttributeRequest(AbstractModel):
    """DescribeGroupAttribute请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID字段
        :type GroupId: str
        """
        self._GroupId = None

    @property
    def GroupId(self):
        """部署组ID字段
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGroupAttributeResponse(AbstractModel):
    """DescribeGroupAttribute返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 虚拟机部署组信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.VmGroupOther`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """虚拟机部署组信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.VmGroupOther`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = VmGroupOther()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeGroupBindedGatewaysRequest(AbstractModel):
    """DescribeGroupBindedGateways请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: API 分组ID
        :type GroupId: str
        :param _Offset: 翻页查询偏移量
        :type Offset: int
        :param _Limit: 翻页查询每页记录数
        :type Limit: int
        :param _SearchWord: 搜索关键字
        :type SearchWord: str
        """
        self._GroupId = None
        self._Offset = None
        self._Limit = None
        self._SearchWord = None

    @property
    def GroupId(self):
        """API 分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def Offset(self):
        """翻页查询偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """翻页查询每页记录数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchWord(self):
        """搜索关键字
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchWord = params.get("SearchWord")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGroupBindedGatewaysResponse(AbstractModel):
    """DescribeGroupBindedGateways返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 翻页结构体
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageGatewayDeployGroup`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """翻页结构体
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageGatewayDeployGroup`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageGatewayDeployGroup()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeGroupBusinessLogConfigsRequest(AbstractModel):
    """DescribeGroupBusinessLogConfigs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 分组ID
        :type GroupId: str
        """
        self._GroupId = None

    @property
    def GroupId(self):
        """分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGroupBusinessLogConfigsResponse(AbstractModel):
    """DescribeGroupBusinessLogConfigs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 业务日志配置列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageBusinessLogConfig`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """业务日志配置列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageBusinessLogConfig`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageBusinessLogConfig()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeGroupGatewaysRequest(AbstractModel):
    """DescribeGroupGateways请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayDeployGroupId: 网关部署组ID
        :type GatewayDeployGroupId: str
        :param _Offset: 翻页查询偏移量
        :type Offset: int
        :param _Limit: 翻页查询每页记录数
        :type Limit: int
        :param _SearchWord: 搜索关键字
        :type SearchWord: str
        """
        self._GatewayDeployGroupId = None
        self._Offset = None
        self._Limit = None
        self._SearchWord = None

    @property
    def GatewayDeployGroupId(self):
        """网关部署组ID
        :rtype: str
        """
        return self._GatewayDeployGroupId

    @GatewayDeployGroupId.setter
    def GatewayDeployGroupId(self, GatewayDeployGroupId):
        self._GatewayDeployGroupId = GatewayDeployGroupId

    @property
    def Offset(self):
        """翻页查询偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """翻页查询每页记录数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchWord(self):
        """搜索关键字
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord


    def _deserialize(self, params):
        self._GatewayDeployGroupId = params.get("GatewayDeployGroupId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchWord = params.get("SearchWord")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGroupGatewaysResponse(AbstractModel):
    """DescribeGroupGateways返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: API分组信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageApiGroupInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """API分组信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageApiGroupInfo`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageApiGroupInfo()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeGroupInstancesRequest(AbstractModel):
    """DescribeGroupInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID
        :type GroupId: str
        :param _SearchWord: 搜索字段
        :type SearchWord: str
        :param _OrderBy: 排序字段
        :type OrderBy: str
        :param _OrderType: 排序类型
        :type OrderType: int
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 分页个数
        :type Limit: int
        """
        self._GroupId = None
        self._SearchWord = None
        self._OrderBy = None
        self._OrderType = None
        self._Offset = None
        self._Limit = None

    @property
    def GroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def SearchWord(self):
        """搜索字段
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def OrderBy(self):
        """排序字段
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        """排序类型
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页个数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._SearchWord = params.get("SearchWord")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGroupInstancesResponse(AbstractModel):
    """DescribeGroupInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 部署组机器信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageInstance`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """部署组机器信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageInstance`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageInstance()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeGroupReleaseRequest(AbstractModel):
    """DescribeGroupRelease请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID
        :type GroupId: str
        """
        self._GroupId = None

    @property
    def GroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGroupReleaseResponse(AbstractModel):
    """DescribeGroupRelease返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 部署组发布的相关信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.GroupRelease`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """部署组发布的相关信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.GroupRelease`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = GroupRelease()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeGroupRequest(AbstractModel):
    """DescribeGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID
        :type GroupId: str
        """
        self._GroupId = None

    @property
    def GroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGroupResponse(AbstractModel):
    """DescribeGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 虚拟机部署组详情
        :type Result: :class:`tencentcloud.tsf.v20180326.models.VmGroup`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """虚拟机部署组详情
        :rtype: :class:`tencentcloud.tsf.v20180326.models.VmGroup`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = VmGroup()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeGroupUseDetailRequest(AbstractModel):
    """DescribeGroupUseDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayDeployGroupId: 网关部署组ID
        :type GatewayDeployGroupId: str
        :param _GroupId: 网关分组ID
        :type GroupId: str
        :param _StartTime: 查询的日期,格式：yyyy-MM-dd HH:mm:ss
        :type StartTime: str
        :param _EndTime: 查询的日期,格式：yyyy-MM-dd HH:mm:ss
        :type EndTime: str
        :param _Count: 指定top的条数,默认为10
        :type Count: int
        """
        self._GatewayDeployGroupId = None
        self._GroupId = None
        self._StartTime = None
        self._EndTime = None
        self._Count = None

    @property
    def GatewayDeployGroupId(self):
        """网关部署组ID
        :rtype: str
        """
        return self._GatewayDeployGroupId

    @GatewayDeployGroupId.setter
    def GatewayDeployGroupId(self, GatewayDeployGroupId):
        self._GatewayDeployGroupId = GatewayDeployGroupId

    @property
    def GroupId(self):
        """网关分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def StartTime(self):
        """查询的日期,格式：yyyy-MM-dd HH:mm:ss
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """查询的日期,格式：yyyy-MM-dd HH:mm:ss
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Count(self):
        """指定top的条数,默认为10
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count


    def _deserialize(self, params):
        self._GatewayDeployGroupId = params.get("GatewayDeployGroupId")
        self._GroupId = params.get("GroupId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Count = params.get("Count")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGroupUseDetailResponse(AbstractModel):
    """DescribeGroupUseDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 日使用统计对象
        :type Result: :class:`tencentcloud.tsf.v20180326.models.GroupDailyUseStatistics`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """日使用统计对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.GroupDailyUseStatistics`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = GroupDailyUseStatistics()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeGroupsRequest(AbstractModel):
    """DescribeGroups请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchWord: 搜索字段
        :type SearchWord: str
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        :param _OrderBy: 排序字段
        :type OrderBy: str
        :param _OrderType: 排序方式
        :type OrderType: int
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 分页个数
        :type Limit: int
        :param _NamespaceId: 命名空间ID
        :type NamespaceId: str
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _GroupResourceTypeList: 部署组资源类型列表
        :type GroupResourceTypeList: list of str
        :param _Status: 部署组状态过滤字段
        :type Status: str
        :param _GroupIdList: 无
        :type GroupIdList: list of str
        """
        self._SearchWord = None
        self._ApplicationId = None
        self._OrderBy = None
        self._OrderType = None
        self._Offset = None
        self._Limit = None
        self._NamespaceId = None
        self._ClusterId = None
        self._GroupResourceTypeList = None
        self._Status = None
        self._GroupIdList = None

    @property
    def SearchWord(self):
        """搜索字段
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def OrderBy(self):
        """排序字段
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        """排序方式
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页个数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def NamespaceId(self):
        """命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def GroupResourceTypeList(self):
        """部署组资源类型列表
        :rtype: list of str
        """
        return self._GroupResourceTypeList

    @GroupResourceTypeList.setter
    def GroupResourceTypeList(self, GroupResourceTypeList):
        self._GroupResourceTypeList = GroupResourceTypeList

    @property
    def Status(self):
        """部署组状态过滤字段
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def GroupIdList(self):
        """无
        :rtype: list of str
        """
        return self._GroupIdList

    @GroupIdList.setter
    def GroupIdList(self, GroupIdList):
        self._GroupIdList = GroupIdList


    def _deserialize(self, params):
        self._SearchWord = params.get("SearchWord")
        self._ApplicationId = params.get("ApplicationId")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._NamespaceId = params.get("NamespaceId")
        self._ClusterId = params.get("ClusterId")
        self._GroupResourceTypeList = params.get("GroupResourceTypeList")
        self._Status = params.get("Status")
        self._GroupIdList = params.get("GroupIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGroupsResponse(AbstractModel):
    """DescribeGroups返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 虚拟机部署组分页信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageVmGroup`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """虚拟机部署组分页信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageVmGroup`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageVmGroup()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeGroupsWithPluginRequest(AbstractModel):
    """DescribeGroupsWithPlugin请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PluginId: 插件ID
        :type PluginId: str
        :param _Offset: 翻页偏移量
        :type Offset: int
        :param _Limit: 每页记录数量
        :type Limit: int
        :param _Bound: 绑定/未绑定: true / false
        :type Bound: bool
        :param _SearchWord: 搜索关键字
        :type SearchWord: str
        :param _GatewayInstanceId: 网关实体ID
        :type GatewayInstanceId: str
        """
        self._PluginId = None
        self._Offset = None
        self._Limit = None
        self._Bound = None
        self._SearchWord = None
        self._GatewayInstanceId = None

    @property
    def PluginId(self):
        """插件ID
        :rtype: str
        """
        return self._PluginId

    @PluginId.setter
    def PluginId(self, PluginId):
        self._PluginId = PluginId

    @property
    def Offset(self):
        """翻页偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """每页记录数量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Bound(self):
        """绑定/未绑定: true / false
        :rtype: bool
        """
        return self._Bound

    @Bound.setter
    def Bound(self, Bound):
        self._Bound = Bound

    @property
    def SearchWord(self):
        """搜索关键字
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def GatewayInstanceId(self):
        """网关实体ID
        :rtype: str
        """
        return self._GatewayInstanceId

    @GatewayInstanceId.setter
    def GatewayInstanceId(self, GatewayInstanceId):
        self._GatewayInstanceId = GatewayInstanceId


    def _deserialize(self, params):
        self._PluginId = params.get("PluginId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Bound = params.get("Bound")
        self._SearchWord = params.get("SearchWord")
        self._GatewayInstanceId = params.get("GatewayInstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGroupsWithPluginResponse(AbstractModel):
    """DescribeGroupsWithPlugin返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: API分组信息列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageApiGroupInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """API分组信息列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageApiGroupInfo`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageApiGroupInfo()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeImageRepositoryRequest(AbstractModel):
    """DescribeImageRepository请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchWord: 仓库名，搜索关键字,不带命名空间的
        :type SearchWord: str
        :param _Offset: 偏移量，取值从0开始
        :type Offset: int
        :param _Limit: 分页个数，默认为20， 取值应为1~100
        :type Limit: int
        :param _RepoType: 企业: tcr ；个人: personal或者不填
        :type RepoType: str
        :param _ApplicationId: 应用id
        :type ApplicationId: str
        :param _TcrRepoInfo: TcrRepoInfo值
        :type TcrRepoInfo: :class:`tencentcloud.tsf.v20180326.models.TcrRepoInfo`
        :param _RepoName: 镜像仓库名称
        :type RepoName: str
        """
        self._SearchWord = None
        self._Offset = None
        self._Limit = None
        self._RepoType = None
        self._ApplicationId = None
        self._TcrRepoInfo = None
        self._RepoName = None

    @property
    def SearchWord(self):
        """仓库名，搜索关键字,不带命名空间的
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def Offset(self):
        """偏移量，取值从0开始
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页个数，默认为20， 取值应为1~100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def RepoType(self):
        """企业: tcr ；个人: personal或者不填
        :rtype: str
        """
        return self._RepoType

    @RepoType.setter
    def RepoType(self, RepoType):
        self._RepoType = RepoType

    @property
    def ApplicationId(self):
        """应用id
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def TcrRepoInfo(self):
        """TcrRepoInfo值
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TcrRepoInfo`
        """
        return self._TcrRepoInfo

    @TcrRepoInfo.setter
    def TcrRepoInfo(self, TcrRepoInfo):
        self._TcrRepoInfo = TcrRepoInfo

    @property
    def RepoName(self):
        """镜像仓库名称
        :rtype: str
        """
        return self._RepoName

    @RepoName.setter
    def RepoName(self, RepoName):
        self._RepoName = RepoName


    def _deserialize(self, params):
        self._SearchWord = params.get("SearchWord")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._RepoType = params.get("RepoType")
        self._ApplicationId = params.get("ApplicationId")
        if params.get("TcrRepoInfo") is not None:
            self._TcrRepoInfo = TcrRepoInfo()
            self._TcrRepoInfo._deserialize(params.get("TcrRepoInfo"))
        self._RepoName = params.get("RepoName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageRepositoryResponse(AbstractModel):
    """DescribeImageRepository返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 查询的权限数据对象
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ImageRepositoryResult`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """查询的权限数据对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ImageRepositoryResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ImageRepositoryResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeImageTagsRequest(AbstractModel):
    """DescribeImageTags请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplicationId: 应用Id
        :type ApplicationId: str
        :param _Offset: 偏移量，取值从0开始
        :type Offset: int
        :param _Limit: 分页个数，默认为20， 取值应为1~100
        :type Limit: int
        :param _QueryImageIdFlag: 不填和0:查询 1:不查询
        :type QueryImageIdFlag: int
        :param _SearchWord: 可用于搜索的 tag 名字
        :type SearchWord: str
        :param _RepoType: 企业: tcr ；个人: personal或者不填
        :type RepoType: str
        :param _TcrRepoInfo: TcrRepoInfo值
        :type TcrRepoInfo: :class:`tencentcloud.tsf.v20180326.models.TcrRepoInfo`
        :param _RepoName: 仓库名
        :type RepoName: str
        """
        self._ApplicationId = None
        self._Offset = None
        self._Limit = None
        self._QueryImageIdFlag = None
        self._SearchWord = None
        self._RepoType = None
        self._TcrRepoInfo = None
        self._RepoName = None

    @property
    def ApplicationId(self):
        """应用Id
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def Offset(self):
        """偏移量，取值从0开始
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页个数，默认为20， 取值应为1~100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def QueryImageIdFlag(self):
        """不填和0:查询 1:不查询
        :rtype: int
        """
        return self._QueryImageIdFlag

    @QueryImageIdFlag.setter
    def QueryImageIdFlag(self, QueryImageIdFlag):
        self._QueryImageIdFlag = QueryImageIdFlag

    @property
    def SearchWord(self):
        """可用于搜索的 tag 名字
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def RepoType(self):
        """企业: tcr ；个人: personal或者不填
        :rtype: str
        """
        return self._RepoType

    @RepoType.setter
    def RepoType(self, RepoType):
        self._RepoType = RepoType

    @property
    def TcrRepoInfo(self):
        """TcrRepoInfo值
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TcrRepoInfo`
        """
        return self._TcrRepoInfo

    @TcrRepoInfo.setter
    def TcrRepoInfo(self, TcrRepoInfo):
        self._TcrRepoInfo = TcrRepoInfo

    @property
    def RepoName(self):
        """仓库名
        :rtype: str
        """
        return self._RepoName

    @RepoName.setter
    def RepoName(self, RepoName):
        self._RepoName = RepoName


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._QueryImageIdFlag = params.get("QueryImageIdFlag")
        self._SearchWord = params.get("SearchWord")
        self._RepoType = params.get("RepoType")
        if params.get("TcrRepoInfo") is not None:
            self._TcrRepoInfo = TcrRepoInfo()
            self._TcrRepoInfo._deserialize(params.get("TcrRepoInfo"))
        self._RepoName = params.get("RepoName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageTagsResponse(AbstractModel):
    """DescribeImageTags返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 查询的权限数据对象
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ImageTagsResult`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """查询的权限数据对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ImageTagsResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ImageTagsResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeInovcationIndicatorsRequest(AbstractModel):
    """DescribeInovcationIndicators请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Dimension: 维度
        :type Dimension: str
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _NamespaceId: 命名空间ID
        :type NamespaceId: str
        :param _ServiceId: 微服务ID
        :type ServiceId: str
        :param _CallerServiceName: 调用方服务名
        :type CallerServiceName: str
        :param _CalleeServiceName: 被调方服务名
        :type CalleeServiceName: str
        :param _CallerInterfaceName: 调用方接口名
        :type CallerInterfaceName: str
        :param _CalleeInterfaceName: 被调方接口名
        :type CalleeInterfaceName: str
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        :param _GroupId: 部署组ID
        :type GroupId: str
        :param _InstanceId: 实例ID
        :type InstanceId: str
        """
        self._Dimension = None
        self._StartTime = None
        self._EndTime = None
        self._NamespaceId = None
        self._ServiceId = None
        self._CallerServiceName = None
        self._CalleeServiceName = None
        self._CallerInterfaceName = None
        self._CalleeInterfaceName = None
        self._ApplicationId = None
        self._GroupId = None
        self._InstanceId = None

    @property
    def Dimension(self):
        """维度
        :rtype: str
        """
        return self._Dimension

    @Dimension.setter
    def Dimension(self, Dimension):
        self._Dimension = Dimension

    @property
    def StartTime(self):
        """开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def NamespaceId(self):
        """命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def ServiceId(self):
        """微服务ID
        :rtype: str
        """
        return self._ServiceId

    @ServiceId.setter
    def ServiceId(self, ServiceId):
        self._ServiceId = ServiceId

    @property
    def CallerServiceName(self):
        """调用方服务名
        :rtype: str
        """
        return self._CallerServiceName

    @CallerServiceName.setter
    def CallerServiceName(self, CallerServiceName):
        self._CallerServiceName = CallerServiceName

    @property
    def CalleeServiceName(self):
        """被调方服务名
        :rtype: str
        """
        return self._CalleeServiceName

    @CalleeServiceName.setter
    def CalleeServiceName(self, CalleeServiceName):
        self._CalleeServiceName = CalleeServiceName

    @property
    def CallerInterfaceName(self):
        """调用方接口名
        :rtype: str
        """
        return self._CallerInterfaceName

    @CallerInterfaceName.setter
    def CallerInterfaceName(self, CallerInterfaceName):
        self._CallerInterfaceName = CallerInterfaceName

    @property
    def CalleeInterfaceName(self):
        """被调方接口名
        :rtype: str
        """
        return self._CalleeInterfaceName

    @CalleeInterfaceName.setter
    def CalleeInterfaceName(self, CalleeInterfaceName):
        self._CalleeInterfaceName = CalleeInterfaceName

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def GroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def InstanceId(self):
        """实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._Dimension = params.get("Dimension")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._NamespaceId = params.get("NamespaceId")
        self._ServiceId = params.get("ServiceId")
        self._CallerServiceName = params.get("CallerServiceName")
        self._CalleeServiceName = params.get("CalleeServiceName")
        self._CallerInterfaceName = params.get("CallerInterfaceName")
        self._CalleeInterfaceName = params.get("CalleeInterfaceName")
        self._ApplicationId = params.get("ApplicationId")
        self._GroupId = params.get("GroupId")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInovcationIndicatorsResponse(AbstractModel):
    """DescribeInovcationIndicators返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 服务调用监控指标
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.tsf.v20180326.models.InvocationIndicator`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """服务调用监控指标
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.InvocationIndicator`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = InvocationIndicator()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeInstancesRequest(AbstractModel):
    """DescribeInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Limit: 分页个数，默认为20，最大100
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        """过滤条件
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页个数，默认为20，最大100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstancesResponse(AbstractModel):
    """DescribeInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 机器列表信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.InstanceEnrichedInfoPage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """机器列表信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.InstanceEnrichedInfoPage`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = InstanceEnrichedInfoPage()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeInvocationMetricDataCurveRequest(AbstractModel):
    """DescribeInvocationMetricDataCurve请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 查询开始时间
        :type StartTime: str
        :param _EndTime: 查询结束时间
        :type EndTime: str
        :param _Period: 查询时间粒度，单位秒可选值：60、3600、86400
        :type Period: int
        :param _MetricDimensions: 查询指标维度，不能为空，支持 ServiceName, OperationName, PeerServiceName, PeerOperationName
        :type MetricDimensions: list of MetricDimension
        :param _Metrics: 查询指标名，不能为空.
        :type Metrics: list of Metric
        :param _Kind: 视图视角。可选值：SERVER, CLIENT。默认为SERVER
        :type Kind: str
        :param _Type: 类型。组件监控使用，可选值：SQL 或者 NoSQL
        :type Type: str
        """
        self._StartTime = None
        self._EndTime = None
        self._Period = None
        self._MetricDimensions = None
        self._Metrics = None
        self._Kind = None
        self._Type = None

    @property
    def StartTime(self):
        """查询开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """查询结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Period(self):
        """查询时间粒度，单位秒可选值：60、3600、86400
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def MetricDimensions(self):
        """查询指标维度，不能为空，支持 ServiceName, OperationName, PeerServiceName, PeerOperationName
        :rtype: list of MetricDimension
        """
        return self._MetricDimensions

    @MetricDimensions.setter
    def MetricDimensions(self, MetricDimensions):
        self._MetricDimensions = MetricDimensions

    @property
    def Metrics(self):
        """查询指标名，不能为空.
        :rtype: list of Metric
        """
        return self._Metrics

    @Metrics.setter
    def Metrics(self, Metrics):
        self._Metrics = Metrics

    @property
    def Kind(self):
        """视图视角。可选值：SERVER, CLIENT。默认为SERVER
        :rtype: str
        """
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def Type(self):
        """类型。组件监控使用，可选值：SQL 或者 NoSQL
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Period = params.get("Period")
        if params.get("MetricDimensions") is not None:
            self._MetricDimensions = []
            for item in params.get("MetricDimensions"):
                obj = MetricDimension()
                obj._deserialize(item)
                self._MetricDimensions.append(obj)
        if params.get("Metrics") is not None:
            self._Metrics = []
            for item in params.get("Metrics"):
                obj = Metric()
                obj._deserialize(item)
                self._Metrics.append(obj)
        self._Kind = params.get("Kind")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInvocationMetricDataCurveResponse(AbstractModel):
    """DescribeInvocationMetricDataCurve返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 指标监控数据曲线集合
        :type Result: list of MetricDataCurve
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """指标监控数据曲线集合
        :rtype: list of MetricDataCurve
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = []
            for item in params.get("Result"):
                obj = MetricDataCurve()
                obj._deserialize(item)
                self._Result.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInvocationMetricDataDimensionRequest(AbstractModel):
    """DescribeInvocationMetricDataDimension请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _Offset: 开始index
        :type Offset: int
        :param _Limit: 分页大小
        :type Limit: int
        :param _DimensionName: 聚合维度
        :type DimensionName: str
        :param _SearchWord: 搜索关键字
        :type SearchWord: str
        :param _MetricDimensionValues: 维度
        :type MetricDimensionValues: list of MetricDimensionValue
        """
        self._StartTime = None
        self._EndTime = None
        self._Offset = None
        self._Limit = None
        self._DimensionName = None
        self._SearchWord = None
        self._MetricDimensionValues = None

    @property
    def StartTime(self):
        """开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Offset(self):
        """开始index
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页大小
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def DimensionName(self):
        """聚合维度
        :rtype: str
        """
        return self._DimensionName

    @DimensionName.setter
    def DimensionName(self, DimensionName):
        self._DimensionName = DimensionName

    @property
    def SearchWord(self):
        """搜索关键字
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def MetricDimensionValues(self):
        """维度
        :rtype: list of MetricDimensionValue
        """
        return self._MetricDimensionValues

    @MetricDimensionValues.setter
    def MetricDimensionValues(self, MetricDimensionValues):
        self._MetricDimensionValues = MetricDimensionValues


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._DimensionName = params.get("DimensionName")
        self._SearchWord = params.get("SearchWord")
        if params.get("MetricDimensionValues") is not None:
            self._MetricDimensionValues = []
            for item in params.get("MetricDimensionValues"):
                obj = MetricDimensionValue()
                obj._deserialize(item)
                self._MetricDimensionValues.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInvocationMetricDataDimensionResponse(AbstractModel):
    """DescribeInvocationMetricDataDimension返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 维度
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageDimension`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """维度
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageDimension`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageDimension()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeInvocationMetricDataPointRequest(AbstractModel):
    """DescribeInvocationMetricDataPoint请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _MetricDimensionValues: 维度，并且 维度 key value 不能为空
        :type MetricDimensionValues: list of MetricDimensionValue
        :param _Metrics: 指标，并且 key, value 不能为空
        :type Metrics: list of Metric
        :param _Kind: 调用视角。可选值：SERVER, CLIENT。默认为SERVER
        :type Kind: str
        """
        self._StartTime = None
        self._EndTime = None
        self._MetricDimensionValues = None
        self._Metrics = None
        self._Kind = None

    @property
    def StartTime(self):
        """开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MetricDimensionValues(self):
        """维度，并且 维度 key value 不能为空
        :rtype: list of MetricDimensionValue
        """
        return self._MetricDimensionValues

    @MetricDimensionValues.setter
    def MetricDimensionValues(self, MetricDimensionValues):
        self._MetricDimensionValues = MetricDimensionValues

    @property
    def Metrics(self):
        """指标，并且 key, value 不能为空
        :rtype: list of Metric
        """
        return self._Metrics

    @Metrics.setter
    def Metrics(self, Metrics):
        self._Metrics = Metrics

    @property
    def Kind(self):
        """调用视角。可选值：SERVER, CLIENT。默认为SERVER
        :rtype: str
        """
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        if params.get("MetricDimensionValues") is not None:
            self._MetricDimensionValues = []
            for item in params.get("MetricDimensionValues"):
                obj = MetricDimensionValue()
                obj._deserialize(item)
                self._MetricDimensionValues.append(obj)
        if params.get("Metrics") is not None:
            self._Metrics = []
            for item in params.get("Metrics"):
                obj = Metric()
                obj._deserialize(item)
                self._Metrics.append(obj)
        self._Kind = params.get("Kind")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInvocationMetricDataPointResponse(AbstractModel):
    """DescribeInvocationMetricDataPoint返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 单值指标列表
        :type Result: list of MetricDataSingleValue
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """单值指标列表
        :rtype: list of MetricDataSingleValue
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = []
            for item in params.get("Result"):
                obj = MetricDataSingleValue()
                obj._deserialize(item)
                self._Result.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInvocationMetricScatterPlotRequest(AbstractModel):
    """DescribeInvocationMetricScatterPlot请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 查询开始时间
        :type StartTime: str
        :param _EndTime: 查询结束时间
        :type EndTime: str
        :param _Period: 查询时间粒度，单位秒。可选值：60、3600、86400。
        :type Period: int
        :param _MetricDimensions: 查询指标维度, 不能为空。可选 NamespaceId, GroupId, InstanceId, OperationName, ServiceName, PeerServiceName, PeerOperationName
        :type MetricDimensions: list of MetricDimension
        :param _Metrics: 查询指标名， 不能为空。仅支持 range_count_duratioin 为 key 下的 sum 方法
        :type Metrics: list of Metric
        :param _Kind: 视图视角。可选值：SERVER, CLIENT。默认为SERVER
        :type Kind: str
        """
        self._StartTime = None
        self._EndTime = None
        self._Period = None
        self._MetricDimensions = None
        self._Metrics = None
        self._Kind = None

    @property
    def StartTime(self):
        """查询开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """查询结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Period(self):
        """查询时间粒度，单位秒。可选值：60、3600、86400。
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def MetricDimensions(self):
        """查询指标维度, 不能为空。可选 NamespaceId, GroupId, InstanceId, OperationName, ServiceName, PeerServiceName, PeerOperationName
        :rtype: list of MetricDimension
        """
        return self._MetricDimensions

    @MetricDimensions.setter
    def MetricDimensions(self, MetricDimensions):
        self._MetricDimensions = MetricDimensions

    @property
    def Metrics(self):
        """查询指标名， 不能为空。仅支持 range_count_duratioin 为 key 下的 sum 方法
        :rtype: list of Metric
        """
        return self._Metrics

    @Metrics.setter
    def Metrics(self, Metrics):
        self._Metrics = Metrics

    @property
    def Kind(self):
        """视图视角。可选值：SERVER, CLIENT。默认为SERVER
        :rtype: str
        """
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Period = params.get("Period")
        if params.get("MetricDimensions") is not None:
            self._MetricDimensions = []
            for item in params.get("MetricDimensions"):
                obj = MetricDimension()
                obj._deserialize(item)
                self._MetricDimensions.append(obj)
        if params.get("Metrics") is not None:
            self._Metrics = []
            for item in params.get("Metrics"):
                obj = Metric()
                obj._deserialize(item)
                self._Metrics.append(obj)
        self._Kind = params.get("Kind")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInvocationMetricScatterPlotResponse(AbstractModel):
    """DescribeInvocationMetricScatterPlot返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 多值时间统计指标
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.tsf.v20180326.models.InvocationMetricScatterPlot`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """多值时间统计指标
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.InvocationMetricScatterPlot`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = InvocationMetricScatterPlot()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeJvmMonitorRequest(AbstractModel):
    """DescribeJvmMonitor请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 查询的实例Id
        :type InstanceId: str
        :param _ApplicationId: 实例所属应用Id
        :type ApplicationId: str
        :param _TimeGranularity: 时间粒度,单位:秒
        :type TimeGranularity: int
        :param _From: 查询数据起始时间格式(yyyy-MM-dd HH:mm:ss)
        :type From: str
        :param _To: 查询数据结束时间格式(yyyy-MM-dd HH:mm:ss)
        :type To: str
        :param _RequiredPictures: 查询的监控图列表,以返回值属性名作为入参
        :type RequiredPictures: list of str
        :param _Tag: 扩展字段
        :type Tag: str
        """
        self._InstanceId = None
        self._ApplicationId = None
        self._TimeGranularity = None
        self._From = None
        self._To = None
        self._RequiredPictures = None
        self._Tag = None

    @property
    def InstanceId(self):
        """查询的实例Id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ApplicationId(self):
        """实例所属应用Id
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def TimeGranularity(self):
        """时间粒度,单位:秒
        :rtype: int
        """
        return self._TimeGranularity

    @TimeGranularity.setter
    def TimeGranularity(self, TimeGranularity):
        self._TimeGranularity = TimeGranularity

    @property
    def From(self):
        """查询数据起始时间格式(yyyy-MM-dd HH:mm:ss)
        :rtype: str
        """
        return self._From

    @From.setter
    def From(self, From):
        self._From = From

    @property
    def To(self):
        """查询数据结束时间格式(yyyy-MM-dd HH:mm:ss)
        :rtype: str
        """
        return self._To

    @To.setter
    def To(self, To):
        self._To = To

    @property
    def RequiredPictures(self):
        """查询的监控图列表,以返回值属性名作为入参
        :rtype: list of str
        """
        return self._RequiredPictures

    @RequiredPictures.setter
    def RequiredPictures(self, RequiredPictures):
        self._RequiredPictures = RequiredPictures

    @property
    def Tag(self):
        """扩展字段
        :rtype: str
        """
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ApplicationId = params.get("ApplicationId")
        self._TimeGranularity = params.get("TimeGranularity")
        self._From = params.get("From")
        self._To = params.get("To")
        self._RequiredPictures = params.get("RequiredPictures")
        self._Tag = params.get("Tag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeJvmMonitorResponse(AbstractModel):
    """DescribeJvmMonitor返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: Java实例jvm监控数据
        :type Result: :class:`tencentcloud.tsf.v20180326.models.JvmMonitorData`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """Java实例jvm监控数据
        :rtype: :class:`tencentcloud.tsf.v20180326.models.JvmMonitorData`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = JvmMonitorData()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeLaneRulesRequest(AbstractModel):
    """DescribeLaneRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 每页展示的条数
        :type Limit: int
        :param _Offset: 翻页偏移量
        :type Offset: int
        :param _SearchWord: 搜索关键词
        :type SearchWord: str
        :param _RuleId: 泳道规则ID（用于精确搜索）
        :type RuleId: str
        :param _RuleIdList: 无
        :type RuleIdList: list of str
        """
        self._Limit = None
        self._Offset = None
        self._SearchWord = None
        self._RuleId = None
        self._RuleIdList = None

    @property
    def Limit(self):
        """每页展示的条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """翻页偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def SearchWord(self):
        """搜索关键词
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def RuleId(self):
        """泳道规则ID（用于精确搜索）
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleIdList(self):
        """无
        :rtype: list of str
        """
        return self._RuleIdList

    @RuleIdList.setter
    def RuleIdList(self, RuleIdList):
        self._RuleIdList = RuleIdList


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._SearchWord = params.get("SearchWord")
        self._RuleId = params.get("RuleId")
        self._RuleIdList = params.get("RuleIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLaneRulesResponse(AbstractModel):
    """DescribeLaneRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 泳道规则列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.LaneRules`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """泳道规则列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.LaneRules`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = LaneRules()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeLanesRequest(AbstractModel):
    """DescribeLanes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 每页展示的条数
        :type Limit: int
        :param _Offset: 翻页偏移量
        :type Offset: int
        :param _SearchWord: 搜索关键字
        :type SearchWord: str
        :param _LaneIdList: 无
        :type LaneIdList: list of str
        :param _DisableProgramAuthCheck: 无
        :type DisableProgramAuthCheck: bool
        """
        self._Limit = None
        self._Offset = None
        self._SearchWord = None
        self._LaneIdList = None
        self._DisableProgramAuthCheck = None

    @property
    def Limit(self):
        """每页展示的条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """翻页偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def SearchWord(self):
        """搜索关键字
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def LaneIdList(self):
        """无
        :rtype: list of str
        """
        return self._LaneIdList

    @LaneIdList.setter
    def LaneIdList(self, LaneIdList):
        self._LaneIdList = LaneIdList

    @property
    def DisableProgramAuthCheck(self):
        """无
        :rtype: bool
        """
        return self._DisableProgramAuthCheck

    @DisableProgramAuthCheck.setter
    def DisableProgramAuthCheck(self, DisableProgramAuthCheck):
        self._DisableProgramAuthCheck = DisableProgramAuthCheck


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._SearchWord = params.get("SearchWord")
        self._LaneIdList = params.get("LaneIdList")
        self._DisableProgramAuthCheck = params.get("DisableProgramAuthCheck")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLanesResponse(AbstractModel):
    """DescribeLanes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 泳道列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.LaneInfos`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """泳道列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.LaneInfos`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = LaneInfos()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeMicroserviceRequest(AbstractModel):
    """DescribeMicroservice请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MicroserviceId: 微服务ID
        :type MicroserviceId: str
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 分页个数
        :type Limit: int
        :param _GroupIds: 可选，根据部署组ID进行过滤
        :type GroupIds: list of str
        :param _Filters: 过滤条件。多个 filter 之间是与关系，单个 filter 多个 value 之间是或关系。filter name 取值有：id（实例id）、name（实例名）、lan-ip（内网ip）、node-ip（所在节点ip）
        :type Filters: list of Filter
        """
        self._MicroserviceId = None
        self._Offset = None
        self._Limit = None
        self._GroupIds = None
        self._Filters = None

    @property
    def MicroserviceId(self):
        """微服务ID
        :rtype: str
        """
        return self._MicroserviceId

    @MicroserviceId.setter
    def MicroserviceId(self, MicroserviceId):
        self._MicroserviceId = MicroserviceId

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页个数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def GroupIds(self):
        """可选，根据部署组ID进行过滤
        :rtype: list of str
        """
        return self._GroupIds

    @GroupIds.setter
    def GroupIds(self, GroupIds):
        self._GroupIds = GroupIds

    @property
    def Filters(self):
        """过滤条件。多个 filter 之间是与关系，单个 filter 多个 value 之间是或关系。filter name 取值有：id（实例id）、name（实例名）、lan-ip（内网ip）、node-ip（所在节点ip）
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._MicroserviceId = params.get("MicroserviceId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._GroupIds = params.get("GroupIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMicroserviceResponse(AbstractModel):
    """DescribeMicroservice返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 微服务详情实例列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageMsInstance`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """微服务详情实例列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageMsInstance`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageMsInstance()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeMicroservicesByGroupIdsRequest(AbstractModel):
    """DescribeMicroservicesByGroupIds请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupIds: 部署组ID列表
        :type GroupIds: list of str
        """
        self._GroupIds = None

    @property
    def GroupIds(self):
        """部署组ID列表
        :rtype: list of str
        """
        return self._GroupIds

    @GroupIds.setter
    def GroupIds(self, GroupIds):
        self._GroupIds = GroupIds


    def _deserialize(self, params):
        self._GroupIds = params.get("GroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMicroservicesByGroupIdsResponse(AbstractModel):
    """DescribeMicroservicesByGroupIds返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 微服务信息分页列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageMicroservice`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """微服务信息分页列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageMicroservice`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageMicroservice()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeMicroservicesRequest(AbstractModel):
    """DescribeMicroservices请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NamespaceId: 命名空间ID
        :type NamespaceId: str
        :param _SearchWord: 搜索字段
        :type SearchWord: str
        :param _OrderBy: 排序字段
        :type OrderBy: str
        :param _OrderType: 排序类型
        :type OrderType: int
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 分页个数
        :type Limit: int
        :param _Status: 状态过滤，online、offline、single_online
        :type Status: list of str
        :param _MicroserviceIdList: IdList
        :type MicroserviceIdList: list of str
        :param _MicroserviceNameList: 搜索的服务名列表
        :type MicroserviceNameList: list of str
        :param _ConfigCenterInstanceId: 注册中心实例id
        :type ConfigCenterInstanceId: str
        """
        self._NamespaceId = None
        self._SearchWord = None
        self._OrderBy = None
        self._OrderType = None
        self._Offset = None
        self._Limit = None
        self._Status = None
        self._MicroserviceIdList = None
        self._MicroserviceNameList = None
        self._ConfigCenterInstanceId = None

    @property
    def NamespaceId(self):
        """命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def SearchWord(self):
        """搜索字段
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def OrderBy(self):
        """排序字段
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        """排序类型
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页个数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Status(self):
        """状态过滤，online、offline、single_online
        :rtype: list of str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def MicroserviceIdList(self):
        """IdList
        :rtype: list of str
        """
        return self._MicroserviceIdList

    @MicroserviceIdList.setter
    def MicroserviceIdList(self, MicroserviceIdList):
        self._MicroserviceIdList = MicroserviceIdList

    @property
    def MicroserviceNameList(self):
        """搜索的服务名列表
        :rtype: list of str
        """
        return self._MicroserviceNameList

    @MicroserviceNameList.setter
    def MicroserviceNameList(self, MicroserviceNameList):
        self._MicroserviceNameList = MicroserviceNameList

    @property
    def ConfigCenterInstanceId(self):
        """注册中心实例id
        :rtype: str
        """
        return self._ConfigCenterInstanceId

    @ConfigCenterInstanceId.setter
    def ConfigCenterInstanceId(self, ConfigCenterInstanceId):
        self._ConfigCenterInstanceId = ConfigCenterInstanceId


    def _deserialize(self, params):
        self._NamespaceId = params.get("NamespaceId")
        self._SearchWord = params.get("SearchWord")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Status = params.get("Status")
        self._MicroserviceIdList = params.get("MicroserviceIdList")
        self._MicroserviceNameList = params.get("MicroserviceNameList")
        self._ConfigCenterInstanceId = params.get("ConfigCenterInstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMicroservicesResponse(AbstractModel):
    """DescribeMicroservices返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 微服务分页列表信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageMicroservice`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """微服务分页列表信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageMicroservice`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageMicroservice()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeMsApiListRequest(AbstractModel):
    """DescribeMsApiList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MicroserviceId: 微服务ID
        :type MicroserviceId: str
        :param _SearchWord: 搜索关键字
        :type SearchWord: str
        :param _Limit: 每页的数量
        :type Limit: int
        :param _Offset: 翻页偏移量
        :type Offset: int
        """
        self._MicroserviceId = None
        self._SearchWord = None
        self._Limit = None
        self._Offset = None

    @property
    def MicroserviceId(self):
        """微服务ID
        :rtype: str
        """
        return self._MicroserviceId

    @MicroserviceId.setter
    def MicroserviceId(self, MicroserviceId):
        self._MicroserviceId = MicroserviceId

    @property
    def SearchWord(self):
        """搜索关键字
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def Limit(self):
        """每页的数量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """翻页偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._MicroserviceId = params.get("MicroserviceId")
        self._SearchWord = params.get("SearchWord")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMsApiListResponse(AbstractModel):
    """DescribeMsApiList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 相应结果
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfApiListResponse`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """相应结果
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfApiListResponse`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfApiListResponse()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeOverviewInvocationRequest(AbstractModel):
    """DescribeOverviewInvocation请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NamespaceId: 命名空间ID， 此参数必填
        :type NamespaceId: str
        :param _Type: 监控统计类型，必填，可选值：SumReqAmount、AvgFailureRate、AvgTimeCost，分别对应请求量、请求错误率、平均响应耗时
        :type Type: str
        :param _Period: 监控统计数据粒度，可选值：60、3600、86400，分别对应1分钟、1小时、1天
        :type Period: int
        :param _StartTime: 查询开始时间，默认为当天的 00:00:00
        :type StartTime: str
        :param _EndTime: 查询结束时间，默认为当前时间
        :type EndTime: str
        """
        self._NamespaceId = None
        self._Type = None
        self._Period = None
        self._StartTime = None
        self._EndTime = None

    @property
    def NamespaceId(self):
        """命名空间ID， 此参数必填
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def Type(self):
        """监控统计类型，必填，可选值：SumReqAmount、AvgFailureRate、AvgTimeCost，分别对应请求量、请求错误率、平均响应耗时
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Period(self):
        """监控统计数据粒度，可选值：60、3600、86400，分别对应1分钟、1小时、1天
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def StartTime(self):
        """查询开始时间，默认为当天的 00:00:00
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """查询结束时间，默认为当前时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._NamespaceId = params.get("NamespaceId")
        self._Type = params.get("Type")
        self._Period = params.get("Period")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOverviewInvocationResponse(AbstractModel):
    """DescribeOverviewInvocation返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 监控统计数据列表
        :type Result: list of MetricDataPoint
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """监控统计数据列表
        :rtype: list of MetricDataPoint
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = []
            for item in params.get("Result"):
                obj = MetricDataPoint()
                obj._deserialize(item)
                self._Result.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePathRewriteRequest(AbstractModel):
    """DescribePathRewrite请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PathRewriteId: 路径重写规则ID
        :type PathRewriteId: str
        """
        self._PathRewriteId = None

    @property
    def PathRewriteId(self):
        """路径重写规则ID
        :rtype: str
        """
        return self._PathRewriteId

    @PathRewriteId.setter
    def PathRewriteId(self, PathRewriteId):
        self._PathRewriteId = PathRewriteId


    def _deserialize(self, params):
        self._PathRewriteId = params.get("PathRewriteId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePathRewriteResponse(AbstractModel):
    """DescribePathRewrite返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 路径重写规则对象
        :type Result: :class:`tencentcloud.tsf.v20180326.models.PathRewrite`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """路径重写规则对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.PathRewrite`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = PathRewrite()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribePathRewritesRequest(AbstractModel):
    """DescribePathRewrites请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayGroupId: 网关部署组ID
        :type GatewayGroupId: str
        :param _SearchWord: 根据正则表达式或替换的内容模糊查询
        :type SearchWord: str
        :param _Limit: 每页数量
        :type Limit: int
        :param _Offset: 起始偏移量
        :type Offset: int
        """
        self._GatewayGroupId = None
        self._SearchWord = None
        self._Limit = None
        self._Offset = None

    @property
    def GatewayGroupId(self):
        """网关部署组ID
        :rtype: str
        """
        return self._GatewayGroupId

    @GatewayGroupId.setter
    def GatewayGroupId(self, GatewayGroupId):
        self._GatewayGroupId = GatewayGroupId

    @property
    def SearchWord(self):
        """根据正则表达式或替换的内容模糊查询
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def Limit(self):
        """每页数量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """起始偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._GatewayGroupId = params.get("GatewayGroupId")
        self._SearchWord = params.get("SearchWord")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePathRewritesResponse(AbstractModel):
    """DescribePathRewrites返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 路径重写翻页对象
        :type Result: :class:`tencentcloud.tsf.v20180326.models.PathRewritePage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """路径重写翻页对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.PathRewritePage`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = PathRewritePage()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribePkgsRequest(AbstractModel):
    """DescribePkgs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplicationId: 应用ID（只传入应用ID，返回该应用下所有软件包信息）
        :type ApplicationId: str
        :param _SearchWord: 查询关键字（支持根据包ID，包名，包版本号搜索）
        :type SearchWord: str
        :param _OrderBy: 排序关键字（默认为"UploadTime"：上传时间）
        :type OrderBy: str
        :param _OrderType: 升序：0/降序：1（默认降序）
        :type OrderType: int
        :param _Offset: 查询起始偏移
        :type Offset: int
        :param _Limit: 返回数量限制
        :type Limit: int
        :param _RepositoryType: 程序包仓库类型
        :type RepositoryType: str
        :param _RepositoryId: 程序包仓库id
        :type RepositoryId: str
        :param _PackageTypeList: 程序包类型数组支持（fatjar jar war tar.gz zip）
        :type PackageTypeList: list of str
        """
        self._ApplicationId = None
        self._SearchWord = None
        self._OrderBy = None
        self._OrderType = None
        self._Offset = None
        self._Limit = None
        self._RepositoryType = None
        self._RepositoryId = None
        self._PackageTypeList = None

    @property
    def ApplicationId(self):
        """应用ID（只传入应用ID，返回该应用下所有软件包信息）
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def SearchWord(self):
        """查询关键字（支持根据包ID，包名，包版本号搜索）
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def OrderBy(self):
        """排序关键字（默认为"UploadTime"：上传时间）
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        """升序：0/降序：1（默认降序）
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def Offset(self):
        """查询起始偏移
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量限制
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def RepositoryType(self):
        """程序包仓库类型
        :rtype: str
        """
        return self._RepositoryType

    @RepositoryType.setter
    def RepositoryType(self, RepositoryType):
        self._RepositoryType = RepositoryType

    @property
    def RepositoryId(self):
        """程序包仓库id
        :rtype: str
        """
        return self._RepositoryId

    @RepositoryId.setter
    def RepositoryId(self, RepositoryId):
        self._RepositoryId = RepositoryId

    @property
    def PackageTypeList(self):
        """程序包类型数组支持（fatjar jar war tar.gz zip）
        :rtype: list of str
        """
        return self._PackageTypeList

    @PackageTypeList.setter
    def PackageTypeList(self, PackageTypeList):
        self._PackageTypeList = PackageTypeList


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._SearchWord = params.get("SearchWord")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._RepositoryType = params.get("RepositoryType")
        self._RepositoryId = params.get("RepositoryId")
        self._PackageTypeList = params.get("PackageTypeList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePkgsResponse(AbstractModel):
    """DescribePkgs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 符合查询程序包信息列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.PkgList`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """符合查询程序包信息列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.PkgList`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = PkgList()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribePluginInstancesRequest(AbstractModel):
    """DescribePluginInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ScopeValue: 分组或者API的ID
        :type ScopeValue: str
        :param _Offset: 翻页偏移量
        :type Offset: int
        :param _Limit: 每页展示的条数
        :type Limit: int
        :param _Bound: 绑定: true; 未绑定: false
        :type Bound: bool
        :param _Type: 插件类型
        :type Type: str
        :param _SearchWord: 搜索关键字
        :type SearchWord: str
        """
        self._ScopeValue = None
        self._Offset = None
        self._Limit = None
        self._Bound = None
        self._Type = None
        self._SearchWord = None

    @property
    def ScopeValue(self):
        """分组或者API的ID
        :rtype: str
        """
        return self._ScopeValue

    @ScopeValue.setter
    def ScopeValue(self, ScopeValue):
        self._ScopeValue = ScopeValue

    @property
    def Offset(self):
        """翻页偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """每页展示的条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Bound(self):
        """绑定: true; 未绑定: false
        :rtype: bool
        """
        return self._Bound

    @Bound.setter
    def Bound(self, Bound):
        self._Bound = Bound

    @property
    def Type(self):
        """插件类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SearchWord(self):
        """搜索关键字
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord


    def _deserialize(self, params):
        self._ScopeValue = params.get("ScopeValue")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Bound = params.get("Bound")
        self._Type = params.get("Type")
        self._SearchWord = params.get("SearchWord")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePluginInstancesResponse(AbstractModel):
    """DescribePluginInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 插件信息列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageGatewayPlugin`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """插件信息列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageGatewayPlugin`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageGatewayPlugin()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribePodInstancesRequest(AbstractModel):
    """DescribePodInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 实例所属groupId
        :type GroupId: str
        :param _Offset: 偏移量，取值从0开始
        :type Offset: int
        :param _Limit: 分页个数，默认为20， 取值应为1~50
        :type Limit: int
        :param _PodNameList: 过滤字段
        :type PodNameList: list of str
        :param _DeployVersion: 新老版本pod批次标识
        :type DeployVersion: str
        :param _TaskId: 任务ID
        :type TaskId: str
        """
        self._GroupId = None
        self._Offset = None
        self._Limit = None
        self._PodNameList = None
        self._DeployVersion = None
        self._TaskId = None

    @property
    def GroupId(self):
        """实例所属groupId
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def Offset(self):
        """偏移量，取值从0开始
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页个数，默认为20， 取值应为1~50
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PodNameList(self):
        """过滤字段
        :rtype: list of str
        """
        return self._PodNameList

    @PodNameList.setter
    def PodNameList(self, PodNameList):
        self._PodNameList = PodNameList

    @property
    def DeployVersion(self):
        """新老版本pod批次标识
        :rtype: str
        """
        return self._DeployVersion

    @DeployVersion.setter
    def DeployVersion(self, DeployVersion):
        self._DeployVersion = DeployVersion

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PodNameList = params.get("PodNameList")
        self._DeployVersion = params.get("DeployVersion")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePodInstancesResponse(AbstractModel):
    """DescribePodInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 查询的权限数据对象
        :type Result: :class:`tencentcloud.tsf.v20180326.models.GroupPodResult`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """查询的权限数据对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.GroupPodResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = GroupPodResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeProgramsRequest(AbstractModel):
    """DescribePrograms请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchWord: 模糊查询数据集ID，数据集名称，不传入时查询全量
        :type SearchWord: str
        :param _Limit: 每页数量
        :type Limit: int
        :param _Offset: 起始偏移量
        :type Offset: int
        """
        self._SearchWord = None
        self._Limit = None
        self._Offset = None

    @property
    def SearchWord(self):
        """模糊查询数据集ID，数据集名称，不传入时查询全量
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def Limit(self):
        """每页数量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """起始偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._SearchWord = params.get("SearchWord")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProgramsResponse(AbstractModel):
    """DescribePrograms返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 数据集列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.PagedProgram`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """数据集列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.PagedProgram`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = PagedProgram()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribePublicConfigReleaseLogsRequest(AbstractModel):
    """DescribePublicConfigReleaseLogs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NamespaceId: 命名空间ID，不传入时查询全量
        :type NamespaceId: str
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Limit: 每页条数，默认为20
        :type Limit: int
        """
        self._NamespaceId = None
        self._Offset = None
        self._Limit = None

    @property
    def NamespaceId(self):
        """命名空间ID，不传入时查询全量
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def Offset(self):
        """偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """每页条数，默认为20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NamespaceId = params.get("NamespaceId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePublicConfigReleaseLogsResponse(AbstractModel):
    """DescribePublicConfigReleaseLogs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 分页后的公共配置项发布历史列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfigReleaseLog`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """分页后的公共配置项发布历史列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfigReleaseLog`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageConfigReleaseLog()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribePublicConfigReleasesRequest(AbstractModel):
    """DescribePublicConfigReleases请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigName: 配置项名称，不传入时查询全量
        :type ConfigName: str
        :param _NamespaceId: 命名空间ID，不传入时查询全量
        :type NamespaceId: str
        :param _Limit: 每页条数
        :type Limit: int
        :param _Offset: 偏移量
        :type Offset: int
        :param _ConfigId: 配置项ID，不传入时查询全量
        :type ConfigId: str
        """
        self._ConfigName = None
        self._NamespaceId = None
        self._Limit = None
        self._Offset = None
        self._ConfigId = None

    @property
    def ConfigName(self):
        """配置项名称，不传入时查询全量
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def NamespaceId(self):
        """命名空间ID，不传入时查询全量
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def Limit(self):
        """每页条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def ConfigId(self):
        """配置项ID，不传入时查询全量
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId


    def _deserialize(self, params):
        self._ConfigName = params.get("ConfigName")
        self._NamespaceId = params.get("NamespaceId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._ConfigId = params.get("ConfigId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePublicConfigReleasesResponse(AbstractModel):
    """DescribePublicConfigReleases返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 公共配置发布信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfigRelease`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """公共配置发布信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfigRelease`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageConfigRelease()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribePublicConfigRequest(AbstractModel):
    """DescribePublicConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 需要查询的配置项ID
        :type ConfigId: str
        """
        self._ConfigId = None

    @property
    def ConfigId(self):
        """需要查询的配置项ID
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePublicConfigResponse(AbstractModel):
    """DescribePublicConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 全局配置
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.tsf.v20180326.models.Config`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """全局配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.Config`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = Config()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribePublicConfigSummaryRequest(AbstractModel):
    """DescribePublicConfigSummary请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchWord: 查询关键字，模糊查询：配置项名称，不传入时查询全量
        :type SearchWord: str
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Limit: 每页条数，默认为20
        :type Limit: int
        :param _OrderBy: 按时间排序：creation_time；按名称排序：config_name
        :type OrderBy: str
        :param _OrderType: 升序传 0，降序传 1
        :type OrderType: int
        :param _ConfigTagList: 无
        :type ConfigTagList: list of str
        :param _DisableProgramAuthCheck: 无
        :type DisableProgramAuthCheck: bool
        :param _ConfigIdList: 无
        :type ConfigIdList: list of str
        """
        self._SearchWord = None
        self._Offset = None
        self._Limit = None
        self._OrderBy = None
        self._OrderType = None
        self._ConfigTagList = None
        self._DisableProgramAuthCheck = None
        self._ConfigIdList = None

    @property
    def SearchWord(self):
        """查询关键字，模糊查询：配置项名称，不传入时查询全量
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def Offset(self):
        """偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """每页条数，默认为20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderBy(self):
        """按时间排序：creation_time；按名称排序：config_name
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        """升序传 0，降序传 1
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def ConfigTagList(self):
        """无
        :rtype: list of str
        """
        return self._ConfigTagList

    @ConfigTagList.setter
    def ConfigTagList(self, ConfigTagList):
        self._ConfigTagList = ConfigTagList

    @property
    def DisableProgramAuthCheck(self):
        """无
        :rtype: bool
        """
        return self._DisableProgramAuthCheck

    @DisableProgramAuthCheck.setter
    def DisableProgramAuthCheck(self, DisableProgramAuthCheck):
        self._DisableProgramAuthCheck = DisableProgramAuthCheck

    @property
    def ConfigIdList(self):
        """无
        :rtype: list of str
        """
        return self._ConfigIdList

    @ConfigIdList.setter
    def ConfigIdList(self, ConfigIdList):
        self._ConfigIdList = ConfigIdList


    def _deserialize(self, params):
        self._SearchWord = params.get("SearchWord")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        self._ConfigTagList = params.get("ConfigTagList")
        self._DisableProgramAuthCheck = params.get("DisableProgramAuthCheck")
        self._ConfigIdList = params.get("ConfigIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePublicConfigSummaryResponse(AbstractModel):
    """DescribePublicConfigSummary返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 分页的全局配置统计信息列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfig`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """分页的全局配置统计信息列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfig`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageConfig()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribePublicConfigsRequest(AbstractModel):
    """DescribePublicConfigs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置项ID，不传入时查询全量，高优先级
        :type ConfigId: str
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Limit: 每页条数，默认为20
        :type Limit: int
        :param _ConfigIdList: 配置项ID列表，不传入时查询全量，低优先级
        :type ConfigIdList: list of str
        :param _ConfigName: 配置项名称，精确查询，不传入时查询全量
        :type ConfigName: str
        :param _ConfigVersion: 配置项版本，精确查询，不传入时查询全量
        :type ConfigVersion: str
        """
        self._ConfigId = None
        self._Offset = None
        self._Limit = None
        self._ConfigIdList = None
        self._ConfigName = None
        self._ConfigVersion = None

    @property
    def ConfigId(self):
        """配置项ID，不传入时查询全量，高优先级
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def Offset(self):
        """偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """每页条数，默认为20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ConfigIdList(self):
        """配置项ID列表，不传入时查询全量，低优先级
        :rtype: list of str
        """
        return self._ConfigIdList

    @ConfigIdList.setter
    def ConfigIdList(self, ConfigIdList):
        self._ConfigIdList = ConfigIdList

    @property
    def ConfigName(self):
        """配置项名称，精确查询，不传入时查询全量
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigVersion(self):
        """配置项版本，精确查询，不传入时查询全量
        :rtype: str
        """
        return self._ConfigVersion

    @ConfigVersion.setter
    def ConfigVersion(self, ConfigVersion):
        self._ConfigVersion = ConfigVersion


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ConfigIdList = params.get("ConfigIdList")
        self._ConfigName = params.get("ConfigName")
        self._ConfigVersion = params.get("ConfigVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePublicConfigsResponse(AbstractModel):
    """DescribePublicConfigs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 分页后的全局配置项列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfig`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """分页后的全局配置项列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageConfig`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageConfig()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeReleasedConfigRequest(AbstractModel):
    """DescribeReleasedConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID
        :type GroupId: str
        """
        self._GroupId = None

    @property
    def GroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReleasedConfigResponse(AbstractModel):
    """DescribeReleasedConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 已发布的配置内容
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """已发布的配置内容
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DescribeRepositoriesRequest(AbstractModel):
    """DescribeRepositories请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchWord: 查询关键字（按照仓库名称搜索）
        :type SearchWord: str
        :param _Offset: 查询起始偏移
        :type Offset: int
        :param _Limit: 返回数量限制
        :type Limit: int
        :param _RepositoryType: 仓库类型（默认仓库：default，私有仓库：private）
        :type RepositoryType: str
        """
        self._SearchWord = None
        self._Offset = None
        self._Limit = None
        self._RepositoryType = None

    @property
    def SearchWord(self):
        """查询关键字（按照仓库名称搜索）
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def Offset(self):
        """查询起始偏移
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量限制
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def RepositoryType(self):
        """仓库类型（默认仓库：default，私有仓库：private）
        :rtype: str
        """
        return self._RepositoryType

    @RepositoryType.setter
    def RepositoryType(self, RepositoryType):
        self._RepositoryType = RepositoryType


    def _deserialize(self, params):
        self._SearchWord = params.get("SearchWord")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._RepositoryType = params.get("RepositoryType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRepositoriesResponse(AbstractModel):
    """DescribeRepositories返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 符合查询仓库信息列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.RepositoryList`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """符合查询仓库信息列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.RepositoryList`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = RepositoryList()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeRepositoryRequest(AbstractModel):
    """DescribeRepository请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RepositoryId: 仓库ID
        :type RepositoryId: str
        """
        self._RepositoryId = None

    @property
    def RepositoryId(self):
        """仓库ID
        :rtype: str
        """
        return self._RepositoryId

    @RepositoryId.setter
    def RepositoryId(self, RepositoryId):
        self._RepositoryId = RepositoryId


    def _deserialize(self, params):
        self._RepositoryId = params.get("RepositoryId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRepositoryResponse(AbstractModel):
    """DescribeRepository返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 查询的仓库信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.RepositoryInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """查询的仓库信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.RepositoryInfo`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = RepositoryInfo()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeResourceTaskStatusRequest(AbstractModel):
    """DescribeResourceTaskStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResourceTaskStatusResponse(AbstractModel):
    """DescribeResourceTaskStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 资源任务执行状态结果
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ResourceTaskStatusResult`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """资源任务执行状态结果
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ResourceTaskStatusResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ResourceTaskStatusResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeSimpleApplicationsRequest(AbstractModel):
    """DescribeSimpleApplications请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplicationIdList: 应用ID列表
        :type ApplicationIdList: list of str
        :param _ApplicationType: 应用类型
        :type ApplicationType: str
        :param _Limit: 每页条数
        :type Limit: int
        :param _Offset: 起始偏移量
        :type Offset: int
        :param _MicroserviceType: 微服务类型
        :type MicroserviceType: str
        :param _ApplicationResourceTypeList: 资源类型数组
        :type ApplicationResourceTypeList: list of str
        :param _SearchWord: 通过id和name进行关键词过滤
        :type SearchWord: str
        :param _DisableProgramAuthCheck: 无
        :type DisableProgramAuthCheck: bool
        :param _MicroserviceTypeList: 查询指定微服务类型的应用列表
        :type MicroserviceTypeList: list of str
        """
        self._ApplicationIdList = None
        self._ApplicationType = None
        self._Limit = None
        self._Offset = None
        self._MicroserviceType = None
        self._ApplicationResourceTypeList = None
        self._SearchWord = None
        self._DisableProgramAuthCheck = None
        self._MicroserviceTypeList = None

    @property
    def ApplicationIdList(self):
        """应用ID列表
        :rtype: list of str
        """
        return self._ApplicationIdList

    @ApplicationIdList.setter
    def ApplicationIdList(self, ApplicationIdList):
        self._ApplicationIdList = ApplicationIdList

    @property
    def ApplicationType(self):
        """应用类型
        :rtype: str
        """
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType

    @property
    def Limit(self):
        """每页条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """起始偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def MicroserviceType(self):
        """微服务类型
        :rtype: str
        """
        return self._MicroserviceType

    @MicroserviceType.setter
    def MicroserviceType(self, MicroserviceType):
        self._MicroserviceType = MicroserviceType

    @property
    def ApplicationResourceTypeList(self):
        """资源类型数组
        :rtype: list of str
        """
        return self._ApplicationResourceTypeList

    @ApplicationResourceTypeList.setter
    def ApplicationResourceTypeList(self, ApplicationResourceTypeList):
        self._ApplicationResourceTypeList = ApplicationResourceTypeList

    @property
    def SearchWord(self):
        """通过id和name进行关键词过滤
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def DisableProgramAuthCheck(self):
        """无
        :rtype: bool
        """
        return self._DisableProgramAuthCheck

    @DisableProgramAuthCheck.setter
    def DisableProgramAuthCheck(self, DisableProgramAuthCheck):
        self._DisableProgramAuthCheck = DisableProgramAuthCheck

    @property
    def MicroserviceTypeList(self):
        """查询指定微服务类型的应用列表
        :rtype: list of str
        """
        return self._MicroserviceTypeList

    @MicroserviceTypeList.setter
    def MicroserviceTypeList(self, MicroserviceTypeList):
        self._MicroserviceTypeList = MicroserviceTypeList


    def _deserialize(self, params):
        self._ApplicationIdList = params.get("ApplicationIdList")
        self._ApplicationType = params.get("ApplicationType")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._MicroserviceType = params.get("MicroserviceType")
        self._ApplicationResourceTypeList = params.get("ApplicationResourceTypeList")
        self._SearchWord = params.get("SearchWord")
        self._DisableProgramAuthCheck = params.get("DisableProgramAuthCheck")
        self._MicroserviceTypeList = params.get("MicroserviceTypeList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSimpleApplicationsResponse(AbstractModel):
    """DescribeSimpleApplications返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 简单应用分页对象
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageSimpleApplication`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """简单应用分页对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageSimpleApplication`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageSimpleApplication()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeSimpleClustersRequest(AbstractModel):
    """DescribeSimpleClusters请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterIdList: 需要查询的集群ID列表，不填或不传入时查询所有内容
        :type ClusterIdList: list of str
        :param _ClusterType: 需要查询的集群类型，不填或不传入时查询所有内容
        :type ClusterType: str
        :param _Offset: 查询偏移量，默认为0
        :type Offset: int
        :param _Limit: 分页个数，默认为20， 取值应为1~50
        :type Limit: int
        :param _SearchWord: 对id和name进行关键词过滤
        :type SearchWord: str
        :param _DisableProgramAuthCheck: 是否关闭鉴权
        :type DisableProgramAuthCheck: bool
        """
        self._ClusterIdList = None
        self._ClusterType = None
        self._Offset = None
        self._Limit = None
        self._SearchWord = None
        self._DisableProgramAuthCheck = None

    @property
    def ClusterIdList(self):
        """需要查询的集群ID列表，不填或不传入时查询所有内容
        :rtype: list of str
        """
        return self._ClusterIdList

    @ClusterIdList.setter
    def ClusterIdList(self, ClusterIdList):
        self._ClusterIdList = ClusterIdList

    @property
    def ClusterType(self):
        """需要查询的集群类型，不填或不传入时查询所有内容
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def Offset(self):
        """查询偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页个数，默认为20， 取值应为1~50
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchWord(self):
        """对id和name进行关键词过滤
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def DisableProgramAuthCheck(self):
        """是否关闭鉴权
        :rtype: bool
        """
        return self._DisableProgramAuthCheck

    @DisableProgramAuthCheck.setter
    def DisableProgramAuthCheck(self, DisableProgramAuthCheck):
        self._DisableProgramAuthCheck = DisableProgramAuthCheck


    def _deserialize(self, params):
        self._ClusterIdList = params.get("ClusterIdList")
        self._ClusterType = params.get("ClusterType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchWord = params.get("SearchWord")
        self._DisableProgramAuthCheck = params.get("DisableProgramAuthCheck")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSimpleClustersResponse(AbstractModel):
    """DescribeSimpleClusters返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: TSF集群分页对象
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageCluster`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """TSF集群分页对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageCluster`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageCluster()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeSimpleGroupsRequest(AbstractModel):
    """DescribeSimpleGroups请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupIdList: 部署组ID列表，不填写时查询全量
        :type GroupIdList: list of str
        :param _ApplicationId: 应用ID，不填写时查询全量
        :type ApplicationId: str
        :param _ClusterId: 集群ID，不填写时查询全量
        :type ClusterId: str
        :param _NamespaceId: 命名空间ID，不填写时查询全量
        :type NamespaceId: str
        :param _Limit: 每页条数
        :type Limit: int
        :param _Offset: 起始偏移量
        :type Offset: int
        :param _GroupId: 部署组ID，不填写时查询全量
        :type GroupId: str
        :param _SearchWord: 模糊查询，部署组名称，不填写时查询全量
        :type SearchWord: str
        :param _AppMicroServiceType: 部署组类型，精确过滤字段，M：service mesh, P：原生应用， G：网关应用
        :type AppMicroServiceType: str
        """
        self._GroupIdList = None
        self._ApplicationId = None
        self._ClusterId = None
        self._NamespaceId = None
        self._Limit = None
        self._Offset = None
        self._GroupId = None
        self._SearchWord = None
        self._AppMicroServiceType = None

    @property
    def GroupIdList(self):
        """部署组ID列表，不填写时查询全量
        :rtype: list of str
        """
        return self._GroupIdList

    @GroupIdList.setter
    def GroupIdList(self, GroupIdList):
        self._GroupIdList = GroupIdList

    @property
    def ApplicationId(self):
        """应用ID，不填写时查询全量
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ClusterId(self):
        """集群ID，不填写时查询全量
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        """命名空间ID，不填写时查询全量
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def Limit(self):
        """每页条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """起始偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def GroupId(self):
        """部署组ID，不填写时查询全量
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def SearchWord(self):
        """模糊查询，部署组名称，不填写时查询全量
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def AppMicroServiceType(self):
        """部署组类型，精确过滤字段，M：service mesh, P：原生应用， G：网关应用
        :rtype: str
        """
        return self._AppMicroServiceType

    @AppMicroServiceType.setter
    def AppMicroServiceType(self, AppMicroServiceType):
        self._AppMicroServiceType = AppMicroServiceType


    def _deserialize(self, params):
        self._GroupIdList = params.get("GroupIdList")
        self._ApplicationId = params.get("ApplicationId")
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._GroupId = params.get("GroupId")
        self._SearchWord = params.get("SearchWord")
        self._AppMicroServiceType = params.get("AppMicroServiceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSimpleGroupsResponse(AbstractModel):
    """DescribeSimpleGroups返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 简单部署组列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageSimpleGroup`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """简单部署组列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageSimpleGroup`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageSimpleGroup()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeSimpleNamespacesRequest(AbstractModel):
    """DescribeSimpleNamespaces请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NamespaceIdList: 命名空间ID列表，不传入时查询全量
        :type NamespaceIdList: list of str
        :param _ClusterId: 集群ID，不传入时查询全量
        :type ClusterId: str
        :param _Limit: 每页条数
        :type Limit: int
        :param _Offset: 起始偏移量
        :type Offset: int
        :param _NamespaceId: 命名空间ID，不传入时查询全量
        :type NamespaceId: str
        :param _NamespaceResourceTypeList: 查询资源类型列表
        :type NamespaceResourceTypeList: list of str
        :param _SearchWord: 通过id和name进行过滤
        :type SearchWord: str
        :param _NamespaceTypeList: 查询的命名空间类型列表
        :type NamespaceTypeList: list of str
        :param _NamespaceName: 通过命名空间名精确过滤
        :type NamespaceName: str
        :param _IsDefault: 通过是否是默认命名空间过滤，不传表示拉取全部命名空间。0：默认命名空间。1：非默认命名空间
        :type IsDefault: str
        :param _DisableProgramAuthCheck: 是否关闭鉴权查询
        :type DisableProgramAuthCheck: bool
        """
        self._NamespaceIdList = None
        self._ClusterId = None
        self._Limit = None
        self._Offset = None
        self._NamespaceId = None
        self._NamespaceResourceTypeList = None
        self._SearchWord = None
        self._NamespaceTypeList = None
        self._NamespaceName = None
        self._IsDefault = None
        self._DisableProgramAuthCheck = None

    @property
    def NamespaceIdList(self):
        """命名空间ID列表，不传入时查询全量
        :rtype: list of str
        """
        return self._NamespaceIdList

    @NamespaceIdList.setter
    def NamespaceIdList(self, NamespaceIdList):
        self._NamespaceIdList = NamespaceIdList

    @property
    def ClusterId(self):
        """集群ID，不传入时查询全量
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Limit(self):
        """每页条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """起始偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def NamespaceId(self):
        """命名空间ID，不传入时查询全量
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def NamespaceResourceTypeList(self):
        """查询资源类型列表
        :rtype: list of str
        """
        return self._NamespaceResourceTypeList

    @NamespaceResourceTypeList.setter
    def NamespaceResourceTypeList(self, NamespaceResourceTypeList):
        self._NamespaceResourceTypeList = NamespaceResourceTypeList

    @property
    def SearchWord(self):
        """通过id和name进行过滤
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def NamespaceTypeList(self):
        """查询的命名空间类型列表
        :rtype: list of str
        """
        return self._NamespaceTypeList

    @NamespaceTypeList.setter
    def NamespaceTypeList(self, NamespaceTypeList):
        self._NamespaceTypeList = NamespaceTypeList

    @property
    def NamespaceName(self):
        """通过命名空间名精确过滤
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def IsDefault(self):
        """通过是否是默认命名空间过滤，不传表示拉取全部命名空间。0：默认命名空间。1：非默认命名空间
        :rtype: str
        """
        return self._IsDefault

    @IsDefault.setter
    def IsDefault(self, IsDefault):
        self._IsDefault = IsDefault

    @property
    def DisableProgramAuthCheck(self):
        """是否关闭鉴权查询
        :rtype: bool
        """
        return self._DisableProgramAuthCheck

    @DisableProgramAuthCheck.setter
    def DisableProgramAuthCheck(self, DisableProgramAuthCheck):
        self._DisableProgramAuthCheck = DisableProgramAuthCheck


    def _deserialize(self, params):
        self._NamespaceIdList = params.get("NamespaceIdList")
        self._ClusterId = params.get("ClusterId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._NamespaceId = params.get("NamespaceId")
        self._NamespaceResourceTypeList = params.get("NamespaceResourceTypeList")
        self._SearchWord = params.get("SearchWord")
        self._NamespaceTypeList = params.get("NamespaceTypeList")
        self._NamespaceName = params.get("NamespaceName")
        self._IsDefault = params.get("IsDefault")
        self._DisableProgramAuthCheck = params.get("DisableProgramAuthCheck")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSimpleNamespacesResponse(AbstractModel):
    """DescribeSimpleNamespaces返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 命名空间分页列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageNamespace`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """命名空间分页列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageNamespace`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageNamespace()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeStatisticsRequest(AbstractModel):
    """DescribeStatistics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 类型：Interface、Service、Group、Instance、SQL、NoSQL
        :type Type: str
        :param _TimeStep: 步长，单位s：60、3600、86400
        :type TimeStep: int
        :param _Offset: 偏移量，取值范围大于等于0，默认值为0
        :type Offset: int
        :param _Limit: 单页请求配置数量，取值范围[1, 50]，默认值为10
        :type Limit: int
        :param _NamespaceId: 命名空间Id,此字段，和 NamespaceIdList 或者 MetricDimensionValues 字段包含 namespaceId 维度信息。三者选其一。
        :type NamespaceId: str
        :param _OrderBy: 排序字段:AvgTimeConsuming[默认]、RequestCount、ErrorRate。实例监控还支持 CpuPercent
        :type OrderBy: str
        :param _OrderType: 排序方式：ASC:0、DESC:1
        :type OrderType: int
        :param _EndTime: 开始时间：年月日 时分秒2020-05-12 14:43:12， 不能为空
        :type EndTime: str
        :param _StartTime: 开始时间：年月日 时分秒2020-05-12 14:43:12， 不能为空
        :type StartTime: str
        :param _ServiceName: 服务名称
        :type ServiceName: str
        :param _SearchWord: 搜索关键词
        :type SearchWord: str
        :param _MetricDimensionValues: 维度
        :type MetricDimensionValues: list of MetricDimensionValue
        :param _BucketKey: 聚合关键词
        :type BucketKey: str
        :param _DbName: 数据库
        :type DbName: str
        :param _NamespaceIdList: 命名空间id数组
        :type NamespaceIdList: list of str
        :param _ConfigCenterInstanceId: 独占配置中心的ID
        :type ConfigCenterInstanceId: str
        """
        self._Type = None
        self._TimeStep = None
        self._Offset = None
        self._Limit = None
        self._NamespaceId = None
        self._OrderBy = None
        self._OrderType = None
        self._EndTime = None
        self._StartTime = None
        self._ServiceName = None
        self._SearchWord = None
        self._MetricDimensionValues = None
        self._BucketKey = None
        self._DbName = None
        self._NamespaceIdList = None
        self._ConfigCenterInstanceId = None

    @property
    def Type(self):
        """类型：Interface、Service、Group、Instance、SQL、NoSQL
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TimeStep(self):
        """步长，单位s：60、3600、86400
        :rtype: int
        """
        return self._TimeStep

    @TimeStep.setter
    def TimeStep(self, TimeStep):
        self._TimeStep = TimeStep

    @property
    def Offset(self):
        """偏移量，取值范围大于等于0，默认值为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """单页请求配置数量，取值范围[1, 50]，默认值为10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def NamespaceId(self):
        """命名空间Id,此字段，和 NamespaceIdList 或者 MetricDimensionValues 字段包含 namespaceId 维度信息。三者选其一。
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def OrderBy(self):
        """排序字段:AvgTimeConsuming[默认]、RequestCount、ErrorRate。实例监控还支持 CpuPercent
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        """排序方式：ASC:0、DESC:1
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def EndTime(self):
        """开始时间：年月日 时分秒2020-05-12 14:43:12， 不能为空
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StartTime(self):
        """开始时间：年月日 时分秒2020-05-12 14:43:12， 不能为空
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def ServiceName(self):
        """服务名称
        :rtype: str
        """
        return self._ServiceName

    @ServiceName.setter
    def ServiceName(self, ServiceName):
        self._ServiceName = ServiceName

    @property
    def SearchWord(self):
        """搜索关键词
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def MetricDimensionValues(self):
        """维度
        :rtype: list of MetricDimensionValue
        """
        return self._MetricDimensionValues

    @MetricDimensionValues.setter
    def MetricDimensionValues(self, MetricDimensionValues):
        self._MetricDimensionValues = MetricDimensionValues

    @property
    def BucketKey(self):
        """聚合关键词
        :rtype: str
        """
        return self._BucketKey

    @BucketKey.setter
    def BucketKey(self, BucketKey):
        self._BucketKey = BucketKey

    @property
    def DbName(self):
        """数据库
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def NamespaceIdList(self):
        """命名空间id数组
        :rtype: list of str
        """
        return self._NamespaceIdList

    @NamespaceIdList.setter
    def NamespaceIdList(self, NamespaceIdList):
        self._NamespaceIdList = NamespaceIdList

    @property
    def ConfigCenterInstanceId(self):
        """独占配置中心的ID
        :rtype: str
        """
        return self._ConfigCenterInstanceId

    @ConfigCenterInstanceId.setter
    def ConfigCenterInstanceId(self, ConfigCenterInstanceId):
        self._ConfigCenterInstanceId = ConfigCenterInstanceId


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._TimeStep = params.get("TimeStep")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._NamespaceId = params.get("NamespaceId")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        self._EndTime = params.get("EndTime")
        self._StartTime = params.get("StartTime")
        self._ServiceName = params.get("ServiceName")
        self._SearchWord = params.get("SearchWord")
        if params.get("MetricDimensionValues") is not None:
            self._MetricDimensionValues = []
            for item in params.get("MetricDimensionValues"):
                obj = MetricDimensionValue()
                obj._deserialize(item)
                self._MetricDimensionValues.append(obj)
        self._BucketKey = params.get("BucketKey")
        self._DbName = params.get("DbName")
        self._NamespaceIdList = params.get("NamespaceIdList")
        self._ConfigCenterInstanceId = params.get("ConfigCenterInstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStatisticsResponse(AbstractModel):
    """DescribeStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 查询服务统计结果
        :type Result: :class:`tencentcloud.tsf.v20180326.models.ServiceStatisticsResults`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """查询服务统计结果
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ServiceStatisticsResults`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ServiceStatisticsResults()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeTaskDetailRequest(AbstractModel):
    """DescribeTaskDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _TaskLogId: 任务历史ID
        :type TaskLogId: str
        """
        self._TaskId = None
        self._TaskLogId = None

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskLogId(self):
        """任务历史ID
        :rtype: str
        """
        return self._TaskLogId

    @TaskLogId.setter
    def TaskLogId(self, TaskLogId):
        self._TaskLogId = TaskLogId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskLogId = params.get("TaskLogId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskDetailResponse(AbstractModel):
    """DescribeTaskDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 任务详情
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TaskRecord`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """任务详情
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TaskRecord`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TaskRecord()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeTaskLastStatusRequest(AbstractModel):
    """DescribeTaskLastStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskLastStatusResponse(AbstractModel):
    """DescribeTaskLastStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 任务上一次执行状态
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TaskLastExecuteStatus`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """任务上一次执行状态
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TaskLastExecuteStatus`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TaskLastExecuteStatus()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeTaskRecordsRequest(AbstractModel):
    """DescribeTaskRecords请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 翻页偏移量。
        :type Offset: int
        :param _Limit: 翻页查询单页数量。
        :type Limit: int
        :param _SearchWord: 模糊查询关键字，支持任务ID和任务名称。
        :type SearchWord: str
        :param _TaskState: 任务启用状态。enabled/disabled
        :type TaskState: str
        :param _GroupId: 分组ID。
        :type GroupId: str
        :param _TaskType: 任务类型。
        :type TaskType: str
        :param _ExecuteType: 任务触发类型，UNICAST、BROADCAST。
        :type ExecuteType: str
        :param _Ids: 无
        :type Ids: list of str
        """
        self._Offset = None
        self._Limit = None
        self._SearchWord = None
        self._TaskState = None
        self._GroupId = None
        self._TaskType = None
        self._ExecuteType = None
        self._Ids = None

    @property
    def Offset(self):
        """翻页偏移量。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """翻页查询单页数量。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchWord(self):
        """模糊查询关键字，支持任务ID和任务名称。
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def TaskState(self):
        """任务启用状态。enabled/disabled
        :rtype: str
        """
        return self._TaskState

    @TaskState.setter
    def TaskState(self, TaskState):
        self._TaskState = TaskState

    @property
    def GroupId(self):
        """分组ID。
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def TaskType(self):
        """任务类型。
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ExecuteType(self):
        """任务触发类型，UNICAST、BROADCAST。
        :rtype: str
        """
        return self._ExecuteType

    @ExecuteType.setter
    def ExecuteType(self, ExecuteType):
        self._ExecuteType = ExecuteType

    @property
    def Ids(self):
        """无
        :rtype: list of str
        """
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchWord = params.get("SearchWord")
        self._TaskState = params.get("TaskState")
        self._GroupId = params.get("GroupId")
        self._TaskType = params.get("TaskType")
        self._ExecuteType = params.get("ExecuteType")
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskRecordsResponse(AbstractModel):
    """DescribeTaskRecords返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 任务记录列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TaskRecordPage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """任务记录列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TaskRecordPage`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TaskRecordPage()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeUnitApiUseDetailRequest(AbstractModel):
    """DescribeUnitApiUseDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayDeployGroupId: 网关部署组ID
        :type GatewayDeployGroupId: str
        :param _ApiId: 网关分组Api ID
        :type ApiId: str
        :param _StartTime: 查询的日期,格式：yyyy-MM-dd HH:mm:ss
        :type StartTime: str
        :param _EndTime: 查询的日期,格式：yyyy-MM-dd HH:mm:ss
        :type EndTime: str
        :param _GatewayInstanceId: 网关实例ID
        :type GatewayInstanceId: str
        :param _GroupId: 网关分组ID
        :type GroupId: str
        :param _Offset: 翻页查询偏移量
        :type Offset: int
        :param _Limit: 翻页查询每页记录数
        :type Limit: int
        :param _Period: 监控统计数据粒度
        :type Period: int
        """
        self._GatewayDeployGroupId = None
        self._ApiId = None
        self._StartTime = None
        self._EndTime = None
        self._GatewayInstanceId = None
        self._GroupId = None
        self._Offset = None
        self._Limit = None
        self._Period = None

    @property
    def GatewayDeployGroupId(self):
        """网关部署组ID
        :rtype: str
        """
        return self._GatewayDeployGroupId

    @GatewayDeployGroupId.setter
    def GatewayDeployGroupId(self, GatewayDeployGroupId):
        self._GatewayDeployGroupId = GatewayDeployGroupId

    @property
    def ApiId(self):
        """网关分组Api ID
        :rtype: str
        """
        return self._ApiId

    @ApiId.setter
    def ApiId(self, ApiId):
        self._ApiId = ApiId

    @property
    def StartTime(self):
        """查询的日期,格式：yyyy-MM-dd HH:mm:ss
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """查询的日期,格式：yyyy-MM-dd HH:mm:ss
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def GatewayInstanceId(self):
        """网关实例ID
        :rtype: str
        """
        return self._GatewayInstanceId

    @GatewayInstanceId.setter
    def GatewayInstanceId(self, GatewayInstanceId):
        self._GatewayInstanceId = GatewayInstanceId

    @property
    def GroupId(self):
        """网关分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def Offset(self):
        """翻页查询偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """翻页查询每页记录数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Period(self):
        """监控统计数据粒度
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period


    def _deserialize(self, params):
        self._GatewayDeployGroupId = params.get("GatewayDeployGroupId")
        self._ApiId = params.get("ApiId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._GatewayInstanceId = params.get("GatewayInstanceId")
        self._GroupId = params.get("GroupId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Period = params.get("Period")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUnitApiUseDetailResponse(AbstractModel):
    """DescribeUnitApiUseDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 单元化使用统计对象
        :type Result: :class:`tencentcloud.tsf.v20180326.models.GroupUnitApiUseStatistics`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """单元化使用统计对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.GroupUnitApiUseStatistics`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = GroupUnitApiUseStatistics()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeUnitNamespacesRequest(AbstractModel):
    """DescribeUnitNamespaces请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayInstanceId: 网关实体ID
        :type GatewayInstanceId: str
        :param _SearchWord: 根据命名空间名或ID模糊查询
        :type SearchWord: str
        :param _Offset: 翻页查询偏移量
        :type Offset: int
        :param _Limit: 翻页查询每页记录数
        :type Limit: int
        """
        self._GatewayInstanceId = None
        self._SearchWord = None
        self._Offset = None
        self._Limit = None

    @property
    def GatewayInstanceId(self):
        """网关实体ID
        :rtype: str
        """
        return self._GatewayInstanceId

    @GatewayInstanceId.setter
    def GatewayInstanceId(self, GatewayInstanceId):
        self._GatewayInstanceId = GatewayInstanceId

    @property
    def SearchWord(self):
        """根据命名空间名或ID模糊查询
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def Offset(self):
        """翻页查询偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """翻页查询每页记录数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._GatewayInstanceId = params.get("GatewayInstanceId")
        self._SearchWord = params.get("SearchWord")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUnitNamespacesResponse(AbstractModel):
    """DescribeUnitNamespaces返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 单元化命名空间对象列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageUnitNamespace`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """单元化命名空间对象列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageUnitNamespace`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageUnitNamespace()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeUnitRuleRequest(AbstractModel):
    """DescribeUnitRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 单元化规则ID
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """单元化规则ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUnitRuleResponse(AbstractModel):
    """DescribeUnitRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 单元化规则对象
        :type Result: :class:`tencentcloud.tsf.v20180326.models.UnitRule`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """单元化规则对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.UnitRule`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = UnitRule()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeUnitRulesRequest(AbstractModel):
    """DescribeUnitRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayInstanceId: 网关实体ID
        :type GatewayInstanceId: str
        :param _SearchWord: 根据规则名或备注内容模糊查询
        :type SearchWord: str
        :param _Status: 启用状态, disabled: 未发布， enabled: 发布
        :type Status: str
        :param _Offset: 翻页查询偏移量
        :type Offset: int
        :param _Limit: 翻页查询每页记录数
        :type Limit: int
        """
        self._GatewayInstanceId = None
        self._SearchWord = None
        self._Status = None
        self._Offset = None
        self._Limit = None

    @property
    def GatewayInstanceId(self):
        """网关实体ID
        :rtype: str
        """
        return self._GatewayInstanceId

    @GatewayInstanceId.setter
    def GatewayInstanceId(self, GatewayInstanceId):
        self._GatewayInstanceId = GatewayInstanceId

    @property
    def SearchWord(self):
        """根据规则名或备注内容模糊查询
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def Status(self):
        """启用状态, disabled: 未发布， enabled: 发布
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Offset(self):
        """翻页查询偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """翻页查询每页记录数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._GatewayInstanceId = params.get("GatewayInstanceId")
        self._SearchWord = params.get("SearchWord")
        self._Status = params.get("Status")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUnitRulesResponse(AbstractModel):
    """DescribeUnitRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 分页列表信息
        :type Result: list of TsfPageUnitRule
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """分页列表信息
        :rtype: list of TsfPageUnitRule
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = []
            for item in params.get("Result"):
                obj = TsfPageUnitRule()
                obj._deserialize(item)
                self._Result.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUnitRulesV2Request(AbstractModel):
    """DescribeUnitRulesV2请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayInstanceId: 网关实体ID
        :type GatewayInstanceId: str
        :param _SearchWord: 根据规则名或备注内容模糊查询
        :type SearchWord: str
        :param _Status: 启用状态, disabled: 未发布， enabled: 发布
        :type Status: str
        :param _Offset: 翻页查询偏移量
        :type Offset: int
        :param _Limit: 翻页查询每页记录数
        :type Limit: int
        """
        self._GatewayInstanceId = None
        self._SearchWord = None
        self._Status = None
        self._Offset = None
        self._Limit = None

    @property
    def GatewayInstanceId(self):
        """网关实体ID
        :rtype: str
        """
        return self._GatewayInstanceId

    @GatewayInstanceId.setter
    def GatewayInstanceId(self, GatewayInstanceId):
        self._GatewayInstanceId = GatewayInstanceId

    @property
    def SearchWord(self):
        """根据规则名或备注内容模糊查询
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def Status(self):
        """启用状态, disabled: 未发布， enabled: 发布
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Offset(self):
        """翻页查询偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """翻页查询每页记录数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._GatewayInstanceId = params.get("GatewayInstanceId")
        self._SearchWord = params.get("SearchWord")
        self._Status = params.get("Status")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUnitRulesV2Response(AbstractModel):
    """DescribeUnitRulesV2返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 分页列表信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageUnitRuleV2`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """分页列表信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageUnitRuleV2`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageUnitRuleV2()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeUploadInfoRequest(AbstractModel):
    """DescribeUploadInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        :param _PkgName: 程序包名
        :type PkgName: str
        :param _PkgVersion: 程序包版本
        :type PkgVersion: str
        :param _PkgType: 程序包类型
        :type PkgType: str
        :param _PkgDesc: 程序包介绍
        :type PkgDesc: str
        :param _RepositoryType: 程序包仓库类型
        :type RepositoryType: str
        :param _RepositoryId: 程序包仓库id
        :type RepositoryId: str
        """
        self._ApplicationId = None
        self._PkgName = None
        self._PkgVersion = None
        self._PkgType = None
        self._PkgDesc = None
        self._RepositoryType = None
        self._RepositoryId = None

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def PkgName(self):
        """程序包名
        :rtype: str
        """
        return self._PkgName

    @PkgName.setter
    def PkgName(self, PkgName):
        self._PkgName = PkgName

    @property
    def PkgVersion(self):
        """程序包版本
        :rtype: str
        """
        return self._PkgVersion

    @PkgVersion.setter
    def PkgVersion(self, PkgVersion):
        self._PkgVersion = PkgVersion

    @property
    def PkgType(self):
        """程序包类型
        :rtype: str
        """
        return self._PkgType

    @PkgType.setter
    def PkgType(self, PkgType):
        self._PkgType = PkgType

    @property
    def PkgDesc(self):
        """程序包介绍
        :rtype: str
        """
        return self._PkgDesc

    @PkgDesc.setter
    def PkgDesc(self, PkgDesc):
        self._PkgDesc = PkgDesc

    @property
    def RepositoryType(self):
        """程序包仓库类型
        :rtype: str
        """
        return self._RepositoryType

    @RepositoryType.setter
    def RepositoryType(self, RepositoryType):
        self._RepositoryType = RepositoryType

    @property
    def RepositoryId(self):
        """程序包仓库id
        :rtype: str
        """
        return self._RepositoryId

    @RepositoryId.setter
    def RepositoryId(self, RepositoryId):
        self._RepositoryId = RepositoryId


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._PkgName = params.get("PkgName")
        self._PkgVersion = params.get("PkgVersion")
        self._PkgType = params.get("PkgType")
        self._PkgDesc = params.get("PkgDesc")
        self._RepositoryType = params.get("RepositoryType")
        self._RepositoryId = params.get("RepositoryId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUploadInfoResponse(AbstractModel):
    """DescribeUploadInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: COS上传信息
        :type Result: :class:`tencentcloud.tsf.v20180326.models.CosUploadInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """COS上传信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.CosUploadInfo`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = CosUploadInfo()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DescribeUsableUnitNamespacesRequest(AbstractModel):
    """DescribeUsableUnitNamespaces请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchWord: 根据命名空间名或ID模糊查询
        :type SearchWord: str
        :param _Offset: 翻页查询偏移量
        :type Offset: int
        :param _Limit: 翻页查询每页记录数
        :type Limit: int
        """
        self._SearchWord = None
        self._Offset = None
        self._Limit = None

    @property
    def SearchWord(self):
        """根据命名空间名或ID模糊查询
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def Offset(self):
        """翻页查询偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """翻页查询每页记录数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SearchWord = params.get("SearchWord")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUsableUnitNamespacesResponse(AbstractModel):
    """DescribeUsableUnitNamespaces返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 单元化命名空间对象列表
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TsfPageUnitNamespace`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """单元化命名空间对象列表
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TsfPageUnitNamespace`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TsfPageUnitNamespace()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DisableLaneRuleRequest(AbstractModel):
    """DisableLaneRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 泳道规则ID
        :type RuleId: str
        """
        self._RuleId = None

    @property
    def RuleId(self):
        """泳道规则ID
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableLaneRuleResponse(AbstractModel):
    """DisableLaneRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 操作状态。成功：true，失败：false
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """操作状态。成功：true，失败：false
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DisableTaskFlowRequest(AbstractModel):
    """DisableTaskFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 工作流 ID
        :type FlowId: str
        """
        self._FlowId = None

    @property
    def FlowId(self):
        """工作流 ID
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableTaskFlowResponse(AbstractModel):
    """DisableTaskFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: true成功，false: 失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """true成功，false: 失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DisableTaskRequest(AbstractModel):
    """DisableTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableTaskResponse(AbstractModel):
    """DisableTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 操作成功 or 失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """操作成功 or 失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DisableUnitRouteRequest(AbstractModel):
    """DisableUnitRoute请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 网关实体ID
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """网关实体ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableUnitRouteResponse(AbstractModel):
    """DisableUnitRoute返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 返回结果，成功失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """返回结果，成功失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DisableUnitRuleRequest(AbstractModel):
    """DisableUnitRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 规则ID
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """规则ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableUnitRuleResponse(AbstractModel):
    """DisableUnitRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 是否成功
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """是否成功
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DisassociateBusinessLogConfigRequest(AbstractModel):
    """DisassociateBusinessLogConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigIdList: 业务日志配置项ID列表
        :type ConfigIdList: list of str
        :param _GroupId: TSF分组ID
        :type GroupId: str
        """
        self._ConfigIdList = None
        self._GroupId = None

    @property
    def ConfigIdList(self):
        """业务日志配置项ID列表
        :rtype: list of str
        """
        return self._ConfigIdList

    @ConfigIdList.setter
    def ConfigIdList(self, ConfigIdList):
        self._ConfigIdList = ConfigIdList

    @property
    def GroupId(self):
        """TSF分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._ConfigIdList = params.get("ConfigIdList")
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateBusinessLogConfigResponse(AbstractModel):
    """DisassociateBusinessLogConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 操作结果
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """操作结果
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DisassociateKafkaConfigRequest(AbstractModel):
    """DisassociateKafkaConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置项id
        :type ConfigId: str
        :param _GroupIds: 部署组id
        :type GroupIds: list of str
        """
        self._ConfigId = None
        self._GroupIds = None

    @property
    def ConfigId(self):
        """配置项id
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def GroupIds(self):
        """部署组id
        :rtype: list of str
        """
        return self._GroupIds

    @GroupIds.setter
    def GroupIds(self, GroupIds):
        self._GroupIds = GroupIds


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        self._GroupIds = params.get("GroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateKafkaConfigResponse(AbstractModel):
    """DisassociateKafkaConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 解除绑定是否成功
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """解除绑定是否成功
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DraftApiGroupRequest(AbstractModel):
    """DraftApiGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: Api 分组ID
        :type GroupId: str
        """
        self._GroupId = None

    @property
    def GroupId(self):
        """Api 分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DraftApiGroupResponse(AbstractModel):
    """DraftApiGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: true: 成功, false: 失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """true: 成功, false: 失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class EmptyDirOption(AbstractModel):
    """空目录选项

    """

    def __init__(self):
        r"""
        :param _EnableMemory: -
        :type EnableMemory: bool
        :param _StorageCapacity: -
        :type StorageCapacity: int
        :param _StorageUnit: -
        :type StorageUnit: str
        :param _SizeLimit: -
        :type SizeLimit: str
        """
        self._EnableMemory = None
        self._StorageCapacity = None
        self._StorageUnit = None
        self._SizeLimit = None

    @property
    def EnableMemory(self):
        """-
        :rtype: bool
        """
        return self._EnableMemory

    @EnableMemory.setter
    def EnableMemory(self, EnableMemory):
        self._EnableMemory = EnableMemory

    @property
    def StorageCapacity(self):
        """-
        :rtype: int
        """
        return self._StorageCapacity

    @StorageCapacity.setter
    def StorageCapacity(self, StorageCapacity):
        self._StorageCapacity = StorageCapacity

    @property
    def StorageUnit(self):
        """-
        :rtype: str
        """
        return self._StorageUnit

    @StorageUnit.setter
    def StorageUnit(self, StorageUnit):
        self._StorageUnit = StorageUnit

    @property
    def SizeLimit(self):
        """-
        :rtype: str
        """
        return self._SizeLimit

    @SizeLimit.setter
    def SizeLimit(self, SizeLimit):
        self._SizeLimit = SizeLimit


    def _deserialize(self, params):
        self._EnableMemory = params.get("EnableMemory")
        self._StorageCapacity = params.get("StorageCapacity")
        self._StorageUnit = params.get("StorageUnit")
        self._SizeLimit = params.get("SizeLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableLaneRuleRequest(AbstractModel):
    """EnableLaneRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 泳道规则ID
        :type RuleId: str
        """
        self._RuleId = None

    @property
    def RuleId(self):
        """泳道规则ID
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableLaneRuleResponse(AbstractModel):
    """EnableLaneRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 操作状态。成功：true，失败：false
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """操作状态。成功：true，失败：false
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class EnableTaskFlowRequest(AbstractModel):
    """EnableTaskFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 工作流 ID
        :type FlowId: str
        """
        self._FlowId = None

    @property
    def FlowId(self):
        """工作流 ID
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableTaskFlowResponse(AbstractModel):
    """EnableTaskFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: true成功，false: 失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """true成功，false: 失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class EnableTaskRequest(AbstractModel):
    """EnableTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 启用任务
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """启用任务
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableTaskResponse(AbstractModel):
    """EnableTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 操作成功or失败
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """操作成功or失败
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class EnableUnitRouteRequest(AbstractModel):
    """EnableUnitRoute请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 网关实体ID
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """网关实体ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableUnitRouteResponse(AbstractModel):
    """EnableUnitRoute返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 返回结果。成功：true，失败：false。
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """返回结果。成功：true，失败：false。
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class EnableUnitRuleRequest(AbstractModel):
    """EnableUnitRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 规则ID
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """规则ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableUnitRuleResponse(AbstractModel):
    """EnableUnitRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 是否成功，成功：true，失败：false。
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """是否成功，成功：true，失败：false。
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class Env(AbstractModel):
    """环境变量

    """

    def __init__(self):
        r"""
        :param _Name: 环境变量名称
        :type Name: str
        :param _Value: 环境变量值
        :type Value: str
        :param _ValueFrom: k8s ValueFrom
注意：此字段可能返回 null，表示取不到有效值。
        :type ValueFrom: :class:`tencentcloud.tsf.v20180326.models.ValueFrom`
        """
        self._Name = None
        self._Value = None
        self._ValueFrom = None

    @property
    def Name(self):
        """环境变量名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Value(self):
        """环境变量值
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def ValueFrom(self):
        """k8s ValueFrom
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ValueFrom`
        """
        return self._ValueFrom

    @ValueFrom.setter
    def ValueFrom(self, ValueFrom):
        self._ValueFrom = ValueFrom


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Value = params.get("Value")
        if params.get("ValueFrom") is not None:
            self._ValueFrom = ValueFrom()
            self._ValueFrom._deserialize(params.get("ValueFrom"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExclusiveInstance(AbstractModel):
    """独占实例

    """

    def __init__(self):
        r"""
        :param _CenterType: 配置中心类型[Registration、Configuration]
        :type CenterType: str
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _InstanceType: 实例类型[Polaris]
        :type InstanceType: str
        :param _InstanceName: 实例名称
        :type InstanceName: str
        :param _RegionId: 实例地域id
        :type RegionId: str
        :param _InstanceNamespaceId: 实例命名空间ID
        :type InstanceNamespaceId: str
        """
        self._CenterType = None
        self._InstanceId = None
        self._InstanceType = None
        self._InstanceName = None
        self._RegionId = None
        self._InstanceNamespaceId = None

    @property
    def CenterType(self):
        """配置中心类型[Registration、Configuration]
        :rtype: str
        """
        return self._CenterType

    @CenterType.setter
    def CenterType(self, CenterType):
        self._CenterType = CenterType

    @property
    def InstanceId(self):
        """实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceType(self):
        """实例类型[Polaris]
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceName(self):
        """实例名称
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def RegionId(self):
        """实例地域id
        :rtype: str
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId

    @property
    def InstanceNamespaceId(self):
        """实例命名空间ID
        :rtype: str
        """
        return self._InstanceNamespaceId

    @InstanceNamespaceId.setter
    def InstanceNamespaceId(self, InstanceNamespaceId):
        self._InstanceNamespaceId = InstanceNamespaceId


    def _deserialize(self, params):
        self._CenterType = params.get("CenterType")
        self._InstanceId = params.get("InstanceId")
        self._InstanceType = params.get("InstanceType")
        self._InstanceName = params.get("InstanceName")
        self._RegionId = params.get("RegionId")
        self._InstanceNamespaceId = params.get("InstanceNamespaceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExecuteTaskFlowRequest(AbstractModel):
    """ExecuteTaskFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 工作流 ID
        :type FlowId: str
        """
        self._FlowId = None

    @property
    def FlowId(self):
        """工作流 ID
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExecuteTaskFlowResponse(AbstractModel):
    """ExecuteTaskFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 工作流批次ID
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """工作流批次ID
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class ExecuteTaskRequest(AbstractModel):
    """ExecuteTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """任务 ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExecuteTaskResponse(AbstractModel):
    """ExecuteTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 成功/失败
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """成功/失败
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class ExpandGroupRequest(AbstractModel):
    """ExpandGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组ID
        :type GroupId: str
        :param _InstanceIdList: 扩容的机器实例ID列表
        :type InstanceIdList: list of str
        """
        self._GroupId = None
        self._InstanceIdList = None

    @property
    def GroupId(self):
        """部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def InstanceIdList(self):
        """扩容的机器实例ID列表
        :rtype: list of str
        """
        return self._InstanceIdList

    @InstanceIdList.setter
    def InstanceIdList(self, InstanceIdList):
        self._InstanceIdList = InstanceIdList


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._InstanceIdList = params.get("InstanceIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExpandGroupResponse(AbstractModel):
    """ExpandGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 任务ID
        :type Result: :class:`tencentcloud.tsf.v20180326.models.TaskId`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """任务ID
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TaskId`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = TaskId()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class FieldRef(AbstractModel):
    """容器 env 的 FieldRef

    """

    def __init__(self):
        r"""
        :param _FieldPath: k8s 的 FieldPath
        :type FieldPath: str
        """
        self._FieldPath = None

    @property
    def FieldPath(self):
        """k8s 的 FieldPath
        :rtype: str
        """
        return self._FieldPath

    @FieldPath.setter
    def FieldPath(self, FieldPath):
        self._FieldPath = FieldPath


    def _deserialize(self, params):
        self._FieldPath = params.get("FieldPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FileConfig(AbstractModel):
    """文件配置项

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置项ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigId: str
        :param _ConfigName: 配置项名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigName: str
        :param _ConfigVersion: 配置项版本
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigVersion: str
        :param _ConfigVersionDesc: 配置项版本描述
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigVersionDesc: str
        :param _ConfigFileName: 配置项文件名
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigFileName: str
        :param _ConfigFileValue: 配置项文件内容
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigFileValue: str
        :param _ConfigFileCode: 配置项文件编码
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigFileCode: str
        :param _CreationTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreationTime: str
        :param _ApplicationId: 配置项归属应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationId: str
        :param _ApplicationName: 应用名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationName: str
        :param _DeleteFlag: 删除标识
注意：此字段可能返回 null，表示取不到有效值。
        :type DeleteFlag: bool
        :param _ConfigVersionCount: 配置项版本数量
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigVersionCount: int
        :param _LastUpdateTime: 配置项最后更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LastUpdateTime: str
        :param _ConfigFilePath: 发布路径
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigFilePath: str
        :param _ConfigPostCmd: 后置命令
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigPostCmd: str
        :param _ConfigFileValueLength: 配置项文件长度
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigFileValueLength: int
        """
        self._ConfigId = None
        self._ConfigName = None
        self._ConfigVersion = None
        self._ConfigVersionDesc = None
        self._ConfigFileName = None
        self._ConfigFileValue = None
        self._ConfigFileCode = None
        self._CreationTime = None
        self._ApplicationId = None
        self._ApplicationName = None
        self._DeleteFlag = None
        self._ConfigVersionCount = None
        self._LastUpdateTime = None
        self._ConfigFilePath = None
        self._ConfigPostCmd = None
        self._ConfigFileValueLength = None

    @property
    def ConfigId(self):
        """配置项ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def ConfigName(self):
        """配置项名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigVersion(self):
        """配置项版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigVersion

    @ConfigVersion.setter
    def ConfigVersion(self, ConfigVersion):
        self._ConfigVersion = ConfigVersion

    @property
    def ConfigVersionDesc(self):
        """配置项版本描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigVersionDesc

    @ConfigVersionDesc.setter
    def ConfigVersionDesc(self, ConfigVersionDesc):
        self._ConfigVersionDesc = ConfigVersionDesc

    @property
    def ConfigFileName(self):
        """配置项文件名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigFileName

    @ConfigFileName.setter
    def ConfigFileName(self, ConfigFileName):
        self._ConfigFileName = ConfigFileName

    @property
    def ConfigFileValue(self):
        """配置项文件内容
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigFileValue

    @ConfigFileValue.setter
    def ConfigFileValue(self, ConfigFileValue):
        self._ConfigFileValue = ConfigFileValue

    @property
    def ConfigFileCode(self):
        """配置项文件编码
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigFileCode

    @ConfigFileCode.setter
    def ConfigFileCode(self, ConfigFileCode):
        self._ConfigFileCode = ConfigFileCode

    @property
    def CreationTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreationTime

    @CreationTime.setter
    def CreationTime(self, CreationTime):
        self._CreationTime = CreationTime

    @property
    def ApplicationId(self):
        """配置项归属应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        """应用名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def DeleteFlag(self):
        """删除标识
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._DeleteFlag

    @DeleteFlag.setter
    def DeleteFlag(self, DeleteFlag):
        self._DeleteFlag = DeleteFlag

    @property
    def ConfigVersionCount(self):
        """配置项版本数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ConfigVersionCount

    @ConfigVersionCount.setter
    def ConfigVersionCount(self, ConfigVersionCount):
        self._ConfigVersionCount = ConfigVersionCount

    @property
    def LastUpdateTime(self):
        """配置项最后更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LastUpdateTime

    @LastUpdateTime.setter
    def LastUpdateTime(self, LastUpdateTime):
        self._LastUpdateTime = LastUpdateTime

    @property
    def ConfigFilePath(self):
        """发布路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigFilePath

    @ConfigFilePath.setter
    def ConfigFilePath(self, ConfigFilePath):
        self._ConfigFilePath = ConfigFilePath

    @property
    def ConfigPostCmd(self):
        """后置命令
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigPostCmd

    @ConfigPostCmd.setter
    def ConfigPostCmd(self, ConfigPostCmd):
        self._ConfigPostCmd = ConfigPostCmd

    @property
    def ConfigFileValueLength(self):
        """配置项文件长度
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ConfigFileValueLength

    @ConfigFileValueLength.setter
    def ConfigFileValueLength(self, ConfigFileValueLength):
        self._ConfigFileValueLength = ConfigFileValueLength


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        self._ConfigName = params.get("ConfigName")
        self._ConfigVersion = params.get("ConfigVersion")
        self._ConfigVersionDesc = params.get("ConfigVersionDesc")
        self._ConfigFileName = params.get("ConfigFileName")
        self._ConfigFileValue = params.get("ConfigFileValue")
        self._ConfigFileCode = params.get("ConfigFileCode")
        self._CreationTime = params.get("CreationTime")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._DeleteFlag = params.get("DeleteFlag")
        self._ConfigVersionCount = params.get("ConfigVersionCount")
        self._LastUpdateTime = params.get("LastUpdateTime")
        self._ConfigFilePath = params.get("ConfigFilePath")
        self._ConfigPostCmd = params.get("ConfigPostCmd")
        self._ConfigFileValueLength = params.get("ConfigFileValueLength")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FileConfigRelease(AbstractModel):
    """文件配置项发布信息

    """

    def __init__(self):
        r"""
        :param _ConfigReleaseId: 配置项发布ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigReleaseId: str
        :param _ConfigId: 配置项ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigId: str
        :param _ConfigName: 配置项名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigName: str
        :param _ConfigVersion: 配置项版本
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigVersion: str
        :param _ReleaseDesc: 发布描述
注意：此字段可能返回 null，表示取不到有效值。
        :type ReleaseDesc: str
        :param _ReleaseTime: 发布时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ReleaseTime: str
        :param _GroupId: 部署组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupId: str
        :param _GroupName: 部署组名称
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupName: str
        :param _NamespaceId: 命名空间ID
注意：此字段可能返回 null，表示取不到有效值。
        :type NamespaceId: str
        :param _NamespaceName: 命名空间名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NamespaceName: str
        :param _ClusterId: 集群ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterId: str
        :param _ClusterName: 集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterName: str
        :param _ConfigCenters: 配置中心发布详情
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigCenters: list of TsfConfigCenter
        """
        self._ConfigReleaseId = None
        self._ConfigId = None
        self._ConfigName = None
        self._ConfigVersion = None
        self._ReleaseDesc = None
        self._ReleaseTime = None
        self._GroupId = None
        self._GroupName = None
        self._NamespaceId = None
        self._NamespaceName = None
        self._ClusterId = None
        self._ClusterName = None
        self._ConfigCenters = None

    @property
    def ConfigReleaseId(self):
        """配置项发布ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigReleaseId

    @ConfigReleaseId.setter
    def ConfigReleaseId(self, ConfigReleaseId):
        self._ConfigReleaseId = ConfigReleaseId

    @property
    def ConfigId(self):
        """配置项ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def ConfigName(self):
        """配置项名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigVersion(self):
        """配置项版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigVersion

    @ConfigVersion.setter
    def ConfigVersion(self, ConfigVersion):
        self._ConfigVersion = ConfigVersion

    @property
    def ReleaseDesc(self):
        """发布描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReleaseDesc

    @ReleaseDesc.setter
    def ReleaseDesc(self, ReleaseDesc):
        self._ReleaseDesc = ReleaseDesc

    @property
    def ReleaseTime(self):
        """发布时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReleaseTime

    @ReleaseTime.setter
    def ReleaseTime(self, ReleaseTime):
        self._ReleaseTime = ReleaseTime

    @property
    def GroupId(self):
        """部署组ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupName(self):
        """部署组名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def NamespaceId(self):
        """命名空间ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def NamespaceName(self):
        """命名空间名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def ClusterId(self):
        """集群ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        """集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ConfigCenters(self):
        """配置中心发布详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TsfConfigCenter
        """
        return self._ConfigCenters

    @ConfigCenters.setter
    def ConfigCenters(self, ConfigCenters):
        self._ConfigCenters = ConfigCenters


    def _deserialize(self, params):
        self._ConfigReleaseId = params.get("ConfigReleaseId")
        self._ConfigId = params.get("ConfigId")
        self._ConfigName = params.get("ConfigName")
        self._ConfigVersion = params.get("ConfigVersion")
        self._ReleaseDesc = params.get("ReleaseDesc")
        self._ReleaseTime = params.get("ReleaseTime")
        self._GroupId = params.get("GroupId")
        self._GroupName = params.get("GroupName")
        self._NamespaceId = params.get("NamespaceId")
        self._NamespaceName = params.get("NamespaceName")
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        if params.get("ConfigCenters") is not None:
            self._ConfigCenters = []
            for item in params.get("ConfigCenters"):
                obj = TsfConfigCenter()
                obj._deserialize(item)
                self._ConfigCenters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Filter(AbstractModel):
    """用于请求参数中的条件过滤字段

    """

    def __init__(self):
        r"""
        :param _Name: 过滤条件名
        :type Name: str
        :param _Values: 过滤条件匹配值，几个条件间是或关系
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        """过滤条件名
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        """过滤条件匹配值，几个条件间是或关系
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ForceSchedule(AbstractModel):
    """强制调度配置

    """

    def __init__(self):
        r"""
        :param _AffinityList: -
        :type AffinityList: list of Affinity
        :param _AntiAffinityList: -
        :type AntiAffinityList: list of Affinity
        """
        self._AffinityList = None
        self._AntiAffinityList = None

    @property
    def AffinityList(self):
        """-
        :rtype: list of Affinity
        """
        return self._AffinityList

    @AffinityList.setter
    def AffinityList(self, AffinityList):
        self._AffinityList = AffinityList

    @property
    def AntiAffinityList(self):
        """-
        :rtype: list of Affinity
        """
        return self._AntiAffinityList

    @AntiAffinityList.setter
    def AntiAffinityList(self, AntiAffinityList):
        self._AntiAffinityList = AntiAffinityList


    def _deserialize(self, params):
        if params.get("AffinityList") is not None:
            self._AffinityList = []
            for item in params.get("AffinityList"):
                obj = Affinity()
                obj._deserialize(item)
                self._AffinityList.append(obj)
        if params.get("AntiAffinityList") is not None:
            self._AntiAffinityList = []
            for item in params.get("AntiAffinityList"):
                obj = Affinity()
                obj._deserialize(item)
                self._AntiAffinityList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GatewayApiGroupVo(AbstractModel):
    """网关分组简单信息

    """

    def __init__(self):
        r"""
        :param _GroupId: 分组ID
        :type GroupId: str
        :param _GroupName: 分组名称
        :type GroupName: str
        :param _GroupApiCount: 分组下API个数
        :type GroupApiCount: int
        :param _GroupApis: 分组API列表
        :type GroupApis: list of GatewayGroupApiVo
        :param _GatewayInstanceType: 网关实例的类型
        :type GatewayInstanceType: str
        :param _GatewayInstanceId: 网关实例ID
        :type GatewayInstanceId: str
        """
        self._GroupId = None
        self._GroupName = None
        self._GroupApiCount = None
        self._GroupApis = None
        self._GatewayInstanceType = None
        self._GatewayInstanceId = None

    @property
    def GroupId(self):
        """分组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupName(self):
        """分组名称
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def GroupApiCount(self):
        """分组下API个数
        :rtype: int
        """
        return self._GroupApiCount

    @GroupApiCount.setter
    def GroupApiCount(self, GroupApiCount):
        self._GroupApiCount = GroupApiCount

    @property
    def GroupApis(self):
        """分组API列表
        :rtype: list of GatewayGroupApiVo
        """
        return self._GroupApis

    @GroupApis.setter
    def GroupApis(self, GroupApis):
        self._GroupApis = GroupApis

    @property
    def GatewayInstanceType(self):
        """网关实例的类型
        :rtype: str
        """
        return self._GatewayInstanceType

    @GatewayInstanceType.setter
    def GatewayInstanceType(self, GatewayInstanceType):
        self._GatewayInstanceType = GatewayInstanceType

    @property
    def GatewayInstanceId(self):
        """网关实例ID
        :rtype: str
        """
        return self._GatewayInstanceId

    @GatewayInstanceId.setter
    def GatewayInstanceId(self, GatewayInstanceId):
        self._GatewayInstanceId = GatewayInstanceId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._GroupName = params.get("GroupName")
        self._GroupApiCount = params.get("GroupApiCount")
        if params.get("GroupApis") is not None:
            self._GroupApis = []
            for item in params.get("GroupApis"):
                obj = GatewayGroupApiVo()
                obj._deserialize(item)
                self._GroupApis.append(obj)
        self._GatewayInstanceType = params.get("GatewayInstanceType")
        self._GatewayInstanceId = params.get("GatewayInstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GatewayConfig(AbstractModel):
    """TSF Envoy网关服务配置

    """

    def __init__(self):
        r"""
        :param _Name: 服务名称
        :type Name: str
        """
        self._Name = None

    @property
    def Name(self):
        """服务名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GatewayDeployGroup(AbstractModel):
    """api分组已绑定的网关部署组

    """

    def __init__(self):
        r"""
        :param _DeployGroupId: 网关部署组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DeployGroupId: str
        :param _DeployGroupName: 网关部署组名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DeployGroupName: str
        :param _ApplicationId: 应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationId: str
        :param _ApplicationName: 应用名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationName: str
        :param _ApplicationType: 应用分类：V：虚拟机应用，C：容器应用
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationType: str
        :param _GroupStatus: 部署组应用状态,取值: Running、Waiting、Paused、Updating、RollingBack、Abnormal、Unknown
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupStatus: str
        :param _ClusterType: 集群类型，C ：容器，V：虚拟机
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterType: str
        """
        self._DeployGroupId = None
        self._DeployGroupName = None
        self._ApplicationId = None
        self._ApplicationName = None
        self._ApplicationType = None
        self._GroupStatus = None
        self._ClusterType = None

    @property
    def DeployGroupId(self):
        """网关部署组ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DeployGroupId

    @DeployGroupId.setter
    def DeployGroupId(self, DeployGroupId):
        self._DeployGroupId = DeployGroupId

    @property
    def DeployGroupName(self):
        """网关部署组名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DeployGroupName

    @DeployGroupName.setter
    def DeployGroupName(self, DeployGroupName):
        self._DeployGroupName = DeployGroupName

    @property
    def ApplicationId(self):
        """应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        """应用名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationType(self):
        """应用分类：V：虚拟机应用，C：容器应用
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType

    @property
    def GroupStatus(self):
        """部署组应用状态,取值: Running、Waiting、Paused、Updating、RollingBack、Abnormal、Unknown
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupStatus

    @GroupStatus.setter
    def GroupStatus(self, GroupStatus):
        self._GroupStatus = GroupStatus

    @property
    def ClusterType(self):
        """集群类型，C ：容器，V：虚拟机
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType


    def _deserialize(self, params):
        self._DeployGroupId = params.get("DeployGroupId")
        self._DeployGroupName = params.get("DeployGroupName")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._ApplicationType = params.get("ApplicationType")
        self._GroupStatus = params.get("GroupStatus")
        self._ClusterType = params.get("ClusterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GatewayGroupApiVo(AbstractModel):
    """网关API简单信息

    """

    def __init__(self):
        r"""
        :param _ApiId: API ID
        :type ApiId: str
        :param _Path: API 请求路径
        :type Path: str
        :param _MicroserviceName: API 微服务名称
        :type MicroserviceName: str
        :param _Method: API 请求方法
注意：此字段可能返回 null，表示取不到有效值。
        :type Method: str
        :param _NamespaceName: 命名空间名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NamespaceName: str
        """
        self._ApiId = None
        self._Path = None
        self._MicroserviceName = None
        self._Method = None
        self._NamespaceName = None

    @property
    def ApiId(self):
        """API ID
        :rtype: str
        """
        return self._ApiId

    @ApiId.setter
    def ApiId(self, ApiId):
        self._ApiId = ApiId

    @property
    def Path(self):
        """API 请求路径
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def MicroserviceName(self):
        """API 微服务名称
        :rtype: str
        """
        return self._MicroserviceName

    @MicroserviceName.setter
    def MicroserviceName(self, MicroserviceName):
        self._MicroserviceName = MicroserviceName

    @property
    def Method(self):
        """API 请求方法
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Method

    @Method.setter
    def Method(self, Method):
        self._Method = Method

    @property
    def NamespaceName(self):
        """命名空间名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName


    def _deserialize(self, params):
        self._ApiId = params.get("ApiId")
        self._Path = params.get("Path")
        self._MicroserviceName = params.get("MicroserviceName")
        self._Method = params.get("Method")
        self._NamespaceName = params.get("NamespaceName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GatewayGroupIds(AbstractModel):
    """网关部署组ID和网关API分组ID元组

    """

    def __init__(self):
        r"""
        :param _GatewayDeployGroupId: 网关部署组ID
        :type GatewayDeployGroupId: str
        :param _GroupId: 分组id
        :type GroupId: str
        """
        self._GatewayDeployGroupId = None
        self._GroupId = None

    @property
    def GatewayDeployGroupId(self):
        """网关部署组ID
        :rtype: str
        """
        return self._GatewayDeployGroupId

    @GatewayDeployGroupId.setter
    def GatewayDeployGroupId(self, GatewayDeployGroupId):
        self._GatewayDeployGroupId = GatewayDeployGroupId

    @property
    def GroupId(self):
        """分组id
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._GatewayDeployGroupId = params.get("GatewayDeployGroupId")
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GatewayPlugin(AbstractModel):
    """微服务网关插件实例对象

    """

    def __init__(self):
        r"""
        :param _Id: 网关插件id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        :param _Name: 插件名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _Type: 插件类型
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _Description: 插件描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _CreatedTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreatedTime: str
        :param _UpdatedTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdatedTime: str
        :param _Status: 发布状态
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        """
        self._Id = None
        self._Name = None
        self._Type = None
        self._Description = None
        self._CreatedTime = None
        self._UpdatedTime = None
        self._Status = None

    @property
    def Id(self):
        """网关插件id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        """插件名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        """插件类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Description(self):
        """插件描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreatedTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def UpdatedTime(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdatedTime

    @UpdatedTime.setter
    def UpdatedTime(self, UpdatedTime):
        self._UpdatedTime = UpdatedTime

    @property
    def Status(self):
        """发布状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Description = params.get("Description")
        self._CreatedTime = params.get("CreatedTime")
        self._UpdatedTime = params.get("UpdatedTime")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GatewayPluginBoundParam(AbstractModel):
    """微服务网关插件绑定对象

    """

    def __init__(self):
        r"""
        :param _PluginId: 插件id
        :type PluginId: str
        :param _ScopeType: 插件绑定到的对象类型:group/api/all
        :type ScopeType: str
        :param _ScopeValue: 插件绑定到的对象主键值，例如分组的ID/API的ID
        :type ScopeValue: str
        :param _MicroserviceId: 创建关联的服务id，关联envoy网关时使用
        :type MicroserviceId: str
        :param _GatewayInstanceId: 网关id
        :type GatewayInstanceId: str
        """
        self._PluginId = None
        self._ScopeType = None
        self._ScopeValue = None
        self._MicroserviceId = None
        self._GatewayInstanceId = None

    @property
    def PluginId(self):
        """插件id
        :rtype: str
        """
        return self._PluginId

    @PluginId.setter
    def PluginId(self, PluginId):
        self._PluginId = PluginId

    @property
    def ScopeType(self):
        """插件绑定到的对象类型:group/api/all
        :rtype: str
        """
        return self._ScopeType

    @ScopeType.setter
    def ScopeType(self, ScopeType):
        self._ScopeType = ScopeType

    @property
    def ScopeValue(self):
        """插件绑定到的对象主键值，例如分组的ID/API的ID
        :rtype: str
        """
        return self._ScopeValue

    @ScopeValue.setter
    def ScopeValue(self, ScopeValue):
        self._ScopeValue = ScopeValue

    @property
    def MicroserviceId(self):
        """创建关联的服务id，关联envoy网关时使用
        :rtype: str
        """
        return self._MicroserviceId

    @MicroserviceId.setter
    def MicroserviceId(self, MicroserviceId):
        self._MicroserviceId = MicroserviceId

    @property
    def GatewayInstanceId(self):
        """网关id
        :rtype: str
        """
        return self._GatewayInstanceId

    @GatewayInstanceId.setter
    def GatewayInstanceId(self, GatewayInstanceId):
        self._GatewayInstanceId = GatewayInstanceId


    def _deserialize(self, params):
        self._PluginId = params.get("PluginId")
        self._ScopeType = params.get("ScopeType")
        self._ScopeValue = params.get("ScopeValue")
        self._MicroserviceId = params.get("MicroserviceId")
        self._GatewayInstanceId = params.get("GatewayInstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GatewayVo(AbstractModel):
    """网关部署组、分组、API列表数据

    """

    def __init__(self):
        r"""
        :param _GatewayDeployGroupId: 网关部署组ID
        :type GatewayDeployGroupId: str
        :param _GatewayDeployGroupName: 网关部署组名称
        :type GatewayDeployGroupName: str
        :param _GroupNum: API 分组个数
        :type GroupNum: int
        :param _Groups: API 分组列表
        :type Groups: list of GatewayApiGroupVo
        """
        self._GatewayDeployGroupId = None
        self._GatewayDeployGroupName = None
        self._GroupNum = None
        self._Groups = None

    @property
    def GatewayDeployGroupId(self):
        """网关部署组ID
        :rtype: str
        """
        return self._GatewayDeployGroupId

    @GatewayDeployGroupId.setter
    def GatewayDeployGroupId(self, GatewayDeployGroupId):
        self._GatewayDeployGroupId = GatewayDeployGroupId

    @property
    def GatewayDeployGroupName(self):
        """网关部署组名称
        :rtype: str
        """
        return self._GatewayDeployGroupName

    @GatewayDeployGroupName.setter
    def GatewayDeployGroupName(self, GatewayDeployGroupName):
        self._GatewayDeployGroupName = GatewayDeployGroupName

    @property
    def GroupNum(self):
        """API 分组个数
        :rtype: int
        """
        return self._GroupNum

    @GroupNum.setter
    def GroupNum(self, GroupNum):
        self._GroupNum = GroupNum

    @property
    def Groups(self):
        """API 分组列表
        :rtype: list of GatewayApiGroupVo
        """
        return self._Groups

    @Groups.setter
    def Groups(self, Groups):
        self._Groups = Groups


    def _deserialize(self, params):
        self._GatewayDeployGroupId = params.get("GatewayDeployGroupId")
        self._GatewayDeployGroupName = params.get("GatewayDeployGroupName")
        self._GroupNum = params.get("GroupNum")
        if params.get("Groups") is not None:
            self._Groups = []
            for item in params.get("Groups"):
                obj = GatewayApiGroupVo()
                obj._deserialize(item)
                self._Groups.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupApiUseStatistics(AbstractModel):
    """API监控明细数据

    """

    def __init__(self):
        r"""
        :param _TopStatusCode: 总调用数
        :type TopStatusCode: list of ApiUseStatisticsEntity
        :param _TopTimeCost: 平均错误率
        :type TopTimeCost: list of ApiUseStatisticsEntity
        :param _Quantile: 分位值对象
        :type Quantile: :class:`tencentcloud.tsf.v20180326.models.QuantileEntity`
        """
        self._TopStatusCode = None
        self._TopTimeCost = None
        self._Quantile = None

    @property
    def TopStatusCode(self):
        """总调用数
        :rtype: list of ApiUseStatisticsEntity
        """
        return self._TopStatusCode

    @TopStatusCode.setter
    def TopStatusCode(self, TopStatusCode):
        self._TopStatusCode = TopStatusCode

    @property
    def TopTimeCost(self):
        """平均错误率
        :rtype: list of ApiUseStatisticsEntity
        """
        return self._TopTimeCost

    @TopTimeCost.setter
    def TopTimeCost(self, TopTimeCost):
        self._TopTimeCost = TopTimeCost

    @property
    def Quantile(self):
        """分位值对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.QuantileEntity`
        """
        return self._Quantile

    @Quantile.setter
    def Quantile(self, Quantile):
        self._Quantile = Quantile


    def _deserialize(self, params):
        if params.get("TopStatusCode") is not None:
            self._TopStatusCode = []
            for item in params.get("TopStatusCode"):
                obj = ApiUseStatisticsEntity()
                obj._deserialize(item)
                self._TopStatusCode.append(obj)
        if params.get("TopTimeCost") is not None:
            self._TopTimeCost = []
            for item in params.get("TopTimeCost"):
                obj = ApiUseStatisticsEntity()
                obj._deserialize(item)
                self._TopTimeCost.append(obj)
        if params.get("Quantile") is not None:
            self._Quantile = QuantileEntity()
            self._Quantile._deserialize(params.get("Quantile"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupContainerInfo(AbstractModel):
    """部署组容器信息

    """

    def __init__(self):
        r"""
        :param _TagName: 镜像版本名称
        :type TagName: str
        :param _ContainerName: 容器名字
        :type ContainerName: str
        :param _RepoName: 镜像名
        :type RepoName: str
        :param _RepoType: 仓库类型,tcr，address，personal，默认personal
        :type RepoType: str
        :param _TcrRepoInfo: tcr仓库信息
        :type TcrRepoInfo: :class:`tencentcloud.tsf.v20180326.models.TcrRepoInfo`
        :param _Server: 镜像server
        :type Server: str
        :param _SecretName: 凭证名字
        :type SecretName: str
        :param _JvmOpts: jvm 参数
        :type JvmOpts: str
        :param _CpuLimit: 容器最大的 CPU 核数，对应 K8S 的 limit
        :type CpuLimit: str
        :param _CpuRequest: 容器分配的 CPU 核数，对应 K8S 的 request
        :type CpuRequest: str
        :param _MemRequest: 容器分配的内存 MiB 数，对应 K8S 的 request
        :type MemRequest: str
        :param _MemLimit: 容器最大的内存 MiB 数，对应 K8S 的 limit
        :type MemLimit: str
        :param _HealthCheckSettings: 健康检查配置信息
        :type HealthCheckSettings: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSettings`
        :param _Envs: 环境变量
        :type Envs: list of Env
        :param _UserEnvs: 环境变量,作为入参时不用填
        :type UserEnvs: list of Env
        :param _VolumeMountInfoList: 数据卷挂载点信息
        :type VolumeMountInfoList: list of VolumeMountInfo
        """
        self._TagName = None
        self._ContainerName = None
        self._RepoName = None
        self._RepoType = None
        self._TcrRepoInfo = None
        self._Server = None
        self._SecretName = None
        self._JvmOpts = None
        self._CpuLimit = None
        self._CpuRequest = None
        self._MemRequest = None
        self._MemLimit = None
        self._HealthCheckSettings = None
        self._Envs = None
        self._UserEnvs = None
        self._VolumeMountInfoList = None

    @property
    def TagName(self):
        """镜像版本名称
        :rtype: str
        """
        return self._TagName

    @TagName.setter
    def TagName(self, TagName):
        self._TagName = TagName

    @property
    def ContainerName(self):
        """容器名字
        :rtype: str
        """
        return self._ContainerName

    @ContainerName.setter
    def ContainerName(self, ContainerName):
        self._ContainerName = ContainerName

    @property
    def RepoName(self):
        """镜像名
        :rtype: str
        """
        return self._RepoName

    @RepoName.setter
    def RepoName(self, RepoName):
        self._RepoName = RepoName

    @property
    def RepoType(self):
        """仓库类型,tcr，address，personal，默认personal
        :rtype: str
        """
        return self._RepoType

    @RepoType.setter
    def RepoType(self, RepoType):
        self._RepoType = RepoType

    @property
    def TcrRepoInfo(self):
        """tcr仓库信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TcrRepoInfo`
        """
        return self._TcrRepoInfo

    @TcrRepoInfo.setter
    def TcrRepoInfo(self, TcrRepoInfo):
        self._TcrRepoInfo = TcrRepoInfo

    @property
    def Server(self):
        """镜像server
        :rtype: str
        """
        return self._Server

    @Server.setter
    def Server(self, Server):
        self._Server = Server

    @property
    def SecretName(self):
        """凭证名字
        :rtype: str
        """
        return self._SecretName

    @SecretName.setter
    def SecretName(self, SecretName):
        self._SecretName = SecretName

    @property
    def JvmOpts(self):
        """jvm 参数
        :rtype: str
        """
        return self._JvmOpts

    @JvmOpts.setter
    def JvmOpts(self, JvmOpts):
        self._JvmOpts = JvmOpts

    @property
    def CpuLimit(self):
        """容器最大的 CPU 核数，对应 K8S 的 limit
        :rtype: str
        """
        return self._CpuLimit

    @CpuLimit.setter
    def CpuLimit(self, CpuLimit):
        self._CpuLimit = CpuLimit

    @property
    def CpuRequest(self):
        """容器分配的 CPU 核数，对应 K8S 的 request
        :rtype: str
        """
        return self._CpuRequest

    @CpuRequest.setter
    def CpuRequest(self, CpuRequest):
        self._CpuRequest = CpuRequest

    @property
    def MemRequest(self):
        """容器分配的内存 MiB 数，对应 K8S 的 request
        :rtype: str
        """
        return self._MemRequest

    @MemRequest.setter
    def MemRequest(self, MemRequest):
        self._MemRequest = MemRequest

    @property
    def MemLimit(self):
        """容器最大的内存 MiB 数，对应 K8S 的 limit
        :rtype: str
        """
        return self._MemLimit

    @MemLimit.setter
    def MemLimit(self, MemLimit):
        self._MemLimit = MemLimit

    @property
    def HealthCheckSettings(self):
        """健康检查配置信息
        :rtype: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSettings`
        """
        return self._HealthCheckSettings

    @HealthCheckSettings.setter
    def HealthCheckSettings(self, HealthCheckSettings):
        self._HealthCheckSettings = HealthCheckSettings

    @property
    def Envs(self):
        """环境变量
        :rtype: list of Env
        """
        return self._Envs

    @Envs.setter
    def Envs(self, Envs):
        self._Envs = Envs

    @property
    def UserEnvs(self):
        """环境变量,作为入参时不用填
        :rtype: list of Env
        """
        return self._UserEnvs

    @UserEnvs.setter
    def UserEnvs(self, UserEnvs):
        self._UserEnvs = UserEnvs

    @property
    def VolumeMountInfoList(self):
        """数据卷挂载点信息
        :rtype: list of VolumeMountInfo
        """
        return self._VolumeMountInfoList

    @VolumeMountInfoList.setter
    def VolumeMountInfoList(self, VolumeMountInfoList):
        self._VolumeMountInfoList = VolumeMountInfoList


    def _deserialize(self, params):
        self._TagName = params.get("TagName")
        self._ContainerName = params.get("ContainerName")
        self._RepoName = params.get("RepoName")
        self._RepoType = params.get("RepoType")
        if params.get("TcrRepoInfo") is not None:
            self._TcrRepoInfo = TcrRepoInfo()
            self._TcrRepoInfo._deserialize(params.get("TcrRepoInfo"))
        self._Server = params.get("Server")
        self._SecretName = params.get("SecretName")
        self._JvmOpts = params.get("JvmOpts")
        self._CpuLimit = params.get("CpuLimit")
        self._CpuRequest = params.get("CpuRequest")
        self._MemRequest = params.get("MemRequest")
        self._MemLimit = params.get("MemLimit")
        if params.get("HealthCheckSettings") is not None:
            self._HealthCheckSettings = HealthCheckSettings()
            self._HealthCheckSettings._deserialize(params.get("HealthCheckSettings"))
        if params.get("Envs") is not None:
            self._Envs = []
            for item in params.get("Envs"):
                obj = Env()
                obj._deserialize(item)
                self._Envs.append(obj)
        if params.get("UserEnvs") is not None:
            self._UserEnvs = []
            for item in params.get("UserEnvs"):
                obj = Env()
                obj._deserialize(item)
                self._UserEnvs.append(obj)
        if params.get("VolumeMountInfoList") is not None:
            self._VolumeMountInfoList = []
            for item in params.get("VolumeMountInfoList"):
                obj = VolumeMountInfo()
                obj._deserialize(item)
                self._VolumeMountInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupDailyUseStatistics(AbstractModel):
    """分组日使用统计对象

    """

    def __init__(self):
        r"""
        :param _TopReqAmount: 总调用数
        :type TopReqAmount: list of GroupUseStatisticsEntity
        :param _TopFailureRate: 平均错误率
        :type TopFailureRate: list of GroupUseStatisticsEntity
        :param _TopAvgTimeCost: 平均响应耗时
        :type TopAvgTimeCost: list of GroupUseStatisticsEntity
        """
        self._TopReqAmount = None
        self._TopFailureRate = None
        self._TopAvgTimeCost = None

    @property
    def TopReqAmount(self):
        """总调用数
        :rtype: list of GroupUseStatisticsEntity
        """
        return self._TopReqAmount

    @TopReqAmount.setter
    def TopReqAmount(self, TopReqAmount):
        self._TopReqAmount = TopReqAmount

    @property
    def TopFailureRate(self):
        """平均错误率
        :rtype: list of GroupUseStatisticsEntity
        """
        return self._TopFailureRate

    @TopFailureRate.setter
    def TopFailureRate(self, TopFailureRate):
        self._TopFailureRate = TopFailureRate

    @property
    def TopAvgTimeCost(self):
        """平均响应耗时
        :rtype: list of GroupUseStatisticsEntity
        """
        return self._TopAvgTimeCost

    @TopAvgTimeCost.setter
    def TopAvgTimeCost(self, TopAvgTimeCost):
        self._TopAvgTimeCost = TopAvgTimeCost


    def _deserialize(self, params):
        if params.get("TopReqAmount") is not None:
            self._TopReqAmount = []
            for item in params.get("TopReqAmount"):
                obj = GroupUseStatisticsEntity()
                obj._deserialize(item)
                self._TopReqAmount.append(obj)
        if params.get("TopFailureRate") is not None:
            self._TopFailureRate = []
            for item in params.get("TopFailureRate"):
                obj = GroupUseStatisticsEntity()
                obj._deserialize(item)
                self._TopFailureRate.append(obj)
        if params.get("TopAvgTimeCost") is not None:
            self._TopAvgTimeCost = []
            for item in params.get("TopAvgTimeCost"):
                obj = GroupUseStatisticsEntity()
                obj._deserialize(item)
                self._TopAvgTimeCost.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupInfo(AbstractModel):
    """日志投递kafka用，描述部署组信息

    """

    def __init__(self):
        r"""
        :param _GroupId: 部署组id
        :type GroupId: str
        :param _GroupName: 部署组名称
        :type GroupName: str
        :param _ClusterType: 集群类型
        :type ClusterType: str
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _NamespaceName: 命名空间名称
        :type NamespaceName: str
        :param _AssociateTime: 绑定时间
        :type AssociateTime: str
        """
        self._GroupId = None
        self._GroupName = None
        self._ClusterType = None
        self._ClusterId = None
        self._ClusterName = None
        self._NamespaceName = None
        self._AssociateTime = None

    @property
    def GroupId(self):
        """部署组id
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupName(self):
        """部署组名称
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def ClusterType(self):
        """集群类型
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def ClusterId(self):
        """集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        """集群名称
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def NamespaceName(self):
        """命名空间名称
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def AssociateTime(self):
        """绑定时间
        :rtype: str
        """
        return self._AssociateTime

    @AssociateTime.setter
    def AssociateTime(self, AssociateTime):
        self._AssociateTime = AssociateTime


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._GroupName = params.get("GroupName")
        self._ClusterType = params.get("ClusterType")
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._NamespaceName = params.get("NamespaceName")
        self._AssociateTime = params.get("AssociateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupPod(AbstractModel):
    """部署组实例列表

    """

    def __init__(self):
        r"""
        :param _PodName: 实例名称(对应到kubernetes的pod名称)
        :type PodName: str
        :param _PodId: 实例ID(对应到kubernetes的pod id)
        :type PodId: str
        :param _Status: 实例状态，请参考后面的实例以及容器的状态定义。启动中（pod 未 ready）：Starting；运行中：Running；异常：Abnormal；停止：Stopped；
        :type Status: str
        :param _Reason: 实例处于当前状态的原因，例如容器下载镜像失败
        :type Reason: str
        :param _NodeIp: 主机IP
        :type NodeIp: str
        :param _Ip: 实例IP
        :type Ip: str
        :param _RestartCount: 实例中容器的重启次数
        :type RestartCount: int
        :param _ReadyCount: 实例中已就绪容器的个数
        :type ReadyCount: int
        :param _Runtime: 运行时长
        :type Runtime: str
        :param _CreatedAt: 实例启动时间
        :type CreatedAt: str
        :param _ServiceInstanceStatus: 服务实例状态
        :type ServiceInstanceStatus: str
        :param _InstanceAvailableStatus: 机器实例可使用状态
        :type InstanceAvailableStatus: str
        :param _InstanceStatus: 机器实例状态
        :type InstanceStatus: str
        :param _NodeInstanceId: 节点实例id
        :type NodeInstanceId: str
        :param _SpecTotalCount: 预期副本数
        :type SpecTotalCount: str
        """
        self._PodName = None
        self._PodId = None
        self._Status = None
        self._Reason = None
        self._NodeIp = None
        self._Ip = None
        self._RestartCount = None
        self._ReadyCount = None
        self._Runtime = None
        self._CreatedAt = None
        self._ServiceInstanceStatus = None
        self._InstanceAvailableStatus = None
        self._InstanceStatus = None
        self._NodeInstanceId = None
        self._SpecTotalCount = None

    @property
    def PodName(self):
        """实例名称(对应到kubernetes的pod名称)
        :rtype: str
        """
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName

    @property
    def PodId(self):
        """实例ID(对应到kubernetes的pod id)
        :rtype: str
        """
        return self._PodId

    @PodId.setter
    def PodId(self, PodId):
        self._PodId = PodId

    @property
    def Status(self):
        """实例状态，请参考后面的实例以及容器的状态定义。启动中（pod 未 ready）：Starting；运行中：Running；异常：Abnormal；停止：Stopped；
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Reason(self):
        """实例处于当前状态的原因，例如容器下载镜像失败
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def NodeIp(self):
        """主机IP
        :rtype: str
        """
        return self._NodeIp

    @NodeIp.setter
    def NodeIp(self, NodeIp):
        self._NodeIp = NodeIp

    @property
    def Ip(self):
        """实例IP
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def RestartCount(self):
        """实例中容器的重启次数
        :rtype: int
        """
        return self._RestartCount

    @RestartCount.setter
    def RestartCount(self, RestartCount):
        self._RestartCount = RestartCount

    @property
    def ReadyCount(self):
        """实例中已就绪容器的个数
        :rtype: int
        """
        return self._ReadyCount

    @ReadyCount.setter
    def ReadyCount(self, ReadyCount):
        self._ReadyCount = ReadyCount

    @property
    def Runtime(self):
        """运行时长
        :rtype: str
        """
        return self._Runtime

    @Runtime.setter
    def Runtime(self, Runtime):
        self._Runtime = Runtime

    @property
    def CreatedAt(self):
        """实例启动时间
        :rtype: str
        """
        return self._CreatedAt

    @CreatedAt.setter
    def CreatedAt(self, CreatedAt):
        self._CreatedAt = CreatedAt

    @property
    def ServiceInstanceStatus(self):
        """服务实例状态
        :rtype: str
        """
        return self._ServiceInstanceStatus

    @ServiceInstanceStatus.setter
    def ServiceInstanceStatus(self, ServiceInstanceStatus):
        self._ServiceInstanceStatus = ServiceInstanceStatus

    @property
    def InstanceAvailableStatus(self):
        """机器实例可使用状态
        :rtype: str
        """
        return self._InstanceAvailableStatus

    @InstanceAvailableStatus.setter
    def InstanceAvailableStatus(self, InstanceAvailableStatus):
        self._InstanceAvailableStatus = InstanceAvailableStatus

    @property
    def InstanceStatus(self):
        """机器实例状态
        :rtype: str
        """
        return self._InstanceStatus

    @InstanceStatus.setter
    def InstanceStatus(self, InstanceStatus):
        self._InstanceStatus = InstanceStatus

    @property
    def NodeInstanceId(self):
        """节点实例id
        :rtype: str
        """
        return self._NodeInstanceId

    @NodeInstanceId.setter
    def NodeInstanceId(self, NodeInstanceId):
        self._NodeInstanceId = NodeInstanceId

    @property
    def SpecTotalCount(self):
        """预期副本数
        :rtype: str
        """
        return self._SpecTotalCount

    @SpecTotalCount.setter
    def SpecTotalCount(self, SpecTotalCount):
        self._SpecTotalCount = SpecTotalCount


    def _deserialize(self, params):
        self._PodName = params.get("PodName")
        self._PodId = params.get("PodId")
        self._Status = params.get("Status")
        self._Reason = params.get("Reason")
        self._NodeIp = params.get("NodeIp")
        self._Ip = params.get("Ip")
        self._RestartCount = params.get("RestartCount")
        self._ReadyCount = params.get("ReadyCount")
        self._Runtime = params.get("Runtime")
        self._CreatedAt = params.get("CreatedAt")
        self._ServiceInstanceStatus = params.get("ServiceInstanceStatus")
        self._InstanceAvailableStatus = params.get("InstanceAvailableStatus")
        self._InstanceStatus = params.get("InstanceStatus")
        self._NodeInstanceId = params.get("NodeInstanceId")
        self._SpecTotalCount = params.get("SpecTotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupPodResult(AbstractModel):
    """部署组实例列表

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _Content: 列表信息
        :type Content: list of GroupPod
        """
        self._TotalCount = None
        self._Content = None

    @property
    def TotalCount(self):
        """总记录数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Content(self):
        """列表信息
        :rtype: list of GroupPod
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Content") is not None:
            self._Content = []
            for item in params.get("Content"):
                obj = GroupPod()
                obj._deserialize(item)
                self._Content.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupRelease(AbstractModel):
    """部署组配置发布相关信息

    """

    def __init__(self):
        r"""
        :param _PackageId: 程序包ID
注意：此字段可能返回 null，表示取不到有效值。
        :type PackageId: str
        :param _PackageName: 程序包名
注意：此字段可能返回 null，表示取不到有效值。
        :type PackageName: str
        :param _PackageVersion: 程序包版本
注意：此字段可能返回 null，表示取不到有效值。
        :type PackageVersion: str
        :param _RepoName: 镜像名
注意：此字段可能返回 null，表示取不到有效值。
        :type RepoName: str
        :param _TagName: 镜像版本
注意：此字段可能返回 null，表示取不到有效值。
        :type TagName: str
        :param _PublicConfigReleaseList: 已发布的全局配置列表
注意：此字段可能返回 null，表示取不到有效值。
        :type PublicConfigReleaseList: list of ConfigRelease
        :param _ConfigReleaseList: 已发布的应用配置列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigReleaseList: list of ConfigRelease
        :param _FileConfigReleaseList: 已发布的文件配置列表
注意：此字段可能返回 null，表示取不到有效值。
        :type FileConfigReleaseList: list of FileConfigRelease
        """
        self._PackageId = None
        self._PackageName = None
        self._PackageVersion = None
        self._RepoName = None
        self._TagName = None
        self._PublicConfigReleaseList = None
        self._ConfigReleaseList = None
        self._FileConfigReleaseList = None

    @property
    def PackageId(self):
        """程序包ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PackageId

    @PackageId.setter
    def PackageId(self, PackageId):
        self._PackageId = PackageId

    @property
    def PackageName(self):
        """程序包名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PackageName

    @PackageName.setter
    def PackageName(self, PackageName):
        self._PackageName = PackageName

    @property
    def PackageVersion(self):
        """程序包版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PackageVersion

    @PackageVersion.setter
    def PackageVersion(self, PackageVersion):
        self._PackageVersion = PackageVersion

    @property
    def RepoName(self):
        """镜像名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RepoName

    @RepoName.setter
    def RepoName(self, RepoName):
        self._RepoName = RepoName

    @property
    def TagName(self):
        """镜像版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TagName

    @TagName.setter
    def TagName(self, TagName):
        self._TagName = TagName

    @property
    def PublicConfigReleaseList(self):
        """已发布的全局配置列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ConfigRelease
        """
        return self._PublicConfigReleaseList

    @PublicConfigReleaseList.setter
    def PublicConfigReleaseList(self, PublicConfigReleaseList):
        self._PublicConfigReleaseList = PublicConfigReleaseList

    @property
    def ConfigReleaseList(self):
        """已发布的应用配置列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ConfigRelease
        """
        return self._ConfigReleaseList

    @ConfigReleaseList.setter
    def ConfigReleaseList(self, ConfigReleaseList):
        self._ConfigReleaseList = ConfigReleaseList

    @property
    def FileConfigReleaseList(self):
        """已发布的文件配置列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of FileConfigRelease
        """
        return self._FileConfigReleaseList

    @FileConfigReleaseList.setter
    def FileConfigReleaseList(self, FileConfigReleaseList):
        self._FileConfigReleaseList = FileConfigReleaseList


    def _deserialize(self, params):
        self._PackageId = params.get("PackageId")
        self._PackageName = params.get("PackageName")
        self._PackageVersion = params.get("PackageVersion")
        self._RepoName = params.get("RepoName")
        self._TagName = params.get("TagName")
        if params.get("PublicConfigReleaseList") is not None:
            self._PublicConfigReleaseList = []
            for item in params.get("PublicConfigReleaseList"):
                obj = ConfigRelease()
                obj._deserialize(item)
                self._PublicConfigReleaseList.append(obj)
        if params.get("ConfigReleaseList") is not None:
            self._ConfigReleaseList = []
            for item in params.get("ConfigReleaseList"):
                obj = ConfigRelease()
                obj._deserialize(item)
                self._ConfigReleaseList.append(obj)
        if params.get("FileConfigReleaseList") is not None:
            self._FileConfigReleaseList = []
            for item in params.get("FileConfigReleaseList"):
                obj = FileConfigRelease()
                obj._deserialize(item)
                self._FileConfigReleaseList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupUnitApiDailyUseStatistics(AbstractModel):
    """单元化API使用详情统计对象列表

    """

    def __init__(self):
        r"""
        :param _NamespaceId: 命名空间ID
        :type NamespaceId: str
        :param _NamespaceName: 命名空间名称
        :type NamespaceName: str
        :param _SumReqAmount: 该API在该命名空间下的总调用次数
        :type SumReqAmount: str
        :param _AvgFailureRate: 该API在该命名空间下的平均错误率
        :type AvgFailureRate: str
        :param _AvgTimeCost: 该API在该命名空间下的平均响应时间
        :type AvgTimeCost: str
        :param _MetricDataPointMap: 监控数据曲线点位图Map集合
        :type MetricDataPointMap: :class:`tencentcloud.tsf.v20180326.models.MetricDataPointMap`
        :param _TopStatusCode: 状态码分布详情
        :type TopStatusCode: list of ApiUseStatisticsEntity
        :param _TopTimeCost: 耗时分布详情
        :type TopTimeCost: list of ApiUseStatisticsEntity
        :param _Quantile: 分位值对象
        :type Quantile: :class:`tencentcloud.tsf.v20180326.models.QuantileEntity`
        """
        self._NamespaceId = None
        self._NamespaceName = None
        self._SumReqAmount = None
        self._AvgFailureRate = None
        self._AvgTimeCost = None
        self._MetricDataPointMap = None
        self._TopStatusCode = None
        self._TopTimeCost = None
        self._Quantile = None

    @property
    def NamespaceId(self):
        """命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def NamespaceName(self):
        """命名空间名称
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def SumReqAmount(self):
        """该API在该命名空间下的总调用次数
        :rtype: str
        """
        return self._SumReqAmount

    @SumReqAmount.setter
    def SumReqAmount(self, SumReqAmount):
        self._SumReqAmount = SumReqAmount

    @property
    def AvgFailureRate(self):
        """该API在该命名空间下的平均错误率
        :rtype: str
        """
        return self._AvgFailureRate

    @AvgFailureRate.setter
    def AvgFailureRate(self, AvgFailureRate):
        self._AvgFailureRate = AvgFailureRate

    @property
    def AvgTimeCost(self):
        """该API在该命名空间下的平均响应时间
        :rtype: str
        """
        return self._AvgTimeCost

    @AvgTimeCost.setter
    def AvgTimeCost(self, AvgTimeCost):
        self._AvgTimeCost = AvgTimeCost

    @property
    def MetricDataPointMap(self):
        """监控数据曲线点位图Map集合
        :rtype: :class:`tencentcloud.tsf.v20180326.models.MetricDataPointMap`
        """
        return self._MetricDataPointMap

    @MetricDataPointMap.setter
    def MetricDataPointMap(self, MetricDataPointMap):
        self._MetricDataPointMap = MetricDataPointMap

    @property
    def TopStatusCode(self):
        """状态码分布详情
        :rtype: list of ApiUseStatisticsEntity
        """
        return self._TopStatusCode

    @TopStatusCode.setter
    def TopStatusCode(self, TopStatusCode):
        self._TopStatusCode = TopStatusCode

    @property
    def TopTimeCost(self):
        """耗时分布详情
        :rtype: list of ApiUseStatisticsEntity
        """
        return self._TopTimeCost

    @TopTimeCost.setter
    def TopTimeCost(self, TopTimeCost):
        self._TopTimeCost = TopTimeCost

    @property
    def Quantile(self):
        """分位值对象
        :rtype: :class:`tencentcloud.tsf.v20180326.models.QuantileEntity`
        """
        return self._Quantile

    @Quantile.setter
    def Quantile(self, Quantile):
        self._Quantile = Quantile


    def _deserialize(self, params):
        self._NamespaceId = params.get("NamespaceId")
        self._NamespaceName = params.get("NamespaceName")
        self._SumReqAmount = params.get("SumReqAmount")
        self._AvgFailureRate = params.get("AvgFailureRate")
        self._AvgTimeCost = params.get("AvgTimeCost")
        if params.get("MetricDataPointMap") is not None:
            self._MetricDataPointMap = MetricDataPointMap()
            self._MetricDataPointMap._deserialize(params.get("MetricDataPointMap"))
        if params.get("TopStatusCode") is not None:
            self._TopStatusCode = []
            for item in params.get("TopStatusCode"):
                obj = ApiUseStatisticsEntity()
                obj._deserialize(item)
                self._TopStatusCode.append(obj)
        if params.get("TopTimeCost") is not None:
            self._TopTimeCost = []
            for item in params.get("TopTimeCost"):
                obj = ApiUseStatisticsEntity()
                obj._deserialize(item)
                self._TopTimeCost.append(obj)
        if params.get("Quantile") is not None:
            self._Quantile = QuantileEntity()
            self._Quantile._deserialize(params.get("Quantile"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupUnitApiUseStatistics(AbstractModel):
    """查询网关API监控明细数据（单元化网关使用详情）

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _Content: 查询网关API监控明细对象集合
        :type Content: list of GroupUnitApiDailyUseStatistics
        """
        self._TotalCount = None
        self._Content = None

    @property
    def TotalCount(self):
        """总记录数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Content(self):
        """查询网关API监控明细对象集合
        :rtype: list of GroupUnitApiDailyUseStatistics
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Content") is not None:
            self._Content = []
            for item in params.get("Content"):
                obj = GroupUnitApiDailyUseStatistics()
                obj._deserialize(item)
                self._Content.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupUseStatisticsEntity(AbstractModel):
    """API分组日使用统计对象数据点

    """

    def __init__(self):
        r"""
        :param _ApiPath: API 路径
        :type ApiPath: str
        :param _ServiceName: 服务名
        :type ServiceName: str
        :param _Value: 统计值
        :type Value: str
        :param _ApiId: API ID
        :type ApiId: str
        """
        self._ApiPath = None
        self._ServiceName = None
        self._Value = None
        self._ApiId = None

    @property
    def ApiPath(self):
        """API 路径
        :rtype: str
        """
        return self._ApiPath

    @ApiPath.setter
    def ApiPath(self, ApiPath):
        self._ApiPath = ApiPath

    @property
    def ServiceName(self):
        """服务名
        :rtype: str
        """
        return self._ServiceName

    @ServiceName.setter
    def ServiceName(self, ServiceName):
        self._ServiceName = ServiceName

    @property
    def Value(self):
        """统计值
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def ApiId(self):
        """API ID
        :rtype: str
        """
        return self._ApiId

    @ApiId.setter
    def ApiId(self, ApiId):
        self._ApiId = ApiId


    def _deserialize(self, params):
        self._ApiPath = params.get("ApiPath")
        self._ServiceName = params.get("ServiceName")
        self._Value = params.get("Value")
        self._ApiId = params.get("ApiId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HealthCheckConfig(AbstractModel):
    """健康检查配置

    """

    def __init__(self):
        r"""
        :param _Path: 健康检查路径
        :type Path: str
        """
        self._Path = None

    @property
    def Path(self):
        """健康检查路径
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path


    def _deserialize(self, params):
        self._Path = params.get("Path")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HealthCheckSetting(AbstractModel):
    """健康检查配置信息，若不指定该参数，则默认不设置健康检查。

    """

    def __init__(self):
        r"""
        :param _ActionType: 健康检查方法。HTTP：通过 HTTP 接口检查；CMD：通过执行命令检查；TCP：通过建立 TCP 连接检查。
注意：此字段可能返回 null，表示取不到有效值。
        :type ActionType: str
        :param _InitialDelaySeconds: 容器延时启动健康检查的时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type InitialDelaySeconds: int
        :param _TimeoutSeconds: 每次健康检查响应的最大超时时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type TimeoutSeconds: int
        :param _PeriodSeconds: 进行健康检查的时间间隔。
注意：此字段可能返回 null，表示取不到有效值。
        :type PeriodSeconds: int
        :param _SuccessThreshold: 表示后端容器从失败到成功的连续健康检查成功次数。
注意：此字段可能返回 null，表示取不到有效值。
        :type SuccessThreshold: int
        :param _FailureThreshold: 表示后端容器从成功到失败的连续健康检查成功次数。
注意：此字段可能返回 null，表示取不到有效值。
        :type FailureThreshold: int
        :param _Scheme: HTTP 健康检查方法使用的检查协议。支持HTTP、HTTPS。
注意：此字段可能返回 null，表示取不到有效值。
        :type Scheme: str
        :param _Port: 健康检查端口，范围 1~65535 。
注意：此字段可能返回 null，表示取不到有效值。
        :type Port: int
        :param _Path: HTTP 健康检查接口的请求路径。
注意：此字段可能返回 null，表示取不到有效值。
        :type Path: str
        :param _Command: 执行命令检查方式，执行的命令。
注意：此字段可能返回 null，表示取不到有效值。
        :type Command: list of str
        :param _Type: TSF_DEFAULT：tsf 默认就绪探针。K8S_NATIVE：k8s 原生探针。不填默认为 k8s 原生探针。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._ActionType = None
        self._InitialDelaySeconds = None
        self._TimeoutSeconds = None
        self._PeriodSeconds = None
        self._SuccessThreshold = None
        self._FailureThreshold = None
        self._Scheme = None
        self._Port = None
        self._Path = None
        self._Command = None
        self._Type = None

    @property
    def ActionType(self):
        """健康检查方法。HTTP：通过 HTTP 接口检查；CMD：通过执行命令检查；TCP：通过建立 TCP 连接检查。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def InitialDelaySeconds(self):
        """容器延时启动健康检查的时间。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._InitialDelaySeconds

    @InitialDelaySeconds.setter
    def InitialDelaySeconds(self, InitialDelaySeconds):
        self._InitialDelaySeconds = InitialDelaySeconds

    @property
    def TimeoutSeconds(self):
        """每次健康检查响应的最大超时时间。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TimeoutSeconds

    @TimeoutSeconds.setter
    def TimeoutSeconds(self, TimeoutSeconds):
        self._TimeoutSeconds = TimeoutSeconds

    @property
    def PeriodSeconds(self):
        """进行健康检查的时间间隔。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PeriodSeconds

    @PeriodSeconds.setter
    def PeriodSeconds(self, PeriodSeconds):
        self._PeriodSeconds = PeriodSeconds

    @property
    def SuccessThreshold(self):
        """表示后端容器从失败到成功的连续健康检查成功次数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._SuccessThreshold

    @SuccessThreshold.setter
    def SuccessThreshold(self, SuccessThreshold):
        self._SuccessThreshold = SuccessThreshold

    @property
    def FailureThreshold(self):
        """表示后端容器从成功到失败的连续健康检查成功次数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._FailureThreshold

    @FailureThreshold.setter
    def FailureThreshold(self, FailureThreshold):
        self._FailureThreshold = FailureThreshold

    @property
    def Scheme(self):
        """HTTP 健康检查方法使用的检查协议。支持HTTP、HTTPS。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Scheme

    @Scheme.setter
    def Scheme(self, Scheme):
        self._Scheme = Scheme

    @property
    def Port(self):
        """健康检查端口，范围 1~65535 。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Path(self):
        """HTTP 健康检查接口的请求路径。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Command(self):
        """执行命令检查方式，执行的命令。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Command

    @Command.setter
    def Command(self, Command):
        self._Command = Command

    @property
    def Type(self):
        """TSF_DEFAULT：tsf 默认就绪探针。K8S_NATIVE：k8s 原生探针。不填默认为 k8s 原生探针。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._ActionType = params.get("ActionType")
        self._InitialDelaySeconds = params.get("InitialDelaySeconds")
        self._TimeoutSeconds = params.get("TimeoutSeconds")
        self._PeriodSeconds = params.get("PeriodSeconds")
        self._SuccessThreshold = params.get("SuccessThreshold")
        self._FailureThreshold = params.get("FailureThreshold")
        self._Scheme = params.get("Scheme")
        self._Port = params.get("Port")
        self._Path = params.get("Path")
        self._Command = params.get("Command")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HealthCheckSettings(AbstractModel):
    """健康检查参数

    """

    def __init__(self):
        r"""
        :param _LivenessProbe: 存活健康检查
注意：此字段可能返回 null，表示取不到有效值。
        :type LivenessProbe: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSetting`
        :param _ReadinessProbe: 就绪健康检查
注意：此字段可能返回 null，表示取不到有效值。
        :type ReadinessProbe: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSetting`
        """
        self._LivenessProbe = None
        self._ReadinessProbe = None

    @property
    def LivenessProbe(self):
        """存活健康检查
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSetting`
        """
        return self._LivenessProbe

    @LivenessProbe.setter
    def LivenessProbe(self, LivenessProbe):
        self._LivenessProbe = LivenessProbe

    @property
    def ReadinessProbe(self):
        """就绪健康检查
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tsf.v20180326.models.HealthCheckSetting`
        """
        return self._ReadinessProbe

    @ReadinessProbe.setter
    def ReadinessProbe(self, ReadinessProbe):
        self._ReadinessProbe = ReadinessProbe


    def _deserialize(self, params):
        if params.get("LivenessProbe") is not None:
            self._LivenessProbe = HealthCheckSetting()
            self._LivenessProbe._deserialize(params.get("LivenessProbe"))
        if params.get("ReadinessProbe") is not None:
            self._ReadinessProbe = HealthCheckSetting()
            self._ReadinessProbe._deserialize(params.get("ReadinessProbe"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageRepository(AbstractModel):
    """镜像仓库

    """

    def __init__(self):
        r"""
        :param _Reponame: 仓库名,含命名空间,如tsf/nginx
        :type Reponame: str
        :param _Repotype: 仓库类型
        :type Repotype: str
        :param _TagCount: 镜像版本数
        :type TagCount: int
        :param _IsPublic: 是否公共,1:公有,0:私有
        :type IsPublic: int
        :param _IsUserFavor: 是否被用户收藏。true：是，false：否
        :type IsUserFavor: bool
        :param _IsQcloudOfficial: 是否是腾讯云官方仓库。 是否是腾讯云官方仓库。true：是，false：否
        :type IsQcloudOfficial: bool
        :param _FavorCount: 被所有用户收藏次数
        :type FavorCount: int
        :param _PullCount: 拉取次数
        :type PullCount: int
        :param _Description: 描述内容
        :type Description: str
        :param _CreationTime: 创建时间
        :type CreationTime: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        :param _TcrRepoInfo: TcrRepoInfo值
        :type TcrRepoInfo: :class:`tencentcloud.tsf.v20180326.models.TcrRepoInfo`
        :param _TcrBindingId: TcrBindingId值
        :type TcrBindingId: int
        :param _ApplicationId: applicationid值
        :type ApplicationId: str
        :param _ApplicationName: ApplicationName值（废弃）
        :type ApplicationName: :class:`tencentcloud.tsf.v20180326.models.ScalableRule`
        :param _ApplicationNameReal: ApplicationName值
        :type ApplicationNameReal: str
        :param _Public: 是否公共,1:公有,0:私有
        :type Public: int
        :param _CreateMode: 创建方式：manual | automatic
        :type CreateMode: str
        :param _RepoName: 仓库名，等同reponame字段
        :type RepoName: str
        :param _RepoType: 仓库类型
        :type RepoType: str
        """
        self._Reponame = None
        self._Repotype = None
        self._TagCount = None
        self._IsPublic = None
        self._IsUserFavor = None
        self._IsQcloudOfficial = None
        self._FavorCount = None
        self._PullCount = None
        self._Description = None
        self._CreationTime = None
        self._UpdateTime = None
        self._TcrRepoInfo = None
        self._TcrBindingId = None
        self._ApplicationId = None
        self._ApplicationName = None
        self._ApplicationNameReal = None
        self._Public = None
        self._CreateMode = None
        self._RepoName = None
        self._RepoType = None

    @property
    def Reponame(self):
        """仓库名,含命名空间,如tsf/nginx
        :rtype: str
        """
        return self._Reponame

    @Reponame.setter
    def Reponame(self, Reponame):
        self._Reponame = Reponame

    @property
    def Repotype(self):
        """仓库类型
        :rtype: str
        """
        return self._Repotype

    @Repotype.setter
    def Repotype(self, Repotype):
        self._Repotype = Repotype

    @property
    def TagCount(self):
        """镜像版本数
        :rtype: int
        """
        return self._TagCount

    @TagCount.setter
    def TagCount(self, TagCount):
        self._TagCount = TagCount

    @property
    def IsPublic(self):
        """是否公共,1:公有,0:私有
        :rtype: int
        """
        return self._IsPublic

    @IsPublic.setter
    def IsPublic(self, IsPublic):
        self._IsPublic = IsPublic

    @property
    def IsUserFavor(self):
        """是否被用户收藏。true：是，false：否
        :rtype: bool
        """
        return self._IsUserFavor

    @IsUserFavor.setter
    def IsUserFavor(self, IsUserFavor):
        self._IsUserFavor = IsUserFavor

    @property
    def IsQcloudOfficial(self):
        """是否是腾讯云官方仓库。 是否是腾讯云官方仓库。true：是，false：否
        :rtype: bool
        """
        return self._IsQcloudOfficial

    @IsQcloudOfficial.setter
    def IsQcloudOfficial(self, IsQcloudOfficial):
        self._IsQcloudOfficial = IsQcloudOfficial

    @property
    def FavorCount(self):
        """被所有用户收藏次数
        :rtype: int
        """
        return self._FavorCount

    @FavorCount.setter
    def FavorCount(self, FavorCount):
        self._FavorCount = FavorCount

    @property
    def PullCount(self):
        """拉取次数
        :rtype: int
        """
        return self._PullCount

    @PullCount.setter
    def PullCount(self, PullCount):
        self._PullCount = PullCount

    @property
    def Description(self):
        """描述内容
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreationTime(self):
        """创建时间
        :rtype: str
        """
        return self._CreationTime

    @CreationTime.setter
    def CreationTime(self, CreationTime):
        self._CreationTime = CreationTime

    @property
    def UpdateTime(self):
        """更新时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def TcrRepoInfo(self):
        """TcrRepoInfo值
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TcrRepoInfo`
        """
        return self._TcrRepoInfo

    @TcrRepoInfo.setter
    def TcrRepoInfo(self, TcrRepoInfo):
        self._TcrRepoInfo = TcrRepoInfo

    @property
    def TcrBindingId(self):
        """TcrBindingId值
        :rtype: int
        """
        return self._TcrBindingId

    @TcrBindingId.setter
    def TcrBindingId(self, TcrBindingId):
        self._TcrBindingId = TcrBindingId

    @property
    def ApplicationId(self):
        """applicationid值
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        """ApplicationName值（废弃）
        :rtype: :class:`tencentcloud.tsf.v20180326.models.ScalableRule`
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationNameReal(self):
        """ApplicationName值
        :rtype: str
        """
        return self._ApplicationNameReal

    @ApplicationNameReal.setter
    def ApplicationNameReal(self, ApplicationNameReal):
        self._ApplicationNameReal = ApplicationNameReal

    @property
    def Public(self):
        """是否公共,1:公有,0:私有
        :rtype: int
        """
        return self._Public

    @Public.setter
    def Public(self, Public):
        self._Public = Public

    @property
    def CreateMode(self):
        """创建方式：manual | automatic
        :rtype: str
        """
        return self._CreateMode

    @CreateMode.setter
    def CreateMode(self, CreateMode):
        self._CreateMode = CreateMode

    @property
    def RepoName(self):
        """仓库名，等同reponame字段
        :rtype: str
        """
        return self._RepoName

    @RepoName.setter
    def RepoName(self, RepoName):
        self._RepoName = RepoName

    @property
    def RepoType(self):
        """仓库类型
        :rtype: str
        """
        return self._RepoType

    @RepoType.setter
    def RepoType(self, RepoType):
        self._RepoType = RepoType


    def _deserialize(self, params):
        self._Reponame = params.get("Reponame")
        self._Repotype = params.get("Repotype")
        self._TagCount = params.get("TagCount")
        self._IsPublic = params.get("IsPublic")
        self._IsUserFavor = params.get("IsUserFavor")
        self._IsQcloudOfficial = params.get("IsQcloudOfficial")
        self._FavorCount = params.get("FavorCount")
        self._PullCount = params.get("PullCount")
        self._Description = params.get("Description")
        self._CreationTime = params.get("CreationTime")
        self._UpdateTime = params.get("UpdateTime")
        if params.get("TcrRepoInfo") is not None:
            self._TcrRepoInfo = TcrRepoInfo()
            self._TcrRepoInfo._deserialize(params.get("TcrRepoInfo"))
        self._TcrBindingId = params.get("TcrBindingId")
        self._ApplicationId = params.get("ApplicationId")
        if params.get("ApplicationName") is not None:
            self._ApplicationName = ScalableRule()
            self._ApplicationName._deserialize(params.get("ApplicationName"))
        self._ApplicationNameReal = params.get("ApplicationNameReal")
        self._Public = params.get("Public")
        self._CreateMode = params.get("CreateMode")
        self._RepoName = params.get("RepoName")
        self._RepoType = params.get("RepoType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageRepositoryResult(AbstractModel):
    """镜像仓库列表

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _Server: 镜像服务器地址
注意：此字段可能返回 null，表示取不到有效值。
        :type Server: str
        :param _Content: 列表信息
        :type Content: list of ImageRepository
        """
        self._TotalCount = None
        self._Server = None
        self._Content = None

    @property
    def TotalCount(self):
        """总记录数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Server(self):
        """镜像服务器地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Server

    @Server.setter
    def Server(self, Server):
        self._Server = Server

    @property
    def Content(self):
        """列表信息
        :rtype: list of ImageRepository
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._Server = params.get("Server")
        if params.get("Content") is not None:
            self._Content = []
            for item in params.get("Content"):
                obj = ImageRepository()
                obj._deserialize(item)
                self._Content.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageTag(AbstractModel):
    """列表信息

    """

    def __init__(self):
        r"""
        :param _RepoName: 仓库名
        :type RepoName: str
        :param _TagName: 版本名称
        :type TagName: str
        :param _TagId: 版本ID
        :type TagId: str
        :param _ImageId: 镜像ID
        :type ImageId: str
        :param _Size: 大小
        :type Size: str
        :param _CreationTime: 创建时间
        :type CreationTime: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        :param _Author: 镜像制作者
        :type Author: str
        :param _Architecture: CPU架构
        :type Architecture: str
        :param _DockerVersion: Docker客户端版本
        :type DockerVersion: str
        :param _Os: 操作系统
        :type Os: str
        :param _PushTime: push时间
        :type PushTime: str
        :param _SizeByte: 单位为字节
        :type SizeByte: int
        :param _TcrRepoInfo: TcrRepoInfo值
        :type TcrRepoInfo: :class:`tencentcloud.tsf.v20180326.models.TcrRepoInfo`
        """
        self._RepoName = None
        self._TagName = None
        self._TagId = None
        self._ImageId = None
        self._Size = None
        self._CreationTime = None
        self._UpdateTime = None
        self._Author = None
        self._Architecture = None
        self._DockerVersion = None
        self._Os = None
        self._PushTime = None
        self._SizeByte = None
        self._TcrRepoInfo = None

    @property
    def RepoName(self):
        """仓库名
        :rtype: str
        """
        return self._RepoName

    @RepoName.setter
    def RepoName(self, RepoName):
        self._RepoName = RepoName

    @property
    def TagName(self):
        """版本名称
        :rtype: str
        """
        return self._TagName

    @TagName.setter
    def TagName(self, TagName):
        self._TagName = TagName

    @property
    def TagId(self):
        """版本ID
        :rtype: str
        """
        return self._TagId

    @TagId.setter
    def TagId(self, TagId):
        self._TagId = TagId

    @property
    def ImageId(self):
        """镜像ID
        :rtype: str
        """
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def Size(self):
        """大小
        :rtype: str
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def CreationTime(self):
        """创建时间
        :rtype: str
        """
        return self._CreationTime

    @CreationTime.setter
    def CreationTime(self, CreationTime):
        self._CreationTime = CreationTime

    @property
    def UpdateTime(self):
        """更新时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Author(self):
        """镜像制作者
        :rtype: str
        """
        return self._Author

    @Author.setter
    def Author(self, Author):
        self._Author = Author

    @property
    def Architecture(self):
        """CPU架构
        :rtype: str
        """
        return self._Architecture

    @Architecture.setter
    def Architecture(self, Architecture):
        self._Architecture = Architecture

    @property
    def DockerVersion(self):
        """Docker客户端版本
        :rtype: str
        """
        return self._DockerVersion

    @DockerVersion.setter
    def DockerVersion(self, DockerVersion):
        self._DockerVersion = DockerVersion

    @property
    def Os(self):
        """操作系统
        :rtype: str
        """
        return self._Os

    @Os.setter
    def Os(self, Os):
        self._Os = Os

    @property
    def PushTime(self):
        """push时间
        :rtype: str
        """
        return self._PushTime

    @PushTime.setter
    def PushTime(self, PushTime):
        self._PushTime = PushTime

    @property
    def SizeByte(self):
        """单位为字节
        :rtype: int
        """
        return self._SizeByte

    @SizeByte.setter
    def SizeByte(self, SizeByte):
        self._SizeByte = SizeByte

    @property
    def TcrRepoInfo(self):
        """TcrRepoInfo值
        :rtype: :class:`tencentcloud.tsf.v20180326.models.TcrRepoInfo`
        """
        return self._TcrRepoInfo

    @TcrRepoInfo.setter
    def TcrRepoInfo(self, TcrRepoInfo):
        self._TcrRepoInfo = TcrRepoInfo


    def _deserialize(self, params):
        self._RepoName = params.get("RepoName")
        self._TagName = params.get("TagName")
        self._TagId = params.get("TagId")
        self._ImageId = params.get("ImageId")
        self._Size = params.get("Size")
        self._CreationTime = params.get("CreationTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Author = params.get("Author")
        self._Architecture = params.get("Architecture")
        self._DockerVersion = params.get("DockerVersion")
        self._Os = params.get("Os")
        self._PushTime = params.get("PushTime")
        self._SizeByte = params.get("SizeByte")
        if params.get("TcrRepoInfo") is not None:
            self._TcrRepoInfo = TcrRepoInfo()
            self._TcrRepoInfo._deserialize(params.get("TcrRepoInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageTagsResult(AbstractModel):
    """镜像版本列表

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _RepoName: 仓库名,含命名空间,如tsf/ngin
        :type RepoName: str
        :param _Server: 镜像服务器地址
        :type Server: str
        :param _Content: 列表信息
        :type Content: list of ImageTag
        """
        self._TotalCount = None
        self._RepoName = None
        self._Server = None
        self._Content = None

    @property
    def TotalCount(self):
        """总记录数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RepoName(self):
        """仓库名,含命名空间,如tsf/ngin
        :rtype: str
        """
        return self._RepoName

    @RepoName.setter
    def RepoName(self, RepoName):
        self._RepoName = RepoName

    @property
    def Server(self):
        """镜像服务器地址
        :rtype: str
        """
        return self._Server

    @Server.setter
    def Server(self, Server):
        self._Server = Server

    @property
    def Content(self):
        """列表信息
        :rtype: list of ImageTag
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._RepoName = params.get("RepoName")
        self._Server = params.get("Server")
        if params.get("Content") is not None:
            self._Content = []
            for item in params.get("Content"):
                obj = ImageTag()
                obj._deserialize(item)
                self._Content.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IndicatorCoord(AbstractModel):
    """监控指标坐标

    """

    def __init__(self):
        r"""
        :param _CoordX: 指标横坐标值
        :type CoordX: str
        :param _CoordY: 指标纵坐标值
        :type CoordY: str
        :param _CoordTag: 指标标签，用于标识附加信息
        :type CoordTag: str
        """
        self._CoordX = None
        self._CoordY = None
        self._CoordTag = None

    @property
    def CoordX(self):
        """指标横坐标值
        :rtype: str
        """
        return self._CoordX

    @CoordX.setter
    def CoordX(self, CoordX):
        self._CoordX = CoordX

    @property
    def CoordY(self):
        """指标纵坐标值
        :rtype: str
        """
        return self._CoordY

    @CoordY.setter
    def CoordY(self, CoordY):
        self._CoordY = CoordY

    @property
    def CoordTag(self):
        """指标标签，用于标识附加信息
        :rtype: str
        """
        return self._CoordTag

    @CoordTag.setter
    def CoordTag(self, CoordTag):
        self._CoordTag = CoordTag


    def _deserialize(self, params):
        self._CoordX = params.get("CoordX")
        self._CoordY = params.get("CoordY")
        self._CoordTag = params.get("CoordTag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Instance(AbstractModel):
    """机器实例

    """

    def __init__(self):
        r"""
        :param _InstanceId: 机器实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _InstanceName: 机器名称
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceName: str
        :param _LanIp: 机器内网地址IP
注意：此字段可能返回 null，表示取不到有效值。
        :type LanIp: str
        :param _WanIp: 机器外网地址IP
注意：此字段可能返回 null，表示取不到有效值。
        :type WanIp: str
        :param _InstanceDesc: 机器描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceDesc: str
        :param _ClusterId: 集群ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterId: str
        :param _ClusterName: 集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterName: str
        :param _InstanceStatus: VM的状态 虚机：虚机的状态 容器：Pod所在虚机的状态
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceStatus: str
        :param _InstanceAvailableStatus: VM的可使用状态 虚机：虚机是否能够作为资源使用 容器：虚机是否能够作为资源部署POD
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceAvailableStatus: str
        :param _ServiceInstanceStatus: 服务下的服务实例的状态 虚机：应用是否可用 + Agent状态 容器：Pod状态
注意：此字段可能返回 null，表示取不到有效值。
        :type ServiceInstanceStatus: str
        :param _CountInTsf: 标识此instance是否已添加在tsf中
注意：此字段可能返回 null，表示取不到有效值。
        :type CountInTsf: int
        :param _GroupId: 机器所属部署组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupId: str
        :param _ApplicationId: 机器所属应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationId: str
        :param _ApplicationName: 机器所属应用名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationName: str
        :param _InstanceCreatedTime: 机器实例在CVM的创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceCreatedTime: str
        :param _InstanceExpiredTime: 机器实例在CVM的过期时间
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceExpiredTime: str
        :param _InstanceChargeType: 机器实例在CVM的计费模式
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceChargeType: str
        :param _InstanceTotalCpu: 机器实例总CPU信息
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceTotalCpu: float
        :param _InstanceTotalMem: 机器实例总内存信息
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceTotalMem: float
        :param _InstanceUsedCpu: 机器实例使用的CPU信息
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceUsedCpu: float
        :param _InstanceUsedMem: 机器实例使用的内存信息
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceUsedMem: float
        :param _InstanceLimitCpu: 机器实例Limit CPU信息
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceLimitCpu: float
        :param _InstanceLimitMem: 机器实例Limit 内存信息
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceLimitMem: float
        :param _InstancePkgVersion: 包版本
注意：此字段可能返回 null，表示取不到有效值。
        :type InstancePkgVersion: str
        :param _ClusterType: 集群类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterType: str
        :param _RestrictState: 机器实例业务状态
注意：此字段可能返回 null，表示取不到有效值。
        :type RestrictState: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _OperationState: 实例执行状态
注意：此字段可能返回 null，表示取不到有效值。
        :type OperationState: int
        :param _NamespaceId: NamespaceId Ns ID
注意：此字段可能返回 null，表示取不到有效值。
        :type NamespaceId: str
        :param _InstanceZoneId: InstanceZoneId 可用区ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceZoneId: str
        :param _InstanceImportMode: InstanceImportMode 导入模式
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceImportMode: str
        :param _ApplicationType: ApplicationType应用类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationType: str
        :param _ApplicationResourceType: ApplicationResourceType 资源类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicationResourceType: str
        :param _ServiceSidecarStatus: sidecar状态
注意：此字段可能返回 null，表示取不到有效值。
        :type ServiceSidecarStatus: str
        :param _GroupName: 部署组名
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupName: str
        :param _NamespaceName: NS名
注意：此字段可能返回 null，表示取不到有效值。
        :type NamespaceName: str
        :param _Reason: 健康检查原因
注意：此字段可能返回 null，表示取不到有效值。
        :type Reason: str
        :param _AgentVersion: agent版本
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentVersion: str
        :param _NodeInstanceId: 容器母机实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeInstanceId: str
        """
        self._InstanceId = None
        self._InstanceName = None
        self._LanIp = None
        self._WanIp = None
        self._InstanceDesc = None
        self._ClusterId = None
        self._ClusterName = None
        self._InstanceStatus = None
        self._InstanceAvailableStatus = None
        self._ServiceInstanceStatus = None
        self._CountInTsf = None
        self._GroupId = None
        self._ApplicationId = None
        self._ApplicationName = None
        self._InstanceCreatedTime = None
        self._InstanceExpiredTime = None
        self._InstanceChargeType = None
        self._InstanceTotalCpu = None
        self._InstanceTotalMem = None
        self._InstanceUsedCpu = None
        self._InstanceUsedMem = None
        self._InstanceLimitCpu = None
        self._InstanceLimitMem = None
        self._InstancePkgVersion = None
        self._ClusterType = None
        self._RestrictState = None
        self._UpdateTime = None
        self._OperationState = None
        self._NamespaceId = None
        self._InstanceZoneId = None
        self._InstanceImportMode = None
        self._ApplicationType = None
        self._ApplicationResourceType = None
        self._ServiceSidecarStatus = None
        self._GroupName = None
        self._NamespaceName = None
        self._Reason = None
        self._AgentVersion = None
        self._NodeInstanceId = None

    @property
    def InstanceId(self):
        """机器实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        """机器名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def LanIp(self):
        """机器内网地址IP
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LanIp

    @LanIp.setter
    def LanIp(self, LanIp):
        self._LanIp = LanIp

    @property
    def WanIp(self):
        """机器外网地址IP
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._WanIp

    @WanIp.setter
    def WanIp(self, WanIp):
        self._WanIp = WanIp

    @property
    def InstanceDesc(self):
        """机器描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceDesc

    @InstanceDesc.setter
    def InstanceDesc(self, InstanceDesc):
        self._InstanceDesc = InstanceDesc

    @property
    def ClusterId(self):
        """集群ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        """集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def InstanceStatus(self):
        """VM的状态 虚机：虚机的状态 容器：Pod所在虚机的状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceStatus

    @InstanceStatus.setter
    def InstanceStatus(self, InstanceStatus):
        self._InstanceStatus = InstanceStatus

    @property
    def InstanceAvailableStatus(self):
        """VM的可使用状态 虚机：虚机是否能够作为资源使用 容器：虚机是否能够作为资源部署POD
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceAvailableStatus

    @InstanceAvailableStatus.setter
    def InstanceAvailableStatus(self, InstanceAvailableStatus):
        self._InstanceAvailableStatus = InstanceAvailableStatus

    @property
    def ServiceInstanceStatus(self):
        """服务下的服务实例的状态 虚机：应用是否可用 + Agent状态 容器：Pod状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ServiceInstanceStatus

    @ServiceInstanceStatus.setter
    def ServiceInstanceStatus(self, ServiceInstanceStatus):
        self._ServiceInstanceStatus = ServiceInstanceStatus

    @property
    def CountInTsf(self):
        """标识此instance是否已添加在tsf中
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._CountInTsf

    @CountInTsf.setter
    def CountInTsf(self, CountInTsf):
        self._CountInTsf = CountInTsf

    @property
    def GroupId(self):
        """机器所属部署组ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def ApplicationId(self):
        """机器所属应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        """机器所属应用名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def InstanceCreatedTime(self):
        """机器实例在CVM的创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceCreatedTime

    @InstanceCreatedTime.setter
    def InstanceCreatedTime(self, InstanceCreatedTime):
        self._InstanceCreatedTime = InstanceCreatedTime

    @property
    def InstanceExpiredTime(self):
        """机器实例在CVM的过期时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceExpiredTime

    @InstanceExpiredTime.setter
    def InstanceExpiredTime(self, InstanceExpiredTime):
        self._InstanceExpiredTime = InstanceExpiredTime

    @property
    def InstanceChargeType(self):
        """机器实例在CVM的计费模式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceChargeType

    @InstanceChargeType.setter
    def InstanceChargeType(self, InstanceChargeType):
        self._InstanceChargeType = InstanceChargeType

    @property
    def InstanceTotalCpu(self):
        """机器实例总CPU信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._InstanceTotalCpu

    @InstanceTotalCpu.setter
    def InstanceTotalCpu(self, InstanceTotalCpu):
        self._InstanceTotalCpu = InstanceTotalCpu

    @property
    def InstanceTotalMem(self):
        """机器实例总内存信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._InstanceTotalMem

    @InstanceTotalMem.setter
    def InstanceTotalMem(self, InstanceTotalMem):
        self._InstanceTotalMem = InstanceTotalMem

    @property
    def InstanceUsedCpu(self):
        """机器实例使用的CPU信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._InstanceUsedCpu

    @InstanceUsedCpu.setter
    def InstanceUsedCpu(self, InstanceUsedCpu):
        self._InstanceUsedCpu = InstanceUsedCpu

    @property
    def InstanceUsedMem(self):
        """机器实例使用的内存信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._InstanceUsedMem

    @InstanceUsedMem.setter
    def InstanceUsedMem(self, InstanceUsedMem):
        self._InstanceUsedMem = InstanceUsedMem

    @property
    def InstanceLimitCpu(self):
        """机器实例Limit CPU信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._InstanceLimitCpu

    @InstanceLimitCpu.setter
    def InstanceLimitCpu(self, InstanceLimitCpu):
        self._InstanceLimitCpu = InstanceLimitCpu

    @property
    def InstanceLimitMem(self):
        """机器实例Limit 内存信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._InstanceLimitMem

    @InstanceLimitMem.setter
    def InstanceLimitMem(self, InstanceLimitMem):
        self._InstanceLimitMem = InstanceLimitMem

    @property
    def InstancePkgVersion(self):
        """包版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstancePkgVersion

    @InstancePkgVersion.setter
    def InstancePkgVersion(self, InstancePkgVersion):
        self._InstancePkgVersion = InstancePkgVersion

    @property
    def ClusterType(self):
        """集群类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def RestrictState(self):
        """机器实例业务状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RestrictState

    @RestrictState.setter
    def RestrictState(self, RestrictState):
        self._RestrictState = RestrictState

    @property
    def UpdateTime(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def OperationState(self):
        """实例执行状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._OperationState

    @OperationState.setter
    def OperationState(self, OperationState):
        self._OperationState = OperationState

    @property
    def NamespaceId(self):
        """NamespaceId Ns ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def InstanceZoneId(self):
        """InstanceZoneId 可用区ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceZoneId

    @InstanceZoneId.setter
    def InstanceZoneId(self, InstanceZoneId):
        self._InstanceZoneId = InstanceZoneId

    @property
    def InstanceImportMode(self):
        """InstanceImportMode 导入模式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceImportMode

    @InstanceImportMode.setter
    def InstanceImportMode(self, InstanceImportMode):
        self._InstanceImportMode = InstanceImportMode

    @property
    def ApplicationType(self):
        """ApplicationType应用类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType

    @property
    def ApplicationResourceType(self):
        """ApplicationResourceType 资源类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplicationResourceType

    @ApplicationResourceType.setter
    def ApplicationResourceType(self, ApplicationResourceType):
        self._ApplicationResourceType = ApplicationResourceType

    @property
    def ServiceSidecarStatus(self):
        """sidecar状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ServiceSidecarStatus

    @ServiceSidecarStatus.setter
    def ServiceSidecarStatus(self, ServiceSidecarStatus):
        self._ServiceSidecarStatus = ServiceSidecarStatus

    @property
    def GroupName(self):
        """部署组名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def NamespaceName(self):
        """NS名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def Reason(self):
        """健康检查原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def AgentVersion(self):
        """agent版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AgentVersion

    @AgentVersion.setter
    def AgentVersion(self, AgentVersion):
        self._AgentVersion = AgentVersion

    @property
    def NodeInstanceId(self):
        """容器母机实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NodeInstanceId

    @NodeInstanceId.setter
    def NodeInstanceId(self, NodeInstanceId):
        self._NodeInstanceId = NodeInstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._LanIp = params.get("LanIp")
        self._WanIp = params.get("WanIp")
        self._InstanceDesc = params.get("InstanceDesc")
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._InstanceStatus = params.get("InstanceStatus")
        self._InstanceAvailableStatus = params.get("InstanceAvailableStatus")
        self._ServiceInstanceStatus = params.get("ServiceInstanceStatus")
        self._CountInTsf = params.get("CountInTsf")
        self._GroupId = params.get("GroupId")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._InstanceCreatedTime = params.get("InstanceCreatedTime")
        self._InstanceExpiredTime = params.get("InstanceExpiredTime")
        self._InstanceChargeType = params.get("InstanceChargeType")
        self._InstanceTotalCpu = params.get("InstanceTotalCpu")
        self._InstanceTotalMem = params.get("InstanceTotalMem")
        self._InstanceUsedCpu = params.get("InstanceUsedCpu")
        self._InstanceUsedMem = params.get("InstanceUsedMem")
        self._InstanceLimitCpu = params.get("InstanceLimitCpu")
        self._InstanceLimitMem = params.get("InstanceLimitMem")
        self._InstancePkgVersion = params.get("InstancePkgVersion")
        self._ClusterType = params.get("ClusterType")
        self._RestrictState = params.get("RestrictState")
        self._UpdateTime = params.get("UpdateTime")
        self._OperationState = params.get("OperationState")
        self._NamespaceId = params.get("NamespaceId")
        self._InstanceZoneId = params.get("InstanceZoneId")
        self._InstanceImportMode = params.get("InstanceImportMode")
        self._ApplicationType = params.get("ApplicationType")
        self._ApplicationResourceType = params.get("ApplicationResourceType")
        self._ServiceSidecarStatus = params.get("ServiceSidecarStatus")
        self._GroupName = params.get("GroupName")
        self._NamespaceName = params.get("NamespaceName")
        self._Reason = params.get("Reason")
        self._AgentVersion = params.get("AgentVersion")
        self._NodeInstanceId = params.get("NodeInstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceAdvancedSettings(AbstractModel):
    """容器导入实例高级设置

    """

    def __init__(self):
        r"""
        :param _MountTarget: 数据盘挂载点, 默认不挂载数据盘. 已格式化的 ext3，ext4，xfs 文件系统的数据盘将直接挂载，其他文件系统或未格式化的数据盘将自动格式化为ext4 并挂载，请注意备份数据! 无数据盘或有多块数据盘的云主机此设置不生效。
注意，注意，多盘场景请使用下方的DataDisks数据结构，设置对应的云盘类型、云盘大小、挂载路径、是否格式化等信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type MountTarget: str
        :param _DockerGraphPath: dockerd --graph 指定值, 默认为 /var/lib/docker
注意：此字段可能返回 null，表示取不到有效值。
        :type DockerGraphPath: str
        """
        self._MountTarget = None
        self._DockerGraphPath = None

    @property
    def MountTarget(self):
        """数据盘挂载点, 默认不挂载数据盘. 已格式化的 ext3，ext4，xfs 文件系统的数据盘将直接挂载，其他文件系统或未格式化的数据盘将自动格式化为ext4 并挂载，请注意备份数据! 无数据盘或有多块数据盘的云主机此设置不生效。
注意，注意，多盘场景请使用下方的DataDisks数据结构，设置对应的云盘类型、云盘大小、挂载路径、是否格式化等信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MountTarget

    @MountTarget.setter
    def MountTarget(self, MountTarget):
        self._MountTarget = MountTarget

    @property
    def DockerGraphPath(self):
        """dockerd --graph 指定值, 默认为 /var/lib/docker
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DockerGraphPath

    @DockerGraphPath.setter
    def DockerGraphPath(self, DockerGraphPath):
        self._DockerGraphPath = DockerGraphPath


    def _deserialize(self, params):
        self._MountTarget = params.get("MountTarget")
        self._DockerGraphPath = params.get("DockerGraphPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceEnrichedInfo(AbstractModel):
    """包含虚拟机所在TSF中的位置信息

    """

    def __init__(self):
        r"""
        :param _InstanceId: 机器ID
        :type InstanceId: str
        :param _InstanceName: 机器名称
        :type InstanceName: str
        :param _LanIp: 机器内网IP
        :type LanIp: str
        :param _WanIp: 机器外网IP
        :type WanIp: str
        :param _VpcId: 机器所在VPC
        :type VpcId: str
        :param _InstanceStatus: 机器运行状态 Pending Running Stopped Rebooting Starting Stopping Abnormal Unknown
        :type InstanceStatus: str
        :param _InstanceAvailableStatus: 机器可用状态（表示机器上的Agent在线）
        :type InstanceAvailableStatus: str
        :param _ApplicationId: 应用ID
        :type ApplicationId: str
        :param _ApplicationName: 应用名称
        :type ApplicationName: str
        :param _ApplicationType: 应用类型
        :type ApplicationType: str
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _ClusterType: 集群类型
        :type ClusterType: str
        :param _NamespaceId: 命名空间ID
        :type NamespaceId: str
        :param _NamespaceName: 命名空间名称
        :type NamespaceName: str
        :param _GroupId: 机器所在部署组ID
        :type GroupId: str
        :param _GroupName: 部署组名称
        :type GroupName: str
        """
        self._InstanceId = None
        self._InstanceName = None
        self._LanIp = None
        self._WanIp = None
        self._VpcId = None
        self._InstanceStatus = None
        self._InstanceAvailableStatus = None
        self._ApplicationId = None
        self._ApplicationName = None
        self._ApplicationType = None
        self._ClusterId = None
        self._ClusterName = None
        self._ClusterType = None
        self._NamespaceId = None
        self._NamespaceName = None
        self._GroupId = None
        self._GroupName = None

    @property
    def InstanceId(self):
        """机器ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        """机器名称
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def LanIp(self):
        """机器内网IP
        :rtype: str
        """
        return self._LanIp

    @LanIp.setter
    def LanIp(self, LanIp):
        self._LanIp = LanIp

    @property
    def WanIp(self):
        """机器外网IP
        :rtype: str
        """
        return self._WanIp

    @WanIp.setter
    def WanIp(self, WanIp):
        self._WanIp = WanIp

    @property
    def VpcId(self):
        """机器所在VPC
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def InstanceStatus(self):
        """机器运行状态 Pending Running Stopped Rebooting Starting Stopping Abnormal Unknown
        :rtype: str
        """
        return self._InstanceStatus

    @InstanceStatus.setter
    def InstanceStatus(self, InstanceStatus):
        self._InstanceStatus = InstanceStatus

    @property
    def InstanceAvailableStatus(self):
        """机器可用状态（表示机器上的Agent在线）
        :rtype: str
        """
        return self._InstanceAvailableStatus

    @InstanceAvailableStatus.setter
    def InstanceAvailableStatus(self, InstanceAvailableStatus):
        self._InstanceAvailableStatus = InstanceAvailableStatus

    @property
    def ApplicationId(self):
        """应用ID
        :rtype: str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        """应用名称
        :rtype: str
        """
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationType(self):
        """应用类型
        :rtype: str
        """
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType

    @property
    def ClusterId(self):
        """集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        """集群名称
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterType(self):
        """集群类型
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def NamespaceId(self):
        """命名空间ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def NamespaceName(self):
        """命名空间名称
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def GroupId(self):
        """机器所在部署组ID
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupName(self):
        """部署组名称
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._LanIp = params.get("LanIp")
        self._WanIp = params.get("WanIp")
        self._VpcId = params.get("VpcId")
        self._InstanceStatus = params.get("InstanceStatus")
        self._InstanceAvailableStatus = params.get("InstanceAvailableStatus")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._ApplicationType = params.get("ApplicationType")
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._ClusterType = params.get("ClusterType")
        self._NamespaceId = params.get("NamespaceId")
        self._NamespaceName = params.get("NamespaceName")
        self._GroupId = params.get("GroupId")
        self._GroupName = params.get("GroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceEnrichedInfoPage(AbstractModel):
    """InstanceEnrichedInfo列表结构

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _Content: 列表
        :type Content: list of InstanceEnrichedInfo
        """
        self._TotalCount = None
        self._Content = None

    @property
    def TotalCount(self):
        """总数量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Content(self):
        """列表
        :rtype: list of InstanceEnrichedInfo
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Content") is not None:
            self._Content = []
            for item in params.get("Content"):
                obj = InstanceEnrichedInfo()
                obj._deserialize(item)
                self._Content.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InvocationIndicator(AbstractModel):
    """服务调用监控指标

    """

    def __init__(self):
        r"""
        :param _InvocationQuantity: 总请求数
注意：此字段可能返回 null，表示取不到有效值。
        :type InvocationQuantity: int
        :param _InvocationSuccessRate: 请求成功率，百分比
注意：此字段可能返回 null，表示取不到有效值。
        :type InvocationSuccessRate: float
        :param _InvocationAvgDuration: 请求平均耗时，单位毫秒
注意：此字段可能返回 null，表示取不到有效值。
        :type InvocationAvgDuration: float
        :param _InvocationSuccessDistribution: 成功请求数时间分布
        :type InvocationSuccessDistribution: list of IndicatorCoord
        :param _InvocationFailedDistribution: 失败请求数时间分布
        :type InvocationFailedDistribution: list of IndicatorCoord
        :param _InvocationStatusDistribution: 状态码分布
        :type InvocationStatusDistribution: list of IndicatorCoord
        :param _InvocationDurationDistribution: 时延分布
        :type InvocationDurationDistribution: list of IndicatorCoord
        :param _InvocationQuantityDistribution: 并发请求次数时间分布
        :type InvocationQuantityDistribution: list of IndicatorCoord
        """
        self._InvocationQuantity = None
        self._InvocationSuccessRate = None
        self._InvocationAvgDuration = None
        self._InvocationSuccessDistribution = None
        self._InvocationFailedDistribution = None
        self._InvocationStatusDistribution = None
        self._InvocationDurationDistribution = None
        self._InvocationQuantityDistribution = None

    @property
    def InvocationQuantity(self):
        """总请求数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._InvocationQuantity

    @InvocationQuantity.setter
    def InvocationQuantity(self, InvocationQuantity):
        self._InvocationQuantity = InvocationQuantity

    @property
    def InvocationSuccessRate(self):
        """请求成功率，百分比
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._InvocationSuccessRate

    @InvocationSuccessRate.setter
    def InvocationSuccessRate(self, InvocationSuccessRate):
        self._InvocationSuccessRate = InvocationSuccessRate

    @property
    def InvocationAvgDuration(self):
        """请求平均耗时，单位毫秒
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._InvocationAvgDuration

    @InvocationAvgDuration.setter
    def InvocationAvgDuration(self, InvocationAvgDuration):
        self._InvocationAvgDuration = InvocationAvgDuration

    @property
    def InvocationSuccessDistribution(self):
        """成功请求数时间分布
        :rtype: list of IndicatorCoord
        """
        return self._InvocationSuccessDistribution

    @InvocationSuccessDistribution.setter
    def InvocationSuccessDistribution(self, InvocationSuccessDistribution):
        self._InvocationSuccessDistribution = InvocationSuccessDistribution

    @property
    def InvocationFailedDistribution(self):
        """失败请求数时间分布
        :rtype: list of IndicatorCoord
        """
        return self._InvocationFailedDistribution

    @InvocationFailedDistribution.setter
    def InvocationFailedDistribution(self, InvocationFailedDistribution):
        self._InvocationFailedDistribution = InvocationFailedDistribution

    @property
    def InvocationStatusDistribution(self):
        """状态码分布
        :rtype: list of IndicatorCoord
        """
        return self._InvocationStatusDistribution

    @InvocationStatusDistribution.setter
    def InvocationStatusDistribution(self, InvocationStatusDistribution):
        self._InvocationStatusDistribution = InvocationStatusDistribution

    @property
    def InvocationDurationDistribution(self):
        """时延分布
        :rtype: list of IndicatorCoord
        """
        return self._InvocationDurationDistribution

    @InvocationDurationDistribution.setter
    def InvocationDurationDistribution(self, InvocationDurationDistribution):
        self._InvocationDurationDistribution = InvocationDurationDistribution

    @property
    def InvocationQuantityDistribution(self):
        """并发请求次数时间分布
        :rtype: list of IndicatorCoord
        """
        return self._InvocationQuantityDistribution

    @InvocationQuantityDistribution.setter
    def InvocationQuantityDistribution(self, InvocationQuantityDistribution):
        self._InvocationQuantityDistribution = InvocationQuantityDistribution


    def _deserialize(self, params):
        self._InvocationQuantity = params.get("InvocationQuantity")
        self._InvocationSuccessRate = params.get("InvocationSuccessRate")
        self._InvocationAvgDuration = params.get("InvocationAvgDuration")
        if params.get("InvocationSuccessDistribution") is not None:
            self._InvocationSuccessDistribution = []
            for item in params.get("InvocationSuccessDistribution"):
                obj = IndicatorCoord()
                obj._deserialize(item)
                self._InvocationSuccessDistribution.append(obj)
        if params.get("InvocationFailedDistribution") is not None:
            self._InvocationFailedDistribution = []
            for item in params.get("InvocationFailedDistribution"):
                obj = IndicatorCoord()
                obj._deserialize(item)
                self._InvocationFailedDistribution.append(obj)
        if params.get("InvocationStatusDistribution") is not None:
            self._InvocationStatusDistribution = []
            for item in params.get("InvocationStatusDistribution"):
                obj = IndicatorCoord()
                obj._deserialize(item)
                self._InvocationStatusDistribution.append(obj)
        if params.get("InvocationDurationDistribution") is not None:
            self._InvocationDurationDistribution = []
            for item in params.get("InvocationDurationDistribution"):
                obj = IndicatorCoord()
                obj._deserialize(item)
                self._InvocationDurationDistribution.append(obj)
        if params.get("InvocationQuantityDistribution") is not None:
            self._InvocationQuantityDistribution = []
            for item in params.get("InvocationQuantityDistribution"):
                obj = IndicatorCoord()
                obj._deserialize(item)
                self._InvocationQuantityDistribution.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InvocationMetricScatterPlot(AbstractModel):
    """监控数据散点图

    """

    def __init__(self):
        r"""
        :param _EndTime: 时间轴截止时间，GMT，精确到毫秒
        :type EndTime: int
        :param _StartTime: 时间粒度
        :type StartTime: int
        :param _Period: 时间轴开始时间，GMT，精确到毫秒
        :type Period: int
        :param _DataPoints: 多值数据点集合
        :type DataPoints: list of MultiValueDataPoints
        """
        self._EndTime = None
        self._StartTime = None
        self._Period = None
        self._DataPoints = None

    @property
    def EndTime(self):
        """时间轴截止时间，GMT，精确到毫秒
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StartTime(self):
        """时间粒度
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def Period(self):
        """时间轴开始时间，GMT，精确到毫秒
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def DataPoints(self):
        """多值数据点集合
        :rtype: list of MultiValueDataPoints
        """
        return self._DataPoints

    @DataPoints.setter
    def DataPoints(self, DataPoints):
        self._DataPoints = DataPoints


    def _deserialize(self, params):
        self._EndTime = params.get("EndTime")
        self._StartTime = params.get("StartTime")
        self._Period = params.get("Period")
        if params.get("DataPoints") is not None:
            self._DataPoints = []
            for item in params.get("DataPoints"):
                obj = MultiValueDataPoints()
                obj._deserialize(item)
                self._DataPoints.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if l