/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr;

import com.aspose.ocr.DetectAreasMode;
import com.aspose.ocr.Format;
import com.aspose.ocr.Logging;
import com.aspose.ocr.PreprocessingFilter;
import com.aspose.ocr.RecognitionSettings;
import com.aspose.ocr.SpellCheck.SpellCheckError;
import com.aspose.ocr.SpellCheck.SpellCheckLanguage;
import com.aspose.ocr.aa;
import com.aspose.ocr.am;
import com.aspose.ocr.e0cd0c2d77;
import com.aspose.ocr.m;
import com.aspose.ocr.q;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RecognitionResult {
    public ArrayList<String> recognitionAreasText;
    public ArrayList<LinesResult> recognitionLinesResult;
    public String recognitionText = "";
    public ArrayList<Rectangle> recognitionAreasRectangles;
    public ArrayList<char[]> recognitionCharactersList;
    public double skew = 0.0;
    public ArrayList<String> warnings;
    private HashMap<String, LinesResult> ac8a = new HashMap();
    BufferedImage f = null;
    DetectAreasMode c0ad = DetectAreasMode.DOCUMENT;
    int edf = 150;

    public String GetJson() {
        m m2 = m.f();
        e0cd0c2d77.f(m2, this);
        try {
            return m2.c0ad();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String GetXml() {
        String string = "";
        try {
            StringWriter stringWriter = new StringWriter();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("totalResult");
            document.appendChild(element);
            e0cd0c2d77.f(document, element, this);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            string = stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            System.out.println("Error outputting document");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Error building document");
        }
        return string;
    }

    public void save(String string) {
        ArrayList<RecognitionResult> arrayList = new ArrayList<RecognitionResult>();
        arrayList.add(this);
        RecognitionResult.f(string, null, Format.Text, arrayList, null);
    }

    public void save(String string, Format format) {
        ArrayList<RecognitionResult> arrayList = new ArrayList<RecognitionResult>();
        arrayList.add(this);
        RecognitionResult.f(string, null, format, arrayList, null);
    }

    public void saveSpellCheckCorrectedText(String string, Format format, SpellCheckLanguage spellCheckLanguage) {
        ArrayList<RecognitionResult> arrayList = new ArrayList<RecognitionResult>();
        arrayList.add(this.f(spellCheckLanguage));
        RecognitionResult.f(string, null, format, arrayList, "");
    }

    public void saveSpellCheckCorrectedText(String string, Format format) {
        ArrayList<RecognitionResult> arrayList = new ArrayList<RecognitionResult>();
        arrayList.add(this.f());
        RecognitionResult.f(string, null, format, arrayList, null);
    }

    public String getSpellCheckCorrectedText(SpellCheckLanguage spellCheckLanguage) {
        return am.f(this.recognitionText, spellCheckLanguage);
    }

    public String getSpellCheckCorrectedText() {
        return am.c0ad(this.recognitionText);
    }

    public List<SpellCheckError> getSpellCheckErrorList(SpellCheckLanguage spellCheckLanguage) {
        return am.c0ad(this.recognitionText, spellCheckLanguage);
    }

    public List<SpellCheckError> getSpellCheckErrorList() {
        return am.edf(this.recognitionText);
    }

    public void useUserDictionary(String string) {
        am.f(string);
    }

    public HashMap<String, LinesResult> GetKeywords() {
        return this.ac8a;
    }

    public void SetKeyword(String string, LinesResult linesResult) {
        this.ac8a.put(string, linesResult);
    }

    public RecognitionResult() {
        this.recognitionAreasText = new ArrayList();
        this.recognitionAreasRectangles = new ArrayList();
        this.warnings = new ArrayList();
        this.recognitionCharactersList = new ArrayList();
        this.recognitionLinesResult = new ArrayList();
    }

    RecognitionResult f(SpellCheckLanguage spellCheckLanguage) {
        RecognitionResult recognitionResult = new RecognitionResult();
        recognitionResult = this.clone();
        for (int i2 = 0; i2 < recognitionResult.recognitionLinesResult.size(); ++i2) {
            String string = recognitionResult.recognitionLinesResult.get((int)i2).textInLine;
            recognitionResult.recognitionLinesResult.get((int)i2).textInLine = am.f(string, spellCheckLanguage);
        }
        return recognitionResult;
    }

    RecognitionResult f() {
        RecognitionResult recognitionResult = new RecognitionResult();
        recognitionResult = this.clone();
        for (int i2 = 0; i2 < recognitionResult.recognitionLinesResult.size(); ++i2) {
            String string = recognitionResult.recognitionLinesResult.get((int)i2).textInLine;
            recognitionResult.recognitionLinesResult.get((int)i2).textInLine = am.c0ad(string);
        }
        return recognitionResult;
    }

    void f(RecognitionSettings recognitionSettings, PreprocessingFilter preprocessingFilter, boolean bl2) {
        if (recognitionSettings == null) {
            return;
        }
        if (preprocessingFilter == null) {
            preprocessingFilter = new PreprocessingFilter();
        }
        if (bl2 && recognitionSettings.f() != null && recognitionSettings.f().size() != 0 || recognitionSettings.edf()) {
            Logging.f(q.e0cd0c6d11, "");
            this.warnings.add("Only setDetectAreasMode options will aplly");
        }
        if (recognitionSettings.f() != null && recognitionSettings.f().size() != 0 && (recognitionSettings.e0cd0c6d19() != DetectAreasMode.NONE || recognitionSettings.edf())) {
            Logging.f(q.edf, String.valueOf((Object)recognitionSettings.e0cd0c6d19()));
            this.warnings.add("Setting detectAreasMode no NONE for recognition will disable RecognizeSingleLine options");
        } else {
            if (preprocessingFilter.f() && preprocessingFilter.c0ad()) {
                Logging.f(q.e0cd0c6d18, "");
                this.warnings.add("Setting skew value will disable AutoSkew");
            }
            if (recognitionSettings.edf()) {
                Logging.f(q.e0cd0c6d19, "");
                this.warnings.add("Setting single line recognition will disable DetectAreas and AutoSkew");
            }
        }
        if ((recognitionSettings.e0cd0c6d19() == DetectAreasMode.DOCUMENT || recognitionSettings.e0cd0c6d19() == DetectAreasMode.NONE) && recognitionSettings.e0cd0c6d13()) {
            Logging.f(q.e0cd0c6d13, String.valueOf((Object)recognitionSettings.e0cd0c6d19()));
            this.warnings.add("AutomaticColorInversion works only with PHOTO, COMBINE, TABLE, CURVED_TEXT modes.");
        }
        this.f(recognitionSettings);
    }

    void f(RecognitionSettings recognitionSettings) {
        if ((recognitionSettings.e0cd0c6d19() == DetectAreasMode.PHOTO || recognitionSettings.e0cd0c6d19() == DetectAreasMode.TABLE) && aa.f(recognitionSettings.ac8a())) {
            Logging.f(q.ac8a, "");
            this.warnings.add("PHOTO and TABLE area recognition mode is not adapted to Chinese language. Use DOCUMENT mode better");
        }
    }

    static void f(String string, OutputStream outputStream, Format format, ArrayList<RecognitionResult> arrayList, SpellCheckLanguage spellCheckLanguage, String string2) {
        ArrayList<RecognitionResult> arrayList2 = new ArrayList<RecognitionResult>();
        for (RecognitionResult recognitionResult : arrayList) {
            arrayList2.add(recognitionResult.f(spellCheckLanguage));
        }
        RecognitionResult.f(string, outputStream, format, arrayList2, string2);
    }

    static void f(String string, OutputStream outputStream, Format format, ArrayList<RecognitionResult> arrayList, String string2) {
        try {
            switch (format) {
                case Docx: {
                    e0cd0c2d77.ac8a(arrayList, string, outputStream);
                    break;
                }
                case Pdf: {
                    e0cd0c2d77.f(arrayList, string, outputStream, true, string2);
                    break;
                }
                case PdfNoImg: {
                    e0cd0c2d77.f(arrayList, string, outputStream, false, string2);
                    break;
                }
                case Xlsx: {
                    e0cd0c2d77.e0cd0c6d16(arrayList, string, outputStream);
                    break;
                }
                case Xml: {
                    e0cd0c2d77.edf(arrayList, string, outputStream);
                    break;
                }
                case Json: {
                    e0cd0c2d77.c0ad(arrayList, string, outputStream);
                    break;
                }
                case Html: {
                    e0cd0c2d77.e0cd0c6d18(arrayList, string, outputStream);
                    break;
                }
                case Epub: {
                    e0cd0c2d77.e0cd0c6d19(arrayList, string, outputStream);
                    break;
                }
                case Rtf: {
                    e0cd0c2d77.e0cd0c6d17(arrayList, string, outputStream);
                    break;
                }
                default: {
                    e0cd0c2d77.f(arrayList, string, outputStream);
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Can't create document");
        }
    }

    public RecognitionResult add(RecognitionResult recognitionResult) {
        this.recognitionAreasRectangles.addAll(recognitionResult.recognitionAreasRectangles);
        this.recognitionAreasText.addAll(recognitionResult.recognitionAreasText);
        this.recognitionCharactersList.addAll(recognitionResult.recognitionCharactersList);
        this.recognitionLinesResult.addAll(recognitionResult.recognitionLinesResult);
        this.recognitionText = this.recognitionText + recognitionResult.recognitionText;
        this.skew = recognitionResult.skew;
        this.warnings = recognitionResult.warnings;
        this.f = recognitionResult.f;
        this.c0ad = recognitionResult.c0ad;
        this.edf = recognitionResult.edf;
        this.ac8a = recognitionResult.ac8a;
        return this;
    }

    public RecognitionResult clone() {
        RecognitionResult recognitionResult = new RecognitionResult();
        recognitionResult.recognitionAreasRectangles.addAll(this.recognitionAreasRectangles);
        recognitionResult.recognitionAreasText.addAll(this.recognitionAreasText);
        recognitionResult.recognitionCharactersList.addAll(this.recognitionCharactersList);
        for (LinesResult linesResult : this.recognitionLinesResult) {
            LinesResult linesResult2 = new LinesResult();
            linesResult2.line = linesResult.line;
            linesResult2.f = linesResult.f;
            linesResult2.textInLine = linesResult.textInLine;
            recognitionResult.recognitionLinesResult.add(linesResult2);
        }
        recognitionResult.recognitionText = recognitionResult.recognitionText + this.recognitionText;
        recognitionResult.skew = this.skew;
        recognitionResult.warnings = this.warnings;
        recognitionResult.f = this.f;
        recognitionResult.c0ad = this.c0ad;
        recognitionResult.edf = this.edf;
        recognitionResult.ac8a = this.ac8a;
        return recognitionResult;
    }

    public class LinesResult {
        public String textInLine;
        public Rectangle line;
        Rectangle f;

        LinesResult() {
        }

        LinesResult(LinesResult linesResult) {
            if (linesResult != null) {
                this.line = linesResult.line;
                this.f = linesResult.f;
                this.textInLine = linesResult.textInLine;
            }
        }
    }
}

