/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr;

import com.aspose.ocr.AsposeOCRException;
import com.aspose.ocr.Defect;
import com.aspose.ocr.ILibraryImport;
import com.aspose.ocr.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class LibraryImport
implements ILibraryImport {
    private static String prepareLibrary() throws IOException, ReflectiveOperationException, AsposeOCRException {
        Path path = Paths.get(Resources.GetLocalPath(), new String[0]);
        String string = "aspose_ocr_corej.dll";
        if (LibraryImport.isUnix()) {
            string = "aspose_ocr_corej.so";
        } else if (LibraryImport.isMac64()) {
            string = "aspose_ocr_corej_x64.dylib";
        } else if (LibraryImport.isMacArm()) {
            string = "aspose_ocr_corej_arm.dylib";
        }
        File file = new File(path.toString() + "/" + string);
        if (file.exists()) {
            return path.toString() + "/" + string;
        }
        try (InputStream inputStream = LibraryImport.class.getClassLoader().getResourceAsStream(string);){
            if (inputStream == null) {
                throw new IOException("Can't load resource custom.dll");
            }
            Files.copy(inputStream, path.resolve(string), new CopyOption[0]);
        }
        return path.toString() + "/" + string;
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("win") >= 0;
    }

    public static boolean isMacArm() {
        String string;
        String string2 = System.getProperty("os.name").toLowerCase();
        return string2.indexOf("mac") >= 0 && ((string = System.getProperty("os.arch")).equals("aarch64") || string.equals("arm64"));
    }

    public static boolean isMac64() {
        String string;
        String string2 = System.getProperty("os.name").toLowerCase();
        return string2.indexOf("mac") >= 0 && ((string = System.getProperty("os.arch")).equals("x86_64") || string.equals("amd64"));
    }

    public static boolean isUnix() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("nix") >= 0 || string.indexOf("nux") >= 0;
    }

    public static String getOSVerion() {
        String string = System.getProperty("os.version");
        return string;
    }

    private native Defect[] detect_defects(int var1, byte[] var2, int var3, int var4, int var5, int var6);

    @Override
    public Defect[] Detect_defects(int n2, byte[] byArray, int n3, int n4, int n5, int n6) {
        return this.detect_defects(n2, byArray, n3, n4, n5, n6);
    }

    static {
        try {
            String string = LibraryImport.prepareLibrary();
            System.load(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

