# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AddSkillGroupsToUserRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, skill_level_list=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.skill_level_list = skill_level_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddSkillGroupsToUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.skill_level_list is not None:
            result['SkillLevelList'] = self.skill_level_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('SkillLevelList') is not None:
            self.skill_level_list = m.get('SkillLevelList')
        return self


class AddSkillGroupsToUserResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddSkillGroupsToUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        return self


class AddSkillGroupsToUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddSkillGroupsToUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddSkillGroupsToUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddSkillGroupsToUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SaveWebRTCStatsRequest(TeaModel):
    def __init__(self, instance_id=None, call_id=None, general_info=None, sender_report=None, receiver_report=None,
                 goog_address=None):
        self.instance_id = instance_id  # type: str
        self.call_id = call_id  # type: str
        self.general_info = general_info  # type: str
        self.sender_report = sender_report  # type: str
        self.receiver_report = receiver_report  # type: str
        self.goog_address = goog_address  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SaveWebRTCStatsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.general_info is not None:
            result['GeneralInfo'] = self.general_info
        if self.sender_report is not None:
            result['SenderReport'] = self.sender_report
        if self.receiver_report is not None:
            result['ReceiverReport'] = self.receiver_report
        if self.goog_address is not None:
            result['GoogAddress'] = self.goog_address
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('GeneralInfo') is not None:
            self.general_info = m.get('GeneralInfo')
        if m.get('SenderReport') is not None:
            self.sender_report = m.get('SenderReport')
        if m.get('ReceiverReport') is not None:
            self.receiver_report = m.get('ReceiverReport')
        if m.get('GoogAddress') is not None:
            self.goog_address = m.get('GoogAddress')
        return self


class SaveWebRTCStatsResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, success=None, code=None, message=None,
                 time_stamp=None, row_count=None):
        self.http_status_code = http_status_code  # type: long
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.message = message  # type: str
        self.time_stamp = time_stamp  # type: long
        self.row_count = row_count  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(SaveWebRTCStatsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.row_count is not None:
            result['RowCount'] = self.row_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('RowCount') is not None:
            self.row_count = m.get('RowCount')
        return self


class SaveWebRTCStatsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SaveWebRTCStatsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SaveWebRTCStatsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SaveWebRTCStatsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMonoRecordingRequest(TeaModel):
    def __init__(self, instance_id=None, contact_id=None):
        self.instance_id = instance_id  # type: str
        self.contact_id = contact_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMonoRecordingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        return self


class GetMonoRecordingResponseBodyData(TeaModel):
    def __init__(self, file_url=None, file_name=None):
        self.file_url = file_url  # type: str
        self.file_name = file_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMonoRecordingResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.file_name is not None:
            result['FileName'] = self.file_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        return self


class GetMonoRecordingResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: GetMonoRecordingResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMonoRecordingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetMonoRecordingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMonoRecordingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMonoRecordingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMonoRecordingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMonoRecordingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUsersRequest(TeaModel):
    def __init__(self, instance_id=None, search_pattern=None, page_number=None, page_size=None):
        self.instance_id = instance_id  # type: str
        self.search_pattern = search_pattern  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUsersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListUsersResponseBodyDataListPersonalOutboundNumberList(TeaModel):
    def __init__(self, number=None, active=None, city=None, usage=None, province=None):
        self.number = number  # type: str
        self.active = active  # type: bool
        self.city = city  # type: str
        self.usage = usage  # type: str
        self.province = province  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUsersResponseBodyDataListPersonalOutboundNumberList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.number is not None:
            result['Number'] = self.number
        if self.active is not None:
            result['Active'] = self.active
        if self.city is not None:
            result['City'] = self.city
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class ListUsersResponseBodyDataListSkillLevelList(TeaModel):
    def __init__(self, skill_level=None, skill_group_id=None, skill_group_name=None):
        self.skill_level = skill_level  # type: int
        self.skill_group_id = skill_group_id  # type: str
        self.skill_group_name = skill_group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUsersResponseBodyDataListSkillLevelList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.skill_level is not None:
            result['SkillLevel'] = self.skill_level
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SkillLevel') is not None:
            self.skill_level = m.get('SkillLevel')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        return self


class ListUsersResponseBodyDataList(TeaModel):
    def __init__(self, display_name=None, login_name=None, email=None, work_mode=None, mobile=None, user_id=None,
                 role_name=None, role_id=None, primary_account=None, personal_outbound_number_list=None,
                 skill_level_list=None):
        self.display_name = display_name  # type: str
        self.login_name = login_name  # type: str
        self.email = email  # type: str
        self.work_mode = work_mode  # type: str
        self.mobile = mobile  # type: str
        self.user_id = user_id  # type: str
        self.role_name = role_name  # type: str
        self.role_id = role_id  # type: str
        self.primary_account = primary_account  # type: bool
        self.personal_outbound_number_list = personal_outbound_number_list  # type: list[ListUsersResponseBodyDataListPersonalOutboundNumberList]
        self.skill_level_list = skill_level_list  # type: list[ListUsersResponseBodyDataListSkillLevelList]

    def validate(self):
        if self.personal_outbound_number_list:
            for k in self.personal_outbound_number_list:
                if k:
                    k.validate()
        if self.skill_level_list:
            for k in self.skill_level_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListUsersResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.email is not None:
            result['Email'] = self.email
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.primary_account is not None:
            result['PrimaryAccount'] = self.primary_account
        result['PersonalOutboundNumberList'] = []
        if self.personal_outbound_number_list is not None:
            for k in self.personal_outbound_number_list:
                result['PersonalOutboundNumberList'].append(k.to_map() if k else None)
        result['SkillLevelList'] = []
        if self.skill_level_list is not None:
            for k in self.skill_level_list:
                result['SkillLevelList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('PrimaryAccount') is not None:
            self.primary_account = m.get('PrimaryAccount')
        self.personal_outbound_number_list = []
        if m.get('PersonalOutboundNumberList') is not None:
            for k in m.get('PersonalOutboundNumberList'):
                temp_model = ListUsersResponseBodyDataListPersonalOutboundNumberList()
                self.personal_outbound_number_list.append(temp_model.from_map(k))
        self.skill_level_list = []
        if m.get('SkillLevelList') is not None:
            for k in m.get('SkillLevelList'):
                temp_model = ListUsersResponseBodyDataListSkillLevelList()
                self.skill_level_list.append(temp_model.from_map(k))
        return self


class ListUsersResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListUsersResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListUsersResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListUsersResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListUsersResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: ListUsersResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListUsersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = ListUsersResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListUsersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListUsersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListUsersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAgentStateLogsRequest(TeaModel):
    def __init__(self, start_time=None, end_time=None, agent_id=None, instance_id=None):
        self.start_time = start_time  # type: long
        self.end_time = end_time  # type: long
        self.agent_id = agent_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAgentStateLogsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListAgentStateLogsResponseBodyData(TeaModel):
    def __init__(self, start_time=None, state_code=None, duration=None, state=None):
        self.start_time = start_time  # type: long
        self.state_code = state_code  # type: str
        self.duration = duration  # type: long
        self.state = state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAgentStateLogsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state_code is not None:
            result['StateCode'] = self.state_code
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StateCode') is not None:
            self.state_code = m.get('StateCode')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListAgentStateLogsResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: list[ListAgentStateLogsResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAgentStateLogsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListAgentStateLogsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListAgentStateLogsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListAgentStateLogsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAgentStateLogsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAgentStateLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemovePhoneNumberFromSkillGroupsRequest(TeaModel):
    def __init__(self, instance_id=None, number=None, skill_group_id_list=None):
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str
        self.skill_group_id_list = skill_group_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemovePhoneNumberFromSkillGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        return self


class RemovePhoneNumberFromSkillGroupsResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemovePhoneNumberFromSkillGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RemovePhoneNumberFromSkillGroupsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemovePhoneNumberFromSkillGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemovePhoneNumberFromSkillGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemovePhoneNumberFromSkillGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPhoneNumbersRequest(TeaModel):
    def __init__(self, instance_id=None, search_pattern=None, usage=None, active=None, page_number=None,
                 page_size=None):
        self.instance_id = instance_id  # type: str
        self.search_pattern = search_pattern  # type: str
        self.usage = usage  # type: str
        self.active = active  # type: bool
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPhoneNumbersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.active is not None:
            result['Active'] = self.active
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListPhoneNumbersResponseBodyDataListSkillGroups(TeaModel):
    def __init__(self, display_name=None, instance_id=None, name=None, skill_group_id=None):
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPhoneNumbersResponseBodyDataListSkillGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class ListPhoneNumbersResponseBodyDataList(TeaModel):
    def __init__(self, active=None, create_time=None, user_id=None, tags=None, city=None, instance_id=None,
                 usage=None, contact_flow_name=None, provider=None, number=None, contact_flow_id=None, province=None,
                 skill_groups=None):
        self.active = active  # type: bool
        self.create_time = create_time  # type: str
        self.user_id = user_id  # type: str
        self.tags = tags  # type: str
        self.city = city  # type: str
        self.instance_id = instance_id  # type: str
        self.usage = usage  # type: str
        self.contact_flow_name = contact_flow_name  # type: str
        self.provider = provider  # type: str
        self.number = number  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.province = province  # type: str
        self.skill_groups = skill_groups  # type: list[ListPhoneNumbersResponseBodyDataListSkillGroups]

    def validate(self):
        if self.skill_groups:
            for k in self.skill_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPhoneNumbersResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.city is not None:
            result['City'] = self.city
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.contact_flow_name is not None:
            result['ContactFlowName'] = self.contact_flow_name
        if self.provider is not None:
            result['Provider'] = self.provider
        if self.number is not None:
            result['Number'] = self.number
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.province is not None:
            result['Province'] = self.province
        result['SkillGroups'] = []
        if self.skill_groups is not None:
            for k in self.skill_groups:
                result['SkillGroups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('ContactFlowName') is not None:
            self.contact_flow_name = m.get('ContactFlowName')
        if m.get('Provider') is not None:
            self.provider = m.get('Provider')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        self.skill_groups = []
        if m.get('SkillGroups') is not None:
            for k in m.get('SkillGroups'):
                temp_model = ListPhoneNumbersResponseBodyDataListSkillGroups()
                self.skill_groups.append(temp_model.from_map(k))
        return self


class ListPhoneNumbersResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListPhoneNumbersResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPhoneNumbersResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListPhoneNumbersResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListPhoneNumbersResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, code=None, message=None, page_number=None,
                 page_size=None, data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.code = code  # type: str
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.data = data  # type: ListPhoneNumbersResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListPhoneNumbersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Data') is not None:
            temp_model = ListPhoneNumbersResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListPhoneNumbersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListPhoneNumbersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPhoneNumbersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListPhoneNumbersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddNumbersToSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, number_list=None):
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.number_list = number_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddNumbersToSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        return self


class AddNumbersToSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddNumbersToSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddNumbersToSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddNumbersToSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddNumbersToSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddNumbersToSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ResetAgentStateRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ResetAgentStateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        return self


class ResetAgentStateResponseBodyData(TeaModel):
    def __init__(self, extension=None, work_mode=None, device_id=None, job_id=None, user_id=None, break_code=None,
                 instance_id=None, outbound_scenario=None, user_state=None, signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ResetAgentStateResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class ResetAgentStateResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: ResetAgentStateResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ResetAgentStateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = ResetAgentStateResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ResetAgentStateResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ResetAgentStateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ResetAgentStateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ResetAgentStateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeWorkModeRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, work_mode=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeWorkModeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class ChangeWorkModeResponseBodyData(TeaModel):
    def __init__(self, extension=None, work_mode=None, device_id=None, job_id=None, user_id=None, break_code=None,
                 instance_id=None, outbound_scenario=None, user_state=None, signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeWorkModeResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class ChangeWorkModeResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: ChangeWorkModeResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ChangeWorkModeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = ChangeWorkModeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ChangeWorkModeResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ChangeWorkModeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ChangeWorkModeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ChangeWorkModeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTurnCredentialsRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTurnCredentialsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetTurnCredentialsResponseBodyData(TeaModel):
    def __init__(self, user_name=None, password=None):
        self.user_name = user_name  # type: str
        self.password = password  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTurnCredentialsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.password is not None:
            result['Password'] = self.password
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        return self


class GetTurnCredentialsResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: GetTurnCredentialsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetTurnCredentialsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = GetTurnCredentialsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetTurnCredentialsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetTurnCredentialsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTurnCredentialsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetTurnCredentialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPhoneNumbersRequest(TeaModel):
    def __init__(self, instance_id=None, contact_flow_id=None, usage=None, number_list=None, number_group_id=None):
        self.instance_id = instance_id  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.usage = usage  # type: str
        self.number_list = number_list  # type: str
        self.number_group_id = number_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPhoneNumbersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        if self.number_group_id is not None:
            result['NumberGroupId'] = self.number_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        if m.get('NumberGroupId') is not None:
            self.number_group_id = m.get('NumberGroupId')
        return self


class AddPhoneNumbersResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPhoneNumbersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class AddPhoneNumbersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddPhoneNumbersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPhoneNumbersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddPhoneNumbersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SaveWebRtcInfoRequest(TeaModel):
    def __init__(self, instance_id=None, call_id=None, job_id=None, content_type=None, content=None):
        self.instance_id = instance_id  # type: str
        self.call_id = call_id  # type: str
        self.job_id = job_id  # type: str
        self.content_type = content_type  # type: str
        self.content = content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SaveWebRtcInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ContentType') is not None:
            self.content_type = m.get('ContentType')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class SaveWebRtcInfoResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, success=None, code=None, message=None,
                 time_stamp=None, row_count=None):
        self.http_status_code = http_status_code  # type: long
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.message = message  # type: str
        self.time_stamp = time_stamp  # type: long
        self.row_count = row_count  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(SaveWebRtcInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.row_count is not None:
            result['RowCount'] = self.row_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('RowCount') is not None:
            self.row_count = m.get('RowCount')
        return self


class SaveWebRtcInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SaveWebRtcInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SaveWebRtcInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SaveWebRtcInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIntervalSkillGroupReportRequest(TeaModel):
    def __init__(self, skill_group_id=None, instance_id=None, start_time=None, end_time=None, interval=None):
        self.skill_group_id = skill_group_id  # type: str
        self.instance_id = instance_id  # type: str
        self.start_time = start_time  # type: long
        self.end_time = end_time  # type: long
        self.interval = interval  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalSkillGroupReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        return self


class ListIntervalSkillGroupReportResponseBodyDataInbound(TeaModel):
    def __init__(self, average_ring_time=None, calls_overflow=None, calls_abandoned_in_ring=None,
                 calls_handled=None, total_work_time=None, total_abandoned_in_ring_time=None, max_work_time=None,
                 calls_attended_transfer_out=None, average_wait_time=None, total_hold_time=None, max_abandon_time=None, average_work_time=None,
                 calls_queued=None, calls_blind_transfer_in=None, satisfaction_index=None, average_abandoned_in_ring_time=None,
                 average_abandon_time=None, calls_ringed=None, calls_blind_transfer_out=None, calls_attended_transfer_in=None,
                 calls_abandoned=None, max_abandoned_in_queue_time=None, total_wait_time=None, total_ring_time=None,
                 max_talk_time=None, max_ring_time=None, abandon_rate=None, total_talk_time=None, total_abandon_time=None,
                 calls_offered=None, max_abandoned_in_ring_time=None, max_wait_time=None, average_abandoned_in_queue_time=None,
                 service_level_20=None, max_hold_time=None, satisfaction_rate=None, average_talk_time=None, calls_hold=None,
                 satisfaction_surveys_offered=None, handle_rate=None, calls_timeout=None, satisfaction_surveys_responded=None,
                 average_hold_time=None, total_abandoned_in_queue_time=None, calls_abandoned_in_queue=None):
        self.average_ring_time = average_ring_time  # type: float
        self.calls_overflow = calls_overflow  # type: long
        self.calls_abandoned_in_ring = calls_abandoned_in_ring  # type: long
        self.calls_handled = calls_handled  # type: long
        self.total_work_time = total_work_time  # type: long
        self.total_abandoned_in_ring_time = total_abandoned_in_ring_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.average_wait_time = average_wait_time  # type: float
        self.total_hold_time = total_hold_time  # type: long
        self.max_abandon_time = max_abandon_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.calls_queued = calls_queued  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.average_abandoned_in_ring_time = average_abandoned_in_ring_time  # type: float
        self.average_abandon_time = average_abandon_time  # type: float
        self.calls_ringed = calls_ringed  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_abandoned = calls_abandoned  # type: long
        self.max_abandoned_in_queue_time = max_abandoned_in_queue_time  # type: long
        self.total_wait_time = total_wait_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.abandon_rate = abandon_rate  # type: float
        self.total_talk_time = total_talk_time  # type: long
        self.total_abandon_time = total_abandon_time  # type: long
        self.calls_offered = calls_offered  # type: long
        self.max_abandoned_in_ring_time = max_abandoned_in_ring_time  # type: long
        self.max_wait_time = max_wait_time  # type: long
        self.average_abandoned_in_queue_time = average_abandoned_in_queue_time  # type: float
        self.service_level_20 = service_level_20  # type: float
        self.max_hold_time = max_hold_time  # type: long
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.calls_hold = calls_hold  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.handle_rate = handle_rate  # type: float
        self.calls_timeout = calls_timeout  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_hold_time = average_hold_time  # type: float
        self.total_abandoned_in_queue_time = total_abandoned_in_queue_time  # type: long
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalSkillGroupReportResponseBodyDataInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_overflow is not None:
            result['CallsOverflow'] = self.calls_overflow
        if self.calls_abandoned_in_ring is not None:
            result['CallsAbandonedInRing'] = self.calls_abandoned_in_ring
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.total_abandoned_in_ring_time is not None:
            result['TotalAbandonedInRingTime'] = self.total_abandoned_in_ring_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.average_wait_time is not None:
            result['AverageWaitTime'] = self.average_wait_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.max_abandon_time is not None:
            result['MaxAbandonTime'] = self.max_abandon_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_queued is not None:
            result['CallsQueued'] = self.calls_queued
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.average_abandoned_in_ring_time is not None:
            result['AverageAbandonedInRingTime'] = self.average_abandoned_in_ring_time
        if self.average_abandon_time is not None:
            result['AverageAbandonTime'] = self.average_abandon_time
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_abandoned is not None:
            result['CallsAbandoned'] = self.calls_abandoned
        if self.max_abandoned_in_queue_time is not None:
            result['MaxAbandonedInQueueTime'] = self.max_abandoned_in_queue_time
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.abandon_rate is not None:
            result['AbandonRate'] = self.abandon_rate
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_abandon_time is not None:
            result['TotalAbandonTime'] = self.total_abandon_time
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.max_abandoned_in_ring_time is not None:
            result['MaxAbandonedInRingTime'] = self.max_abandoned_in_ring_time
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.average_abandoned_in_queue_time is not None:
            result['AverageAbandonedInQueueTime'] = self.average_abandoned_in_queue_time
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.calls_timeout is not None:
            result['CallsTimeout'] = self.calls_timeout
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.total_abandoned_in_queue_time is not None:
            result['TotalAbandonedInQueueTime'] = self.total_abandoned_in_queue_time
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsOverflow') is not None:
            self.calls_overflow = m.get('CallsOverflow')
        if m.get('CallsAbandonedInRing') is not None:
            self.calls_abandoned_in_ring = m.get('CallsAbandonedInRing')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('TotalAbandonedInRingTime') is not None:
            self.total_abandoned_in_ring_time = m.get('TotalAbandonedInRingTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('AverageWaitTime') is not None:
            self.average_wait_time = m.get('AverageWaitTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('MaxAbandonTime') is not None:
            self.max_abandon_time = m.get('MaxAbandonTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsQueued') is not None:
            self.calls_queued = m.get('CallsQueued')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('AverageAbandonedInRingTime') is not None:
            self.average_abandoned_in_ring_time = m.get('AverageAbandonedInRingTime')
        if m.get('AverageAbandonTime') is not None:
            self.average_abandon_time = m.get('AverageAbandonTime')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAbandoned') is not None:
            self.calls_abandoned = m.get('CallsAbandoned')
        if m.get('MaxAbandonedInQueueTime') is not None:
            self.max_abandoned_in_queue_time = m.get('MaxAbandonedInQueueTime')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('AbandonRate') is not None:
            self.abandon_rate = m.get('AbandonRate')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalAbandonTime') is not None:
            self.total_abandon_time = m.get('TotalAbandonTime')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('MaxAbandonedInRingTime') is not None:
            self.max_abandoned_in_ring_time = m.get('MaxAbandonedInRingTime')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('AverageAbandonedInQueueTime') is not None:
            self.average_abandoned_in_queue_time = m.get('AverageAbandonedInQueueTime')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('CallsTimeout') is not None:
            self.calls_timeout = m.get('CallsTimeout')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('TotalAbandonedInQueueTime') is not None:
            self.total_abandoned_in_queue_time = m.get('TotalAbandonedInQueueTime')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        return self


class ListIntervalSkillGroupReportResponseBodyDataOutbound(TeaModel):
    def __init__(self, average_ring_time=None, calls_dialed=None, calls_answered=None, total_work_time=None,
                 calls_attended_transfer_out=None, max_work_time=None, total_dialing_time=None, total_hold_time=None, average_work_time=None,
                 calls_blind_transfer_in=None, satisfaction_index=None, calls_ringed=None, calls_attended_transfer_in=None,
                 calls_blind_transfer_out=None, total_ring_time=None, max_talk_time=None, max_ring_time=None, total_talk_time=None,
                 max_dialing_time=None, answer_rate=None, max_hold_time=None, average_talk_time=None, satisfaction_rate=None,
                 calls_hold=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 average_hold_time=None, average_dialing_time=None):
        self.average_ring_time = average_ring_time  # type: float
        self.calls_dialed = calls_dialed  # type: long
        self.calls_answered = calls_answered  # type: long
        self.total_work_time = total_work_time  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.max_work_time = max_work_time  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.calls_ringed = calls_ringed  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.answer_rate = answer_rate  # type: float
        self.max_hold_time = max_hold_time  # type: long
        self.average_talk_time = average_talk_time  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.calls_hold = calls_hold  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_hold_time = average_hold_time  # type: float
        self.average_dialing_time = average_dialing_time  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalSkillGroupReportResponseBodyDataOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        return self


class ListIntervalSkillGroupReportResponseBodyDataOverall(TeaModel):
    def __init__(self, total_talk_time=None, total_logged_in_time=None, occupancy_rate=None, total_work_time=None,
                 max_hold_time=None, max_work_time=None, average_break_time=None, total_hold_time=None, satisfaction_rate=None,
                 max_break_time=None, average_work_time=None, average_talk_time=None, satisfaction_index=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, max_ready_time=None, average_ready_time=None,
                 average_hold_time=None, total_ready_time=None, total_break_time=None, max_talk_time=None, total_calls=None):
        self.total_talk_time = total_talk_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.total_work_time = total_work_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_break_time = average_break_time  # type: float
        self.total_hold_time = total_hold_time  # type: long
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.max_break_time = max_break_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.average_ready_time = average_ready_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.total_ready_time = total_ready_time  # type: long
        self.total_break_time = total_break_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalSkillGroupReportResponseBodyDataOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class ListIntervalSkillGroupReportResponseBodyData(TeaModel):
    def __init__(self, stats_time=None, inbound=None, outbound=None, overall=None):
        self.stats_time = stats_time  # type: long
        self.inbound = inbound  # type: ListIntervalSkillGroupReportResponseBodyDataInbound
        self.outbound = outbound  # type: ListIntervalSkillGroupReportResponseBodyDataOutbound
        self.overall = overall  # type: ListIntervalSkillGroupReportResponseBodyDataOverall

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(ListIntervalSkillGroupReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stats_time is not None:
            result['StatsTime'] = self.stats_time
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StatsTime') is not None:
            self.stats_time = m.get('StatsTime')
        if m.get('Inbound') is not None:
            temp_model = ListIntervalSkillGroupReportResponseBodyDataInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = ListIntervalSkillGroupReportResponseBodyDataOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = ListIntervalSkillGroupReportResponseBodyDataOverall()
            self.overall = temp_model.from_map(m['Overall'])
        return self


class ListIntervalSkillGroupReportResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: list[ListIntervalSkillGroupReportResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListIntervalSkillGroupReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListIntervalSkillGroupReportResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListIntervalSkillGroupReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListIntervalSkillGroupReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListIntervalSkillGroupReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListIntervalSkillGroupReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MonitorCallRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, monitored_user_id=None, timeout_seconds=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.monitored_user_id = monitored_user_id  # type: str
        self.timeout_seconds = timeout_seconds  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(MonitorCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.monitored_user_id is not None:
            result['MonitoredUserId'] = self.monitored_user_id
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('MonitoredUserId') is not None:
            self.monitored_user_id = m.get('MonitoredUserId')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        return self


class MonitorCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, index=None, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, skill_group_id=None, timestamp=None, associated_data=None, release_reason=None,
                 call_type=None, job_id=None, channel_id=None, user_extension=None, originator=None):
        self.index = index  # type: int
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.user_extension = user_extension  # type: str
        self.originator = originator  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MonitorCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.originator is not None:
            result['Originator'] = self.originator
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        return self


class MonitorCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[MonitorCallResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(MonitorCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = MonitorCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class MonitorCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(MonitorCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class MonitorCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: MonitorCallResponseBodyDataCallContext
        self.user_context = user_context  # type: MonitorCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(MonitorCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = MonitorCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = MonitorCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class MonitorCallResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: MonitorCallResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(MonitorCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = MonitorCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class MonitorCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: MonitorCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(MonitorCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = MonitorCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveUsersFromSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, user_id_list=None):
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.user_id_list = user_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveUsersFromSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.user_id_list is not None:
            result['UserIdList'] = self.user_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('UserIdList') is not None:
            self.user_id_list = m.get('UserIdList')
        return self


class RemoveUsersFromSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveUsersFromSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RemoveUsersFromSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemoveUsersFromSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveUsersFromSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemoveUsersFromSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, force=None):
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.force = force  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.force is not None:
            result['Force'] = self.force
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        return self


class DeleteSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BlindTransferRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, transferor=None, transferee=None,
                 timeout_seconds=None, job_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.transferor = transferor  # type: str
        self.transferee = transferee  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BlindTransferRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.transferor is not None:
            result['Transferor'] = self.transferor
        if self.transferee is not None:
            result['Transferee'] = self.transferee
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Transferor') is not None:
            self.transferor = m.get('Transferor')
        if m.get('Transferee') is not None:
            self.transferee = m.get('Transferee')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class BlindTransferResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, timestamp=None, associated_data=None, release_reason=None, call_type=None, job_id=None,
                 channel_id=None, originator=None, user_extension=None):
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.originator = originator  # type: str
        self.user_extension = user_extension  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BlindTransferResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        return self


class BlindTransferResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[BlindTransferResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BlindTransferResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = BlindTransferResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class BlindTransferResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BlindTransferResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class BlindTransferResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: BlindTransferResponseBodyDataCallContext
        self.user_context = user_context  # type: BlindTransferResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(BlindTransferResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = BlindTransferResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = BlindTransferResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class BlindTransferResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: BlindTransferResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BlindTransferResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = BlindTransferResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BlindTransferResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BlindTransferResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BlindTransferResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BlindTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSkillLevelsOfUserRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, is_member=None, page_number=None, page_size=None,
                 search_pattern=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.is_member = is_member  # type: bool
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.search_pattern = search_pattern  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSkillLevelsOfUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.is_member is not None:
            result['IsMember'] = self.is_member
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('IsMember') is not None:
            self.is_member = m.get('IsMember')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        return self


class ListSkillLevelsOfUserResponseBodyDataList(TeaModel):
    def __init__(self, skill_level=None, skill_group_id=None, skill_group_name=None):
        self.skill_level = skill_level  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.skill_group_name = skill_group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSkillLevelsOfUserResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.skill_level is not None:
            result['SkillLevel'] = self.skill_level
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SkillLevel') is not None:
            self.skill_level = m.get('SkillLevel')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        return self


class ListSkillLevelsOfUserResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListSkillLevelsOfUserResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListSkillLevelsOfUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListSkillLevelsOfUserResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListSkillLevelsOfUserResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: ListSkillLevelsOfUserResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListSkillLevelsOfUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListSkillLevelsOfUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListSkillLevelsOfUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListSkillLevelsOfUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListSkillLevelsOfUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListSkillLevelsOfUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUnassignedNumbersRequest(TeaModel):
    def __init__(self, search_pattern=None, page_number=None, page_size=None, instance_id=None):
        self.search_pattern = search_pattern  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUnassignedNumbersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListUnassignedNumbersResponseBodyDataList(TeaModel):
    def __init__(self, number=None, active=None, city=None, usage=None, province=None):
        self.number = number  # type: str
        self.active = active  # type: bool
        self.city = city  # type: str
        self.usage = usage  # type: bool
        self.province = province  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUnassignedNumbersResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.number is not None:
            result['Number'] = self.number
        if self.active is not None:
            result['Active'] = self.active
        if self.city is not None:
            result['City'] = self.city
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class ListUnassignedNumbersResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListUnassignedNumbersResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListUnassignedNumbersResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListUnassignedNumbersResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListUnassignedNumbersResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: ListUnassignedNumbersResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListUnassignedNumbersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListUnassignedNumbersResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListUnassignedNumbersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListUnassignedNumbersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListUnassignedNumbersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListUnassignedNumbersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceTrendingReportRequest(TeaModel):
    def __init__(self, instance_id=None, start_time=None, end_time=None):
        self.instance_id = instance_id  # type: str
        self.start_time = start_time  # type: long
        self.end_time = end_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceTrendingReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class GetInstanceTrendingReportResponseBodyDataInbound(TeaModel):
    def __init__(self, stats_time=None, calls_queued=None, calls_abandoned_in_ring=None, calls_handled=None,
                 total_calls=None, calls_abandoned_in_ivr=None, calls_abandoned_in_queue=None):
        self.stats_time = stats_time  # type: long
        self.calls_queued = calls_queued  # type: long
        self.calls_abandoned_in_ring = calls_abandoned_in_ring  # type: long
        self.calls_handled = calls_handled  # type: long
        self.total_calls = total_calls  # type: long
        self.calls_abandoned_in_ivr = calls_abandoned_in_ivr  # type: long
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponseBodyDataInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stats_time is not None:
            result['StatsTime'] = self.stats_time
        if self.calls_queued is not None:
            result['CallsQueued'] = self.calls_queued
        if self.calls_abandoned_in_ring is not None:
            result['CallsAbandonedInRing'] = self.calls_abandoned_in_ring
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        if self.calls_abandoned_in_ivr is not None:
            result['CallsAbandonedInIVR'] = self.calls_abandoned_in_ivr
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StatsTime') is not None:
            self.stats_time = m.get('StatsTime')
        if m.get('CallsQueued') is not None:
            self.calls_queued = m.get('CallsQueued')
        if m.get('CallsAbandonedInRing') is not None:
            self.calls_abandoned_in_ring = m.get('CallsAbandonedInRing')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        if m.get('CallsAbandonedInIVR') is not None:
            self.calls_abandoned_in_ivr = m.get('CallsAbandonedInIVR')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        return self


class GetInstanceTrendingReportResponseBodyDataOutbound(TeaModel):
    def __init__(self, stats_time=None, calls_answered=None, total_calls=None):
        self.stats_time = stats_time  # type: long
        self.calls_answered = calls_answered  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponseBodyDataOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stats_time is not None:
            result['StatsTime'] = self.stats_time
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StatsTime') is not None:
            self.stats_time = m.get('StatsTime')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class GetInstanceTrendingReportResponseBodyData(TeaModel):
    def __init__(self, inbound=None, outbound=None):
        self.inbound = inbound  # type: list[GetInstanceTrendingReportResponseBodyDataInbound]
        self.outbound = outbound  # type: list[GetInstanceTrendingReportResponseBodyDataOutbound]

    def validate(self):
        if self.inbound:
            for k in self.inbound:
                if k:
                    k.validate()
        if self.outbound:
            for k in self.outbound:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Inbound'] = []
        if self.inbound is not None:
            for k in self.inbound:
                result['Inbound'].append(k.to_map() if k else None)
        result['Outbound'] = []
        if self.outbound is not None:
            for k in self.outbound:
                result['Outbound'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.inbound = []
        if m.get('Inbound') is not None:
            for k in m.get('Inbound'):
                temp_model = GetInstanceTrendingReportResponseBodyDataInbound()
                self.inbound.append(temp_model.from_map(k))
        self.outbound = []
        if m.get('Outbound') is not None:
            for k in m.get('Outbound'):
                temp_model = GetInstanceTrendingReportResponseBodyDataOutbound()
                self.outbound.append(temp_model.from_map(k))
        return self


class GetInstanceTrendingReportResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: GetInstanceTrendingReportResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetInstanceTrendingReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetInstanceTrendingReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetInstanceTrendingReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceTrendingReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInstancesOfUserRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesOfUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListInstancesOfUserResponseBodyDataListAdminList(TeaModel):
    def __init__(self, display_name=None, extension=None, login_name=None, email=None, work_mode=None, mobile=None,
                 user_id=None, role_name=None, instance_id=None, role_id=None):
        self.display_name = display_name  # type: str
        self.extension = extension  # type: str
        self.login_name = login_name  # type: str
        self.email = email  # type: str
        self.work_mode = work_mode  # type: str
        self.mobile = mobile  # type: str
        self.user_id = user_id  # type: str
        self.role_name = role_name  # type: str
        self.instance_id = instance_id  # type: str
        self.role_id = role_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBodyDataListAdminList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.email is not None:
            result['Email'] = self.email
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        return self


class ListInstancesOfUserResponseBodyDataListNumberListSkillGroups(TeaModel):
    def __init__(self, display_name=None, description=None, phone_number_count=None, skill_group_id=None,
                 user_count=None, instance_id=None, name=None):
        self.display_name = display_name  # type: str
        self.description = description  # type: str
        self.phone_number_count = phone_number_count  # type: int
        self.skill_group_id = skill_group_id  # type: str
        self.user_count = user_count  # type: int
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBodyDataListNumberListSkillGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.description is not None:
            result['Description'] = self.description
        if self.phone_number_count is not None:
            result['PhoneNumberCount'] = self.phone_number_count
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('PhoneNumberCount') is not None:
            self.phone_number_count = m.get('PhoneNumberCount')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ListInstancesOfUserResponseBodyDataListNumberList(TeaModel):
    def __init__(self, active=None, user_id=None, number=None, city=None, instance_id=None, usage=None,
                 contact_flow_id=None, province=None, skill_groups=None):
        self.active = active  # type: bool
        self.user_id = user_id  # type: str
        self.number = number  # type: str
        self.city = city  # type: str
        self.instance_id = instance_id  # type: str
        self.usage = usage  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.province = province  # type: str
        self.skill_groups = skill_groups  # type: list[ListInstancesOfUserResponseBodyDataListNumberListSkillGroups]

    def validate(self):
        if self.skill_groups:
            for k in self.skill_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBodyDataListNumberList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.number is not None:
            result['Number'] = self.number
        if self.city is not None:
            result['City'] = self.city
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.province is not None:
            result['Province'] = self.province
        result['SkillGroups'] = []
        if self.skill_groups is not None:
            for k in self.skill_groups:
                result['SkillGroups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        self.skill_groups = []
        if m.get('SkillGroups') is not None:
            for k in m.get('SkillGroups'):
                temp_model = ListInstancesOfUserResponseBodyDataListNumberListSkillGroups()
                self.skill_groups.append(temp_model.from_map(k))
        return self


class ListInstancesOfUserResponseBodyDataList(TeaModel):
    def __init__(self, status=None, console_url=None, description=None, aliyun_uid=None, name=None, domain_name=None,
                 id=None, admin_list=None, number_list=None):
        self.status = status  # type: str
        self.console_url = console_url  # type: str
        self.description = description  # type: str
        self.aliyun_uid = aliyun_uid  # type: str
        self.name = name  # type: str
        self.domain_name = domain_name  # type: str
        self.id = id  # type: str
        self.admin_list = admin_list  # type: list[ListInstancesOfUserResponseBodyDataListAdminList]
        self.number_list = number_list  # type: list[ListInstancesOfUserResponseBodyDataListNumberList]

    def validate(self):
        if self.admin_list:
            for k in self.admin_list:
                if k:
                    k.validate()
        if self.number_list:
            for k in self.number_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.console_url is not None:
            result['ConsoleUrl'] = self.console_url
        if self.description is not None:
            result['Description'] = self.description
        if self.aliyun_uid is not None:
            result['AliyunUid'] = self.aliyun_uid
        if self.name is not None:
            result['Name'] = self.name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.id is not None:
            result['Id'] = self.id
        result['AdminList'] = []
        if self.admin_list is not None:
            for k in self.admin_list:
                result['AdminList'].append(k.to_map() if k else None)
        result['NumberList'] = []
        if self.number_list is not None:
            for k in self.number_list:
                result['NumberList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ConsoleUrl') is not None:
            self.console_url = m.get('ConsoleUrl')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('AliyunUid') is not None:
            self.aliyun_uid = m.get('AliyunUid')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        self.admin_list = []
        if m.get('AdminList') is not None:
            for k in m.get('AdminList'):
                temp_model = ListInstancesOfUserResponseBodyDataListAdminList()
                self.admin_list.append(temp_model.from_map(k))
        self.number_list = []
        if m.get('NumberList') is not None:
            for k in m.get('NumberList'):
                temp_model = ListInstancesOfUserResponseBodyDataListNumberList()
                self.number_list.append(temp_model.from_map(k))
        return self


class ListInstancesOfUserResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListInstancesOfUserResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListInstancesOfUserResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListInstancesOfUserResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: ListInstancesOfUserResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = ListInstancesOfUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListInstancesOfUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListInstancesOfUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListInstancesOfUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListInstancesOfUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class LaunchSurveyRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, job_id=None, contact_flow_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.contact_flow_id = contact_flow_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchSurveyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        return self


class LaunchSurveyResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, index=None, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, skill_group_id=None, timestamp=None, associated_data=None, release_reason=None,
                 call_type=None, job_id=None, channel_id=None, user_extension=None, originator=None):
        self.index = index  # type: int
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.user_extension = user_extension  # type: str
        self.originator = originator  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchSurveyResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.originator is not None:
            result['Originator'] = self.originator
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        return self


class LaunchSurveyResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[LaunchSurveyResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(LaunchSurveyResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = LaunchSurveyResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class LaunchSurveyResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchSurveyResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class LaunchSurveyResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: LaunchSurveyResponseBodyDataCallContext
        self.user_context = user_context  # type: LaunchSurveyResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(LaunchSurveyResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = LaunchSurveyResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = LaunchSurveyResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class LaunchSurveyResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: LaunchSurveyResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(LaunchSurveyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = LaunchSurveyResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class LaunchSurveyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: LaunchSurveyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(LaunchSurveyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = LaunchSurveyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIvrTrackingDetailsRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, contact_id=None, instance_id=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.contact_id = contact_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIvrTrackingDetailsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListIvrTrackingDetailsResponseBodyDataList(TeaModel):
    def __init__(self, instance=None, callee=None, enter_time=None, node_variables=None, node_exit_code=None,
                 flow_name=None, flow_id=None, node_properties=None, node_type=None, caller=None, node_name=None,
                 contact_id=None, leave_time=None, channel_variables=None, channel_id=None, node_id=None):
        self.instance = instance  # type: str
        self.callee = callee  # type: str
        self.enter_time = enter_time  # type: long
        self.node_variables = node_variables  # type: dict[str, any]
        self.node_exit_code = node_exit_code  # type: str
        self.flow_name = flow_name  # type: str
        self.flow_id = flow_id  # type: str
        self.node_properties = node_properties  # type: dict[str, any]
        self.node_type = node_type  # type: str
        self.caller = caller  # type: str
        self.node_name = node_name  # type: str
        self.contact_id = contact_id  # type: str
        self.leave_time = leave_time  # type: long
        self.channel_variables = channel_variables  # type: str
        self.channel_id = channel_id  # type: str
        self.node_id = node_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIvrTrackingDetailsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance is not None:
            result['Instance'] = self.instance
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.enter_time is not None:
            result['EnterTime'] = self.enter_time
        if self.node_variables is not None:
            result['NodeVariables'] = self.node_variables
        if self.node_exit_code is not None:
            result['NodeExitCode'] = self.node_exit_code
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.node_properties is not None:
            result['NodeProperties'] = self.node_properties
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.leave_time is not None:
            result['LeaveTime'] = self.leave_time
        if self.channel_variables is not None:
            result['ChannelVariables'] = self.channel_variables
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('EnterTime') is not None:
            self.enter_time = m.get('EnterTime')
        if m.get('NodeVariables') is not None:
            self.node_variables = m.get('NodeVariables')
        if m.get('NodeExitCode') is not None:
            self.node_exit_code = m.get('NodeExitCode')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('NodeProperties') is not None:
            self.node_properties = m.get('NodeProperties')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('LeaveTime') is not None:
            self.leave_time = m.get('LeaveTime')
        if m.get('ChannelVariables') is not None:
            self.channel_variables = m.get('ChannelVariables')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class ListIvrTrackingDetailsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListIvrTrackingDetailsResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListIvrTrackingDetailsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListIvrTrackingDetailsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListIvrTrackingDetailsResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: ListIvrTrackingDetailsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListIvrTrackingDetailsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListIvrTrackingDetailsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListIvrTrackingDetailsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListIvrTrackingDetailsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListIvrTrackingDetailsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListIvrTrackingDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBriefSkillGroupsRequest(TeaModel):
    def __init__(self, instance_id=None, search_pattern=None, page_number=None, page_size=None):
        self.instance_id = instance_id  # type: str
        self.search_pattern = search_pattern  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBriefSkillGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListBriefSkillGroupsResponseBodyDataList(TeaModel):
    def __init__(self, display_name=None, description=None, phone_number_count=None, skill_group_id=None,
                 skill_group_name=None, user_count=None, instance_id=None):
        self.display_name = display_name  # type: str
        self.description = description  # type: str
        self.phone_number_count = phone_number_count  # type: int
        self.skill_group_id = skill_group_id  # type: str
        self.skill_group_name = skill_group_name  # type: str
        self.user_count = user_count  # type: int
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBriefSkillGroupsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.description is not None:
            result['Description'] = self.description
        if self.phone_number_count is not None:
            result['PhoneNumberCount'] = self.phone_number_count
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('PhoneNumberCount') is not None:
            self.phone_number_count = m.get('PhoneNumberCount')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListBriefSkillGroupsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListBriefSkillGroupsResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListBriefSkillGroupsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListBriefSkillGroupsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListBriefSkillGroupsResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: ListBriefSkillGroupsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListBriefSkillGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListBriefSkillGroupsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListBriefSkillGroupsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListBriefSkillGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListBriefSkillGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListBriefSkillGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UnmuteCallRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, job_id=None, channel_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(UnmuteCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        return self


class UnmuteCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, index=None, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, skill_group_id=None, timestamp=None, associated_data=None, release_reason=None,
                 call_type=None, job_id=None, channel_id=None, user_extension=None, originator=None):
        self.index = index  # type: int
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.user_extension = user_extension  # type: str
        self.originator = originator  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(UnmuteCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.originator is not None:
            result['Originator'] = self.originator
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        return self


class UnmuteCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[UnmuteCallResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(UnmuteCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = UnmuteCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class UnmuteCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, heartbeat=None, extension=None, work_mode=None, mobile=None, device_id=None, job_id=None,
                 user_id=None, break_code=None, instance_id=None, outbound_scenario=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.heartbeat = heartbeat  # type: long
        self.extension = extension  # type: str
        self.work_mode = work_mode  # type: str
        self.mobile = mobile  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(UnmuteCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class UnmuteCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: UnmuteCallResponseBodyDataCallContext
        self.user_context = user_context  # type: UnmuteCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(UnmuteCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = UnmuteCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = UnmuteCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class UnmuteCallResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: UnmuteCallResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(UnmuteCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = UnmuteCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UnmuteCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: UnmuteCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(UnmuteCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UnmuteCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySkillLevelsOfUserRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, skill_level_list=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.skill_level_list = skill_level_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifySkillLevelsOfUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.skill_level_list is not None:
            result['SkillLevelList'] = self.skill_level_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('SkillLevelList') is not None:
            self.skill_level_list = m.get('SkillLevelList')
        return self


class ModifySkillLevelsOfUserResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifySkillLevelsOfUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        return self


class ModifySkillLevelsOfUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifySkillLevelsOfUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifySkillLevelsOfUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySkillLevelsOfUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssignUsersRequest(TeaModel):
    def __init__(self, instance_id=None, role_id=None, skill_level_list=None, ram_id_list=None, work_mode=None):
        self.instance_id = instance_id  # type: str
        self.role_id = role_id  # type: str
        self.skill_level_list = skill_level_list  # type: str
        self.ram_id_list = ram_id_list  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssignUsersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.skill_level_list is not None:
            result['SkillLevelList'] = self.skill_level_list
        if self.ram_id_list is not None:
            result['RamIdList'] = self.ram_id_list
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('SkillLevelList') is not None:
            self.skill_level_list = m.get('SkillLevelList')
        if m.get('RamIdList') is not None:
            self.ram_id_list = m.get('RamIdList')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class AssignUsersResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, request_id=None, sync=None, code=None, workflow_id=None,
                 message=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.sync = sync  # type: str
        self.code = code  # type: str
        self.workflow_id = workflow_id  # type: str
        self.message = message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssignUsersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sync is not None:
            result['Sync'] = self.sync
        if self.code is not None:
            result['Code'] = self.code
        if self.workflow_id is not None:
            result['WorkflowId'] = self.workflow_id
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Sync') is not None:
            self.sync = m.get('Sync')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('WorkflowId') is not None:
            self.workflow_id = m.get('WorkflowId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class AssignUsersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AssignUsersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AssignUsersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssignUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUserLevelsOfSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, is_member=None, page_number=None, page_size=None,
                 search_pattern=None):
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.is_member = is_member  # type: bool
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.search_pattern = search_pattern  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUserLevelsOfSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.is_member is not None:
            result['IsMember'] = self.is_member
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('IsMember') is not None:
            self.is_member = m.get('IsMember')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        return self


class ListUserLevelsOfSkillGroupResponseBodyDataList(TeaModel):
    def __init__(self, display_name=None, skill_level=None, login_name=None, user_id=None, skill_group_id=None,
                 skill_group_name=None, role_name=None, role_id=None):
        self.display_name = display_name  # type: str
        self.skill_level = skill_level  # type: int
        self.login_name = login_name  # type: str
        self.user_id = user_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.skill_group_name = skill_group_name  # type: str
        self.role_name = role_name  # type: str
        self.role_id = role_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUserLevelsOfSkillGroupResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.skill_level is not None:
            result['SkillLevel'] = self.skill_level
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('SkillLevel') is not None:
            self.skill_level = m.get('SkillLevel')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        return self


class ListUserLevelsOfSkillGroupResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListUserLevelsOfSkillGroupResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListUserLevelsOfSkillGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListUserLevelsOfSkillGroupResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListUserLevelsOfSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: ListUserLevelsOfSkillGroupResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListUserLevelsOfSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListUserLevelsOfSkillGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListUserLevelsOfSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListUserLevelsOfSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListUserLevelsOfSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListUserLevelsOfSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRolesRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRolesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListRolesResponseBodyData(TeaModel):
    def __init__(self, name=None, role_id=None):
        self.name = name  # type: str
        self.role_id = role_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRolesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        return self


class ListRolesResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: list[ListRolesResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRolesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListRolesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListRolesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListRolesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListRolesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRolesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateConfigItemsRequest(TeaModel):
    def __init__(self, instance_id=None, object_id=None, object_type=None, config_items=None):
        self.instance_id = instance_id  # type: str
        self.object_id = object_id  # type: str
        self.object_type = object_type  # type: str
        self.config_items = config_items  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(UpdateConfigItemsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.object_id is not None:
            result['ObjectId'] = self.object_id
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.config_items is not None:
            result['ConfigItems'] = self.config_items
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ObjectId') is not None:
            self.object_id = m.get('ObjectId')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('ConfigItems') is not None:
            self.config_items = m.get('ConfigItems')
        return self


class UpdateConfigItemsResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(UpdateConfigItemsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        return self


class UpdateConfigItemsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: UpdateConfigItemsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(UpdateConfigItemsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateConfigItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCallDetailRecordRequest(TeaModel):
    def __init__(self, contact_id=None, instance_id=None):
        self.contact_id = contact_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallDetailRecordRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetCallDetailRecordResponseBodyDataAgentEventsEventSequence(TeaModel):
    def __init__(self, event=None, event_time=None):
        self.event = event  # type: str
        self.event_time = event_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataAgentEventsEventSequence, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event is not None:
            result['Event'] = self.event
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Event') is not None:
            self.event = m.get('Event')
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        return self


class GetCallDetailRecordResponseBodyDataAgentEvents(TeaModel):
    def __init__(self, agent_name=None, agent_id=None, skill_group_id=None, event_sequence=None):
        self.agent_name = agent_name  # type: str
        self.agent_id = agent_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.event_sequence = event_sequence  # type: list[GetCallDetailRecordResponseBodyDataAgentEventsEventSequence]

    def validate(self):
        if self.event_sequence:
            for k in self.event_sequence:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataAgentEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        result['EventSequence'] = []
        if self.event_sequence is not None:
            for k in self.event_sequence:
                result['EventSequence'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        self.event_sequence = []
        if m.get('EventSequence') is not None:
            for k in m.get('EventSequence'):
                temp_model = GetCallDetailRecordResponseBodyDataAgentEventsEventSequence()
                self.event_sequence.append(temp_model.from_map(k))
        return self


class GetCallDetailRecordResponseBodyDataIvrEventsEventSequence(TeaModel):
    def __init__(self, event=None, event_time=None):
        self.event = event  # type: str
        self.event_time = event_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataIvrEventsEventSequence, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event is not None:
            result['Event'] = self.event
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Event') is not None:
            self.event = m.get('Event')
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        return self


class GetCallDetailRecordResponseBodyDataIvrEvents(TeaModel):
    def __init__(self, flow_id=None, event_sequence=None):
        self.flow_id = flow_id  # type: str
        self.event_sequence = event_sequence  # type: list[GetCallDetailRecordResponseBodyDataIvrEventsEventSequence]

    def validate(self):
        if self.event_sequence:
            for k in self.event_sequence:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataIvrEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        result['EventSequence'] = []
        if self.event_sequence is not None:
            for k in self.event_sequence:
                result['EventSequence'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        self.event_sequence = []
        if m.get('EventSequence') is not None:
            for k in m.get('EventSequence'):
                temp_model = GetCallDetailRecordResponseBodyDataIvrEventsEventSequence()
                self.event_sequence.append(temp_model.from_map(k))
        return self


class GetCallDetailRecordResponseBodyDataQueueEventsEventSequence(TeaModel):
    def __init__(self, event=None, event_time=None):
        self.event = event  # type: str
        self.event_time = event_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataQueueEventsEventSequence, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event is not None:
            result['Event'] = self.event
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Event') is not None:
            self.event = m.get('Event')
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        return self


class GetCallDetailRecordResponseBodyDataQueueEvents(TeaModel):
    def __init__(self, queue_id=None, queue_name=None, flow_id=None, queue_type=None, event_sequence=None):
        self.queue_id = queue_id  # type: str
        self.queue_name = queue_name  # type: str
        self.flow_id = flow_id  # type: str
        self.queue_type = queue_type  # type: int
        self.event_sequence = event_sequence  # type: list[GetCallDetailRecordResponseBodyDataQueueEventsEventSequence]

    def validate(self):
        if self.event_sequence:
            for k in self.event_sequence:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataQueueEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.queue_type is not None:
            result['QueueType'] = self.queue_type
        result['EventSequence'] = []
        if self.event_sequence is not None:
            for k in self.event_sequence:
                result['EventSequence'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('QueueType') is not None:
            self.queue_type = m.get('QueueType')
        self.event_sequence = []
        if m.get('EventSequence') is not None:
            for k in m.get('EventSequence'):
                temp_model = GetCallDetailRecordResponseBodyDataQueueEventsEventSequence()
                self.event_sequence.append(temp_model.from_map(k))
        return self


class GetCallDetailRecordResponseBodyData(TeaModel):
    def __init__(self, release_initiator=None, contact_disposition=None, contact_type=None, agent_ids=None,
                 call_duration=None, recording_ready=None, established_time=None, instance_id=None,
                 satisfaction_survey_offered=None, called_number=None, agent_names=None, satisfaction=None, start_time=None, contact_id=None,
                 satisfaction_survey_channel=None, release_time=None, calling_number=None, skill_group_names=None, skill_group_ids=None,
                 agent_events=None, ivr_events=None, queue_events=None, caller_location=None, callee_location=None):
        self.release_initiator = release_initiator  # type: str
        self.contact_disposition = contact_disposition  # type: str
        self.contact_type = contact_type  # type: str
        self.agent_ids = agent_ids  # type: str
        self.call_duration = call_duration  # type: long
        self.recording_ready = recording_ready  # type: bool
        self.established_time = established_time  # type: long
        self.instance_id = instance_id  # type: str
        self.satisfaction_survey_offered = satisfaction_survey_offered  # type: bool
        self.called_number = called_number  # type: str
        self.agent_names = agent_names  # type: str
        self.satisfaction = satisfaction  # type: int
        self.start_time = start_time  # type: long
        self.contact_id = contact_id  # type: str
        self.satisfaction_survey_channel = satisfaction_survey_channel  # type: str
        self.release_time = release_time  # type: long
        self.calling_number = calling_number  # type: str
        self.skill_group_names = skill_group_names  # type: str
        self.skill_group_ids = skill_group_ids  # type: str
        self.agent_events = agent_events  # type: list[GetCallDetailRecordResponseBodyDataAgentEvents]
        self.ivr_events = ivr_events  # type: list[GetCallDetailRecordResponseBodyDataIvrEvents]
        self.queue_events = queue_events  # type: list[GetCallDetailRecordResponseBodyDataQueueEvents]
        self.caller_location = caller_location  # type: str
        self.callee_location = callee_location  # type: str

    def validate(self):
        if self.agent_events:
            for k in self.agent_events:
                if k:
                    k.validate()
        if self.ivr_events:
            for k in self.ivr_events:
                if k:
                    k.validate()
        if self.queue_events:
            for k in self.queue_events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.contact_disposition is not None:
            result['ContactDisposition'] = self.contact_disposition
        if self.contact_type is not None:
            result['ContactType'] = self.contact_type
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.call_duration is not None:
            result['CallDuration'] = self.call_duration
        if self.recording_ready is not None:
            result['RecordingReady'] = self.recording_ready
        if self.established_time is not None:
            result['EstablishedTime'] = self.established_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.satisfaction_survey_offered is not None:
            result['SatisfactionSurveyOffered'] = self.satisfaction_survey_offered
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.agent_names is not None:
            result['AgentNames'] = self.agent_names
        if self.satisfaction is not None:
            result['Satisfaction'] = self.satisfaction
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.satisfaction_survey_channel is not None:
            result['SatisfactionSurveyChannel'] = self.satisfaction_survey_channel
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.skill_group_names is not None:
            result['SkillGroupNames'] = self.skill_group_names
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        result['AgentEvents'] = []
        if self.agent_events is not None:
            for k in self.agent_events:
                result['AgentEvents'].append(k.to_map() if k else None)
        result['IvrEvents'] = []
        if self.ivr_events is not None:
            for k in self.ivr_events:
                result['IvrEvents'].append(k.to_map() if k else None)
        result['QueueEvents'] = []
        if self.queue_events is not None:
            for k in self.queue_events:
                result['QueueEvents'].append(k.to_map() if k else None)
        if self.caller_location is not None:
            result['CallerLocation'] = self.caller_location
        if self.callee_location is not None:
            result['CalleeLocation'] = self.callee_location
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ContactDisposition') is not None:
            self.contact_disposition = m.get('ContactDisposition')
        if m.get('ContactType') is not None:
            self.contact_type = m.get('ContactType')
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CallDuration') is not None:
            self.call_duration = m.get('CallDuration')
        if m.get('RecordingReady') is not None:
            self.recording_ready = m.get('RecordingReady')
        if m.get('EstablishedTime') is not None:
            self.established_time = m.get('EstablishedTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SatisfactionSurveyOffered') is not None:
            self.satisfaction_survey_offered = m.get('SatisfactionSurveyOffered')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('AgentNames') is not None:
            self.agent_names = m.get('AgentNames')
        if m.get('Satisfaction') is not None:
            self.satisfaction = m.get('Satisfaction')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('SatisfactionSurveyChannel') is not None:
            self.satisfaction_survey_channel = m.get('SatisfactionSurveyChannel')
        if m.get('ReleaseTime') is not None:
            self.release_time = m.get('ReleaseTime')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('SkillGroupNames') is not None:
            self.skill_group_names = m.get('SkillGroupNames')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        self.agent_events = []
        if m.get('AgentEvents') is not None:
            for k in m.get('AgentEvents'):
                temp_model = GetCallDetailRecordResponseBodyDataAgentEvents()
                self.agent_events.append(temp_model.from_map(k))
        self.ivr_events = []
        if m.get('IvrEvents') is not None:
            for k in m.get('IvrEvents'):
                temp_model = GetCallDetailRecordResponseBodyDataIvrEvents()
                self.ivr_events.append(temp_model.from_map(k))
        self.queue_events = []
        if m.get('QueueEvents') is not None:
            for k in m.get('QueueEvents'):
                temp_model = GetCallDetailRecordResponseBodyDataQueueEvents()
                self.queue_events.append(temp_model.from_map(k))
        if m.get('CallerLocation') is not None:
            self.caller_location = m.get('CallerLocation')
        if m.get('CalleeLocation') is not None:
            self.callee_location = m.get('CalleeLocation')
        return self


class GetCallDetailRecordResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: GetCallDetailRecordResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetCallDetailRecordResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetCallDetailRecordResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetCallDetailRecordResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetCallDetailRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyPhoneNumberRequest(TeaModel):
    def __init__(self, instance_id=None, number=None, usage=None, contact_flow_id=None):
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str
        self.usage = usage  # type: str
        self.contact_flow_id = contact_flow_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyPhoneNumberRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        return self


class ModifyPhoneNumberResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyPhoneNumberResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyPhoneNumberResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyPhoneNumberResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyPhoneNumberResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyPhoneNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CoachCallRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, job_id=None, coached_user_id=None,
                 timeout_seconds=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.coached_user_id = coached_user_id  # type: str
        self.timeout_seconds = timeout_seconds  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CoachCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.coached_user_id is not None:
            result['CoachedUserId'] = self.coached_user_id
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CoachedUserId') is not None:
            self.coached_user_id = m.get('CoachedUserId')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        return self


class CoachCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, index=None, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, skill_group_id=None, timestamp=None, associated_data=None, release_reason=None,
                 call_type=None, job_id=None, channel_id=None, user_extension=None, originator=None):
        self.index = index  # type: int
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.user_extension = user_extension  # type: str
        self.originator = originator  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CoachCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.originator is not None:
            result['Originator'] = self.originator
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        return self


class CoachCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[CoachCallResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CoachCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = CoachCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class CoachCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, uri=None, device_state=None, mobile=None,
                 job_id=None, user_state=None, signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.uri = uri  # type: str
        self.device_state = device_state  # type: str
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CoachCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.uri is not None:
            result['Uri'] = self.uri
        if self.device_state is not None:
            result['DeviceState'] = self.device_state
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Uri') is not None:
            self.uri = m.get('Uri')
        if m.get('DeviceState') is not None:
            self.device_state = m.get('DeviceState')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class CoachCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: CoachCallResponseBodyDataCallContext
        self.user_context = user_context  # type: CoachCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(CoachCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = CoachCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = CoachCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class CoachCallResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: CoachCallResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CoachCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = CoachCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CoachCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CoachCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CoachCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CoachCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUserRequest(TeaModel):
    def __init__(self, instance_id=None, login_name=None, display_name=None, mobile=None, email=None, work_mode=None,
                 role_id=None, skill_level_list=None, reset_password=None):
        self.instance_id = instance_id  # type: str
        self.login_name = login_name  # type: str
        self.display_name = display_name  # type: str
        self.mobile = mobile  # type: str
        self.email = email  # type: str
        self.work_mode = work_mode  # type: str
        self.role_id = role_id  # type: str
        self.skill_level_list = skill_level_list  # type: str
        self.reset_password = reset_password  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.email is not None:
            result['Email'] = self.email
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.skill_level_list is not None:
            result['SkillLevelList'] = self.skill_level_list
        if self.reset_password is not None:
            result['ResetPassword'] = self.reset_password
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('SkillLevelList') is not None:
            self.skill_level_list = m.get('SkillLevelList')
        if m.get('ResetPassword') is not None:
            self.reset_password = m.get('ResetPassword')
        return self


class CreateUserResponseBodyData(TeaModel):
    def __init__(self, display_name=None, extension=None, email=None, login_name=None, work_mode=None, mobile=None,
                 user_id=None):
        self.display_name = display_name  # type: str
        self.extension = extension  # type: str
        self.email = email  # type: str
        self.login_name = login_name  # type: str
        self.work_mode = work_mode  # type: str
        self.mobile = mobile  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.email is not None:
            result['Email'] = self.email
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CreateUserResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: CreateUserResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = CreateUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPrivilegesOfUserRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrivilegesOfUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListPrivilegesOfUserResponseBodyData(TeaModel):
    def __init__(self, instance_id=None, scope=None, name=None):
        self.instance_id = instance_id  # type: str
        self.scope = scope  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrivilegesOfUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ListPrivilegesOfUserResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: list[ListPrivilegesOfUserResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPrivilegesOfUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListPrivilegesOfUserResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListPrivilegesOfUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListPrivilegesOfUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPrivilegesOfUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListPrivilegesOfUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPersonalNumbersToUserRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, number_list=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.number_list = number_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPersonalNumbersToUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        return self


class AddPersonalNumbersToUserResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPersonalNumbersToUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class AddPersonalNumbersToUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddPersonalNumbersToUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPersonalNumbersToUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddPersonalNumbersToUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHistoricalAgentReportRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, agent_id_list=None, start_time=None, stop_time=None,
                 instance_id=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.agent_id_list = agent_id_list  # type: str
        self.start_time = start_time  # type: long
        self.stop_time = stop_time  # type: long
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.agent_id_list is not None:
            result['AgentIdList'] = self.agent_id_list
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('AgentIdList') is not None:
            self.agent_id_list = m.get('AgentIdList')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListHistoricalAgentReportResponseBodyDataListInbound(TeaModel):
    def __init__(self, average_ring_time=None, calls_handled=None, total_work_time=None,
                 calls_attended_transfer_out=None, max_work_time=None, total_hold_time=None, average_work_time=None,
                 calls_blind_transfer_in=None, satisfaction_index=None, calls_ringed=None, calls_attended_transfer_in=None,
                 calls_blind_transfer_out=None, total_ring_time=None, max_talk_time=None, max_ring_time=None, total_talk_time=None,
                 calls_offered=None, max_hold_time=None, average_talk_time=None, satisfaction_rate=None, calls_hold=None,
                 satisfaction_surveys_offered=None, handle_rate=None, satisfaction_surveys_responded=None, average_hold_time=None):
        self.average_ring_time = average_ring_time  # type: float
        self.calls_handled = calls_handled  # type: long
        self.total_work_time = total_work_time  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.max_work_time = max_work_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.calls_ringed = calls_ringed  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.calls_offered = calls_offered  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.average_talk_time = average_talk_time  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.calls_hold = calls_hold  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.handle_rate = handle_rate  # type: float
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_hold_time = average_hold_time  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataListInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        return self


class ListHistoricalAgentReportResponseBodyDataListOutbound(TeaModel):
    def __init__(self, average_ring_time=None, calls_dialed=None, calls_answered=None, total_work_time=None,
                 calls_attended_transfer_out=None, max_work_time=None, total_dialing_time=None, total_hold_time=None, average_work_time=None,
                 calls_blind_transfer_in=None, satisfaction_index=None, calls_ringed=None, calls_attended_transfer_in=None,
                 calls_blind_transfer_out=None, total_ring_time=None, max_talk_time=None, max_ring_time=None, total_talk_time=None,
                 max_dialing_time=None, answer_rate=None, max_hold_time=None, average_talk_time=None, satisfaction_rate=None,
                 calls_hold=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 average_hold_time=None, average_dialing_time=None):
        self.average_ring_time = average_ring_time  # type: float
        self.calls_dialed = calls_dialed  # type: long
        self.calls_answered = calls_answered  # type: long
        self.total_work_time = total_work_time  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.max_work_time = max_work_time  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.calls_ringed = calls_ringed  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.answer_rate = answer_rate  # type: float
        self.max_hold_time = max_hold_time  # type: long
        self.average_talk_time = average_talk_time  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.calls_hold = calls_hold  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_hold_time = average_hold_time  # type: float
        self.average_dialing_time = average_dialing_time  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataListOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        return self


class ListHistoricalAgentReportResponseBodyDataListOverall(TeaModel):
    def __init__(self, total_talk_time=None, total_logged_in_time=None, occupancy_rate=None, total_work_time=None,
                 max_hold_time=None, max_work_time=None, average_break_time=None, total_hold_time=None, satisfaction_rate=None,
                 max_break_time=None, average_work_time=None, average_talk_time=None, satisfaction_index=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, max_ready_time=None, average_ready_time=None,
                 average_hold_time=None, total_ready_time=None, total_break_time=None, max_talk_time=None, total_calls=None):
        self.total_talk_time = total_talk_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.total_work_time = total_work_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_break_time = average_break_time  # type: float
        self.total_hold_time = total_hold_time  # type: long
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.max_break_time = max_break_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.average_ready_time = average_ready_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.total_ready_time = total_ready_time  # type: long
        self.total_break_time = total_break_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataListOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class ListHistoricalAgentReportResponseBodyDataList(TeaModel):
    def __init__(self, agent_name=None, agent_id=None, inbound=None, outbound=None, overall=None):
        self.agent_name = agent_name  # type: str
        self.agent_id = agent_id  # type: str
        self.inbound = inbound  # type: ListHistoricalAgentReportResponseBodyDataListInbound
        self.outbound = outbound  # type: ListHistoricalAgentReportResponseBodyDataListOutbound
        self.overall = overall  # type: ListHistoricalAgentReportResponseBodyDataListOverall

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('Inbound') is not None:
            temp_model = ListHistoricalAgentReportResponseBodyDataListInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = ListHistoricalAgentReportResponseBodyDataListOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = ListHistoricalAgentReportResponseBodyDataListOverall()
            self.overall = temp_model.from_map(m['Overall'])
        return self


class ListHistoricalAgentReportResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListHistoricalAgentReportResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListHistoricalAgentReportResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListHistoricalAgentReportResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: ListHistoricalAgentReportResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListHistoricalAgentReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListHistoricalAgentReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListHistoricalAgentReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListHistoricalAgentReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InterceptCallRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, job_id=None, intercepted_user_id=None,
                 timeout_seconds=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.intercepted_user_id = intercepted_user_id  # type: str
        self.timeout_seconds = timeout_seconds  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(InterceptCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.intercepted_user_id is not None:
            result['InterceptedUserId'] = self.intercepted_user_id
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('InterceptedUserId') is not None:
            self.intercepted_user_id = m.get('InterceptedUserId')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        return self


class InterceptCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, index=None, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, skill_group_id=None, timestamp=None, associated_data=None, release_reason=None,
                 call_type=None, job_id=None, channel_id=None, user_extension=None, originator=None):
        self.index = index  # type: int
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.user_extension = user_extension  # type: str
        self.originator = originator  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InterceptCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.originator is not None:
            result['Originator'] = self.originator
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        return self


class InterceptCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[InterceptCallResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(InterceptCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = InterceptCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class InterceptCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(InterceptCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class InterceptCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: InterceptCallResponseBodyDataCallContext
        self.user_context = user_context  # type: InterceptCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(InterceptCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = InterceptCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = InterceptCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class InterceptCallResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: InterceptCallResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(InterceptCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = InterceptCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class InterceptCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: InterceptCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InterceptCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InterceptCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListContactFlowsRequest(TeaModel):
    def __init__(self, instance_id=None, page_number=None, page_size=None, type=None):
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListContactFlowsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListContactFlowsResponseBodyDataList(TeaModel):
    def __init__(self, type=None, definition=None, draft_id=None, description=None, updated_time=None, editor=None,
                 published=None, instance_id=None, name=None, contact_flow_id=None, created_time=None, number_list=None):
        self.type = type  # type: str
        self.definition = definition  # type: str
        self.draft_id = draft_id  # type: str
        self.description = description  # type: str
        self.updated_time = updated_time  # type: str
        self.editor = editor  # type: str
        self.published = published  # type: bool
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.created_time = created_time  # type: str
        self.number_list = number_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListContactFlowsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.draft_id is not None:
            result['DraftId'] = self.draft_id
        if self.description is not None:
            result['Description'] = self.description
        if self.updated_time is not None:
            result['UpdatedTime'] = self.updated_time
        if self.editor is not None:
            result['Editor'] = self.editor
        if self.published is not None:
            result['Published'] = self.published
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('DraftId') is not None:
            self.draft_id = m.get('DraftId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('UpdatedTime') is not None:
            self.updated_time = m.get('UpdatedTime')
        if m.get('Editor') is not None:
            self.editor = m.get('Editor')
        if m.get('Published') is not None:
            self.published = m.get('Published')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        return self


class ListContactFlowsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListContactFlowsResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListContactFlowsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListContactFlowsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListContactFlowsResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: ListContactFlowsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListContactFlowsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListContactFlowsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListContactFlowsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListContactFlowsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListContactFlowsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListContactFlowsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPersonalNumbersOfUserRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, page_number=None, page_size=None, is_member=None,
                 search_pattern=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.is_member = is_member  # type: bool
        self.search_pattern = search_pattern  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPersonalNumbersOfUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.is_member is not None:
            result['IsMember'] = self.is_member
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('IsMember') is not None:
            self.is_member = m.get('IsMember')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        return self


class ListPersonalNumbersOfUserResponseBodyDataList(TeaModel):
    def __init__(self, active=None, number=None, city=None, instance_id=None, contact_flow_id=None, province=None):
        self.active = active  # type: bool
        self.number = number  # type: str
        self.city = city  # type: str
        self.instance_id = instance_id  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.province = province  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPersonalNumbersOfUserResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.number is not None:
            result['Number'] = self.number
        if self.city is not None:
            result['City'] = self.city
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class ListPersonalNumbersOfUserResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListPersonalNumbersOfUserResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPersonalNumbersOfUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListPersonalNumbersOfUserResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListPersonalNumbersOfUserResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: ListPersonalNumbersOfUserResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListPersonalNumbersOfUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListPersonalNumbersOfUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListPersonalNumbersOfUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListPersonalNumbersOfUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPersonalNumbersOfUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListPersonalNumbersOfUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartPredictiveCallRequest(TeaModel):
    def __init__(self, instance_id=None, caller=None, callee=None, timeout_seconds=None, contact_flow_id=None,
                 tags=None, contact_flow_variables=None):
        self.instance_id = instance_id  # type: str
        self.caller = caller  # type: str
        self.callee = callee  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.contact_flow_id = contact_flow_id  # type: str
        self.tags = tags  # type: str
        self.contact_flow_variables = contact_flow_variables  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartPredictiveCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.contact_flow_variables is not None:
            result['ContactFlowVariables'] = self.contact_flow_variables
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('ContactFlowVariables') is not None:
            self.contact_flow_variables = m.get('ContactFlowVariables')
        return self


class StartPredictiveCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, timestamp=None, associated_data=None, release_reason=None, call_type=None, job_id=None,
                 channel_id=None, originator=None, user_extension=None):
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.originator = originator  # type: str
        self.user_extension = user_extension  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartPredictiveCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        return self


class StartPredictiveCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[StartPredictiveCallResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(StartPredictiveCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = StartPredictiveCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class StartPredictiveCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, device_state=None, mobile=None, job_id=None,
                 user_state=None, signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.device_state = device_state  # type: str
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartPredictiveCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.device_state is not None:
            result['DeviceState'] = self.device_state
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('DeviceState') is not None:
            self.device_state = m.get('DeviceState')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class StartPredictiveCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: StartPredictiveCallResponseBodyDataCallContext
        self.user_context = user_context  # type: StartPredictiveCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(StartPredictiveCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = StartPredictiveCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = StartPredictiveCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class StartPredictiveCallResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: StartPredictiveCallResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(StartPredictiveCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = StartPredictiveCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class StartPredictiveCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: StartPredictiveCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StartPredictiveCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StartPredictiveCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIntervalInstanceReportRequest(TeaModel):
    def __init__(self, instance_id=None, start_time=None, end_time=None, interval=None):
        self.instance_id = instance_id  # type: str
        self.start_time = start_time  # type: long
        self.end_time = end_time  # type: long
        self.interval = interval  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalInstanceReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        return self


class ListIntervalInstanceReportResponseBodyDataInbound(TeaModel):
    def __init__(self, average_ring_time=None, calls_voicemail=None, max_abandoned_in_ivrtime=None,
                 calls_handled=None, calls_ivrexception=None, calls_abandoned_in_ivr=None, max_work_time=None,
                 total_hold_time=None, max_abandon_time=None, average_abandon_time=None, abandoned_rate=None, calls_ringed=None,
                 calls_queuing_failed=None, total_ring_time=None, total_talk_time=None, max_abandoned_in_ring_time=None,
                 calls_blind_transferred=None, average_abandoned_in_ivrtime=None, average_abandoned_in_queue_time=None,
                 max_wait_time=None, average_talk_time=None, calls_attended_transferred=None, total_abandoned_in_ivrtime=None,
                 calls_queuing_overflow=None, calls_abandoned_in_ring=None, total_abandoned_in_ring_time=None, total_work_time=None,
                 average_wait_time=None, average_work_time=None, calls_queued=None, average_abandoned_in_ring_time=None,
                 satisfaction_index=None, calls_abandoned=None, max_abandoned_in_queue_time=None,
                 calls_abandoned_in_voice_navigator=None, total_wait_time=None, max_talk_time=None, max_ring_time=None, total_abandon_time=None,
                 calls_offered=None, calls_queuing_timeout=None, service_level_20=None, max_hold_time=None,
                 calls_forward_to_outside_number=None, satisfaction_rate=None, calls_hold=None, satisfaction_surveys_offered=None,
                 handle_rate=None, satisfaction_surveys_responded=None, average_hold_time=None, calls_abandoned_in_queue=None,
                 total_abandoned_in_queue_time=None):
        self.average_ring_time = average_ring_time  # type: float
        self.calls_voicemail = calls_voicemail  # type: long
        self.max_abandoned_in_ivrtime = max_abandoned_in_ivrtime  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_ivrexception = calls_ivrexception  # type: long
        self.calls_abandoned_in_ivr = calls_abandoned_in_ivr  # type: long
        self.max_work_time = max_work_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.max_abandon_time = max_abandon_time  # type: long
        self.average_abandon_time = average_abandon_time  # type: float
        self.abandoned_rate = abandoned_rate  # type: float
        self.calls_ringed = calls_ringed  # type: long
        self.calls_queuing_failed = calls_queuing_failed  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.max_abandoned_in_ring_time = max_abandoned_in_ring_time  # type: long
        self.calls_blind_transferred = calls_blind_transferred  # type: long
        self.average_abandoned_in_ivrtime = average_abandoned_in_ivrtime  # type: float
        self.average_abandoned_in_queue_time = average_abandoned_in_queue_time  # type: float
        self.max_wait_time = max_wait_time  # type: long
        self.average_talk_time = average_talk_time  # type: float
        self.calls_attended_transferred = calls_attended_transferred  # type: long
        self.total_abandoned_in_ivrtime = total_abandoned_in_ivrtime  # type: long
        self.calls_queuing_overflow = calls_queuing_overflow  # type: long
        self.calls_abandoned_in_ring = calls_abandoned_in_ring  # type: long
        self.total_abandoned_in_ring_time = total_abandoned_in_ring_time  # type: long
        self.total_work_time = total_work_time  # type: long
        self.average_wait_time = average_wait_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_queued = calls_queued  # type: long
        self.average_abandoned_in_ring_time = average_abandoned_in_ring_time  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.calls_abandoned = calls_abandoned  # type: long
        self.max_abandoned_in_queue_time = max_abandoned_in_queue_time  # type: long
        self.calls_abandoned_in_voice_navigator = calls_abandoned_in_voice_navigator  # type: long
        self.total_wait_time = total_wait_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.total_abandon_time = total_abandon_time  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_queuing_timeout = calls_queuing_timeout  # type: long
        self.service_level_20 = service_level_20  # type: float
        self.max_hold_time = max_hold_time  # type: long
        self.calls_forward_to_outside_number = calls_forward_to_outside_number  # type: long
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.calls_hold = calls_hold  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.handle_rate = handle_rate  # type: float
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_hold_time = average_hold_time  # type: float
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long
        self.total_abandoned_in_queue_time = total_abandoned_in_queue_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalInstanceReportResponseBodyDataInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_voicemail is not None:
            result['CallsVoicemail'] = self.calls_voicemail
        if self.max_abandoned_in_ivrtime is not None:
            result['MaxAbandonedInIVRTime'] = self.max_abandoned_in_ivrtime
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_ivrexception is not None:
            result['CallsIVRException'] = self.calls_ivrexception
        if self.calls_abandoned_in_ivr is not None:
            result['CallsAbandonedInIVR'] = self.calls_abandoned_in_ivr
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.max_abandon_time is not None:
            result['MaxAbandonTime'] = self.max_abandon_time
        if self.average_abandon_time is not None:
            result['AverageAbandonTime'] = self.average_abandon_time
        if self.abandoned_rate is not None:
            result['AbandonedRate'] = self.abandoned_rate
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_queuing_failed is not None:
            result['CallsQueuingFailed'] = self.calls_queuing_failed
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_abandoned_in_ring_time is not None:
            result['MaxAbandonedInRingTime'] = self.max_abandoned_in_ring_time
        if self.calls_blind_transferred is not None:
            result['CallsBlindTransferred'] = self.calls_blind_transferred
        if self.average_abandoned_in_ivrtime is not None:
            result['AverageAbandonedInIVRTime'] = self.average_abandoned_in_ivrtime
        if self.average_abandoned_in_queue_time is not None:
            result['AverageAbandonedInQueueTime'] = self.average_abandoned_in_queue_time
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.calls_attended_transferred is not None:
            result['CallsAttendedTransferred'] = self.calls_attended_transferred
        if self.total_abandoned_in_ivrtime is not None:
            result['TotalAbandonedInIVRTime'] = self.total_abandoned_in_ivrtime
        if self.calls_queuing_overflow is not None:
            result['CallsQueuingOverflow'] = self.calls_queuing_overflow
        if self.calls_abandoned_in_ring is not None:
            result['CallsAbandonedInRing'] = self.calls_abandoned_in_ring
        if self.total_abandoned_in_ring_time is not None:
            result['TotalAbandonedInRingTime'] = self.total_abandoned_in_ring_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.average_wait_time is not None:
            result['AverageWaitTime'] = self.average_wait_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_queued is not None:
            result['CallsQueued'] = self.calls_queued
        if self.average_abandoned_in_ring_time is not None:
            result['AverageAbandonedInRingTime'] = self.average_abandoned_in_ring_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.calls_abandoned is not None:
            result['CallsAbandoned'] = self.calls_abandoned
        if self.max_abandoned_in_queue_time is not None:
            result['MaxAbandonedInQueueTime'] = self.max_abandoned_in_queue_time
        if self.calls_abandoned_in_voice_navigator is not None:
            result['CallsAbandonedInVoiceNavigator'] = self.calls_abandoned_in_voice_navigator
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.total_abandon_time is not None:
            result['TotalAbandonTime'] = self.total_abandon_time
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_queuing_timeout is not None:
            result['CallsQueuingTimeout'] = self.calls_queuing_timeout
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.calls_forward_to_outside_number is not None:
            result['CallsForwardToOutsideNumber'] = self.calls_forward_to_outside_number
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        if self.total_abandoned_in_queue_time is not None:
            result['TotalAbandonedInQueueTime'] = self.total_abandoned_in_queue_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsVoicemail') is not None:
            self.calls_voicemail = m.get('CallsVoicemail')
        if m.get('MaxAbandonedInIVRTime') is not None:
            self.max_abandoned_in_ivrtime = m.get('MaxAbandonedInIVRTime')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsIVRException') is not None:
            self.calls_ivrexception = m.get('CallsIVRException')
        if m.get('CallsAbandonedInIVR') is not None:
            self.calls_abandoned_in_ivr = m.get('CallsAbandonedInIVR')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('MaxAbandonTime') is not None:
            self.max_abandon_time = m.get('MaxAbandonTime')
        if m.get('AverageAbandonTime') is not None:
            self.average_abandon_time = m.get('AverageAbandonTime')
        if m.get('AbandonedRate') is not None:
            self.abandoned_rate = m.get('AbandonedRate')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsQueuingFailed') is not None:
            self.calls_queuing_failed = m.get('CallsQueuingFailed')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxAbandonedInRingTime') is not None:
            self.max_abandoned_in_ring_time = m.get('MaxAbandonedInRingTime')
        if m.get('CallsBlindTransferred') is not None:
            self.calls_blind_transferred = m.get('CallsBlindTransferred')
        if m.get('AverageAbandonedInIVRTime') is not None:
            self.average_abandoned_in_ivrtime = m.get('AverageAbandonedInIVRTime')
        if m.get('AverageAbandonedInQueueTime') is not None:
            self.average_abandoned_in_queue_time = m.get('AverageAbandonedInQueueTime')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('CallsAttendedTransferred') is not None:
            self.calls_attended_transferred = m.get('CallsAttendedTransferred')
        if m.get('TotalAbandonedInIVRTime') is not None:
            self.total_abandoned_in_ivrtime = m.get('TotalAbandonedInIVRTime')
        if m.get('CallsQueuingOverflow') is not None:
            self.calls_queuing_overflow = m.get('CallsQueuingOverflow')
        if m.get('CallsAbandonedInRing') is not None:
            self.calls_abandoned_in_ring = m.get('CallsAbandonedInRing')
        if m.get('TotalAbandonedInRingTime') is not None:
            self.total_abandoned_in_ring_time = m.get('TotalAbandonedInRingTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('AverageWaitTime') is not None:
            self.average_wait_time = m.get('AverageWaitTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsQueued') is not None:
            self.calls_queued = m.get('CallsQueued')
        if m.get('AverageAbandonedInRingTime') is not None:
            self.average_abandoned_in_ring_time = m.get('AverageAbandonedInRingTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('CallsAbandoned') is not None:
            self.calls_abandoned = m.get('CallsAbandoned')
        if m.get('MaxAbandonedInQueueTime') is not None:
            self.max_abandoned_in_queue_time = m.get('MaxAbandonedInQueueTime')
        if m.get('CallsAbandonedInVoiceNavigator') is not None:
            self.calls_abandoned_in_voice_navigator = m.get('CallsAbandonedInVoiceNavigator')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('TotalAbandonTime') is not None:
            self.total_abandon_time = m.get('TotalAbandonTime')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsQueuingTimeout') is not None:
            self.calls_queuing_timeout = m.get('CallsQueuingTimeout')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('CallsForwardToOutsideNumber') is not None:
            self.calls_forward_to_outside_number = m.get('CallsForwardToOutsideNumber')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        if m.get('TotalAbandonedInQueueTime') is not None:
            self.total_abandoned_in_queue_time = m.get('TotalAbandonedInQueueTime')
        return self


class ListIntervalInstanceReportResponseBodyDataOutbound(TeaModel):
    def __init__(self, average_ring_time=None, calls_dialed=None, calls_answered=None, total_work_time=None,
                 max_work_time=None, total_dialing_time=None, total_hold_time=None, average_work_time=None,
                 satisfaction_index=None, calls_ringed=None, total_ring_time=None, max_talk_time=None, max_ring_time=None,
                 total_talk_time=None, max_dialing_time=None, calls_blind_transferred=None, answer_rate=None, max_hold_time=None,
                 average_talk_time=None, satisfaction_rate=None, calls_attended_transferred=None, calls_hold=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, average_hold_time=None, average_dialing_time=None):
        self.average_ring_time = average_ring_time  # type: float
        self.calls_dialed = calls_dialed  # type: long
        self.calls_answered = calls_answered  # type: long
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.calls_ringed = calls_ringed  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.calls_blind_transferred = calls_blind_transferred  # type: long
        self.answer_rate = answer_rate  # type: float
        self.max_hold_time = max_hold_time  # type: long
        self.average_talk_time = average_talk_time  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.calls_attended_transferred = calls_attended_transferred  # type: long
        self.calls_hold = calls_hold  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_hold_time = average_hold_time  # type: float
        self.average_dialing_time = average_dialing_time  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalInstanceReportResponseBodyDataOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.calls_blind_transferred is not None:
            result['CallsBlindTransferred'] = self.calls_blind_transferred
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.calls_attended_transferred is not None:
            result['CallsAttendedTransferred'] = self.calls_attended_transferred
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('CallsBlindTransferred') is not None:
            self.calls_blind_transferred = m.get('CallsBlindTransferred')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('CallsAttendedTransferred') is not None:
            self.calls_attended_transferred = m.get('CallsAttendedTransferred')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        return self


class ListIntervalInstanceReportResponseBodyDataOverall(TeaModel):
    def __init__(self, total_talk_time=None, total_logged_in_time=None, occupancy_rate=None, total_work_time=None,
                 max_hold_time=None, max_work_time=None, average_break_time=None, total_hold_time=None, satisfaction_rate=None,
                 max_break_time=None, average_work_time=None, average_talk_time=None, satisfaction_index=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, max_ready_time=None, average_ready_time=None,
                 average_hold_time=None, total_ready_time=None, total_break_time=None, max_talk_time=None, total_calls=None):
        self.total_talk_time = total_talk_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.total_work_time = total_work_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_break_time = average_break_time  # type: float
        self.total_hold_time = total_hold_time  # type: long
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.max_break_time = max_break_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.average_ready_time = average_ready_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.total_ready_time = total_ready_time  # type: long
        self.total_break_time = total_break_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalInstanceReportResponseBodyDataOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class ListIntervalInstanceReportResponseBodyData(TeaModel):
    def __init__(self, stats_time=None, inbound=None, outbound=None, overall=None):
        self.stats_time = stats_time  # type: long
        self.inbound = inbound  # type: ListIntervalInstanceReportResponseBodyDataInbound
        self.outbound = outbound  # type: ListIntervalInstanceReportResponseBodyDataOutbound
        self.overall = overall  # type: ListIntervalInstanceReportResponseBodyDataOverall

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(ListIntervalInstanceReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stats_time is not None:
            result['StatsTime'] = self.stats_time
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StatsTime') is not None:
            self.stats_time = m.get('StatsTime')
        if m.get('Inbound') is not None:
            temp_model = ListIntervalInstanceReportResponseBodyDataInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = ListIntervalInstanceReportResponseBodyDataOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = ListIntervalInstanceReportResponseBodyDataOverall()
            self.overall = temp_model.from_map(m['Overall'])
        return self


class ListIntervalInstanceReportResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: list[ListIntervalInstanceReportResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListIntervalInstanceReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListIntervalInstanceReportResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListIntervalInstanceReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListIntervalInstanceReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListIntervalInstanceReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListIntervalInstanceReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstanceRequest(TeaModel):
    def __init__(self, name=None, description=None, domain_name=None, number_list=None, admin_ram_id_list=None):
        self.name = name  # type: str
        self.description = description  # type: str
        self.domain_name = domain_name  # type: str
        self.number_list = number_list  # type: str
        self.admin_ram_id_list = admin_ram_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        if self.admin_ram_id_list is not None:
            result['AdminRamIdList'] = self.admin_ram_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        if m.get('AdminRamIdList') is not None:
            self.admin_ram_id_list = m.get('AdminRamIdList')
        return self


class CreateInstanceResponseBody(TeaModel):
    def __init__(self, http_status_code=None, code=None, message=None, data=None, request_id=None, params=None):
        self.http_status_code = http_status_code  # type: int
        self.code = code  # type: str
        self.message = message  # type: str
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        return self


class CreateInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveSkillGroupsFromUserRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, skill_group_id_list=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.skill_group_id_list = skill_group_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveSkillGroupsFromUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        return self


class RemoveSkillGroupsFromUserResponseBody(TeaModel):
    def __init__(self, http_status_code=None, code=None, message=None, data=None, request_id=None):
        self.http_status_code = http_status_code  # type: int
        self.code = code  # type: str
        self.message = message  # type: str
        self.data = data  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveSkillGroupsFromUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RemoveSkillGroupsFromUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemoveSkillGroupsFromUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveSkillGroupsFromUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemoveSkillGroupsFromUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRealtimeAgentStatesRequest(TeaModel):
    def __init__(self, skill_group_id=None, page_number=None, page_size=None, instance_id=None, agent_id_list=None,
                 state_list=None, agent_name=None):
        self.skill_group_id = skill_group_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.instance_id = instance_id  # type: str
        self.agent_id_list = agent_id_list  # type: str
        self.state_list = state_list  # type: str
        self.agent_name = agent_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRealtimeAgentStatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.agent_id_list is not None:
            result['AgentIdList'] = self.agent_id_list
        if self.state_list is not None:
            result['StateList'] = self.state_list
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('AgentIdList') is not None:
            self.agent_id_list = m.get('AgentIdList')
        if m.get('StateList') is not None:
            self.state_list = m.get('StateList')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        return self


class ListRealtimeAgentStatesResponseBodyDataList(TeaModel):
    def __init__(self, extension=None, state_code=None, state=None, agent_id=None, state_time=None, agent_name=None,
                 instance_id=None, counter_party=None, skill_group_id_list=None):
        self.extension = extension  # type: str
        self.state_code = state_code  # type: str
        self.state = state  # type: str
        self.agent_id = agent_id  # type: str
        self.state_time = state_time  # type: long
        self.agent_name = agent_name  # type: str
        self.instance_id = instance_id  # type: str
        self.counter_party = counter_party  # type: str
        self.skill_group_id_list = skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRealtimeAgentStatesResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.state_code is not None:
            result['StateCode'] = self.state_code
        if self.state is not None:
            result['State'] = self.state
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.state_time is not None:
            result['StateTime'] = self.state_time
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.counter_party is not None:
            result['CounterParty'] = self.counter_party
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('StateCode') is not None:
            self.state_code = m.get('StateCode')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('StateTime') is not None:
            self.state_time = m.get('StateTime')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CounterParty') is not None:
            self.counter_party = m.get('CounterParty')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        return self


class ListRealtimeAgentStatesResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListRealtimeAgentStatesResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRealtimeAgentStatesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListRealtimeAgentStatesResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListRealtimeAgentStatesResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: ListRealtimeAgentStatesResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListRealtimeAgentStatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListRealtimeAgentStatesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListRealtimeAgentStatesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListRealtimeAgentStatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListRealtimeAgentStatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRealtimeAgentStatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class LaunchAuthenticationRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, job_id=None, contact_flow_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.contact_flow_id = contact_flow_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchAuthenticationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        return self


class LaunchAuthenticationResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, index=None, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, skill_group_id=None, timestamp=None, associated_data=None, release_reason=None,
                 call_type=None, job_id=None, channel_id=None, user_extension=None, originator=None):
        self.index = index  # type: int
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.user_extension = user_extension  # type: str
        self.originator = originator  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchAuthenticationResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.originator is not None:
            result['Originator'] = self.originator
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        return self


class LaunchAuthenticationResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[LaunchAuthenticationResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(LaunchAuthenticationResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = LaunchAuthenticationResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class LaunchAuthenticationResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchAuthenticationResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class LaunchAuthenticationResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: LaunchAuthenticationResponseBodyDataCallContext
        self.user_context = user_context  # type: LaunchAuthenticationResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(LaunchAuthenticationResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = LaunchAuthenticationResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = LaunchAuthenticationResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class LaunchAuthenticationResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: LaunchAuthenticationResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(LaunchAuthenticationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = LaunchAuthenticationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class LaunchAuthenticationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: LaunchAuthenticationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(LaunchAuthenticationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = LaunchAuthenticationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInstancesRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListInstancesResponseBodyDataListAdminList(TeaModel):
    def __init__(self, display_name=None, extension=None, login_name=None, email=None, work_mode=None, mobile=None,
                 user_id=None, role_name=None, instance_id=None, role_id=None):
        self.display_name = display_name  # type: str
        self.extension = extension  # type: str
        self.login_name = login_name  # type: str
        self.email = email  # type: str
        self.work_mode = work_mode  # type: str
        self.mobile = mobile  # type: str
        self.user_id = user_id  # type: str
        self.role_name = role_name  # type: str
        self.instance_id = instance_id  # type: str
        self.role_id = role_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesResponseBodyDataListAdminList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.email is not None:
            result['Email'] = self.email
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        return self


class ListInstancesResponseBodyDataListNumberList(TeaModel):
    def __init__(self, number=None):
        self.number = number  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesResponseBodyDataListNumberList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.number is not None:
            result['Number'] = self.number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Number') is not None:
            self.number = m.get('Number')
        return self


class ListInstancesResponseBodyDataList(TeaModel):
    def __init__(self, status=None, console_url=None, description=None, create_time=None, aliyun_uid=None, name=None,
                 domain_name=None, id=None, admin_list=None, number_list=None):
        self.status = status  # type: str
        self.console_url = console_url  # type: str
        self.description = description  # type: str
        self.create_time = create_time  # type: long
        self.aliyun_uid = aliyun_uid  # type: str
        self.name = name  # type: str
        self.domain_name = domain_name  # type: str
        self.id = id  # type: str
        self.admin_list = admin_list  # type: list[ListInstancesResponseBodyDataListAdminList]
        self.number_list = number_list  # type: list[ListInstancesResponseBodyDataListNumberList]

    def validate(self):
        if self.admin_list:
            for k in self.admin_list:
                if k:
                    k.validate()
        if self.number_list:
            for k in self.number_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.console_url is not None:
            result['ConsoleUrl'] = self.console_url
        if self.description is not None:
            result['Description'] = self.description
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.aliyun_uid is not None:
            result['AliyunUid'] = self.aliyun_uid
        if self.name is not None:
            result['Name'] = self.name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.id is not None:
            result['Id'] = self.id
        result['AdminList'] = []
        if self.admin_list is not None:
            for k in self.admin_list:
                result['AdminList'].append(k.to_map() if k else None)
        result['NumberList'] = []
        if self.number_list is not None:
            for k in self.number_list:
                result['NumberList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ConsoleUrl') is not None:
            self.console_url = m.get('ConsoleUrl')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('AliyunUid') is not None:
            self.aliyun_uid = m.get('AliyunUid')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        self.admin_list = []
        if m.get('AdminList') is not None:
            for k in m.get('AdminList'):
                temp_model = ListInstancesResponseBodyDataListAdminList()
                self.admin_list.append(temp_model.from_map(k))
        self.number_list = []
        if m.get('NumberList') is not None:
            for k in m.get('NumberList'):
                temp_model = ListInstancesResponseBodyDataListNumberList()
                self.number_list.append(temp_model.from_map(k))
        return self


class ListInstancesResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListInstancesResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListInstancesResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListInstancesResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: ListInstancesResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = ListInstancesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListInstancesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHistoricalInstanceReportRequest(TeaModel):
    def __init__(self, instance_id=None, start_time=None, end_time=None):
        self.instance_id = instance_id  # type: str
        self.start_time = start_time  # type: long
        self.end_time = end_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalInstanceReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class GetHistoricalInstanceReportResponseBodyDataInbound(TeaModel):
    def __init__(self, average_ring_time=None, calls_voicemail=None, max_abandoned_in_ivrtime=None,
                 calls_handled=None, calls_ivrexception=None, calls_abandoned_in_ivr=None, max_work_time=None,
                 total_hold_time=None, max_abandon_time=None, average_abandon_time=None, calls_ringed=None,
                 calls_queuing_failed=None, total_ring_time=None, abandon_rate=None, total_talk_time=None,
                 max_abandoned_in_ring_time=None, calls_blind_transferred=None, average_abandoned_in_ivrtime=None,
                 average_abandoned_in_queue_time=None, max_wait_time=None, average_talk_time=None, calls_attended_transferred=None,
                 total_abandoned_in_ivrtime=None, calls_queuing_overflow=None, calls_abandoned_in_ring=None,
                 total_abandoned_in_ring_time=None, total_work_time=None, average_wait_time=None, average_work_time=None, calls_queued=None,
                 average_abandoned_in_ring_time=None, satisfaction_index=None, calls_abandoned=None, max_abandoned_in_queue_time=None,
                 calls_abandoned_in_voice_navigator=None, total_wait_time=None, max_talk_time=None, max_ring_time=None, total_abandon_time=None,
                 calls_offered=None, calls_queuing_timeout=None, service_level_20=None, max_hold_time=None,
                 calls_forward_to_outside_number=None, satisfaction_rate=None, calls_hold=None, satisfaction_surveys_offered=None,
                 handle_rate=None, satisfaction_surveys_responded=None, average_hold_time=None, calls_abandoned_in_queue=None,
                 total_abandoned_in_queue_time=None):
        self.average_ring_time = average_ring_time  # type: float
        self.calls_voicemail = calls_voicemail  # type: long
        self.max_abandoned_in_ivrtime = max_abandoned_in_ivrtime  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_ivrexception = calls_ivrexception  # type: long
        self.calls_abandoned_in_ivr = calls_abandoned_in_ivr  # type: long
        self.max_work_time = max_work_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.max_abandon_time = max_abandon_time  # type: long
        self.average_abandon_time = average_abandon_time  # type: float
        self.calls_ringed = calls_ringed  # type: long
        self.calls_queuing_failed = calls_queuing_failed  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.abandon_rate = abandon_rate  # type: float
        self.total_talk_time = total_talk_time  # type: long
        self.max_abandoned_in_ring_time = max_abandoned_in_ring_time  # type: long
        self.calls_blind_transferred = calls_blind_transferred  # type: long
        self.average_abandoned_in_ivrtime = average_abandoned_in_ivrtime  # type: float
        self.average_abandoned_in_queue_time = average_abandoned_in_queue_time  # type: float
        self.max_wait_time = max_wait_time  # type: long
        self.average_talk_time = average_talk_time  # type: float
        self.calls_attended_transferred = calls_attended_transferred  # type: long
        self.total_abandoned_in_ivrtime = total_abandoned_in_ivrtime  # type: long
        self.calls_queuing_overflow = calls_queuing_overflow  # type: long
        self.calls_abandoned_in_ring = calls_abandoned_in_ring  # type: long
        self.total_abandoned_in_ring_time = total_abandoned_in_ring_time  # type: long
        self.total_work_time = total_work_time  # type: long
        self.average_wait_time = average_wait_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_queued = calls_queued  # type: long
        self.average_abandoned_in_ring_time = average_abandoned_in_ring_time  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.calls_abandoned = calls_abandoned  # type: long
        self.max_abandoned_in_queue_time = max_abandoned_in_queue_time  # type: long
        self.calls_abandoned_in_voice_navigator = calls_abandoned_in_voice_navigator  # type: long
        self.total_wait_time = total_wait_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.total_abandon_time = total_abandon_time  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_queuing_timeout = calls_queuing_timeout  # type: long
        self.service_level_20 = service_level_20  # type: float
        self.max_hold_time = max_hold_time  # type: long
        self.calls_forward_to_outside_number = calls_forward_to_outside_number  # type: long
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.calls_hold = calls_hold  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.handle_rate = handle_rate  # type: float
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_hold_time = average_hold_time  # type: float
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long
        self.total_abandoned_in_queue_time = total_abandoned_in_queue_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBodyDataInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_voicemail is not None:
            result['CallsVoicemail'] = self.calls_voicemail
        if self.max_abandoned_in_ivrtime is not None:
            result['MaxAbandonedInIVRTime'] = self.max_abandoned_in_ivrtime
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_ivrexception is not None:
            result['CallsIVRException'] = self.calls_ivrexception
        if self.calls_abandoned_in_ivr is not None:
            result['CallsAbandonedInIVR'] = self.calls_abandoned_in_ivr
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.max_abandon_time is not None:
            result['MaxAbandonTime'] = self.max_abandon_time
        if self.average_abandon_time is not None:
            result['AverageAbandonTime'] = self.average_abandon_time
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_queuing_failed is not None:
            result['CallsQueuingFailed'] = self.calls_queuing_failed
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.abandon_rate is not None:
            result['AbandonRate'] = self.abandon_rate
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_abandoned_in_ring_time is not None:
            result['MaxAbandonedInRingTime'] = self.max_abandoned_in_ring_time
        if self.calls_blind_transferred is not None:
            result['CallsBlindTransferred'] = self.calls_blind_transferred
        if self.average_abandoned_in_ivrtime is not None:
            result['AverageAbandonedInIVRTime'] = self.average_abandoned_in_ivrtime
        if self.average_abandoned_in_queue_time is not None:
            result['AverageAbandonedInQueueTime'] = self.average_abandoned_in_queue_time
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.calls_attended_transferred is not None:
            result['CallsAttendedTransferred'] = self.calls_attended_transferred
        if self.total_abandoned_in_ivrtime is not None:
            result['TotalAbandonedInIVRTime'] = self.total_abandoned_in_ivrtime
        if self.calls_queuing_overflow is not None:
            result['CallsQueuingOverflow'] = self.calls_queuing_overflow
        if self.calls_abandoned_in_ring is not None:
            result['CallsAbandonedInRing'] = self.calls_abandoned_in_ring
        if self.total_abandoned_in_ring_time is not None:
            result['TotalAbandonedInRingTime'] = self.total_abandoned_in_ring_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.average_wait_time is not None:
            result['AverageWaitTime'] = self.average_wait_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_queued is not None:
            result['CallsQueued'] = self.calls_queued
        if self.average_abandoned_in_ring_time is not None:
            result['AverageAbandonedInRingTime'] = self.average_abandoned_in_ring_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.calls_abandoned is not None:
            result['CallsAbandoned'] = self.calls_abandoned
        if self.max_abandoned_in_queue_time is not None:
            result['MaxAbandonedInQueueTime'] = self.max_abandoned_in_queue_time
        if self.calls_abandoned_in_voice_navigator is not None:
            result['CallsAbandonedInVoiceNavigator'] = self.calls_abandoned_in_voice_navigator
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.total_abandon_time is not None:
            result['TotalAbandonTime'] = self.total_abandon_time
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_queuing_timeout is not None:
            result['CallsQueuingTimeout'] = self.calls_queuing_timeout
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.calls_forward_to_outside_number is not None:
            result['CallsForwardToOutsideNumber'] = self.calls_forward_to_outside_number
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        if self.total_abandoned_in_queue_time is not None:
            result['TotalAbandonedInQueueTime'] = self.total_abandoned_in_queue_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsVoicemail') is not None:
            self.calls_voicemail = m.get('CallsVoicemail')
        if m.get('MaxAbandonedInIVRTime') is not None:
            self.max_abandoned_in_ivrtime = m.get('MaxAbandonedInIVRTime')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsIVRException') is not None:
            self.calls_ivrexception = m.get('CallsIVRException')
        if m.get('CallsAbandonedInIVR') is not None:
            self.calls_abandoned_in_ivr = m.get('CallsAbandonedInIVR')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('MaxAbandonTime') is not None:
            self.max_abandon_time = m.get('MaxAbandonTime')
        if m.get('AverageAbandonTime') is not None:
            self.average_abandon_time = m.get('AverageAbandonTime')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsQueuingFailed') is not None:
            self.calls_queuing_failed = m.get('CallsQueuingFailed')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('AbandonRate') is not None:
            self.abandon_rate = m.get('AbandonRate')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxAbandonedInRingTime') is not None:
            self.max_abandoned_in_ring_time = m.get('MaxAbandonedInRingTime')
        if m.get('CallsBlindTransferred') is not None:
            self.calls_blind_transferred = m.get('CallsBlindTransferred')
        if m.get('AverageAbandonedInIVRTime') is not None:
            self.average_abandoned_in_ivrtime = m.get('AverageAbandonedInIVRTime')
        if m.get('AverageAbandonedInQueueTime') is not None:
            self.average_abandoned_in_queue_time = m.get('AverageAbandonedInQueueTime')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('CallsAttendedTransferred') is not None:
            self.calls_attended_transferred = m.get('CallsAttendedTransferred')
        if m.get('TotalAbandonedInIVRTime') is not None:
            self.total_abandoned_in_ivrtime = m.get('TotalAbandonedInIVRTime')
        if m.get('CallsQueuingOverflow') is not None:
            self.calls_queuing_overflow = m.get('CallsQueuingOverflow')
        if m.get('CallsAbandonedInRing') is not None:
            self.calls_abandoned_in_ring = m.get('CallsAbandonedInRing')
        if m.get('TotalAbandonedInRingTime') is not None:
            self.total_abandoned_in_ring_time = m.get('TotalAbandonedInRingTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('AverageWaitTime') is not None:
            self.average_wait_time = m.get('AverageWaitTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsQueued') is not None:
            self.calls_queued = m.get('CallsQueued')
        if m.get('AverageAbandonedInRingTime') is not None:
            self.average_abandoned_in_ring_time = m.get('AverageAbandonedInRingTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('CallsAbandoned') is not None:
            self.calls_abandoned = m.get('CallsAbandoned')
        if m.get('MaxAbandonedInQueueTime') is not None:
            self.max_abandoned_in_queue_time = m.get('MaxAbandonedInQueueTime')
        if m.get('CallsAbandonedInVoiceNavigator') is not None:
            self.calls_abandoned_in_voice_navigator = m.get('CallsAbandonedInVoiceNavigator')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('TotalAbandonTime') is not None:
            self.total_abandon_time = m.get('TotalAbandonTime')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsQueuingTimeout') is not None:
            self.calls_queuing_timeout = m.get('CallsQueuingTimeout')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('CallsForwardToOutsideNumber') is not None:
            self.calls_forward_to_outside_number = m.get('CallsForwardToOutsideNumber')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        if m.get('TotalAbandonedInQueueTime') is not None:
            self.total_abandoned_in_queue_time = m.get('TotalAbandonedInQueueTime')
        return self


class GetHistoricalInstanceReportResponseBodyDataOutbound(TeaModel):
    def __init__(self, average_ring_time=None, calls_dialed=None, calls_answered=None, total_work_time=None,
                 max_work_time=None, total_dialing_time=None, total_hold_time=None, average_work_time=None,
                 satisfaction_index=None, calls_ringed=None, total_ring_time=None, max_talk_time=None, max_ring_time=None,
                 total_talk_time=None, max_dialing_time=None, calls_blind_transferred=None, answer_rate=None, max_hold_time=None,
                 average_talk_time=None, satisfaction_rate=None, calls_attended_transferred=None, calls_hold=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, average_hold_time=None, average_dialing_time=None):
        self.average_ring_time = average_ring_time  # type: float
        self.calls_dialed = calls_dialed  # type: long
        self.calls_answered = calls_answered  # type: long
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.calls_ringed = calls_ringed  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.calls_blind_transferred = calls_blind_transferred  # type: long
        self.answer_rate = answer_rate  # type: float
        self.max_hold_time = max_hold_time  # type: long
        self.average_talk_time = average_talk_time  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.calls_attended_transferred = calls_attended_transferred  # type: long
        self.calls_hold = calls_hold  # type: int
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_hold_time = average_hold_time  # type: float
        self.average_dialing_time = average_dialing_time  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBodyDataOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.calls_blind_transferred is not None:
            result['CallsBlindTransferred'] = self.calls_blind_transferred
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.calls_attended_transferred is not None:
            result['CallsAttendedTransferred'] = self.calls_attended_transferred
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('CallsBlindTransferred') is not None:
            self.calls_blind_transferred = m.get('CallsBlindTransferred')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('CallsAttendedTransferred') is not None:
            self.calls_attended_transferred = m.get('CallsAttendedTransferred')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        return self


class GetHistoricalInstanceReportResponseBodyDataOverall(TeaModel):
    def __init__(self, total_talk_time=None, total_logged_in_time=None, occupancy_rate=None, total_work_time=None,
                 max_hold_time=None, max_work_time=None, average_break_time=None, total_hold_time=None, satisfaction_rate=None,
                 max_break_time=None, average_work_time=None, average_talk_time=None, satisfaction_index=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, max_ready_time=None, average_ready_time=None,
                 average_hold_time=None, total_ready_time=None, total_break_time=None, max_talk_time=None, total_calls=None):
        self.total_talk_time = total_talk_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.total_work_time = total_work_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_break_time = average_break_time  # type: float
        self.total_hold_time = total_hold_time  # type: long
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.max_break_time = max_break_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.average_ready_time = average_ready_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.total_ready_time = total_ready_time  # type: long
        self.total_break_time = total_break_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBodyDataOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class GetHistoricalInstanceReportResponseBodyData(TeaModel):
    def __init__(self, inbound=None, outbound=None, overall=None):
        self.inbound = inbound  # type: GetHistoricalInstanceReportResponseBodyDataInbound
        self.outbound = outbound  # type: GetHistoricalInstanceReportResponseBodyDataOutbound
        self.overall = overall  # type: GetHistoricalInstanceReportResponseBodyDataOverall

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Inbound') is not None:
            temp_model = GetHistoricalInstanceReportResponseBodyDataInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = GetHistoricalInstanceReportResponseBodyDataOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = GetHistoricalInstanceReportResponseBodyDataOverall()
            self.overall = temp_model.from_map(m['Overall'])
        return self


class GetHistoricalInstanceReportResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: GetHistoricalInstanceReportResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetHistoricalInstanceReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetHistoricalInstanceReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetHistoricalInstanceReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetHistoricalInstanceReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveUsersRequest(TeaModel):
    def __init__(self, instance_id=None, user_id_list=None):
        self.instance_id = instance_id  # type: str
        self.user_id_list = user_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveUsersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id_list is not None:
            result['UserIdList'] = self.user_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserIdList') is not None:
            self.user_id_list = m.get('UserIdList')
        return self


class RemoveUsersResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveUsersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        return self


class RemoveUsersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemoveUsersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveUsersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemoveUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartBack2BackCallRequest(TeaModel):
    def __init__(self, instance_id=None, caller=None, callee=None, timeout_seconds=None, broker=None,
                 additional_broker=None, tags=None):
        self.instance_id = instance_id  # type: str
        self.caller = caller  # type: str
        self.callee = callee  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.broker = broker  # type: str
        self.additional_broker = additional_broker  # type: str
        self.tags = tags  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartBack2BackCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.broker is not None:
            result['Broker'] = self.broker
        if self.additional_broker is not None:
            result['AdditionalBroker'] = self.additional_broker
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('Broker') is not None:
            self.broker = m.get('Broker')
        if m.get('AdditionalBroker') is not None:
            self.additional_broker = m.get('AdditionalBroker')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class StartBack2BackCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, timestamp=None, associated_data=None, release_reason=None, call_type=None, job_id=None,
                 channel_id=None, originator=None, user_extension=None):
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.originator = originator  # type: str
        self.user_extension = user_extension  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartBack2BackCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        return self


class StartBack2BackCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[StartBack2BackCallResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(StartBack2BackCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = StartBack2BackCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class StartBack2BackCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, uri=None, device_state=None, mobile=None,
                 job_id=None, user_state=None, signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.uri = uri  # type: str
        self.device_state = device_state  # type: str
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartBack2BackCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.uri is not None:
            result['Uri'] = self.uri
        if self.device_state is not None:
            result['DeviceState'] = self.device_state
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Uri') is not None:
            self.uri = m.get('Uri')
        if m.get('DeviceState') is not None:
            self.device_state = m.get('DeviceState')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class StartBack2BackCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: StartBack2BackCallResponseBodyDataCallContext
        self.user_context = user_context  # type: StartBack2BackCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(StartBack2BackCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = StartBack2BackCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = StartBack2BackCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class StartBack2BackCallResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: StartBack2BackCallResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(StartBack2BackCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = StartBack2BackCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class StartBack2BackCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: StartBack2BackCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StartBack2BackCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StartBack2BackCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, extension=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.extension = extension  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.extension is not None:
            result['Extension'] = self.extension
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        return self


class GetUserResponseBodyData(TeaModel):
    def __init__(self, display_name=None, extension=None, login_name=None, email=None, work_mode=None, mobile=None,
                 user_id=None, role_name=None, instance_id=None, role_id=None):
        self.display_name = display_name  # type: str
        self.extension = extension  # type: str
        self.login_name = login_name  # type: str
        self.email = email  # type: str
        self.work_mode = work_mode  # type: str
        self.mobile = mobile  # type: str
        self.user_id = user_id  # type: str
        self.role_name = role_name  # type: str
        self.instance_id = instance_id  # type: str
        self.role_id = role_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.email is not None:
            result['Email'] = self.email
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        return self


class GetUserResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: GetUserResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = GetUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemovePhoneNumbersFromSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, number_list=None, skill_group_id=None):
        self.instance_id = instance_id  # type: str
        self.number_list = number_list  # type: str
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemovePhoneNumbersFromSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class RemovePhoneNumbersFromSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemovePhoneNumbersFromSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RemovePhoneNumbersFromSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemovePhoneNumbersFromSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemovePhoneNumbersFromSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemovePhoneNumbersFromSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CompleteAttendedTransferRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, job_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CompleteAttendedTransferRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CompleteAttendedTransferResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, index=None, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, skill_group_id=None, timestamp=None, associated_data=None, release_reason=None,
                 call_type=None, job_id=None, channel_id=None, user_extension=None, originator=None):
        self.index = index  # type: int
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.user_extension = user_extension  # type: str
        self.originator = originator  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CompleteAttendedTransferResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.originator is not None:
            result['Originator'] = self.originator
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        return self


class CompleteAttendedTransferResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[CompleteAttendedTransferResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CompleteAttendedTransferResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = CompleteAttendedTransferResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class CompleteAttendedTransferResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CompleteAttendedTransferResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class CompleteAttendedTransferResponseBodyData(TeaModel):
    def __init__(self, context_id=None, call_context=None, user_context=None):
        self.context_id = context_id  # type: long
        self.call_context = call_context  # type: CompleteAttendedTransferResponseBodyDataCallContext
        self.user_context = user_context  # type: CompleteAttendedTransferResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(CompleteAttendedTransferResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('CallContext') is not None:
            temp_model = CompleteAttendedTransferResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = CompleteAttendedTransferResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class CompleteAttendedTransferResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: CompleteAttendedTransferResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CompleteAttendedTransferResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = CompleteAttendedTransferResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CompleteAttendedTransferResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CompleteAttendedTransferResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CompleteAttendedTransferResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CompleteAttendedTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ResetUserPasswordRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, password=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.password = password  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ResetUserPasswordRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.password is not None:
            result['Password'] = self.password
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        return self


class ResetUserPasswordResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ResetUserPasswordResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ResetUserPasswordResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ResetUserPasswordResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ResetUserPasswordResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ResetUserPasswordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTurnServerListRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTurnServerListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetTurnServerListResponseBody(TeaModel):
    def __init__(self, http_status_code=None, code=None, message=None, data=None, request_id=None, params=None):
        self.http_status_code = http_status_code  # type: int
        self.code = code  # type: str
        self.message = message  # type: str
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTurnServerListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        return self


class GetTurnServerListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetTurnServerListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTurnServerListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetTurnServerListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNumberLocationRequest(TeaModel):
    def __init__(self, instance_id=None, number=None):
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNumberLocationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        return self


class GetNumberLocationResponseBodyData(TeaModel):
    def __init__(self, number=None, city=None, province=None):
        self.number = number  # type: str
        self.city = city  # type: str
        self.province = province  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNumberLocationResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.number is not None:
            result['Number'] = self.number
        if self.city is not None:
            result['City'] = self.city
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class GetNumberLocationResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: GetNumberLocationResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetNumberLocationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetNumberLocationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetNumberLocationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetNumberLocationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetNumberLocationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNumberLocationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRamUsersRequest(TeaModel):
    def __init__(self, instance_id=None, search_pattern=None, page_number=None, page_size=None):
        self.instance_id = instance_id  # type: str
        self.search_pattern = search_pattern  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRamUsersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListRamUsersResponseBodyDataList(TeaModel):
    def __init__(self, display_name=None, email=None, login_name=None, mobile=None, aliyun_uid=None, primary=None,
                 ram_id=None):
        self.display_name = display_name  # type: str
        self.email = email  # type: str
        self.login_name = login_name  # type: str
        self.mobile = mobile  # type: str
        self.aliyun_uid = aliyun_uid  # type: long
        self.primary = primary  # type: bool
        self.ram_id = ram_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRamUsersResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.aliyun_uid is not None:
            result['AliyunUid'] = self.aliyun_uid
        if self.primary is not None:
            result['Primary'] = self.primary
        if self.ram_id is not None:
            result['RamId'] = self.ram_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('AliyunUid') is not None:
            self.aliyun_uid = m.get('AliyunUid')
        if m.get('Primary') is not None:
            self.primary = m.get('Primary')
        if m.get('RamId') is not None:
            self.ram_id = m.get('RamId')
        return self


class ListRamUsersResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListRamUsersResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRamUsersResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListRamUsersResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListRamUsersResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: ListRamUsersResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListRamUsersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = ListRamUsersResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListRamUsersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListRamUsersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListRamUsersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRamUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MuteCallRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, job_id=None, channel_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MuteCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        return self


class MuteCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, index=None, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, timestamp=None, associated_data=None, release_reason=None, call_type=None, job_id=None,
                 channel_id=None, user_extension=None, originator=None):
        self.index = index  # type: int
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.user_extension = user_extension  # type: str
        self.originator = originator  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MuteCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.originator is not None:
            result['Originator'] = self.originator
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        return self


class MuteCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[MuteCallResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(MuteCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = MuteCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class MuteCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(MuteCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class MuteCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: MuteCallResponseBodyDataCallContext
        self.user_context = user_context  # type: MuteCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(MuteCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = MuteCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = MuteCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class MuteCallResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: MuteCallResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(MuteCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = MuteCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class MuteCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: MuteCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(MuteCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = MuteCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AnswerCallRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, job_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AnswerCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class AnswerCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 skill_group_id=None, timestamp=None, associated_data=None, release_reason=None, call_type=None, job_id=None,
                 channel_id=None, originator=None, user_extension=None):
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.originator = originator  # type: str
        self.user_extension = user_extension  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AnswerCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        return self


class AnswerCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, job_id=None, instance_id=None, channel_contexts=None):
        self.job_id = job_id  # type: str
        self.instance_id = instance_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[AnswerCallResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AnswerCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = AnswerCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class AnswerCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AnswerCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class AnswerCallResponseBodyData(TeaModel):
    def __init__(self, context_id=None, call_context=None, user_context=None):
        self.context_id = context_id  # type: long
        self.call_context = call_context  # type: AnswerCallResponseBodyDataCallContext
        self.user_context = user_context  # type: AnswerCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(AnswerCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('CallContext') is not None:
            temp_model = AnswerCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = AnswerCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class AnswerCallResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: AnswerCallResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AnswerCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = AnswerCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class AnswerCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AnswerCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AnswerCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AnswerCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIntervalAgentReportRequest(TeaModel):
    def __init__(self, agent_id=None, start_time=None, end_time=None, instance_id=None, interval=None):
        self.agent_id = agent_id  # type: str
        self.start_time = start_time  # type: long
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.interval = interval  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalAgentReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.interval is not None:
            result['Interval'] = self.interval
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        return self


class ListIntervalAgentReportResponseBodyDataInbound(TeaModel):
    def __init__(self, average_ring_time=None, calls_handled=None, total_work_time=None,
                 calls_attended_transfer_out=None, max_work_time=None, total_hold_time=None, average_work_time=None,
                 calls_blind_transfer_in=None, satisfaction_index=None, calls_ringed=None, calls_attended_transfer_in=None,
                 calls_blind_transfer_out=None, total_ring_time=None, max_talk_time=None, max_ring_time=None, total_talk_time=None,
                 calls_offered=None, max_hold_time=None, average_talk_time=None, satisfaction_rate=None, calls_hold=None,
                 satisfaction_surveys_offered=None, handle_rate=None, satisfaction_surveys_responded=None, average_hold_time=None):
        self.average_ring_time = average_ring_time  # type: float
        self.calls_handled = calls_handled  # type: long
        self.total_work_time = total_work_time  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.max_work_time = max_work_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.calls_ringed = calls_ringed  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.calls_offered = calls_offered  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.average_talk_time = average_talk_time  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.calls_hold = calls_hold  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.handle_rate = handle_rate  # type: float
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_hold_time = average_hold_time  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalAgentReportResponseBodyDataInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        return self


class ListIntervalAgentReportResponseBodyDataOutbound(TeaModel):
    def __init__(self, average_ring_time=None, calls_dialed=None, calls_answered=None, total_work_time=None,
                 calls_attended_transfer_out=None, max_work_time=None, total_dialing_time=None, total_hold_time=None, average_work_time=None,
                 calls_blind_transfer_in=None, satisfaction_index=None, calls_ringed=None, calls_attended_transfer_in=None,
                 calls_blind_transfer_out=None, total_ring_time=None, max_talk_time=None, max_ring_time=None, total_talk_time=None,
                 max_dialing_time=None, answer_rate=None, max_hold_time=None, average_talk_time=None, satisfaction_rate=None,
                 calls_hold=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 average_hold_time=None, average_dialing_time=None):
        self.average_ring_time = average_ring_time  # type: float
        self.calls_dialed = calls_dialed  # type: long
        self.calls_answered = calls_answered  # type: long
        self.total_work_time = total_work_time  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.max_work_time = max_work_time  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.calls_ringed = calls_ringed  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.answer_rate = answer_rate  # type: float
        self.max_hold_time = max_hold_time  # type: long
        self.average_talk_time = average_talk_time  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.calls_hold = calls_hold  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_hold_time = average_hold_time  # type: float
        self.average_dialing_time = average_dialing_time  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalAgentReportResponseBodyDataOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        return self


class ListIntervalAgentReportResponseBodyDataOverall(TeaModel):
    def __init__(self, occupancy_rate=None, total_work_time=None, max_work_time=None, total_hold_time=None,
                 average_work_time=None, max_break_time=None, satisfaction_index=None, max_ready_time=None, max_talk_time=None,
                 total_ready_time=None, last_checkout_time=None, total_calls=None, total_logged_in_time=None, total_talk_time=None,
                 max_hold_time=None, average_break_time=None, average_talk_time=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, first_check_in_time=None, satisfaction_surveys_responded=None, average_hold_time=None,
                 average_ready_time=None, total_break_time=None):
        self.occupancy_rate = occupancy_rate  # type: float
        self.total_work_time = total_work_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.max_break_time = max_break_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.max_ready_time = max_ready_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.last_checkout_time = last_checkout_time  # type: long
        self.total_calls = total_calls  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.average_break_time = average_break_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.first_check_in_time = first_check_in_time  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_hold_time = average_hold_time  # type: float
        self.average_ready_time = average_ready_time  # type: float
        self.total_break_time = total_break_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalAgentReportResponseBodyDataOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.last_checkout_time is not None:
            result['LastCheckoutTime'] = self.last_checkout_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.first_check_in_time is not None:
            result['FirstCheckInTime'] = self.first_check_in_time
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('LastCheckoutTime') is not None:
            self.last_checkout_time = m.get('LastCheckoutTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('FirstCheckInTime') is not None:
            self.first_check_in_time = m.get('FirstCheckInTime')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        return self


class ListIntervalAgentReportResponseBodyData(TeaModel):
    def __init__(self, stats_time=None, inbound=None, outbound=None, overall=None):
        self.stats_time = stats_time  # type: long
        self.inbound = inbound  # type: ListIntervalAgentReportResponseBodyDataInbound
        self.outbound = outbound  # type: ListIntervalAgentReportResponseBodyDataOutbound
        self.overall = overall  # type: ListIntervalAgentReportResponseBodyDataOverall

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(ListIntervalAgentReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stats_time is not None:
            result['StatsTime'] = self.stats_time
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StatsTime') is not None:
            self.stats_time = m.get('StatsTime')
        if m.get('Inbound') is not None:
            temp_model = ListIntervalAgentReportResponseBodyDataInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = ListIntervalAgentReportResponseBodyDataOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = ListIntervalAgentReportResponseBodyDataOverall()
            self.overall = temp_model.from_map(m['Overall'])
        return self


class ListIntervalAgentReportResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: list[ListIntervalAgentReportResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListIntervalAgentReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListIntervalAgentReportResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListIntervalAgentReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListIntervalAgentReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListIntervalAgentReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListIntervalAgentReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCallDetailRecordsRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, start_time=None, end_time=None, contact_type=None,
                 contact_disposition=None, contact_id=None, agent_id=None, skill_group_id=None, sort_order=None, instance_id=None,
                 order_by_field=None, criteria=None, calling_number=None, called_number=None, satisfaction_list=None,
                 satisfaction_survey_channel=None, satisfaction_description_list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.start_time = start_time  # type: long
        self.end_time = end_time  # type: long
        self.contact_type = contact_type  # type: str
        self.contact_disposition = contact_disposition  # type: str
        self.contact_id = contact_id  # type: str
        self.agent_id = agent_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.sort_order = sort_order  # type: str
        self.instance_id = instance_id  # type: str
        self.order_by_field = order_by_field  # type: str
        self.criteria = criteria  # type: str
        self.calling_number = calling_number  # type: str
        self.called_number = called_number  # type: str
        self.satisfaction_list = satisfaction_list  # type: str
        self.satisfaction_survey_channel = satisfaction_survey_channel  # type: str
        self.satisfaction_description_list = satisfaction_description_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCallDetailRecordsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.contact_type is not None:
            result['ContactType'] = self.contact_type
        if self.contact_disposition is not None:
            result['ContactDisposition'] = self.contact_disposition
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.sort_order is not None:
            result['SortOrder'] = self.sort_order
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.order_by_field is not None:
            result['OrderByField'] = self.order_by_field
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.satisfaction_list is not None:
            result['SatisfactionList'] = self.satisfaction_list
        if self.satisfaction_survey_channel is not None:
            result['SatisfactionSurveyChannel'] = self.satisfaction_survey_channel
        if self.satisfaction_description_list is not None:
            result['SatisfactionDescriptionList'] = self.satisfaction_description_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ContactType') is not None:
            self.contact_type = m.get('ContactType')
        if m.get('ContactDisposition') is not None:
            self.contact_disposition = m.get('ContactDisposition')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SortOrder') is not None:
            self.sort_order = m.get('SortOrder')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrderByField') is not None:
            self.order_by_field = m.get('OrderByField')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('SatisfactionList') is not None:
            self.satisfaction_list = m.get('SatisfactionList')
        if m.get('SatisfactionSurveyChannel') is not None:
            self.satisfaction_survey_channel = m.get('SatisfactionSurveyChannel')
        if m.get('SatisfactionDescriptionList') is not None:
            self.satisfaction_description_list = m.get('SatisfactionDescriptionList')
        return self


class ListCallDetailRecordsResponseBodyDataList(TeaModel):
    def __init__(self, contact_disposition=None, contact_type=None, established_time=None, called_number=None,
                 additional_broker=None, satisfaction_index=None, satisfaction_survey_channel=None, release_time=None,
                 wait_time=None, skill_group_names=None, ivr_time=None, satisfaction_description=None,
                 release_initiator=None, agent_ids=None, call_duration=None, recording_ready=None, instance_id=None, ring_time=None,
                 satisfaction_survey_offered=None, agent_names=None, start_time=None, contact_id=None, recording_duration=None,
                 calling_number=None, queue_time=None, broker=None, skill_group_ids=None, caller_location=None,
                 callee_location=None):
        self.contact_disposition = contact_disposition  # type: str
        self.contact_type = contact_type  # type: str
        self.established_time = established_time  # type: long
        self.called_number = called_number  # type: str
        self.additional_broker = additional_broker  # type: str
        self.satisfaction_index = satisfaction_index  # type: int
        self.satisfaction_survey_channel = satisfaction_survey_channel  # type: str
        self.release_time = release_time  # type: long
        self.wait_time = wait_time  # type: long
        self.skill_group_names = skill_group_names  # type: str
        self.ivr_time = ivr_time  # type: long
        self.satisfaction_description = satisfaction_description  # type: str
        self.release_initiator = release_initiator  # type: str
        self.agent_ids = agent_ids  # type: str
        self.call_duration = call_duration  # type: str
        self.recording_ready = recording_ready  # type: bool
        self.instance_id = instance_id  # type: str
        self.ring_time = ring_time  # type: long
        self.satisfaction_survey_offered = satisfaction_survey_offered  # type: bool
        self.agent_names = agent_names  # type: str
        self.start_time = start_time  # type: long
        self.contact_id = contact_id  # type: str
        self.recording_duration = recording_duration  # type: long
        self.calling_number = calling_number  # type: str
        self.queue_time = queue_time  # type: long
        self.broker = broker  # type: str
        self.skill_group_ids = skill_group_ids  # type: str
        self.caller_location = caller_location  # type: str
        self.callee_location = callee_location  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCallDetailRecordsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_disposition is not None:
            result['ContactDisposition'] = self.contact_disposition
        if self.contact_type is not None:
            result['ContactType'] = self.contact_type
        if self.established_time is not None:
            result['EstablishedTime'] = self.established_time
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.additional_broker is not None:
            result['AdditionalBroker'] = self.additional_broker
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_survey_channel is not None:
            result['SatisfactionSurveyChannel'] = self.satisfaction_survey_channel
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.wait_time is not None:
            result['WaitTime'] = self.wait_time
        if self.skill_group_names is not None:
            result['SkillGroupNames'] = self.skill_group_names
        if self.ivr_time is not None:
            result['IvrTime'] = self.ivr_time
        if self.satisfaction_description is not None:
            result['SatisfactionDescription'] = self.satisfaction_description
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.call_duration is not None:
            result['CallDuration'] = self.call_duration
        if self.recording_ready is not None:
            result['RecordingReady'] = self.recording_ready
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ring_time is not None:
            result['RingTime'] = self.ring_time
        if self.satisfaction_survey_offered is not None:
            result['SatisfactionSurveyOffered'] = self.satisfaction_survey_offered
        if self.agent_names is not None:
            result['AgentNames'] = self.agent_names
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.recording_duration is not None:
            result['RecordingDuration'] = self.recording_duration
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.queue_time is not None:
            result['QueueTime'] = self.queue_time
        if self.broker is not None:
            result['Broker'] = self.broker
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        if self.caller_location is not None:
            result['CallerLocation'] = self.caller_location
        if self.callee_location is not None:
            result['CalleeLocation'] = self.callee_location
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactDisposition') is not None:
            self.contact_disposition = m.get('ContactDisposition')
        if m.get('ContactType') is not None:
            self.contact_type = m.get('ContactType')
        if m.get('EstablishedTime') is not None:
            self.established_time = m.get('EstablishedTime')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('AdditionalBroker') is not None:
            self.additional_broker = m.get('AdditionalBroker')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveyChannel') is not None:
            self.satisfaction_survey_channel = m.get('SatisfactionSurveyChannel')
        if m.get('ReleaseTime') is not None:
            self.release_time = m.get('ReleaseTime')
        if m.get('WaitTime') is not None:
            self.wait_time = m.get('WaitTime')
        if m.get('SkillGroupNames') is not None:
            self.skill_group_names = m.get('SkillGroupNames')
        if m.get('IvrTime') is not None:
            self.ivr_time = m.get('IvrTime')
        if m.get('SatisfactionDescription') is not None:
            self.satisfaction_description = m.get('SatisfactionDescription')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CallDuration') is not None:
            self.call_duration = m.get('CallDuration')
        if m.get('RecordingReady') is not None:
            self.recording_ready = m.get('RecordingReady')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RingTime') is not None:
            self.ring_time = m.get('RingTime')
        if m.get('SatisfactionSurveyOffered') is not None:
            self.satisfaction_survey_offered = m.get('SatisfactionSurveyOffered')
        if m.get('AgentNames') is not None:
            self.agent_names = m.get('AgentNames')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('RecordingDuration') is not None:
            self.recording_duration = m.get('RecordingDuration')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('QueueTime') is not None:
            self.queue_time = m.get('QueueTime')
        if m.get('Broker') is not None:
            self.broker = m.get('Broker')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        if m.get('CallerLocation') is not None:
            self.caller_location = m.get('CallerLocation')
        if m.get('CalleeLocation') is not None:
            self.callee_location = m.get('CalleeLocation')
        return self


class ListCallDetailRecordsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListCallDetailRecordsResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCallDetailRecordsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListCallDetailRecordsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListCallDetailRecordsResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: ListCallDetailRecordsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListCallDetailRecordsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListCallDetailRecordsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListCallDetailRecordsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListCallDetailRecordsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCallDetailRecordsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListCallDetailRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemovePhoneNumbersRequest(TeaModel):
    def __init__(self, instance_id=None, number_list=None):
        self.instance_id = instance_id  # type: str
        self.number_list = number_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemovePhoneNumbersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        return self


class RemovePhoneNumbersResponseBody(TeaModel):
    def __init__(self, http_status_code=None, code=None, message=None, data=None, request_id=None, failure_list=None,
                 params=None):
        self.http_status_code = http_status_code  # type: int
        self.code = code  # type: str
        self.message = message  # type: str
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.failure_list = failure_list  # type: list[str]
        self.params = params  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemovePhoneNumbersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.failure_list is not None:
            result['FailureList'] = self.failure_list
        if self.params is not None:
            result['Params'] = self.params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FailureList') is not None:
            self.failure_list = m.get('FailureList')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        return self


class RemovePhoneNumbersResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemovePhoneNumbersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemovePhoneNumbersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemovePhoneNumbersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelAttendedTransferRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, job_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelAttendedTransferRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelAttendedTransferResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, index=None, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, timestamp=None, associated_data=None, release_reason=None, call_type=None, job_id=None,
                 channel_id=None, user_extension=None, originator=None):
        self.index = index  # type: int
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.user_extension = user_extension  # type: str
        self.originator = originator  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelAttendedTransferResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.originator is not None:
            result['Originator'] = self.originator
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        return self


class CancelAttendedTransferResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[CancelAttendedTransferResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CancelAttendedTransferResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = CancelAttendedTransferResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class CancelAttendedTransferResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelAttendedTransferResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class CancelAttendedTransferResponseBodyData(TeaModel):
    def __init__(self, context_id=None, call_context=None, user_context=None):
        self.context_id = context_id  # type: long
        self.call_context = call_context  # type: CancelAttendedTransferResponseBodyDataCallContext
        self.user_context = user_context  # type: CancelAttendedTransferResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(CancelAttendedTransferResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('CallContext') is not None:
            temp_model = CancelAttendedTransferResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = CancelAttendedTransferResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class CancelAttendedTransferResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: CancelAttendedTransferResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CancelAttendedTransferResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = CancelAttendedTransferResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CancelAttendedTransferResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CancelAttendedTransferResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelAttendedTransferResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelAttendedTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class TakeBreakRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, code=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.code = code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(TakeBreakRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class TakeBreakResponseBodyData(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(TakeBreakResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class TakeBreakResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: TakeBreakResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(TakeBreakResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = TakeBreakResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class TakeBreakResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: TakeBreakResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(TakeBreakResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = TakeBreakResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHistoricalSkillGroupReportRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, skill_group_id_list=None, start_time=None, end_time=None,
                 instance_id=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.skill_group_id_list = skill_group_id_list  # type: str
        self.start_time = start_time  # type: long
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListHistoricalSkillGroupReportResponseBodyDataListInbound(TeaModel):
    def __init__(self, average_ring_time=None, calls_overflow=None, calls_abandoned_in_ring=None,
                 calls_handled=None, total_work_time=None, total_abandoned_in_ring_time=None, max_work_time=None,
                 calls_attended_transfer_out=None, average_wait_time=None, total_hold_time=None, max_abandon_time=None, average_work_time=None,
                 calls_queued=None, calls_blind_transfer_in=None, satisfaction_index=None, average_abandoned_in_ring_time=None,
                 average_abandon_time=None, calls_ringed=None, calls_blind_transfer_out=None, calls_attended_transfer_in=None,
                 calls_abandoned=None, max_abandoned_in_queue_time=None, total_wait_time=None, total_ring_time=None,
                 max_talk_time=None, max_ring_time=None, abandon_rate=None, total_talk_time=None, total_abandon_time=None,
                 calls_offered=None, max_abandoned_in_ring_time=None, max_wait_time=None, average_abandoned_in_queue_time=None,
                 service_level_20=None, max_hold_time=None, satisfaction_rate=None, average_talk_time=None, calls_hold=None,
                 satisfaction_surveys_offered=None, handle_rate=None, calls_timeout=None, satisfaction_surveys_responded=None,
                 average_hold_time=None, total_abandoned_in_queue_time=None, calls_abandoned_in_queue=None):
        self.average_ring_time = average_ring_time  # type: float
        self.calls_overflow = calls_overflow  # type: long
        self.calls_abandoned_in_ring = calls_abandoned_in_ring  # type: long
        self.calls_handled = calls_handled  # type: long
        self.total_work_time = total_work_time  # type: long
        self.total_abandoned_in_ring_time = total_abandoned_in_ring_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.average_wait_time = average_wait_time  # type: float
        self.total_hold_time = total_hold_time  # type: long
        self.max_abandon_time = max_abandon_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.calls_queued = calls_queued  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.average_abandoned_in_ring_time = average_abandoned_in_ring_time  # type: float
        self.average_abandon_time = average_abandon_time  # type: float
        self.calls_ringed = calls_ringed  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_abandoned = calls_abandoned  # type: long
        self.max_abandoned_in_queue_time = max_abandoned_in_queue_time  # type: long
        self.total_wait_time = total_wait_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.abandon_rate = abandon_rate  # type: float
        self.total_talk_time = total_talk_time  # type: long
        self.total_abandon_time = total_abandon_time  # type: long
        self.calls_offered = calls_offered  # type: long
        self.max_abandoned_in_ring_time = max_abandoned_in_ring_time  # type: long
        self.max_wait_time = max_wait_time  # type: long
        self.average_abandoned_in_queue_time = average_abandoned_in_queue_time  # type: float
        self.service_level_20 = service_level_20  # type: float
        self.max_hold_time = max_hold_time  # type: long
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.calls_hold = calls_hold  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.handle_rate = handle_rate  # type: float
        self.calls_timeout = calls_timeout  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_hold_time = average_hold_time  # type: float
        self.total_abandoned_in_queue_time = total_abandoned_in_queue_time  # type: long
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyDataListInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_overflow is not None:
            result['CallsOverflow'] = self.calls_overflow
        if self.calls_abandoned_in_ring is not None:
            result['CallsAbandonedInRing'] = self.calls_abandoned_in_ring
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.total_abandoned_in_ring_time is not None:
            result['TotalAbandonedInRingTime'] = self.total_abandoned_in_ring_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.average_wait_time is not None:
            result['AverageWaitTime'] = self.average_wait_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.max_abandon_time is not None:
            result['MaxAbandonTime'] = self.max_abandon_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_queued is not None:
            result['CallsQueued'] = self.calls_queued
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.average_abandoned_in_ring_time is not None:
            result['AverageAbandonedInRingTime'] = self.average_abandoned_in_ring_time
        if self.average_abandon_time is not None:
            result['AverageAbandonTime'] = self.average_abandon_time
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_abandoned is not None:
            result['CallsAbandoned'] = self.calls_abandoned
        if self.max_abandoned_in_queue_time is not None:
            result['MaxAbandonedInQueueTime'] = self.max_abandoned_in_queue_time
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.abandon_rate is not None:
            result['AbandonRate'] = self.abandon_rate
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_abandon_time is not None:
            result['TotalAbandonTime'] = self.total_abandon_time
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.max_abandoned_in_ring_time is not None:
            result['MaxAbandonedInRingTime'] = self.max_abandoned_in_ring_time
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.average_abandoned_in_queue_time is not None:
            result['AverageAbandonedInQueueTime'] = self.average_abandoned_in_queue_time
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.calls_timeout is not None:
            result['CallsTimeout'] = self.calls_timeout
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.total_abandoned_in_queue_time is not None:
            result['TotalAbandonedInQueueTime'] = self.total_abandoned_in_queue_time
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsOverflow') is not None:
            self.calls_overflow = m.get('CallsOverflow')
        if m.get('CallsAbandonedInRing') is not None:
            self.calls_abandoned_in_ring = m.get('CallsAbandonedInRing')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('TotalAbandonedInRingTime') is not None:
            self.total_abandoned_in_ring_time = m.get('TotalAbandonedInRingTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('AverageWaitTime') is not None:
            self.average_wait_time = m.get('AverageWaitTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('MaxAbandonTime') is not None:
            self.max_abandon_time = m.get('MaxAbandonTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsQueued') is not None:
            self.calls_queued = m.get('CallsQueued')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('AverageAbandonedInRingTime') is not None:
            self.average_abandoned_in_ring_time = m.get('AverageAbandonedInRingTime')
        if m.get('AverageAbandonTime') is not None:
            self.average_abandon_time = m.get('AverageAbandonTime')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAbandoned') is not None:
            self.calls_abandoned = m.get('CallsAbandoned')
        if m.get('MaxAbandonedInQueueTime') is not None:
            self.max_abandoned_in_queue_time = m.get('MaxAbandonedInQueueTime')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('AbandonRate') is not None:
            self.abandon_rate = m.get('AbandonRate')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalAbandonTime') is not None:
            self.total_abandon_time = m.get('TotalAbandonTime')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('MaxAbandonedInRingTime') is not None:
            self.max_abandoned_in_ring_time = m.get('MaxAbandonedInRingTime')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('AverageAbandonedInQueueTime') is not None:
            self.average_abandoned_in_queue_time = m.get('AverageAbandonedInQueueTime')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('CallsTimeout') is not None:
            self.calls_timeout = m.get('CallsTimeout')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('TotalAbandonedInQueueTime') is not None:
            self.total_abandoned_in_queue_time = m.get('TotalAbandonedInQueueTime')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        return self


class ListHistoricalSkillGroupReportResponseBodyDataListOutbound(TeaModel):
    def __init__(self, average_ring_time=None, calls_dialed=None, calls_answered=None, total_work_time=None,
                 calls_attended_transfer_out=None, max_work_time=None, total_dialing_time=None, total_hold_time=None, average_work_time=None,
                 calls_blind_transfer_in=None, satisfaction_index=None, calls_ringed=None, calls_attended_transfer_in=None,
                 calls_blind_transfer_out=None, total_ring_time=None, max_talk_time=None, max_ring_time=None, total_talk_time=None,
                 max_dialing_time=None, answer_rate=None, max_hold_time=None, average_talk_time=None, satisfaction_rate=None,
                 calls_hold=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 average_hold_time=None, average_dialing_time=None):
        self.average_ring_time = average_ring_time  # type: float
        self.calls_dialed = calls_dialed  # type: long
        self.calls_answered = calls_answered  # type: long
        self.total_work_time = total_work_time  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.max_work_time = max_work_time  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.calls_ringed = calls_ringed  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.answer_rate = answer_rate  # type: float
        self.max_hold_time = max_hold_time  # type: long
        self.average_talk_time = average_talk_time  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.calls_hold = calls_hold  # type: long
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.average_hold_time = average_hold_time  # type: float
        self.average_dialing_time = average_dialing_time  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyDataListOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        return self


class ListHistoricalSkillGroupReportResponseBodyDataListOverall(TeaModel):
    def __init__(self, total_talk_time=None, total_logged_in_time=None, occupancy_rate=None, total_work_time=None,
                 max_hold_time=None, max_work_time=None, average_break_time=None, total_hold_time=None, satisfaction_rate=None,
                 max_break_time=None, average_work_time=None, average_talk_time=None, satisfaction_index=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, max_ready_time=None, average_ready_time=None,
                 average_hold_time=None, total_ready_time=None, total_break_time=None, max_talk_time=None, total_calls=None):
        self.total_talk_time = total_talk_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.total_work_time = total_work_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.average_break_time = average_break_time  # type: float
        self.total_hold_time = total_hold_time  # type: long
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.max_break_time = max_break_time  # type: long
        self.average_work_time = average_work_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.average_ready_time = average_ready_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.total_ready_time = total_ready_time  # type: long
        self.total_break_time = total_break_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyDataListOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class ListHistoricalSkillGroupReportResponseBodyDataList(TeaModel):
    def __init__(self, skill_group_name=None, skill_group_id=None, inbound=None, outbound=None, overall=None):
        self.skill_group_name = skill_group_name  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.inbound = inbound  # type: ListHistoricalSkillGroupReportResponseBodyDataListInbound
        self.outbound = outbound  # type: ListHistoricalSkillGroupReportResponseBodyDataListOutbound
        self.overall = overall  # type: ListHistoricalSkillGroupReportResponseBodyDataListOverall

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Inbound') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBodyDataListInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBodyDataListOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBodyDataListOverall()
            self.overall = temp_model.from_map(m['Overall'])
        return self


class ListHistoricalSkillGroupReportResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListHistoricalSkillGroupReportResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListHistoricalSkillGroupReportResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListHistoricalSkillGroupReportResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: ListHistoricalSkillGroupReportResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListHistoricalSkillGroupReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListHistoricalSkillGroupReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SendDtmfSignalingRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, job_id=None, channel_id=None, dtmf=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.dtmf = dtmf  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SendDtmfSignalingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.dtmf is not None:
            result['Dtmf'] = self.dtmf
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('Dtmf') is not None:
            self.dtmf = m.get('Dtmf')
        return self


class SendDtmfSignalingResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, index=None, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, skill_group_id=None, timestamp=None, associated_data=None, release_reason=None,
                 call_type=None, job_id=None, channel_id=None, user_extension=None, originator=None):
        self.index = index  # type: int
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.user_extension = user_extension  # type: str
        self.originator = originator  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SendDtmfSignalingResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.originator is not None:
            result['Originator'] = self.originator
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        return self


class SendDtmfSignalingResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[SendDtmfSignalingResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(SendDtmfSignalingResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = SendDtmfSignalingResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class SendDtmfSignalingResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(SendDtmfSignalingResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class SendDtmfSignalingResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: SendDtmfSignalingResponseBodyDataCallContext
        self.user_context = user_context  # type: SendDtmfSignalingResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(SendDtmfSignalingResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = SendDtmfSignalingResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = SendDtmfSignalingResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class SendDtmfSignalingResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: SendDtmfSignalingResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(SendDtmfSignalingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = SendDtmfSignalingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class SendDtmfSignalingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SendDtmfSignalingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SendDtmfSignalingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SendDtmfSignalingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRecentCallDetailRecordsRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, start_time=None, end_time=None, instance_id=None,
                 criteria=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.start_time = start_time  # type: long
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.criteria = criteria  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRecentCallDetailRecordsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        return self


class ListRecentCallDetailRecordsResponseBodyDataList(TeaModel):
    def __init__(self, start_time=None, contact_disposition=None, contact_type=None, agent_ids=None,
                 contact_id=None, call_duration=None, calling_number=None, duration=None, instance_id=None, called_number=None,
                 skill_group_ids=None):
        self.start_time = start_time  # type: long
        self.contact_disposition = contact_disposition  # type: str
        self.contact_type = contact_type  # type: str
        self.agent_ids = agent_ids  # type: str
        self.contact_id = contact_id  # type: str
        self.call_duration = call_duration  # type: str
        self.calling_number = calling_number  # type: str
        self.duration = duration  # type: long
        self.instance_id = instance_id  # type: str
        self.called_number = called_number  # type: str
        self.skill_group_ids = skill_group_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRecentCallDetailRecordsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.contact_disposition is not None:
            result['ContactDisposition'] = self.contact_disposition
        if self.contact_type is not None:
            result['ContactType'] = self.contact_type
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.call_duration is not None:
            result['CallDuration'] = self.call_duration
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('ContactDisposition') is not None:
            self.contact_disposition = m.get('ContactDisposition')
        if m.get('ContactType') is not None:
            self.contact_type = m.get('ContactType')
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('CallDuration') is not None:
            self.call_duration = m.get('CallDuration')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        return self


class ListRecentCallDetailRecordsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListRecentCallDetailRecordsResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRecentCallDetailRecordsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListRecentCallDetailRecordsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListRecentCallDetailRecordsResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: ListRecentCallDetailRecordsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListRecentCallDetailRecordsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListRecentCallDetailRecordsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListRecentCallDetailRecordsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListRecentCallDetailRecordsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListRecentCallDetailRecordsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRecentCallDetailRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InitiateAttendedTransferRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, transferor=None, transferee=None,
                 timeout_seconds=None, job_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.transferor = transferor  # type: str
        self.transferee = transferee  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InitiateAttendedTransferRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.transferor is not None:
            result['Transferor'] = self.transferor
        if self.transferee is not None:
            result['Transferee'] = self.transferee
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Transferor') is not None:
            self.transferor = m.get('Transferor')
        if m.get('Transferee') is not None:
            self.transferee = m.get('Transferee')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class InitiateAttendedTransferResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, index=None, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, skill_group_id=None, timestamp=None, associated_data=None, release_reason=None,
                 call_type=None, job_id=None, channel_id=None, user_extension=None, originator=None):
        self.index = index  # type: int
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.user_extension = user_extension  # type: str
        self.originator = originator  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InitiateAttendedTransferResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.originator is not None:
            result['Originator'] = self.originator
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        return self


class InitiateAttendedTransferResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[InitiateAttendedTransferResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(InitiateAttendedTransferResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = InitiateAttendedTransferResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class InitiateAttendedTransferResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(InitiateAttendedTransferResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class InitiateAttendedTransferResponseBodyData(TeaModel):
    def __init__(self, context_id=None, call_context=None, user_context=None):
        self.context_id = context_id  # type: long
        self.call_context = call_context  # type: InitiateAttendedTransferResponseBodyDataCallContext
        self.user_context = user_context  # type: InitiateAttendedTransferResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(InitiateAttendedTransferResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('CallContext') is not None:
            temp_model = InitiateAttendedTransferResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = InitiateAttendedTransferResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class InitiateAttendedTransferResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: InitiateAttendedTransferResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(InitiateAttendedTransferResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = InitiateAttendedTransferResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class InitiateAttendedTransferResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: InitiateAttendedTransferResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InitiateAttendedTransferResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InitiateAttendedTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MakeCallRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, caller=None, callee=None,
                 timeout_seconds=None, tags=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.caller = caller  # type: str
        self.callee = callee  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.tags = tags  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MakeCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class MakeCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, timestamp=None, associated_data=None, release_reason=None, call_type=None, job_id=None,
                 channel_id=None, originator=None, user_extension=None):
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.originator = originator  # type: str
        self.user_extension = user_extension  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MakeCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        return self


class MakeCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[MakeCallResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(MakeCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = MakeCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class MakeCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, work_mode=None, device_id=None, job_id=None, user_id=None, break_code=None,
                 instance_id=None, outbound_scenario=None, user_state=None, signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(MakeCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class MakeCallResponseBodyData(TeaModel):
    def __init__(self, context_id=None, call_context=None, user_context=None):
        self.context_id = context_id  # type: long
        self.call_context = call_context  # type: MakeCallResponseBodyDataCallContext
        self.user_context = user_context  # type: MakeCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(MakeCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('CallContext') is not None:
            temp_model = MakeCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = MakeCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class MakeCallResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: MakeCallResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(MakeCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = MakeCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class MakeCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: MakeCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(MakeCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = MakeCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetInstanceResponseBodyDataAdminList(TeaModel):
    def __init__(self, display_name=None, extension=None, login_name=None, email=None, work_mode=None, mobile=None,
                 user_id=None, role_name=None, instance_id=None, role_id=None):
        self.display_name = display_name  # type: str
        self.extension = extension  # type: str
        self.login_name = login_name  # type: str
        self.email = email  # type: str
        self.work_mode = work_mode  # type: str
        self.mobile = mobile  # type: str
        self.user_id = user_id  # type: str
        self.role_name = role_name  # type: str
        self.instance_id = instance_id  # type: str
        self.role_id = role_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceResponseBodyDataAdminList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.email is not None:
            result['Email'] = self.email
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        return self


class GetInstanceResponseBodyDataNumberListSkillGroups(TeaModel):
    def __init__(self, display_name=None, description=None, phone_number_count=None, skill_group_id=None,
                 user_count=None, instance_id=None, name=None):
        self.display_name = display_name  # type: str
        self.description = description  # type: str
        self.phone_number_count = phone_number_count  # type: int
        self.skill_group_id = skill_group_id  # type: str
        self.user_count = user_count  # type: int
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceResponseBodyDataNumberListSkillGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.description is not None:
            result['Description'] = self.description
        if self.phone_number_count is not None:
            result['PhoneNumberCount'] = self.phone_number_count
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('PhoneNumberCount') is not None:
            self.phone_number_count = m.get('PhoneNumberCount')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetInstanceResponseBodyDataNumberList(TeaModel):
    def __init__(self, active=None, user_id=None, number=None, city=None, instance_id=None, usage=None,
                 contact_flow_id=None, province=None, skill_groups=None):
        self.active = active  # type: bool
        self.user_id = user_id  # type: str
        self.number = number  # type: str
        self.city = city  # type: str
        self.instance_id = instance_id  # type: str
        self.usage = usage  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.province = province  # type: str
        self.skill_groups = skill_groups  # type: list[GetInstanceResponseBodyDataNumberListSkillGroups]

    def validate(self):
        if self.skill_groups:
            for k in self.skill_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetInstanceResponseBodyDataNumberList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.number is not None:
            result['Number'] = self.number
        if self.city is not None:
            result['City'] = self.city
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.province is not None:
            result['Province'] = self.province
        result['SkillGroups'] = []
        if self.skill_groups is not None:
            for k in self.skill_groups:
                result['SkillGroups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        self.skill_groups = []
        if m.get('SkillGroups') is not None:
            for k in m.get('SkillGroups'):
                temp_model = GetInstanceResponseBodyDataNumberListSkillGroups()
                self.skill_groups.append(temp_model.from_map(k))
        return self


class GetInstanceResponseBodyData(TeaModel):
    def __init__(self, status=None, console_url=None, description=None, aliyun_uid=None, name=None, domain_name=None,
                 id=None, admin_list=None, number_list=None):
        self.status = status  # type: str
        self.console_url = console_url  # type: str
        self.description = description  # type: str
        self.aliyun_uid = aliyun_uid  # type: str
        self.name = name  # type: str
        self.domain_name = domain_name  # type: str
        self.id = id  # type: str
        self.admin_list = admin_list  # type: list[GetInstanceResponseBodyDataAdminList]
        self.number_list = number_list  # type: list[GetInstanceResponseBodyDataNumberList]

    def validate(self):
        if self.admin_list:
            for k in self.admin_list:
                if k:
                    k.validate()
        if self.number_list:
            for k in self.number_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetInstanceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.console_url is not None:
            result['ConsoleUrl'] = self.console_url
        if self.description is not None:
            result['Description'] = self.description
        if self.aliyun_uid is not None:
            result['AliyunUid'] = self.aliyun_uid
        if self.name is not None:
            result['Name'] = self.name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.id is not None:
            result['Id'] = self.id
        result['AdminList'] = []
        if self.admin_list is not None:
            for k in self.admin_list:
                result['AdminList'].append(k.to_map() if k else None)
        result['NumberList'] = []
        if self.number_list is not None:
            for k in self.number_list:
                result['NumberList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ConsoleUrl') is not None:
            self.console_url = m.get('ConsoleUrl')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('AliyunUid') is not None:
            self.aliyun_uid = m.get('AliyunUid')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        self.admin_list = []
        if m.get('AdminList') is not None:
            for k in m.get('AdminList'):
                temp_model = GetInstanceResponseBodyDataAdminList()
                self.admin_list.append(temp_model.from_map(k))
        self.number_list = []
        if m.get('NumberList') is not None:
            for k in m.get('NumberList'):
                temp_model = GetInstanceResponseBodyDataNumberList()
                self.number_list.append(temp_model.from_map(k))
        return self


class GetInstanceResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: GetInstanceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = GetInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddUsersToSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, user_skill_level_list=None):
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.user_skill_level_list = user_skill_level_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddUsersToSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.user_skill_level_list is not None:
            result['UserSkillLevelList'] = self.user_skill_level_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('UserSkillLevelList') is not None:
            self.user_skill_level_list = m.get('UserSkillLevelList')
        return self


class AddUsersToSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddUsersToSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddUsersToSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddUsersToSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddUsersToSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddUsersToSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConfigItemsRequest(TeaModel):
    def __init__(self, instance_id=None, object_id=None, object_type=None):
        self.instance_id = instance_id  # type: str
        self.object_id = object_id  # type: str
        self.object_type = object_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListConfigItemsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.object_id is not None:
            result['ObjectId'] = self.object_id
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ObjectId') is not None:
            self.object_id = m.get('ObjectId')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        return self


class ListConfigItemsResponseBodyData(TeaModel):
    def __init__(self, object_id=None, value=None, object_type=None, instance_id=None, name=None):
        self.object_id = object_id  # type: str
        self.value = value  # type: str
        self.object_type = object_type  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListConfigItemsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object_id is not None:
            result['ObjectId'] = self.object_id
        if self.value is not None:
            result['Value'] = self.value
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ObjectId') is not None:
            self.object_id = m.get('ObjectId')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ListConfigItemsResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: list[ListConfigItemsResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListConfigItemsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListConfigItemsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListConfigItemsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListConfigItemsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListConfigItemsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConfigItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SignInGroupRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, signed_skill_group_id_list=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SignInGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class SignInGroupResponseBodyData(TeaModel):
    def __init__(self, extension=None, work_mode=None, device_id=None, job_id=None, user_id=None, break_code=None,
                 instance_id=None, outbound_scenario=None, user_state=None, signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(SignInGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class SignInGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: SignInGroupResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(SignInGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = SignInGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class SignInGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SignInGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SignInGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SignInGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRealtimeInstanceStatesRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRealtimeInstanceStatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetRealtimeInstanceStatesResponseBodyData(TeaModel):
    def __init__(self, working_agents=None, longest_waiting_time=None, logged_in_agents=None, total_agents=None,
                 waiting_calls=None, breaking_agents=None, talking_agents=None, interactive_calls=None, ready_agents=None,
                 instance_id=None):
        self.working_agents = working_agents  # type: long
        self.longest_waiting_time = longest_waiting_time  # type: long
        self.logged_in_agents = logged_in_agents  # type: long
        self.total_agents = total_agents  # type: long
        self.waiting_calls = waiting_calls  # type: long
        self.breaking_agents = breaking_agents  # type: long
        self.talking_agents = talking_agents  # type: long
        self.interactive_calls = interactive_calls  # type: long
        self.ready_agents = ready_agents  # type: long
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRealtimeInstanceStatesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.working_agents is not None:
            result['WorkingAgents'] = self.working_agents
        if self.longest_waiting_time is not None:
            result['LongestWaitingTime'] = self.longest_waiting_time
        if self.logged_in_agents is not None:
            result['LoggedInAgents'] = self.logged_in_agents
        if self.total_agents is not None:
            result['TotalAgents'] = self.total_agents
        if self.waiting_calls is not None:
            result['WaitingCalls'] = self.waiting_calls
        if self.breaking_agents is not None:
            result['BreakingAgents'] = self.breaking_agents
        if self.talking_agents is not None:
            result['TalkingAgents'] = self.talking_agents
        if self.interactive_calls is not None:
            result['InteractiveCalls'] = self.interactive_calls
        if self.ready_agents is not None:
            result['ReadyAgents'] = self.ready_agents
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('WorkingAgents') is not None:
            self.working_agents = m.get('WorkingAgents')
        if m.get('LongestWaitingTime') is not None:
            self.longest_waiting_time = m.get('LongestWaitingTime')
        if m.get('LoggedInAgents') is not None:
            self.logged_in_agents = m.get('LoggedInAgents')
        if m.get('TotalAgents') is not None:
            self.total_agents = m.get('TotalAgents')
        if m.get('WaitingCalls') is not None:
            self.waiting_calls = m.get('WaitingCalls')
        if m.get('BreakingAgents') is not None:
            self.breaking_agents = m.get('BreakingAgents')
        if m.get('TalkingAgents') is not None:
            self.talking_agents = m.get('TalkingAgents')
        if m.get('InteractiveCalls') is not None:
            self.interactive_calls = m.get('InteractiveCalls')
        if m.get('ReadyAgents') is not None:
            self.ready_agents = m.get('ReadyAgents')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetRealtimeInstanceStatesResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: GetRealtimeInstanceStatesResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetRealtimeInstanceStatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetRealtimeInstanceStatesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetRealtimeInstanceStatesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetRealtimeInstanceStatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRealtimeInstanceStatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRealtimeInstanceStatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, display_name=None, description=None):
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.display_name = display_name  # type: str
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifySkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class ModifySkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifySkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifySkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifySkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyUserRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, mobile=None, work_mode=None, role_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.mobile = mobile  # type: str
        self.work_mode = work_mode  # type: str
        self.role_id = role_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        return self


class ModifyUserResponseBody(TeaModel):
    def __init__(self, http_status_code=None, code=None, message=None, data=None, request_id=None, params=None):
        self.http_status_code = http_status_code  # type: int
        self.code = code  # type: str
        self.message = message  # type: str
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        return self


class ModifyUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPhoneNumberToSkillGroupsRequest(TeaModel):
    def __init__(self, instance_id=None, number=None, skill_group_id_list=None):
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str
        self.skill_group_id_list = skill_group_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPhoneNumberToSkillGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        return self


class AddPhoneNumberToSkillGroupsResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPhoneNumberToSkillGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPhoneNumberToSkillGroupsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddPhoneNumberToSkillGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPhoneNumberToSkillGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddPhoneNumberToSkillGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDevicesRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDevicesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListDevicesResponseBodyData(TeaModel):
    def __init__(self, extension=None, expires=None, contact=None, device_id=None, user_id=None, call_id=None,
                 instance_id=None):
        self.extension = extension  # type: str
        self.expires = expires  # type: long
        self.contact = contact  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.call_id = call_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDevicesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.expires is not None:
            result['Expires'] = self.expires
        if self.contact is not None:
            result['Contact'] = self.contact
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Expires') is not None:
            self.expires = m.get('Expires')
        if m.get('Contact') is not None:
            self.contact = m.get('Contact')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListDevicesResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: list[ListDevicesResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDevicesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListDevicesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListDevicesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListDevicesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDevicesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RetrieveCallRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, job_id=None, channel_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RetrieveCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        return self


class RetrieveCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 skill_group_id=None, timestamp=None, associated_data=None, release_reason=None, call_type=None, job_id=None,
                 channel_id=None, originator=None, user_extension=None):
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.originator = originator  # type: str
        self.user_extension = user_extension  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RetrieveCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        return self


class RetrieveCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[RetrieveCallResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(RetrieveCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = RetrieveCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class RetrieveCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(RetrieveCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class RetrieveCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: RetrieveCallResponseBodyDataCallContext
        self.user_context = user_context  # type: RetrieveCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(RetrieveCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = RetrieveCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = RetrieveCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class RetrieveCallResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: RetrieveCallResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(RetrieveCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = RetrieveCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class RetrieveCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RetrieveCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RetrieveCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RetrieveCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSkillGroupsRequest(TeaModel):
    def __init__(self, instance_id=None, search_pattern=None, page_number=None, page_size=None):
        self.instance_id = instance_id  # type: str
        self.search_pattern = search_pattern  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSkillGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListSkillGroupsResponseBodyDataList(TeaModel):
    def __init__(self, display_name=None, description=None, phone_number_count=None, skill_group_id=None,
                 skill_group_name=None, user_count=None, instance_id=None):
        self.display_name = display_name  # type: str
        self.description = description  # type: str
        self.phone_number_count = phone_number_count  # type: int
        self.skill_group_id = skill_group_id  # type: str
        self.skill_group_name = skill_group_name  # type: str
        self.user_count = user_count  # type: int
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSkillGroupsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.description is not None:
            result['Description'] = self.description
        if self.phone_number_count is not None:
            result['PhoneNumberCount'] = self.phone_number_count
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('PhoneNumberCount') is not None:
            self.phone_number_count = m.get('PhoneNumberCount')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListSkillGroupsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListSkillGroupsResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListSkillGroupsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListSkillGroupsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListSkillGroupsResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: ListSkillGroupsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListSkillGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListSkillGroupsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListSkillGroupsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListSkillGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListSkillGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListSkillGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HoldCallRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, job_id=None, channel_id=None, music=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.music = music  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HoldCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.music is not None:
            result['Music'] = self.music
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('Music') is not None:
            self.music = m.get('Music')
        return self


class HoldCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 skill_group_id=None, timestamp=None, associated_data=None, release_reason=None, call_type=None, job_id=None,
                 channel_id=None, originator=None, user_extension=None):
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.originator = originator  # type: str
        self.user_extension = user_extension  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HoldCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        return self


class HoldCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[HoldCallResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(HoldCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = HoldCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class HoldCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(HoldCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class HoldCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: HoldCallResponseBodyDataCallContext
        self.user_context = user_context  # type: HoldCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(HoldCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = HoldCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = HoldCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class HoldCallResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: HoldCallResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(HoldCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = HoldCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class HoldCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: HoldCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(HoldCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = HoldCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RegisterDeviceRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, password=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.password = password  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RegisterDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.password is not None:
            result['Password'] = self.password
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        return self


class RegisterDeviceResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(RegisterDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        return self


class RegisterDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RegisterDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RegisterDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RegisterDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemovePersonalNumbersFromUserRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, number_list=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.number_list = number_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemovePersonalNumbersFromUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        return self


class RemovePersonalNumbersFromUserResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemovePersonalNumbersFromUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RemovePersonalNumbersFromUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemovePersonalNumbersFromUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemovePersonalNumbersFromUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemovePersonalNumbersFromUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, description=None):
        self.instance_id = instance_id  # type: str
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class ModifyInstanceResponseBody(TeaModel):
    def __init__(self, http_status_code=None, code=None, message=None, data=None, request_id=None, params=None):
        self.http_status_code = http_status_code  # type: int
        self.code = code  # type: str
        self.message = message  # type: str
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        return self


class ModifyInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOutboundNumbersOfUserRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, page_number=None, page_size=None, skill_group_id_list=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.skill_group_id_list = skill_group_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOutboundNumbersOfUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        return self


class ListOutboundNumbersOfUserResponseBodyDataList(TeaModel):
    def __init__(self, number=None, city=None, province=None):
        self.number = number  # type: str
        self.city = city  # type: str
        self.province = province  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOutboundNumbersOfUserResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.number is not None:
            result['Number'] = self.number
        if self.city is not None:
            result['City'] = self.city
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class ListOutboundNumbersOfUserResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListOutboundNumbersOfUserResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListOutboundNumbersOfUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListOutboundNumbersOfUserResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListOutboundNumbersOfUserResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: ListOutboundNumbersOfUserResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListOutboundNumbersOfUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListOutboundNumbersOfUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOutboundNumbersOfUserResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListOutboundNumbersOfUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListOutboundNumbersOfUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOutboundNumbersOfUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PollUserStatusRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PollUserStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        return self


class PollUserStatusResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, index=None, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, skill_group_id=None, timestamp=None, associated_data=None, release_reason=None,
                 call_type=None, channel_variables=None, job_id=None, channel_id=None, user_extension=None, originator=None):
        self.index = index  # type: int
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.channel_variables = channel_variables  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.user_extension = user_extension  # type: str
        self.originator = originator  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PollUserStatusResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_variables is not None:
            result['ChannelVariables'] = self.channel_variables
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.originator is not None:
            result['Originator'] = self.originator
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelVariables') is not None:
            self.channel_variables = m.get('ChannelVariables')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        return self


class PollUserStatusResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[PollUserStatusResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(PollUserStatusResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = PollUserStatusResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class PollUserStatusResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(PollUserStatusResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class PollUserStatusResponseBodyData(TeaModel):
    def __init__(self, context_id=None, call_context=None, user_context=None):
        self.context_id = context_id  # type: long
        self.call_context = call_context  # type: PollUserStatusResponseBodyDataCallContext
        self.user_context = user_context  # type: PollUserStatusResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(PollUserStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('CallContext') is not None:
            temp_model = PollUserStatusResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = PollUserStatusResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class PollUserStatusResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: PollUserStatusResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(PollUserStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = PollUserStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class PollUserStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: PollUserStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(PollUserStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PollUserStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ReadyForServiceRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, outbound_scenario=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ReadyForServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        return self


class ReadyForServiceResponseBodyData(TeaModel):
    def __init__(self, extension=None, work_mode=None, device_id=None, job_id=None, user_id=None, break_code=None,
                 instance_id=None, outbound_scenario=None, user_state=None, signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ReadyForServiceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class ReadyForServiceResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: ReadyForServiceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ReadyForServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = ReadyForServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ReadyForServiceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ReadyForServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ReadyForServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ReadyForServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMultiChannelRecordingRequest(TeaModel):
    def __init__(self, instance_id=None, contact_id=None):
        self.instance_id = instance_id  # type: str
        self.contact_id = contact_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMultiChannelRecordingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        return self


class GetMultiChannelRecordingResponseBodyData(TeaModel):
    def __init__(self, file_url=None, file_name=None):
        self.file_url = file_url  # type: str
        self.file_name = file_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMultiChannelRecordingResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.file_name is not None:
            result['FileName'] = self.file_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        return self


class GetMultiChannelRecordingResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: GetMultiChannelRecordingResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMultiChannelRecordingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetMultiChannelRecordingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMultiChannelRecordingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMultiChannelRecordingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMultiChannelRecordingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMultiChannelRecordingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BargeInCallRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None, job_id=None, barged_user_id=None,
                 timeout_seconds=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str
        self.job_id = job_id  # type: str
        self.barged_user_id = barged_user_id  # type: str
        self.timeout_seconds = timeout_seconds  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(BargeInCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.barged_user_id is not None:
            result['BargedUserId'] = self.barged_user_id
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('BargedUserId') is not None:
            self.barged_user_id = m.get('BargedUserId')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        return self


class BargeInCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, index=None, release_initiator=None, channel_state=None, destination=None, user_id=None,
                 channel_flags=None, skill_group_id=None, timestamp=None, associated_data=None, release_reason=None,
                 call_type=None, job_id=None, channel_id=None, user_extension=None, originator=None):
        self.index = index  # type: int
        self.release_initiator = release_initiator  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.user_id = user_id  # type: str
        self.channel_flags = channel_flags  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.associated_data = associated_data  # type: dict[str, any]
        self.release_reason = release_reason  # type: str
        self.call_type = call_type  # type: str
        self.job_id = job_id  # type: str
        self.channel_id = channel_id  # type: str
        self.user_extension = user_extension  # type: str
        self.originator = originator  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BargeInCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.originator is not None:
            result['Originator'] = self.originator
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        return self


class BargeInCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, instance_id=None, job_id=None, channel_contexts=None):
        self.call_type = call_type  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.channel_contexts = channel_contexts  # type: list[BargeInCallResponseBodyDataCallContextChannelContexts]

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BargeInCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = BargeInCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        return self


class BargeInCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BargeInCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class BargeInCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: BargeInCallResponseBodyDataCallContext
        self.user_context = user_context  # type: BargeInCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(BargeInCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = BargeInCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = BargeInCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class BargeInCallResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: BargeInCallResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BargeInCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = BargeInCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BargeInCallResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BargeInCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BargeInCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BargeInCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPhoneNumbersOfSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, page_number=None, page_size=None, is_member=None,
                 search_pattern=None, active=None):
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.is_member = is_member  # type: bool
        self.search_pattern = search_pattern  # type: str
        self.active = active  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPhoneNumbersOfSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.is_member is not None:
            result['IsMember'] = self.is_member
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        if self.active is not None:
            result['Active'] = self.active
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('IsMember') is not None:
            self.is_member = m.get('IsMember')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        if m.get('Active') is not None:
            self.active = m.get('Active')
        return self


class ListPhoneNumbersOfSkillGroupResponseBodyDataList(TeaModel):
    def __init__(self, active=None, number=None, city=None, instance_id=None, usage=None, contact_flow_id=None,
                 province=None):
        self.active = active  # type: bool
        self.number = number  # type: str
        self.city = city  # type: str
        self.instance_id = instance_id  # type: str
        self.usage = usage  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.province = province  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPhoneNumbersOfSkillGroupResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.number is not None:
            result['Number'] = self.number
        if self.city is not None:
            result['City'] = self.city
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class ListPhoneNumbersOfSkillGroupResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.list = list  # type: list[ListPhoneNumbersOfSkillGroupResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPhoneNumbersOfSkillGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListPhoneNumbersOfSkillGroupResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class ListPhoneNumbersOfSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: ListPhoneNumbersOfSkillGroupResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListPhoneNumbersOfSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListPhoneNumbersOfSkillGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListPhoneNumbersOfSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListPhoneNumbersOfSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPhoneNumbersOfSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListPhoneNumbersOfSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SignOutGroupRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None, device_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str
        self.device_id = device_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SignOutGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        return self


class SignOutGroupResponseBodyData(TeaModel):
    def __init__(self, extension=None, heartbeat=None, work_mode=None, device_id=None, user_id=None, reserved=None,
                 break_code=None, instance_id=None, outbound_scenario=None, mobile=None, job_id=None, user_state=None,
                 signed_skill_group_id_list=None):
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.work_mode = work_mode  # type: str
        self.device_id = device_id  # type: str
        self.user_id = user_id  # type: str
        self.reserved = reserved  # type: long
        self.break_code = break_code  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.mobile = mobile  # type: str
        self.job_id = job_id  # type: str
        self.user_state = user_state  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(SignOutGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        return self


class SignOutGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, params=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.params = params  # type: list[str]
        self.data = data  # type: SignOutGroupResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(SignOutGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.params is not None:
            result['Params'] = self.params
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Data') is not None:
            temp_model = SignOutGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class SignOutGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SignOutGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SignOutGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SignOutGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SaveRTCStatsV2Request(TeaModel):
    def __init__(self, instance_id=None, call_id=None, general_info=None, sender_report=None, receiver_report=None,
                 goog_address=None):
        self.instance_id = instance_id  # type: str
        self.call_id = call_id  # type: str
        self.general_info = general_info  # type: str
        self.sender_report = sender_report  # type: str
        self.receiver_report = receiver_report  # type: str
        self.goog_address = goog_address  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SaveRTCStatsV2Request, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.general_info is not None:
            result['GeneralInfo'] = self.general_info
        if self.sender_report is not None:
            result['SenderReport'] = self.sender_report
        if self.receiver_report is not None:
            result['ReceiverReport'] = self.receiver_report
        if self.goog_address is not None:
            result['GoogAddress'] = self.goog_address
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('GeneralInfo') is not None:
            self.general_info = m.get('GeneralInfo')
        if m.get('SenderReport') is not None:
            self.sender_report = m.get('SenderReport')
        if m.get('ReceiverReport') is not None:
            self.receiver_report = m.get('ReceiverReport')
        if m.get('GoogAddress') is not None:
            self.goog_address = m.get('GoogAddress')
        return self


class SaveRTCStatsV2ResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, success=None, code=None, message=None,
                 time_stamp=None, row_count=None):
        self.http_status_code = http_status_code  # type: long
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.message = message  # type: str
        self.time_stamp = time_stamp  # type: long
        self.row_count = row_count  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(SaveRTCStatsV2ResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.row_count is not None:
            result['RowCount'] = self.row_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('RowCount') is not None:
            self.row_count = m.get('RowCount')
        return self


class SaveRTCStatsV2Response(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SaveRTCStatsV2ResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SaveRTCStatsV2Response, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SaveRTCStatsV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHistoricalCallerReportRequest(TeaModel):
    def __init__(self, instance_id=None, calling_number=None, stop_time=None, start_time=None):
        self.instance_id = instance_id  # type: str
        self.calling_number = calling_number  # type: str
        self.stop_time = stop_time  # type: long
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalCallerReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetHistoricalCallerReportResponseBodyData(TeaModel):
    def __init__(self, last_calling_time=None, total_calls=None):
        self.last_calling_time = last_calling_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalCallerReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.last_calling_time is not None:
            result['LastCallingTime'] = self.last_calling_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LastCallingTime') is not None:
            self.last_calling_time = m.get('LastCallingTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class GetHistoricalCallerReportResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, data=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.data = data  # type: GetHistoricalCallerReportResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetHistoricalCallerReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetHistoricalCallerReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetHistoricalCallerReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetHistoricalCallerReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHistoricalCallerReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetHistoricalCallerReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyUserLevelsOfSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, user_level_list=None):
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.user_level_list = user_level_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyUserLevelsOfSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.user_level_list is not None:
            result['UserLevelList'] = self.user_level_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skil