# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import django.db.models.deletion
from django.db import migrations, models

import dynamic_forms.fields


class Migration(migrations.Migration):

    dependencies = []

    operations = [
        migrations.CreateModel(
            bases = (models.Model,),
            name = 'FormModel',
            fields = [
                ('id', models.AutoField(serialize=False, auto_created=True, primary_key=True, verbose_name='ID'),),
                ('name', models.CharField(max_length=50, unique=True, verbose_name='Name'),),
                ('submit_url', models.CharField(max_length=100, unique=True, help_text='The full URL path to the form. It should start and end with a forward slash (<code>/</code>).', verbose_name='Submit URL'),),
                ('success_url', models.CharField(max_length=100, help_text='The full URL path where the user will be redirected after successfully sending the form. It should start and end with a forward slash (<code>/</code>). If empty, the success URL is generated by appending <code>done/</code> to the “Submit URL”.', default='', blank=True, verbose_name='Success URL'),),
                ('actions', dynamic_forms.fields.TextMultiSelectField(choices=(
                    ('dynamic_forms.actions.dynamic_form_send_email', 'Send via email'),
                    ('dynamic_forms.actions.dynamic_form_store_database', 'Store in database')), verbose_name='Actions', default=''),),
                ('form_template', models.CharField(max_length=100, default='dynamic_forms/form.html', verbose_name='Form template path'),),
                ('success_template', models.CharField(max_length=100, default='dynamic_forms/form_success.html', verbose_name='Success template path'),)],
            options = {
                'ordering': ['name'],
                'verbose_name': 'Dynamic form',
                'verbose_name_plural': 'Dynamic forms',
            },
        ),
        migrations.CreateModel(
            bases = (models.Model,),
            name = 'FormFieldModel',
            fields = [
                ('id', models.AutoField(serialize=False, auto_created=True, primary_key=True, verbose_name='ID'),),
                ('parent_form', models.ForeignKey(to_field='id', to='dynamic_forms.FormModel'),),
                ('field_type', models.CharField(max_length=255, choices=(
                    ('dynamic_forms.formfields.BooleanField', 'Boolean',),
                    ('dynamic_forms.formfields.ChoiceField', 'Choices',),
                    ('dynamic_forms.formfields.DateField', 'Date',),
                    ('dynamic_forms.formfields.DateTimeField', 'Date and Time',),
                    ('dynamic_forms.formfields.EmailField', 'Email',),
                    ('dynamic_forms.formfields.IntegerField', 'Integer',),
                    ('dynamic_forms.formfields.MultiLineTextField', 'Multi Line Text',),
                    ('dynamic_forms.formfields.SingleLineTextField', 'Single Line Text',),
                    ('dynamic_forms.formfields.TimeField', 'Time',)), verbose_name='Type'),),
                ('label', models.CharField(max_length=20, verbose_name='Label'),),
                ('name', models.SlugField(blank=True, verbose_name='Name'),),
                ('_options', models.TextField(null=True, blank=True, verbose_name='Options'),),
                ('position', models.SmallIntegerField(default=0, blank=True, verbose_name='Position'),)],
            options = {
                'ordering': ['parent_form', 'position'],
                'verbose_name': 'Form field',
                'verbose_name_plural': 'Form fields',
            },
        ),
        migrations.CreateModel(
            bases = (models.Model,),
            name = 'FormModelData',
            fields = [
                ('id', models.AutoField(serialize=False, auto_created=True, primary_key=True, verbose_name='ID'),),
                ('form', models.ForeignKey(null=True, to_field='id', to='dynamic_forms.FormModel', on_delete=django.db.models.deletion.SET_NULL),),
                ('value', models.TextField(default='', blank=True, verbose_name='Form data'),),
                ('submitted', models.DateTimeField(auto_now_add=True, verbose_name='Submitted on'),)],
            options = {
                'verbose_name': 'Form data',
                'verbose_name_plural': 'Form data',
            },
        ),
    ]
