import { IRole } from 'aws-cdk-lib/aws-iam';
import { IBucket } from 'aws-cdk-lib/aws-s3';
import { Provider } from 'aws-cdk-lib/custom-resources';
import { Construct } from 'constructs';
import { EmrVersion } from './emr-eks-cluster';
/**
* The properties for the EMR Managed Endpoint to create.
*/
export interface EmrManagedEndpointOptions {
    /**
     * The name of the EMR managed endpoint
     */
    readonly managedEndpointName: string;
    /**
     * The Id of the Amazon EMR virtual cluster containing the managed endpoint
     */
    readonly virtualClusterId: string;
    /**
     * The Amazon IAM role used as the execution role, this role must provide access to all the AWS resource a user will interact with
     * These can be S3, DynamoDB, Glue Catalog
     */
    readonly executionRole: IRole;
    /**
     * The Amazon EMR version to use
     * @default - The [default Amazon EMR version]{@link EmrEksCluster.DEFAULT_EMR_VERSION}
     */
    readonly emrOnEksVersion?: EmrVersion;
    /**
     * The JSON configuration overrides for Amazon EMR on EKS configuration attached to the managed endpoint
     * @default - Configuration related to the [default nodegroup for notebook]{@link EmrEksNodegroup.NOTEBOOK_EXECUTOR}
     */
    readonly configurationOverrides?: string;
}
/**
 * The properties for the EMR on EKS Managed Endpoint to create.
 * @private
 */
export interface EmrManagedEndpointProviderProps {
    /**
     * The bucket containing the k8s assets, in this case the pod templates
     */
    readonly assetBucket: IBucket;
}
/**
 * A custom resource provider for CRUD operations on Amazon EMR on EKS Managed Endpoints.
 * @private
 */
export declare class EmrManagedEndpointProvider extends Construct {
    /**
     * The custom resource Provider for creating Amazon EMR Managed Endpoints custom resources
     */
    readonly provider: Provider;
    /**
     * Constructs a new instance of the ManageEndpointProvider. The provider can then be used to create Amazon EMR on EKS Managed Endpoint custom resources
     * @param { Construct} scope the Scope of the CDK Construct
     * @param id the ID of the CDK Construct
     * @private
     */
    constructor(scope: Construct, id: string, props: EmrManagedEndpointProviderProps);
}
