import { Database } from '@aws-cdk/aws-glue-alpha';
import { Construct } from 'constructs';
import { TrackedConstruct } from './common/tracked-construct';
/**
 * A Data Lake Catalog composed of 3 AWS Glue Database configured with AWS best practices:
 *  Databases for Raw/Cleaned/Transformed data,
 */
export declare class DataLakeCatalog extends TrackedConstruct {
    /**
       * AWS Glue Database for Raw data
       */
    readonly rawDatabase: Database;
    /**
       * AWS Glue Database for Clean data
       */
    readonly cleanDatabase: Database;
    /**
       * AWS Glue Database for Transform data
       */
    readonly transformDatabase: Database;
    /**
       * Construct a new instance of DataLakeCatalog based on S3 buckets with best practices configuration
       * @param {Construct} scope the Scope of the CDK Construct
       * @param {string} id the ID of the CDK Construct
       * @access public
       */
    constructor(scope: Construct, id: string);
}
