# coding: utf-8

import six

from huaweicloudsdkcore.utils.http_utils import sanitize_for_serialization


class AppBaseInfo:

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    sensitive_list = []

    openapi_types = {
        'id': 'str',
        'name': 'str',
        'region': 'str',
        'is_disable': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'region': 'region',
        'is_disable': 'is_disable'
    }

    def __init__(self, id=None, name=None, region=None, is_disable=None):
        """AppBaseInfo

        The model defined in huaweicloud sdk

        :param id: 应用id
        :type id: str
        :param name: 应用名称
        :type name: str
        :param region: 局点信息
        :type region: str
        :param is_disable: 应用是否被禁用
        :type is_disable: bool
        """
        
        

        self._id = None
        self._name = None
        self._region = None
        self._is_disable = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if region is not None:
            self.region = region
        if is_disable is not None:
            self.is_disable = is_disable

    @property
    def id(self):
        """Gets the id of this AppBaseInfo.

        应用id

        :return: The id of this AppBaseInfo.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AppBaseInfo.

        应用id

        :param id: The id of this AppBaseInfo.
        :type id: str
        """
        self._id = id

    @property
    def name(self):
        """Gets the name of this AppBaseInfo.

        应用名称

        :return: The name of this AppBaseInfo.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AppBaseInfo.

        应用名称

        :param name: The name of this AppBaseInfo.
        :type name: str
        """
        self._name = name

    @property
    def region(self):
        """Gets the region of this AppBaseInfo.

        局点信息

        :return: The region of this AppBaseInfo.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """Sets the region of this AppBaseInfo.

        局点信息

        :param region: The region of this AppBaseInfo.
        :type region: str
        """
        self._region = region

    @property
    def is_disable(self):
        """Gets the is_disable of this AppBaseInfo.

        应用是否被禁用

        :return: The is_disable of this AppBaseInfo.
        :rtype: bool
        """
        return self._is_disable

    @is_disable.setter
    def is_disable(self, is_disable):
        """Sets the is_disable of this AppBaseInfo.

        应用是否被禁用

        :param is_disable: The is_disable of this AppBaseInfo.
        :type is_disable: bool
        """
        self._is_disable = is_disable

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                if attr in self.sensitive_list:
                    result[attr] = "****"
                else:
                    result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        import simplejson as json
        if six.PY2:
            import sys
            reload(sys)
            sys.setdefaultencoding("utf-8")
        return json.dumps(sanitize_for_serialization(self), ensure_ascii=False)

    def __repr__(self):
        """For `print`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AppBaseInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
