# coding: utf-8

"""
    Simple Inventory API

    This is the long form house API  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: dev@goproperly.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ModelProperty(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'address': 'str',
        'community': 'str',
        'zone': 'str',
        'yr_built': 'int',
        'living_space_square_footage_ag': 'int',
        'lot_size': 'float',
        'land_use_code': 'str',
        'assessed_value': 'float',
        'tax_amount': 'float',
        'building_type': 'str',
        'style': 'str',
        'basement_development': 'str',
        'basement': 'list[str]',
        'bedrooms_total': 'float',
        'bedrooms_ag': 'float',
        'bedrooms_with_closet': 'float',
        'master_walk_in': 'bool',
        'master_ensuite': 'bool',
        'bathrooms_full': 'float',
        'bathrooms_half': 'float',
        'bathrooms_main': 'float',
        'bathrooms_basement': 'float',
        'room_number': 'float',
        'kitchen_countertops': 'list[str]',
        'kitchen_island': 'bool',
        'kitchen_appliances': 'list[str]',
        'kitchen_layout': 'str',
        'flooring': 'list[str]',
        'fireplace': 'list[str]',
        'heating_type': 'list[str]',
        'backyard_details': 'str',
        'exterior': 'list[str]',
        'parking': 'list[str]',
        'total_parking': 'float',
        'enclosed_parking': 'float',
        'roof_type': 'str',
        'roof_age_years': 'int',
        'is_renovated': 'bool',
        'renovations_or_upgrades': 'str',
        'property_photos_user_submitted': 'str',
        'latitude': 'float',
        'longitude': 'float',
        'google_place_id': 'str',
        'geo_hash5': 'str',
        'geo_hash12': 'str'
    }

    attribute_map = {
        'id': 'id',
        'address': 'address',
        'community': 'community',
        'zone': 'zone',
        'yr_built': 'yrBuilt',
        'living_space_square_footage_ag': 'livingSpaceSquareFootageAG',
        'lot_size': 'lotSize',
        'land_use_code': 'landUseCode',
        'assessed_value': 'assessedValue',
        'tax_amount': 'taxAmount',
        'building_type': 'buildingType',
        'style': 'style',
        'basement_development': 'basementDevelopment',
        'basement': 'basement',
        'bedrooms_total': 'bedroomsTotal',
        'bedrooms_ag': 'bedroomsAG',
        'bedrooms_with_closet': 'bedroomsWithCloset',
        'master_walk_in': 'masterWalkIn',
        'master_ensuite': 'masterEnsuite',
        'bathrooms_full': 'bathroomsFull',
        'bathrooms_half': 'bathroomsHalf',
        'bathrooms_main': 'bathroomsMain',
        'bathrooms_basement': 'bathroomsBasement',
        'room_number': 'roomNumber',
        'kitchen_countertops': 'kitchenCountertops',
        'kitchen_island': 'kitchenIsland',
        'kitchen_appliances': 'kitchenAppliances',
        'kitchen_layout': 'kitchenLayout',
        'flooring': 'flooring',
        'fireplace': 'fireplace',
        'heating_type': 'heatingType',
        'backyard_details': 'backyardDetails',
        'exterior': 'exterior',
        'parking': 'parking',
        'total_parking': 'totalParking',
        'enclosed_parking': 'enclosedParking',
        'roof_type': 'roofType',
        'roof_age_years': 'roofAgeYears',
        'is_renovated': 'isRenovated',
        'renovations_or_upgrades': 'renovationsOrUpgrades',
        'property_photos_user_submitted': 'propertyPhotosUserSubmitted',
        'latitude': 'latitude',
        'longitude': 'longitude',
        'google_place_id': 'googlePlaceId',
        'geo_hash5': 'geoHash5',
        'geo_hash12': 'geoHash12'
    }

    def __init__(self, id=None, address=None, community=None, zone=None, yr_built=None, living_space_square_footage_ag=None, lot_size=None, land_use_code=None, assessed_value=None, tax_amount=None, building_type=None, style=None, basement_development=None, basement=None, bedrooms_total=None, bedrooms_ag=None, bedrooms_with_closet=None, master_walk_in=None, master_ensuite=None, bathrooms_full=None, bathrooms_half=None, bathrooms_main=None, bathrooms_basement=None, room_number=None, kitchen_countertops=None, kitchen_island=None, kitchen_appliances=None, kitchen_layout=None, flooring=None, fireplace=None, heating_type=None, backyard_details=None, exterior=None, parking=None, total_parking=None, enclosed_parking=None, roof_type=None, roof_age_years=None, is_renovated=None, renovations_or_upgrades=None, property_photos_user_submitted=None, latitude=None, longitude=None, google_place_id=None, geo_hash5=None, geo_hash12=None):  # noqa: E501
        """ModelProperty - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._address = None
        self._community = None
        self._zone = None
        self._yr_built = None
        self._living_space_square_footage_ag = None
        self._lot_size = None
        self._land_use_code = None
        self._assessed_value = None
        self._tax_amount = None
        self._building_type = None
        self._style = None
        self._basement_development = None
        self._basement = None
        self._bedrooms_total = None
        self._bedrooms_ag = None
        self._bedrooms_with_closet = None
        self._master_walk_in = None
        self._master_ensuite = None
        self._bathrooms_full = None
        self._bathrooms_half = None
        self._bathrooms_main = None
        self._bathrooms_basement = None
        self._room_number = None
        self._kitchen_countertops = None
        self._kitchen_island = None
        self._kitchen_appliances = None
        self._kitchen_layout = None
        self._flooring = None
        self._fireplace = None
        self._heating_type = None
        self._backyard_details = None
        self._exterior = None
        self._parking = None
        self._total_parking = None
        self._enclosed_parking = None
        self._roof_type = None
        self._roof_age_years = None
        self._is_renovated = None
        self._renovations_or_upgrades = None
        self._property_photos_user_submitted = None
        self._latitude = None
        self._longitude = None
        self._google_place_id = None
        self._geo_hash5 = None
        self._geo_hash12 = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.address = address
        if community is not None:
            self.community = community
        if zone is not None:
            self.zone = zone
        self.yr_built = yr_built
        if living_space_square_footage_ag is not None:
            self.living_space_square_footage_ag = living_space_square_footage_ag
        if lot_size is not None:
            self.lot_size = lot_size
        if land_use_code is not None:
            self.land_use_code = land_use_code
        if assessed_value is not None:
            self.assessed_value = assessed_value
        if tax_amount is not None:
            self.tax_amount = tax_amount
        if building_type is not None:
            self.building_type = building_type
        if style is not None:
            self.style = style
        if basement_development is not None:
            self.basement_development = basement_development
        if basement is not None:
            self.basement = basement
        if bedrooms_total is not None:
            self.bedrooms_total = bedrooms_total
        if bedrooms_ag is not None:
            self.bedrooms_ag = bedrooms_ag
        if bedrooms_with_closet is not None:
            self.bedrooms_with_closet = bedrooms_with_closet
        if master_walk_in is not None:
            self.master_walk_in = master_walk_in
        if master_ensuite is not None:
            self.master_ensuite = master_ensuite
        if bathrooms_full is not None:
            self.bathrooms_full = bathrooms_full
        if bathrooms_half is not None:
            self.bathrooms_half = bathrooms_half
        if bathrooms_main is not None:
            self.bathrooms_main = bathrooms_main
        if bathrooms_basement is not None:
            self.bathrooms_basement = bathrooms_basement
        if room_number is not None:
            self.room_number = room_number
        if kitchen_countertops is not None:
            self.kitchen_countertops = kitchen_countertops
        if kitchen_island is not None:
            self.kitchen_island = kitchen_island
        if kitchen_appliances is not None:
            self.kitchen_appliances = kitchen_appliances
        if kitchen_layout is not None:
            self.kitchen_layout = kitchen_layout
        if flooring is not None:
            self.flooring = flooring
        if fireplace is not None:
            self.fireplace = fireplace
        if heating_type is not None:
            self.heating_type = heating_type
        if backyard_details is not None:
            self.backyard_details = backyard_details
        if exterior is not None:
            self.exterior = exterior
        if parking is not None:
            self.parking = parking
        if total_parking is not None:
            self.total_parking = total_parking
        if enclosed_parking is not None:
            self.enclosed_parking = enclosed_parking
        if roof_type is not None:
            self.roof_type = roof_type
        if roof_age_years is not None:
            self.roof_age_years = roof_age_years
        if is_renovated is not None:
            self.is_renovated = is_renovated
        if renovations_or_upgrades is not None:
            self.renovations_or_upgrades = renovations_or_upgrades
        if property_photos_user_submitted is not None:
            self.property_photos_user_submitted = property_photos_user_submitted
        if latitude is not None:
            self.latitude = latitude
        if longitude is not None:
            self.longitude = longitude
        if google_place_id is not None:
            self.google_place_id = google_place_id
        if geo_hash5 is not None:
            self.geo_hash5 = geo_hash5
        if geo_hash12 is not None:
            self.geo_hash12 = geo_hash12

    @property
    def id(self):
        """Gets the id of this ModelProperty.  # noqa: E501


        :return: The id of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ModelProperty.


        :param id: The id of this ModelProperty.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def address(self):
        """Gets the address of this ModelProperty.  # noqa: E501

        The address of the home.  # noqa: E501

        :return: The address of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address):
        """Sets the address of this ModelProperty.

        The address of the home.  # noqa: E501

        :param address: The address of this ModelProperty.  # noqa: E501
        :type: str
        """
        if address is None:
            raise ValueError("Invalid value for `address`, must not be `None`")  # noqa: E501

        self._address = address

    @property
    def community(self):
        """Gets the community of this ModelProperty.  # noqa: E501

        The community of the home.  # noqa: E501

        :return: The community of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._community

    @community.setter
    def community(self, community):
        """Sets the community of this ModelProperty.

        The community of the home.  # noqa: E501

        :param community: The community of this ModelProperty.  # noqa: E501
        :type: str
        """

        self._community = community

    @property
    def zone(self):
        """Gets the zone of this ModelProperty.  # noqa: E501

        The zone the community is located.  # noqa: E501

        :return: The zone of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._zone

    @zone.setter
    def zone(self, zone):
        """Sets the zone of this ModelProperty.

        The zone the community is located.  # noqa: E501

        :param zone: The zone of this ModelProperty.  # noqa: E501
        :type: str
        """

        self._zone = zone

    @property
    def yr_built(self):
        """Gets the yr_built of this ModelProperty.  # noqa: E501

        The year the home was built.  # noqa: E501

        :return: The yr_built of this ModelProperty.  # noqa: E501
        :rtype: int
        """
        return self._yr_built

    @yr_built.setter
    def yr_built(self, yr_built):
        """Sets the yr_built of this ModelProperty.

        The year the home was built.  # noqa: E501

        :param yr_built: The yr_built of this ModelProperty.  # noqa: E501
        :type: int
        """
        if yr_built is None:
            raise ValueError("Invalid value for `yr_built`, must not be `None`")  # noqa: E501

        self._yr_built = yr_built

    @property
    def living_space_square_footage_ag(self):
        """Gets the living_space_square_footage_ag of this ModelProperty.  # noqa: E501


        :return: The living_space_square_footage_ag of this ModelProperty.  # noqa: E501
        :rtype: int
        """
        return self._living_space_square_footage_ag

    @living_space_square_footage_ag.setter
    def living_space_square_footage_ag(self, living_space_square_footage_ag):
        """Sets the living_space_square_footage_ag of this ModelProperty.


        :param living_space_square_footage_ag: The living_space_square_footage_ag of this ModelProperty.  # noqa: E501
        :type: int
        """

        self._living_space_square_footage_ag = living_space_square_footage_ag

    @property
    def lot_size(self):
        """Gets the lot_size of this ModelProperty.  # noqa: E501

        How would you describe your lot size? * Below Average -> 0.8 * Average -> 1.0 * Above Average -> 1.2   # noqa: E501

        :return: The lot_size of this ModelProperty.  # noqa: E501
        :rtype: float
        """
        return self._lot_size

    @lot_size.setter
    def lot_size(self, lot_size):
        """Sets the lot_size of this ModelProperty.

        How would you describe your lot size? * Below Average -> 0.8 * Average -> 1.0 * Above Average -> 1.2   # noqa: E501

        :param lot_size: The lot_size of this ModelProperty.  # noqa: E501
        :type: float
        """

        self._lot_size = lot_size

    @property
    def land_use_code(self):
        """Gets the land_use_code of this ModelProperty.  # noqa: E501

        The land use code of the home.  # noqa: E501

        :return: The land_use_code of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._land_use_code

    @land_use_code.setter
    def land_use_code(self, land_use_code):
        """Sets the land_use_code of this ModelProperty.

        The land use code of the home.  # noqa: E501

        :param land_use_code: The land_use_code of this ModelProperty.  # noqa: E501
        :type: str
        """
        allowed_values = ["R1", "R2", "M"]  # noqa: E501
        if land_use_code not in allowed_values:
            raise ValueError(
                "Invalid value for `land_use_code` ({0}), must be one of {1}"  # noqa: E501
                .format(land_use_code, allowed_values)
            )

        self._land_use_code = land_use_code

    @property
    def assessed_value(self):
        """Gets the assessed_value of this ModelProperty.  # noqa: E501

        What is the most recent assesed value for the property?  # noqa: E501

        :return: The assessed_value of this ModelProperty.  # noqa: E501
        :rtype: float
        """
        return self._assessed_value

    @assessed_value.setter
    def assessed_value(self, assessed_value):
        """Sets the assessed_value of this ModelProperty.

        What is the most recent assesed value for the property?  # noqa: E501

        :param assessed_value: The assessed_value of this ModelProperty.  # noqa: E501
        :type: float
        """

        self._assessed_value = assessed_value

    @property
    def tax_amount(self):
        """Gets the tax_amount of this ModelProperty.  # noqa: E501

        How much did you most recently pay in property taxes?  # noqa: E501

        :return: The tax_amount of this ModelProperty.  # noqa: E501
        :rtype: float
        """
        return self._tax_amount

    @tax_amount.setter
    def tax_amount(self, tax_amount):
        """Sets the tax_amount of this ModelProperty.

        How much did you most recently pay in property taxes?  # noqa: E501

        :param tax_amount: The tax_amount of this ModelProperty.  # noqa: E501
        :type: float
        """

        self._tax_amount = tax_amount

    @property
    def building_type(self):
        """Gets the building_type of this ModelProperty.  # noqa: E501

        The building type.  # noqa: E501

        :return: The building_type of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._building_type

    @building_type.setter
    def building_type(self, building_type):
        """Sets the building_type of this ModelProperty.

        The building type.  # noqa: E501

        :param building_type: The building_type of this ModelProperty.  # noqa: E501
        :type: str
        """
        allowed_values = ["Detached", "Semi Detached", "Row", "Lowrise Apartment", "Double Wide", "High Rise Apartment", "Single Wide"]  # noqa: E501
        if building_type not in allowed_values:
            raise ValueError(
                "Invalid value for `building_type` ({0}), must be one of {1}"  # noqa: E501
                .format(building_type, allowed_values)
            )

        self._building_type = building_type

    @property
    def style(self):
        """Gets the style of this ModelProperty.  # noqa: E501

        The home style.  # noqa: E501

        :return: The style of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._style

    @style.setter
    def style(self, style):
        """Sets the style of this ModelProperty.

        The home style.  # noqa: E501

        :param style: The style of this ModelProperty.  # noqa: E501
        :type: str
        """

        self._style = style

    @property
    def basement_development(self):
        """Gets the basement_development of this ModelProperty.  # noqa: E501

        The basement development.  # noqa: E501

        :return: The basement_development of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._basement_development

    @basement_development.setter
    def basement_development(self, basement_development):
        """Sets the basement_development of this ModelProperty.

        The basement development.  # noqa: E501

        :param basement_development: The basement_development of this ModelProperty.  # noqa: E501
        :type: str
        """
        allowed_values = ["Fully Finished", "Partly Finished", "Unfinished", "Suite", "Other"]  # noqa: E501
        if basement_development not in allowed_values:
            raise ValueError(
                "Invalid value for `basement_development` ({0}), must be one of {1}"  # noqa: E501
                .format(basement_development, allowed_values)
            )

        self._basement_development = basement_development

    @property
    def basement(self):
        """Gets the basement of this ModelProperty.  # noqa: E501

        The type of basement.  # noqa: E501

        :return: The basement of this ModelProperty.  # noqa: E501
        :rtype: list[str]
        """
        return self._basement

    @basement.setter
    def basement(self, basement):
        """Sets the basement of this ModelProperty.

        The type of basement.  # noqa: E501

        :param basement: The basement of this ModelProperty.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["Walkout/Walkup", "Other"]  # noqa: E501
        if not set(basement).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `basement` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(basement) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._basement = basement

    @property
    def bedrooms_total(self):
        """Gets the bedrooms_total of this ModelProperty.  # noqa: E501

        Total number of bedrooms.  # noqa: E501

        :return: The bedrooms_total of this ModelProperty.  # noqa: E501
        :rtype: float
        """
        return self._bedrooms_total

    @bedrooms_total.setter
    def bedrooms_total(self, bedrooms_total):
        """Sets the bedrooms_total of this ModelProperty.

        Total number of bedrooms.  # noqa: E501

        :param bedrooms_total: The bedrooms_total of this ModelProperty.  # noqa: E501
        :type: float
        """

        self._bedrooms_total = bedrooms_total

    @property
    def bedrooms_ag(self):
        """Gets the bedrooms_ag of this ModelProperty.  # noqa: E501

        Number of bedrooms above grade.  # noqa: E501

        :return: The bedrooms_ag of this ModelProperty.  # noqa: E501
        :rtype: float
        """
        return self._bedrooms_ag

    @bedrooms_ag.setter
    def bedrooms_ag(self, bedrooms_ag):
        """Sets the bedrooms_ag of this ModelProperty.

        Number of bedrooms above grade.  # noqa: E501

        :param bedrooms_ag: The bedrooms_ag of this ModelProperty.  # noqa: E501
        :type: float
        """

        self._bedrooms_ag = bedrooms_ag

    @property
    def bedrooms_with_closet(self):
        """Gets the bedrooms_with_closet of this ModelProperty.  # noqa: E501

        Number of bedrooms With closet.  # noqa: E501

        :return: The bedrooms_with_closet of this ModelProperty.  # noqa: E501
        :rtype: float
        """
        return self._bedrooms_with_closet

    @bedrooms_with_closet.setter
    def bedrooms_with_closet(self, bedrooms_with_closet):
        """Sets the bedrooms_with_closet of this ModelProperty.

        Number of bedrooms With closet.  # noqa: E501

        :param bedrooms_with_closet: The bedrooms_with_closet of this ModelProperty.  # noqa: E501
        :type: float
        """

        self._bedrooms_with_closet = bedrooms_with_closet

    @property
    def master_walk_in(self):
        """Gets the master_walk_in of this ModelProperty.  # noqa: E501

        Does the master bedroom have a walk-in closet?  # noqa: E501

        :return: The master_walk_in of this ModelProperty.  # noqa: E501
        :rtype: bool
        """
        return self._master_walk_in

    @master_walk_in.setter
    def master_walk_in(self, master_walk_in):
        """Sets the master_walk_in of this ModelProperty.

        Does the master bedroom have a walk-in closet?  # noqa: E501

        :param master_walk_in: The master_walk_in of this ModelProperty.  # noqa: E501
        :type: bool
        """

        self._master_walk_in = master_walk_in

    @property
    def master_ensuite(self):
        """Gets the master_ensuite of this ModelProperty.  # noqa: E501

        Does the master bedroom have ensuite?  # noqa: E501

        :return: The master_ensuite of this ModelProperty.  # noqa: E501
        :rtype: bool
        """
        return self._master_ensuite

    @master_ensuite.setter
    def master_ensuite(self, master_ensuite):
        """Sets the master_ensuite of this ModelProperty.

        Does the master bedroom have ensuite?  # noqa: E501

        :param master_ensuite: The master_ensuite of this ModelProperty.  # noqa: E501
        :type: bool
        """

        self._master_ensuite = master_ensuite

    @property
    def bathrooms_full(self):
        """Gets the bathrooms_full of this ModelProperty.  # noqa: E501

        Number of full bathrooms.  # noqa: E501

        :return: The bathrooms_full of this ModelProperty.  # noqa: E501
        :rtype: float
        """
        return self._bathrooms_full

    @bathrooms_full.setter
    def bathrooms_full(self, bathrooms_full):
        """Sets the bathrooms_full of this ModelProperty.

        Number of full bathrooms.  # noqa: E501

        :param bathrooms_full: The bathrooms_full of this ModelProperty.  # noqa: E501
        :type: float
        """

        self._bathrooms_full = bathrooms_full

    @property
    def bathrooms_half(self):
        """Gets the bathrooms_half of this ModelProperty.  # noqa: E501

        Number of half bathrooms.  # noqa: E501

        :return: The bathrooms_half of this ModelProperty.  # noqa: E501
        :rtype: float
        """
        return self._bathrooms_half

    @bathrooms_half.setter
    def bathrooms_half(self, bathrooms_half):
        """Sets the bathrooms_half of this ModelProperty.

        Number of half bathrooms.  # noqa: E501

        :param bathrooms_half: The bathrooms_half of this ModelProperty.  # noqa: E501
        :type: float
        """

        self._bathrooms_half = bathrooms_half

    @property
    def bathrooms_main(self):
        """Gets the bathrooms_main of this ModelProperty.  # noqa: E501

        Number of bathrooms on the main floor.  # noqa: E501

        :return: The bathrooms_main of this ModelProperty.  # noqa: E501
        :rtype: float
        """
        return self._bathrooms_main

    @bathrooms_main.setter
    def bathrooms_main(self, bathrooms_main):
        """Sets the bathrooms_main of this ModelProperty.

        Number of bathrooms on the main floor.  # noqa: E501

        :param bathrooms_main: The bathrooms_main of this ModelProperty.  # noqa: E501
        :type: float
        """

        self._bathrooms_main = bathrooms_main

    @property
    def bathrooms_basement(self):
        """Gets the bathrooms_basement of this ModelProperty.  # noqa: E501

        Number of bathrooms basement floor.  # noqa: E501

        :return: The bathrooms_basement of this ModelProperty.  # noqa: E501
        :rtype: float
        """
        return self._bathrooms_basement

    @bathrooms_basement.setter
    def bathrooms_basement(self, bathrooms_basement):
        """Sets the bathrooms_basement of this ModelProperty.

        Number of bathrooms basement floor.  # noqa: E501

        :param bathrooms_basement: The bathrooms_basement of this ModelProperty.  # noqa: E501
        :type: float
        """

        self._bathrooms_basement = bathrooms_basement

    @property
    def room_number(self):
        """Gets the room_number of this ModelProperty.  # noqa: E501

        Total number of rooms except bathrooms.  # noqa: E501

        :return: The room_number of this ModelProperty.  # noqa: E501
        :rtype: float
        """
        return self._room_number

    @room_number.setter
    def room_number(self, room_number):
        """Sets the room_number of this ModelProperty.

        Total number of rooms except bathrooms.  # noqa: E501

        :param room_number: The room_number of this ModelProperty.  # noqa: E501
        :type: float
        """

        self._room_number = room_number

    @property
    def kitchen_countertops(self):
        """Gets the kitchen_countertops of this ModelProperty.  # noqa: E501

        The type of material for the kitchen countertops.  # noqa: E501

        :return: The kitchen_countertops of this ModelProperty.  # noqa: E501
        :rtype: list[str]
        """
        return self._kitchen_countertops

    @kitchen_countertops.setter
    def kitchen_countertops(self, kitchen_countertops):
        """Sets the kitchen_countertops of this ModelProperty.

        The type of material for the kitchen countertops.  # noqa: E501

        :param kitchen_countertops: The kitchen_countertops of this ModelProperty.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["Granite", "Not Stone", "Laminate", "Quartz", "Other"]  # noqa: E501
        if not set(kitchen_countertops).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `kitchen_countertops` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(kitchen_countertops) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._kitchen_countertops = kitchen_countertops

    @property
    def kitchen_island(self):
        """Gets the kitchen_island of this ModelProperty.  # noqa: E501

        Does the kitchen have an island?  # noqa: E501

        :return: The kitchen_island of this ModelProperty.  # noqa: E501
        :rtype: bool
        """
        return self._kitchen_island

    @kitchen_island.setter
    def kitchen_island(self, kitchen_island):
        """Sets the kitchen_island of this ModelProperty.

        Does the kitchen have an island?  # noqa: E501

        :param kitchen_island: The kitchen_island of this ModelProperty.  # noqa: E501
        :type: bool
        """

        self._kitchen_island = kitchen_island

    @property
    def kitchen_appliances(self):
        """Gets the kitchen_appliances of this ModelProperty.  # noqa: E501

        The finish of the kitchen applicances.  # noqa: E501

        :return: The kitchen_appliances of this ModelProperty.  # noqa: E501
        :rtype: list[str]
        """
        return self._kitchen_appliances

    @kitchen_appliances.setter
    def kitchen_appliances(self, kitchen_appliances):
        """Sets the kitchen_appliances of this ModelProperty.

        The finish of the kitchen applicances.  # noqa: E501

        :param kitchen_appliances: The kitchen_appliances of this ModelProperty.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["Stainless Steel", "White", "Black", "Other"]  # noqa: E501
        if not set(kitchen_appliances).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `kitchen_appliances` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(kitchen_appliances) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._kitchen_appliances = kitchen_appliances

    @property
    def kitchen_layout(self):
        """Gets the kitchen_layout of this ModelProperty.  # noqa: E501

        Kitchen layout.  # noqa: E501

        :return: The kitchen_layout of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._kitchen_layout

    @kitchen_layout.setter
    def kitchen_layout(self, kitchen_layout):
        """Sets the kitchen_layout of this ModelProperty.

        Kitchen layout.  # noqa: E501

        :param kitchen_layout: The kitchen_layout of this ModelProperty.  # noqa: E501
        :type: str
        """
        allowed_values = ["Open Concept", "Contained"]  # noqa: E501
        if kitchen_layout not in allowed_values:
            raise ValueError(
                "Invalid value for `kitchen_layout` ({0}), must be one of {1}"  # noqa: E501
                .format(kitchen_layout, allowed_values)
            )

        self._kitchen_layout = kitchen_layout

    @property
    def flooring(self):
        """Gets the flooring of this ModelProperty.  # noqa: E501

        Overall flooring.  # noqa: E501

        :return: The flooring of this ModelProperty.  # noqa: E501
        :rtype: list[str]
        """
        return self._flooring

    @flooring.setter
    def flooring(self, flooring):
        """Sets the flooring of this ModelProperty.

        Overall flooring.  # noqa: E501

        :param flooring: The flooring of this ModelProperty.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["Carpet", "Laminate Flooring", "Linoleum", "Hardwood", "Ceramic Tile", "Slate", "Non-Ceramic Tile", "Wall to Wall Carpet", "Carpet Over Hardwood", "Cork Flooring", "Marble", "Softwood", "Carpet Over Softwood"]  # noqa: E501
        if not set(flooring).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `flooring` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(flooring) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._flooring = flooring

    @property
    def fireplace(self):
        """Gets the fireplace of this ModelProperty.  # noqa: E501

        The type of fireplace.  # noqa: E501

        :return: The fireplace of this ModelProperty.  # noqa: E501
        :rtype: list[str]
        """
        return self._fireplace

    @fireplace.setter
    def fireplace(self, fireplace):
        """Sets the fireplace of this ModelProperty.

        The type of fireplace.  # noqa: E501

        :param fireplace: The fireplace of this ModelProperty.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["Electric", "Wood With Log Lighter", "Wood", "Gas"]  # noqa: E501
        if not set(fireplace).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `fireplace` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(fireplace) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._fireplace = fireplace

    @property
    def heating_type(self):
        """Gets the heating_type of this ModelProperty.  # noqa: E501

        Do you have in floor heating?  # noqa: E501

        :return: The heating_type of this ModelProperty.  # noqa: E501
        :rtype: list[str]
        """
        return self._heating_type

    @heating_type.setter
    def heating_type(self, heating_type):
        """Sets the heating_type of this ModelProperty.

        Do you have in floor heating?  # noqa: E501

        :param heating_type: The heating_type of this ModelProperty.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["In Floor Heat System", "No In Floor Heat System"]  # noqa: E501
        if not set(heating_type).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `heating_type` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(heating_type) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._heating_type = heating_type

    @property
    def backyard_details(self):
        """Gets the backyard_details of this ModelProperty.  # noqa: E501

        Backyard details (fence, deck, landscaping, etc.)  # noqa: E501

        :return: The backyard_details of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._backyard_details

    @backyard_details.setter
    def backyard_details(self, backyard_details):
        """Sets the backyard_details of this ModelProperty.

        Backyard details (fence, deck, landscaping, etc.)  # noqa: E501

        :param backyard_details: The backyard_details of this ModelProperty.  # noqa: E501
        :type: str
        """

        self._backyard_details = backyard_details

    @property
    def exterior(self):
        """Gets the exterior of this ModelProperty.  # noqa: E501

        The type of material of the exterior of the home.  # noqa: E501

        :return: The exterior of this ModelProperty.  # noqa: E501
        :rtype: list[str]
        """
        return self._exterior

    @exterior.setter
    def exterior(self, exterior):
        """Sets the exterior of this ModelProperty.

        The type of material of the exterior of the home.  # noqa: E501

        :param exterior: The exterior of this ModelProperty.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["Brick", "Composite", "Stucco", "Fiber Cement Siding", "Stone", "Metal", "Wood", "Concrete", "Asbestos", "Cedar", "Vinyl", "Shingles", "Log", "Asphalt Shingles", "Wood Shingle"]  # noqa: E501
        if not set(exterior).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `exterior` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(exterior) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._exterior = exterior

    @property
    def parking(self):
        """Gets the parking of this ModelProperty.  # noqa: E501

        Parking features.  # noqa: E501

        :return: The parking of this ModelProperty.  # noqa: E501
        :rtype: list[str]
        """
        return self._parking

    @parking.setter
    def parking(self, parking):
        """Sets the parking of this ModelProperty.

        Parking features.  # noqa: E501

        :param parking: The parking of this ModelProperty.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["Attached", "Detached", "Parking Pad", "Rear Drive Access", "RV Parking", "Outdoor Stalls", "220 Volt Wiring"]  # noqa: E501
        if not set(parking).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `parking` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(parking) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._parking = parking

    @property
    def total_parking(self):
        """Gets the total_parking of this ModelProperty.  # noqa: E501

        Total parking spots.  # noqa: E501

        :return: The total_parking of this ModelProperty.  # noqa: E501
        :rtype: float
        """
        return self._total_parking

    @total_parking.setter
    def total_parking(self, total_parking):
        """Sets the total_parking of this ModelProperty.

        Total parking spots.  # noqa: E501

        :param total_parking: The total_parking of this ModelProperty.  # noqa: E501
        :type: float
        """

        self._total_parking = total_parking

    @property
    def enclosed_parking(self):
        """Gets the enclosed_parking of this ModelProperty.  # noqa: E501

        Total enclosed parking.  # noqa: E501

        :return: The enclosed_parking of this ModelProperty.  # noqa: E501
        :rtype: float
        """
        return self._enclosed_parking

    @enclosed_parking.setter
    def enclosed_parking(self, enclosed_parking):
        """Sets the enclosed_parking of this ModelProperty.

        Total enclosed parking.  # noqa: E501

        :param enclosed_parking: The enclosed_parking of this ModelProperty.  # noqa: E501
        :type: float
        """

        self._enclosed_parking = enclosed_parking

    @property
    def roof_type(self):
        """Gets the roof_type of this ModelProperty.  # noqa: E501

        The type of material of the roof.  # noqa: E501

        :return: The roof_type of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._roof_type

    @roof_type.setter
    def roof_type(self, roof_type):
        """Sets the roof_type of this ModelProperty.

        The type of material of the roof.  # noqa: E501

        :param roof_type: The roof_type of this ModelProperty.  # noqa: E501
        :type: str
        """
        allowed_values = ["Asphalt Shingles", "Concrete Tiles", "Wood Shingles", "Clay Tile", "Metal", "Tar & Gravel", "Pine Shakes", "Vinyl Shingles", "Cedar Shakes", "EPDM Membrane", "See Remarks", "Roll Roofing", "Fiberglass"]  # noqa: E501
        if roof_type not in allowed_values:
            raise ValueError(
                "Invalid value for `roof_type` ({0}), must be one of {1}"  # noqa: E501
                .format(roof_type, allowed_values)
            )

        self._roof_type = roof_type

    @property
    def roof_age_years(self):
        """Gets the roof_age_years of this ModelProperty.  # noqa: E501

        The age of the roof in years.  # noqa: E501

        :return: The roof_age_years of this ModelProperty.  # noqa: E501
        :rtype: int
        """
        return self._roof_age_years

    @roof_age_years.setter
    def roof_age_years(self, roof_age_years):
        """Sets the roof_age_years of this ModelProperty.

        The age of the roof in years.  # noqa: E501

        :param roof_age_years: The roof_age_years of this ModelProperty.  # noqa: E501
        :type: int
        """

        self._roof_age_years = roof_age_years

    @property
    def is_renovated(self):
        """Gets the is_renovated of this ModelProperty.  # noqa: E501

        Has the house been renovated?  # noqa: E501

        :return: The is_renovated of this ModelProperty.  # noqa: E501
        :rtype: bool
        """
        return self._is_renovated

    @is_renovated.setter
    def is_renovated(self, is_renovated):
        """Sets the is_renovated of this ModelProperty.

        Has the house been renovated?  # noqa: E501

        :param is_renovated: The is_renovated of this ModelProperty.  # noqa: E501
        :type: bool
        """

        self._is_renovated = is_renovated

    @property
    def renovations_or_upgrades(self):
        """Gets the renovations_or_upgrades of this ModelProperty.  # noqa: E501

        The renovations or upgrades.  # noqa: E501

        :return: The renovations_or_upgrades of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._renovations_or_upgrades

    @renovations_or_upgrades.setter
    def renovations_or_upgrades(self, renovations_or_upgrades):
        """Sets the renovations_or_upgrades of this ModelProperty.

        The renovations or upgrades.  # noqa: E501

        :param renovations_or_upgrades: The renovations_or_upgrades of this ModelProperty.  # noqa: E501
        :type: str
        """

        self._renovations_or_upgrades = renovations_or_upgrades

    @property
    def property_photos_user_submitted(self):
        """Gets the property_photos_user_submitted of this ModelProperty.  # noqa: E501

        The photos of the home.  # noqa: E501

        :return: The property_photos_user_submitted of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._property_photos_user_submitted

    @property_photos_user_submitted.setter
    def property_photos_user_submitted(self, property_photos_user_submitted):
        """Sets the property_photos_user_submitted of this ModelProperty.

        The photos of the home.  # noqa: E501

        :param property_photos_user_submitted: The property_photos_user_submitted of this ModelProperty.  # noqa: E501
        :type: str
        """

        self._property_photos_user_submitted = property_photos_user_submitted

    @property
    def latitude(self):
        """Gets the latitude of this ModelProperty.  # noqa: E501

        The latitude of the location  # noqa: E501

        :return: The latitude of this ModelProperty.  # noqa: E501
        :rtype: float
        """
        return self._latitude

    @latitude.setter
    def latitude(self, latitude):
        """Sets the latitude of this ModelProperty.

        The latitude of the location  # noqa: E501

        :param latitude: The latitude of this ModelProperty.  # noqa: E501
        :type: float
        """

        self._latitude = latitude

    @property
    def longitude(self):
        """Gets the longitude of this ModelProperty.  # noqa: E501

        The longitude of the location  # noqa: E501

        :return: The longitude of this ModelProperty.  # noqa: E501
        :rtype: float
        """
        return self._longitude

    @longitude.setter
    def longitude(self, longitude):
        """Sets the longitude of this ModelProperty.

        The longitude of the location  # noqa: E501

        :param longitude: The longitude of this ModelProperty.  # noqa: E501
        :type: float
        """

        self._longitude = longitude

    @property
    def google_place_id(self):
        """Gets the google_place_id of this ModelProperty.  # noqa: E501

        The google place id for this location  # noqa: E501

        :return: The google_place_id of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._google_place_id

    @google_place_id.setter
    def google_place_id(self, google_place_id):
        """Sets the google_place_id of this ModelProperty.

        The google place id for this location  # noqa: E501

        :param google_place_id: The google_place_id of this ModelProperty.  # noqa: E501
        :type: str
        """

        self._google_place_id = google_place_id

    @property
    def geo_hash5(self):
        """Gets the geo_hash5 of this ModelProperty.  # noqa: E501

        The geohash 5 character precision  # noqa: E501

        :return: The geo_hash5 of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._geo_hash5

    @geo_hash5.setter
    def geo_hash5(self, geo_hash5):
        """Sets the geo_hash5 of this ModelProperty.

        The geohash 5 character precision  # noqa: E501

        :param geo_hash5: The geo_hash5 of this ModelProperty.  # noqa: E501
        :type: str
        """

        self._geo_hash5 = geo_hash5

    @property
    def geo_hash12(self):
        """Gets the geo_hash12 of this ModelProperty.  # noqa: E501

        The full geohash  # noqa: E501

        :return: The geo_hash12 of this ModelProperty.  # noqa: E501
        :rtype: str
        """
        return self._geo_hash12

    @geo_hash12.setter
    def geo_hash12(self, geo_hash12):
        """Sets the geo_hash12 of this ModelProperty.

        The full geohash  # noqa: E501

        :param geo_hash12: The geo_hash12 of this ModelProperty.  # noqa: E501
        :type: str
        """

        self._geo_hash12 = geo_hash12

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ModelProperty):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
