import { EnvironmentVariablesService as CommonEnvironmentVariablesService } from '@aws-lambda-powertools/commons';
/**
 * Class EnvironmentVariablesService
 *
 * This class is used to return environment variables that are available in the runtime of
 * the current Lambda invocation.
 */
class EnvironmentVariablesService extends CommonEnvironmentVariablesService {
    namespaceVariable = 'POWERTOOLS_METRICS_NAMESPACE';
    disabledVariable = 'POWERTOOLS_METRICS_DISABLED';
    /**
     * Get the value of the `POWERTOOLS_METRICS_NAMESPACE` environment variable.
     */
    getNamespace() {
        return this.get(this.namespaceVariable);
    }
    /**
     * Get the value of the `POWERTOOLS_METRICS_DISABLED` or `POWERTOOLS_DEV` environment variables.
     *
     * The `POWERTOOLS_METRICS_DISABLED` environment variable takes precedence over `POWERTOOLS_DEV`.
     */
    getMetricsDisabled() {
        const value = this.get(this.disabledVariable);
        if (this.isValueFalse(value))
            return false;
        if (this.isValueTrue(value))
            return true;
        if (this.isDevMode())
            return true;
        return false;
    }
}
export { EnvironmentVariablesService };
