/**
 * These constants are used to store cleanup functions in Middy's `request.internal` object.
 * They are used by the `cleanupPowertools` function to check if any cleanup function
 * is present and execute it.
 */
declare const PREFIX = "powertools-for-aws";
/**
 * Key to store the tracer instance in the `request.internal` object.
 *
 * @see {@link cleanupMiddlewares}
 */
declare const TRACER_KEY = "powertools-for-aws.tracer";
/**
 * Key to store the metrics instance in the `request.internal` object.
 *
 * @see {@link cleanupMiddlewares}
 */
declare const METRICS_KEY = "powertools-for-aws.metrics";
/**
 * Key to store the logger instance in the `request.internal` object.
 *
 * @see {@link cleanupMiddlewares}
 */
declare const LOGGER_KEY = "powertools-for-aws.logger";
/**
 * Key to store the idempotency instance in the `request.internal` object.
 *
 * @see {@link cleanupMiddlewares}
 */
declare const IDEMPOTENCY_KEY = "powertools-for-aws.idempotency";
export { PREFIX, TRACER_KEY, METRICS_KEY, LOGGER_KEY, IDEMPOTENCY_KEY };
//# sourceMappingURL=constants.d.ts.map