"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TailscaleLambdaProxy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_lambda_nodejs_1 = require("aws-cdk-lib/aws-lambda-nodejs");
const constructs_1 = require("constructs");
const tailscale_lambda_extension_1 = require("tailscale-lambda-extension");
class TailscaleLambdaProxy extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.extension = new tailscale_lambda_extension_1.TailscaleLambdaExtension(scope, 'tailscale-extension', props.options.extension);
        this.lambda = new aws_lambda_nodejs_1.NodejsFunction(this, 'tailscale-proxy-lambda', {
            ...props.options.lambda,
            runtime: lambda.Runtime.NODEJS_20_X,
            entry: 'src/lambda/tailscale-proxy/index.ts',
            layers: [this.extension.layer],
            environment: {
                TS_SECRET_API_KEY: props.tsSecretApiKey.secretArn,
                TS_HOSTNAME: props.tsHostname,
            },
            timeout: cdk.Duration.minutes(15),
            memorySize: 256,
        });
        props.tsSecretApiKey.grantRead(this.lambda);
        this.lambdaFunctionUrl = this.lambda.addFunctionUrl({
            authType: lambda.FunctionUrlAuthType.AWS_IAM,
        });
    }
}
exports.TailscaleLambdaProxy = TailscaleLambdaProxy;
_a = JSII_RTTI_SYMBOL_1;
TailscaleLambdaProxy[_a] = { fqn: "tailscale-lambda-proxy.TailscaleLambdaProxy", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,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