import { FunctionUrl } from 'aws-cdk-lib/aws-lambda';
import { NodejsFunction } from 'aws-cdk-lib/aws-lambda-nodejs';
import * as secretsmanager from 'aws-cdk-lib/aws-secretsmanager';
import { Construct } from 'constructs';
import { TailscaleLambdaExtension, TailscaleLambdaExtensionProps } from 'tailscale-lambda-extension';
export interface LambdaOptions {
    readonly functionName?: string;
}
export interface TailscaleLambdaProxyPropsOptions {
    readonly extension: TailscaleLambdaExtensionProps;
    readonly lambda: LambdaOptions;
}
export interface TailscaleLambdaProxyProps {
    /**
     * The name of the AWS Secrets Manager secret that contains the pure text Tailscale API Key.
     */
    readonly tsSecretApiKey: secretsmanager.Secret;
    /**
     * The "Machine" name as shown in the Tailscale admin console that identifies the Lambda function.
     */
    readonly tsHostname: string;
    readonly options: TailscaleLambdaProxyPropsOptions;
}
export declare class TailscaleLambdaProxy extends Construct {
    readonly extension: TailscaleLambdaExtension;
    readonly lambda: NodejsFunction;
    readonly lambdaFunctionUrl: FunctionUrl;
    constructor(scope: Construct, id: string, props: TailscaleLambdaProxyProps);
}
