import interscript
import regex as re
interscript.stdlib.define_map("alalc-kan-Kana-Latn-1997")
interscript.stdlib.add_map_alias("alalc-kan-Kana-Latn-1997", "kana_chars_1", "ಾ")
interscript.stdlib.add_map_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1", "[ಾಿೀುೂೃೆೇೈೊೋೌ್]")
def _stage_main(s):
    s = re.compile("ಕ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("k", s)
    s = re.compile("ಖ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("kh", s)
    s = re.compile("ಗ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("g", s)
    s = re.compile("ಘ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("gh", s)
    s = re.compile("ಙ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("ṅ", s)
    s = re.compile("ಚ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("c", s)
    s = re.compile("ಛ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("ch", s)
    s = re.compile("ಜ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("j", s)
    s = re.compile("ಝ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("jh", s)
    s = re.compile("ಞ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("ñ", s)
    s = re.compile("ಟ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("ṭ", s)
    s = re.compile("ಠ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("ṭh", s)
    s = re.compile("ಡ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("ḍ", s)
    s = re.compile("ಢ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("ḍh", s)
    s = re.compile("ಣ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("ṇ", s)
    s = re.compile("ತ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("t", s)
    s = re.compile("ಥ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("th", s)
    s = re.compile("ದ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("d", s)
    s = re.compile("ಧ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("dh", s)
    s = re.compile("ನ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("n", s)
    s = re.compile("ಪ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("p", s)
    s = re.compile("ಫ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("ph", s)
    s = re.compile("ಬ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("b", s)
    s = re.compile("ಭ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("bh", s)
    s = re.compile("ಮ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("m", s)
    s = re.compile("ಯ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("y", s)
    s = re.compile("ರ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("r", s)
    s = re.compile("ಱ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("ṟ", s)
    s = re.compile("ಲ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("l", s)
    s = re.compile("ಳ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("ḷ", s)
    s = re.compile("ೞ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("l̤", s)
    s = re.compile("ವ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("v", s)
    s = re.compile("ಶ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("ś", s)
    s = re.compile("ಷ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("ṣ", s)
    s = re.compile("ಸ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("s", s)
    s = re.compile("ಹ(?="+interscript.stdlib.get_alias_re("alalc-kan-Kana-Latn-1997", "kana_chars_1")+")", re.MULTILINE).sub("h", s)
    s = re.compile("ಂ(?=[ಕಖಗಘಙ])", re.MULTILINE).sub("ṅ", s)
    s = re.compile("ಂ(?=[ಚಛಜಝಞ])", re.MULTILINE).sub("ñ", s)
    s = re.compile("ಂ(?=[ಟಠಡಢಣ])", re.MULTILINE).sub("ṇ", s)
    s = re.compile("ಂ(?=[ತಥದಧನ])", re.MULTILINE).sub("n", s)
    s = interscript.stdlib.parallel_replace_tree(s, _PTREE_1303450861787291819)
    s = interscript.functions.compose(s, {})
    return s

interscript.stdlib.add_map_stage("alalc-kan-Kana-Latn-1997", "main", _stage_main)
_PTREE_1303450861787291819 = {3205:{None:"a"},3206:{None:"ā"},3207:{None:"i"},3208:{None:"ī"},3209:{None:"u"},3210:{None:"ū"},3211:{None:"ṛ"},3296:{None:"ṝ"},3212:{None:"ḻ"},3214:{None:"e"},3215:{None:"ē"},3216:{None:"ai"},3218:{None:"o"},3219:{None:"ō"},3220:{None:"au"},3221:{None:"ka"},3222:{None:"kha"},3223:{None:"ga"},3224:{None:"gha"},3225:{None:"ṅa"},3226:{None:"ca"},3227:{None:"cha"},3228:{None:"ja"},3229:{None:"jha"},3230:{None:"ña"},3231:{None:"ṭa"},3232:{None:"ṭha"},3233:{None:"ḍa"},3234:{None:"ḍha"},3235:{None:"ṇa"},3236:{None:"ta"},3237:{None:"tha"},3238:{None:"da"},3239:{None:"dha"},3240:{None:"na"},3242:{None:"pa"},3243:{None:"pha"},3244:{None:"ba"},3245:{None:"bha"},3246:{None:"ma"},3247:{None:"ya"},3248:{None:"ra"},3249:{None:"ṟa"},3250:{None:"la"},3251:{None:"ḷa"},3294:{None:"l̤a"},3253:{None:"va"},3254:{None:"śa"},3255:{None:"ṣa"},3256:{None:"sa"},3257:{None:"ha"},3203:{None:"ḥ"},3202:{None:"ṃ"},3260:{None:""},3262:{None:"ā"},3263:{None:"i"},3264:{None:"ī"},3265:{None:"u"},3266:{None:"ū"},3267:{None:"ṛ"},3268:{None:"ṝ"},3298:{None:"ḻ"},3270:{None:"e"},3271:{None:"ē"},3272:{None:"ai"},3274:{None:"o"},3275:{None:"ō"},3276:{None:"au"},2381:{None:""},2364:{None:""},3277:{None:""},8205:{None:""},8204:{None:""},3302:{None:"0"},3303:{None:"1"},3304:{None:"2"},3305:{None:"3"},3306:{None:"4"},3307:{None:"5"},3308:{None:"6"},3309:{None:"7"},3310:{None:"8"},3311:{None:"9"}}
