#!/usr/bin/python3
from csepy.PublicFunctions.CommandInterface.ICommand import ICommand
from csepy.System.MultiProcessing.MultiProcessing import RunCommandsAsync


class AsyncCommand(ICommand):
    def Execute(self):
        RunCommandsAsync(self.request)


AsyncCommand.PublicFacing = "async"
AsyncCommand.MinRequestParameters = 1
AsyncCommand.Help = "Receives a command or list of commands and runs them via thread pool concurrently\n" \
                    "async [command] [command]...\n" \
                    "command - a command that will be run async, all commands passed must be wrapped in parentheses"
AsyncCommand.ShortHelp = "Runs the added command(s) concurrently"
