from typing import Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="CreateFineTuningJobRequestIntegrationsType0ItemWandb")


@_attrs_define
class CreateFineTuningJobRequestIntegrationsType0ItemWandb:
    """The settings for your integration with Weights and Biases. This payload specifies the project that
    metrics will be sent to. Optionally, you can set an explicit display name for your run, add tags
    to your run, and set a default entity (team, username, etc) to be associated with your run.

        Attributes:
            project (str): The name of the project that the new run will be created under.
                 Example: my-wandb-project.
            name (Union[None, Unset, str]): A display name to set for the run. If not set, we will use the Job ID as the
                name.
            entity (Union[None, Unset, str]): The entity to use for the run. This allows you to set the team or username of
                the WandB user that you would
                like associated with the run. If not set, the default entity for the registered WandB API key is used.
            tags (Union[Unset, List[str]]): A list of tags to be attached to the newly created run. These tags are passed
                through directly to WandB. Some
                default tags are generated by OpenAI: "openai/finetune", "openai/{base-model}", "openai/{ftjob-abcdef}".
    """

    project: str
    name: Union[None, Unset, str] = UNSET
    entity: Union[None, Unset, str] = UNSET
    tags: Union[Unset, List[str]] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        project = self.project

        name: Union[None, Unset, str]
        if isinstance(self.name, Unset):
            name = UNSET
        else:
            name = self.name

        entity: Union[None, Unset, str]
        if isinstance(self.entity, Unset):
            entity = UNSET
        else:
            entity = self.entity

        tags: Union[Unset, List[str]] = UNSET
        if not isinstance(self.tags, Unset):
            tags = self.tags

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "project": project,
            }
        )
        if name is not UNSET:
            field_dict["name"] = name
        if entity is not UNSET:
            field_dict["entity"] = entity
        if tags is not UNSET:
            field_dict["tags"] = tags

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        project = d.pop("project")

        def _parse_name(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        name = _parse_name(d.pop("name", UNSET))

        def _parse_entity(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        entity = _parse_entity(d.pop("entity", UNSET))

        tags = cast(List[str], d.pop("tags", UNSET))

        create_fine_tuning_job_request_integrations_type_0_item_wandb = cls(
            project=project,
            name=name,
            entity=entity,
            tags=tags,
        )

        create_fine_tuning_job_request_integrations_type_0_item_wandb.additional_properties = d
        return create_fine_tuning_job_request_integrations_type_0_item_wandb

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
