from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.create_chat_completion_stream_response_choices_item_finish_reason import (
    CreateChatCompletionStreamResponseChoicesItemFinishReason,
)
from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.chat_completion_stream_response_delta import ChatCompletionStreamResponseDelta
    from ..models.create_chat_completion_stream_response_choices_item_logprobs_type_0 import (
        CreateChatCompletionStreamResponseChoicesItemLogprobsType0,
    )


T = TypeVar("T", bound="CreateChatCompletionStreamResponseChoicesItem")


@_attrs_define
class CreateChatCompletionStreamResponseChoicesItem:
    """
    Attributes:
        delta (ChatCompletionStreamResponseDelta): A chat completion delta generated by streamed model responses.
        finish_reason (CreateChatCompletionStreamResponseChoicesItemFinishReason): The reason the model stopped
            generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
            `length` if the maximum number of tokens specified in the request was reached,
            `content_filter` if content was omitted due to a flag from our content filters,
            `tool_calls` if the model called a tool, or `function_call` (deprecated) if the model called a function.
        index (int): The index of the choice in the list of choices.
        logprobs (Union['CreateChatCompletionStreamResponseChoicesItemLogprobsType0', None, Unset]): Log probability
            information for the choice.
    """

    delta: "ChatCompletionStreamResponseDelta"
    finish_reason: CreateChatCompletionStreamResponseChoicesItemFinishReason
    index: int
    logprobs: Union["CreateChatCompletionStreamResponseChoicesItemLogprobsType0", None, Unset] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        from ..models.create_chat_completion_stream_response_choices_item_logprobs_type_0 import (
            CreateChatCompletionStreamResponseChoicesItemLogprobsType0,
        )

        delta = self.delta.to_dict()

        finish_reason = self.finish_reason.value

        index = self.index

        logprobs: Union[Dict[str, Any], None, Unset]
        if isinstance(self.logprobs, Unset):
            logprobs = UNSET
        elif isinstance(self.logprobs, CreateChatCompletionStreamResponseChoicesItemLogprobsType0):
            logprobs = self.logprobs.to_dict()
        else:
            logprobs = self.logprobs

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "delta": delta,
                "finish_reason": finish_reason,
                "index": index,
            }
        )
        if logprobs is not UNSET:
            field_dict["logprobs"] = logprobs

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.chat_completion_stream_response_delta import ChatCompletionStreamResponseDelta
        from ..models.create_chat_completion_stream_response_choices_item_logprobs_type_0 import (
            CreateChatCompletionStreamResponseChoicesItemLogprobsType0,
        )

        d = src_dict.copy()
        delta = ChatCompletionStreamResponseDelta.from_dict(d.pop("delta"))

        finish_reason = CreateChatCompletionStreamResponseChoicesItemFinishReason(d.pop("finish_reason"))

        index = d.pop("index")

        def _parse_logprobs(
            data: object,
        ) -> Union["CreateChatCompletionStreamResponseChoicesItemLogprobsType0", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                logprobs_type_0 = CreateChatCompletionStreamResponseChoicesItemLogprobsType0.from_dict(data)

                return logprobs_type_0
            except:  # noqa: E722
                pass
            return cast(Union["CreateChatCompletionStreamResponseChoicesItemLogprobsType0", None, Unset], data)

        logprobs = _parse_logprobs(d.pop("logprobs", UNSET))

        create_chat_completion_stream_response_choices_item = cls(
            delta=delta,
            finish_reason=finish_reason,
            index=index,
            logprobs=logprobs,
        )

        create_chat_completion_stream_response_choices_item.additional_properties = d
        return create_chat_completion_stream_response_choices_item

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
