# coding: utf-8

"""
    SnapTrade

    Connect brokerage accounts to your app for live positions and trading

    The version of the OpenAPI document: 1.0.0
    Contact: api@snaptrade.com
    Created by: https://snaptrade.com/
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from snaptrade_client import schemas  # noqa: F401


class ManualTradeFormBracket(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)

    Inputs for placing an order with the brokerage.
    """


    class MetaOapg:
        required = {
            "time_in_force",
            "take_profit",
            "stop_loss",
            "action",
            "instrument",
            "order_type",
        }
        
        class properties:
        
            @staticmethod
            def action() -> typing.Type['ActionStrictWithOptions']:
                return ActionStrictWithOptions
        
            @staticmethod
            def instrument() -> typing.Type['TradingInstrument']:
                return TradingInstrument
        
            @staticmethod
            def order_type() -> typing.Type['OrderTypeStrict']:
                return OrderTypeStrict
        
            @staticmethod
            def time_in_force() -> typing.Type['TimeInForceStrict']:
                return TimeInForceStrict
        
            @staticmethod
            def stop_loss() -> typing.Type['StopLoss']:
                return StopLoss
        
            @staticmethod
            def take_profit() -> typing.Type['TakeProfit']:
                return TakeProfit
            
            
            class price(
                schemas.NumberBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneDecimalMixin
            ):
            
            
                def __new__(
                    cls,
                    *args: typing.Union[None, decimal.Decimal, int, float, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'price':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                    )
            
            
            class stop(
                schemas.NumberBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneDecimalMixin
            ):
            
            
                def __new__(
                    cls,
                    *args: typing.Union[None, decimal.Decimal, int, float, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'stop':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                    )
            units = schemas.NumberSchema
            __annotations__ = {
                "action": action,
                "instrument": instrument,
                "order_type": order_type,
                "time_in_force": time_in_force,
                "stop_loss": stop_loss,
                "take_profit": take_profit,
                "price": price,
                "stop": stop,
                "units": units,
            }
    
    time_in_force: 'TimeInForceStrict'
    take_profit: 'TakeProfit'
    stop_loss: 'StopLoss'
    action: 'ActionStrictWithOptions'
    instrument: 'TradingInstrument'
    order_type: 'OrderTypeStrict'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["action"]) -> 'ActionStrictWithOptions': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["instrument"]) -> 'TradingInstrument': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["order_type"]) -> 'OrderTypeStrict': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["time_in_force"]) -> 'TimeInForceStrict': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["stop_loss"]) -> 'StopLoss': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["take_profit"]) -> 'TakeProfit': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["price"]) -> MetaOapg.properties.price: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["stop"]) -> MetaOapg.properties.stop: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["units"]) -> MetaOapg.properties.units: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["action", "instrument", "order_type", "time_in_force", "stop_loss", "take_profit", "price", "stop", "units", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["action"]) -> 'ActionStrictWithOptions': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["instrument"]) -> 'TradingInstrument': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["order_type"]) -> 'OrderTypeStrict': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["time_in_force"]) -> 'TimeInForceStrict': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["stop_loss"]) -> 'StopLoss': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["take_profit"]) -> 'TakeProfit': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["price"]) -> typing.Union[MetaOapg.properties.price, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["stop"]) -> typing.Union[MetaOapg.properties.stop, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["units"]) -> typing.Union[MetaOapg.properties.units, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["action", "instrument", "order_type", "time_in_force", "stop_loss", "take_profit", "price", "stop", "units", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        time_in_force: 'TimeInForceStrict',
        take_profit: 'TakeProfit',
        stop_loss: 'StopLoss',
        action: 'ActionStrictWithOptions',
        instrument: 'TradingInstrument',
        order_type: 'OrderTypeStrict',
        price: typing.Union[MetaOapg.properties.price, None, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        stop: typing.Union[MetaOapg.properties.stop, None, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        units: typing.Union[MetaOapg.properties.units, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'ManualTradeFormBracket':
        return super().__new__(
            cls,
            *args,
            time_in_force=time_in_force,
            take_profit=take_profit,
            stop_loss=stop_loss,
            action=action,
            instrument=instrument,
            order_type=order_type,
            price=price,
            stop=stop,
            units=units,
            _configuration=_configuration,
            **kwargs,
        )

from snaptrade_client.model.action_strict_with_options import ActionStrictWithOptions
from snaptrade_client.model.order_type_strict import OrderTypeStrict
from snaptrade_client.model.stop_loss import StopLoss
from snaptrade_client.model.take_profit import TakeProfit
from snaptrade_client.model.time_in_force_strict import TimeInForceStrict
from snaptrade_client.model.trading_instrument import TradingInstrument
