# coding: utf-8

"""
    SnapTrade

    Connect brokerage accounts to your app for live positions and trading

    The version of the OpenAPI document: 1.0.0
    Contact: api@snaptrade.com
    Created by: https://snaptrade.com/
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from snaptrade_client import schemas  # noqa: F401


class EncryptedResponse(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)

    This response consists of 2 different components that must be decrypted to obtain the decrypted message

* Decrypting the encryptedSharedKey

  The encrypted shared key is a shared key that was randomly generated by SnapTrade and encrypted using the users SSH public key provided when registering the user
  It is needed to decrypt the message in step 2.

  To decrypt the shared key, the user should have access to their SSH private key stored locally in their device

  An example Python code on how to decrypt the shared key is shown below

  ```
  def decrypt_rsa_message(self, encrypted_message):
      from Crypto.Cipher import PKCS1_OAEP
      from Crypto.PublicKey import RSA
      from base64 import b64decode

      f = open('private.pem', 'r')
      private_key = RSA.import_key(f.read())
      cipher = PKCS1_OAEP.new(private_key)

      return cipher.decrypt(b64decode(encrypted_message.encode())).decode()
  ```

* Decrypting the encryptedMessageData

   The data meant to be returned by an endpoint can be obtained by decrypting the encrypted message

   An encrypted message is a message that is encrypted using AES - MODE OCB with the shared key obtained in step one

  An example code to decrypt the encrypted message is shown below

  ```
  def decrypt_aes_message(self, shared_key, encrypted_message):
      from Crypto.Cipher import AES
      from base64 import b64decode

      encrypted_msg = b64decode(encrypted_message["encryptedMessage"].encode())
      tag = b64decode(encrypted_message["tag"].encode())
      nonce = b64decode(encrypted_message["nonce"].encode())
      cipher = AES.new(shared_key.encode(), AES.MODE_OCB, nonce=nonce)

      return cipher.decrypt_and_verify(encrypted_msg, tag).decode()
  ```

    """


    class MetaOapg:
        
        class properties:
            encryptedSharedKey = schemas.StrSchema
        
            @staticmethod
            def encryptedMessageData() -> typing.Type['EncryptedResponseEncryptedMessageData']:
                return EncryptedResponseEncryptedMessageData
            __annotations__ = {
                "encryptedSharedKey": encryptedSharedKey,
                "encryptedMessageData": encryptedMessageData,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["encryptedSharedKey"]) -> MetaOapg.properties.encryptedSharedKey: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["encryptedMessageData"]) -> 'EncryptedResponseEncryptedMessageData': ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["encryptedSharedKey"], typing_extensions.Literal["encryptedMessageData"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["encryptedSharedKey"]) -> typing.Union[MetaOapg.properties.encryptedSharedKey, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["encryptedMessageData"]) -> typing.Union['EncryptedResponseEncryptedMessageData', schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["encryptedSharedKey"], typing_extensions.Literal["encryptedMessageData"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        encryptedSharedKey: typing.Union[MetaOapg.properties.encryptedSharedKey, str, schemas.Unset] = schemas.unset,
        encryptedMessageData: typing.Union['EncryptedResponseEncryptedMessageData', schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs,
    ) -> 'EncryptedResponse':
        return super().__new__(
            cls,
            *args,
            encryptedSharedKey=encryptedSharedKey,
            encryptedMessageData=encryptedMessageData,
            _configuration=_configuration,
        )

from snaptrade_client.model.encrypted_response_encrypted_message_data import EncryptedResponseEncryptedMessageData
