# coding: utf-8

"""
    SnapTrade

    Connect brokerage accounts to your app for live positions and trading

    The version of the OpenAPI document: 1.0.0
    Contact: api@snaptrade.com
    Created by: https://snaptrade.com/
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from snaptrade_client import schemas  # noqa: F401


class BrokerageInstrument(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)
    """


    class MetaOapg:
        required = {
            "symbol",
        }
        
        class properties:
            symbol = schemas.StrSchema
            
            
            class exchange_mic(
                schemas.StrBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneStrMixin
            ):
            
            
                def __new__(
                    cls,
                    *args: typing.Union[None, str, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'exchange_mic':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                    )
            
            
            class tradeable(
                schemas.BoolBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneBoolMixin
            ):
            
            
                def __new__(
                    cls,
                    *args: typing.Union[None, bool, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'tradeable':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                    )
            
            
            class fractionable(
                schemas.BoolBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneBoolMixin
            ):
            
            
                def __new__(
                    cls,
                    *args: typing.Union[None, bool, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'fractionable':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                    )
            
            
            class universal_symbol_id(
                schemas.UUIDBase,
                schemas.StrBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneStrMixin
            ):
            
            
                class MetaOapg:
                    format = 'uuid'
            
            
                def __new__(
                    cls,
                    *args: typing.Union[None, str, uuid.UUID, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'universal_symbol_id':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                    )
            __annotations__ = {
                "symbol": symbol,
                "exchange_mic": exchange_mic,
                "tradeable": tradeable,
                "fractionable": fractionable,
                "universal_symbol_id": universal_symbol_id,
            }
        additional_properties = schemas.AnyTypeSchema
    
    symbol: MetaOapg.properties.symbol
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["symbol"]) -> MetaOapg.properties.symbol: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["exchange_mic"]) -> MetaOapg.properties.exchange_mic: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tradeable"]) -> MetaOapg.properties.tradeable: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["fractionable"]) -> MetaOapg.properties.fractionable: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["universal_symbol_id"]) -> MetaOapg.properties.universal_symbol_id: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> MetaOapg.additional_properties: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["symbol"], typing_extensions.Literal["exchange_mic"], typing_extensions.Literal["tradeable"], typing_extensions.Literal["fractionable"], typing_extensions.Literal["universal_symbol_id"], str, ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["symbol"]) -> MetaOapg.properties.symbol: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["exchange_mic"]) -> typing.Union[MetaOapg.properties.exchange_mic, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tradeable"]) -> typing.Union[MetaOapg.properties.tradeable, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["fractionable"]) -> typing.Union[MetaOapg.properties.fractionable, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["universal_symbol_id"]) -> typing.Union[MetaOapg.properties.universal_symbol_id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[MetaOapg.additional_properties, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["symbol"], typing_extensions.Literal["exchange_mic"], typing_extensions.Literal["tradeable"], typing_extensions.Literal["fractionable"], typing_extensions.Literal["universal_symbol_id"], str, ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        symbol: typing.Union[MetaOapg.properties.symbol, str, ],
        exchange_mic: typing.Union[MetaOapg.properties.exchange_mic, None, str, schemas.Unset] = schemas.unset,
        tradeable: typing.Union[MetaOapg.properties.tradeable, None, bool, schemas.Unset] = schemas.unset,
        fractionable: typing.Union[MetaOapg.properties.fractionable, None, bool, schemas.Unset] = schemas.unset,
        universal_symbol_id: typing.Union[MetaOapg.properties.universal_symbol_id, None, str, uuid.UUID, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[MetaOapg.additional_properties, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
    ) -> 'BrokerageInstrument':
        return super().__new__(
            cls,
            *args,
            symbol=symbol,
            exchange_mic=exchange_mic,
            tradeable=tradeable,
            fractionable=fractionable,
            universal_symbol_id=universal_symbol_id,
            _configuration=_configuration,
            **kwargs,
        )
