module IntXbar( // @[freechips.rocketchip.system.LitexConfig.fir 3:2]
  input   auto_int_in_0, // @[freechips.rocketchip.system.LitexConfig.fir 6:4]
  input   auto_int_in_1, // @[freechips.rocketchip.system.LitexConfig.fir 6:4]
  input   auto_int_in_2, // @[freechips.rocketchip.system.LitexConfig.fir 6:4]
  input   auto_int_in_3, // @[freechips.rocketchip.system.LitexConfig.fir 6:4]
  output  auto_int_out_0, // @[freechips.rocketchip.system.LitexConfig.fir 6:4]
  output  auto_int_out_1, // @[freechips.rocketchip.system.LitexConfig.fir 6:4]
  output  auto_int_out_2, // @[freechips.rocketchip.system.LitexConfig.fir 6:4]
  output  auto_int_out_3 // @[freechips.rocketchip.system.LitexConfig.fir 6:4]
);
  assign auto_int_out_0 = auto_int_in_0; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 15:4]
  assign auto_int_out_1 = auto_int_in_1; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 15:4]
  assign auto_int_out_2 = auto_int_in_2; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 15:4]
  assign auto_int_out_3 = auto_int_in_3; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 15:4]
endmodule
module SimpleClockGroupSource( // @[freechips.rocketchip.system.LitexConfig.fir 22:2]
  input   clock, // @[freechips.rocketchip.system.LitexConfig.fir 23:4]
  input   reset, // @[freechips.rocketchip.system.LitexConfig.fir 24:4]
  output  auto_out_member_subsystem_sbus_5_clock, // @[freechips.rocketchip.system.LitexConfig.fir 25:4]
  output  auto_out_member_subsystem_sbus_5_reset, // @[freechips.rocketchip.system.LitexConfig.fir 25:4]
  output  auto_out_member_subsystem_sbus_4_clock, // @[freechips.rocketchip.system.LitexConfig.fir 25:4]
  output  auto_out_member_subsystem_sbus_4_reset, // @[freechips.rocketchip.system.LitexConfig.fir 25:4]
  output  auto_out_member_subsystem_sbus_3_clock, // @[freechips.rocketchip.system.LitexConfig.fir 25:4]
  output  auto_out_member_subsystem_sbus_3_reset, // @[freechips.rocketchip.system.LitexConfig.fir 25:4]
  output  auto_out_member_subsystem_sbus_1_clock, // @[freechips.rocketchip.system.LitexConfig.fir 25:4]
  output  auto_out_member_subsystem_sbus_1_reset, // @[freechips.rocketchip.system.LitexConfig.fir 25:4]
  output  auto_out_member_subsystem_sbus_0_clock, // @[freechips.rocketchip.system.LitexConfig.fir 25:4]
  output  auto_out_member_subsystem_sbus_0_reset // @[freechips.rocketchip.system.LitexConfig.fir 25:4]
);
  assign auto_out_member_subsystem_sbus_5_clock = clock; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 32:4]
  assign auto_out_member_subsystem_sbus_5_reset = reset; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 32:4]
  assign auto_out_member_subsystem_sbus_4_clock = clock; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 32:4]
  assign auto_out_member_subsystem_sbus_4_reset = reset; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 32:4]
  assign auto_out_member_subsystem_sbus_3_clock = clock; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 32:4]
  assign auto_out_member_subsystem_sbus_3_reset = reset; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 32:4]
  assign auto_out_member_subsystem_sbus_1_clock = clock; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 32:4]
  assign auto_out_member_subsystem_sbus_1_reset = reset; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 32:4]
  assign auto_out_member_subsystem_sbus_0_clock = clock; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 32:4]
  assign auto_out_member_subsystem_sbus_0_reset = reset; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 32:4]
endmodule
module ClockGroupAggregator( // @[freechips.rocketchip.system.LitexConfig.fir 46:2]
  input   auto_in_member_subsystem_sbus_5_clock, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  input   auto_in_member_subsystem_sbus_5_reset, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  input   auto_in_member_subsystem_sbus_4_clock, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  input   auto_in_member_subsystem_sbus_4_reset, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  input   auto_in_member_subsystem_sbus_3_clock, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  input   auto_in_member_subsystem_sbus_3_reset, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  input   auto_in_member_subsystem_sbus_1_clock, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  input   auto_in_member_subsystem_sbus_1_reset, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  input   auto_in_member_subsystem_sbus_0_clock, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  input   auto_in_member_subsystem_sbus_0_reset, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  output  auto_out_3_member_subsystem_l2_1_clock, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  output  auto_out_3_member_subsystem_l2_1_reset, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  output  auto_out_3_member_subsystem_l2_0_clock, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  output  auto_out_3_member_subsystem_l2_0_reset, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  output  auto_out_2_member_subsystem_fbus_0_clock, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  output  auto_out_2_member_subsystem_fbus_0_reset, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  output  auto_out_1_member_subsystem_cbus_0_clock, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  output  auto_out_1_member_subsystem_cbus_0_reset, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  output  auto_out_0_member_subsystem_sbus_0_clock, // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
  output  auto_out_0_member_subsystem_sbus_0_reset // @[freechips.rocketchip.system.LitexConfig.fir 47:4]
);
  assign auto_out_3_member_subsystem_l2_1_clock = auto_in_member_subsystem_sbus_5_clock; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 70:4]
  assign auto_out_3_member_subsystem_l2_1_reset = auto_in_member_subsystem_sbus_5_reset; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 70:4]
  assign auto_out_3_member_subsystem_l2_0_clock = auto_in_member_subsystem_sbus_4_clock; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 70:4]
  assign auto_out_3_member_subsystem_l2_0_reset = auto_in_member_subsystem_sbus_4_reset; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 70:4]
  assign auto_out_2_member_subsystem_fbus_0_clock = auto_in_member_subsystem_sbus_3_clock; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 69:4]
  assign auto_out_2_member_subsystem_fbus_0_reset = auto_in_member_subsystem_sbus_3_reset; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 69:4]
  assign auto_out_1_member_subsystem_cbus_0_clock = auto_in_member_subsystem_sbus_1_clock; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 68:4]
  assign auto_out_1_member_subsystem_cbus_0_reset = auto_in_member_subsystem_sbus_1_reset; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 68:4]
  assign auto_out_0_member_subsystem_sbus_0_clock = auto_in_member_subsystem_sbus_0_clock; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 67:4]
  assign auto_out_0_member_subsystem_sbus_0_reset = auto_in_member_subsystem_sbus_0_reset; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 67:4]
endmodule
module ClockGroup( // @[freechips.rocketchip.system.LitexConfig.fir 85:2]
  input   auto_in_member_subsystem_sbus_0_clock, // @[freechips.rocketchip.system.LitexConfig.fir 86:4]
  input   auto_in_member_subsystem_sbus_0_reset, // @[freechips.rocketchip.system.LitexConfig.fir 86:4]
  output  auto_out_clock, // @[freechips.rocketchip.system.LitexConfig.fir 86:4]
  output  auto_out_reset // @[freechips.rocketchip.system.LitexConfig.fir 86:4]
);
  assign auto_out_clock = auto_in_member_subsystem_sbus_0_clock; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 100:4]
  assign auto_out_reset = auto_in_member_subsystem_sbus_0_reset; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 100:4]
endmodule
module FixedClockBroadcast( // @[freechips.rocketchip.system.LitexConfig.fir 105:2]
  input   auto_in_clock, // @[freechips.rocketchip.system.LitexConfig.fir 106:4]
  input   auto_in_reset, // @[freechips.rocketchip.system.LitexConfig.fir 106:4]
  output  auto_out_1_clock, // @[freechips.rocketchip.system.LitexConfig.fir 106:4]
  output  auto_out_1_reset, // @[freechips.rocketchip.system.LitexConfig.fir 106:4]
  output  auto_out_0_clock, // @[freechips.rocketchip.system.LitexConfig.fir 106:4]
  output  auto_out_0_reset // @[freechips.rocketchip.system.LitexConfig.fir 106:4]
);
  assign auto_out_1_clock = auto_in_clock; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 123:4]
  assign auto_out_1_reset = auto_in_reset; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 123:4]
  assign auto_out_0_clock = auto_in_clock; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 122:4]
  assign auto_out_0_reset = auto_in_reset; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 122:4]
endmodule
module TLMonitor( // @[freechips.rocketchip.system.LitexConfig.fir 155:2]
  input         clock, // @[freechips.rocketchip.system.LitexConfig.fir 156:4]
  input         reset, // @[freechips.rocketchip.system.LitexConfig.fir 157:4]
  input         io_in_a_ready, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input         io_in_a_valid, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input  [2:0]  io_in_a_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input  [2:0]  io_in_a_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input  [3:0]  io_in_a_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input  [3:0]  io_in_a_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input  [31:0] io_in_a_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input  [7:0]  io_in_a_bits_mask, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input         io_in_a_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input         io_in_d_ready, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input         io_in_d_valid, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input  [2:0]  io_in_d_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input  [1:0]  io_in_d_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input  [3:0]  io_in_d_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input  [3:0]  io_in_d_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input  [1:0]  io_in_d_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input         io_in_d_bits_denied, // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
  input         io_in_d_bits_corrupt // @[freechips.rocketchip.system.LitexConfig.fir 158:4]
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [63:0] _RAND_14;
  reg [127:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [127:0] _RAND_20;
  reg [31:0] _RAND_21;
  reg [31:0] _RAND_22;
`endif // RANDOMIZE_REG_INIT
  wire [31:0] plusarg_reader_out; // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 2087:4]
  wire [31:0] plusarg_reader_1_out; // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 2394:4]
  wire  _T_7 = ~io_in_a_bits_source[3]; // @[Parameters.scala 55:32 freechips.rocketchip.system.LitexConfig.fir 172:6]
  wire  _T_21 = _T_7 | io_in_a_bits_source[3]; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 189:6]
  wire [26:0] _T_23 = 27'hfff << io_in_a_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 191:6]
  wire [11:0] _T_25 = ~_T_23[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 193:6]
  wire [31:0] _GEN_71 = {{20'd0}, _T_25}; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 194:6]
  wire [31:0] _T_26 = io_in_a_bits_address & _GEN_71; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 194:6]
  wire  _T_27 = _T_26 == 32'h0; // @[Edges.scala 22:24 freechips.rocketchip.system.LitexConfig.fir 195:6]
  wire [3:0] _T_30 = 4'h1 << io_in_a_bits_size[1:0]; // @[OneHot.scala 65:12 freechips.rocketchip.system.LitexConfig.fir 198:6]
  wire [2:0] _T_32 = _T_30[2:0] | 3'h1; // @[Misc.scala 201:81 freechips.rocketchip.system.LitexConfig.fir 200:6]
  wire  _T_33 = io_in_a_bits_size >= 4'h3; // @[Misc.scala 205:21 freechips.rocketchip.system.LitexConfig.fir 201:6]
  wire  _T_36 = ~io_in_a_bits_address[2]; // @[Misc.scala 210:20 freechips.rocketchip.system.LitexConfig.fir 204:6]
  wire  _T_38 = _T_32[2] & _T_36; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 206:6]
  wire  _T_39 = _T_33 | _T_38; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 207:6]
  wire  _T_41 = _T_32[2] & io_in_a_bits_address[2]; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 209:6]
  wire  _T_42 = _T_33 | _T_41; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 210:6]
  wire  _T_45 = ~io_in_a_bits_address[1]; // @[Misc.scala 210:20 freechips.rocketchip.system.LitexConfig.fir 213:6]
  wire  _T_46 = _T_36 & _T_45; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 214:6]
  wire  _T_47 = _T_32[1] & _T_46; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 215:6]
  wire  _T_48 = _T_39 | _T_47; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 216:6]
  wire  _T_49 = _T_36 & io_in_a_bits_address[1]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 217:6]
  wire  _T_50 = _T_32[1] & _T_49; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 218:6]
  wire  _T_51 = _T_39 | _T_50; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 219:6]
  wire  _T_52 = io_in_a_bits_address[2] & _T_45; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 220:6]
  wire  _T_53 = _T_32[1] & _T_52; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 221:6]
  wire  _T_54 = _T_42 | _T_53; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 222:6]
  wire  _T_55 = io_in_a_bits_address[2] & io_in_a_bits_address[1]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 223:6]
  wire  _T_56 = _T_32[1] & _T_55; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 224:6]
  wire  _T_57 = _T_42 | _T_56; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 225:6]
  wire  _T_60 = ~io_in_a_bits_address[0]; // @[Misc.scala 210:20 freechips.rocketchip.system.LitexConfig.fir 228:6]
  wire  _T_61 = _T_46 & _T_60; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 229:6]
  wire  _T_62 = _T_32[0] & _T_61; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 230:6]
  wire  _T_63 = _T_48 | _T_62; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 231:6]
  wire  _T_64 = _T_46 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 232:6]
  wire  _T_65 = _T_32[0] & _T_64; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 233:6]
  wire  _T_66 = _T_48 | _T_65; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 234:6]
  wire  _T_67 = _T_49 & _T_60; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 235:6]
  wire  _T_68 = _T_32[0] & _T_67; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 236:6]
  wire  _T_69 = _T_51 | _T_68; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 237:6]
  wire  _T_70 = _T_49 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 238:6]
  wire  _T_71 = _T_32[0] & _T_70; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 239:6]
  wire  _T_72 = _T_51 | _T_71; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 240:6]
  wire  _T_73 = _T_52 & _T_60; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 241:6]
  wire  _T_74 = _T_32[0] & _T_73; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 242:6]
  wire  _T_75 = _T_54 | _T_74; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 243:6]
  wire  _T_76 = _T_52 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 244:6]
  wire  _T_77 = _T_32[0] & _T_76; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 245:6]
  wire  _T_78 = _T_54 | _T_77; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 246:6]
  wire  _T_79 = _T_55 & _T_60; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 247:6]
  wire  _T_80 = _T_32[0] & _T_79; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 248:6]
  wire  _T_81 = _T_57 | _T_80; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 249:6]
  wire  _T_82 = _T_55 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 250:6]
  wire  _T_83 = _T_32[0] & _T_82; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 251:6]
  wire  _T_84 = _T_57 | _T_83; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 252:6]
  wire [7:0] _T_91 = {_T_84,_T_81,_T_78,_T_75,_T_72,_T_69,_T_66,_T_63}; // @[Cat.scala 29:58 freechips.rocketchip.system.LitexConfig.fir 259:6]
  wire [32:0] _T_102 = {1'b0,$signed(io_in_a_bits_address)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 270:6]
  wire  _T_126 = io_in_a_bits_opcode == 3'h6; // @[Monitor.scala 83:25 freechips.rocketchip.system.LitexConfig.fir 298:6]
  wire  _T_128 = io_in_a_bits_size <= 4'hc; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 301:8]
  wire  _T_147 = _T_128 & _T_21; // @[Parameters.scala 1195:30 freechips.rocketchip.system.LitexConfig.fir 320:8]
  wire  _T_157 = io_in_a_bits_size <= 4'h6; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 330:8]
  wire [31:0] _T_160 = io_in_a_bits_address ^ 32'h80000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 333:8]
  wire [32:0] _T_161 = {1'b0,$signed(_T_160)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 334:8]
  wire [32:0] _T_163 = $signed(_T_161) & 33'sh80000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 336:8]
  wire  _T_164 = $signed(_T_163) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 337:8]
  wire  _T_165 = _T_157 & _T_164; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 338:8]
  wire  _T_168 = _T_147 & _T_165; // @[Parameters.scala 1402:195 freechips.rocketchip.system.LitexConfig.fir 341:8]
  wire  _T_170 = _T_168 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 343:8]
  wire  _T_171 = ~_T_170; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 344:8]
  wire  _T_186 = ~reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 363:8]
  wire  _T_188 = _T_21 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 369:8]
  wire  _T_189 = ~_T_188; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 370:8]
  wire  _T_192 = _T_33 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 377:8]
  wire  _T_193 = ~_T_192; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 378:8]
  wire  _T_195 = _T_27 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 384:8]
  wire  _T_196 = ~_T_195; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 385:8]
  wire  _T_197 = io_in_a_bits_param <= 3'h2; // @[Bundles.scala 110:27 freechips.rocketchip.system.LitexConfig.fir 390:8]
  wire  _T_199 = _T_197 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 392:8]
  wire  _T_200 = ~_T_199; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 393:8]
  wire [7:0] _T_201 = ~io_in_a_bits_mask; // @[Monitor.scala 90:18 freechips.rocketchip.system.LitexConfig.fir 398:8]
  wire  _T_202 = _T_201 == 8'h0; // @[Monitor.scala 90:31 freechips.rocketchip.system.LitexConfig.fir 399:8]
  wire  _T_204 = _T_202 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 401:8]
  wire  _T_205 = ~_T_204; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 402:8]
  wire  _T_206 = ~io_in_a_bits_corrupt; // @[Monitor.scala 91:18 freechips.rocketchip.system.LitexConfig.fir 407:8]
  wire  _T_208 = _T_206 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 409:8]
  wire  _T_209 = ~_T_208; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 410:8]
  wire  _T_210 = io_in_a_bits_opcode == 3'h7; // @[Monitor.scala 94:25 freechips.rocketchip.system.LitexConfig.fir 416:6]
  wire  _T_285 = io_in_a_bits_param != 3'h0; // @[Monitor.scala 101:31 freechips.rocketchip.system.LitexConfig.fir 516:8]
  wire  _T_287 = _T_285 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 518:8]
  wire  _T_288 = ~_T_287; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 519:8]
  wire  _T_298 = io_in_a_bits_opcode == 3'h4; // @[Monitor.scala 106:25 freechips.rocketchip.system.LitexConfig.fir 542:6]
  wire  _T_322 = _T_147 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 567:8]
  wire  _T_323 = ~_T_322; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 568:8]
  wire [31:0] _T_328 = io_in_a_bits_address ^ 32'h2000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 577:8]
  wire [32:0] _T_329 = {1'b0,$signed(_T_328)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 578:8]
  wire [32:0] _T_331 = $signed(_T_329) & 33'shfa012000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 580:8]
  wire  _T_332 = $signed(_T_331) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 581:8]
  wire  _T_333 = _T_128 & _T_332; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 582:8]
  wire [32:0] _T_341 = $signed(_T_102) & 33'shfa012000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 590:8]
  wire  _T_342 = $signed(_T_341) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 591:8]
  wire [31:0] _T_343 = io_in_a_bits_address ^ 32'h10000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 592:8]
  wire [32:0] _T_344 = {1'b0,$signed(_T_343)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 593:8]
  wire [32:0] _T_346 = $signed(_T_344) & 33'shfa010000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 595:8]
  wire  _T_347 = $signed(_T_346) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 596:8]
  wire [31:0] _T_348 = io_in_a_bits_address ^ 32'h2000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 597:8]
  wire [32:0] _T_349 = {1'b0,$signed(_T_348)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 598:8]
  wire [32:0] _T_351 = $signed(_T_349) & 33'shfa010000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 600:8]
  wire  _T_352 = $signed(_T_351) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 601:8]
  wire [31:0] _T_353 = io_in_a_bits_address ^ 32'h8000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 602:8]
  wire [32:0] _T_354 = {1'b0,$signed(_T_353)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 603:8]
  wire [32:0] _T_356 = $signed(_T_354) & 33'shf8000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 605:8]
  wire  _T_357 = $signed(_T_356) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 606:8]
  wire [31:0] _T_358 = io_in_a_bits_address ^ 32'h10000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 607:8]
  wire [32:0] _T_359 = {1'b0,$signed(_T_358)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 608:8]
  wire [32:0] _T_361 = $signed(_T_359) & 33'shf0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 610:8]
  wire  _T_362 = $signed(_T_361) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 611:8]
  wire [31:0] _T_363 = io_in_a_bits_address ^ 32'h20000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 612:8]
  wire [32:0] _T_364 = {1'b0,$signed(_T_363)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 613:8]
  wire [32:0] _T_366 = $signed(_T_364) & 33'she0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 615:8]
  wire  _T_367 = $signed(_T_366) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 616:8]
  wire [31:0] _T_368 = io_in_a_bits_address ^ 32'h40000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 617:8]
  wire [32:0] _T_369 = {1'b0,$signed(_T_368)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 618:8]
  wire [32:0] _T_371 = $signed(_T_369) & 33'shc0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 620:8]
  wire  _T_372 = $signed(_T_371) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 621:8]
  wire  _T_378 = _T_342 | _T_347; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 627:8]
  wire  _T_379 = _T_378 | _T_352; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 628:8]
  wire  _T_380 = _T_379 | _T_357; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 629:8]
  wire  _T_381 = _T_380 | _T_362; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 630:8]
  wire  _T_382 = _T_381 | _T_367; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 631:8]
  wire  _T_383 = _T_382 | _T_372; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 632:8]
  wire  _T_384 = _T_383 | _T_164; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 633:8]
  wire  _T_385 = _T_157 & _T_384; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 634:8]
  wire  _T_387 = _T_333 | _T_385; // @[Parameters.scala 661:30 freechips.rocketchip.system.LitexConfig.fir 636:8]
  wire  _T_389 = _T_387 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 638:8]
  wire  _T_390 = ~_T_389; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 639:8]
  wire  _T_397 = io_in_a_bits_param == 3'h0; // @[Monitor.scala 111:31 freechips.rocketchip.system.LitexConfig.fir 658:8]
  wire  _T_399 = _T_397 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 660:8]
  wire  _T_400 = ~_T_399; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 661:8]
  wire  _T_401 = io_in_a_bits_mask == _T_91; // @[Monitor.scala 112:30 freechips.rocketchip.system.LitexConfig.fir 666:8]
  wire  _T_403 = _T_401 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 668:8]
  wire  _T_404 = ~_T_403; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 669:8]
  wire  _T_409 = io_in_a_bits_opcode == 3'h0; // @[Monitor.scala 116:25 freechips.rocketchip.system.LitexConfig.fir 683:6]
  wire  _T_466 = _T_342 | _T_352; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 741:8]
  wire  _T_467 = _T_466 | _T_357; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 742:8]
  wire  _T_468 = _T_467 | _T_164; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 743:8]
  wire  _T_469 = _T_157 & _T_468; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 744:8]
  wire  _T_478 = io_in_a_bits_size <= 4'h8; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 753:8]
  wire  _T_496 = _T_362 | _T_367; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 771:8]
  wire  _T_497 = _T_496 | _T_372; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 772:8]
  wire  _T_498 = _T_478 & _T_497; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 773:8]
  wire  _T_500 = _T_333 | _T_469; // @[Parameters.scala 661:30 freechips.rocketchip.system.LitexConfig.fir 775:8]
  wire  _T_502 = _T_500 | _T_498; // @[Parameters.scala 661:30 freechips.rocketchip.system.LitexConfig.fir 777:8]
  wire  _T_503 = _T_147 & _T_502; // @[Parameters.scala 1406:195 freechips.rocketchip.system.LitexConfig.fir 778:8]
  wire  _T_505 = _T_503 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 780:8]
  wire  _T_506 = ~_T_505; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 781:8]
  wire  _T_521 = io_in_a_bits_opcode == 3'h1; // @[Monitor.scala 124:25 freechips.rocketchip.system.LitexConfig.fir 817:6]
  wire [7:0] _T_629 = ~_T_91; // @[Monitor.scala 129:33 freechips.rocketchip.system.LitexConfig.fir 942:8]
  wire [7:0] _T_630 = io_in_a_bits_mask & _T_629; // @[Monitor.scala 129:31 freechips.rocketchip.system.LitexConfig.fir 943:8]
  wire  _T_631 = _T_630 == 8'h0; // @[Monitor.scala 129:40 freechips.rocketchip.system.LitexConfig.fir 944:8]
  wire  _T_633 = _T_631 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 946:8]
  wire  _T_634 = ~_T_633; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 947:8]
  wire  _T_635 = io_in_a_bits_opcode == 3'h2; // @[Monitor.scala 132:25 freechips.rocketchip.system.LitexConfig.fir 953:6]
  wire  _T_659 = io_in_a_bits_size <= 4'h3; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 978:8]
  wire [32:0] _T_665 = $signed(_T_102) & 33'shf8010000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 984:8]
  wire  _T_666 = $signed(_T_665) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 985:8]
  wire  _T_672 = _T_666 | _T_357; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 991:8]
  wire  _T_673 = _T_659 & _T_672; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 992:8]
  wire  _T_707 = _T_147 & _T_673; // @[Parameters.scala 1403:195 freechips.rocketchip.system.LitexConfig.fir 1026:8]
  wire  _T_709 = _T_707 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1028:8]
  wire  _T_710 = ~_T_709; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1029:8]
  wire  _T_717 = io_in_a_bits_param <= 3'h4; // @[Bundles.scala 140:33 freechips.rocketchip.system.LitexConfig.fir 1048:8]
  wire  _T_719 = _T_717 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1050:8]
  wire  _T_720 = ~_T_719; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1051:8]
  wire  _T_725 = io_in_a_bits_opcode == 3'h3; // @[Monitor.scala 140:25 freechips.rocketchip.system.LitexConfig.fir 1065:6]
  wire  _T_807 = io_in_a_bits_param <= 3'h3; // @[Bundles.scala 147:30 freechips.rocketchip.system.LitexConfig.fir 1160:8]
  wire  _T_809 = _T_807 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1162:8]
  wire  _T_810 = ~_T_809; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1163:8]
  wire  _T_815 = io_in_a_bits_opcode == 3'h5; // @[Monitor.scala 148:25 freechips.rocketchip.system.LitexConfig.fir 1177:6]
  wire  _T_899 = _T_147 & _T_333; // @[Parameters.scala 1408:195 freechips.rocketchip.system.LitexConfig.fir 1262:8]
  wire  _T_901 = _T_899 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1264:8]
  wire  _T_902 = ~_T_901; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1265:8]
  wire  _T_909 = io_in_a_bits_param <= 3'h1; // @[Bundles.scala 160:28 freechips.rocketchip.system.LitexConfig.fir 1284:8]
  wire  _T_911 = _T_909 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1286:8]
  wire  _T_912 = ~_T_911; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1287:8]
  wire  _T_921 = io_in_d_bits_opcode <= 3'h6; // @[Bundles.scala 44:24 freechips.rocketchip.system.LitexConfig.fir 1311:6]
  wire  _T_923 = _T_921 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1313:6]
  wire  _T_924 = ~_T_923; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1314:6]
  wire  _T_928 = ~io_in_d_bits_source[3]; // @[Parameters.scala 55:32 freechips.rocketchip.system.LitexConfig.fir 1322:6]
  wire  _T_942 = _T_928 | io_in_d_bits_source[3]; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 1339:6]
  wire  _T_944 = io_in_d_bits_opcode == 3'h6; // @[Monitor.scala 312:25 freechips.rocketchip.system.LitexConfig.fir 1341:6]
  wire  _T_946 = _T_942 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1344:8]
  wire  _T_947 = ~_T_946; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1345:8]
  wire  _T_948 = io_in_d_bits_size >= 4'h3; // @[Monitor.scala 314:27 freechips.rocketchip.system.LitexConfig.fir 1350:8]
  wire  _T_950 = _T_948 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1352:8]
  wire  _T_951 = ~_T_950; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1353:8]
  wire  _T_952 = io_in_d_bits_param == 2'h0; // @[Monitor.scala 315:28 freechips.rocketchip.system.LitexConfig.fir 1358:8]
  wire  _T_954 = _T_952 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1360:8]
  wire  _T_955 = ~_T_954; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1361:8]
  wire  _T_956 = ~io_in_d_bits_corrupt; // @[Monitor.scala 316:15 freechips.rocketchip.system.LitexConfig.fir 1366:8]
  wire  _T_958 = _T_956 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1368:8]
  wire  _T_959 = ~_T_958; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1369:8]
  wire  _T_960 = ~io_in_d_bits_denied; // @[Monitor.scala 317:15 freechips.rocketchip.system.LitexConfig.fir 1374:8]
  wire  _T_962 = _T_960 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1376:8]
  wire  _T_963 = ~_T_962; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1377:8]
  wire  _T_964 = io_in_d_bits_opcode == 3'h4; // @[Monitor.scala 320:25 freechips.rocketchip.system.LitexConfig.fir 1383:6]
  wire  _T_975 = io_in_d_bits_param <= 2'h2; // @[Bundles.scala 104:26 freechips.rocketchip.system.LitexConfig.fir 1407:8]
  wire  _T_977 = _T_975 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1409:8]
  wire  _T_978 = ~_T_977; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1410:8]
  wire  _T_979 = io_in_d_bits_param != 2'h2; // @[Monitor.scala 325:28 freechips.rocketchip.system.LitexConfig.fir 1415:8]
  wire  _T_981 = _T_979 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1417:8]
  wire  _T_982 = ~_T_981; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1418:8]
  wire  _T_992 = io_in_d_bits_opcode == 3'h5; // @[Monitor.scala 330:25 freechips.rocketchip.system.LitexConfig.fir 1441:6]
  wire  _T_1012 = _T_960 | io_in_d_bits_corrupt; // @[Monitor.scala 336:30 freechips.rocketchip.system.LitexConfig.fir 1482:8]
  wire  _T_1014 = _T_1012 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1484:8]
  wire  _T_1015 = ~_T_1014; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1485:8]
  wire  _T_1021 = io_in_d_bits_opcode == 3'h0; // @[Monitor.scala 340:25 freechips.rocketchip.system.LitexConfig.fir 1500:6]
  wire  _T_1038 = io_in_d_bits_opcode == 3'h1; // @[Monitor.scala 348:25 freechips.rocketchip.system.LitexConfig.fir 1535:6]
  wire  _T_1056 = io_in_d_bits_opcode == 3'h2; // @[Monitor.scala 356:25 freechips.rocketchip.system.LitexConfig.fir 1571:6]
  wire  _T_1088 = io_in_a_ready & io_in_a_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 1637:4]
  wire  _T_1095 = ~io_in_a_bits_opcode[2]; // @[Edges.scala 93:28 freechips.rocketchip.system.LitexConfig.fir 1644:4]
  reg [8:0] _T_1097; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 1646:4]
  wire [8:0] _T_1099 = _T_1097 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 1648:4]
  wire  _T_1100 = _T_1097 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 1649:4]
  reg [2:0] _T_1108; // @[Monitor.scala 386:22 freechips.rocketchip.system.LitexConfig.fir 1660:4]
  reg [2:0] _T_1109; // @[Monitor.scala 387:22 freechips.rocketchip.system.LitexConfig.fir 1661:4]
  reg [3:0] _T_1110; // @[Monitor.scala 388:22 freechips.rocketchip.system.LitexConfig.fir 1662:4]
  reg [3:0] _T_1111; // @[Monitor.scala 389:22 freechips.rocketchip.system.LitexConfig.fir 1663:4]
  reg [31:0] _T_1112; // @[Monitor.scala 390:22 freechips.rocketchip.system.LitexConfig.fir 1664:4]
  wire  _T_1113 = ~_T_1100; // @[Monitor.scala 391:22 freechips.rocketchip.system.LitexConfig.fir 1665:4]
  wire  _T_1114 = io_in_a_valid & _T_1113; // @[Monitor.scala 391:19 freechips.rocketchip.system.LitexConfig.fir 1666:4]
  wire  _T_1115 = io_in_a_bits_opcode == _T_1108; // @[Monitor.scala 392:32 freechips.rocketchip.system.LitexConfig.fir 1668:6]
  wire  _T_1117 = _T_1115 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1670:6]
  wire  _T_1118 = ~_T_1117; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1671:6]
  wire  _T_1119 = io_in_a_bits_param == _T_1109; // @[Monitor.scala 393:32 freechips.rocketchip.system.LitexConfig.fir 1676:6]
  wire  _T_1121 = _T_1119 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1678:6]
  wire  _T_1122 = ~_T_1121; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1679:6]
  wire  _T_1123 = io_in_a_bits_size == _T_1110; // @[Monitor.scala 394:32 freechips.rocketchip.system.LitexConfig.fir 1684:6]
  wire  _T_1125 = _T_1123 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1686:6]
  wire  _T_1126 = ~_T_1125; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1687:6]
  wire  _T_1127 = io_in_a_bits_source == _T_1111; // @[Monitor.scala 395:32 freechips.rocketchip.system.LitexConfig.fir 1692:6]
  wire  _T_1129 = _T_1127 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1694:6]
  wire  _T_1130 = ~_T_1129; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1695:6]
  wire  _T_1131 = io_in_a_bits_address == _T_1112; // @[Monitor.scala 396:32 freechips.rocketchip.system.LitexConfig.fir 1700:6]
  wire  _T_1133 = _T_1131 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1702:6]
  wire  _T_1134 = ~_T_1133; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1703:6]
  wire  _T_1136 = _T_1088 & _T_1100; // @[Monitor.scala 398:20 freechips.rocketchip.system.LitexConfig.fir 1710:4]
  wire  _T_1137 = io_in_d_ready & io_in_d_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 1718:4]
  wire [26:0] _T_1139 = 27'hfff << io_in_d_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 1720:4]
  wire [11:0] _T_1141 = ~_T_1139[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 1722:4]
  reg [8:0] _T_1145; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 1726:4]
  wire [8:0] _T_1147 = _T_1145 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 1728:4]
  wire  _T_1148 = _T_1145 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 1729:4]
  reg [2:0] _T_1156; // @[Monitor.scala 537:22 freechips.rocketchip.system.LitexConfig.fir 1740:4]
  reg [1:0] _T_1157; // @[Monitor.scala 538:22 freechips.rocketchip.system.LitexConfig.fir 1741:4]
  reg [3:0] _T_1158; // @[Monitor.scala 539:22 freechips.rocketchip.system.LitexConfig.fir 1742:4]
  reg [3:0] _T_1159; // @[Monitor.scala 540:22 freechips.rocketchip.system.LitexConfig.fir 1743:4]
  reg [1:0] _T_1160; // @[Monitor.scala 541:22 freechips.rocketchip.system.LitexConfig.fir 1744:4]
  reg  _T_1161; // @[Monitor.scala 542:22 freechips.rocketchip.system.LitexConfig.fir 1745:4]
  wire  _T_1162 = ~_T_1148; // @[Monitor.scala 543:22 freechips.rocketchip.system.LitexConfig.fir 1746:4]
  wire  _T_1163 = io_in_d_valid & _T_1162; // @[Monitor.scala 543:19 freechips.rocketchip.system.LitexConfig.fir 1747:4]
  wire  _T_1164 = io_in_d_bits_opcode == _T_1156; // @[Monitor.scala 544:29 freechips.rocketchip.system.LitexConfig.fir 1749:6]
  wire  _T_1166 = _T_1164 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1751:6]
  wire  _T_1167 = ~_T_1166; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1752:6]
  wire  _T_1168 = io_in_d_bits_param == _T_1157; // @[Monitor.scala 545:29 freechips.rocketchip.system.LitexConfig.fir 1757:6]
  wire  _T_1170 = _T_1168 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1759:6]
  wire  _T_1171 = ~_T_1170; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1760:6]
  wire  _T_1172 = io_in_d_bits_size == _T_1158; // @[Monitor.scala 546:29 freechips.rocketchip.system.LitexConfig.fir 1765:6]
  wire  _T_1174 = _T_1172 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1767:6]
  wire  _T_1175 = ~_T_1174; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1768:6]
  wire  _T_1176 = io_in_d_bits_source == _T_1159; // @[Monitor.scala 547:29 freechips.rocketchip.system.LitexConfig.fir 1773:6]
  wire  _T_1178 = _T_1176 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1775:6]
  wire  _T_1179 = ~_T_1178; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1776:6]
  wire  _T_1180 = io_in_d_bits_sink == _T_1160; // @[Monitor.scala 548:29 freechips.rocketchip.system.LitexConfig.fir 1781:6]
  wire  _T_1182 = _T_1180 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1783:6]
  wire  _T_1183 = ~_T_1182; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1784:6]
  wire  _T_1184 = io_in_d_bits_denied == _T_1161; // @[Monitor.scala 549:29 freechips.rocketchip.system.LitexConfig.fir 1789:6]
  wire  _T_1186 = _T_1184 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1791:6]
  wire  _T_1187 = ~_T_1186; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1792:6]
  wire  _T_1189 = _T_1137 & _T_1148; // @[Monitor.scala 551:20 freechips.rocketchip.system.LitexConfig.fir 1799:4]
  reg [15:0] inflight; // @[Monitor.scala 613:27 freechips.rocketchip.system.LitexConfig.fir 1808:4]
  reg [63:0] inflight_opcodes; // @[Monitor.scala 615:35 freechips.rocketchip.system.LitexConfig.fir 1809:4]
  reg [127:0] inflight_sizes; // @[Monitor.scala 617:33 freechips.rocketchip.system.LitexConfig.fir 1810:4]
  reg [8:0] _T_1199; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 1820:4]
  wire [8:0] _T_1201 = _T_1199 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 1822:4]
  wire  a_first = _T_1199 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 1823:4]
  reg [8:0] _T_1217; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 1842:4]
  wire [8:0] _T_1219 = _T_1217 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 1844:4]
  wire  d_first = _T_1217 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 1845:4]
  wire [5:0] _GEN_72 = {io_in_d_bits_source, 2'h0}; // @[Monitor.scala 636:69 freechips.rocketchip.system.LitexConfig.fir 1866:4]
  wire [6:0] _T_1227 = {{1'd0}, _GEN_72}; // @[Monitor.scala 636:69 freechips.rocketchip.system.LitexConfig.fir 1866:4]
  wire [63:0] _T_1228 = inflight_opcodes >> _T_1227; // @[Monitor.scala 636:44 freechips.rocketchip.system.LitexConfig.fir 1867:4]
  wire [15:0] _T_1232 = 16'h10 - 16'h1; // @[Monitor.scala 611:57 freechips.rocketchip.system.LitexConfig.fir 1871:4]
  wire [63:0] _GEN_73 = {{48'd0}, _T_1232}; // @[Monitor.scala 636:97 freechips.rocketchip.system.LitexConfig.fir 1872:4]
  wire [63:0] _T_1233 = _T_1228 & _GEN_73; // @[Monitor.scala 636:97 freechips.rocketchip.system.LitexConfig.fir 1872:4]
  wire [63:0] _T_1234 = {{1'd0}, _T_1233[63:1]}; // @[Monitor.scala 636:152 freechips.rocketchip.system.LitexConfig.fir 1873:4]
  wire [6:0] _T_1235 = {io_in_d_bits_source, 3'h0}; // @[Monitor.scala 640:65 freechips.rocketchip.system.LitexConfig.fir 1877:4]
  wire [127:0] _T_1236 = inflight_sizes >> _T_1235; // @[Monitor.scala 640:40 freechips.rocketchip.system.LitexConfig.fir 1878:4]
  wire [15:0] _T_1240 = 16'h100 - 16'h1; // @[Monitor.scala 611:57 freechips.rocketchip.system.LitexConfig.fir 1882:4]
  wire [127:0] _GEN_75 = {{112'd0}, _T_1240}; // @[Monitor.scala 640:91 freechips.rocketchip.system.LitexConfig.fir 1883:4]
  wire [127:0] _T_1241 = _T_1236 & _GEN_75; // @[Monitor.scala 640:91 freechips.rocketchip.system.LitexConfig.fir 1883:4]
  wire [127:0] _T_1242 = {{1'd0}, _T_1241[127:1]}; // @[Monitor.scala 640:144 freechips.rocketchip.system.LitexConfig.fir 1884:4]
  wire  _T_1245 = io_in_a_valid & a_first; // @[Monitor.scala 650:26 freechips.rocketchip.system.LitexConfig.fir 1908:4]
  wire [15:0] _T_1247 = 16'h1 << io_in_a_bits_source; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 1911:6]
  wire [15:0] a_set_wo_ready = _T_1245 ? _T_1247 : 16'h0; // @[Monitor.scala 650:71 freechips.rocketchip.system.LitexConfig.fir 1910:4]
  wire  _T_1249 = _T_1088 & a_first; // @[Monitor.scala 654:27 freechips.rocketchip.system.LitexConfig.fir 1915:4]
  wire [3:0] _T_1252 = {io_in_a_bits_opcode, 1'h0}; // @[Monitor.scala 656:53 freechips.rocketchip.system.LitexConfig.fir 1920:6]
  wire [3:0] _T_1253 = _T_1252 | 4'h1; // @[Monitor.scala 656:61 freechips.rocketchip.system.LitexConfig.fir 1921:6]
  wire [4:0] _T_1254 = {io_in_a_bits_size, 1'h0}; // @[Monitor.scala 657:51 freechips.rocketchip.system.LitexConfig.fir 1923:6]
  wire [4:0] _T_1255 = _T_1254 | 5'h1; // @[Monitor.scala 657:59 freechips.rocketchip.system.LitexConfig.fir 1924:6]
  wire [5:0] _GEN_77 = {io_in_a_bits_source, 2'h0}; // @[Monitor.scala 658:79 freechips.rocketchip.system.LitexConfig.fir 1926:6]
  wire [6:0] _T_1256 = {{1'd0}, _GEN_77}; // @[Monitor.scala 658:79 freechips.rocketchip.system.LitexConfig.fir 1926:6]
  wire [3:0] a_opcodes_set_interm = _T_1249 ? _T_1253 : 4'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 1917:4]
  wire [130:0] _GEN_78 = {{127'd0}, a_opcodes_set_interm}; // @[Monitor.scala 658:54 freechips.rocketchip.system.LitexConfig.fir 1927:6]
  wire [130:0] _T_1257 = _GEN_78 << _T_1256; // @[Monitor.scala 658:54 freechips.rocketchip.system.LitexConfig.fir 1927:6]
  wire [6:0] _T_1258 = {io_in_a_bits_source, 3'h0}; // @[Monitor.scala 659:77 freechips.rocketchip.system.LitexConfig.fir 1929:6]
  wire [4:0] a_sizes_set_interm = _T_1249 ? _T_1255 : 5'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 1917:4]
  wire [131:0] _GEN_79 = {{127'd0}, a_sizes_set_interm}; // @[Monitor.scala 659:52 freechips.rocketchip.system.LitexConfig.fir 1930:6]
  wire [131:0] _T_1259 = _GEN_79 << _T_1258; // @[Monitor.scala 659:52 freechips.rocketchip.system.LitexConfig.fir 1930:6]
  wire [15:0] _T_1260 = inflight >> io_in_a_bits_source; // @[Monitor.scala 660:26 freechips.rocketchip.system.LitexConfig.fir 1932:6]
  wire  _T_1262 = ~_T_1260[0]; // @[Monitor.scala 660:17 freechips.rocketchip.system.LitexConfig.fir 1934:6]
  wire  _T_1264 = _T_1262 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1936:6]
  wire  _T_1265 = ~_T_1264; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1937:6]
  wire [15:0] a_set = _T_1249 ? _T_1247 : 16'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 1917:4]
  wire [130:0] _GEN_19 = _T_1249 ? _T_1257 : 131'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 1917:4]
  wire [131:0] _GEN_20 = _T_1249 ? _T_1259 : 132'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 1917:4]
  wire  _T_1267 = io_in_d_valid & d_first; // @[Monitor.scala 673:26 freechips.rocketchip.system.LitexConfig.fir 1952:4]
  wire  _T_1269 = ~_T_944; // @[Monitor.scala 673:74 freechips.rocketchip.system.LitexConfig.fir 1954:4]
  wire  _T_1270 = _T_1267 & _T_1269; // @[Monitor.scala 673:71 freechips.rocketchip.system.LitexConfig.fir 1955:4]
  wire [15:0] _T_1271 = 16'h1 << io_in_d_bits_source; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 1957:6]
  wire [15:0] d_clr_wo_ready = _T_1270 ? _T_1271 : 16'h0; // @[Monitor.scala 673:90 freechips.rocketchip.system.LitexConfig.fir 1956:4]
  wire  _T_1273 = _T_1137 & d_first; // @[Monitor.scala 677:27 freechips.rocketchip.system.LitexConfig.fir 1961:4]
  wire  _T_1276 = _T_1273 & _T_1269; // @[Monitor.scala 677:72 freechips.rocketchip.system.LitexConfig.fir 1964:4]
  wire [142:0] _GEN_81 = {{127'd0}, _T_1232}; // @[Monitor.scala 679:76 freechips.rocketchip.system.LitexConfig.fir 1973:6]
  wire [142:0] _T_1283 = _GEN_81 << _T_1227; // @[Monitor.scala 679:76 freechips.rocketchip.system.LitexConfig.fir 1973:6]
  wire [142:0] _GEN_82 = {{127'd0}, _T_1240}; // @[Monitor.scala 680:74 freechips.rocketchip.system.LitexConfig.fir 1980:6]
  wire [142:0] _T_1289 = _GEN_82 << _T_1235; // @[Monitor.scala 680:74 freechips.rocketchip.system.LitexConfig.fir 1980:6]
  wire [15:0] d_clr = _T_1276 ? _T_1271 : 16'h0; // @[Monitor.scala 677:91 freechips.rocketchip.system.LitexConfig.fir 1965:4]
  wire [142:0] _GEN_23 = _T_1276 ? _T_1283 : 143'h0; // @[Monitor.scala 677:91 freechips.rocketchip.system.LitexConfig.fir 1965:4]
  wire [142:0] _GEN_24 = _T_1276 ? _T_1289 : 143'h0; // @[Monitor.scala 677:91 freechips.rocketchip.system.LitexConfig.fir 1965:4]
  wire  _T_1296 = io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 683:113 freechips.rocketchip.system.LitexConfig.fir 1990:6]
  wire  _T_1297 = _T_1245 & _T_1296; // @[Monitor.scala 683:88 freechips.rocketchip.system.LitexConfig.fir 1991:6]
  wire [15:0] _T_1298 = inflight >> io_in_d_bits_source; // @[Monitor.scala 684:25 freechips.rocketchip.system.LitexConfig.fir 1992:6]
  wire  _T_1300 = _T_1298[0] | _T_1297; // @[Monitor.scala 684:49 freechips.rocketchip.system.LitexConfig.fir 1994:6]
  wire  _T_1302 = _T_1300 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1996:6]
  wire  _T_1303 = ~_T_1302; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1997:6]
  wire [2:0] _GEN_27 = 3'h2 == io_in_a_bits_opcode ? 3'h1 : 3'h0; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 2003:8]
  wire [2:0] _GEN_28 = 3'h3 == io_in_a_bits_opcode ? 3'h1 : _GEN_27; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 2003:8]
  wire [2:0] _GEN_29 = 3'h4 == io_in_a_bits_opcode ? 3'h1 : _GEN_28; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 2003:8]
  wire [2:0] _GEN_30 = 3'h5 == io_in_a_bits_opcode ? 3'h2 : _GEN_29; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 2003:8]
  wire [2:0] _GEN_31 = 3'h6 == io_in_a_bits_opcode ? 3'h4 : _GEN_30; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 2003:8]
  wire [2:0] _GEN_32 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_31; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 2003:8]
  wire  _T_1304 = io_in_d_bits_opcode == _GEN_32; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 2003:8]
  wire [2:0] _GEN_39 = 3'h6 == io_in_a_bits_opcode ? 3'h5 : _GEN_30; // @[Monitor.scala 688:39 freechips.rocketchip.system.LitexConfig.fir 2004:8]
  wire [2:0] _GEN_40 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_39; // @[Monitor.scala 688:39 freechips.rocketchip.system.LitexConfig.fir 2004:8]
  wire  _T_1305 = io_in_d_bits_opcode == _GEN_40; // @[Monitor.scala 688:39 freechips.rocketchip.system.LitexConfig.fir 2004:8]
  wire  _T_1306 = _T_1304 | _T_1305; // @[Monitor.scala 687:77 freechips.rocketchip.system.LitexConfig.fir 2005:8]
  wire  _T_1308 = _T_1306 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2007:8]
  wire  _T_1309 = ~_T_1308; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2008:8]
  wire  _T_1310 = io_in_a_bits_size == io_in_d_bits_size; // @[Monitor.scala 689:36 freechips.rocketchip.system.LitexConfig.fir 2013:8]
  wire  _T_1312 = _T_1310 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2015:8]
  wire  _T_1313 = ~_T_1312; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2016:8]
  wire [3:0] a_opcode_lookup = _T_1234[3:0]; // @[freechips.rocketchip.system.LitexConfig.fir 1864:4 freechips.rocketchip.system.LitexConfig.fir 1865:4 Monitor.scala 636:21 freechips.rocketchip.system.LitexConfig.fir 1874:4]
  wire [2:0] _GEN_43 = 3'h2 == a_opcode_lookup[2:0] ? 3'h1 : 3'h0; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 2024:8]
  wire [2:0] _GEN_44 = 3'h3 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_43; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 2024:8]
  wire [2:0] _GEN_45 = 3'h4 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_44; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 2024:8]
  wire [2:0] _GEN_46 = 3'h5 == a_opcode_lookup[2:0] ? 3'h2 : _GEN_45; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 2024:8]
  wire [2:0] _GEN_47 = 3'h6 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_46; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 2024:8]
  wire [2:0] _GEN_48 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_47; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 2024:8]
  wire  _T_1315 = io_in_d_bits_opcode == _GEN_48; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 2024:8]
  wire [2:0] _GEN_55 = 3'h6 == a_opcode_lookup[2:0] ? 3'h5 : _GEN_46; // @[Monitor.scala 692:38 freechips.rocketchip.system.LitexConfig.fir 2026:8]
  wire [2:0] _GEN_56 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_55; // @[Monitor.scala 692:38 freechips.rocketchip.system.LitexConfig.fir 2026:8]
  wire  _T_1317 = io_in_d_bits_opcode == _GEN_56; // @[Monitor.scala 692:38 freechips.rocketchip.system.LitexConfig.fir 2026:8]
  wire  _T_1318 = _T_1315 | _T_1317; // @[Monitor.scala 691:72 freechips.rocketchip.system.LitexConfig.fir 2027:8]
  wire  _T_1320 = _T_1318 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2029:8]
  wire  _T_1321 = ~_T_1320; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2030:8]
  wire [7:0] a_size_lookup = _T_1242[7:0]; // @[freechips.rocketchip.system.LitexConfig.fir 1875:4 freechips.rocketchip.system.LitexConfig.fir 1876:4 Monitor.scala 640:19 freechips.rocketchip.system.LitexConfig.fir 1885:4]
  wire [7:0] _GEN_83 = {{4'd0}, io_in_d_bits_size}; // @[Monitor.scala 693:36 freechips.rocketchip.system.LitexConfig.fir 2035:8]
  wire  _T_1322 = _GEN_83 == a_size_lookup; // @[Monitor.scala 693:36 freechips.rocketchip.system.LitexConfig.fir 2035:8]
  wire  _T_1324 = _T_1322 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2037:8]
  wire  _T_1325 = ~_T_1324; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2038:8]
  wire  _T_1327 = _T_1267 & a_first; // @[Monitor.scala 696:36 freechips.rocketchip.system.LitexConfig.fir 2046:4]
  wire  _T_1328 = _T_1327 & io_in_a_valid; // @[Monitor.scala 696:47 freechips.rocketchip.system.LitexConfig.fir 2047:4]
  wire  _T_1330 = _T_1328 & _T_1296; // @[Monitor.scala 696:65 freechips.rocketchip.system.LitexConfig.fir 2049:4]
  wire  _T_1332 = _T_1330 & _T_1269; // @[Monitor.scala 696:116 freechips.rocketchip.system.LitexConfig.fir 2051:4]
  wire  _T_1333 = ~io_in_d_ready; // @[Monitor.scala 697:15 freechips.rocketchip.system.LitexConfig.fir 2053:6]
  wire  _T_1334 = _T_1333 | io_in_a_ready; // @[Monitor.scala 697:32 freechips.rocketchip.system.LitexConfig.fir 2054:6]
  wire  _T_1336 = _T_1334 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2056:6]
  wire  _T_1337 = ~_T_1336; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2057:6]
  wire  _T_1338 = a_set_wo_ready != d_clr_wo_ready; // @[Monitor.scala 701:29 freechips.rocketchip.system.LitexConfig.fir 2063:4]
  wire  _T_1339 = |a_set_wo_ready; // @[Monitor.scala 701:67 freechips.rocketchip.system.LitexConfig.fir 2064:4]
  wire  _T_1340 = ~_T_1339; // @[Monitor.scala 701:51 freechips.rocketchip.system.LitexConfig.fir 2065:4]
  wire  _T_1341 = _T_1338 | _T_1340; // @[Monitor.scala 701:48 freechips.rocketchip.system.LitexConfig.fir 2066:4]
  wire  _T_1343 = _T_1341 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2068:4]
  wire  _T_1344 = ~_T_1343; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2069:4]
  wire [15:0] _T_1345 = inflight | a_set; // @[Monitor.scala 704:27 freechips.rocketchip.system.LitexConfig.fir 2074:4]
  wire [15:0] _T_1346 = ~d_clr; // @[Monitor.scala 704:38 freechips.rocketchip.system.LitexConfig.fir 2075:4]
  wire [15:0] _T_1347 = _T_1345 & _T_1346; // @[Monitor.scala 704:36 freechips.rocketchip.system.LitexConfig.fir 2076:4]
  wire [63:0] a_opcodes_set = _GEN_19[63:0]; // @[freechips.rocketchip.system.LitexConfig.fir 1860:4 freechips.rocketchip.system.LitexConfig.fir 1861:4 Monitor.scala 658:28 freechips.rocketchip.system.LitexConfig.fir 1928:6]
  wire [63:0] _T_1348 = inflight_opcodes | a_opcodes_set; // @[Monitor.scala 705:43 freechips.rocketchip.system.LitexConfig.fir 2078:4]
  wire [63:0] d_opcodes_clr = _GEN_23[63:0]; // @[freechips.rocketchip.system.LitexConfig.fir 1947:4 freechips.rocketchip.system.LitexConfig.fir 1948:4 Monitor.scala 679:21 freechips.rocketchip.system.LitexConfig.fir 1974:6]
  wire [63:0] _T_1349 = ~d_opcodes_clr; // @[Monitor.scala 705:62 freechips.rocketchip.system.LitexConfig.fir 2079:4]
  wire [63:0] _T_1350 = _T_1348 & _T_1349; // @[Monitor.scala 705:60 freechips.rocketchip.system.LitexConfig.fir 2080:4]
  wire [127:0] a_sizes_set = _GEN_20[127:0]; // @[freechips.rocketchip.system.LitexConfig.fir 1862:4 freechips.rocketchip.system.LitexConfig.fir 1863:4 Monitor.scala 659:28 freechips.rocketchip.system.LitexConfig.fir 1931:6]
  wire [127:0] _T_1351 = inflight_sizes | a_sizes_set; // @[Monitor.scala 706:39 freechips.rocketchip.system.LitexConfig.fir 2082:4]
  wire [127:0] d_sizes_clr = _GEN_24[127:0]; // @[freechips.rocketchip.system.LitexConfig.fir 1949:4 freechips.rocketchip.system.LitexConfig.fir 1950:4 Monitor.scala 680:21 freechips.rocketchip.system.LitexConfig.fir 1981:6]
  wire [127:0] _T_1352 = ~d_sizes_clr; // @[Monitor.scala 706:56 freechips.rocketchip.system.LitexConfig.fir 2083:4]
  wire [127:0] _T_1353 = _T_1351 & _T_1352; // @[Monitor.scala 706:54 freechips.rocketchip.system.LitexConfig.fir 2084:4]
  reg [31:0] _T_1354; // @[Monitor.scala 708:27 freechips.rocketchip.system.LitexConfig.fir 2086:4]
  wire  _T_1355 = |inflight; // @[Monitor.scala 711:26 freechips.rocketchip.system.LitexConfig.fir 2089:4]
  wire  _T_1356 = ~_T_1355; // @[Monitor.scala 711:16 freechips.rocketchip.system.LitexConfig.fir 2090:4]
  wire  _T_1357 = plusarg_reader_out == 32'h0; // @[Monitor.scala 711:39 freechips.rocketchip.system.LitexConfig.fir 2091:4]
  wire  _T_1358 = _T_1356 | _T_1357; // @[Monitor.scala 711:30 freechips.rocketchip.system.LitexConfig.fir 2092:4]
  wire  _T_1359 = _T_1354 < plusarg_reader_out; // @[Monitor.scala 711:59 freechips.rocketchip.system.LitexConfig.fir 2093:4]
  wire  _T_1360 = _T_1358 | _T_1359; // @[Monitor.scala 711:47 freechips.rocketchip.system.LitexConfig.fir 2094:4]
  wire  _T_1362 = _T_1360 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2096:4]
  wire  _T_1363 = ~_T_1362; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2097:4]
  wire [31:0] _T_1365 = _T_1354 + 32'h1; // @[Monitor.scala 713:26 freechips.rocketchip.system.LitexConfig.fir 2103:4]
  wire  _T_1368 = _T_1088 | _T_1137; // @[Monitor.scala 714:27 freechips.rocketchip.system.LitexConfig.fir 2107:4]
  reg [15:0] inflight_1; // @[Monitor.scala 725:35 freechips.rocketchip.system.LitexConfig.fir 2111:4]
  reg [127:0] inflight_sizes_1; // @[Monitor.scala 727:35 freechips.rocketchip.system.LitexConfig.fir 2113:4]
  reg [8:0] _T_1397; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 2148:4]
  wire [8:0] _T_1399 = _T_1397 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 2150:4]
  wire  d_first_1 = _T_1397 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 2151:4]
  wire [127:0] _T_1416 = inflight_sizes_1 >> _T_1235; // @[Monitor.scala 749:42 freechips.rocketchip.system.LitexConfig.fir 2184:4]
  wire [127:0] _T_1421 = _T_1416 & _GEN_75; // @[Monitor.scala 749:93 freechips.rocketchip.system.LitexConfig.fir 2189:4]
  wire [127:0] _T_1422 = {{1'd0}, _T_1421[127:1]}; // @[Monitor.scala 749:146 freechips.rocketchip.system.LitexConfig.fir 2190:4]
  wire  _T_1462 = io_in_d_valid & d_first_1; // @[Monitor.scala 781:26 freechips.rocketchip.system.LitexConfig.fir 2268:4]
  wire  _T_1464 = _T_1462 & _T_944; // @[Monitor.scala 781:71 freechips.rocketchip.system.LitexConfig.fir 2270:4]
  wire  _T_1467 = _T_1137 & d_first_1; // @[Monitor.scala 785:27 freechips.rocketchip.system.LitexConfig.fir 2276:4]
  wire  _T_1469 = _T_1467 & _T_944; // @[Monitor.scala 785:72 freechips.rocketchip.system.LitexConfig.fir 2278:4]
  wire [15:0] d_clr_1 = _T_1469 ? _T_1271 : 16'h0; // @[Monitor.scala 785:90 freechips.rocketchip.system.LitexConfig.fir 2279:4]
  wire [142:0] _GEN_69 = _T_1469 ? _T_1289 : 143'h0; // @[Monitor.scala 785:90 freechips.rocketchip.system.LitexConfig.fir 2279:4]
  wire [15:0] _T_1496 = inflight_1 >> io_in_d_bits_source; // @[Monitor.scala 793:25 freechips.rocketchip.system.LitexConfig.fir 2314:6]
  wire  _T_1500 = _T_1496[0] | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2318:6]
  wire  _T_1501 = ~_T_1500; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2319:6]
  wire [7:0] c_size_lookup = _T_1422[7:0]; // @[freechips.rocketchip.system.LitexConfig.fir 2172:4 freechips.rocketchip.system.LitexConfig.fir 2173:4 Monitor.scala 749:21 freechips.rocketchip.system.LitexConfig.fir 2191:4]
  wire  _T_1507 = _GEN_83 == c_size_lookup; // @[Monitor.scala 797:36 freechips.rocketchip.system.LitexConfig.fir 2337:8]
  wire  _T_1509 = _T_1507 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2339:8]
  wire  _T_1510 = ~_T_1509; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2340:8]
  wire [15:0] _T_1531 = ~d_clr_1; // @[Monitor.scala 811:46 freechips.rocketchip.system.LitexConfig.fir 2382:4]
  wire [15:0] _T_1532 = inflight_1 & _T_1531; // @[Monitor.scala 811:44 freechips.rocketchip.system.LitexConfig.fir 2383:4]
  wire [127:0] d_sizes_clr_1 = _GEN_69[127:0]; // @[freechips.rocketchip.system.LitexConfig.fir 2265:4 freechips.rocketchip.system.LitexConfig.fir 2266:4 Monitor.scala 788:21 freechips.rocketchip.system.LitexConfig.fir 2295:6]
  wire [127:0] _T_1537 = ~d_sizes_clr_1; // @[Monitor.scala 813:58 freechips.rocketchip.system.LitexConfig.fir 2390:4]
  wire [127:0] _T_1538 = inflight_sizes_1 & _T_1537; // @[Monitor.scala 813:56 freechips.rocketchip.system.LitexConfig.fir 2391:4]
  reg [31:0] _T_1539; // @[Monitor.scala 815:27 freechips.rocketchip.system.LitexConfig.fir 2393:4]
  wire  _T_1540 = |inflight_1; // @[Monitor.scala 818:26 freechips.rocketchip.system.LitexConfig.fir 2396:4]
  wire  _T_1541 = ~_T_1540; // @[Monitor.scala 818:16 freechips.rocketchip.system.LitexConfig.fir 2397:4]
  wire  _T_1542 = plusarg_reader_1_out == 32'h0; // @[Monitor.scala 818:39 freechips.rocketchip.system.LitexConfig.fir 2398:4]
  wire  _T_1543 = _T_1541 | _T_1542; // @[Monitor.scala 818:30 freechips.rocketchip.system.LitexConfig.fir 2399:4]
  wire  _T_1544 = _T_1539 < plusarg_reader_1_out; // @[Monitor.scala 818:59 freechips.rocketchip.system.LitexConfig.fir 2400:4]
  wire  _T_1545 = _T_1543 | _T_1544; // @[Monitor.scala 818:47 freechips.rocketchip.system.LitexConfig.fir 2401:4]
  wire  _T_1547 = _T_1545 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2403:4]
  wire  _T_1548 = ~_T_1547; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2404:4]
  wire [31:0] _T_1550 = _T_1539 + 32'h1; // @[Monitor.scala 820:26 freechips.rocketchip.system.LitexConfig.fir 2410:4]
  wire  _GEN_93 = io_in_a_valid & _T_126; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 346:10]
  wire  _GEN_109 = io_in_a_valid & _T_210; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 464:10]
  wire  _GEN_127 = io_in_a_valid & _T_298; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 570:10]
  wire  _GEN_141 = io_in_a_valid & _T_409; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 783:10]
  wire  _GEN_151 = io_in_a_valid & _T_521; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 917:10]
  wire  _GEN_161 = io_in_a_valid & _T_635; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1031:10]
  wire  _GEN_171 = io_in_a_valid & _T_725; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1143:10]
  wire  _GEN_181 = io_in_a_valid & _T_815; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1267:10]
  wire  _GEN_193 = io_in_d_valid & _T_944; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1347:10]
  wire  _GEN_203 = io_in_d_valid & _T_964; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1389:10]
  wire  _GEN_213 = io_in_d_valid & _T_992; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1447:10]
  wire  _GEN_223 = io_in_d_valid & _T_1021; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1506:10]
  wire  _GEN_229 = io_in_d_valid & _T_1038; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1541:10]
  wire  _GEN_235 = io_in_d_valid & _T_1056; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1577:10]
  wire  _GEN_241 = _T_1270 & _T_1297; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2010:10]
  wire  _GEN_245 = ~_T_1297; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2032:10]
  wire  _GEN_246 = _T_1270 & _GEN_245; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2032:10]
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader ( // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 2087:4]
    .out(plusarg_reader_out)
  );
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader_1 ( // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 2394:4]
    .out(plusarg_reader_1_out)
  );
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  _T_1097 = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  _T_1108 = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  _T_1109 = _RAND_2[2:0];
  _RAND_3 = {1{`RANDOM}};
  _T_1110 = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  _T_1111 = _RAND_4[3:0];
  _RAND_5 = {1{`RANDOM}};
  _T_1112 = _RAND_5[31:0];
  _RAND_6 = {1{`RANDOM}};
  _T_1145 = _RAND_6[8:0];
  _RAND_7 = {1{`RANDOM}};
  _T_1156 = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  _T_1157 = _RAND_8[1:0];
  _RAND_9 = {1{`RANDOM}};
  _T_1158 = _RAND_9[3:0];
  _RAND_10 = {1{`RANDOM}};
  _T_1159 = _RAND_10[3:0];
  _RAND_11 = {1{`RANDOM}};
  _T_1160 = _RAND_11[1:0];
  _RAND_12 = {1{`RANDOM}};
  _T_1161 = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  inflight = _RAND_13[15:0];
  _RAND_14 = {2{`RANDOM}};
  inflight_opcodes = _RAND_14[63:0];
  _RAND_15 = {4{`RANDOM}};
  inflight_sizes = _RAND_15[127:0];
  _RAND_16 = {1{`RANDOM}};
  _T_1199 = _RAND_16[8:0];
  _RAND_17 = {1{`RANDOM}};
  _T_1217 = _RAND_17[8:0];
  _RAND_18 = {1{`RANDOM}};
  _T_1354 = _RAND_18[31:0];
  _RAND_19 = {1{`RANDOM}};
  inflight_1 = _RAND_19[15:0];
  _RAND_20 = {4{`RANDOM}};
  inflight_sizes_1 = _RAND_20[127:0];
  _RAND_21 = {1{`RANDOM}};
  _T_1397 = _RAND_21[8:0];
  _RAND_22 = {1{`RANDOM}};
  _T_1539 = _RAND_22[31:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
  always @(posedge clock) begin
    if (reset) begin
      _T_1097 <= 9'h0;
    end else if (_T_1088) begin
      if (_T_1100) begin
        if (_T_1095) begin
          _T_1097 <= _T_25[11:3];
        end else begin
          _T_1097 <= 9'h0;
        end
      end else begin
        _T_1097 <= _T_1099;
      end
    end
    if (_T_1136) begin
      _T_1108 <= io_in_a_bits_opcode;
    end
    if (_T_1136) begin
      _T_1109 <= io_in_a_bits_param;
    end
    if (_T_1136) begin
      _T_1110 <= io_in_a_bits_size;
    end
    if (_T_1136) begin
      _T_1111 <= io_in_a_bits_source;
    end
    if (_T_1136) begin
      _T_1112 <= io_in_a_bits_address;
    end
    if (reset) begin
      _T_1145 <= 9'h0;
    end else if (_T_1137) begin
      if (_T_1148) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_1145 <= _T_1141[11:3];
        end else begin
          _T_1145 <= 9'h0;
        end
      end else begin
        _T_1145 <= _T_1147;
      end
    end
    if (_T_1189) begin
      _T_1156 <= io_in_d_bits_opcode;
    end
    if (_T_1189) begin
      _T_1157 <= io_in_d_bits_param;
    end
    if (_T_1189) begin
      _T_1158 <= io_in_d_bits_size;
    end
    if (_T_1189) begin
      _T_1159 <= io_in_d_bits_source;
    end
    if (_T_1189) begin
      _T_1160 <= io_in_d_bits_sink;
    end
    if (_T_1189) begin
      _T_1161 <= io_in_d_bits_denied;
    end
    if (reset) begin
      inflight <= 16'h0;
    end else begin
      inflight <= _T_1347;
    end
    if (reset) begin
      inflight_opcodes <= 64'h0;
    end else begin
      inflight_opcodes <= _T_1350;
    end
    if (reset) begin
      inflight_sizes <= 128'h0;
    end else begin
      inflight_sizes <= _T_1353;
    end
    if (reset) begin
      _T_1199 <= 9'h0;
    end else if (_T_1088) begin
      if (a_first) begin
        if (_T_1095) begin
          _T_1199 <= _T_25[11:3];
        end else begin
          _T_1199 <= 9'h0;
        end
      end else begin
        _T_1199 <= _T_1201;
      end
    end
    if (reset) begin
      _T_1217 <= 9'h0;
    end else if (_T_1137) begin
      if (d_first) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_1217 <= _T_1141[11:3];
        end else begin
          _T_1217 <= 9'h0;
        end
      end else begin
        _T_1217 <= _T_1219;
      end
    end
    if (reset) begin
      _T_1354 <= 32'h0;
    end else if (_T_1368) begin
      _T_1354 <= 32'h0;
    end else begin
      _T_1354 <= _T_1365;
    end
    if (reset) begin
      inflight_1 <= 16'h0;
    end else begin
      inflight_1 <= _T_1532;
    end
    if (reset) begin
      inflight_sizes_1 <= 128'h0;
    end else begin
      inflight_sizes_1 <= _T_1538;
    end
    if (reset) begin
      _T_1397 <= 9'h0;
    end else if (_T_1137) begin
      if (d_first_1) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_1397 <= _T_1141[11:3];
        end else begin
          _T_1397 <= 9'h0;
        end
      end else begin
        _T_1397 <= _T_1399;
      end
    end
    if (reset) begin
      _T_1539 <= 32'h0;
    end else if (_T_1137) begin
      _T_1539 <= 32'h0;
    end else begin
      _T_1539 <= _T_1550;
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquireBlock type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 346:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 347:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_186) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquireBlock from a client which does not support Probe (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 365:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_186) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 366:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 372:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 373:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_193) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock smaller than a beat (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 380:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_193) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 381:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 387:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 388:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_200) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock carries invalid grow param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 395:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_200) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 396:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_205) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 404:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_205) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 405:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_209) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 412:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_209) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 413:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquirePerm type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 464:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 465:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_186) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquirePerm from a client which does not support Probe (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 483:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_186) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 484:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 490:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 491:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_193) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm smaller than a beat (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 498:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_193) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 499:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 505:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 506:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_200) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm carries invalid grow param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 513:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_200) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 514:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_288) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm requests NtoB (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 521:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_288) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 522:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_205) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 530:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_205) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 531:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_209) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 538:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_209) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 539:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_323) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Get type which master claims it can't emit (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 570:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_323) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 571:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_390) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Get type which slave claims it can't support (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 641:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_390) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 642:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 648:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 649:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 655:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 656:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_400) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 663:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_400) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 664:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_404) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 671:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_404) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 672:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_209) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 679:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_209) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 680:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_141 & _T_506) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries PutFull type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 783:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_141 & _T_506) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 784:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_141 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 790:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_141 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 791:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_141 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 797:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_141 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 798:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_141 & _T_400) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 805:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_141 & _T_400) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 806:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_141 & _T_404) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 813:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_141 & _T_404) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 814:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_151 & _T_506) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries PutPartial type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 917:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_151 & _T_506) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 918:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_151 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 924:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_151 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 925:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_151 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 931:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_151 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 932:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_151 & _T_400) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 939:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_151 & _T_400) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 940:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_151 & _T_634) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 949:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_151 & _T_634) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 950:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_161 & _T_710) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Arithmetic type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1031:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_161 & _T_710) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1032:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_161 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1038:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_161 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1039:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_161 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1045:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_161 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1046:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_161 & _T_720) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic carries invalid opcode param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1053:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_161 & _T_720) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1054:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_161 & _T_404) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1061:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_161 & _T_404) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1062:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_171 & _T_710) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Logical type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1143:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_171 & _T_710) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1144:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_171 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1150:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_171 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1151:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_171 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1157:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_171 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1158:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_171 & _T_810) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical carries invalid opcode param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1165:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_171 & _T_810) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1166:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_171 & _T_404) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1173:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_171 & _T_404) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1174:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_181 & _T_902) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Hint type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1267:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_181 & _T_902) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1268:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_181 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1274:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_181 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1275:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_181 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1281:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_181 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1282:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_181 & _T_912) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint carries invalid opcode param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1289:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_181 & _T_912) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1290:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_181 & _T_404) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1297:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_181 & _T_404) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1298:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_181 & _T_209) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1305:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_181 & _T_209) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1306:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_924) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel has invalid opcode (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1316:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_924) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1317:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_193 & _T_947) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1347:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_193 & _T_947) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1348:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_193 & _T_951) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck smaller than a beat (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1355:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_193 & _T_951) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1356:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_193 & _T_955) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseeAck carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1363:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_193 & _T_955) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1364:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_193 & _T_959) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1371:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_193 & _T_959) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1372:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_193 & _T_963) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck is denied (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1379:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_193 & _T_963) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1380:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_203 & _T_947) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1389:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_203 & _T_947) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1390:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_203 & _T_951) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant smaller than a beat (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1404:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_203 & _T_951) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1405:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_203 & _T_978) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant carries invalid cap param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1412:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_203 & _T_978) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1413:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_203 & _T_982) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant carries toN param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1420:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_203 & _T_982) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1421:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_203 & _T_959) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1428:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_203 & _T_959) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1429:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_213 & _T_947) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1447:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_213 & _T_947) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1448:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_213 & _T_951) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData smaller than a beat (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1462:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_213 & _T_951) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1463:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_213 & _T_978) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData carries invalid cap param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1470:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_213 & _T_978) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1471:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_213 & _T_982) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData carries toN param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1478:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_213 & _T_982) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1479:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_213 & _T_1015) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData is denied but not corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1487:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_213 & _T_1015) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1488:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_223 & _T_947) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAck carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1506:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_223 & _T_947) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1507:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_223 & _T_955) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAck carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1514:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_223 & _T_955) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1515:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_223 & _T_959) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAck is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1522:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_223 & _T_959) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1523:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_229 & _T_947) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1541:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_229 & _T_947) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1542:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_229 & _T_955) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAckData carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1549:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_229 & _T_955) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1550:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_229 & _T_1015) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAckData is denied but not corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1558:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_229 & _T_1015) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1559:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_235 & _T_947) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel HintAck carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1577:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_235 & _T_947) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1578:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_235 & _T_955) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel HintAck carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1585:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_235 & _T_955) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1586:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_235 & _T_959) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel HintAck is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1593:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_235 & _T_959) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1594:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1114 & _T_1118) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel opcode changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1673:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1114 & _T_1118) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1674:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1114 & _T_1122) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel param changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1681:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1114 & _T_1122) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1682:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1114 & _T_1126) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel size changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1689:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1114 & _T_1126) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1690:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1114 & _T_1130) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel source changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1697:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1114 & _T_1130) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1698:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1114 & _T_1134) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel address changed with multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1705:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1114 & _T_1134) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1706:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1163 & _T_1167) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel opcode changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1754:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1163 & _T_1167) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1755:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1163 & _T_1171) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel param changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1762:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1163 & _T_1171) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1763:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1163 & _T_1175) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel size changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1770:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1163 & _T_1175) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1771:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1163 & _T_1179) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel source changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1778:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1163 & _T_1179) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1779:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1163 & _T_1183) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel sink changed with multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1786:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1163 & _T_1183) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1787:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1163 & _T_1187) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel denied changed with multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1794:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1163 & _T_1187) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1795:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1249 & _T_1265) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel re-used a source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1939:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1249 & _T_1265) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 1940:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1270 & _T_1303) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 1999:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1270 & _T_1303) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2000:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_241 & _T_1309) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2010:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_241 & _T_1309) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2011:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_241 & _T_1313) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2018:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_241 & _T_1313) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2019:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_246 & _T_1321) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2032:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_246 & _T_1321) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2033:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_246 & _T_1325) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2040:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_246 & _T_1325) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2041:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1332 & _T_1337) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2059:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1332 & _T_1337) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2060:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1344) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2071:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1344) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2072:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1363) begin
          $fwrite(32'h80000002,"Assertion failed: TileLink timeout expired (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2099:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1363) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2100:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1464 & _T_1501) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2321:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1464 & _T_1501) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2322:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1464 & _T_1510) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2342:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1464 & _T_1510) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 2343:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1548) begin
          $fwrite(32'h80000002,"Assertion failed: TileLink timeout expired (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2406:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1548) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2407:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
endmodule
module TLMonitor_1( // @[freechips.rocketchip.system.LitexConfig.fir 2437:2]
  input         clock, // @[freechips.rocketchip.system.LitexConfig.fir 2438:4]
  input         reset, // @[freechips.rocketchip.system.LitexConfig.fir 2439:4]
  input         io_in_a_ready, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input         io_in_a_valid, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [2:0]  io_in_a_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [2:0]  io_in_a_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [3:0]  io_in_a_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [1:0]  io_in_a_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [31:0] io_in_a_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [7:0]  io_in_a_bits_mask, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input         io_in_a_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input         io_in_b_ready, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input         io_in_b_valid, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [1:0]  io_in_b_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [31:0] io_in_b_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input         io_in_c_ready, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input         io_in_c_valid, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [2:0]  io_in_c_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [2:0]  io_in_c_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [3:0]  io_in_c_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [1:0]  io_in_c_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [31:0] io_in_c_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input         io_in_c_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input         io_in_d_ready, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input         io_in_d_valid, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [2:0]  io_in_d_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [1:0]  io_in_d_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [3:0]  io_in_d_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [1:0]  io_in_d_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [1:0]  io_in_d_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input         io_in_d_bits_denied, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input         io_in_d_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input         io_in_e_valid, // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
  input  [1:0]  io_in_e_bits_sink // @[freechips.rocketchip.system.LitexConfig.fir 2440:4]
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [31:0] _RAND_14;
  reg [31:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [31:0] _RAND_20;
  reg [31:0] _RAND_21;
  reg [31:0] _RAND_22;
  reg [31:0] _RAND_23;
  reg [31:0] _RAND_24;
  reg [31:0] _RAND_25;
  reg [31:0] _RAND_26;
  reg [31:0] _RAND_27;
  reg [31:0] _RAND_28;
  reg [31:0] _RAND_29;
  reg [31:0] _RAND_30;
  reg [31:0] _RAND_31;
  reg [31:0] _RAND_32;
  reg [31:0] _RAND_33;
  reg [31:0] _RAND_34;
`endif // RANDOMIZE_REG_INIT
  wire [31:0] plusarg_reader_out; // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 5596:4]
  wire [31:0] plusarg_reader_1_out; // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 5863:4]
  wire  _T_4 = io_in_a_bits_source == 2'h0; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 2451:6]
  wire  _T_5 = io_in_a_bits_source == 2'h1; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 2452:6]
  wire  _T_6 = io_in_a_bits_source == 2'h2; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 2453:6]
  wire  _T_8 = _T_4 | _T_5; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 2459:6]
  wire  _T_9 = _T_8 | _T_6; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 2460:6]
  wire [26:0] _T_11 = 27'hfff << io_in_a_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 2462:6]
  wire [11:0] _T_13 = ~_T_11[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 2464:6]
  wire [31:0] _GEN_86 = {{20'd0}, _T_13}; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 2465:6]
  wire [31:0] _T_14 = io_in_a_bits_address & _GEN_86; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 2465:6]
  wire  _T_15 = _T_14 == 32'h0; // @[Edges.scala 22:24 freechips.rocketchip.system.LitexConfig.fir 2466:6]
  wire [3:0] _T_18 = 4'h1 << io_in_a_bits_size[1:0]; // @[OneHot.scala 65:12 freechips.rocketchip.system.LitexConfig.fir 2469:6]
  wire [2:0] _T_20 = _T_18[2:0] | 3'h1; // @[Misc.scala 201:81 freechips.rocketchip.system.LitexConfig.fir 2471:6]
  wire  _T_21 = io_in_a_bits_size >= 4'h3; // @[Misc.scala 205:21 freechips.rocketchip.system.LitexConfig.fir 2472:6]
  wire  _T_24 = ~io_in_a_bits_address[2]; // @[Misc.scala 210:20 freechips.rocketchip.system.LitexConfig.fir 2475:6]
  wire  _T_26 = _T_20[2] & _T_24; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 2477:6]
  wire  _T_27 = _T_21 | _T_26; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 2478:6]
  wire  _T_29 = _T_20[2] & io_in_a_bits_address[2]; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 2480:6]
  wire  _T_30 = _T_21 | _T_29; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 2481:6]
  wire  _T_33 = ~io_in_a_bits_address[1]; // @[Misc.scala 210:20 freechips.rocketchip.system.LitexConfig.fir 2484:6]
  wire  _T_34 = _T_24 & _T_33; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 2485:6]
  wire  _T_35 = _T_20[1] & _T_34; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 2486:6]
  wire  _T_36 = _T_27 | _T_35; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 2487:6]
  wire  _T_37 = _T_24 & io_in_a_bits_address[1]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 2488:6]
  wire  _T_38 = _T_20[1] & _T_37; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 2489:6]
  wire  _T_39 = _T_27 | _T_38; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 2490:6]
  wire  _T_40 = io_in_a_bits_address[2] & _T_33; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 2491:6]
  wire  _T_41 = _T_20[1] & _T_40; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 2492:6]
  wire  _T_42 = _T_30 | _T_41; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 2493:6]
  wire  _T_43 = io_in_a_bits_address[2] & io_in_a_bits_address[1]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 2494:6]
  wire  _T_44 = _T_20[1] & _T_43; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 2495:6]
  wire  _T_45 = _T_30 | _T_44; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 2496:6]
  wire  _T_48 = ~io_in_a_bits_address[0]; // @[Misc.scala 210:20 freechips.rocketchip.system.LitexConfig.fir 2499:6]
  wire  _T_49 = _T_34 & _T_48; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 2500:6]
  wire  _T_50 = _T_20[0] & _T_49; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 2501:6]
  wire  _T_51 = _T_36 | _T_50; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 2502:6]
  wire  _T_52 = _T_34 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 2503:6]
  wire  _T_53 = _T_20[0] & _T_52; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 2504:6]
  wire  _T_54 = _T_36 | _T_53; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 2505:6]
  wire  _T_55 = _T_37 & _T_48; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 2506:6]
  wire  _T_56 = _T_20[0] & _T_55; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 2507:6]
  wire  _T_57 = _T_39 | _T_56; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 2508:6]
  wire  _T_58 = _T_37 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 2509:6]
  wire  _T_59 = _T_20[0] & _T_58; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 2510:6]
  wire  _T_60 = _T_39 | _T_59; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 2511:6]
  wire  _T_61 = _T_40 & _T_48; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 2512:6]
  wire  _T_62 = _T_20[0] & _T_61; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 2513:6]
  wire  _T_63 = _T_42 | _T_62; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 2514:6]
  wire  _T_64 = _T_40 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 2515:6]
  wire  _T_65 = _T_20[0] & _T_64; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 2516:6]
  wire  _T_66 = _T_42 | _T_65; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 2517:6]
  wire  _T_67 = _T_43 & _T_48; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 2518:6]
  wire  _T_68 = _T_20[0] & _T_67; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 2519:6]
  wire  _T_69 = _T_45 | _T_68; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 2520:6]
  wire  _T_70 = _T_43 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 2521:6]
  wire  _T_71 = _T_20[0] & _T_70; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 2522:6]
  wire  _T_72 = _T_45 | _T_71; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 2523:6]
  wire [7:0] _T_79 = {_T_72,_T_69,_T_66,_T_63,_T_60,_T_57,_T_54,_T_51}; // @[Cat.scala 29:58 freechips.rocketchip.system.LitexConfig.fir 2530:6]
  wire [32:0] _T_83 = {1'b0,$signed(io_in_a_bits_address)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 2534:6]
  wire  _T_109 = io_in_a_bits_opcode == 3'h6; // @[Monitor.scala 83:25 freechips.rocketchip.system.LitexConfig.fir 2564:6]
  wire  _T_111 = io_in_a_bits_size <= 4'hc; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 2567:8]
  wire  _T_118 = _T_111 & _T_9; // @[Parameters.scala 1195:30 freechips.rocketchip.system.LitexConfig.fir 2574:8]
  wire  _T_128 = io_in_a_bits_size <= 4'h6; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 2584:8]
  wire [31:0] _T_131 = io_in_a_bits_address ^ 32'h80000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 2587:8]
  wire [32:0] _T_132 = {1'b0,$signed(_T_131)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 2588:8]
  wire [32:0] _T_134 = $signed(_T_132) & 33'sh80000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 2590:8]
  wire  _T_135 = $signed(_T_134) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 2591:8]
  wire  _T_136 = _T_128 & _T_135; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 2592:8]
  wire  _T_139 = _T_118 & _T_136; // @[Parameters.scala 1402:195 freechips.rocketchip.system.LitexConfig.fir 2595:8]
  wire  _T_141 = _T_139 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2597:8]
  wire  _T_142 = ~_T_141; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2598:8]
  wire  _T_147 = 4'h6 == io_in_a_bits_size; // @[Parameters.scala 92:48 freechips.rocketchip.system.LitexConfig.fir 2611:8]
  wire  _T_148 = _T_4 & _T_147; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 2612:8]
  wire  _T_165 = _T_148 & _T_111; // @[Parameters.scala 1417:195 freechips.rocketchip.system.LitexConfig.fir 2630:8]
  wire  _T_167 = _T_165 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2632:8]
  wire  _T_168 = ~_T_167; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2633:8]
  wire  _T_170 = _T_9 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2639:8]
  wire  _T_171 = ~_T_170; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2640:8]
  wire  _T_174 = _T_21 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2647:8]
  wire  _T_175 = ~_T_174; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2648:8]
  wire  _T_177 = _T_15 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2654:8]
  wire  _T_178 = ~_T_177; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2655:8]
  wire  _T_179 = io_in_a_bits_param <= 3'h2; // @[Bundles.scala 110:27 freechips.rocketchip.system.LitexConfig.fir 2660:8]
  wire  _T_181 = _T_179 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2662:8]
  wire  _T_182 = ~_T_181; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2663:8]
  wire [7:0] _T_183 = ~io_in_a_bits_mask; // @[Monitor.scala 90:18 freechips.rocketchip.system.LitexConfig.fir 2668:8]
  wire  _T_184 = _T_183 == 8'h0; // @[Monitor.scala 90:31 freechips.rocketchip.system.LitexConfig.fir 2669:8]
  wire  _T_186 = _T_184 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2671:8]
  wire  _T_187 = ~_T_186; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2672:8]
  wire  _T_188 = ~io_in_a_bits_corrupt; // @[Monitor.scala 91:18 freechips.rocketchip.system.LitexConfig.fir 2677:8]
  wire  _T_190 = _T_188 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2679:8]
  wire  _T_191 = ~_T_190; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2680:8]
  wire  _T_192 = io_in_a_bits_opcode == 3'h7; // @[Monitor.scala 94:25 freechips.rocketchip.system.LitexConfig.fir 2686:6]
  wire  _T_266 = io_in_a_bits_param != 3'h0; // @[Monitor.scala 101:31 freechips.rocketchip.system.LitexConfig.fir 2790:8]
  wire  _T_268 = _T_266 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2792:8]
  wire  _T_269 = ~_T_268; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2793:8]
  wire  _T_279 = io_in_a_bits_opcode == 3'h4; // @[Monitor.scala 106:25 freechips.rocketchip.system.LitexConfig.fir 2816:6]
  wire  _T_291 = _T_118 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2829:8]
  wire  _T_292 = ~_T_291; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2830:8]
  wire [31:0] _T_297 = io_in_a_bits_address ^ 32'h2000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 2839:8]
  wire [32:0] _T_298 = {1'b0,$signed(_T_297)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 2840:8]
  wire [32:0] _T_300 = $signed(_T_298) & 33'shfa012000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 2842:8]
  wire  _T_301 = $signed(_T_300) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 2843:8]
  wire  _T_302 = _T_111 & _T_301; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 2844:8]
  wire [32:0] _T_310 = $signed(_T_83) & 33'shfa012000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 2852:8]
  wire  _T_311 = $signed(_T_310) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 2853:8]
  wire [31:0] _T_312 = io_in_a_bits_address ^ 32'h10000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 2854:8]
  wire [32:0] _T_313 = {1'b0,$signed(_T_312)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 2855:8]
  wire [32:0] _T_315 = $signed(_T_313) & 33'shfa010000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 2857:8]
  wire  _T_316 = $signed(_T_315) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 2858:8]
  wire [31:0] _T_317 = io_in_a_bits_address ^ 32'h2000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 2859:8]
  wire [32:0] _T_318 = {1'b0,$signed(_T_317)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 2860:8]
  wire [32:0] _T_320 = $signed(_T_318) & 33'shfa010000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 2862:8]
  wire  _T_321 = $signed(_T_320) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 2863:8]
  wire [31:0] _T_322 = io_in_a_bits_address ^ 32'h8000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 2864:8]
  wire [32:0] _T_323 = {1'b0,$signed(_T_322)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 2865:8]
  wire [32:0] _T_325 = $signed(_T_323) & 33'shf8000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 2867:8]
  wire  _T_326 = $signed(_T_325) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 2868:8]
  wire [31:0] _T_327 = io_in_a_bits_address ^ 32'h10000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 2869:8]
  wire [32:0] _T_328 = {1'b0,$signed(_T_327)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 2870:8]
  wire [32:0] _T_330 = $signed(_T_328) & 33'shf0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 2872:8]
  wire  _T_331 = $signed(_T_330) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 2873:8]
  wire [31:0] _T_332 = io_in_a_bits_address ^ 32'h20000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 2874:8]
  wire [32:0] _T_333 = {1'b0,$signed(_T_332)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 2875:8]
  wire [32:0] _T_335 = $signed(_T_333) & 33'she0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 2877:8]
  wire  _T_336 = $signed(_T_335) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 2878:8]
  wire [31:0] _T_337 = io_in_a_bits_address ^ 32'h40000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 2879:8]
  wire [32:0] _T_338 = {1'b0,$signed(_T_337)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 2880:8]
  wire [32:0] _T_340 = $signed(_T_338) & 33'shc0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 2882:8]
  wire  _T_341 = $signed(_T_340) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 2883:8]
  wire  _T_347 = _T_311 | _T_316; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 2889:8]
  wire  _T_348 = _T_347 | _T_321; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 2890:8]
  wire  _T_349 = _T_348 | _T_326; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 2891:8]
  wire  _T_350 = _T_349 | _T_331; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 2892:8]
  wire  _T_351 = _T_350 | _T_336; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 2893:8]
  wire  _T_352 = _T_351 | _T_341; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 2894:8]
  wire  _T_353 = _T_352 | _T_135; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 2895:8]
  wire  _T_354 = _T_128 & _T_353; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 2896:8]
  wire  _T_356 = _T_302 | _T_354; // @[Parameters.scala 661:30 freechips.rocketchip.system.LitexConfig.fir 2898:8]
  wire  _T_358 = _T_356 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2900:8]
  wire  _T_359 = ~_T_358; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2901:8]
  wire  _T_366 = io_in_a_bits_param == 3'h0; // @[Monitor.scala 111:31 freechips.rocketchip.system.LitexConfig.fir 2920:8]
  wire  _T_368 = _T_366 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2922:8]
  wire  _T_369 = ~_T_368; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2923:8]
  wire  _T_370 = io_in_a_bits_mask == _T_79; // @[Monitor.scala 112:30 freechips.rocketchip.system.LitexConfig.fir 2928:8]
  wire  _T_372 = _T_370 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2930:8]
  wire  _T_373 = ~_T_372; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2931:8]
  wire  _T_378 = io_in_a_bits_opcode == 3'h0; // @[Monitor.scala 116:25 freechips.rocketchip.system.LitexConfig.fir 2945:6]
  wire  _T_423 = _T_311 | _T_321; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 2991:8]
  wire  _T_424 = _T_423 | _T_326; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 2992:8]
  wire  _T_425 = _T_424 | _T_135; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 2993:8]
  wire  _T_426 = _T_128 & _T_425; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 2994:8]
  wire  _T_435 = io_in_a_bits_size <= 4'h8; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 3003:8]
  wire  _T_453 = _T_331 | _T_336; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 3021:8]
  wire  _T_454 = _T_453 | _T_341; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 3022:8]
  wire  _T_455 = _T_435 & _T_454; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 3023:8]
  wire  _T_457 = _T_302 | _T_426; // @[Parameters.scala 661:30 freechips.rocketchip.system.LitexConfig.fir 3025:8]
  wire  _T_459 = _T_457 | _T_455; // @[Parameters.scala 661:30 freechips.rocketchip.system.LitexConfig.fir 3027:8]
  wire  _T_460 = _T_118 & _T_459; // @[Parameters.scala 1406:195 freechips.rocketchip.system.LitexConfig.fir 3028:8]
  wire  _T_462 = _T_460 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3030:8]
  wire  _T_463 = ~_T_462; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3031:8]
  wire  _T_478 = io_in_a_bits_opcode == 3'h1; // @[Monitor.scala 124:25 freechips.rocketchip.system.LitexConfig.fir 3067:6]
  wire [7:0] _T_574 = ~_T_79; // @[Monitor.scala 129:33 freechips.rocketchip.system.LitexConfig.fir 3180:8]
  wire [7:0] _T_575 = io_in_a_bits_mask & _T_574; // @[Monitor.scala 129:31 freechips.rocketchip.system.LitexConfig.fir 3181:8]
  wire  _T_576 = _T_575 == 8'h0; // @[Monitor.scala 129:40 freechips.rocketchip.system.LitexConfig.fir 3182:8]
  wire  _T_578 = _T_576 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3184:8]
  wire  _T_579 = ~_T_578; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3185:8]
  wire  _T_580 = io_in_a_bits_opcode == 3'h2; // @[Monitor.scala 132:25 freechips.rocketchip.system.LitexConfig.fir 3191:6]
  wire  _T_592 = io_in_a_bits_size <= 4'h3; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 3204:8]
  wire [32:0] _T_598 = $signed(_T_83) & 33'shf8010000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 3210:8]
  wire  _T_599 = $signed(_T_598) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 3211:8]
  wire  _T_605 = _T_599 | _T_326; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 3217:8]
  wire  _T_606 = _T_592 & _T_605; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 3218:8]
  wire  _T_640 = _T_118 & _T_606; // @[Parameters.scala 1403:195 freechips.rocketchip.system.LitexConfig.fir 3252:8]
  wire  _T_642 = _T_640 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3254:8]
  wire  _T_643 = ~_T_642; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3255:8]
  wire  _T_650 = io_in_a_bits_param <= 3'h4; // @[Bundles.scala 140:33 freechips.rocketchip.system.LitexConfig.fir 3274:8]
  wire  _T_652 = _T_650 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3276:8]
  wire  _T_653 = ~_T_652; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3277:8]
  wire  _T_658 = io_in_a_bits_opcode == 3'h3; // @[Monitor.scala 140:25 freechips.rocketchip.system.LitexConfig.fir 3291:6]
  wire  _T_728 = io_in_a_bits_param <= 3'h3; // @[Bundles.scala 147:30 freechips.rocketchip.system.LitexConfig.fir 3374:8]
  wire  _T_730 = _T_728 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3376:8]
  wire  _T_731 = ~_T_730; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3377:8]
  wire  _T_736 = io_in_a_bits_opcode == 3'h5; // @[Monitor.scala 148:25 freechips.rocketchip.system.LitexConfig.fir 3391:6]
  wire  _T_808 = _T_118 & _T_302; // @[Parameters.scala 1408:195 freechips.rocketchip.system.LitexConfig.fir 3464:8]
  wire  _T_810 = _T_808 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3466:8]
  wire  _T_811 = ~_T_810; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3467:8]
  wire  _T_818 = io_in_a_bits_param <= 3'h1; // @[Bundles.scala 160:28 freechips.rocketchip.system.LitexConfig.fir 3486:8]
  wire  _T_820 = _T_818 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3488:8]
  wire  _T_821 = ~_T_820; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3489:8]
  wire  _T_830 = io_in_d_bits_opcode <= 3'h6; // @[Bundles.scala 44:24 freechips.rocketchip.system.LitexConfig.fir 3513:6]
  wire  _T_832 = _T_830 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3515:6]
  wire  _T_833 = ~_T_832; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3516:6]
  wire  _T_834 = io_in_d_bits_source == 2'h0; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 3521:6]
  wire  _T_835 = io_in_d_bits_source == 2'h1; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 3522:6]
  wire  _T_836 = io_in_d_bits_source == 2'h2; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 3523:6]
  wire  _T_838 = _T_834 | _T_835; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 3529:6]
  wire  _T_839 = _T_838 | _T_836; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 3530:6]
  wire  _T_841 = io_in_d_bits_opcode == 3'h6; // @[Monitor.scala 312:25 freechips.rocketchip.system.LitexConfig.fir 3532:6]
  wire  _T_843 = _T_839 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3535:8]
  wire  _T_844 = ~_T_843; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3536:8]
  wire  _T_845 = io_in_d_bits_size >= 4'h3; // @[Monitor.scala 314:27 freechips.rocketchip.system.LitexConfig.fir 3541:8]
  wire  _T_847 = _T_845 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3543:8]
  wire  _T_848 = ~_T_847; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3544:8]
  wire  _T_849 = io_in_d_bits_param == 2'h0; // @[Monitor.scala 315:28 freechips.rocketchip.system.LitexConfig.fir 3549:8]
  wire  _T_851 = _T_849 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3551:8]
  wire  _T_852 = ~_T_851; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3552:8]
  wire  _T_853 = ~io_in_d_bits_corrupt; // @[Monitor.scala 316:15 freechips.rocketchip.system.LitexConfig.fir 3557:8]
  wire  _T_855 = _T_853 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3559:8]
  wire  _T_856 = ~_T_855; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3560:8]
  wire  _T_857 = ~io_in_d_bits_denied; // @[Monitor.scala 317:15 freechips.rocketchip.system.LitexConfig.fir 3565:8]
  wire  _T_859 = _T_857 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3567:8]
  wire  _T_860 = ~_T_859; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3568:8]
  wire  _T_861 = io_in_d_bits_opcode == 3'h4; // @[Monitor.scala 320:25 freechips.rocketchip.system.LitexConfig.fir 3574:6]
  wire  _T_872 = io_in_d_bits_param <= 2'h2; // @[Bundles.scala 104:26 freechips.rocketchip.system.LitexConfig.fir 3598:8]
  wire  _T_874 = _T_872 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3600:8]
  wire  _T_875 = ~_T_874; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3601:8]
  wire  _T_876 = io_in_d_bits_param != 2'h2; // @[Monitor.scala 325:28 freechips.rocketchip.system.LitexConfig.fir 3606:8]
  wire  _T_878 = _T_876 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3608:8]
  wire  _T_879 = ~_T_878; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3609:8]
  wire  _T_889 = io_in_d_bits_opcode == 3'h5; // @[Monitor.scala 330:25 freechips.rocketchip.system.LitexConfig.fir 3632:6]
  wire  _T_909 = _T_857 | io_in_d_bits_corrupt; // @[Monitor.scala 336:30 freechips.rocketchip.system.LitexConfig.fir 3673:8]
  wire  _T_911 = _T_909 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3675:8]
  wire  _T_912 = ~_T_911; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3676:8]
  wire  _T_918 = io_in_d_bits_opcode == 3'h0; // @[Monitor.scala 340:25 freechips.rocketchip.system.LitexConfig.fir 3691:6]
  wire  _T_935 = io_in_d_bits_opcode == 3'h1; // @[Monitor.scala 348:25 freechips.rocketchip.system.LitexConfig.fir 3726:6]
  wire  _T_953 = io_in_d_bits_opcode == 3'h2; // @[Monitor.scala 356:25 freechips.rocketchip.system.LitexConfig.fir 3762:6]
  wire [32:0] _T_977 = {1'b0,$signed(io_in_b_bits_address)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 3810:6]
  wire [31:0] _T_1003 = io_in_b_bits_address ^ 32'h3000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 3840:6]
  wire [32:0] _T_1004 = {1'b0,$signed(_T_1003)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 3841:6]
  wire [32:0] _T_1006 = $signed(_T_1004) & -33'sh1000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 3843:6]
  wire  _T_1007 = $signed(_T_1006) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 3844:6]
  wire [31:0] _T_1008 = io_in_b_bits_address ^ 32'hc000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 3845:6]
  wire [32:0] _T_1009 = {1'b0,$signed(_T_1008)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 3846:6]
  wire [32:0] _T_1011 = $signed(_T_1009) & -33'sh4000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 3848:6]
  wire  _T_1012 = $signed(_T_1011) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 3849:6]
  wire [31:0] _T_1013 = io_in_b_bits_address ^ 32'h2000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 3850:6]
  wire [32:0] _T_1014 = {1'b0,$signed(_T_1013)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 3851:6]
  wire [32:0] _T_1016 = $signed(_T_1014) & -33'sh10000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 3853:6]
  wire  _T_1017 = $signed(_T_1016) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 3854:6]
  wire [32:0] _T_1021 = $signed(_T_977) & -33'sh1000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 3858:6]
  wire  _T_1022 = $signed(_T_1021) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 3859:6]
  wire [31:0] _T_1023 = io_in_b_bits_address ^ 32'h10000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 3860:6]
  wire [32:0] _T_1024 = {1'b0,$signed(_T_1023)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 3861:6]
  wire [32:0] _T_1026 = $signed(_T_1024) & -33'sh10000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 3863:6]
  wire  _T_1027 = $signed(_T_1026) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 3864:6]
  wire [31:0] _T_1028 = io_in_b_bits_address ^ 32'h80000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 3865:6]
  wire [32:0] _T_1029 = {1'b0,$signed(_T_1028)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 3866:6]
  wire [32:0] _T_1031 = $signed(_T_1029) & -33'sh80000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 3868:6]
  wire  _T_1032 = $signed(_T_1031) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 3869:6]
  wire [31:0] _T_1033 = io_in_b_bits_address ^ 32'h10000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 3870:6]
  wire [32:0] _T_1034 = {1'b0,$signed(_T_1033)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 3871:6]
  wire [32:0] _T_1036 = $signed(_T_1034) & -33'sh10000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 3873:6]
  wire  _T_1037 = $signed(_T_1036) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 3874:6]
  wire [31:0] _T_1038 = io_in_b_bits_address ^ 32'h20000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 3875:6]
  wire [32:0] _T_1039 = {1'b0,$signed(_T_1038)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 3876:6]
  wire [32:0] _T_1041 = $signed(_T_1039) & -33'sh20000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 3878:6]
  wire  _T_1042 = $signed(_T_1041) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 3879:6]
  wire [31:0] _T_1043 = io_in_b_bits_address ^ 32'h40000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 3880:6]
  wire [32:0] _T_1044 = {1'b0,$signed(_T_1043)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 3881:6]
  wire [32:0] _T_1046 = $signed(_T_1044) & -33'sh40000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 3883:6]
  wire  _T_1047 = $signed(_T_1046) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 3884:6]
  wire  _T_1048 = _T_1037 | _T_1042; // @[Parameters.scala 590:92 freechips.rocketchip.system.LitexConfig.fir 3885:6]
  wire  _T_1049 = _T_1048 | _T_1047; // @[Parameters.scala 590:92 freechips.rocketchip.system.LitexConfig.fir 3886:6]
  wire  _T_1051 = _T_1007 | _T_1012; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 3896:6]
  wire  _T_1052 = _T_1051 | _T_1017; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 3897:6]
  wire  _T_1053 = _T_1052 | _T_1022; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 3898:6]
  wire  _T_1054 = _T_1053 | _T_1027; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 3899:6]
  wire  _T_1055 = _T_1054 | _T_1032; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 3900:6]
  wire  _T_1056 = _T_1055 | _T_1049; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 3901:6]
  wire [31:0] _T_1061 = io_in_b_bits_address & 32'h3f; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 3906:6]
  wire  _T_1062 = _T_1061 == 32'h0; // @[Edges.scala 22:24 freechips.rocketchip.system.LitexConfig.fir 3907:6]
  wire  _T_1166 = _T_1056 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 4026:8]
  wire  _T_1167 = ~_T_1166; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 4027:8]
  wire  _T_1172 = _T_1062 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 4040:8]
  wire  _T_1173 = ~_T_1172; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 4041:8]
  wire  _T_1174 = io_in_b_bits_param <= 2'h2; // @[Bundles.scala 104:26 freechips.rocketchip.system.LitexConfig.fir 4046:8]
  wire  _T_1176 = _T_1174 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 4048:8]
  wire  _T_1177 = ~_T_1176; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 4049:8]
  wire  _T_1394 = io_in_c_bits_source == 2'h0; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 4445:6]
  wire  _T_1395 = io_in_c_bits_source == 2'h1; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 4446:6]
  wire  _T_1396 = io_in_c_bits_source == 2'h2; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 4447:6]
  wire  _T_1398 = _T_1394 | _T_1395; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 4453:6]
  wire  _T_1399 = _T_1398 | _T_1396; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 4454:6]
  wire [26:0] _T_1401 = 27'hfff << io_in_c_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 4456:6]
  wire [11:0] _T_1403 = ~_T_1401[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 4458:6]
  wire [31:0] _GEN_87 = {{20'd0}, _T_1403}; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 4459:6]
  wire [31:0] _T_1404 = io_in_c_bits_address & _GEN_87; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 4459:6]
  wire  _T_1405 = _T_1404 == 32'h0; // @[Edges.scala 22:24 freechips.rocketchip.system.LitexConfig.fir 4460:6]
  wire [31:0] _T_1406 = io_in_c_bits_address ^ 32'h3000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 4461:6]
  wire [32:0] _T_1407 = {1'b0,$signed(_T_1406)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 4462:6]
  wire [32:0] _T_1409 = $signed(_T_1407) & -33'sh1000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 4464:6]
  wire  _T_1410 = $signed(_T_1409) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 4465:6]
  wire [31:0] _T_1411 = io_in_c_bits_address ^ 32'hc000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 4466:6]
  wire [32:0] _T_1412 = {1'b0,$signed(_T_1411)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 4467:6]
  wire [32:0] _T_1414 = $signed(_T_1412) & -33'sh4000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 4469:6]
  wire  _T_1415 = $signed(_T_1414) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 4470:6]
  wire [31:0] _T_1416 = io_in_c_bits_address ^ 32'h2000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 4471:6]
  wire [32:0] _T_1417 = {1'b0,$signed(_T_1416)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 4472:6]
  wire [32:0] _T_1419 = $signed(_T_1417) & -33'sh10000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 4474:6]
  wire  _T_1420 = $signed(_T_1419) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 4475:6]
  wire [32:0] _T_1422 = {1'b0,$signed(io_in_c_bits_address)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 4477:6]
  wire [32:0] _T_1424 = $signed(_T_1422) & -33'sh1000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 4479:6]
  wire  _T_1425 = $signed(_T_1424) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 4480:6]
  wire [31:0] _T_1426 = io_in_c_bits_address ^ 32'h10000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 4481:6]
  wire [32:0] _T_1427 = {1'b0,$signed(_T_1426)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 4482:6]
  wire [32:0] _T_1429 = $signed(_T_1427) & -33'sh10000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 4484:6]
  wire  _T_1430 = $signed(_T_1429) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 4485:6]
  wire [31:0] _T_1431 = io_in_c_bits_address ^ 32'h80000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 4486:6]
  wire [32:0] _T_1432 = {1'b0,$signed(_T_1431)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 4487:6]
  wire [32:0] _T_1434 = $signed(_T_1432) & -33'sh80000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 4489:6]
  wire  _T_1435 = $signed(_T_1434) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 4490:6]
  wire [31:0] _T_1436 = io_in_c_bits_address ^ 32'h10000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 4491:6]
  wire [32:0] _T_1437 = {1'b0,$signed(_T_1436)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 4492:6]
  wire [32:0] _T_1439 = $signed(_T_1437) & -33'sh10000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 4494:6]
  wire  _T_1440 = $signed(_T_1439) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 4495:6]
  wire [31:0] _T_1441 = io_in_c_bits_address ^ 32'h20000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 4496:6]
  wire [32:0] _T_1442 = {1'b0,$signed(_T_1441)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 4497:6]
  wire [32:0] _T_1444 = $signed(_T_1442) & -33'sh20000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 4499:6]
  wire  _T_1445 = $signed(_T_1444) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 4500:6]
  wire [31:0] _T_1446 = io_in_c_bits_address ^ 32'h40000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 4501:6]
  wire [32:0] _T_1447 = {1'b0,$signed(_T_1446)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 4502:6]
  wire [32:0] _T_1449 = $signed(_T_1447) & -33'sh40000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 4504:6]
  wire  _T_1450 = $signed(_T_1449) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 4505:6]
  wire  _T_1451 = _T_1440 | _T_1445; // @[Parameters.scala 590:92 freechips.rocketchip.system.LitexConfig.fir 4506:6]
  wire  _T_1452 = _T_1451 | _T_1450; // @[Parameters.scala 590:92 freechips.rocketchip.system.LitexConfig.fir 4507:6]
  wire  _T_1454 = _T_1410 | _T_1415; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 4517:6]
  wire  _T_1455 = _T_1454 | _T_1420; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 4518:6]
  wire  _T_1456 = _T_1455 | _T_1425; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 4519:6]
  wire  _T_1457 = _T_1456 | _T_1430; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 4520:6]
  wire  _T_1458 = _T_1457 | _T_1435; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 4521:6]
  wire  _T_1459 = _T_1458 | _T_1452; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 4522:6]
  wire  _T_1489 = io_in_c_bits_opcode == 3'h4; // @[Monitor.scala 244:25 freechips.rocketchip.system.LitexConfig.fir 4556:6]
  wire  _T_1491 = _T_1459 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4559:8]
  wire  _T_1492 = ~_T_1491; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4560:8]
  wire  _T_1494 = _T_1399 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4566:8]
  wire  _T_1495 = ~_T_1494; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4567:8]
  wire  _T_1496 = io_in_c_bits_size >= 4'h3; // @[Monitor.scala 247:30 freechips.rocketchip.system.LitexConfig.fir 4572:8]
  wire  _T_1498 = _T_1496 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4574:8]
  wire  _T_1499 = ~_T_1498; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4575:8]
  wire  _T_1501 = _T_1405 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4581:8]
  wire  _T_1502 = ~_T_1501; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4582:8]
  wire  _T_1503 = io_in_c_bits_param <= 3'h5; // @[Bundles.scala 122:29 freechips.rocketchip.system.LitexConfig.fir 4587:8]
  wire  _T_1505 = _T_1503 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4589:8]
  wire  _T_1506 = ~_T_1505; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4590:8]
  wire  _T_1507 = ~io_in_c_bits_corrupt; // @[Monitor.scala 250:18 freechips.rocketchip.system.LitexConfig.fir 4595:8]
  wire  _T_1509 = _T_1507 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4597:8]
  wire  _T_1510 = ~_T_1509; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4598:8]
  wire  _T_1511 = io_in_c_bits_opcode == 3'h5; // @[Monitor.scala 253:25 freechips.rocketchip.system.LitexConfig.fir 4604:6]
  wire  _T_1529 = io_in_c_bits_opcode == 3'h6; // @[Monitor.scala 261:25 freechips.rocketchip.system.LitexConfig.fir 4644:6]
  wire  _T_1531 = io_in_c_bits_size <= 4'hc; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 4647:8]
  wire  _T_1538 = _T_1531 & _T_1399; // @[Parameters.scala 1195:30 freechips.rocketchip.system.LitexConfig.fir 4654:8]
  wire  _T_1548 = io_in_c_bits_size <= 4'h6; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 4664:8]
  wire [32:0] _T_1554 = $signed(_T_1432) & 33'sh80000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 4670:8]
  wire  _T_1555 = $signed(_T_1554) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 4671:8]
  wire  _T_1556 = _T_1548 & _T_1555; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 4672:8]
  wire  _T_1559 = _T_1538 & _T_1556; // @[Parameters.scala 1402:195 freechips.rocketchip.system.LitexConfig.fir 4675:8]
  wire  _T_1561 = _T_1559 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4677:8]
  wire  _T_1562 = ~_T_1561; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4678:8]
  wire  _T_1567 = 4'h6 == io_in_c_bits_size; // @[Parameters.scala 92:48 freechips.rocketchip.system.LitexConfig.fir 4691:8]
  wire  _T_1568 = _T_1394 & _T_1567; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 4692:8]
  wire  _T_1585 = _T_1568 & _T_1531; // @[Parameters.scala 1417:195 freechips.rocketchip.system.LitexConfig.fir 4710:8]
  wire  _T_1587 = _T_1585 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4712:8]
  wire  _T_1588 = ~_T_1587; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4713:8]
  wire  _T_1599 = io_in_c_bits_param <= 3'h2; // @[Bundles.scala 116:29 freechips.rocketchip.system.LitexConfig.fir 4740:8]
  wire  _T_1601 = _T_1599 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4742:8]
  wire  _T_1602 = ~_T_1601; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4743:8]
  wire  _T_1607 = io_in_c_bits_opcode == 3'h7; // @[Monitor.scala 271:25 freechips.rocketchip.system.LitexConfig.fir 4757:6]
  wire  _T_1681 = io_in_c_bits_opcode == 3'h0; // @[Monitor.scala 280:25 freechips.rocketchip.system.LitexConfig.fir 4862:6]
  wire  _T_1691 = io_in_c_bits_param == 3'h0; // @[Monitor.scala 284:31 freechips.rocketchip.system.LitexConfig.fir 4885:8]
  wire  _T_1693 = _T_1691 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4887:8]
  wire  _T_1694 = ~_T_1693; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4888:8]
  wire  _T_1699 = io_in_c_bits_opcode == 3'h1; // @[Monitor.scala 288:25 freechips.rocketchip.system.LitexConfig.fir 4902:6]
  wire  _T_1713 = io_in_c_bits_opcode == 3'h2; // @[Monitor.scala 295:25 freechips.rocketchip.system.LitexConfig.fir 4934:6]
  wire  _T_1735 = io_in_a_ready & io_in_a_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 4985:4]
  wire  _T_1742 = ~io_in_a_bits_opcode[2]; // @[Edges.scala 93:28 freechips.rocketchip.system.LitexConfig.fir 4992:4]
  reg [8:0] _T_1744; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 4994:4]
  wire [8:0] _T_1746 = _T_1744 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 4996:4]
  wire  _T_1747 = _T_1744 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 4997:4]
  reg [2:0] _T_1755; // @[Monitor.scala 386:22 freechips.rocketchip.system.LitexConfig.fir 5008:4]
  reg [2:0] _T_1756; // @[Monitor.scala 387:22 freechips.rocketchip.system.LitexConfig.fir 5009:4]
  reg [3:0] _T_1757; // @[Monitor.scala 388:22 freechips.rocketchip.system.LitexConfig.fir 5010:4]
  reg [1:0] _T_1758; // @[Monitor.scala 389:22 freechips.rocketchip.system.LitexConfig.fir 5011:4]
  reg [31:0] _T_1759; // @[Monitor.scala 390:22 freechips.rocketchip.system.LitexConfig.fir 5012:4]
  wire  _T_1760 = ~_T_1747; // @[Monitor.scala 391:22 freechips.rocketchip.system.LitexConfig.fir 5013:4]
  wire  _T_1761 = io_in_a_valid & _T_1760; // @[Monitor.scala 391:19 freechips.rocketchip.system.LitexConfig.fir 5014:4]
  wire  _T_1762 = io_in_a_bits_opcode == _T_1755; // @[Monitor.scala 392:32 freechips.rocketchip.system.LitexConfig.fir 5016:6]
  wire  _T_1764 = _T_1762 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5018:6]
  wire  _T_1765 = ~_T_1764; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5019:6]
  wire  _T_1766 = io_in_a_bits_param == _T_1756; // @[Monitor.scala 393:32 freechips.rocketchip.system.LitexConfig.fir 5024:6]
  wire  _T_1768 = _T_1766 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5026:6]
  wire  _T_1769 = ~_T_1768; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5027:6]
  wire  _T_1770 = io_in_a_bits_size == _T_1757; // @[Monitor.scala 394:32 freechips.rocketchip.system.LitexConfig.fir 5032:6]
  wire  _T_1772 = _T_1770 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5034:6]
  wire  _T_1773 = ~_T_1772; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5035:6]
  wire  _T_1774 = io_in_a_bits_source == _T_1758; // @[Monitor.scala 395:32 freechips.rocketchip.system.LitexConfig.fir 5040:6]
  wire  _T_1776 = _T_1774 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5042:6]
  wire  _T_1777 = ~_T_1776; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5043:6]
  wire  _T_1778 = io_in_a_bits_address == _T_1759; // @[Monitor.scala 396:32 freechips.rocketchip.system.LitexConfig.fir 5048:6]
  wire  _T_1780 = _T_1778 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5050:6]
  wire  _T_1781 = ~_T_1780; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5051:6]
  wire  _T_1783 = _T_1735 & _T_1747; // @[Monitor.scala 398:20 freechips.rocketchip.system.LitexConfig.fir 5058:4]
  wire  _T_1784 = io_in_d_ready & io_in_d_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 5066:4]
  wire [26:0] _T_1786 = 27'hfff << io_in_d_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 5068:4]
  wire [11:0] _T_1788 = ~_T_1786[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 5070:4]
  reg [8:0] _T_1792; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 5074:4]
  wire [8:0] _T_1794 = _T_1792 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 5076:4]
  wire  _T_1795 = _T_1792 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 5077:4]
  reg [2:0] _T_1803; // @[Monitor.scala 537:22 freechips.rocketchip.system.LitexConfig.fir 5088:4]
  reg [1:0] _T_1804; // @[Monitor.scala 538:22 freechips.rocketchip.system.LitexConfig.fir 5089:4]
  reg [3:0] _T_1805; // @[Monitor.scala 539:22 freechips.rocketchip.system.LitexConfig.fir 5090:4]
  reg [1:0] _T_1806; // @[Monitor.scala 540:22 freechips.rocketchip.system.LitexConfig.fir 5091:4]
  reg [1:0] _T_1807; // @[Monitor.scala 541:22 freechips.rocketchip.system.LitexConfig.fir 5092:4]
  reg  _T_1808; // @[Monitor.scala 542:22 freechips.rocketchip.system.LitexConfig.fir 5093:4]
  wire  _T_1809 = ~_T_1795; // @[Monitor.scala 543:22 freechips.rocketchip.system.LitexConfig.fir 5094:4]
  wire  _T_1810 = io_in_d_valid & _T_1809; // @[Monitor.scala 543:19 freechips.rocketchip.system.LitexConfig.fir 5095:4]
  wire  _T_1811 = io_in_d_bits_opcode == _T_1803; // @[Monitor.scala 544:29 freechips.rocketchip.system.LitexConfig.fir 5097:6]
  wire  _T_1813 = _T_1811 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5099:6]
  wire  _T_1814 = ~_T_1813; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5100:6]
  wire  _T_1815 = io_in_d_bits_param == _T_1804; // @[Monitor.scala 545:29 freechips.rocketchip.system.LitexConfig.fir 5105:6]
  wire  _T_1817 = _T_1815 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5107:6]
  wire  _T_1818 = ~_T_1817; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5108:6]
  wire  _T_1819 = io_in_d_bits_size == _T_1805; // @[Monitor.scala 546:29 freechips.rocketchip.system.LitexConfig.fir 5113:6]
  wire  _T_1821 = _T_1819 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5115:6]
  wire  _T_1822 = ~_T_1821; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5116:6]
  wire  _T_1823 = io_in_d_bits_source == _T_1806; // @[Monitor.scala 547:29 freechips.rocketchip.system.LitexConfig.fir 5121:6]
  wire  _T_1825 = _T_1823 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5123:6]
  wire  _T_1826 = ~_T_1825; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5124:6]
  wire  _T_1827 = io_in_d_bits_sink == _T_1807; // @[Monitor.scala 548:29 freechips.rocketchip.system.LitexConfig.fir 5129:6]
  wire  _T_1829 = _T_1827 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5131:6]
  wire  _T_1830 = ~_T_1829; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5132:6]
  wire  _T_1831 = io_in_d_bits_denied == _T_1808; // @[Monitor.scala 549:29 freechips.rocketchip.system.LitexConfig.fir 5137:6]
  wire  _T_1833 = _T_1831 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5139:6]
  wire  _T_1834 = ~_T_1833; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5140:6]
  wire  _T_1836 = _T_1784 & _T_1795; // @[Monitor.scala 551:20 freechips.rocketchip.system.LitexConfig.fir 5147:4]
  wire  _T_1837 = io_in_b_ready & io_in_b_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 5156:4]
  reg [8:0] _T_1846; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 5165:4]
  wire [8:0] _T_1848 = _T_1846 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 5167:4]
  wire  _T_1849 = _T_1846 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 5168:4]
  reg [1:0] _T_1858; // @[Monitor.scala 410:22 freechips.rocketchip.system.LitexConfig.fir 5180:4]
  reg [31:0] _T_1861; // @[Monitor.scala 413:22 freechips.rocketchip.system.LitexConfig.fir 5183:4]
  wire  _T_1862 = ~_T_1849; // @[Monitor.scala 414:22 freechips.rocketchip.system.LitexConfig.fir 5184:4]
  wire  _T_1863 = io_in_b_valid & _T_1862; // @[Monitor.scala 414:19 freechips.rocketchip.system.LitexConfig.fir 5185:4]
  wire  _T_1868 = io_in_b_bits_param == _T_1858; // @[Monitor.scala 416:32 freechips.rocketchip.system.LitexConfig.fir 5195:6]
  wire  _T_1870 = _T_1868 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5197:6]
  wire  _T_1871 = ~_T_1870; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5198:6]
  wire  _T_1880 = io_in_b_bits_address == _T_1861; // @[Monitor.scala 419:32 freechips.rocketchip.system.LitexConfig.fir 5219:6]
  wire  _T_1882 = _T_1880 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5221:6]
  wire  _T_1883 = ~_T_1882; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5222:6]
  wire  _T_1885 = _T_1837 & _T_1849; // @[Monitor.scala 421:20 freechips.rocketchip.system.LitexConfig.fir 5229:4]
  wire  _T_1886 = io_in_c_ready & io_in_c_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 5237:4]
  reg [8:0] _T_1894; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 5245:4]
  wire [8:0] _T_1896 = _T_1894 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 5247:4]
  wire  _T_1897 = _T_1894 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 5248:4]
  reg [2:0] _T_1905; // @[Monitor.scala 514:22 freechips.rocketchip.system.LitexConfig.fir 5259:4]
  reg [2:0] _T_1906; // @[Monitor.scala 515:22 freechips.rocketchip.system.LitexConfig.fir 5260:4]
  reg [3:0] _T_1907; // @[Monitor.scala 516:22 freechips.rocketchip.system.LitexConfig.fir 5261:4]
  reg [1:0] _T_1908; // @[Monitor.scala 517:22 freechips.rocketchip.system.LitexConfig.fir 5262:4]
  reg [31:0] _T_1909; // @[Monitor.scala 518:22 freechips.rocketchip.system.LitexConfig.fir 5263:4]
  wire  _T_1910 = ~_T_1897; // @[Monitor.scala 519:22 freechips.rocketchip.system.LitexConfig.fir 5264:4]
  wire  _T_1911 = io_in_c_valid & _T_1910; // @[Monitor.scala 519:19 freechips.rocketchip.system.LitexConfig.fir 5265:4]
  wire  _T_1912 = io_in_c_bits_opcode == _T_1905; // @[Monitor.scala 520:32 freechips.rocketchip.system.LitexConfig.fir 5267:6]
  wire  _T_1914 = _T_1912 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5269:6]
  wire  _T_1915 = ~_T_1914; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5270:6]
  wire  _T_1916 = io_in_c_bits_param == _T_1906; // @[Monitor.scala 521:32 freechips.rocketchip.system.LitexConfig.fir 5275:6]
  wire  _T_1918 = _T_1916 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5277:6]
  wire  _T_1919 = ~_T_1918; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5278:6]
  wire  _T_1920 = io_in_c_bits_size == _T_1907; // @[Monitor.scala 522:32 freechips.rocketchip.system.LitexConfig.fir 5283:6]
  wire  _T_1922 = _T_1920 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5285:6]
  wire  _T_1923 = ~_T_1922; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5286:6]
  wire  _T_1924 = io_in_c_bits_source == _T_1908; // @[Monitor.scala 523:32 freechips.rocketchip.system.LitexConfig.fir 5291:6]
  wire  _T_1926 = _T_1924 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5293:6]
  wire  _T_1927 = ~_T_1926; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5294:6]
  wire  _T_1928 = io_in_c_bits_address == _T_1909; // @[Monitor.scala 524:32 freechips.rocketchip.system.LitexConfig.fir 5299:6]
  wire  _T_1930 = _T_1928 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5301:6]
  wire  _T_1931 = ~_T_1930; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5302:6]
  wire  _T_1933 = _T_1886 & _T_1897; // @[Monitor.scala 526:20 freechips.rocketchip.system.LitexConfig.fir 5309:4]
  reg [2:0] inflight; // @[Monitor.scala 613:27 freechips.rocketchip.system.LitexConfig.fir 5317:4]
  reg [11:0] inflight_opcodes; // @[Monitor.scala 615:35 freechips.rocketchip.system.LitexConfig.fir 5318:4]
  reg [23:0] inflight_sizes; // @[Monitor.scala 617:33 freechips.rocketchip.system.LitexConfig.fir 5319:4]
  reg [8:0] _T_1943; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 5329:4]
  wire [8:0] _T_1945 = _T_1943 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 5331:4]
  wire  a_first = _T_1943 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 5332:4]
  reg [8:0] _T_1961; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 5351:4]
  wire [8:0] _T_1963 = _T_1961 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 5353:4]
  wire  d_first = _T_1961 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 5354:4]
  wire [3:0] _GEN_88 = {io_in_d_bits_source, 2'h0}; // @[Monitor.scala 636:69 freechips.rocketchip.system.LitexConfig.fir 5375:4]
  wire [4:0] _T_1971 = {{1'd0}, _GEN_88}; // @[Monitor.scala 636:69 freechips.rocketchip.system.LitexConfig.fir 5375:4]
  wire [11:0] _T_1972 = inflight_opcodes >> _T_1971; // @[Monitor.scala 636:44 freechips.rocketchip.system.LitexConfig.fir 5376:4]
  wire [15:0] _T_1976 = 16'h10 - 16'h1; // @[Monitor.scala 611:57 freechips.rocketchip.system.LitexConfig.fir 5380:4]
  wire [15:0] _GEN_89 = {{4'd0}, _T_1972}; // @[Monitor.scala 636:97 freechips.rocketchip.system.LitexConfig.fir 5381:4]
  wire [15:0] _T_1977 = _GEN_89 & _T_1976; // @[Monitor.scala 636:97 freechips.rocketchip.system.LitexConfig.fir 5381:4]
  wire [15:0] _T_1978 = {{1'd0}, _T_1977[15:1]}; // @[Monitor.scala 636:152 freechips.rocketchip.system.LitexConfig.fir 5382:4]
  wire [4:0] _T_1979 = {io_in_d_bits_source, 3'h0}; // @[Monitor.scala 640:65 freechips.rocketchip.system.LitexConfig.fir 5386:4]
  wire [23:0] _T_1980 = inflight_sizes >> _T_1979; // @[Monitor.scala 640:40 freechips.rocketchip.system.LitexConfig.fir 5387:4]
  wire [15:0] _T_1984 = 16'h100 - 16'h1; // @[Monitor.scala 611:57 freechips.rocketchip.system.LitexConfig.fir 5391:4]
  wire [23:0] _GEN_91 = {{8'd0}, _T_1984}; // @[Monitor.scala 640:91 freechips.rocketchip.system.LitexConfig.fir 5392:4]
  wire [23:0] _T_1985 = _T_1980 & _GEN_91; // @[Monitor.scala 640:91 freechips.rocketchip.system.LitexConfig.fir 5392:4]
  wire [23:0] _T_1986 = {{1'd0}, _T_1985[23:1]}; // @[Monitor.scala 640:144 freechips.rocketchip.system.LitexConfig.fir 5393:4]
  wire  _T_1989 = io_in_a_valid & a_first; // @[Monitor.scala 650:26 freechips.rocketchip.system.LitexConfig.fir 5417:4]
  wire [3:0] _T_1991 = 4'h1 << io_in_a_bits_source; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 5420:6]
  wire [3:0] _GEN_27 = _T_1989 ? _T_1991 : 4'h0; // @[Monitor.scala 650:71 freechips.rocketchip.system.LitexConfig.fir 5419:4]
  wire  _T_1993 = _T_1735 & a_first; // @[Monitor.scala 654:27 freechips.rocketchip.system.LitexConfig.fir 5424:4]
  wire [3:0] _T_1996 = {io_in_a_bits_opcode, 1'h0}; // @[Monitor.scala 656:53 freechips.rocketchip.system.LitexConfig.fir 5429:6]
  wire [3:0] _T_1997 = _T_1996 | 4'h1; // @[Monitor.scala 656:61 freechips.rocketchip.system.LitexConfig.fir 5430:6]
  wire [4:0] _T_1998 = {io_in_a_bits_size, 1'h0}; // @[Monitor.scala 657:51 freechips.rocketchip.system.LitexConfig.fir 5432:6]
  wire [4:0] _T_1999 = _T_1998 | 5'h1; // @[Monitor.scala 657:59 freechips.rocketchip.system.LitexConfig.fir 5433:6]
  wire [3:0] _GEN_93 = {io_in_a_bits_source, 2'h0}; // @[Monitor.scala 658:79 freechips.rocketchip.system.LitexConfig.fir 5435:6]
  wire [4:0] _T_2000 = {{1'd0}, _GEN_93}; // @[Monitor.scala 658:79 freechips.rocketchip.system.LitexConfig.fir 5435:6]
  wire [3:0] a_opcodes_set_interm = _T_1993 ? _T_1997 : 4'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 5426:4]
  wire [34:0] _GEN_94 = {{31'd0}, a_opcodes_set_interm}; // @[Monitor.scala 658:54 freechips.rocketchip.system.LitexConfig.fir 5436:6]
  wire [34:0] _T_2001 = _GEN_94 << _T_2000; // @[Monitor.scala 658:54 freechips.rocketchip.system.LitexConfig.fir 5436:6]
  wire [4:0] _T_2002 = {io_in_a_bits_source, 3'h0}; // @[Monitor.scala 659:77 freechips.rocketchip.system.LitexConfig.fir 5438:6]
  wire [4:0] a_sizes_set_interm = _T_1993 ? _T_1999 : 5'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 5426:4]
  wire [35:0] _GEN_95 = {{31'd0}, a_sizes_set_interm}; // @[Monitor.scala 659:52 freechips.rocketchip.system.LitexConfig.fir 5439:6]
  wire [35:0] _T_2003 = _GEN_95 << _T_2002; // @[Monitor.scala 659:52 freechips.rocketchip.system.LitexConfig.fir 5439:6]
  wire [2:0] _T_2004 = inflight >> io_in_a_bits_source; // @[Monitor.scala 660:26 freechips.rocketchip.system.LitexConfig.fir 5441:6]
  wire  _T_2006 = ~_T_2004[0]; // @[Monitor.scala 660:17 freechips.rocketchip.system.LitexConfig.fir 5443:6]
  wire  _T_2008 = _T_2006 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5445:6]
  wire  _T_2009 = ~_T_2008; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5446:6]
  wire [3:0] _GEN_28 = _T_1993 ? _T_1991 : 4'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 5426:4]
  wire [34:0] _GEN_31 = _T_1993 ? _T_2001 : 35'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 5426:4]
  wire [35:0] _GEN_32 = _T_1993 ? _T_2003 : 36'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 5426:4]
  wire  _T_2011 = io_in_d_valid & d_first; // @[Monitor.scala 673:26 freechips.rocketchip.system.LitexConfig.fir 5461:4]
  wire  _T_2013 = ~_T_841; // @[Monitor.scala 673:74 freechips.rocketchip.system.LitexConfig.fir 5463:4]
  wire  _T_2014 = _T_2011 & _T_2013; // @[Monitor.scala 673:71 freechips.rocketchip.system.LitexConfig.fir 5464:4]
  wire [3:0] _T_2015 = 4'h1 << io_in_d_bits_source; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 5466:6]
  wire [3:0] _GEN_33 = _T_2014 ? _T_2015 : 4'h0; // @[Monitor.scala 673:90 freechips.rocketchip.system.LitexConfig.fir 5465:4]
  wire  _T_2017 = _T_1784 & d_first; // @[Monitor.scala 677:27 freechips.rocketchip.system.LitexConfig.fir 5470:4]
  wire  _T_2020 = _T_2017 & _T_2013; // @[Monitor.scala 677:72 freechips.rocketchip.system.LitexConfig.fir 5473:4]
  wire [46:0] _GEN_97 = {{31'd0}, _T_1976}; // @[Monitor.scala 679:76 freechips.rocketchip.system.LitexConfig.fir 5482:6]
  wire [46:0] _T_2027 = _GEN_97 << _T_1971; // @[Monitor.scala 679:76 freechips.rocketchip.system.LitexConfig.fir 5482:6]
  wire [46:0] _GEN_98 = {{31'd0}, _T_1984}; // @[Monitor.scala 680:74 freechips.rocketchip.system.LitexConfig.fir 5489:6]
  wire [46:0] _T_2033 = _GEN_98 << _T_1979; // @[Monitor.scala 680:74 freechips.rocketchip.system.LitexConfig.fir 5489:6]
  wire [3:0] _GEN_34 = _T_2020 ? _T_2015 : 4'h0; // @[Monitor.scala 677:91 freechips.rocketchip.system.LitexConfig.fir 5474:4]
  wire [46:0] _GEN_35 = _T_2020 ? _T_2027 : 47'h0; // @[Monitor.scala 677:91 freechips.rocketchip.system.LitexConfig.fir 5474:4]
  wire [46:0] _GEN_36 = _T_2020 ? _T_2033 : 47'h0; // @[Monitor.scala 677:91 freechips.rocketchip.system.LitexConfig.fir 5474:4]
  wire  _T_2040 = io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 683:113 freechips.rocketchip.system.LitexConfig.fir 5499:6]
  wire  _T_2041 = _T_1989 & _T_2040; // @[Monitor.scala 683:88 freechips.rocketchip.system.LitexConfig.fir 5500:6]
  wire [2:0] _T_2042 = inflight >> io_in_d_bits_source; // @[Monitor.scala 684:25 freechips.rocketchip.system.LitexConfig.fir 5501:6]
  wire  _T_2044 = _T_2042[0] | _T_2041; // @[Monitor.scala 684:49 freechips.rocketchip.system.LitexConfig.fir 5503:6]
  wire  _T_2046 = _T_2044 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5505:6]
  wire  _T_2047 = ~_T_2046; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5506:6]
  wire [2:0] _GEN_39 = 3'h2 == io_in_a_bits_opcode ? 3'h1 : 3'h0; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 5512:8]
  wire [2:0] _GEN_40 = 3'h3 == io_in_a_bits_opcode ? 3'h1 : _GEN_39; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 5512:8]
  wire [2:0] _GEN_41 = 3'h4 == io_in_a_bits_opcode ? 3'h1 : _GEN_40; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 5512:8]
  wire [2:0] _GEN_42 = 3'h5 == io_in_a_bits_opcode ? 3'h2 : _GEN_41; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 5512:8]
  wire [2:0] _GEN_43 = 3'h6 == io_in_a_bits_opcode ? 3'h4 : _GEN_42; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 5512:8]
  wire [2:0] _GEN_44 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_43; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 5512:8]
  wire  _T_2048 = io_in_d_bits_opcode == _GEN_44; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 5512:8]
  wire [2:0] _GEN_51 = 3'h6 == io_in_a_bits_opcode ? 3'h5 : _GEN_42; // @[Monitor.scala 688:39 freechips.rocketchip.system.LitexConfig.fir 5513:8]
  wire [2:0] _GEN_52 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_51; // @[Monitor.scala 688:39 freechips.rocketchip.system.LitexConfig.fir 5513:8]
  wire  _T_2049 = io_in_d_bits_opcode == _GEN_52; // @[Monitor.scala 688:39 freechips.rocketchip.system.LitexConfig.fir 5513:8]
  wire  _T_2050 = _T_2048 | _T_2049; // @[Monitor.scala 687:77 freechips.rocketchip.system.LitexConfig.fir 5514:8]
  wire  _T_2052 = _T_2050 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5516:8]
  wire  _T_2053 = ~_T_2052; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5517:8]
  wire  _T_2054 = io_in_a_bits_size == io_in_d_bits_size; // @[Monitor.scala 689:36 freechips.rocketchip.system.LitexConfig.fir 5522:8]
  wire  _T_2056 = _T_2054 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5524:8]
  wire  _T_2057 = ~_T_2056; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5525:8]
  wire [3:0] a_opcode_lookup = _T_1978[3:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5373:4 freechips.rocketchip.system.LitexConfig.fir 5374:4 Monitor.scala 636:21 freechips.rocketchip.system.LitexConfig.fir 5383:4]
  wire [2:0] _GEN_55 = 3'h2 == a_opcode_lookup[2:0] ? 3'h1 : 3'h0; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 5533:8]
  wire [2:0] _GEN_56 = 3'h3 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_55; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 5533:8]
  wire [2:0] _GEN_57 = 3'h4 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_56; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 5533:8]
  wire [2:0] _GEN_58 = 3'h5 == a_opcode_lookup[2:0] ? 3'h2 : _GEN_57; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 5533:8]
  wire [2:0] _GEN_59 = 3'h6 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_58; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 5533:8]
  wire [2:0] _GEN_60 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_59; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 5533:8]
  wire  _T_2059 = io_in_d_bits_opcode == _GEN_60; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 5533:8]
  wire [2:0] _GEN_67 = 3'h6 == a_opcode_lookup[2:0] ? 3'h5 : _GEN_58; // @[Monitor.scala 692:38 freechips.rocketchip.system.LitexConfig.fir 5535:8]
  wire [2:0] _GEN_68 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_67; // @[Monitor.scala 692:38 freechips.rocketchip.system.LitexConfig.fir 5535:8]
  wire  _T_2061 = io_in_d_bits_opcode == _GEN_68; // @[Monitor.scala 692:38 freechips.rocketchip.system.LitexConfig.fir 5535:8]
  wire  _T_2062 = _T_2059 | _T_2061; // @[Monitor.scala 691:72 freechips.rocketchip.system.LitexConfig.fir 5536:8]
  wire  _T_2064 = _T_2062 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5538:8]
  wire  _T_2065 = ~_T_2064; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5539:8]
  wire [7:0] a_size_lookup = _T_1986[7:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5384:4 freechips.rocketchip.system.LitexConfig.fir 5385:4 Monitor.scala 640:19 freechips.rocketchip.system.LitexConfig.fir 5394:4]
  wire [7:0] _GEN_99 = {{4'd0}, io_in_d_bits_size}; // @[Monitor.scala 693:36 freechips.rocketchip.system.LitexConfig.fir 5544:8]
  wire  _T_2066 = _GEN_99 == a_size_lookup; // @[Monitor.scala 693:36 freechips.rocketchip.system.LitexConfig.fir 5544:8]
  wire  _T_2068 = _T_2066 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5546:8]
  wire  _T_2069 = ~_T_2068; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5547:8]
  wire  _T_2071 = _T_2011 & a_first; // @[Monitor.scala 696:36 freechips.rocketchip.system.LitexConfig.fir 5555:4]
  wire  _T_2072 = _T_2071 & io_in_a_valid; // @[Monitor.scala 696:47 freechips.rocketchip.system.LitexConfig.fir 5556:4]
  wire  _T_2074 = _T_2072 & _T_2040; // @[Monitor.scala 696:65 freechips.rocketchip.system.LitexConfig.fir 5558:4]
  wire  _T_2076 = _T_2074 & _T_2013; // @[Monitor.scala 696:116 freechips.rocketchip.system.LitexConfig.fir 5560:4]
  wire  _T_2077 = ~io_in_d_ready; // @[Monitor.scala 697:15 freechips.rocketchip.system.LitexConfig.fir 5562:6]
  wire  _T_2078 = _T_2077 | io_in_a_ready; // @[Monitor.scala 697:32 freechips.rocketchip.system.LitexConfig.fir 5563:6]
  wire  _T_2080 = _T_2078 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5565:6]
  wire  _T_2081 = ~_T_2080; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5566:6]
  wire [2:0] a_set_wo_ready = _GEN_27[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5367:4 freechips.rocketchip.system.LitexConfig.fir 5368:4 Monitor.scala 651:22 freechips.rocketchip.system.LitexConfig.fir 5421:6]
  wire [2:0] d_clr_wo_ready = _GEN_33[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5454:4 freechips.rocketchip.system.LitexConfig.fir 5455:4 Monitor.scala 674:22 freechips.rocketchip.system.LitexConfig.fir 5467:6]
  wire  _T_2082 = a_set_wo_ready != d_clr_wo_ready; // @[Monitor.scala 701:29 freechips.rocketchip.system.LitexConfig.fir 5572:4]
  wire  _T_2083 = |a_set_wo_ready; // @[Monitor.scala 701:67 freechips.rocketchip.system.LitexConfig.fir 5573:4]
  wire  _T_2084 = ~_T_2083; // @[Monitor.scala 701:51 freechips.rocketchip.system.LitexConfig.fir 5574:4]
  wire  _T_2085 = _T_2082 | _T_2084; // @[Monitor.scala 701:48 freechips.rocketchip.system.LitexConfig.fir 5575:4]
  wire  _T_2087 = _T_2085 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5577:4]
  wire  _T_2088 = ~_T_2087; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5578:4]
  wire [2:0] a_set = _GEN_28[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5365:4 freechips.rocketchip.system.LitexConfig.fir 5366:4 Monitor.scala 655:28 freechips.rocketchip.system.LitexConfig.fir 5428:6]
  wire [2:0] _T_2089 = inflight | a_set; // @[Monitor.scala 704:27 freechips.rocketchip.system.LitexConfig.fir 5583:4]
  wire [2:0] d_clr = _GEN_34[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5452:4 freechips.rocketchip.system.LitexConfig.fir 5453:4 Monitor.scala 678:21 freechips.rocketchip.system.LitexConfig.fir 5476:6]
  wire [2:0] _T_2090 = ~d_clr; // @[Monitor.scala 704:38 freechips.rocketchip.system.LitexConfig.fir 5584:4]
  wire [2:0] _T_2091 = _T_2089 & _T_2090; // @[Monitor.scala 704:36 freechips.rocketchip.system.LitexConfig.fir 5585:4]
  wire [11:0] a_opcodes_set = _GEN_31[11:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5369:4 freechips.rocketchip.system.LitexConfig.fir 5370:4 Monitor.scala 658:28 freechips.rocketchip.system.LitexConfig.fir 5437:6]
  wire [11:0] _T_2092 = inflight_opcodes | a_opcodes_set; // @[Monitor.scala 705:43 freechips.rocketchip.system.LitexConfig.fir 5587:4]
  wire [11:0] d_opcodes_clr = _GEN_35[11:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5456:4 freechips.rocketchip.system.LitexConfig.fir 5457:4 Monitor.scala 679:21 freechips.rocketchip.system.LitexConfig.fir 5483:6]
  wire [11:0] _T_2093 = ~d_opcodes_clr; // @[Monitor.scala 705:62 freechips.rocketchip.system.LitexConfig.fir 5588:4]
  wire [11:0] _T_2094 = _T_2092 & _T_2093; // @[Monitor.scala 705:60 freechips.rocketchip.system.LitexConfig.fir 5589:4]
  wire [23:0] a_sizes_set = _GEN_32[23:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5371:4 freechips.rocketchip.system.LitexConfig.fir 5372:4 Monitor.scala 659:28 freechips.rocketchip.system.LitexConfig.fir 5440:6]
  wire [23:0] _T_2095 = inflight_sizes | a_sizes_set; // @[Monitor.scala 706:39 freechips.rocketchip.system.LitexConfig.fir 5591:4]
  wire [23:0] d_sizes_clr = _GEN_36[23:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5458:4 freechips.rocketchip.system.LitexConfig.fir 5459:4 Monitor.scala 680:21 freechips.rocketchip.system.LitexConfig.fir 5490:6]
  wire [23:0] _T_2096 = ~d_sizes_clr; // @[Monitor.scala 706:56 freechips.rocketchip.system.LitexConfig.fir 5592:4]
  wire [23:0] _T_2097 = _T_2095 & _T_2096; // @[Monitor.scala 706:54 freechips.rocketchip.system.LitexConfig.fir 5593:4]
  reg [31:0] _T_2098; // @[Monitor.scala 708:27 freechips.rocketchip.system.LitexConfig.fir 5595:4]
  wire  _T_2099 = |inflight; // @[Monitor.scala 711:26 freechips.rocketchip.system.LitexConfig.fir 5598:4]
  wire  _T_2100 = ~_T_2099; // @[Monitor.scala 711:16 freechips.rocketchip.system.LitexConfig.fir 5599:4]
  wire  _T_2101 = plusarg_reader_out == 32'h0; // @[Monitor.scala 711:39 freechips.rocketchip.system.LitexConfig.fir 5600:4]
  wire  _T_2102 = _T_2100 | _T_2101; // @[Monitor.scala 711:30 freechips.rocketchip.system.LitexConfig.fir 5601:4]
  wire  _T_2103 = _T_2098 < plusarg_reader_out; // @[Monitor.scala 711:59 freechips.rocketchip.system.LitexConfig.fir 5602:4]
  wire  _T_2104 = _T_2102 | _T_2103; // @[Monitor.scala 711:47 freechips.rocketchip.system.LitexConfig.fir 5603:4]
  wire  _T_2106 = _T_2104 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5605:4]
  wire  _T_2107 = ~_T_2106; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5606:4]
  wire [31:0] _T_2109 = _T_2098 + 32'h1; // @[Monitor.scala 713:26 freechips.rocketchip.system.LitexConfig.fir 5612:4]
  wire  _T_2112 = _T_1735 | _T_1784; // @[Monitor.scala 714:27 freechips.rocketchip.system.LitexConfig.fir 5616:4]
  reg [2:0] inflight_1; // @[Monitor.scala 725:35 freechips.rocketchip.system.LitexConfig.fir 5620:4]
  reg [23:0] inflight_sizes_1; // @[Monitor.scala 727:35 freechips.rocketchip.system.LitexConfig.fir 5622:4]
  reg [8:0] _T_2121; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 5631:4]
  wire [8:0] _T_2123 = _T_2121 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 5633:4]
  wire  c_first = _T_2121 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 5634:4]
  reg [8:0] _T_2139; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 5653:4]
  wire [8:0] _T_2141 = _T_2139 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 5655:4]
  wire  d_first_1 = _T_2139 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 5656:4]
  wire [23:0] _T_2158 = inflight_sizes_1 >> _T_1979; // @[Monitor.scala 749:42 freechips.rocketchip.system.LitexConfig.fir 5689:4]
  wire [23:0] _T_2163 = _T_2158 & _GEN_91; // @[Monitor.scala 749:93 freechips.rocketchip.system.LitexConfig.fir 5694:4]
  wire [23:0] _T_2164 = {{1'd0}, _T_2163[23:1]}; // @[Monitor.scala 749:146 freechips.rocketchip.system.LitexConfig.fir 5695:4]
  wire  _T_2165 = io_in_c_valid & c_first; // @[Monitor.scala 758:26 freechips.rocketchip.system.LitexConfig.fir 5701:4]
  wire  _T_2168 = io_in_c_bits_opcode[2] & io_in_c_bits_opcode[1]; // @[Edges.scala 69:40 freechips.rocketchip.system.LitexConfig.fir 5704:4]
  wire  _T_2169 = _T_2165 & _T_2168; // @[Monitor.scala 758:37 freechips.rocketchip.system.LitexConfig.fir 5705:4]
  wire [3:0] _T_2170 = 4'h1 << io_in_c_bits_source; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 5707:6]
  wire [3:0] _GEN_72 = _T_2169 ? _T_2170 : 4'h0; // @[Monitor.scala 758:71 freechips.rocketchip.system.LitexConfig.fir 5706:4]
  wire  _T_2172 = _T_1886 & c_first; // @[Monitor.scala 762:27 freechips.rocketchip.system.LitexConfig.fir 5711:4]
  wire  _T_2176 = _T_2172 & _T_2168; // @[Monitor.scala 762:38 freechips.rocketchip.system.LitexConfig.fir 5715:4]
  wire [4:0] _T_2180 = {io_in_c_bits_size, 1'h0}; // @[Monitor.scala 765:51 freechips.rocketchip.system.LitexConfig.fir 5722:6]
  wire [4:0] _T_2181 = _T_2180 | 5'h1; // @[Monitor.scala 765:59 freechips.rocketchip.system.LitexConfig.fir 5723:6]
  wire [4:0] _T_2184 = {io_in_c_bits_source, 3'h0}; // @[Monitor.scala 767:77 freechips.rocketchip.system.LitexConfig.fir 5728:6]
  wire [4:0] c_sizes_set_interm = _T_2176 ? _T_2181 : 5'h0; // @[Monitor.scala 762:72 freechips.rocketchip.system.LitexConfig.fir 5716:4]
  wire [35:0] _GEN_107 = {{31'd0}, c_sizes_set_interm}; // @[Monitor.scala 767:52 freechips.rocketchip.system.LitexConfig.fir 5729:6]
  wire [35:0] _T_2185 = _GEN_107 << _T_2184; // @[Monitor.scala 767:52 freechips.rocketchip.system.LitexConfig.fir 5729:6]
  wire [2:0] _T_2186 = inflight_1 >> io_in_c_bits_source; // @[Monitor.scala 768:26 freechips.rocketchip.system.LitexConfig.fir 5731:6]
  wire  _T_2188 = ~_T_2186[0]; // @[Monitor.scala 768:17 freechips.rocketchip.system.LitexConfig.fir 5733:6]
  wire  _T_2190 = _T_2188 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5735:6]
  wire  _T_2191 = ~_T_2190; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5736:6]
  wire [3:0] _GEN_73 = _T_2176 ? _T_2170 : 4'h0; // @[Monitor.scala 762:72 freechips.rocketchip.system.LitexConfig.fir 5716:4]
  wire [35:0] _GEN_77 = _T_2176 ? _T_2185 : 36'h0; // @[Monitor.scala 762:72 freechips.rocketchip.system.LitexConfig.fir 5716:4]
  wire  _T_2193 = io_in_d_valid & d_first_1; // @[Monitor.scala 781:26 freechips.rocketchip.system.LitexConfig.fir 5751:4]
  wire  _T_2195 = _T_2193 & _T_841; // @[Monitor.scala 781:71 freechips.rocketchip.system.LitexConfig.fir 5753:4]
  wire [3:0] _GEN_78 = _T_2195 ? _T_2015 : 4'h0; // @[Monitor.scala 781:89 freechips.rocketchip.system.LitexConfig.fir 5754:4]
  wire  _T_2198 = _T_1784 & d_first_1; // @[Monitor.scala 785:27 freechips.rocketchip.system.LitexConfig.fir 5759:4]
  wire  _T_2200 = _T_2198 & _T_841; // @[Monitor.scala 785:72 freechips.rocketchip.system.LitexConfig.fir 5761:4]
  wire [3:0] _GEN_79 = _T_2200 ? _T_2015 : 4'h0; // @[Monitor.scala 785:90 freechips.rocketchip.system.LitexConfig.fir 5762:4]
  wire [46:0] _GEN_81 = _T_2200 ? _T_2033 : 47'h0; // @[Monitor.scala 785:90 freechips.rocketchip.system.LitexConfig.fir 5762:4]
  wire  _T_2222 = io_in_c_bits_source == io_in_d_bits_source; // @[Monitor.scala 792:113 freechips.rocketchip.system.LitexConfig.fir 5789:6]
  wire  _T_2223 = _T_2169 & _T_2222; // @[Monitor.scala 792:88 freechips.rocketchip.system.LitexConfig.fir 5790:6]
  wire [2:0] _T_2224 = inflight_1 >> io_in_d_bits_source; // @[Monitor.scala 793:25 freechips.rocketchip.system.LitexConfig.fir 5791:6]
  wire  _T_2226 = _T_2224[0] | _T_2223; // @[Monitor.scala 793:49 freechips.rocketchip.system.LitexConfig.fir 5793:6]
  wire  _T_2228 = _T_2226 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5795:6]
  wire  _T_2229 = ~_T_2228; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5796:6]
  wire  _T_2230 = io_in_d_bits_size == io_in_c_bits_size; // @[Monitor.scala 795:36 freechips.rocketchip.system.LitexConfig.fir 5802:8]
  wire  _T_2232 = _T_2230 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5804:8]
  wire  _T_2233 = ~_T_2232; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5805:8]
  wire [7:0] c_size_lookup = _T_2164[7:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5677:4 freechips.rocketchip.system.LitexConfig.fir 5678:4 Monitor.scala 749:21 freechips.rocketchip.system.LitexConfig.fir 5696:4]
  wire  _T_2234 = _GEN_99 == c_size_lookup; // @[Monitor.scala 797:36 freechips.rocketchip.system.LitexConfig.fir 5812:8]
  wire  _T_2236 = _T_2234 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5814:8]
  wire  _T_2237 = ~_T_2236; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5815:8]
  wire  _T_2239 = _T_2193 & c_first; // @[Monitor.scala 801:36 freechips.rocketchip.system.LitexConfig.fir 5823:4]
  wire  _T_2240 = _T_2239 & io_in_c_valid; // @[Monitor.scala 801:47 freechips.rocketchip.system.LitexConfig.fir 5824:4]
  wire  _T_2242 = _T_2240 & _T_2222; // @[Monitor.scala 801:65 freechips.rocketchip.system.LitexConfig.fir 5826:4]
  wire  _T_2243 = _T_2242 & _T_841; // @[Monitor.scala 801:116 freechips.rocketchip.system.LitexConfig.fir 5827:4]
  wire  _T_2245 = _T_2077 | io_in_c_ready; // @[Monitor.scala 802:32 freechips.rocketchip.system.LitexConfig.fir 5830:6]
  wire  _T_2247 = _T_2245 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5832:6]
  wire  _T_2248 = ~_T_2247; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5833:6]
  wire [2:0] c_set_wo_ready = _GEN_72[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5669:4 freechips.rocketchip.system.LitexConfig.fir 5670:4 Monitor.scala 759:22 freechips.rocketchip.system.LitexConfig.fir 5708:6]
  wire  _T_2249 = |c_set_wo_ready; // @[Monitor.scala 806:28 freechips.rocketchip.system.LitexConfig.fir 5839:4]
  wire [2:0] d_clr_wo_ready_1 = _GEN_78[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5744:4 freechips.rocketchip.system.LitexConfig.fir 5745:4 Monitor.scala 782:22 freechips.rocketchip.system.LitexConfig.fir 5756:6]
  wire  _T_2250 = c_set_wo_ready != d_clr_wo_ready_1; // @[Monitor.scala 807:31 freechips.rocketchip.system.LitexConfig.fir 5841:6]
  wire  _T_2252 = _T_2250 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5843:6]
  wire  _T_2253 = ~_T_2252; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5844:6]
  wire [2:0] c_set = _GEN_73[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5667:4 freechips.rocketchip.system.LitexConfig.fir 5668:4 Monitor.scala 763:28 freechips.rocketchip.system.LitexConfig.fir 5718:6]
  wire [2:0] _T_2254 = inflight_1 | c_set; // @[Monitor.scala 811:35 freechips.rocketchip.system.LitexConfig.fir 5850:4]
  wire [2:0] d_clr_1 = _GEN_79[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5742:4 freechips.rocketchip.system.LitexConfig.fir 5743:4 Monitor.scala 786:21 freechips.rocketchip.system.LitexConfig.fir 5764:6]
  wire [2:0] _T_2255 = ~d_clr_1; // @[Monitor.scala 811:46 freechips.rocketchip.system.LitexConfig.fir 5851:4]
  wire [2:0] _T_2256 = _T_2254 & _T_2255; // @[Monitor.scala 811:44 freechips.rocketchip.system.LitexConfig.fir 5852:4]
  wire [23:0] c_sizes_set = _GEN_77[23:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5673:4 freechips.rocketchip.system.LitexConfig.fir 5674:4 Monitor.scala 767:28 freechips.rocketchip.system.LitexConfig.fir 5730:6]
  wire [23:0] _T_2260 = inflight_sizes_1 | c_sizes_set; // @[Monitor.scala 813:41 freechips.rocketchip.system.LitexConfig.fir 5858:4]
  wire [23:0] d_sizes_clr_1 = _GEN_81[23:0]; // @[freechips.rocketchip.system.LitexConfig.fir 5748:4 freechips.rocketchip.system.LitexConfig.fir 5749:4 Monitor.scala 788:21 freechips.rocketchip.system.LitexConfig.fir 5778:6]
  wire [23:0] _T_2261 = ~d_sizes_clr_1; // @[Monitor.scala 813:58 freechips.rocketchip.system.LitexConfig.fir 5859:4]
  wire [23:0] _T_2262 = _T_2260 & _T_2261; // @[Monitor.scala 813:56 freechips.rocketchip.system.LitexConfig.fir 5860:4]
  reg [31:0] _T_2263; // @[Monitor.scala 815:27 freechips.rocketchip.system.LitexConfig.fir 5862:4]
  wire  _T_2264 = |inflight_1; // @[Monitor.scala 818:26 freechips.rocketchip.system.LitexConfig.fir 5865:4]
  wire  _T_2265 = ~_T_2264; // @[Monitor.scala 818:16 freechips.rocketchip.system.LitexConfig.fir 5866:4]
  wire  _T_2266 = plusarg_reader_1_out == 32'h0; // @[Monitor.scala 818:39 freechips.rocketchip.system.LitexConfig.fir 5867:4]
  wire  _T_2267 = _T_2265 | _T_2266; // @[Monitor.scala 818:30 freechips.rocketchip.system.LitexConfig.fir 5868:4]
  wire  _T_2268 = _T_2263 < plusarg_reader_1_out; // @[Monitor.scala 818:59 freechips.rocketchip.system.LitexConfig.fir 5869:4]
  wire  _T_2269 = _T_2267 | _T_2268; // @[Monitor.scala 818:47 freechips.rocketchip.system.LitexConfig.fir 5870:4]
  wire  _T_2271 = _T_2269 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5872:4]
  wire  _T_2272 = ~_T_2271; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5873:4]
  wire [31:0] _T_2274 = _T_2263 + 32'h1; // @[Monitor.scala 820:26 freechips.rocketchip.system.LitexConfig.fir 5879:4]
  wire  _T_2277 = _T_1886 | _T_1784; // @[Monitor.scala 821:27 freechips.rocketchip.system.LitexConfig.fir 5883:4]
  reg [3:0] _T_2278; // @[Monitor.scala 825:27 freechips.rocketchip.system.LitexConfig.fir 5887:4]
  reg [8:0] _T_2287; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 5896:4]
  wire [8:0] _T_2289 = _T_2287 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 5898:4]
  wire  _T_2290 = _T_2287 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 5899:4]
  wire  _T_2300 = _T_1784 & _T_2290; // @[Monitor.scala 831:27 freechips.rocketchip.system.LitexConfig.fir 5913:4]
  wire  _T_2303 = ~io_in_d_bits_opcode[1]; // @[Edges.scala 72:43 freechips.rocketchip.system.LitexConfig.fir 5916:4]
  wire  _T_2304 = io_in_d_bits_opcode[2] & _T_2303; // @[Edges.scala 72:40 freechips.rocketchip.system.LitexConfig.fir 5917:4]
  wire  _T_2305 = _T_2300 & _T_2304; // @[Monitor.scala 831:38 freechips.rocketchip.system.LitexConfig.fir 5918:4]
  wire [3:0] _T_2306 = 4'h1 << io_in_d_bits_sink; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 5920:6]
  wire [3:0] _T_2307 = _T_2278 >> io_in_d_bits_sink; // @[Monitor.scala 833:23 freechips.rocketchip.system.LitexConfig.fir 5922:6]
  wire  _T_2309 = ~_T_2307[0]; // @[Monitor.scala 833:14 freechips.rocketchip.system.LitexConfig.fir 5924:6]
  wire  _T_2311 = _T_2309 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5926:6]
  wire  _T_2312 = ~_T_2311; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5927:6]
  wire [3:0] _GEN_84 = _T_2305 ? _T_2306 : 4'h0; // @[Monitor.scala 831:72 freechips.rocketchip.system.LitexConfig.fir 5919:4]
  wire [3:0] _T_2317 = 4'h1 << io_in_e_bits_sink; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 5939:6]
  wire [3:0] _T_2318 = _GEN_84 | _T_2278; // @[Monitor.scala 839:24 freechips.rocketchip.system.LitexConfig.fir 5941:6]
  wire [3:0] _T_2319 = _T_2318 >> io_in_e_bits_sink; // @[Monitor.scala 839:35 freechips.rocketchip.system.LitexConfig.fir 5942:6]
  wire  _T_2322 = _T_2319[0] | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5945:6]
  wire  _T_2323 = ~_T_2322; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5946:6]
  wire [3:0] _GEN_85 = io_in_e_valid ? _T_2317 : 4'h0; // @[Monitor.scala 837:73 freechips.rocketchip.system.LitexConfig.fir 5938:4]
  wire [3:0] _T_2324 = _T_2278 | _GEN_84; // @[Monitor.scala 844:27 freechips.rocketchip.system.LitexConfig.fir 5952:4]
  wire [3:0] _T_2325 = ~_GEN_85; // @[Monitor.scala 844:38 freechips.rocketchip.system.LitexConfig.fir 5953:4]
  wire [3:0] _T_2326 = _T_2324 & _T_2325; // @[Monitor.scala 844:36 freechips.rocketchip.system.LitexConfig.fir 5954:4]
  wire  _GEN_112 = io_in_a_valid & _T_109; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2600:10]
  wire  _GEN_128 = io_in_a_valid & _T_192; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2722:10]
  wire  _GEN_146 = io_in_a_valid & _T_279; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2832:10]
  wire  _GEN_160 = io_in_a_valid & _T_378; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3033:10]
  wire  _GEN_170 = io_in_a_valid & _T_478; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3155:10]
  wire  _GEN_180 = io_in_a_valid & _T_580; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3257:10]
  wire  _GEN_190 = io_in_a_valid & _T_658; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3357:10]
  wire  _GEN_200 = io_in_a_valid & _T_736; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3469:10]
  wire  _GEN_212 = io_in_d_valid & _T_841; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3538:10]
  wire  _GEN_222 = io_in_d_valid & _T_861; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3580:10]
  wire  _GEN_232 = io_in_d_valid & _T_889; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3638:10]
  wire  _GEN_242 = io_in_d_valid & _T_918; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3697:10]
  wire  _GEN_248 = io_in_d_valid & _T_935; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3732:10]
  wire  _GEN_254 = io_in_d_valid & _T_953; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3768:10]
  wire  _GEN_260 = io_in_c_valid & _T_1489; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4562:10]
  wire  _GEN_272 = io_in_c_valid & _T_1511; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4610:10]
  wire  _GEN_282 = io_in_c_valid & _T_1529; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4680:10]
  wire  _GEN_296 = io_in_c_valid & _T_1607; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4793:10]
  wire  _GEN_308 = io_in_c_valid & _T_1681; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4868:10]
  wire  _GEN_318 = io_in_c_valid & _T_1699; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4908:10]
  wire  _GEN_326 = io_in_c_valid & _T_1713; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4940:10]
  wire  _GEN_336 = _T_2014 & _T_2041; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5519:10]
  wire  _GEN_340 = ~_T_2041; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5541:10]
  wire  _GEN_341 = _T_2014 & _GEN_340; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5541:10]
  wire  _GEN_348 = _T_2195 & _T_2223; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5807:10]
  wire  _GEN_350 = ~_T_2223; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5817:10]
  wire  _GEN_351 = _T_2195 & _GEN_350; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5817:10]
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader ( // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 5596:4]
    .out(plusarg_reader_out)
  );
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader_1 ( // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 5863:4]
    .out(plusarg_reader_1_out)
  );
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  _T_1744 = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  _T_1755 = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  _T_1756 = _RAND_2[2:0];
  _RAND_3 = {1{`RANDOM}};
  _T_1757 = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  _T_1758 = _RAND_4[1:0];
  _RAND_5 = {1{`RANDOM}};
  _T_1759 = _RAND_5[31:0];
  _RAND_6 = {1{`RANDOM}};
  _T_1792 = _RAND_6[8:0];
  _RAND_7 = {1{`RANDOM}};
  _T_1803 = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  _T_1804 = _RAND_8[1:0];
  _RAND_9 = {1{`RANDOM}};
  _T_1805 = _RAND_9[3:0];
  _RAND_10 = {1{`RANDOM}};
  _T_1806 = _RAND_10[1:0];
  _RAND_11 = {1{`RANDOM}};
  _T_1807 = _RAND_11[1:0];
  _RAND_12 = {1{`RANDOM}};
  _T_1808 = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  _T_1846 = _RAND_13[8:0];
  _RAND_14 = {1{`RANDOM}};
  _T_1858 = _RAND_14[1:0];
  _RAND_15 = {1{`RANDOM}};
  _T_1861 = _RAND_15[31:0];
  _RAND_16 = {1{`RANDOM}};
  _T_1894 = _RAND_16[8:0];
  _RAND_17 = {1{`RANDOM}};
  _T_1905 = _RAND_17[2:0];
  _RAND_18 = {1{`RANDOM}};
  _T_1906 = _RAND_18[2:0];
  _RAND_19 = {1{`RANDOM}};
  _T_1907 = _RAND_19[3:0];
  _RAND_20 = {1{`RANDOM}};
  _T_1908 = _RAND_20[1:0];
  _RAND_21 = {1{`RANDOM}};
  _T_1909 = _RAND_21[31:0];
  _RAND_22 = {1{`RANDOM}};
  inflight = _RAND_22[2:0];
  _RAND_23 = {1{`RANDOM}};
  inflight_opcodes = _RAND_23[11:0];
  _RAND_24 = {1{`RANDOM}};
  inflight_sizes = _RAND_24[23:0];
  _RAND_25 = {1{`RANDOM}};
  _T_1943 = _RAND_25[8:0];
  _RAND_26 = {1{`RANDOM}};
  _T_1961 = _RAND_26[8:0];
  _RAND_27 = {1{`RANDOM}};
  _T_2098 = _RAND_27[31:0];
  _RAND_28 = {1{`RANDOM}};
  inflight_1 = _RAND_28[2:0];
  _RAND_29 = {1{`RANDOM}};
  inflight_sizes_1 = _RAND_29[23:0];
  _RAND_30 = {1{`RANDOM}};
  _T_2121 = _RAND_30[8:0];
  _RAND_31 = {1{`RANDOM}};
  _T_2139 = _RAND_31[8:0];
  _RAND_32 = {1{`RANDOM}};
  _T_2263 = _RAND_32[31:0];
  _RAND_33 = {1{`RANDOM}};
  _T_2278 = _RAND_33[3:0];
  _RAND_34 = {1{`RANDOM}};
  _T_2287 = _RAND_34[8:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
  always @(posedge clock) begin
    if (reset) begin
      _T_1744 <= 9'h0;
    end else if (_T_1735) begin
      if (_T_1747) begin
        if (_T_1742) begin
          _T_1744 <= _T_13[11:3];
        end else begin
          _T_1744 <= 9'h0;
        end
      end else begin
        _T_1744 <= _T_1746;
      end
    end
    if (_T_1783) begin
      _T_1755 <= io_in_a_bits_opcode;
    end
    if (_T_1783) begin
      _T_1756 <= io_in_a_bits_param;
    end
    if (_T_1783) begin
      _T_1757 <= io_in_a_bits_size;
    end
    if (_T_1783) begin
      _T_1758 <= io_in_a_bits_source;
    end
    if (_T_1783) begin
      _T_1759 <= io_in_a_bits_address;
    end
    if (reset) begin
      _T_1792 <= 9'h0;
    end else if (_T_1784) begin
      if (_T_1795) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_1792 <= _T_1788[11:3];
        end else begin
          _T_1792 <= 9'h0;
        end
      end else begin
        _T_1792 <= _T_1794;
      end
    end
    if (_T_1836) begin
      _T_1803 <= io_in_d_bits_opcode;
    end
    if (_T_1836) begin
      _T_1804 <= io_in_d_bits_param;
    end
    if (_T_1836) begin
      _T_1805 <= io_in_d_bits_size;
    end
    if (_T_1836) begin
      _T_1806 <= io_in_d_bits_source;
    end
    if (_T_1836) begin
      _T_1807 <= io_in_d_bits_sink;
    end
    if (_T_1836) begin
      _T_1808 <= io_in_d_bits_denied;
    end
    if (reset) begin
      _T_1846 <= 9'h0;
    end else if (_T_1837) begin
      if (_T_1849) begin
        _T_1846 <= 9'h0;
      end else begin
        _T_1846 <= _T_1848;
      end
    end
    if (_T_1885) begin
      _T_1858 <= io_in_b_bits_param;
    end
    if (_T_1885) begin
      _T_1861 <= io_in_b_bits_address;
    end
    if (reset) begin
      _T_1894 <= 9'h0;
    end else if (_T_1886) begin
      if (_T_1897) begin
        if (io_in_c_bits_opcode[0]) begin
          _T_1894 <= _T_1403[11:3];
        end else begin
          _T_1894 <= 9'h0;
        end
      end else begin
        _T_1894 <= _T_1896;
      end
    end
    if (_T_1933) begin
      _T_1905 <= io_in_c_bits_opcode;
    end
    if (_T_1933) begin
      _T_1906 <= io_in_c_bits_param;
    end
    if (_T_1933) begin
      _T_1907 <= io_in_c_bits_size;
    end
    if (_T_1933) begin
      _T_1908 <= io_in_c_bits_source;
    end
    if (_T_1933) begin
      _T_1909 <= io_in_c_bits_address;
    end
    if (reset) begin
      inflight <= 3'h0;
    end else begin
      inflight <= _T_2091;
    end
    if (reset) begin
      inflight_opcodes <= 12'h0;
    end else begin
      inflight_opcodes <= _T_2094;
    end
    if (reset) begin
      inflight_sizes <= 24'h0;
    end else begin
      inflight_sizes <= _T_2097;
    end
    if (reset) begin
      _T_1943 <= 9'h0;
    end else if (_T_1735) begin
      if (a_first) begin
        if (_T_1742) begin
          _T_1943 <= _T_13[11:3];
        end else begin
          _T_1943 <= 9'h0;
        end
      end else begin
        _T_1943 <= _T_1945;
      end
    end
    if (reset) begin
      _T_1961 <= 9'h0;
    end else if (_T_1784) begin
      if (d_first) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_1961 <= _T_1788[11:3];
        end else begin
          _T_1961 <= 9'h0;
        end
      end else begin
        _T_1961 <= _T_1963;
      end
    end
    if (reset) begin
      _T_2098 <= 32'h0;
    end else if (_T_2112) begin
      _T_2098 <= 32'h0;
    end else begin
      _T_2098 <= _T_2109;
    end
    if (reset) begin
      inflight_1 <= 3'h0;
    end else begin
      inflight_1 <= _T_2256;
    end
    if (reset) begin
      inflight_sizes_1 <= 24'h0;
    end else begin
      inflight_sizes_1 <= _T_2262;
    end
    if (reset) begin
      _T_2121 <= 9'h0;
    end else if (_T_1886) begin
      if (c_first) begin
        if (io_in_c_bits_opcode[0]) begin
          _T_2121 <= _T_1403[11:3];
        end else begin
          _T_2121 <= 9'h0;
        end
      end else begin
        _T_2121 <= _T_2123;
      end
    end
    if (reset) begin
      _T_2139 <= 9'h0;
    end else if (_T_1784) begin
      if (d_first_1) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_2139 <= _T_1788[11:3];
        end else begin
          _T_2139 <= 9'h0;
        end
      end else begin
        _T_2139 <= _T_2141;
      end
    end
    if (reset) begin
      _T_2263 <= 32'h0;
    end else if (_T_2277) begin
      _T_2263 <= 32'h0;
    end else begin
      _T_2263 <= _T_2274;
    end
    if (reset) begin
      _T_2278 <= 4'h0;
    end else begin
      _T_2278 <= _T_2326;
    end
    if (reset) begin
      _T_2287 <= 9'h0;
    end else if (_T_1784) begin
      if (_T_2290) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_2287 <= _T_1788[11:3];
        end else begin
          _T_2287 <= 9'h0;
        end
      end else begin
        _T_2287 <= _T_2289;
      end
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_142) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquireBlock type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2600:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_142) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2601:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_168) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquireBlock from a client which does not support Probe (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2635:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_168) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2636:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2642:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2643:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_175) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock smaller than a beat (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2650:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_175) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2651:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2657:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2658:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_182) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock carries invalid grow param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2665:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_182) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2666:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_187) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2674:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_187) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2675:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_191) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2682:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_191) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2683:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_142) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquirePerm type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2722:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_142) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2723:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_168) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquirePerm from a client which does not support Probe (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2757:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_168) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2758:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2764:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2765:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_175) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm smaller than a beat (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2772:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_175) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2773:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2779:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2780:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_182) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm carries invalid grow param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2787:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_182) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2788:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_269) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm requests NtoB (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2795:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_269) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2796:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_187) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2804:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_187) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2805:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_191) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2812:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_191) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2813:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_146 & _T_292) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Get type which master claims it can't emit (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2832:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_146 & _T_292) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2833:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_146 & _T_359) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Get type which slave claims it can't support (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2903:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_146 & _T_359) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2904:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_146 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2910:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_146 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2911:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_146 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2917:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_146 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2918:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_146 & _T_369) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2925:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_146 & _T_369) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2926:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_146 & _T_373) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2933:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_146 & _T_373) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2934:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_146 & _T_191) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2941:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_146 & _T_191) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 2942:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_160 & _T_463) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries PutFull type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3033:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_160 & _T_463) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3034:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_160 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3040:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_160 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3041:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_160 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3047:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_160 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3048:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_160 & _T_369) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3055:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_160 & _T_369) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3056:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_160 & _T_373) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3063:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_160 & _T_373) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3064:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_170 & _T_463) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries PutPartial type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3155:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_170 & _T_463) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3156:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_170 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3162:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_170 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3163:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_170 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3169:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_170 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3170:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_170 & _T_369) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3177:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_170 & _T_369) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3178:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_170 & _T_579) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3187:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_170 & _T_579) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3188:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_180 & _T_643) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Arithmetic type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3257:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_180 & _T_643) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3258:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_180 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3264:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_180 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3265:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_180 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3271:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_180 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3272:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_180 & _T_653) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic carries invalid opcode param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3279:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_180 & _T_653) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3280:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_180 & _T_373) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3287:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_180 & _T_373) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3288:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_190 & _T_643) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Logical type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3357:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_190 & _T_643) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3358:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_190 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3364:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_190 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3365:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_190 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3371:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_190 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3372:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_190 & _T_731) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical carries invalid opcode param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3379:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_190 & _T_731) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3380:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_190 & _T_373) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3387:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_190 & _T_373) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3388:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_200 & _T_811) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Hint type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3469:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_200 & _T_811) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3470:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_200 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3476:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_200 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3477:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_200 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3483:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_200 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3484:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_200 & _T_821) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint carries invalid opcode param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3491:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_200 & _T_821) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3492:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_200 & _T_373) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint contains invalid mask (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3499:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_200 & _T_373) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3500:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_200 & _T_191) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3507:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_200 & _T_191) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 3508:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_833) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel has invalid opcode (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3518:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_833) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3519:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_212 & _T_844) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3538:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_212 & _T_844) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3539:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_212 & _T_848) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck smaller than a beat (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3546:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_212 & _T_848) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3547:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_212 & _T_852) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseeAck carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3554:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_212 & _T_852) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3555:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_212 & _T_856) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3562:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_212 & _T_856) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3563:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_212 & _T_860) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck is denied (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3570:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_212 & _T_860) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3571:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_222 & _T_844) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3580:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_222 & _T_844) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3581:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_222 & _T_848) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant smaller than a beat (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3595:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_222 & _T_848) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3596:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_222 & _T_875) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant carries invalid cap param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3603:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_222 & _T_875) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3604:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_222 & _T_879) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant carries toN param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3611:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_222 & _T_879) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3612:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_222 & _T_856) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3619:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_222 & _T_856) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3620:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_232 & _T_844) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3638:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_232 & _T_844) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3639:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_232 & _T_848) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData smaller than a beat (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3653:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_232 & _T_848) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3654:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_232 & _T_875) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData carries invalid cap param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3661:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_232 & _T_875) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3662:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_232 & _T_879) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData carries toN param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3669:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_232 & _T_879) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3670:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_232 & _T_912) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData is denied but not corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3678:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_232 & _T_912) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3679:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_242 & _T_844) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAck carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3697:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_242 & _T_844) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3698:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_242 & _T_852) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAck carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3705:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_242 & _T_852) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3706:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_242 & _T_856) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAck is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3713:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_242 & _T_856) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3714:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_248 & _T_844) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3732:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_248 & _T_844) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3733:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_248 & _T_852) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAckData carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3740:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_248 & _T_852) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3741:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_248 & _T_912) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAckData is denied but not corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3749:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_248 & _T_912) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3750:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_254 & _T_844) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel HintAck carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3768:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_254 & _T_844) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3769:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_254 & _T_852) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel HintAck carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3776:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_254 & _T_852) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3777:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_254 & _T_856) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel HintAck is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3784:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_254 & _T_856) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 3785:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & _T_1167) begin
          $fwrite(32'h80000002,"Assertion failed: 'B' channel Probe carries unmanaged address (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 4029:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & _T_1167) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 4030:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & _T_1173) begin
          $fwrite(32'h80000002,"Assertion failed: 'B' channel Probe address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 4043:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & _T_1173) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 4044:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & _T_1177) begin
          $fwrite(32'h80000002,"Assertion failed: 'B' channel Probe carries invalid cap param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 4051:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & _T_1177) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 4052:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_260 & _T_1492) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAck carries unmanaged address (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4562:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_260 & _T_1492) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4563:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_260 & _T_1495) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAck carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4569:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_260 & _T_1495) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4570:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_260 & _T_1499) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAck smaller than a beat (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4577:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_260 & _T_1499) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4578:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_260 & _T_1502) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAck address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4584:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_260 & _T_1502) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4585:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_260 & _T_1506) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAck carries invalid report param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4592:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_260 & _T_1506) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4593:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_260 & _T_1510) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAck is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4600:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_260 & _T_1510) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4601:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_272 & _T_1492) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAckData carries unmanaged address (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4610:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_272 & _T_1492) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4611:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_272 & _T_1495) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAckData carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4617:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_272 & _T_1495) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4618:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_272 & _T_1499) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAckData smaller than a beat (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4625:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_272 & _T_1499) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4626:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_272 & _T_1502) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAckData address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4632:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_272 & _T_1502) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4633:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_272 & _T_1506) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAckData carries invalid report param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4640:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_272 & _T_1506) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4641:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_282 & _T_1562) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel carries Release type unsupported by manager (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4680:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_282 & _T_1562) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4681:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_282 & _T_1588) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel carries Release from a client which does not support Probe (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4715:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_282 & _T_1588) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4716:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_282 & _T_1495) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel Release carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4722:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_282 & _T_1495) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4723:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_282 & _T_1499) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel Release smaller than a beat (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4730:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_282 & _T_1499) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4731:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_282 & _T_1502) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel Release address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4737:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_282 & _T_1502) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4738:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_282 & _T_1602) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel Release carries invalid shrink param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4745:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_282 & _T_1602) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4746:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_282 & _T_1510) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel Release is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4753:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_282 & _T_1510) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4754:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_296 & _T_1562) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel carries ReleaseData type unsupported by manager (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4793:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_296 & _T_1562) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4794:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_296 & _T_1588) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel carries Release from a client which does not support Probe (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4828:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_296 & _T_1588) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4829:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_296 & _T_1495) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ReleaseData carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4835:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_296 & _T_1495) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4836:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_296 & _T_1499) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ReleaseData smaller than a beat (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4843:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_296 & _T_1499) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4844:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_296 & _T_1502) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ReleaseData address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4850:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_296 & _T_1502) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4851:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_296 & _T_1602) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ReleaseData carries invalid shrink param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4858:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_296 & _T_1602) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4859:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_308 & _T_1492) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAck carries unmanaged address (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4868:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_308 & _T_1492) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4869:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_308 & _T_1495) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAck carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4875:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_308 & _T_1495) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4876:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_308 & _T_1502) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAck address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4882:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_308 & _T_1502) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4883:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_308 & _T_1694) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAck carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4890:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_308 & _T_1694) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4891:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_308 & _T_1510) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAck is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4898:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_308 & _T_1510) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4899:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_318 & _T_1492) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAckData carries unmanaged address (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4908:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_318 & _T_1492) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4909:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_318 & _T_1495) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4915:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_318 & _T_1495) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4916:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_318 & _T_1502) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAckData address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4922:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_318 & _T_1502) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4923:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_318 & _T_1694) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAckData carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4930:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_318 & _T_1694) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4931:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_326 & _T_1492) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel HintAck carries unmanaged address (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4940:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_326 & _T_1492) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4941:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_326 & _T_1495) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel HintAck carries invalid source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4947:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_326 & _T_1495) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4948:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_326 & _T_1502) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel HintAck address not aligned to size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4954:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_326 & _T_1502) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4955:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_326 & _T_1694) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel HintAck carries invalid param (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4962:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_326 & _T_1694) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4963:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_326 & _T_1510) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel HintAck is corrupt (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4970:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_326 & _T_1510) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 4971:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1761 & _T_1765) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel opcode changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5021:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1761 & _T_1765) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5022:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1761 & _T_1769) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel param changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5029:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1761 & _T_1769) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5030:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1761 & _T_1773) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel size changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5037:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1761 & _T_1773) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5038:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1761 & _T_1777) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel source changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5045:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1761 & _T_1777) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5046:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1761 & _T_1781) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel address changed with multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5053:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1761 & _T_1781) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5054:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1810 & _T_1814) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel opcode changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5102:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1810 & _T_1814) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5103:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1810 & _T_1818) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel param changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5110:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1810 & _T_1818) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5111:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1810 & _T_1822) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel size changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5118:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1810 & _T_1822) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5119:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1810 & _T_1826) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel source changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5126:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1810 & _T_1826) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5127:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1810 & _T_1830) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel sink changed with multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5134:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1810 & _T_1830) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5135:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1810 & _T_1834) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel denied changed with multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5142:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1810 & _T_1834) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5143:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1863 & _T_1871) begin
          $fwrite(32'h80000002,"Assertion failed: 'B' channel param changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5200:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1863 & _T_1871) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5201:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1863 & _T_1883) begin
          $fwrite(32'h80000002,"Assertion failed: 'B' channel addresss changed with multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5224:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1863 & _T_1883) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5225:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1911 & _T_1915) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel opcode changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5272:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1911 & _T_1915) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5273:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1911 & _T_1919) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel param changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5280:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1911 & _T_1919) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5281:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1911 & _T_1923) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel size changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5288:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1911 & _T_1923) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5289:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1911 & _T_1927) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel source changed within multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5296:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1911 & _T_1927) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5297:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1911 & _T_1931) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel address changed with multibeat operation (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5304:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1911 & _T_1931) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5305:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1993 & _T_2009) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel re-used a source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5448:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1993 & _T_2009) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5449:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2014 & _T_2047) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5508:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2014 & _T_2047) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5509:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_336 & _T_2053) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5519:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_336 & _T_2053) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5520:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_336 & _T_2057) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5527:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_336 & _T_2057) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5528:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_341 & _T_2065) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5541:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_341 & _T_2065) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5542:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_341 & _T_2069) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5549:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_341 & _T_2069) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5550:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2076 & _T_2081) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5568:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2076 & _T_2081) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5569:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2088) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5580:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2088) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5581:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2107) begin
          $fwrite(32'h80000002,"Assertion failed: TileLink timeout expired (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5608:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2107) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5609:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2176 & _T_2191) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel re-used a source ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5738:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2176 & _T_2191) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5739:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2195 & _T_2229) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5798:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2195 & _T_2229) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5799:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_348 & _T_2233) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5807:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_348 & _T_2233) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5808:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_351 & _T_2237) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5817:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_351 & _T_2237) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5818:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2243 & _T_2248) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5835:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2243 & _T_2248) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5836:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2249 & _T_2253) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5846:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2249 & _T_2253) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5847:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2272) begin
          $fwrite(32'h80000002,"Assertion failed: TileLink timeout expired (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5875:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2272) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5876:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2305 & _T_2312) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel re-used a sink ID (connected at SystemBus.scala:42:55)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5929:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2305 & _T_2312) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 5930:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_e_valid & _T_2323) begin
          $fwrite(32'h80000002,"Assertion failed: 'E' channel acknowledged for nothing inflight (connected at SystemBus.scala:42:55)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5948:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_e_valid & _T_2323) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 5949:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
endmodule
module TLXbar( // @[freechips.rocketchip.system.LitexConfig.fir 5957:2]
  input         clock, // @[freechips.rocketchip.system.LitexConfig.fir 5958:4]
  input         reset, // @[freechips.rocketchip.system.LitexConfig.fir 5959:4]
  output        auto_in_1_a_ready, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_1_a_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [2:0]  auto_in_1_a_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [2:0]  auto_in_1_a_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [3:0]  auto_in_1_a_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [1:0]  auto_in_1_a_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [31:0] auto_in_1_a_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_1_a_bits_user_amba_prot_bufferable, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_1_a_bits_user_amba_prot_modifiable, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_1_a_bits_user_amba_prot_readalloc, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_1_a_bits_user_amba_prot_writealloc, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_1_a_bits_user_amba_prot_privileged, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_1_a_bits_user_amba_prot_secure, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_1_a_bits_user_amba_prot_fetch, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [7:0]  auto_in_1_a_bits_mask, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [63:0] auto_in_1_a_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_1_a_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_1_b_ready, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_in_1_b_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [1:0]  auto_in_1_b_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [31:0] auto_in_1_b_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_in_1_c_ready, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_1_c_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [2:0]  auto_in_1_c_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [2:0]  auto_in_1_c_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [3:0]  auto_in_1_c_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [1:0]  auto_in_1_c_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [31:0] auto_in_1_c_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [63:0] auto_in_1_c_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_1_c_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_1_d_ready, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_in_1_d_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [2:0]  auto_in_1_d_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [1:0]  auto_in_1_d_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [3:0]  auto_in_1_d_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [1:0]  auto_in_1_d_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [1:0]  auto_in_1_d_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_in_1_d_bits_denied, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [63:0] auto_in_1_d_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_in_1_d_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_1_e_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [1:0]  auto_in_1_e_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_in_0_a_ready, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_0_a_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [2:0]  auto_in_0_a_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [2:0]  auto_in_0_a_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [3:0]  auto_in_0_a_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [3:0]  auto_in_0_a_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [31:0] auto_in_0_a_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_0_a_bits_user_amba_prot_bufferable, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_0_a_bits_user_amba_prot_modifiable, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_0_a_bits_user_amba_prot_readalloc, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_0_a_bits_user_amba_prot_writealloc, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_0_a_bits_user_amba_prot_privileged, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_0_a_bits_user_amba_prot_secure, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_0_a_bits_user_amba_prot_fetch, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [7:0]  auto_in_0_a_bits_mask, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [63:0] auto_in_0_a_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_0_a_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_in_0_d_ready, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_in_0_d_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [2:0]  auto_in_0_d_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [1:0]  auto_in_0_d_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [3:0]  auto_in_0_d_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [3:0]  auto_in_0_d_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [1:0]  auto_in_0_d_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_in_0_d_bits_denied, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [63:0] auto_in_0_d_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_in_0_d_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_out_2_a_ready, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_2_a_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [2:0]  auto_out_2_a_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [2:0]  auto_out_2_a_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [3:0]  auto_out_2_a_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [4:0]  auto_out_2_a_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [30:0] auto_out_2_a_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_2_a_bits_user_amba_prot_bufferable, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_2_a_bits_user_amba_prot_modifiable, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_2_a_bits_user_amba_prot_readalloc, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_2_a_bits_user_amba_prot_writealloc, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_2_a_bits_user_amba_prot_privileged, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_2_a_bits_user_amba_prot_secure, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_2_a_bits_user_amba_prot_fetch, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [7:0]  auto_out_2_a_bits_mask, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [63:0] auto_out_2_a_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_2_a_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_2_d_ready, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_out_2_d_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [2:0]  auto_out_2_d_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [3:0]  auto_out_2_d_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [4:0]  auto_out_2_d_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_out_2_d_bits_denied, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [63:0] auto_out_2_d_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_out_2_d_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_out_1_a_ready, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_1_a_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [2:0]  auto_out_1_a_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [2:0]  auto_out_1_a_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [2:0]  auto_out_1_a_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [4:0]  auto_out_1_a_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [31:0] auto_out_1_a_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_1_a_bits_user_amba_prot_bufferable, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_1_a_bits_user_amba_prot_modifiable, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_1_a_bits_user_amba_prot_readalloc, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_1_a_bits_user_amba_prot_writealloc, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_1_a_bits_user_amba_prot_privileged, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_1_a_bits_user_amba_prot_secure, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_1_a_bits_user_amba_prot_fetch, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [7:0]  auto_out_1_a_bits_mask, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [63:0] auto_out_1_a_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_1_a_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_1_b_ready, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_out_1_b_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [1:0]  auto_out_1_b_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [31:0] auto_out_1_b_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_out_1_c_ready, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_1_c_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [2:0]  auto_out_1_c_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [2:0]  auto_out_1_c_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [2:0]  auto_out_1_c_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [4:0]  auto_out_1_c_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [31:0] auto_out_1_c_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [63:0] auto_out_1_c_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_1_c_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_1_d_ready, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_out_1_d_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [2:0]  auto_out_1_d_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [1:0]  auto_out_1_d_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [2:0]  auto_out_1_d_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [4:0]  auto_out_1_d_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [1:0]  auto_out_1_d_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_out_1_d_bits_denied, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [63:0] auto_out_1_d_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_out_1_d_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_1_e_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [1:0]  auto_out_1_e_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_out_0_a_ready, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_0_a_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [2:0]  auto_out_0_a_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [2:0]  auto_out_0_a_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [3:0]  auto_out_0_a_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [4:0]  auto_out_0_a_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [27:0] auto_out_0_a_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [7:0]  auto_out_0_a_bits_mask, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output [63:0] auto_out_0_a_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_0_a_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  output        auto_out_0_d_ready, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_out_0_d_valid, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [2:0]  auto_out_0_d_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [1:0]  auto_out_0_d_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [3:0]  auto_out_0_d_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [4:0]  auto_out_0_d_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_out_0_d_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_out_0_d_bits_denied, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input  [63:0] auto_out_0_d_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
  input         auto_out_0_d_bits_corrupt // @[freechips.rocketchip.system.LitexConfig.fir 5960:4]
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [31:0] _RAND_14;
  reg [31:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [31:0] _RAND_20;
  reg [31:0] _RAND_21;
`endif // RANDOMIZE_REG_INIT
  wire  TLMonitor_clock; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire  TLMonitor_reset; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire  TLMonitor_io_in_a_ready; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire  TLMonitor_io_in_a_valid; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire [2:0] TLMonitor_io_in_a_bits_opcode; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire [2:0] TLMonitor_io_in_a_bits_param; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire [3:0] TLMonitor_io_in_a_bits_size; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire [3:0] TLMonitor_io_in_a_bits_source; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire [31:0] TLMonitor_io_in_a_bits_address; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire [7:0] TLMonitor_io_in_a_bits_mask; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire  TLMonitor_io_in_a_bits_corrupt; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire  TLMonitor_io_in_d_ready; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire  TLMonitor_io_in_d_valid; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire [2:0] TLMonitor_io_in_d_bits_opcode; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire [1:0] TLMonitor_io_in_d_bits_param; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire [3:0] TLMonitor_io_in_d_bits_size; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire [3:0] TLMonitor_io_in_d_bits_source; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire [1:0] TLMonitor_io_in_d_bits_sink; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire  TLMonitor_io_in_d_bits_denied; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire  TLMonitor_io_in_d_bits_corrupt; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
  wire  TLMonitor_1_clock; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire  TLMonitor_1_reset; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire  TLMonitor_1_io_in_a_ready; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire  TLMonitor_1_io_in_a_valid; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [2:0] TLMonitor_1_io_in_a_bits_opcode; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [2:0] TLMonitor_1_io_in_a_bits_param; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [3:0] TLMonitor_1_io_in_a_bits_size; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [1:0] TLMonitor_1_io_in_a_bits_source; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [31:0] TLMonitor_1_io_in_a_bits_address; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [7:0] TLMonitor_1_io_in_a_bits_mask; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire  TLMonitor_1_io_in_a_bits_corrupt; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire  TLMonitor_1_io_in_b_ready; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire  TLMonitor_1_io_in_b_valid; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [1:0] TLMonitor_1_io_in_b_bits_param; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [31:0] TLMonitor_1_io_in_b_bits_address; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire  TLMonitor_1_io_in_c_ready; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire  TLMonitor_1_io_in_c_valid; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [2:0] TLMonitor_1_io_in_c_bits_opcode; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [2:0] TLMonitor_1_io_in_c_bits_param; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [3:0] TLMonitor_1_io_in_c_bits_size; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [1:0] TLMonitor_1_io_in_c_bits_source; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [31:0] TLMonitor_1_io_in_c_bits_address; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire  TLMonitor_1_io_in_c_bits_corrupt; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire  TLMonitor_1_io_in_d_ready; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire  TLMonitor_1_io_in_d_valid; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [2:0] TLMonitor_1_io_in_d_bits_opcode; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [1:0] TLMonitor_1_io_in_d_bits_param; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [3:0] TLMonitor_1_io_in_d_bits_size; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [1:0] TLMonitor_1_io_in_d_bits_source; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [1:0] TLMonitor_1_io_in_d_bits_sink; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire  TLMonitor_1_io_in_d_bits_denied; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire  TLMonitor_1_io_in_d_bits_corrupt; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire  TLMonitor_1_io_in_e_valid; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  wire [1:0] TLMonitor_1_io_in_e_bits_sink; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
  reg [8:0] _T_906; // @[Arbiter.scala 78:30 freechips.rocketchip.system.LitexConfig.fir 8059:4]
  wire  _T_907 = _T_906 == 9'h0; // @[Arbiter.scala 79:28 freechips.rocketchip.system.LitexConfig.fir 8060:4]
  wire  _T_204 = ~auto_out_2_d_bits_source[4]; // @[Parameters.scala 55:32 freechips.rocketchip.system.LitexConfig.fir 6665:4]
  wire  _T_407 = auto_out_2_d_valid & _T_204; // @[Xbar.scala 173:40 freechips.rocketchip.system.LitexConfig.fir 7134:4]
  wire  _T_188 = ~auto_out_1_d_bits_source[4]; // @[Parameters.scala 55:32 freechips.rocketchip.system.LitexConfig.fir 6649:4]
  wire  _T_398 = auto_out_1_d_valid & _T_188; // @[Xbar.scala 173:40 freechips.rocketchip.system.LitexConfig.fir 7105:4]
  wire  _T_172 = ~auto_out_0_d_bits_source[4]; // @[Parameters.scala 55:32 freechips.rocketchip.system.LitexConfig.fir 6633:4]
  wire  _T_389 = auto_out_0_d_valid & _T_172; // @[Xbar.scala 173:40 freechips.rocketchip.system.LitexConfig.fir 7076:4]
  wire [2:0] _T_916 = {_T_407,_T_398,_T_389}; // @[Cat.scala 29:58 freechips.rocketchip.system.LitexConfig.fir 8069:4]
  reg [2:0] _T_922; // @[Arbiter.scala 22:23 freechips.rocketchip.system.LitexConfig.fir 8079:4]
  wire [2:0] _T_923 = ~_T_922; // @[Arbiter.scala 23:30 freechips.rocketchip.system.LitexConfig.fir 8080:4]
  wire [2:0] _T_924 = _T_916 & _T_923; // @[Arbiter.scala 23:28 freechips.rocketchip.system.LitexConfig.fir 8081:4]
  wire [5:0] _T_925 = {_T_924,_T_407,_T_398,_T_389}; // @[Cat.scala 29:58 freechips.rocketchip.system.LitexConfig.fir 8082:4]
  wire [5:0] _GEN_5 = {{1'd0}, _T_925[5:1]}; // @[package.scala 231:43 freechips.rocketchip.system.LitexConfig.fir 8084:4]
  wire [5:0] _T_927 = _T_925 | _GEN_5; // @[package.scala 231:43 freechips.rocketchip.system.LitexConfig.fir 8084:4]
  wire [5:0] _GEN_6 = {{2'd0}, _T_927[5:2]}; // @[package.scala 231:43 freechips.rocketchip.system.LitexConfig.fir 8086:4]
  wire [5:0] _T_929 = _T_927 | _GEN_6; // @[package.scala 231:43 freechips.rocketchip.system.LitexConfig.fir 8086:4]
  wire [5:0] _T_932 = {_T_922, 3'h0}; // @[Arbiter.scala 24:66 freechips.rocketchip.system.LitexConfig.fir 8089:4]
  wire [5:0] _GEN_7 = {{1'd0}, _T_929[5:1]}; // @[Arbiter.scala 24:58 freechips.rocketchip.system.LitexConfig.fir 8090:4]
  wire [5:0] _T_933 = _GEN_7 | _T_932; // @[Arbiter.scala 24:58 freechips.rocketchip.system.LitexConfig.fir 8090:4]
  wire [2:0] _T_936 = _T_933[5:3] & _T_933[2:0]; // @[Arbiter.scala 25:39 freechips.rocketchip.system.LitexConfig.fir 8093:4]
  wire [2:0] _T_937 = ~_T_936; // @[Arbiter.scala 25:18 freechips.rocketchip.system.LitexConfig.fir 8094:4]
  wire  _T_953 = _T_937[0] & _T_389; // @[Arbiter.scala 88:79 freechips.rocketchip.system.LitexConfig.fir 8116:4]
  reg  _T_1008_0; // @[Arbiter.scala 107:26 freechips.rocketchip.system.LitexConfig.fir 8193:4]
  wire  _T_1009_0 = _T_907 ? _T_953 : _T_1008_0; // @[Arbiter.scala 108:30 freechips.rocketchip.system.LitexConfig.fir 8194:4]
  wire [1:0] _T_20_0_d_bits_sink = {{1'd0}, auto_out_0_d_bits_sink}; // @[Xbar.scala 282:19 freechips.rocketchip.system.LitexConfig.fir 6302:4 BundleMap.scala 248:19 freechips.rocketchip.system.LitexConfig.fir 6351:4 Xbar.scala 317:28 freechips.rocketchip.system.LitexConfig.fir 6359:4]
  wire [81:0] _T_1036 = {auto_out_0_d_bits_opcode,auto_out_0_d_bits_param,auto_out_0_d_bits_size,auto_out_0_d_bits_source,_T_20_0_d_bits_sink,auto_out_0_d_bits_denied,auto_out_0_d_bits_data,auto_out_0_d_bits_corrupt}; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8231:4]
  wire [81:0] _T_1037 = _T_1009_0 ? _T_1036 : 82'h0; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8232:4]
  wire  _T_954 = _T_937[1] & _T_398; // @[Arbiter.scala 88:79 freechips.rocketchip.system.LitexConfig.fir 8117:4]
  reg  _T_1008_1; // @[Arbiter.scala 107:26 freechips.rocketchip.system.LitexConfig.fir 8193:4]
  wire  _T_1009_1 = _T_907 ? _T_954 : _T_1008_1; // @[Arbiter.scala 108:30 freechips.rocketchip.system.LitexConfig.fir 8194:4]
  wire [3:0] _T_20_1_d_bits_size = {{1'd0}, auto_out_1_d_bits_size}; // @[Xbar.scala 282:19 freechips.rocketchip.system.LitexConfig.fir 6302:4 BundleMap.scala 248:19 freechips.rocketchip.system.LitexConfig.fir 6406:4]
  wire [81:0] _T_1044 = {auto_out_1_d_bits_opcode,auto_out_1_d_bits_param,_T_20_1_d_bits_size,auto_out_1_d_bits_source,auto_out_1_d_bits_sink,auto_out_1_d_bits_denied,auto_out_1_d_bits_data,auto_out_1_d_bits_corrupt}; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8239:4]
  wire [81:0] _T_1045 = _T_1009_1 ? _T_1044 : 82'h0; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8240:4]
  wire [81:0] _T_1054 = _T_1037 | _T_1045; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8249:4]
  wire  _T_955 = _T_937[2] & _T_407; // @[Arbiter.scala 88:79 freechips.rocketchip.system.LitexConfig.fir 8118:4]
  reg  _T_1008_2; // @[Arbiter.scala 107:26 freechips.rocketchip.system.LitexConfig.fir 8193:4]
  wire  _T_1009_2 = _T_907 ? _T_955 : _T_1008_2; // @[Arbiter.scala 108:30 freechips.rocketchip.system.LitexConfig.fir 8194:4]
  wire [81:0] _T_1052 = {auto_out_2_d_bits_opcode,2'h0,auto_out_2_d_bits_size,auto_out_2_d_bits_source,2'h0,auto_out_2_d_bits_denied,auto_out_2_d_bits_data,auto_out_2_d_bits_corrupt}; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8247:4]
  wire [81:0] _T_1053 = _T_1009_2 ? _T_1052 : 82'h0; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8248:4]
  wire [81:0] _T_1055 = _T_1054 | _T_1053; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8250:4]
  wire [4:0] _GEN_8 = {{3'd0}, auto_in_1_a_bits_source}; // @[Xbar.scala 231:55 freechips.rocketchip.system.LitexConfig.fir 6262:4]
  wire [4:0] _T_16 = _GEN_8 | 5'h10; // @[Xbar.scala 231:55 freechips.rocketchip.system.LitexConfig.fir 6262:4]
  wire [4:0] _GEN_9 = {{3'd0}, auto_in_1_c_bits_source}; // @[Xbar.scala 253:55 freechips.rocketchip.system.LitexConfig.fir 6285:4]
  reg [8:0] _T_1078; // @[Arbiter.scala 78:30 freechips.rocketchip.system.LitexConfig.fir 8388:4]
  wire  _T_1079 = _T_1078 == 9'h0; // @[Arbiter.scala 79:28 freechips.rocketchip.system.LitexConfig.fir 8389:4]
  wire  _T_212 = auto_out_2_d_bits_source[4:2] == 3'h4; // @[Parameters.scala 55:32 freechips.rocketchip.system.LitexConfig.fir 6673:4]
  wire  _T_409 = auto_out_2_d_valid & _T_212; // @[Xbar.scala 173:40 freechips.rocketchip.system.LitexConfig.fir 7145:4]
  wire  _T_196 = auto_out_1_d_bits_source[4:2] == 3'h4; // @[Parameters.scala 55:32 freechips.rocketchip.system.LitexConfig.fir 6657:4]
  wire  _T_400 = auto_out_1_d_valid & _T_196; // @[Xbar.scala 173:40 freechips.rocketchip.system.LitexConfig.fir 7116:4]
  wire  _T_180 = auto_out_0_d_bits_source[4:2] == 3'h4; // @[Parameters.scala 55:32 freechips.rocketchip.system.LitexConfig.fir 6641:4]
  wire  _T_391 = auto_out_0_d_valid & _T_180; // @[Xbar.scala 173:40 freechips.rocketchip.system.LitexConfig.fir 7087:4]
  wire [2:0] _T_1088 = {_T_409,_T_400,_T_391}; // @[Cat.scala 29:58 freechips.rocketchip.system.LitexConfig.fir 8398:4]
  reg [2:0] _T_1094; // @[Arbiter.scala 22:23 freechips.rocketchip.system.LitexConfig.fir 8408:4]
  wire [2:0] _T_1095 = ~_T_1094; // @[Arbiter.scala 23:30 freechips.rocketchip.system.LitexConfig.fir 8409:4]
  wire [2:0] _T_1096 = _T_1088 & _T_1095; // @[Arbiter.scala 23:28 freechips.rocketchip.system.LitexConfig.fir 8410:4]
  wire [5:0] _T_1097 = {_T_1096,_T_409,_T_400,_T_391}; // @[Cat.scala 29:58 freechips.rocketchip.system.LitexConfig.fir 8411:4]
  wire [5:0] _GEN_10 = {{1'd0}, _T_1097[5:1]}; // @[package.scala 231:43 freechips.rocketchip.system.LitexConfig.fir 8413:4]
  wire [5:0] _T_1099 = _T_1097 | _GEN_10; // @[package.scala 231:43 freechips.rocketchip.system.LitexConfig.fir 8413:4]
  wire [5:0] _GEN_11 = {{2'd0}, _T_1099[5:2]}; // @[package.scala 231:43 freechips.rocketchip.system.LitexConfig.fir 8415:4]
  wire [5:0] _T_1101 = _T_1099 | _GEN_11; // @[package.scala 231:43 freechips.rocketchip.system.LitexConfig.fir 8415:4]
  wire [5:0] _T_1104 = {_T_1094, 3'h0}; // @[Arbiter.scala 24:66 freechips.rocketchip.system.LitexConfig.fir 8418:4]
  wire [5:0] _GEN_12 = {{1'd0}, _T_1101[5:1]}; // @[Arbiter.scala 24:58 freechips.rocketchip.system.LitexConfig.fir 8419:4]
  wire [5:0] _T_1105 = _GEN_12 | _T_1104; // @[Arbiter.scala 24:58 freechips.rocketchip.system.LitexConfig.fir 8419:4]
  wire [2:0] _T_1108 = _T_1105[5:3] & _T_1105[2:0]; // @[Arbiter.scala 25:39 freechips.rocketchip.system.LitexConfig.fir 8422:4]
  wire [2:0] _T_1109 = ~_T_1108; // @[Arbiter.scala 25:18 freechips.rocketchip.system.LitexConfig.fir 8423:4]
  wire  _T_1125 = _T_1109[0] & _T_391; // @[Arbiter.scala 88:79 freechips.rocketchip.system.LitexConfig.fir 8445:4]
  reg  _T_1180_0; // @[Arbiter.scala 107:26 freechips.rocketchip.system.LitexConfig.fir 8522:4]
  wire  _T_1181_0 = _T_1079 ? _T_1125 : _T_1180_0; // @[Arbiter.scala 108:30 freechips.rocketchip.system.LitexConfig.fir 8523:4]
  wire [81:0] _T_1209 = _T_1181_0 ? _T_1036 : 82'h0; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8561:4]
  wire  _T_1126 = _T_1109[1] & _T_400; // @[Arbiter.scala 88:79 freechips.rocketchip.system.LitexConfig.fir 8446:4]
  reg  _T_1180_1; // @[Arbiter.scala 107:26 freechips.rocketchip.system.LitexConfig.fir 8522:4]
  wire  _T_1181_1 = _T_1079 ? _T_1126 : _T_1180_1; // @[Arbiter.scala 108:30 freechips.rocketchip.system.LitexConfig.fir 8523:4]
  wire [81:0] _T_1217 = _T_1181_1 ? _T_1044 : 82'h0; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8569:4]
  wire [81:0] _T_1226 = _T_1209 | _T_1217; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8578:4]
  wire  _T_1127 = _T_1109[2] & _T_409; // @[Arbiter.scala 88:79 freechips.rocketchip.system.LitexConfig.fir 8447:4]
  reg  _T_1180_2; // @[Arbiter.scala 107:26 freechips.rocketchip.system.LitexConfig.fir 8522:4]
  wire  _T_1181_2 = _T_1079 ? _T_1127 : _T_1180_2; // @[Arbiter.scala 108:30 freechips.rocketchip.system.LitexConfig.fir 8523:4]
  wire [81:0] _T_1225 = _T_1181_2 ? _T_1052 : 82'h0; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8577:4]
  wire [81:0] _T_1227 = _T_1226 | _T_1225; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8579:4]
  wire [32:0] _T_26 = {1'b0,$signed(auto_in_0_a_bits_address)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 6487:4]
  wire [32:0] _T_28 = $signed(_T_26) & 33'shf0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 6489:4]
  wire  _T_29 = $signed(_T_28) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 6490:4]
  wire [31:0] _T_31 = auto_in_0_a_bits_address ^ 32'h80000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 6492:4]
  wire [32:0] _T_32 = {1'b0,$signed(_T_31)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 6493:4]
  wire [32:0] _T_34 = $signed(_T_32) & 33'sh80000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 6495:4]
  wire  _T_35 = $signed(_T_34) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 6496:4]
  wire [31:0] _T_37 = auto_in_0_a_bits_address ^ 32'h10000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 6498:4]
  wire [32:0] _T_38 = {1'b0,$signed(_T_37)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 6499:4]
  wire [32:0] _T_40 = $signed(_T_38) & 33'shf0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 6501:4]
  wire  _T_41 = $signed(_T_40) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 6502:4]
  wire [31:0] _T_42 = auto_in_0_a_bits_address ^ 32'h20000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 6503:4]
  wire [32:0] _T_43 = {1'b0,$signed(_T_42)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 6504:4]
  wire [32:0] _T_45 = $signed(_T_43) & 33'she0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 6506:4]
  wire  _T_46 = $signed(_T_45) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 6507:4]
  wire [31:0] _T_47 = auto_in_0_a_bits_address ^ 32'h40000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 6508:4]
  wire [32:0] _T_48 = {1'b0,$signed(_T_47)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 6509:4]
  wire [32:0] _T_50 = $signed(_T_48) & 33'shc0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 6511:4]
  wire  _T_51 = $signed(_T_50) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 6512:4]
  wire  _T_52 = _T_41 | _T_46; // @[Xbar.scala 357:92 freechips.rocketchip.system.LitexConfig.fir 6513:4]
  wire  _T_53 = _T_52 | _T_51; // @[Xbar.scala 357:92 freechips.rocketchip.system.LitexConfig.fir 6514:4]
  wire [32:0] _T_56 = {1'b0,$signed(auto_in_1_a_bits_address)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 6517:4]
  wire [32:0] _T_58 = $signed(_T_56) & 33'shf0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 6519:4]
  wire  _T_59 = $signed(_T_58) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 6520:4]
  wire [31:0] _T_61 = auto_in_1_a_bits_address ^ 32'h80000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 6522:4]
  wire [32:0] _T_62 = {1'b0,$signed(_T_61)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 6523:4]
  wire [32:0] _T_64 = $signed(_T_62) & 33'sh80000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 6525:4]
  wire  _T_65 = $signed(_T_64) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 6526:4]
  wire [31:0] _T_67 = auto_in_1_a_bits_address ^ 32'h10000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 6528:4]
  wire [32:0] _T_68 = {1'b0,$signed(_T_67)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 6529:4]
  wire [32:0] _T_70 = $signed(_T_68) & 33'shf0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 6531:4]
  wire  _T_71 = $signed(_T_70) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 6532:4]
  wire [31:0] _T_72 = auto_in_1_a_bits_address ^ 32'h20000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 6533:4]
  wire [32:0] _T_73 = {1'b0,$signed(_T_72)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 6534:4]
  wire [32:0] _T_75 = $signed(_T_73) & 33'she0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 6536:4]
  wire  _T_76 = $signed(_T_75) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 6537:4]
  wire [31:0] _T_77 = auto_in_1_a_bits_address ^ 32'h40000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 6538:4]
  wire [32:0] _T_78 = {1'b0,$signed(_T_77)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 6539:4]
  wire [32:0] _T_80 = $signed(_T_78) & 33'shc0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 6541:4]
  wire  _T_81 = $signed(_T_80) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 6542:4]
  wire  _T_82 = _T_71 | _T_76; // @[Xbar.scala 357:92 freechips.rocketchip.system.LitexConfig.fir 6543:4]
  wire  _T_83 = _T_82 | _T_81; // @[Xbar.scala 357:92 freechips.rocketchip.system.LitexConfig.fir 6544:4]
  wire [26:0] _T_234 = 27'hfff << auto_in_0_a_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 6695:4]
  wire [11:0] _T_236 = ~_T_234[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 6697:4]
  wire  _T_239 = ~auto_in_0_a_bits_opcode[2]; // @[Edges.scala 93:28 freechips.rocketchip.system.LitexConfig.fir 6700:4]
  wire [8:0] _T_240 = _T_239 ? _T_236[11:3] : 9'h0; // @[Edges.scala 222:14 freechips.rocketchip.system.LitexConfig.fir 6701:4]
  wire [26:0] _T_242 = 27'hfff << auto_in_1_a_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 6703:4]
  wire [11:0] _T_244 = ~_T_242[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 6705:4]
  wire  _T_247 = ~auto_in_1_a_bits_opcode[2]; // @[Edges.scala 93:28 freechips.rocketchip.system.LitexConfig.fir 6708:4]
  wire [8:0] _T_248 = _T_247 ? _T_244[11:3] : 9'h0; // @[Edges.scala 222:14 freechips.rocketchip.system.LitexConfig.fir 6709:4]
  wire [26:0] _T_288 = 27'hfff << auto_out_0_d_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 6749:4]
  wire [11:0] _T_290 = ~_T_288[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 6751:4]
  wire [8:0] _T_293 = auto_out_0_d_bits_opcode[0] ? _T_290[11:3] : 9'h0; // @[Edges.scala 222:14 freechips.rocketchip.system.LitexConfig.fir 6754:4]
  wire [20:0] _T_295 = 21'h3f << _T_20_1_d_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 6756:4]
  wire [5:0] _T_297 = ~_T_295[5:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 6758:4]
  wire [2:0] _T_300 = auto_out_1_d_bits_opcode[0] ? _T_297[5:3] : 3'h0; // @[Edges.scala 222:14 freechips.rocketchip.system.LitexConfig.fir 6761:4]
  wire [22:0] _T_302 = 23'hff << auto_out_2_d_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 6763:4]
  wire [7:0] _T_304 = ~_T_302[7:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 6765:4]
  wire [4:0] _T_307 = auto_out_2_d_bits_opcode[0] ? _T_304[7:3] : 5'h0; // @[Edges.scala 222:14 freechips.rocketchip.system.LitexConfig.fir 6768:4]
  wire  _T_310 = auto_in_0_a_valid & _T_29; // @[Xbar.scala 422:50 freechips.rocketchip.system.LitexConfig.fir 6787:4]
  wire  _T_312 = auto_in_0_a_valid & _T_35; // @[Xbar.scala 422:50 freechips.rocketchip.system.LitexConfig.fir 6806:4]
  wire  _T_314 = auto_in_0_a_valid & _T_53; // @[Xbar.scala 422:50 freechips.rocketchip.system.LitexConfig.fir 6825:4]
  reg [8:0] _T_440; // @[Arbiter.scala 78:30 freechips.rocketchip.system.LitexConfig.fir 7195:4]
  wire  _T_441 = _T_440 == 9'h0; // @[Arbiter.scala 79:28 freechips.rocketchip.system.LitexConfig.fir 7196:4]
  wire  _T_323 = auto_in_1_a_valid & _T_59; // @[Xbar.scala 422:50 freechips.rocketchip.system.LitexConfig.fir 6853:4]
  wire [1:0] _T_447 = {_T_323,_T_310}; // @[Cat.scala 29:58 freechips.rocketchip.system.LitexConfig.fir 7202:4]
  reg [1:0] _T_453; // @[Arbiter.scala 22:23 freechips.rocketchip.system.LitexConfig.fir 7212:4]
  wire [1:0] _T_454 = ~_T_453; // @[Arbiter.scala 23:30 freechips.rocketchip.system.LitexConfig.fir 7213:4]
  wire [1:0] _T_455 = _T_447 & _T_454; // @[Arbiter.scala 23:28 freechips.rocketchip.system.LitexConfig.fir 7214:4]
  wire [3:0] _T_456 = {_T_455,_T_323,_T_310}; // @[Cat.scala 29:58 freechips.rocketchip.system.LitexConfig.fir 7215:4]
  wire [3:0] _GEN_13 = {{1'd0}, _T_456[3:1]}; // @[package.scala 231:43 freechips.rocketchip.system.LitexConfig.fir 7217:4]
  wire [3:0] _T_458 = _T_456 | _GEN_13; // @[package.scala 231:43 freechips.rocketchip.system.LitexConfig.fir 7217:4]
  wire [3:0] _T_461 = {_T_453, 2'h0}; // @[Arbiter.scala 24:66 freechips.rocketchip.system.LitexConfig.fir 7220:4]
  wire [3:0] _GEN_14 = {{1'd0}, _T_458[3:1]}; // @[Arbiter.scala 24:58 freechips.rocketchip.system.LitexConfig.fir 7221:4]
  wire [3:0] _T_462 = _GEN_14 | _T_461; // @[Arbiter.scala 24:58 freechips.rocketchip.system.LitexConfig.fir 7221:4]
  wire [1:0] _T_465 = _T_462[3:2] & _T_462[1:0]; // @[Arbiter.scala 25:39 freechips.rocketchip.system.LitexConfig.fir 7224:4]
  wire [1:0] _T_466 = ~_T_465; // @[Arbiter.scala 25:18 freechips.rocketchip.system.LitexConfig.fir 7225:4]
  reg  _T_520_0; // @[Arbiter.scala 107:26 freechips.rocketchip.system.LitexConfig.fir 7303:4]
  wire  _T_523_0 = _T_441 ? _T_466[0] : _T_520_0; // @[Arbiter.scala 112:24 freechips.rocketchip.system.LitexConfig.fir 7308:4]
  wire  _T_524 = auto_out_0_a_ready & _T_523_0; // @[Arbiter.scala 114:31 freechips.rocketchip.system.LitexConfig.fir 7309:4]
  wire  _T_315 = _T_29 & _T_524; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 6827:4]
  reg [8:0] _T_592; // @[Arbiter.scala 78:30 freechips.rocketchip.system.LitexConfig.fir 7454:4]
  wire  _T_593 = _T_592 == 9'h0; // @[Arbiter.scala 79:28 freechips.rocketchip.system.LitexConfig.fir 7455:4]
  wire  _T_325 = auto_in_1_a_valid & _T_65; // @[Xbar.scala 422:50 freechips.rocketchip.system.LitexConfig.fir 6872:4]
  wire [1:0] _T_599 = {_T_325,_T_312}; // @[Cat.scala 29:58 freechips.rocketchip.system.LitexConfig.fir 7461:4]
  reg [1:0] _T_605; // @[Arbiter.scala 22:23 freechips.rocketchip.system.LitexConfig.fir 7471:4]
  wire [1:0] _T_606 = ~_T_605; // @[Arbiter.scala 23:30 freechips.rocketchip.system.LitexConfig.fir 7472:4]
  wire [1:0] _T_607 = _T_599 & _T_606; // @[Arbiter.scala 23:28 freechips.rocketchip.system.LitexConfig.fir 7473:4]
  wire [3:0] _T_608 = {_T_607,_T_325,_T_312}; // @[Cat.scala 29:58 freechips.rocketchip.system.LitexConfig.fir 7474:4]
  wire [3:0] _GEN_15 = {{1'd0}, _T_608[3:1]}; // @[package.scala 231:43 freechips.rocketchip.system.LitexConfig.fir 7476:4]
  wire [3:0] _T_610 = _T_608 | _GEN_15; // @[package.scala 231:43 freechips.rocketchip.system.LitexConfig.fir 7476:4]
  wire [3:0] _T_613 = {_T_605, 2'h0}; // @[Arbiter.scala 24:66 freechips.rocketchip.system.LitexConfig.fir 7479:4]
  wire [3:0] _GEN_16 = {{1'd0}, _T_610[3:1]}; // @[Arbiter.scala 24:58 freechips.rocketchip.system.LitexConfig.fir 7480:4]
  wire [3:0] _T_614 = _GEN_16 | _T_613; // @[Arbiter.scala 24:58 freechips.rocketchip.system.LitexConfig.fir 7480:4]
  wire [1:0] _T_617 = _T_614[3:2] & _T_614[1:0]; // @[Arbiter.scala 25:39 freechips.rocketchip.system.LitexConfig.fir 7483:4]
  wire [1:0] _T_618 = ~_T_617; // @[Arbiter.scala 25:18 freechips.rocketchip.system.LitexConfig.fir 7484:4]
  reg  _T_672_0; // @[Arbiter.scala 107:26 freechips.rocketchip.system.LitexConfig.fir 7562:4]
  wire  _T_675_0 = _T_593 ? _T_618[0] : _T_672_0; // @[Arbiter.scala 112:24 freechips.rocketchip.system.LitexConfig.fir 7567:4]
  wire  _T_676 = auto_out_1_a_ready & _T_675_0; // @[Arbiter.scala 114:31 freechips.rocketchip.system.LitexConfig.fir 7568:4]
  wire  _T_316 = _T_35 & _T_676; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 6828:4]
  reg [8:0] _T_746; // @[Arbiter.scala 78:30 freechips.rocketchip.system.LitexConfig.fir 7729:4]
  wire  _T_747 = _T_746 == 9'h0; // @[Arbiter.scala 79:28 freechips.rocketchip.system.LitexConfig.fir 7730:4]
  wire  _T_327 = auto_in_1_a_valid & _T_83; // @[Xbar.scala 422:50 freechips.rocketchip.system.LitexConfig.fir 6891:4]
  wire [1:0] _T_753 = {_T_327,_T_314}; // @[Cat.scala 29:58 freechips.rocketchip.system.LitexConfig.fir 7736:4]
  reg [1:0] _T_759; // @[Arbiter.scala 22:23 freechips.rocketchip.system.LitexConfig.fir 7746:4]
  wire [1:0] _T_760 = ~_T_759; // @[Arbiter.scala 23:30 freechips.rocketchip.system.LitexConfig.fir 7747:4]
  wire [1:0] _T_761 = _T_753 & _T_760; // @[Arbiter.scala 23:28 freechips.rocketchip.system.LitexConfig.fir 7748:4]
  wire [3:0] _T_762 = {_T_761,_T_327,_T_314}; // @[Cat.scala 29:58 freechips.rocketchip.system.LitexConfig.fir 7749:4]
  wire [3:0] _GEN_17 = {{1'd0}, _T_762[3:1]}; // @[package.scala 231:43 freechips.rocketchip.system.LitexConfig.fir 7751:4]
  wire [3:0] _T_764 = _T_762 | _GEN_17; // @[package.scala 231:43 freechips.rocketchip.system.LitexConfig.fir 7751:4]
  wire [3:0] _T_767 = {_T_759, 2'h0}; // @[Arbiter.scala 24:66 freechips.rocketchip.system.LitexConfig.fir 7754:4]
  wire [3:0] _GEN_18 = {{1'd0}, _T_764[3:1]}; // @[Arbiter.scala 24:58 freechips.rocketchip.system.LitexConfig.fir 7755:4]
  wire [3:0] _T_768 = _GEN_18 | _T_767; // @[Arbiter.scala 24:58 freechips.rocketchip.system.LitexConfig.fir 7755:4]
  wire [1:0] _T_771 = _T_768[3:2] & _T_768[1:0]; // @[Arbiter.scala 25:39 freechips.rocketchip.system.LitexConfig.fir 7758:4]
  wire [1:0] _T_772 = ~_T_771; // @[Arbiter.scala 25:18 freechips.rocketchip.system.LitexConfig.fir 7759:4]
  reg  _T_826_0; // @[Arbiter.scala 107:26 freechips.rocketchip.system.LitexConfig.fir 7837:4]
  wire  _T_829_0 = _T_747 ? _T_772[0] : _T_826_0; // @[Arbiter.scala 112:24 freechips.rocketchip.system.LitexConfig.fir 7842:4]
  wire  _T_830 = auto_out_2_a_ready & _T_829_0; // @[Arbiter.scala 114:31 freechips.rocketchip.system.LitexConfig.fir 7843:4]
  wire  _T_317 = _T_53 & _T_830; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 6829:4]
  wire  _T_318 = _T_315 | _T_316; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 6830:4]
  reg  _T_520_1; // @[Arbiter.scala 107:26 freechips.rocketchip.system.LitexConfig.fir 7303:4]
  wire  _T_523_1 = _T_441 ? _T_466[1] : _T_520_1; // @[Arbiter.scala 112:24 freechips.rocketchip.system.LitexConfig.fir 7308:4]
  wire  _T_525 = auto_out_0_a_ready & _T_523_1; // @[Arbiter.scala 114:31 freechips.rocketchip.system.LitexConfig.fir 7311:4]
  wire  _T_328 = _T_59 & _T_525; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 6893:4]
  reg  _T_672_1; // @[Arbiter.scala 107:26 freechips.rocketchip.system.LitexConfig.fir 7562:4]
  wire  _T_675_1 = _T_593 ? _T_618[1] : _T_672_1; // @[Arbiter.scala 112:24 freechips.rocketchip.system.LitexConfig.fir 7567:4]
  wire  _T_677 = auto_out_1_a_ready & _T_675_1; // @[Arbiter.scala 114:31 freechips.rocketchip.system.LitexConfig.fir 7570:4]
  wire  _T_329 = _T_65 & _T_677; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 6894:4]
  reg  _T_826_1; // @[Arbiter.scala 107:26 freechips.rocketchip.system.LitexConfig.fir 7837:4]
  wire  _T_829_1 = _T_747 ? _T_772[1] : _T_826_1; // @[Arbiter.scala 112:24 freechips.rocketchip.system.LitexConfig.fir 7842:4]
  wire  _T_831 = auto_out_2_a_ready & _T_829_1; // @[Arbiter.scala 114:31 freechips.rocketchip.system.LitexConfig.fir 7845:4]
  wire  _T_330 = _T_83 & _T_831; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 6895:4]
  wire  _T_331 = _T_328 | _T_329; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 6896:4]
  wire  _T_1011_0 = _T_907 ? _T_937[0] : _T_1008_0; // @[Arbiter.scala 112:24 freechips.rocketchip.system.LitexConfig.fir 8199:4]
  wire  _T_1012 = auto_in_0_d_ready & _T_1011_0; // @[Arbiter.scala 114:31 freechips.rocketchip.system.LitexConfig.fir 8200:4]
  wire  _T_392 = _T_172 & _T_1012; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7089:4]
  wire  _T_1183_0 = _T_1079 ? _T_1109[0] : _T_1180_0; // @[Arbiter.scala 112:24 freechips.rocketchip.system.LitexConfig.fir 8528:4]
  wire  _T_1184 = auto_in_1_d_ready & _T_1183_0; // @[Arbiter.scala 114:31 freechips.rocketchip.system.LitexConfig.fir 8529:4]
  wire  _T_393 = _T_180 & _T_1184; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7090:4]
  wire  _T_1011_1 = _T_907 ? _T_937[1] : _T_1008_1; // @[Arbiter.scala 112:24 freechips.rocketchip.system.LitexConfig.fir 8199:4]
  wire  _T_1013 = auto_in_0_d_ready & _T_1011_1; // @[Arbiter.scala 114:31 freechips.rocketchip.system.LitexConfig.fir 8202:4]
  wire  _T_401 = _T_188 & _T_1013; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7118:4]
  wire  _T_1183_1 = _T_1079 ? _T_1109[1] : _T_1180_1; // @[Arbiter.scala 112:24 freechips.rocketchip.system.LitexConfig.fir 8528:4]
  wire  _T_1185 = auto_in_1_d_ready & _T_1183_1; // @[Arbiter.scala 114:31 freechips.rocketchip.system.LitexConfig.fir 8531:4]
  wire  _T_402 = _T_196 & _T_1185; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7119:4]
  wire  _T_1011_2 = _T_907 ? _T_937[2] : _T_1008_2; // @[Arbiter.scala 112:24 freechips.rocketchip.system.LitexConfig.fir 8199:4]
  wire  _T_1014 = auto_in_0_d_ready & _T_1011_2; // @[Arbiter.scala 114:31 freechips.rocketchip.system.LitexConfig.fir 8204:4]
  wire  _T_410 = _T_204 & _T_1014; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7147:4]
  wire  _T_1183_2 = _T_1079 ? _T_1109[2] : _T_1180_2; // @[Arbiter.scala 112:24 freechips.rocketchip.system.LitexConfig.fir 8528:4]
  wire  _T_1186 = auto_in_1_d_ready & _T_1183_2; // @[Arbiter.scala 114:31 freechips.rocketchip.system.LitexConfig.fir 8533:4]
  wire  _T_411 = _T_212 & _T_1186; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7148:4]
  wire  _T_442 = _T_441 & auto_out_0_a_ready; // @[Arbiter.scala 80:24 freechips.rocketchip.system.LitexConfig.fir 7197:4]
  wire  _T_467 = |_T_447; // @[Arbiter.scala 26:27 freechips.rocketchip.system.LitexConfig.fir 7226:4]
  wire  _T_468 = _T_442 & _T_467; // @[Arbiter.scala 26:18 freechips.rocketchip.system.LitexConfig.fir 7227:4]
  wire [1:0] _T_469 = _T_466 & _T_447; // @[Arbiter.scala 27:29 freechips.rocketchip.system.LitexConfig.fir 7229:6]
  wire [2:0] _T_470 = {_T_469, 1'h0}; // @[package.scala 222:48 freechips.rocketchip.system.LitexConfig.fir 7230:6]
  wire [1:0] _T_472 = _T_469 | _T_470[1:0]; // @[package.scala 222:43 freechips.rocketchip.system.LitexConfig.fir 7232:6]
  wire  _T_478 = _T_466[0] & _T_310; // @[Arbiter.scala 88:79 freechips.rocketchip.system.LitexConfig.fir 7242:4]
  wire  _T_479 = _T_466[1] & _T_323; // @[Arbiter.scala 88:79 freechips.rocketchip.system.LitexConfig.fir 7243:4]
  wire  _T_485 = _T_478 | _T_479; // @[Arbiter.scala 95:53 freechips.rocketchip.system.LitexConfig.fir 7253:4]
  wire  _T_487 = ~_T_478; // @[Arbiter.scala 96:67 freechips.rocketchip.system.LitexConfig.fir 7255:4]
  wire  _T_490 = ~_T_479; // @[Arbiter.scala 96:67 freechips.rocketchip.system.LitexConfig.fir 7258:4]
  wire  _T_491 = _T_487 | _T_490; // @[Arbiter.scala 96:64 freechips.rocketchip.system.LitexConfig.fir 7259:4]
  wire  _T_494 = _T_491 | reset; // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 7262:4]
  wire  _T_495 = ~_T_494; // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 7263:4]
  wire  _T_496 = _T_310 | _T_323; // @[Arbiter.scala 98:36 freechips.rocketchip.system.LitexConfig.fir 7268:4]
  wire  _T_497 = ~_T_496; // @[Arbiter.scala 98:15 freechips.rocketchip.system.LitexConfig.fir 7269:4]
  wire  _T_499 = _T_497 | _T_485; // @[Arbiter.scala 98:41 freechips.rocketchip.system.LitexConfig.fir 7271:4]
  wire  _T_501 = _T_499 | reset; // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 7273:4]
  wire  _T_502 = ~_T_501; // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 7274:4]
  wire  _T_506 = _T_497 | _T_496; // @[Arbiter.scala 99:41 freechips.rocketchip.system.LitexConfig.fir 7282:4]
  wire  _T_508 = _T_506 | reset; // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 7284:4]
  wire  _T_509 = ~_T_508; // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 7285:4]
  wire [8:0] _T_510 = _T_478 ? _T_240 : 9'h0; // @[Arbiter.scala 102:73 freechips.rocketchip.system.LitexConfig.fir 7290:4]
  wire [8:0] _T_511 = _T_479 ? _T_248 : 9'h0; // @[Arbiter.scala 102:73 freechips.rocketchip.system.LitexConfig.fir 7291:4]
  wire [8:0] _T_512 = _T_510 | _T_511; // @[Arbiter.scala 103:44 freechips.rocketchip.system.LitexConfig.fir 7292:4]
  wire  _T_521_0 = _T_441 ? _T_478 : _T_520_0; // @[Arbiter.scala 108:30 freechips.rocketchip.system.LitexConfig.fir 7304:4]
  wire  _T_521_1 = _T_441 ? _T_479 : _T_520_1; // @[Arbiter.scala 108:30 freechips.rocketchip.system.LitexConfig.fir 7304:4]
  wire  _T_527 = _T_520_0 & _T_310; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7314:4]
  wire  _T_528 = _T_520_1 & _T_323; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7315:4]
  wire  _T_529 = _T_527 | _T_528; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7316:4]
  wire  _T_531 = _T_441 ? _T_496 : _T_529; // @[Arbiter.scala 116:29 freechips.rocketchip.system.LitexConfig.fir 7319:4]
  wire  _T_515 = auto_out_0_a_ready & _T_531; // @[ReadyValidCancel.scala 52:33 freechips.rocketchip.system.LitexConfig.fir 7295:4]
  wire [8:0] _GEN_19 = {{8'd0}, _T_515}; // @[Arbiter.scala 104:52 freechips.rocketchip.system.LitexConfig.fir 7296:4]
  wire [8:0] _T_517 = _T_440 - _GEN_19; // @[Arbiter.scala 104:52 freechips.rocketchip.system.LitexConfig.fir 7297:4]
  wire [76:0] _T_541 = {auto_in_0_a_bits_user_amba_prot_writealloc,auto_in_0_a_bits_user_amba_prot_privileged,auto_in_0_a_bits_user_amba_prot_secure,auto_in_0_a_bits_user_amba_prot_fetch,auto_in_0_a_bits_mask,auto_in_0_a_bits_data,auto_in_0_a_bits_corrupt}; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7332:4]
  wire [4:0] _T_13_0_a_bits_source = {{1'd0}, auto_in_0_a_bits_source}; // @[Xbar.scala 225:18 freechips.rocketchip.system.LitexConfig.fir 6173:4 BundleMap.scala 248:19 freechips.rocketchip.system.LitexConfig.fir 6185:4 Xbar.scala 231:29 freechips.rocketchip.system.LitexConfig.fir 6193:4]
  wire [126:0] _T_549 = {auto_in_0_a_bits_opcode,auto_in_0_a_bits_param,auto_in_0_a_bits_size,_T_13_0_a_bits_source,auto_in_0_a_bits_address,auto_in_0_a_bits_user_amba_prot_bufferable,auto_in_0_a_bits_user_amba_prot_modifiable,auto_in_0_a_bits_user_amba_prot_readalloc,_T_541}; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7340:4]
  wire [126:0] _T_550 = _T_521_0 ? _T_549 : 127'h0; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7341:4]
  wire [76:0] _T_556 = {auto_in_1_a_bits_user_amba_prot_writealloc,auto_in_1_a_bits_user_amba_prot_privileged,auto_in_1_a_bits_user_amba_prot_secure,auto_in_1_a_bits_user_amba_prot_fetch,auto_in_1_a_bits_mask,auto_in_1_a_bits_data,auto_in_1_a_bits_corrupt}; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7347:4]
  wire [126:0] _T_564 = {auto_in_1_a_bits_opcode,auto_in_1_a_bits_param,auto_in_1_a_bits_size,_T_16,auto_in_1_a_bits_address,auto_in_1_a_bits_user_amba_prot_bufferable,auto_in_1_a_bits_user_amba_prot_modifiable,auto_in_1_a_bits_user_amba_prot_readalloc,_T_556}; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7355:4]
  wire [126:0] _T_565 = _T_521_1 ? _T_564 : 127'h0; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7356:4]
  wire [126:0] _T_566 = _T_550 | _T_565; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7357:4]
  wire  _T_594 = _T_593 & auto_out_1_a_ready; // @[Arbiter.scala 80:24 freechips.rocketchip.system.LitexConfig.fir 7456:4]
  wire  _T_619 = |_T_599; // @[Arbiter.scala 26:27 freechips.rocketchip.system.LitexConfig.fir 7485:4]
  wire  _T_620 = _T_594 & _T_619; // @[Arbiter.scala 26:18 freechips.rocketchip.system.LitexConfig.fir 7486:4]
  wire [1:0] _T_621 = _T_618 & _T_599; // @[Arbiter.scala 27:29 freechips.rocketchip.system.LitexConfig.fir 7488:6]
  wire [2:0] _T_622 = {_T_621, 1'h0}; // @[package.scala 222:48 freechips.rocketchip.system.LitexConfig.fir 7489:6]
  wire [1:0] _T_624 = _T_621 | _T_622[1:0]; // @[package.scala 222:43 freechips.rocketchip.system.LitexConfig.fir 7491:6]
  wire  _T_630 = _T_618[0] & _T_312; // @[Arbiter.scala 88:79 freechips.rocketchip.system.LitexConfig.fir 7501:4]
  wire  _T_631 = _T_618[1] & _T_325; // @[Arbiter.scala 88:79 freechips.rocketchip.system.LitexConfig.fir 7502:4]
  wire  _T_637 = _T_630 | _T_631; // @[Arbiter.scala 95:53 freechips.rocketchip.system.LitexConfig.fir 7512:4]
  wire  _T_639 = ~_T_630; // @[Arbiter.scala 96:67 freechips.rocketchip.system.LitexConfig.fir 7514:4]
  wire  _T_642 = ~_T_631; // @[Arbiter.scala 96:67 freechips.rocketchip.system.LitexConfig.fir 7517:4]
  wire  _T_643 = _T_639 | _T_642; // @[Arbiter.scala 96:64 freechips.rocketchip.system.LitexConfig.fir 7518:4]
  wire  _T_646 = _T_643 | reset; // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 7521:4]
  wire  _T_647 = ~_T_646; // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 7522:4]
  wire  _T_648 = _T_312 | _T_325; // @[Arbiter.scala 98:36 freechips.rocketchip.system.LitexConfig.fir 7527:4]
  wire  _T_649 = ~_T_648; // @[Arbiter.scala 98:15 freechips.rocketchip.system.LitexConfig.fir 7528:4]
  wire  _T_651 = _T_649 | _T_637; // @[Arbiter.scala 98:41 freechips.rocketchip.system.LitexConfig.fir 7530:4]
  wire  _T_653 = _T_651 | reset; // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 7532:4]
  wire  _T_654 = ~_T_653; // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 7533:4]
  wire  _T_658 = _T_649 | _T_648; // @[Arbiter.scala 99:41 freechips.rocketchip.system.LitexConfig.fir 7541:4]
  wire  _T_660 = _T_658 | reset; // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 7543:4]
  wire  _T_661 = ~_T_660; // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 7544:4]
  wire [8:0] _T_662 = _T_630 ? _T_240 : 9'h0; // @[Arbiter.scala 102:73 freechips.rocketchip.system.LitexConfig.fir 7549:4]
  wire [8:0] _T_663 = _T_631 ? _T_248 : 9'h0; // @[Arbiter.scala 102:73 freechips.rocketchip.system.LitexConfig.fir 7550:4]
  wire [8:0] _T_664 = _T_662 | _T_663; // @[Arbiter.scala 103:44 freechips.rocketchip.system.LitexConfig.fir 7551:4]
  wire  _T_673_0 = _T_593 ? _T_630 : _T_672_0; // @[Arbiter.scala 108:30 freechips.rocketchip.system.LitexConfig.fir 7563:4]
  wire  _T_673_1 = _T_593 ? _T_631 : _T_672_1; // @[Arbiter.scala 108:30 freechips.rocketchip.system.LitexConfig.fir 7563:4]
  wire  _T_679 = _T_672_0 & _T_312; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7573:4]
  wire  _T_680 = _T_672_1 & _T_325; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7574:4]
  wire  _T_681 = _T_679 | _T_680; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7575:4]
  wire  _T_683 = _T_593 ? _T_648 : _T_681; // @[Arbiter.scala 116:29 freechips.rocketchip.system.LitexConfig.fir 7578:4]
  wire  _T_667 = auto_out_1_a_ready & _T_683; // @[ReadyValidCancel.scala 52:33 freechips.rocketchip.system.LitexConfig.fir 7554:4]
  wire [8:0] _GEN_20 = {{8'd0}, _T_667}; // @[Arbiter.scala 104:52 freechips.rocketchip.system.LitexConfig.fir 7555:4]
  wire [8:0] _T_669 = _T_592 - _GEN_20; // @[Arbiter.scala 104:52 freechips.rocketchip.system.LitexConfig.fir 7556:4]
  wire [126:0] _T_702 = _T_673_0 ? _T_549 : 127'h0; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7600:4]
  wire [126:0] _T_717 = _T_673_1 ? _T_564 : 127'h0; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7615:4]
  wire [126:0] _T_718 = _T_702 | _T_717; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7616:4]
  wire  _T_748 = _T_747 & auto_out_2_a_ready; // @[Arbiter.scala 80:24 freechips.rocketchip.system.LitexConfig.fir 7731:4]
  wire  _T_773 = |_T_753; // @[Arbiter.scala 26:27 freechips.rocketchip.system.LitexConfig.fir 7760:4]
  wire  _T_774 = _T_748 & _T_773; // @[Arbiter.scala 26:18 freechips.rocketchip.system.LitexConfig.fir 7761:4]
  wire [1:0] _T_775 = _T_772 & _T_753; // @[Arbiter.scala 27:29 freechips.rocketchip.system.LitexConfig.fir 7763:6]
  wire [2:0] _T_776 = {_T_775, 1'h0}; // @[package.scala 222:48 freechips.rocketchip.system.LitexConfig.fir 7764:6]
  wire [1:0] _T_778 = _T_775 | _T_776[1:0]; // @[package.scala 222:43 freechips.rocketchip.system.LitexConfig.fir 7766:6]
  wire  _T_784 = _T_772[0] & _T_314; // @[Arbiter.scala 88:79 freechips.rocketchip.system.LitexConfig.fir 7776:4]
  wire  _T_785 = _T_772[1] & _T_327; // @[Arbiter.scala 88:79 freechips.rocketchip.system.LitexConfig.fir 7777:4]
  wire  _T_791 = _T_784 | _T_785; // @[Arbiter.scala 95:53 freechips.rocketchip.system.LitexConfig.fir 7787:4]
  wire  _T_793 = ~_T_784; // @[Arbiter.scala 96:67 freechips.rocketchip.system.LitexConfig.fir 7789:4]
  wire  _T_796 = ~_T_785; // @[Arbiter.scala 96:67 freechips.rocketchip.system.LitexConfig.fir 7792:4]
  wire  _T_797 = _T_793 | _T_796; // @[Arbiter.scala 96:64 freechips.rocketchip.system.LitexConfig.fir 7793:4]
  wire  _T_800 = _T_797 | reset; // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 7796:4]
  wire  _T_801 = ~_T_800; // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 7797:4]
  wire  _T_802 = _T_314 | _T_327; // @[Arbiter.scala 98:36 freechips.rocketchip.system.LitexConfig.fir 7802:4]
  wire  _T_803 = ~_T_802; // @[Arbiter.scala 98:15 freechips.rocketchip.system.LitexConfig.fir 7803:4]
  wire  _T_805 = _T_803 | _T_791; // @[Arbiter.scala 98:41 freechips.rocketchip.system.LitexConfig.fir 7805:4]
  wire  _T_807 = _T_805 | reset; // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 7807:4]
  wire  _T_808 = ~_T_807; // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 7808:4]
  wire  _T_812 = _T_803 | _T_802; // @[Arbiter.scala 99:41 freechips.rocketchip.system.LitexConfig.fir 7816:4]
  wire  _T_814 = _T_812 | reset; // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 7818:4]
  wire  _T_815 = ~_T_814; // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 7819:4]
  wire [8:0] _T_816 = _T_784 ? _T_240 : 9'h0; // @[Arbiter.scala 102:73 freechips.rocketchip.system.LitexConfig.fir 7824:4]
  wire [8:0] _T_817 = _T_785 ? _T_248 : 9'h0; // @[Arbiter.scala 102:73 freechips.rocketchip.system.LitexConfig.fir 7825:4]
  wire [8:0] _T_818 = _T_816 | _T_817; // @[Arbiter.scala 103:44 freechips.rocketchip.system.LitexConfig.fir 7826:4]
  wire  _T_827_0 = _T_747 ? _T_784 : _T_826_0; // @[Arbiter.scala 108:30 freechips.rocketchip.system.LitexConfig.fir 7838:4]
  wire  _T_827_1 = _T_747 ? _T_785 : _T_826_1; // @[Arbiter.scala 108:30 freechips.rocketchip.system.LitexConfig.fir 7838:4]
  wire  _T_833 = _T_826_0 & _T_314; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7848:4]
  wire  _T_834 = _T_826_1 & _T_327; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7849:4]
  wire  _T_835 = _T_833 | _T_834; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7850:4]
  wire  _T_837 = _T_747 ? _T_802 : _T_835; // @[Arbiter.scala 116:29 freechips.rocketchip.system.LitexConfig.fir 7853:4]
  wire  _T_821 = auto_out_2_a_ready & _T_837; // @[ReadyValidCancel.scala 52:33 freechips.rocketchip.system.LitexConfig.fir 7829:4]
  wire [8:0] _GEN_21 = {{8'd0}, _T_821}; // @[Arbiter.scala 104:52 freechips.rocketchip.system.LitexConfig.fir 7830:4]
  wire [8:0] _T_823 = _T_746 - _GEN_21; // @[Arbiter.scala 104:52 freechips.rocketchip.system.LitexConfig.fir 7831:4]
  wire [126:0] _T_856 = _T_827_0 ? _T_549 : 127'h0; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7875:4]
  wire [126:0] _T_871 = _T_827_1 ? _T_564 : 127'h0; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7890:4]
  wire [126:0] _T_872 = _T_856 | _T_871; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 7891:4]
  wire  _T_908 = _T_907 & auto_in_0_d_ready; // @[Arbiter.scala 80:24 freechips.rocketchip.system.LitexConfig.fir 8061:4]
  wire  _T_938 = |_T_916; // @[Arbiter.scala 26:27 freechips.rocketchip.system.LitexConfig.fir 8095:4]
  wire  _T_939 = _T_908 & _T_938; // @[Arbiter.scala 26:18 freechips.rocketchip.system.LitexConfig.fir 8096:4]
  wire [2:0] _T_940 = _T_937 & _T_916; // @[Arbiter.scala 27:29 freechips.rocketchip.system.LitexConfig.fir 8098:6]
  wire [3:0] _T_941 = {_T_940, 1'h0}; // @[package.scala 222:48 freechips.rocketchip.system.LitexConfig.fir 8099:6]
  wire [2:0] _T_943 = _T_940 | _T_941[2:0]; // @[package.scala 222:43 freechips.rocketchip.system.LitexConfig.fir 8101:6]
  wire [4:0] _T_944 = {_T_943, 2'h0}; // @[package.scala 222:48 freechips.rocketchip.system.LitexConfig.fir 8102:6]
  wire [2:0] _T_946 = _T_943 | _T_944[2:0]; // @[package.scala 222:43 freechips.rocketchip.system.LitexConfig.fir 8104:6]
  wire  _T_962 = _T_953 | _T_954; // @[Arbiter.scala 95:53 freechips.rocketchip.system.LitexConfig.fir 8131:4]
  wire  _T_963 = _T_962 | _T_955; // @[Arbiter.scala 95:53 freechips.rocketchip.system.LitexConfig.fir 8132:4]
  wire  _T_965 = ~_T_953; // @[Arbiter.scala 96:67 freechips.rocketchip.system.LitexConfig.fir 8134:4]
  wire  _T_968 = ~_T_954; // @[Arbiter.scala 96:67 freechips.rocketchip.system.LitexConfig.fir 8137:4]
  wire  _T_969 = _T_965 | _T_968; // @[Arbiter.scala 96:64 freechips.rocketchip.system.LitexConfig.fir 8138:4]
  wire  _T_970 = ~_T_962; // @[Arbiter.scala 96:61 freechips.rocketchip.system.LitexConfig.fir 8139:4]
  wire  _T_971 = ~_T_955; // @[Arbiter.scala 96:67 freechips.rocketchip.system.LitexConfig.fir 8140:4]
  wire  _T_972 = _T_970 | _T_971; // @[Arbiter.scala 96:64 freechips.rocketchip.system.LitexConfig.fir 8141:4]
  wire  _T_974 = _T_969 & _T_972; // @[Arbiter.scala 96:82 freechips.rocketchip.system.LitexConfig.fir 8143:4]
  wire  _T_976 = _T_974 | reset; // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 8145:4]
  wire  _T_977 = ~_T_976; // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 8146:4]
  wire  _T_978 = _T_389 | _T_398; // @[Arbiter.scala 98:36 freechips.rocketchip.system.LitexConfig.fir 8151:4]
  wire  _T_979 = _T_978 | _T_407; // @[Arbiter.scala 98:36 freechips.rocketchip.system.LitexConfig.fir 8152:4]
  wire  _T_980 = ~_T_979; // @[Arbiter.scala 98:15 freechips.rocketchip.system.LitexConfig.fir 8153:4]
  wire  _T_983 = _T_980 | _T_963; // @[Arbiter.scala 98:41 freechips.rocketchip.system.LitexConfig.fir 8156:4]
  wire  _T_985 = _T_983 | reset; // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 8158:4]
  wire  _T_986 = ~_T_985; // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 8159:4]
  wire  _T_992 = _T_980 | _T_979; // @[Arbiter.scala 99:41 freechips.rocketchip.system.LitexConfig.fir 8169:4]
  wire  _T_994 = _T_992 | reset; // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 8171:4]
  wire  _T_995 = ~_T_994; // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 8172:4]
  wire [8:0] _T_996 = _T_953 ? _T_293 : 9'h0; // @[Arbiter.scala 102:73 freechips.rocketchip.system.LitexConfig.fir 8177:4]
  wire [2:0] _T_997 = _T_954 ? _T_300 : 3'h0; // @[Arbiter.scala 102:73 freechips.rocketchip.system.LitexConfig.fir 8178:4]
  wire [4:0] _T_998 = _T_955 ? _T_307 : 5'h0; // @[Arbiter.scala 102:73 freechips.rocketchip.system.LitexConfig.fir 8179:4]
  wire [8:0] _GEN_22 = {{6'd0}, _T_997}; // @[Arbiter.scala 103:44 freechips.rocketchip.system.LitexConfig.fir 8180:4]
  wire [8:0] _T_999 = _T_996 | _GEN_22; // @[Arbiter.scala 103:44 freechips.rocketchip.system.LitexConfig.fir 8180:4]
  wire [8:0] _GEN_23 = {{4'd0}, _T_998}; // @[Arbiter.scala 103:44 freechips.rocketchip.system.LitexConfig.fir 8181:4]
  wire [8:0] _T_1000 = _T_999 | _GEN_23; // @[Arbiter.scala 103:44 freechips.rocketchip.system.LitexConfig.fir 8181:4]
  wire  _T_1017 = _T_1008_0 & _T_389; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8208:4]
  wire  _T_1018 = _T_1008_1 & _T_398; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8209:4]
  wire  _T_1020 = _T_1017 | _T_1018; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8211:4]
  wire  _T_1019 = _T_1008_2 & _T_407; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8210:4]
  wire  _T_1021 = _T_1020 | _T_1019; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8212:4]
  wire  _T_1023 = _T_907 ? _T_979 : _T_1021; // @[Arbiter.scala 116:29 freechips.rocketchip.system.LitexConfig.fir 8215:4]
  wire  _T_1003 = auto_in_0_d_ready & _T_1023; // @[ReadyValidCancel.scala 52:33 freechips.rocketchip.system.LitexConfig.fir 8184:4]
  wire [8:0] _GEN_24 = {{8'd0}, _T_1003}; // @[Arbiter.scala 104:52 freechips.rocketchip.system.LitexConfig.fir 8185:4]
  wire [8:0] _T_1005 = _T_906 - _GEN_24; // @[Arbiter.scala 104:52 freechips.rocketchip.system.LitexConfig.fir 8186:4]
  wire  _T_1080 = _T_1079 & auto_in_1_d_ready; // @[Arbiter.scala 80:24 freechips.rocketchip.system.LitexConfig.fir 8390:4]
  wire  _T_1110 = |_T_1088; // @[Arbiter.scala 26:27 freechips.rocketchip.system.LitexConfig.fir 8424:4]
  wire  _T_1111 = _T_1080 & _T_1110; // @[Arbiter.scala 26:18 freechips.rocketchip.system.LitexConfig.fir 8425:4]
  wire [2:0] _T_1112 = _T_1109 & _T_1088; // @[Arbiter.scala 27:29 freechips.rocketchip.system.LitexConfig.fir 8427:6]
  wire [3:0] _T_1113 = {_T_1112, 1'h0}; // @[package.scala 222:48 freechips.rocketchip.system.LitexConfig.fir 8428:6]
  wire [2:0] _T_1115 = _T_1112 | _T_1113[2:0]; // @[package.scala 222:43 freechips.rocketchip.system.LitexConfig.fir 8430:6]
  wire [4:0] _T_1116 = {_T_1115, 2'h0}; // @[package.scala 222:48 freechips.rocketchip.system.LitexConfig.fir 8431:6]
  wire [2:0] _T_1118 = _T_1115 | _T_1116[2:0]; // @[package.scala 222:43 freechips.rocketchip.system.LitexConfig.fir 8433:6]
  wire  _T_1134 = _T_1125 | _T_1126; // @[Arbiter.scala 95:53 freechips.rocketchip.system.LitexConfig.fir 8460:4]
  wire  _T_1135 = _T_1134 | _T_1127; // @[Arbiter.scala 95:53 freechips.rocketchip.system.LitexConfig.fir 8461:4]
  wire  _T_1137 = ~_T_1125; // @[Arbiter.scala 96:67 freechips.rocketchip.system.LitexConfig.fir 8463:4]
  wire  _T_1140 = ~_T_1126; // @[Arbiter.scala 96:67 freechips.rocketchip.system.LitexConfig.fir 8466:4]
  wire  _T_1141 = _T_1137 | _T_1140; // @[Arbiter.scala 96:64 freechips.rocketchip.system.LitexConfig.fir 8467:4]
  wire  _T_1142 = ~_T_1134; // @[Arbiter.scala 96:61 freechips.rocketchip.system.LitexConfig.fir 8468:4]
  wire  _T_1143 = ~_T_1127; // @[Arbiter.scala 96:67 freechips.rocketchip.system.LitexConfig.fir 8469:4]
  wire  _T_1144 = _T_1142 | _T_1143; // @[Arbiter.scala 96:64 freechips.rocketchip.system.LitexConfig.fir 8470:4]
  wire  _T_1146 = _T_1141 & _T_1144; // @[Arbiter.scala 96:82 freechips.rocketchip.system.LitexConfig.fir 8472:4]
  wire  _T_1148 = _T_1146 | reset; // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 8474:4]
  wire  _T_1149 = ~_T_1148; // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 8475:4]
  wire  _T_1150 = _T_391 | _T_400; // @[Arbiter.scala 98:36 freechips.rocketchip.system.LitexConfig.fir 8480:4]
  wire  _T_1151 = _T_1150 | _T_409; // @[Arbiter.scala 98:36 freechips.rocketchip.system.LitexConfig.fir 8481:4]
  wire  _T_1152 = ~_T_1151; // @[Arbiter.scala 98:15 freechips.rocketchip.system.LitexConfig.fir 8482:4]
  wire  _T_1155 = _T_1152 | _T_1135; // @[Arbiter.scala 98:41 freechips.rocketchip.system.LitexConfig.fir 8485:4]
  wire  _T_1157 = _T_1155 | reset; // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 8487:4]
  wire  _T_1158 = ~_T_1157; // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 8488:4]
  wire  _T_1164 = _T_1152 | _T_1151; // @[Arbiter.scala 99:41 freechips.rocketchip.system.LitexConfig.fir 8498:4]
  wire  _T_1166 = _T_1164 | reset; // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 8500:4]
  wire  _T_1167 = ~_T_1166; // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 8501:4]
  wire [8:0] _T_1168 = _T_1125 ? _T_293 : 9'h0; // @[Arbiter.scala 102:73 freechips.rocketchip.system.LitexConfig.fir 8506:4]
  wire [2:0] _T_1169 = _T_1126 ? _T_300 : 3'h0; // @[Arbiter.scala 102:73 freechips.rocketchip.system.LitexConfig.fir 8507:4]
  wire [4:0] _T_1170 = _T_1127 ? _T_307 : 5'h0; // @[Arbiter.scala 102:73 freechips.rocketchip.system.LitexConfig.fir 8508:4]
  wire [8:0] _GEN_25 = {{6'd0}, _T_1169}; // @[Arbiter.scala 103:44 freechips.rocketchip.system.LitexConfig.fir 8509:4]
  wire [8:0] _T_1171 = _T_1168 | _GEN_25; // @[Arbiter.scala 103:44 freechips.rocketchip.system.LitexConfig.fir 8509:4]
  wire [8:0] _GEN_26 = {{4'd0}, _T_1170}; // @[Arbiter.scala 103:44 freechips.rocketchip.system.LitexConfig.fir 8510:4]
  wire [8:0] _T_1172 = _T_1171 | _GEN_26; // @[Arbiter.scala 103:44 freechips.rocketchip.system.LitexConfig.fir 8510:4]
  wire  _T_1189 = _T_1180_0 & _T_391; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8537:4]
  wire  _T_1190 = _T_1180_1 & _T_400; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8538:4]
  wire  _T_1192 = _T_1189 | _T_1190; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8540:4]
  wire  _T_1191 = _T_1180_2 & _T_409; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8539:4]
  wire  _T_1193 = _T_1192 | _T_1191; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 8541:4]
  wire  _T_1195 = _T_1079 ? _T_1151 : _T_1193; // @[Arbiter.scala 116:29 freechips.rocketchip.system.LitexConfig.fir 8544:4]
  wire  _T_1175 = auto_in_1_d_ready & _T_1195; // @[ReadyValidCancel.scala 52:33 freechips.rocketchip.system.LitexConfig.fir 8513:4]
  wire [8:0] _GEN_27 = {{8'd0}, _T_1175}; // @[Arbiter.scala 104:52 freechips.rocketchip.system.LitexConfig.fir 8514:4]
  wire [8:0] _T_1177 = _T_1078 - _GEN_27; // @[Arbiter.scala 104:52 freechips.rocketchip.system.LitexConfig.fir 8515:4]
  TLMonitor TLMonitor ( // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5969:4]
    .clock(TLMonitor_clock),
    .reset(TLMonitor_reset),
    .io_in_a_ready(TLMonitor_io_in_a_ready),
    .io_in_a_valid(TLMonitor_io_in_a_valid),
    .io_in_a_bits_opcode(TLMonitor_io_in_a_bits_opcode),
    .io_in_a_bits_param(TLMonitor_io_in_a_bits_param),
    .io_in_a_bits_size(TLMonitor_io_in_a_bits_size),
    .io_in_a_bits_source(TLMonitor_io_in_a_bits_source),
    .io_in_a_bits_address(TLMonitor_io_in_a_bits_address),
    .io_in_a_bits_mask(TLMonitor_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(TLMonitor_io_in_a_bits_corrupt),
    .io_in_d_ready(TLMonitor_io_in_d_ready),
    .io_in_d_valid(TLMonitor_io_in_d_valid),
    .io_in_d_bits_opcode(TLMonitor_io_in_d_bits_opcode),
    .io_in_d_bits_param(TLMonitor_io_in_d_bits_param),
    .io_in_d_bits_size(TLMonitor_io_in_d_bits_size),
    .io_in_d_bits_source(TLMonitor_io_in_d_bits_source),
    .io_in_d_bits_sink(TLMonitor_io_in_d_bits_sink),
    .io_in_d_bits_denied(TLMonitor_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(TLMonitor_io_in_d_bits_corrupt)
  );
  TLMonitor_1 TLMonitor_1 ( // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 5999:4]
    .clock(TLMonitor_1_clock),
    .reset(TLMonitor_1_reset),
    .io_in_a_ready(TLMonitor_1_io_in_a_ready),
    .io_in_a_valid(TLMonitor_1_io_in_a_valid),
    .io_in_a_bits_opcode(TLMonitor_1_io_in_a_bits_opcode),
    .io_in_a_bits_param(TLMonitor_1_io_in_a_bits_param),
    .io_in_a_bits_size(TLMonitor_1_io_in_a_bits_size),
    .io_in_a_bits_source(TLMonitor_1_io_in_a_bits_source),
    .io_in_a_bits_address(TLMonitor_1_io_in_a_bits_address),
    .io_in_a_bits_mask(TLMonitor_1_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(TLMonitor_1_io_in_a_bits_corrupt),
    .io_in_b_ready(TLMonitor_1_io_in_b_ready),
    .io_in_b_valid(TLMonitor_1_io_in_b_valid),
    .io_in_b_bits_param(TLMonitor_1_io_in_b_bits_param),
    .io_in_b_bits_address(TLMonitor_1_io_in_b_bits_address),
    .io_in_c_ready(TLMonitor_1_io_in_c_ready),
    .io_in_c_valid(TLMonitor_1_io_in_c_valid),
    .io_in_c_bits_opcode(TLMonitor_1_io_in_c_bits_opcode),
    .io_in_c_bits_param(TLMonitor_1_io_in_c_bits_param),
    .io_in_c_bits_size(TLMonitor_1_io_in_c_bits_size),
    .io_in_c_bits_source(TLMonitor_1_io_in_c_bits_source),
    .io_in_c_bits_address(TLMonitor_1_io_in_c_bits_address),
    .io_in_c_bits_corrupt(TLMonitor_1_io_in_c_bits_corrupt),
    .io_in_d_ready(TLMonitor_1_io_in_d_ready),
    .io_in_d_valid(TLMonitor_1_io_in_d_valid),
    .io_in_d_bits_opcode(TLMonitor_1_io_in_d_bits_opcode),
    .io_in_d_bits_param(TLMonitor_1_io_in_d_bits_param),
    .io_in_d_bits_size(TLMonitor_1_io_in_d_bits_size),
    .io_in_d_bits_source(TLMonitor_1_io_in_d_bits_source),
    .io_in_d_bits_sink(TLMonitor_1_io_in_d_bits_sink),
    .io_in_d_bits_denied(TLMonitor_1_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(TLMonitor_1_io_in_d_bits_corrupt),
    .io_in_e_valid(TLMonitor_1_io_in_e_valid),
    .io_in_e_bits_sink(TLMonitor_1_io_in_e_bits_sink)
  );
  assign auto_in_1_a_ready = _T_331 | _T_330; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6061:4]
  assign auto_in_1_b_valid = auto_out_1_b_valid; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6061:4]
  assign auto_in_1_b_bits_param = auto_out_1_b_bits_param; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6061:4]
  assign auto_in_1_b_bits_address = auto_out_1_b_bits_address; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6061:4]
  assign auto_in_1_c_ready = auto_out_1_c_ready; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6061:4]
  assign auto_in_1_d_valid = _T_1079 ? _T_1151 : _T_1193; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6061:4]
  assign auto_in_1_d_bits_opcode = _T_1227[81:79]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6061:4]
  assign auto_in_1_d_bits_param = _T_1227[78:77]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6061:4]
  assign auto_in_1_d_bits_size = _T_1227[76:73]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6061:4]
  assign auto_in_1_d_bits_source = _T_1227[69:68]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6061:4]
  assign auto_in_1_d_bits_sink = _T_1227[67:66]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6061:4]
  assign auto_in_1_d_bits_denied = _T_1227[65]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6061:4]
  assign auto_in_1_d_bits_data = _T_1227[64:1]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6061:4]
  assign auto_in_1_d_bits_corrupt = _T_1227[0]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6061:4]
  assign auto_in_0_a_ready = _T_318 | _T_317; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6060:4]
  assign auto_in_0_d_valid = _T_907 ? _T_979 : _T_1021; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6060:4]
  assign auto_in_0_d_bits_opcode = _T_1055[81:79]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6060:4]
  assign auto_in_0_d_bits_param = _T_1055[78:77]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6060:4]
  assign auto_in_0_d_bits_size = _T_1055[76:73]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6060:4]
  assign auto_in_0_d_bits_source = _T_1055[71:68]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6060:4]
  assign auto_in_0_d_bits_sink = _T_1055[67:66]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6060:4]
  assign auto_in_0_d_bits_denied = _T_1055[65]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6060:4]
  assign auto_in_0_d_bits_data = _T_1055[64:1]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6060:4]
  assign auto_in_0_d_bits_corrupt = _T_1055[0]; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 6060:4]
  assign auto_out_2_a_valid = _T_747 ? _T_802 : _T_835; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_a_bits_opcode = _T_872[126:124]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_a_bits_param = _T_872[123:121]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_a_bits_size = _T_872[120:117]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_a_bits_source = _T_872[116:112]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_a_bits_address = _T_872[110:80]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_a_bits_user_amba_prot_bufferable = _T_872[79]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_a_bits_user_amba_prot_modifiable = _T_872[78]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_a_bits_user_amba_prot_readalloc = _T_872[77]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_a_bits_user_amba_prot_writealloc = _T_872[76]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_a_bits_user_amba_prot_privileged = _T_872[75]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_a_bits_user_amba_prot_secure = _T_872[74]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_a_bits_user_amba_prot_fetch = _T_872[73]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_a_bits_mask = _T_872[72:65]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_a_bits_data = _T_872[64:1]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_a_bits_corrupt = _T_872[0]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_2_d_ready = _T_410 | _T_411; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6059:4]
  assign auto_out_1_a_valid = _T_593 ? _T_648 : _T_681; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_a_bits_opcode = _T_718[126:124]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_a_bits_param = _T_718[123:121]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_a_bits_size = _T_718[119:117]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_a_bits_source = _T_718[116:112]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_a_bits_address = _T_718[111:80]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_a_bits_user_amba_prot_bufferable = _T_718[79]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_a_bits_user_amba_prot_modifiable = _T_718[78]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_a_bits_user_amba_prot_readalloc = _T_718[77]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_a_bits_user_amba_prot_writealloc = _T_718[76]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_a_bits_user_amba_prot_privileged = _T_718[75]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_a_bits_user_amba_prot_secure = _T_718[74]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_a_bits_user_amba_prot_fetch = _T_718[73]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_a_bits_mask = _T_718[72:65]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_a_bits_data = _T_718[64:1]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_a_bits_corrupt = _T_718[0]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_b_ready = auto_in_1_b_ready; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_c_valid = auto_in_1_c_valid; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_c_bits_opcode = auto_in_1_c_bits_opcode; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_c_bits_param = auto_in_1_c_bits_param; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_c_bits_size = auto_in_1_c_bits_size[2:0]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_c_bits_source = _GEN_9 | 5'h10; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_c_bits_address = auto_in_1_c_bits_address; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_c_bits_data = auto_in_1_c_bits_data; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_c_bits_corrupt = auto_in_1_c_bits_corrupt; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_d_ready = _T_401 | _T_402; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_e_valid = auto_in_1_e_valid; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_1_e_bits_sink = auto_in_1_e_bits_sink; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6058:4]
  assign auto_out_0_a_valid = _T_441 ? _T_496 : _T_529; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6057:4]
  assign auto_out_0_a_bits_opcode = _T_566[126:124]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6057:4]
  assign auto_out_0_a_bits_param = _T_566[123:121]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6057:4]
  assign auto_out_0_a_bits_size = _T_566[120:117]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6057:4]
  assign auto_out_0_a_bits_source = _T_566[116:112]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6057:4]
  assign auto_out_0_a_bits_address = _T_566[107:80]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6057:4]
  assign auto_out_0_a_bits_mask = _T_566[72:65]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6057:4]
  assign auto_out_0_a_bits_data = _T_566[64:1]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6057:4]
  assign auto_out_0_a_bits_corrupt = _T_566[0]; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6057:4]
  assign auto_out_0_d_ready = _T_392 | _T_393; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 6057:4]
  assign TLMonitor_clock = clock; // @[freechips.rocketchip.system.LitexConfig.fir 5970:4]
  assign TLMonitor_reset = reset; // @[freechips.rocketchip.system.LitexConfig.fir 5971:4]
  assign TLMonitor_io_in_a_ready = _T_318 | _T_317; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5998:4]
  assign TLMonitor_io_in_a_valid = auto_in_0_a_valid; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5997:4]
  assign TLMonitor_io_in_a_bits_opcode = auto_in_0_a_bits_opcode; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5996:4]
  assign TLMonitor_io_in_a_bits_param = auto_in_0_a_bits_param; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5995:4]
  assign TLMonitor_io_in_a_bits_size = auto_in_0_a_bits_size; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5994:4]
  assign TLMonitor_io_in_a_bits_source = auto_in_0_a_bits_source; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5993:4]
  assign TLMonitor_io_in_a_bits_address = auto_in_0_a_bits_address; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5992:4]
  assign TLMonitor_io_in_a_bits_mask = auto_in_0_a_bits_mask; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5984:4]
  assign TLMonitor_io_in_a_bits_corrupt = auto_in_0_a_bits_corrupt; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5982:4]
  assign TLMonitor_io_in_d_ready = auto_in_0_d_ready; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5981:4]
  assign TLMonitor_io_in_d_valid = _T_907 ? _T_979 : _T_1021; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5980:4]
  assign TLMonitor_io_in_d_bits_opcode = _T_1055[81:79]; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5979:4]
  assign TLMonitor_io_in_d_bits_param = _T_1055[78:77]; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5978:4]
  assign TLMonitor_io_in_d_bits_size = _T_1055[76:73]; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5977:4]
  assign TLMonitor_io_in_d_bits_source = _T_1055[71:68]; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5976:4]
  assign TLMonitor_io_in_d_bits_sink = _T_1055[67:66]; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5975:4]
  assign TLMonitor_io_in_d_bits_denied = _T_1055[65]; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5974:4]
  assign TLMonitor_io_in_d_bits_corrupt = _T_1055[0]; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 5972:4]
  assign TLMonitor_1_clock = clock; // @[freechips.rocketchip.system.LitexConfig.fir 6000:4]
  assign TLMonitor_1_reset = reset; // @[freechips.rocketchip.system.LitexConfig.fir 6001:4]
  assign TLMonitor_1_io_in_a_ready = _T_331 | _T_330; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6050:4]
  assign TLMonitor_1_io_in_a_valid = auto_in_1_a_valid; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6049:4]
  assign TLMonitor_1_io_in_a_bits_opcode = auto_in_1_a_bits_opcode; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6048:4]
  assign TLMonitor_1_io_in_a_bits_param = auto_in_1_a_bits_param; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6047:4]
  assign TLMonitor_1_io_in_a_bits_size = auto_in_1_a_bits_size; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6046:4]
  assign TLMonitor_1_io_in_a_bits_source = auto_in_1_a_bits_source; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6045:4]
  assign TLMonitor_1_io_in_a_bits_address = auto_in_1_a_bits_address; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6044:4]
  assign TLMonitor_1_io_in_a_bits_mask = auto_in_1_a_bits_mask; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6036:4]
  assign TLMonitor_1_io_in_a_bits_corrupt = auto_in_1_a_bits_corrupt; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6034:4]
  assign TLMonitor_1_io_in_b_ready = auto_in_1_b_ready; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6033:4]
  assign TLMonitor_1_io_in_b_valid = auto_out_1_b_valid; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6032:4]
  assign TLMonitor_1_io_in_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6030:4]
  assign TLMonitor_1_io_in_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6027:4]
  assign TLMonitor_1_io_in_c_ready = auto_out_1_c_ready; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6023:4]
  assign TLMonitor_1_io_in_c_valid = auto_in_1_c_valid; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6022:4]
  assign TLMonitor_1_io_in_c_bits_opcode = auto_in_1_c_bits_opcode; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6021:4]
  assign TLMonitor_1_io_in_c_bits_param = auto_in_1_c_bits_param; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6020:4]
  assign TLMonitor_1_io_in_c_bits_size = auto_in_1_c_bits_size; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6019:4]
  assign TLMonitor_1_io_in_c_bits_source = auto_in_1_c_bits_source; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6018:4]
  assign TLMonitor_1_io_in_c_bits_address = auto_in_1_c_bits_address; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6017:4]
  assign TLMonitor_1_io_in_c_bits_corrupt = auto_in_1_c_bits_corrupt; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6015:4]
  assign TLMonitor_1_io_in_d_ready = auto_in_1_d_ready; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6014:4]
  assign TLMonitor_1_io_in_d_valid = _T_1079 ? _T_1151 : _T_1193; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6013:4]
  assign TLMonitor_1_io_in_d_bits_opcode = _T_1227[81:79]; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6012:4]
  assign TLMonitor_1_io_in_d_bits_param = _T_1227[78:77]; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6011:4]
  assign TLMonitor_1_io_in_d_bits_size = _T_1227[76:73]; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6010:4]
  assign TLMonitor_1_io_in_d_bits_source = _T_1227[69:68]; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6009:4]
  assign TLMonitor_1_io_in_d_bits_sink = _T_1227[67:66]; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6008:4]
  assign TLMonitor_1_io_in_d_bits_denied = _T_1227[65]; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6007:4]
  assign TLMonitor_1_io_in_d_bits_corrupt = _T_1227[0]; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6005:4]
  assign TLMonitor_1_io_in_e_valid = auto_in_1_e_valid; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6003:4]
  assign TLMonitor_1_io_in_e_bits_sink = auto_in_1_e_bits_sink; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 6002:4]
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  _T_906 = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  _T_922 = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  _T_1008_0 = _RAND_2[0:0];
  _RAND_3 = {1{`RANDOM}};
  _T_1008_1 = _RAND_3[0:0];
  _RAND_4 = {1{`RANDOM}};
  _T_1008_2 = _RAND_4[0:0];
  _RAND_5 = {1{`RANDOM}};
  _T_1078 = _RAND_5[8:0];
  _RAND_6 = {1{`RANDOM}};
  _T_1094 = _RAND_6[2:0];
  _RAND_7 = {1{`RANDOM}};
  _T_1180_0 = _RAND_7[0:0];
  _RAND_8 = {1{`RANDOM}};
  _T_1180_1 = _RAND_8[0:0];
  _RAND_9 = {1{`RANDOM}};
  _T_1180_2 = _RAND_9[0:0];
  _RAND_10 = {1{`RANDOM}};
  _T_440 = _RAND_10[8:0];
  _RAND_11 = {1{`RANDOM}};
  _T_453 = _RAND_11[1:0];
  _RAND_12 = {1{`RANDOM}};
  _T_520_0 = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  _T_592 = _RAND_13[8:0];
  _RAND_14 = {1{`RANDOM}};
  _T_605 = _RAND_14[1:0];
  _RAND_15 = {1{`RANDOM}};
  _T_672_0 = _RAND_15[0:0];
  _RAND_16 = {1{`RANDOM}};
  _T_746 = _RAND_16[8:0];
  _RAND_17 = {1{`RANDOM}};
  _T_759 = _RAND_17[1:0];
  _RAND_18 = {1{`RANDOM}};
  _T_826_0 = _RAND_18[0:0];
  _RAND_19 = {1{`RANDOM}};
  _T_520_1 = _RAND_19[0:0];
  _RAND_20 = {1{`RANDOM}};
  _T_672_1 = _RAND_20[0:0];
  _RAND_21 = {1{`RANDOM}};
  _T_826_1 = _RAND_21[0:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
  always @(posedge clock) begin
    if (reset) begin
      _T_906 <= 9'h0;
    end else if (_T_908) begin
      _T_906 <= _T_1000;
    end else begin
      _T_906 <= _T_1005;
    end
    if (reset) begin
      _T_922 <= 3'h7;
    end else if (_T_939) begin
      _T_922 <= _T_946;
    end
    if (reset) begin
      _T_1008_0 <= 1'h0;
    end else if (_T_907) begin
      _T_1008_0 <= _T_953;
    end
    if (reset) begin
      _T_1008_1 <= 1'h0;
    end else if (_T_907) begin
      _T_1008_1 <= _T_954;
    end
    if (reset) begin
      _T_1008_2 <= 1'h0;
    end else if (_T_907) begin
      _T_1008_2 <= _T_955;
    end
    if (reset) begin
      _T_1078 <= 9'h0;
    end else if (_T_1080) begin
      _T_1078 <= _T_1172;
    end else begin
      _T_1078 <= _T_1177;
    end
    if (reset) begin
      _T_1094 <= 3'h7;
    end else if (_T_1111) begin
      _T_1094 <= _T_1118;
    end
    if (reset) begin
      _T_1180_0 <= 1'h0;
    end else if (_T_1079) begin
      _T_1180_0 <= _T_1125;
    end
    if (reset) begin
      _T_1180_1 <= 1'h0;
    end else if (_T_1079) begin
      _T_1180_1 <= _T_1126;
    end
    if (reset) begin
      _T_1180_2 <= 1'h0;
    end else if (_T_1079) begin
      _T_1180_2 <= _T_1127;
    end
    if (reset) begin
      _T_440 <= 9'h0;
    end else if (_T_442) begin
      _T_440 <= _T_512;
    end else begin
      _T_440 <= _T_517;
    end
    if (reset) begin
      _T_453 <= 2'h3;
    end else if (_T_468) begin
      _T_453 <= _T_472;
    end
    if (reset) begin
      _T_520_0 <= 1'h0;
    end else if (_T_441) begin
      _T_520_0 <= _T_478;
    end
    if (reset) begin
      _T_592 <= 9'h0;
    end else if (_T_594) begin
      _T_592 <= _T_664;
    end else begin
      _T_592 <= _T_669;
    end
    if (reset) begin
      _T_605 <= 2'h3;
    end else if (_T_620) begin
      _T_605 <= _T_624;
    end
    if (reset) begin
      _T_672_0 <= 1'h0;
    end else if (_T_593) begin
      _T_672_0 <= _T_630;
    end
    if (reset) begin
      _T_746 <= 9'h0;
    end else if (_T_748) begin
      _T_746 <= _T_818;
    end else begin
      _T_746 <= _T_823;
    end
    if (reset) begin
      _T_759 <= 2'h3;
    end else if (_T_774) begin
      _T_759 <= _T_778;
    end
    if (reset) begin
      _T_826_0 <= 1'h0;
    end else if (_T_747) begin
      _T_826_0 <= _T_784;
    end
    if (reset) begin
      _T_520_1 <= 1'h0;
    end else if (_T_441) begin
      _T_520_1 <= _T_479;
    end
    if (reset) begin
      _T_672_1 <= 1'h0;
    end else if (_T_593) begin
      _T_672_1 <= _T_631;
    end
    if (reset) begin
      _T_826_1 <= 1'h0;
    end else if (_T_747) begin
      _T_826_1 <= _T_785;
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_495) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Arbiter.scala:96 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"); // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 7265:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_495) begin
          $fatal; // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 7266:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_502) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Arbiter.scala:98 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"); // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 7276:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_502) begin
          $fatal; // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 7277:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_509) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Arbiter.scala:99 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"); // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 7287:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_509) begin
          $fatal; // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 7288:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_647) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Arbiter.scala:96 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"); // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 7524:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_647) begin
          $fatal; // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 7525:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_654) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Arbiter.scala:98 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"); // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 7535:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_654) begin
          $fatal; // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 7536:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_661) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Arbiter.scala:99 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"); // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 7546:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_661) begin
          $fatal; // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 7547:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_801) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Arbiter.scala:96 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"); // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 7799:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_801) begin
          $fatal; // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 7800:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_808) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Arbiter.scala:98 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"); // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 7810:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_808) begin
          $fatal; // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 7811:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_815) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Arbiter.scala:99 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"); // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 7821:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_815) begin
          $fatal; // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 7822:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_977) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Arbiter.scala:96 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"); // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 8148:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_977) begin
          $fatal; // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 8149:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_986) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Arbiter.scala:98 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"); // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 8161:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_986) begin
          $fatal; // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 8162:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_995) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Arbiter.scala:99 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"); // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 8174:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_995) begin
          $fatal; // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 8175:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1149) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Arbiter.scala:96 assert((prefixOR zip earlyWinner) map { case (p,w) => !p || !w } reduce {_ && _})\n"); // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 8477:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1149) begin
          $fatal; // @[Arbiter.scala 96:13 freechips.rocketchip.system.LitexConfig.fir 8478:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1158) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Arbiter.scala:98 assert (!earlyValids.reduce(_||_) || earlyWinner.reduce(_||_))\n"); // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 8490:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1158) begin
          $fatal; // @[Arbiter.scala 98:14 freechips.rocketchip.system.LitexConfig.fir 8491:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1167) begin
          $fwrite(32'h80000002,"Assertion failed\n    at Arbiter.scala:99 assert (!validQuals .reduce(_||_) || validQuals .reduce(_||_))\n"); // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 8503:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1167) begin
          $fatal; // @[Arbiter.scala 99:14 freechips.rocketchip.system.LitexConfig.fir 8504:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
endmodule
module TLMonitor_2( // @[freechips.rocketchip.system.LitexConfig.fir 8860:2]
  input         clock, // @[freechips.rocketchip.system.LitexConfig.fir 8861:4]
  input         reset, // @[freechips.rocketchip.system.LitexConfig.fir 8862:4]
  input         io_in_a_ready, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input         io_in_a_valid, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input  [2:0]  io_in_a_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input  [2:0]  io_in_a_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input  [3:0]  io_in_a_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input  [3:0]  io_in_a_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input  [31:0] io_in_a_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input  [7:0]  io_in_a_bits_mask, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input         io_in_a_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input         io_in_d_ready, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input         io_in_d_valid, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input  [2:0]  io_in_d_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input  [1:0]  io_in_d_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input  [3:0]  io_in_d_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input  [3:0]  io_in_d_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input  [1:0]  io_in_d_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input         io_in_d_bits_denied, // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
  input         io_in_d_bits_corrupt // @[freechips.rocketchip.system.LitexConfig.fir 8863:4]
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [63:0] _RAND_14;
  reg [127:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [127:0] _RAND_20;
  reg [31:0] _RAND_21;
  reg [31:0] _RAND_22;
`endif // RANDOMIZE_REG_INIT
  wire [31:0] plusarg_reader_out; // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 10792:4]
  wire [31:0] plusarg_reader_1_out; // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 11099:4]
  wire  _T_7 = ~io_in_a_bits_source[3]; // @[Parameters.scala 55:32 freechips.rocketchip.system.LitexConfig.fir 8877:6]
  wire  _T_21 = _T_7 | io_in_a_bits_source[3]; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 8894:6]
  wire [26:0] _T_23 = 27'hfff << io_in_a_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 8896:6]
  wire [11:0] _T_25 = ~_T_23[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 8898:6]
  wire [31:0] _GEN_71 = {{20'd0}, _T_25}; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 8899:6]
  wire [31:0] _T_26 = io_in_a_bits_address & _GEN_71; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 8899:6]
  wire  _T_27 = _T_26 == 32'h0; // @[Edges.scala 22:24 freechips.rocketchip.system.LitexConfig.fir 8900:6]
  wire [3:0] _T_30 = 4'h1 << io_in_a_bits_size[1:0]; // @[OneHot.scala 65:12 freechips.rocketchip.system.LitexConfig.fir 8903:6]
  wire [2:0] _T_32 = _T_30[2:0] | 3'h1; // @[Misc.scala 201:81 freechips.rocketchip.system.LitexConfig.fir 8905:6]
  wire  _T_33 = io_in_a_bits_size >= 4'h3; // @[Misc.scala 205:21 freechips.rocketchip.system.LitexConfig.fir 8906:6]
  wire  _T_36 = ~io_in_a_bits_address[2]; // @[Misc.scala 210:20 freechips.rocketchip.system.LitexConfig.fir 8909:6]
  wire  _T_38 = _T_32[2] & _T_36; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 8911:6]
  wire  _T_39 = _T_33 | _T_38; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 8912:6]
  wire  _T_41 = _T_32[2] & io_in_a_bits_address[2]; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 8914:6]
  wire  _T_42 = _T_33 | _T_41; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 8915:6]
  wire  _T_45 = ~io_in_a_bits_address[1]; // @[Misc.scala 210:20 freechips.rocketchip.system.LitexConfig.fir 8918:6]
  wire  _T_46 = _T_36 & _T_45; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 8919:6]
  wire  _T_47 = _T_32[1] & _T_46; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 8920:6]
  wire  _T_48 = _T_39 | _T_47; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 8921:6]
  wire  _T_49 = _T_36 & io_in_a_bits_address[1]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 8922:6]
  wire  _T_50 = _T_32[1] & _T_49; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 8923:6]
  wire  _T_51 = _T_39 | _T_50; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 8924:6]
  wire  _T_52 = io_in_a_bits_address[2] & _T_45; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 8925:6]
  wire  _T_53 = _T_32[1] & _T_52; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 8926:6]
  wire  _T_54 = _T_42 | _T_53; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 8927:6]
  wire  _T_55 = io_in_a_bits_address[2] & io_in_a_bits_address[1]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 8928:6]
  wire  _T_56 = _T_32[1] & _T_55; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 8929:6]
  wire  _T_57 = _T_42 | _T_56; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 8930:6]
  wire  _T_60 = ~io_in_a_bits_address[0]; // @[Misc.scala 210:20 freechips.rocketchip.system.LitexConfig.fir 8933:6]
  wire  _T_61 = _T_46 & _T_60; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 8934:6]
  wire  _T_62 = _T_32[0] & _T_61; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 8935:6]
  wire  _T_63 = _T_48 | _T_62; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 8936:6]
  wire  _T_64 = _T_46 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 8937:6]
  wire  _T_65 = _T_32[0] & _T_64; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 8938:6]
  wire  _T_66 = _T_48 | _T_65; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 8939:6]
  wire  _T_67 = _T_49 & _T_60; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 8940:6]
  wire  _T_68 = _T_32[0] & _T_67; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 8941:6]
  wire  _T_69 = _T_51 | _T_68; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 8942:6]
  wire  _T_70 = _T_49 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 8943:6]
  wire  _T_71 = _T_32[0] & _T_70; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 8944:6]
  wire  _T_72 = _T_51 | _T_71; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 8945:6]
  wire  _T_73 = _T_52 & _T_60; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 8946:6]
  wire  _T_74 = _T_32[0] & _T_73; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 8947:6]
  wire  _T_75 = _T_54 | _T_74; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 8948:6]
  wire  _T_76 = _T_52 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 8949:6]
  wire  _T_77 = _T_32[0] & _T_76; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 8950:6]
  wire  _T_78 = _T_54 | _T_77; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 8951:6]
  wire  _T_79 = _T_55 & _T_60; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 8952:6]
  wire  _T_80 = _T_32[0] & _T_79; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 8953:6]
  wire  _T_81 = _T_57 | _T_80; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 8954:6]
  wire  _T_82 = _T_55 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 8955:6]
  wire  _T_83 = _T_32[0] & _T_82; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 8956:6]
  wire  _T_84 = _T_57 | _T_83; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 8957:6]
  wire [7:0] _T_91 = {_T_84,_T_81,_T_78,_T_75,_T_72,_T_69,_T_66,_T_63}; // @[Cat.scala 29:58 freechips.rocketchip.system.LitexConfig.fir 8964:6]
  wire [32:0] _T_102 = {1'b0,$signed(io_in_a_bits_address)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 8975:6]
  wire  _T_126 = io_in_a_bits_opcode == 3'h6; // @[Monitor.scala 83:25 freechips.rocketchip.system.LitexConfig.fir 9003:6]
  wire  _T_128 = io_in_a_bits_size <= 4'hc; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 9006:8]
  wire  _T_147 = _T_128 & _T_21; // @[Parameters.scala 1195:30 freechips.rocketchip.system.LitexConfig.fir 9025:8]
  wire  _T_157 = io_in_a_bits_size <= 4'h6; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 9035:8]
  wire [31:0] _T_160 = io_in_a_bits_address ^ 32'h80000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 9038:8]
  wire [32:0] _T_161 = {1'b0,$signed(_T_160)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 9039:8]
  wire [32:0] _T_163 = $signed(_T_161) & 33'sh80000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 9041:8]
  wire  _T_164 = $signed(_T_163) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 9042:8]
  wire  _T_165 = _T_157 & _T_164; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 9043:8]
  wire  _T_168 = _T_147 & _T_165; // @[Parameters.scala 1402:195 freechips.rocketchip.system.LitexConfig.fir 9046:8]
  wire  _T_170 = _T_168 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9048:8]
  wire  _T_171 = ~_T_170; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9049:8]
  wire  _T_186 = ~reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9068:8]
  wire  _T_188 = _T_21 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9074:8]
  wire  _T_189 = ~_T_188; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9075:8]
  wire  _T_192 = _T_33 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9082:8]
  wire  _T_193 = ~_T_192; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9083:8]
  wire  _T_195 = _T_27 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9089:8]
  wire  _T_196 = ~_T_195; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9090:8]
  wire  _T_197 = io_in_a_bits_param <= 3'h2; // @[Bundles.scala 110:27 freechips.rocketchip.system.LitexConfig.fir 9095:8]
  wire  _T_199 = _T_197 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9097:8]
  wire  _T_200 = ~_T_199; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9098:8]
  wire [7:0] _T_201 = ~io_in_a_bits_mask; // @[Monitor.scala 90:18 freechips.rocketchip.system.LitexConfig.fir 9103:8]
  wire  _T_202 = _T_201 == 8'h0; // @[Monitor.scala 90:31 freechips.rocketchip.system.LitexConfig.fir 9104:8]
  wire  _T_204 = _T_202 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9106:8]
  wire  _T_205 = ~_T_204; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9107:8]
  wire  _T_206 = ~io_in_a_bits_corrupt; // @[Monitor.scala 91:18 freechips.rocketchip.system.LitexConfig.fir 9112:8]
  wire  _T_208 = _T_206 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9114:8]
  wire  _T_209 = ~_T_208; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9115:8]
  wire  _T_210 = io_in_a_bits_opcode == 3'h7; // @[Monitor.scala 94:25 freechips.rocketchip.system.LitexConfig.fir 9121:6]
  wire  _T_285 = io_in_a_bits_param != 3'h0; // @[Monitor.scala 101:31 freechips.rocketchip.system.LitexConfig.fir 9221:8]
  wire  _T_287 = _T_285 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9223:8]
  wire  _T_288 = ~_T_287; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9224:8]
  wire  _T_298 = io_in_a_bits_opcode == 3'h4; // @[Monitor.scala 106:25 freechips.rocketchip.system.LitexConfig.fir 9247:6]
  wire  _T_322 = _T_147 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9272:8]
  wire  _T_323 = ~_T_322; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9273:8]
  wire [31:0] _T_328 = io_in_a_bits_address ^ 32'h2000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 9282:8]
  wire [32:0] _T_329 = {1'b0,$signed(_T_328)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 9283:8]
  wire [32:0] _T_331 = $signed(_T_329) & 33'shfa012000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 9285:8]
  wire  _T_332 = $signed(_T_331) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 9286:8]
  wire  _T_333 = _T_128 & _T_332; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 9287:8]
  wire [32:0] _T_341 = $signed(_T_102) & 33'shfa012000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 9295:8]
  wire  _T_342 = $signed(_T_341) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 9296:8]
  wire [31:0] _T_343 = io_in_a_bits_address ^ 32'h10000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 9297:8]
  wire [32:0] _T_344 = {1'b0,$signed(_T_343)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 9298:8]
  wire [32:0] _T_346 = $signed(_T_344) & 33'shfa010000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 9300:8]
  wire  _T_347 = $signed(_T_346) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 9301:8]
  wire [31:0] _T_348 = io_in_a_bits_address ^ 32'h2000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 9302:8]
  wire [32:0] _T_349 = {1'b0,$signed(_T_348)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 9303:8]
  wire [32:0] _T_351 = $signed(_T_349) & 33'shfa010000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 9305:8]
  wire  _T_352 = $signed(_T_351) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 9306:8]
  wire [31:0] _T_353 = io_in_a_bits_address ^ 32'h8000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 9307:8]
  wire [32:0] _T_354 = {1'b0,$signed(_T_353)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 9308:8]
  wire [32:0] _T_356 = $signed(_T_354) & 33'shf8000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 9310:8]
  wire  _T_357 = $signed(_T_356) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 9311:8]
  wire [31:0] _T_358 = io_in_a_bits_address ^ 32'h10000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 9312:8]
  wire [32:0] _T_359 = {1'b0,$signed(_T_358)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 9313:8]
  wire [32:0] _T_361 = $signed(_T_359) & 33'shf0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 9315:8]
  wire  _T_362 = $signed(_T_361) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 9316:8]
  wire [31:0] _T_363 = io_in_a_bits_address ^ 32'h20000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 9317:8]
  wire [32:0] _T_364 = {1'b0,$signed(_T_363)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 9318:8]
  wire [32:0] _T_366 = $signed(_T_364) & 33'she0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 9320:8]
  wire  _T_367 = $signed(_T_366) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 9321:8]
  wire [31:0] _T_368 = io_in_a_bits_address ^ 32'h40000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 9322:8]
  wire [32:0] _T_369 = {1'b0,$signed(_T_368)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 9323:8]
  wire [32:0] _T_371 = $signed(_T_369) & 33'shc0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 9325:8]
  wire  _T_372 = $signed(_T_371) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 9326:8]
  wire  _T_378 = _T_342 | _T_347; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 9332:8]
  wire  _T_379 = _T_378 | _T_352; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 9333:8]
  wire  _T_380 = _T_379 | _T_357; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 9334:8]
  wire  _T_381 = _T_380 | _T_362; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 9335:8]
  wire  _T_382 = _T_381 | _T_367; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 9336:8]
  wire  _T_383 = _T_382 | _T_372; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 9337:8]
  wire  _T_384 = _T_383 | _T_164; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 9338:8]
  wire  _T_385 = _T_157 & _T_384; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 9339:8]
  wire  _T_387 = _T_333 | _T_385; // @[Parameters.scala 661:30 freechips.rocketchip.system.LitexConfig.fir 9341:8]
  wire  _T_389 = _T_387 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9343:8]
  wire  _T_390 = ~_T_389; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9344:8]
  wire  _T_397 = io_in_a_bits_param == 3'h0; // @[Monitor.scala 111:31 freechips.rocketchip.system.LitexConfig.fir 9363:8]
  wire  _T_399 = _T_397 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9365:8]
  wire  _T_400 = ~_T_399; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9366:8]
  wire  _T_401 = io_in_a_bits_mask == _T_91; // @[Monitor.scala 112:30 freechips.rocketchip.system.LitexConfig.fir 9371:8]
  wire  _T_403 = _T_401 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9373:8]
  wire  _T_404 = ~_T_403; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9374:8]
  wire  _T_409 = io_in_a_bits_opcode == 3'h0; // @[Monitor.scala 116:25 freechips.rocketchip.system.LitexConfig.fir 9388:6]
  wire  _T_466 = _T_342 | _T_352; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 9446:8]
  wire  _T_467 = _T_466 | _T_357; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 9447:8]
  wire  _T_468 = _T_467 | _T_164; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 9448:8]
  wire  _T_469 = _T_157 & _T_468; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 9449:8]
  wire  _T_478 = io_in_a_bits_size <= 4'h8; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 9458:8]
  wire  _T_496 = _T_362 | _T_367; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 9476:8]
  wire  _T_497 = _T_496 | _T_372; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 9477:8]
  wire  _T_498 = _T_478 & _T_497; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 9478:8]
  wire  _T_500 = _T_333 | _T_469; // @[Parameters.scala 661:30 freechips.rocketchip.system.LitexConfig.fir 9480:8]
  wire  _T_502 = _T_500 | _T_498; // @[Parameters.scala 661:30 freechips.rocketchip.system.LitexConfig.fir 9482:8]
  wire  _T_503 = _T_147 & _T_502; // @[Parameters.scala 1406:195 freechips.rocketchip.system.LitexConfig.fir 9483:8]
  wire  _T_505 = _T_503 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9485:8]
  wire  _T_506 = ~_T_505; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9486:8]
  wire  _T_521 = io_in_a_bits_opcode == 3'h1; // @[Monitor.scala 124:25 freechips.rocketchip.system.LitexConfig.fir 9522:6]
  wire [7:0] _T_629 = ~_T_91; // @[Monitor.scala 129:33 freechips.rocketchip.system.LitexConfig.fir 9647:8]
  wire [7:0] _T_630 = io_in_a_bits_mask & _T_629; // @[Monitor.scala 129:31 freechips.rocketchip.system.LitexConfig.fir 9648:8]
  wire  _T_631 = _T_630 == 8'h0; // @[Monitor.scala 129:40 freechips.rocketchip.system.LitexConfig.fir 9649:8]
  wire  _T_633 = _T_631 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9651:8]
  wire  _T_634 = ~_T_633; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9652:8]
  wire  _T_635 = io_in_a_bits_opcode == 3'h2; // @[Monitor.scala 132:25 freechips.rocketchip.system.LitexConfig.fir 9658:6]
  wire  _T_659 = io_in_a_bits_size <= 4'h3; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 9683:8]
  wire [32:0] _T_665 = $signed(_T_102) & 33'shf8010000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 9689:8]
  wire  _T_666 = $signed(_T_665) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 9690:8]
  wire  _T_672 = _T_666 | _T_357; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 9696:8]
  wire  _T_673 = _T_659 & _T_672; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 9697:8]
  wire  _T_707 = _T_147 & _T_673; // @[Parameters.scala 1403:195 freechips.rocketchip.system.LitexConfig.fir 9731:8]
  wire  _T_709 = _T_707 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9733:8]
  wire  _T_710 = ~_T_709; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9734:8]
  wire  _T_717 = io_in_a_bits_param <= 3'h4; // @[Bundles.scala 140:33 freechips.rocketchip.system.LitexConfig.fir 9753:8]
  wire  _T_719 = _T_717 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9755:8]
  wire  _T_720 = ~_T_719; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9756:8]
  wire  _T_725 = io_in_a_bits_opcode == 3'h3; // @[Monitor.scala 140:25 freechips.rocketchip.system.LitexConfig.fir 9770:6]
  wire  _T_807 = io_in_a_bits_param <= 3'h3; // @[Bundles.scala 147:30 freechips.rocketchip.system.LitexConfig.fir 9865:8]
  wire  _T_809 = _T_807 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9867:8]
  wire  _T_810 = ~_T_809; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9868:8]
  wire  _T_815 = io_in_a_bits_opcode == 3'h5; // @[Monitor.scala 148:25 freechips.rocketchip.system.LitexConfig.fir 9882:6]
  wire  _T_899 = _T_147 & _T_333; // @[Parameters.scala 1408:195 freechips.rocketchip.system.LitexConfig.fir 9967:8]
  wire  _T_901 = _T_899 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9969:8]
  wire  _T_902 = ~_T_901; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9970:8]
  wire  _T_909 = io_in_a_bits_param <= 3'h1; // @[Bundles.scala 160:28 freechips.rocketchip.system.LitexConfig.fir 9989:8]
  wire  _T_911 = _T_909 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9991:8]
  wire  _T_912 = ~_T_911; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9992:8]
  wire  _T_921 = io_in_d_bits_opcode <= 3'h6; // @[Bundles.scala 44:24 freechips.rocketchip.system.LitexConfig.fir 10016:6]
  wire  _T_923 = _T_921 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10018:6]
  wire  _T_924 = ~_T_923; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10019:6]
  wire  _T_928 = ~io_in_d_bits_source[3]; // @[Parameters.scala 55:32 freechips.rocketchip.system.LitexConfig.fir 10027:6]
  wire  _T_942 = _T_928 | io_in_d_bits_source[3]; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 10044:6]
  wire  _T_944 = io_in_d_bits_opcode == 3'h6; // @[Monitor.scala 312:25 freechips.rocketchip.system.LitexConfig.fir 10046:6]
  wire  _T_946 = _T_942 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10049:8]
  wire  _T_947 = ~_T_946; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10050:8]
  wire  _T_948 = io_in_d_bits_size >= 4'h3; // @[Monitor.scala 314:27 freechips.rocketchip.system.LitexConfig.fir 10055:8]
  wire  _T_950 = _T_948 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10057:8]
  wire  _T_951 = ~_T_950; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10058:8]
  wire  _T_952 = io_in_d_bits_param == 2'h0; // @[Monitor.scala 315:28 freechips.rocketchip.system.LitexConfig.fir 10063:8]
  wire  _T_954 = _T_952 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10065:8]
  wire  _T_955 = ~_T_954; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10066:8]
  wire  _T_956 = ~io_in_d_bits_corrupt; // @[Monitor.scala 316:15 freechips.rocketchip.system.LitexConfig.fir 10071:8]
  wire  _T_958 = _T_956 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10073:8]
  wire  _T_959 = ~_T_958; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10074:8]
  wire  _T_960 = ~io_in_d_bits_denied; // @[Monitor.scala 317:15 freechips.rocketchip.system.LitexConfig.fir 10079:8]
  wire  _T_962 = _T_960 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10081:8]
  wire  _T_963 = ~_T_962; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10082:8]
  wire  _T_964 = io_in_d_bits_opcode == 3'h4; // @[Monitor.scala 320:25 freechips.rocketchip.system.LitexConfig.fir 10088:6]
  wire  _T_975 = io_in_d_bits_param <= 2'h2; // @[Bundles.scala 104:26 freechips.rocketchip.system.LitexConfig.fir 10112:8]
  wire  _T_977 = _T_975 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10114:8]
  wire  _T_978 = ~_T_977; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10115:8]
  wire  _T_979 = io_in_d_bits_param != 2'h2; // @[Monitor.scala 325:28 freechips.rocketchip.system.LitexConfig.fir 10120:8]
  wire  _T_981 = _T_979 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10122:8]
  wire  _T_982 = ~_T_981; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10123:8]
  wire  _T_992 = io_in_d_bits_opcode == 3'h5; // @[Monitor.scala 330:25 freechips.rocketchip.system.LitexConfig.fir 10146:6]
  wire  _T_1012 = _T_960 | io_in_d_bits_corrupt; // @[Monitor.scala 336:30 freechips.rocketchip.system.LitexConfig.fir 10187:8]
  wire  _T_1014 = _T_1012 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10189:8]
  wire  _T_1015 = ~_T_1014; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10190:8]
  wire  _T_1021 = io_in_d_bits_opcode == 3'h0; // @[Monitor.scala 340:25 freechips.rocketchip.system.LitexConfig.fir 10205:6]
  wire  _T_1038 = io_in_d_bits_opcode == 3'h1; // @[Monitor.scala 348:25 freechips.rocketchip.system.LitexConfig.fir 10240:6]
  wire  _T_1056 = io_in_d_bits_opcode == 3'h2; // @[Monitor.scala 356:25 freechips.rocketchip.system.LitexConfig.fir 10276:6]
  wire  _T_1088 = io_in_a_ready & io_in_a_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 10342:4]
  wire  _T_1095 = ~io_in_a_bits_opcode[2]; // @[Edges.scala 93:28 freechips.rocketchip.system.LitexConfig.fir 10349:4]
  reg [8:0] _T_1097; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 10351:4]
  wire [8:0] _T_1099 = _T_1097 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 10353:4]
  wire  _T_1100 = _T_1097 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 10354:4]
  reg [2:0] _T_1108; // @[Monitor.scala 386:22 freechips.rocketchip.system.LitexConfig.fir 10365:4]
  reg [2:0] _T_1109; // @[Monitor.scala 387:22 freechips.rocketchip.system.LitexConfig.fir 10366:4]
  reg [3:0] _T_1110; // @[Monitor.scala 388:22 freechips.rocketchip.system.LitexConfig.fir 10367:4]
  reg [3:0] _T_1111; // @[Monitor.scala 389:22 freechips.rocketchip.system.LitexConfig.fir 10368:4]
  reg [31:0] _T_1112; // @[Monitor.scala 390:22 freechips.rocketchip.system.LitexConfig.fir 10369:4]
  wire  _T_1113 = ~_T_1100; // @[Monitor.scala 391:22 freechips.rocketchip.system.LitexConfig.fir 10370:4]
  wire  _T_1114 = io_in_a_valid & _T_1113; // @[Monitor.scala 391:19 freechips.rocketchip.system.LitexConfig.fir 10371:4]
  wire  _T_1115 = io_in_a_bits_opcode == _T_1108; // @[Monitor.scala 392:32 freechips.rocketchip.system.LitexConfig.fir 10373:6]
  wire  _T_1117 = _T_1115 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10375:6]
  wire  _T_1118 = ~_T_1117; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10376:6]
  wire  _T_1119 = io_in_a_bits_param == _T_1109; // @[Monitor.scala 393:32 freechips.rocketchip.system.LitexConfig.fir 10381:6]
  wire  _T_1121 = _T_1119 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10383:6]
  wire  _T_1122 = ~_T_1121; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10384:6]
  wire  _T_1123 = io_in_a_bits_size == _T_1110; // @[Monitor.scala 394:32 freechips.rocketchip.system.LitexConfig.fir 10389:6]
  wire  _T_1125 = _T_1123 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10391:6]
  wire  _T_1126 = ~_T_1125; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10392:6]
  wire  _T_1127 = io_in_a_bits_source == _T_1111; // @[Monitor.scala 395:32 freechips.rocketchip.system.LitexConfig.fir 10397:6]
  wire  _T_1129 = _T_1127 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10399:6]
  wire  _T_1130 = ~_T_1129; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10400:6]
  wire  _T_1131 = io_in_a_bits_address == _T_1112; // @[Monitor.scala 396:32 freechips.rocketchip.system.LitexConfig.fir 10405:6]
  wire  _T_1133 = _T_1131 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10407:6]
  wire  _T_1134 = ~_T_1133; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10408:6]
  wire  _T_1136 = _T_1088 & _T_1100; // @[Monitor.scala 398:20 freechips.rocketchip.system.LitexConfig.fir 10415:4]
  wire  _T_1137 = io_in_d_ready & io_in_d_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 10423:4]
  wire [26:0] _T_1139 = 27'hfff << io_in_d_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 10425:4]
  wire [11:0] _T_1141 = ~_T_1139[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 10427:4]
  reg [8:0] _T_1145; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 10431:4]
  wire [8:0] _T_1147 = _T_1145 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 10433:4]
  wire  _T_1148 = _T_1145 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 10434:4]
  reg [2:0] _T_1156; // @[Monitor.scala 537:22 freechips.rocketchip.system.LitexConfig.fir 10445:4]
  reg [1:0] _T_1157; // @[Monitor.scala 538:22 freechips.rocketchip.system.LitexConfig.fir 10446:4]
  reg [3:0] _T_1158; // @[Monitor.scala 539:22 freechips.rocketchip.system.LitexConfig.fir 10447:4]
  reg [3:0] _T_1159; // @[Monitor.scala 540:22 freechips.rocketchip.system.LitexConfig.fir 10448:4]
  reg [1:0] _T_1160; // @[Monitor.scala 541:22 freechips.rocketchip.system.LitexConfig.fir 10449:4]
  reg  _T_1161; // @[Monitor.scala 542:22 freechips.rocketchip.system.LitexConfig.fir 10450:4]
  wire  _T_1162 = ~_T_1148; // @[Monitor.scala 543:22 freechips.rocketchip.system.LitexConfig.fir 10451:4]
  wire  _T_1163 = io_in_d_valid & _T_1162; // @[Monitor.scala 543:19 freechips.rocketchip.system.LitexConfig.fir 10452:4]
  wire  _T_1164 = io_in_d_bits_opcode == _T_1156; // @[Monitor.scala 544:29 freechips.rocketchip.system.LitexConfig.fir 10454:6]
  wire  _T_1166 = _T_1164 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10456:6]
  wire  _T_1167 = ~_T_1166; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10457:6]
  wire  _T_1168 = io_in_d_bits_param == _T_1157; // @[Monitor.scala 545:29 freechips.rocketchip.system.LitexConfig.fir 10462:6]
  wire  _T_1170 = _T_1168 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10464:6]
  wire  _T_1171 = ~_T_1170; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10465:6]
  wire  _T_1172 = io_in_d_bits_size == _T_1158; // @[Monitor.scala 546:29 freechips.rocketchip.system.LitexConfig.fir 10470:6]
  wire  _T_1174 = _T_1172 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10472:6]
  wire  _T_1175 = ~_T_1174; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10473:6]
  wire  _T_1176 = io_in_d_bits_source == _T_1159; // @[Monitor.scala 547:29 freechips.rocketchip.system.LitexConfig.fir 10478:6]
  wire  _T_1178 = _T_1176 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10480:6]
  wire  _T_1179 = ~_T_1178; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10481:6]
  wire  _T_1180 = io_in_d_bits_sink == _T_1160; // @[Monitor.scala 548:29 freechips.rocketchip.system.LitexConfig.fir 10486:6]
  wire  _T_1182 = _T_1180 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10488:6]
  wire  _T_1183 = ~_T_1182; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10489:6]
  wire  _T_1184 = io_in_d_bits_denied == _T_1161; // @[Monitor.scala 549:29 freechips.rocketchip.system.LitexConfig.fir 10494:6]
  wire  _T_1186 = _T_1184 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10496:6]
  wire  _T_1187 = ~_T_1186; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10497:6]
  wire  _T_1189 = _T_1137 & _T_1148; // @[Monitor.scala 551:20 freechips.rocketchip.system.LitexConfig.fir 10504:4]
  reg [15:0] inflight; // @[Monitor.scala 613:27 freechips.rocketchip.system.LitexConfig.fir 10513:4]
  reg [63:0] inflight_opcodes; // @[Monitor.scala 615:35 freechips.rocketchip.system.LitexConfig.fir 10514:4]
  reg [127:0] inflight_sizes; // @[Monitor.scala 617:33 freechips.rocketchip.system.LitexConfig.fir 10515:4]
  reg [8:0] _T_1199; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 10525:4]
  wire [8:0] _T_1201 = _T_1199 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 10527:4]
  wire  a_first = _T_1199 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 10528:4]
  reg [8:0] _T_1217; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 10547:4]
  wire [8:0] _T_1219 = _T_1217 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 10549:4]
  wire  d_first = _T_1217 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 10550:4]
  wire [5:0] _GEN_72 = {io_in_d_bits_source, 2'h0}; // @[Monitor.scala 636:69 freechips.rocketchip.system.LitexConfig.fir 10571:4]
  wire [6:0] _T_1227 = {{1'd0}, _GEN_72}; // @[Monitor.scala 636:69 freechips.rocketchip.system.LitexConfig.fir 10571:4]
  wire [63:0] _T_1228 = inflight_opcodes >> _T_1227; // @[Monitor.scala 636:44 freechips.rocketchip.system.LitexConfig.fir 10572:4]
  wire [15:0] _T_1232 = 16'h10 - 16'h1; // @[Monitor.scala 611:57 freechips.rocketchip.system.LitexConfig.fir 10576:4]
  wire [63:0] _GEN_73 = {{48'd0}, _T_1232}; // @[Monitor.scala 636:97 freechips.rocketchip.system.LitexConfig.fir 10577:4]
  wire [63:0] _T_1233 = _T_1228 & _GEN_73; // @[Monitor.scala 636:97 freechips.rocketchip.system.LitexConfig.fir 10577:4]
  wire [63:0] _T_1234 = {{1'd0}, _T_1233[63:1]}; // @[Monitor.scala 636:152 freechips.rocketchip.system.LitexConfig.fir 10578:4]
  wire [6:0] _T_1235 = {io_in_d_bits_source, 3'h0}; // @[Monitor.scala 640:65 freechips.rocketchip.system.LitexConfig.fir 10582:4]
  wire [127:0] _T_1236 = inflight_sizes >> _T_1235; // @[Monitor.scala 640:40 freechips.rocketchip.system.LitexConfig.fir 10583:4]
  wire [15:0] _T_1240 = 16'h100 - 16'h1; // @[Monitor.scala 611:57 freechips.rocketchip.system.LitexConfig.fir 10587:4]
  wire [127:0] _GEN_75 = {{112'd0}, _T_1240}; // @[Monitor.scala 640:91 freechips.rocketchip.system.LitexConfig.fir 10588:4]
  wire [127:0] _T_1241 = _T_1236 & _GEN_75; // @[Monitor.scala 640:91 freechips.rocketchip.system.LitexConfig.fir 10588:4]
  wire [127:0] _T_1242 = {{1'd0}, _T_1241[127:1]}; // @[Monitor.scala 640:144 freechips.rocketchip.system.LitexConfig.fir 10589:4]
  wire  _T_1245 = io_in_a_valid & a_first; // @[Monitor.scala 650:26 freechips.rocketchip.system.LitexConfig.fir 10613:4]
  wire [15:0] _T_1247 = 16'h1 << io_in_a_bits_source; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 10616:6]
  wire [15:0] a_set_wo_ready = _T_1245 ? _T_1247 : 16'h0; // @[Monitor.scala 650:71 freechips.rocketchip.system.LitexConfig.fir 10615:4]
  wire  _T_1249 = _T_1088 & a_first; // @[Monitor.scala 654:27 freechips.rocketchip.system.LitexConfig.fir 10620:4]
  wire [3:0] _T_1252 = {io_in_a_bits_opcode, 1'h0}; // @[Monitor.scala 656:53 freechips.rocketchip.system.LitexConfig.fir 10625:6]
  wire [3:0] _T_1253 = _T_1252 | 4'h1; // @[Monitor.scala 656:61 freechips.rocketchip.system.LitexConfig.fir 10626:6]
  wire [4:0] _T_1254 = {io_in_a_bits_size, 1'h0}; // @[Monitor.scala 657:51 freechips.rocketchip.system.LitexConfig.fir 10628:6]
  wire [4:0] _T_1255 = _T_1254 | 5'h1; // @[Monitor.scala 657:59 freechips.rocketchip.system.LitexConfig.fir 10629:6]
  wire [5:0] _GEN_77 = {io_in_a_bits_source, 2'h0}; // @[Monitor.scala 658:79 freechips.rocketchip.system.LitexConfig.fir 10631:6]
  wire [6:0] _T_1256 = {{1'd0}, _GEN_77}; // @[Monitor.scala 658:79 freechips.rocketchip.system.LitexConfig.fir 10631:6]
  wire [3:0] a_opcodes_set_interm = _T_1249 ? _T_1253 : 4'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 10622:4]
  wire [130:0] _GEN_78 = {{127'd0}, a_opcodes_set_interm}; // @[Monitor.scala 658:54 freechips.rocketchip.system.LitexConfig.fir 10632:6]
  wire [130:0] _T_1257 = _GEN_78 << _T_1256; // @[Monitor.scala 658:54 freechips.rocketchip.system.LitexConfig.fir 10632:6]
  wire [6:0] _T_1258 = {io_in_a_bits_source, 3'h0}; // @[Monitor.scala 659:77 freechips.rocketchip.system.LitexConfig.fir 10634:6]
  wire [4:0] a_sizes_set_interm = _T_1249 ? _T_1255 : 5'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 10622:4]
  wire [131:0] _GEN_79 = {{127'd0}, a_sizes_set_interm}; // @[Monitor.scala 659:52 freechips.rocketchip.system.LitexConfig.fir 10635:6]
  wire [131:0] _T_1259 = _GEN_79 << _T_1258; // @[Monitor.scala 659:52 freechips.rocketchip.system.LitexConfig.fir 10635:6]
  wire [15:0] _T_1260 = inflight >> io_in_a_bits_source; // @[Monitor.scala 660:26 freechips.rocketchip.system.LitexConfig.fir 10637:6]
  wire  _T_1262 = ~_T_1260[0]; // @[Monitor.scala 660:17 freechips.rocketchip.system.LitexConfig.fir 10639:6]
  wire  _T_1264 = _T_1262 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10641:6]
  wire  _T_1265 = ~_T_1264; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10642:6]
  wire [15:0] a_set = _T_1249 ? _T_1247 : 16'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 10622:4]
  wire [130:0] _GEN_19 = _T_1249 ? _T_1257 : 131'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 10622:4]
  wire [131:0] _GEN_20 = _T_1249 ? _T_1259 : 132'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 10622:4]
  wire  _T_1267 = io_in_d_valid & d_first; // @[Monitor.scala 673:26 freechips.rocketchip.system.LitexConfig.fir 10657:4]
  wire  _T_1269 = ~_T_944; // @[Monitor.scala 673:74 freechips.rocketchip.system.LitexConfig.fir 10659:4]
  wire  _T_1270 = _T_1267 & _T_1269; // @[Monitor.scala 673:71 freechips.rocketchip.system.LitexConfig.fir 10660:4]
  wire [15:0] _T_1271 = 16'h1 << io_in_d_bits_source; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 10662:6]
  wire [15:0] d_clr_wo_ready = _T_1270 ? _T_1271 : 16'h0; // @[Monitor.scala 673:90 freechips.rocketchip.system.LitexConfig.fir 10661:4]
  wire  _T_1273 = _T_1137 & d_first; // @[Monitor.scala 677:27 freechips.rocketchip.system.LitexConfig.fir 10666:4]
  wire  _T_1276 = _T_1273 & _T_1269; // @[Monitor.scala 677:72 freechips.rocketchip.system.LitexConfig.fir 10669:4]
  wire [142:0] _GEN_81 = {{127'd0}, _T_1232}; // @[Monitor.scala 679:76 freechips.rocketchip.system.LitexConfig.fir 10678:6]
  wire [142:0] _T_1283 = _GEN_81 << _T_1227; // @[Monitor.scala 679:76 freechips.rocketchip.system.LitexConfig.fir 10678:6]
  wire [142:0] _GEN_82 = {{127'd0}, _T_1240}; // @[Monitor.scala 680:74 freechips.rocketchip.system.LitexConfig.fir 10685:6]
  wire [142:0] _T_1289 = _GEN_82 << _T_1235; // @[Monitor.scala 680:74 freechips.rocketchip.system.LitexConfig.fir 10685:6]
  wire [15:0] d_clr = _T_1276 ? _T_1271 : 16'h0; // @[Monitor.scala 677:91 freechips.rocketchip.system.LitexConfig.fir 10670:4]
  wire [142:0] _GEN_23 = _T_1276 ? _T_1283 : 143'h0; // @[Monitor.scala 677:91 freechips.rocketchip.system.LitexConfig.fir 10670:4]
  wire [142:0] _GEN_24 = _T_1276 ? _T_1289 : 143'h0; // @[Monitor.scala 677:91 freechips.rocketchip.system.LitexConfig.fir 10670:4]
  wire  _T_1296 = io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 683:113 freechips.rocketchip.system.LitexConfig.fir 10695:6]
  wire  _T_1297 = _T_1245 & _T_1296; // @[Monitor.scala 683:88 freechips.rocketchip.system.LitexConfig.fir 10696:6]
  wire [15:0] _T_1298 = inflight >> io_in_d_bits_source; // @[Monitor.scala 684:25 freechips.rocketchip.system.LitexConfig.fir 10697:6]
  wire  _T_1300 = _T_1298[0] | _T_1297; // @[Monitor.scala 684:49 freechips.rocketchip.system.LitexConfig.fir 10699:6]
  wire  _T_1302 = _T_1300 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10701:6]
  wire  _T_1303 = ~_T_1302; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10702:6]
  wire [2:0] _GEN_27 = 3'h2 == io_in_a_bits_opcode ? 3'h1 : 3'h0; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 10708:8]
  wire [2:0] _GEN_28 = 3'h3 == io_in_a_bits_opcode ? 3'h1 : _GEN_27; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 10708:8]
  wire [2:0] _GEN_29 = 3'h4 == io_in_a_bits_opcode ? 3'h1 : _GEN_28; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 10708:8]
  wire [2:0] _GEN_30 = 3'h5 == io_in_a_bits_opcode ? 3'h2 : _GEN_29; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 10708:8]
  wire [2:0] _GEN_31 = 3'h6 == io_in_a_bits_opcode ? 3'h4 : _GEN_30; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 10708:8]
  wire [2:0] _GEN_32 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_31; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 10708:8]
  wire  _T_1304 = io_in_d_bits_opcode == _GEN_32; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 10708:8]
  wire [2:0] _GEN_39 = 3'h6 == io_in_a_bits_opcode ? 3'h5 : _GEN_30; // @[Monitor.scala 688:39 freechips.rocketchip.system.LitexConfig.fir 10709:8]
  wire [2:0] _GEN_40 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_39; // @[Monitor.scala 688:39 freechips.rocketchip.system.LitexConfig.fir 10709:8]
  wire  _T_1305 = io_in_d_bits_opcode == _GEN_40; // @[Monitor.scala 688:39 freechips.rocketchip.system.LitexConfig.fir 10709:8]
  wire  _T_1306 = _T_1304 | _T_1305; // @[Monitor.scala 687:77 freechips.rocketchip.system.LitexConfig.fir 10710:8]
  wire  _T_1308 = _T_1306 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10712:8]
  wire  _T_1309 = ~_T_1308; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10713:8]
  wire  _T_1310 = io_in_a_bits_size == io_in_d_bits_size; // @[Monitor.scala 689:36 freechips.rocketchip.system.LitexConfig.fir 10718:8]
  wire  _T_1312 = _T_1310 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10720:8]
  wire  _T_1313 = ~_T_1312; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10721:8]
  wire [3:0] a_opcode_lookup = _T_1234[3:0]; // @[freechips.rocketchip.system.LitexConfig.fir 10569:4 freechips.rocketchip.system.LitexConfig.fir 10570:4 Monitor.scala 636:21 freechips.rocketchip.system.LitexConfig.fir 10579:4]
  wire [2:0] _GEN_43 = 3'h2 == a_opcode_lookup[2:0] ? 3'h1 : 3'h0; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 10729:8]
  wire [2:0] _GEN_44 = 3'h3 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_43; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 10729:8]
  wire [2:0] _GEN_45 = 3'h4 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_44; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 10729:8]
  wire [2:0] _GEN_46 = 3'h5 == a_opcode_lookup[2:0] ? 3'h2 : _GEN_45; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 10729:8]
  wire [2:0] _GEN_47 = 3'h6 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_46; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 10729:8]
  wire [2:0] _GEN_48 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_47; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 10729:8]
  wire  _T_1315 = io_in_d_bits_opcode == _GEN_48; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 10729:8]
  wire [2:0] _GEN_55 = 3'h6 == a_opcode_lookup[2:0] ? 3'h5 : _GEN_46; // @[Monitor.scala 692:38 freechips.rocketchip.system.LitexConfig.fir 10731:8]
  wire [2:0] _GEN_56 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_55; // @[Monitor.scala 692:38 freechips.rocketchip.system.LitexConfig.fir 10731:8]
  wire  _T_1317 = io_in_d_bits_opcode == _GEN_56; // @[Monitor.scala 692:38 freechips.rocketchip.system.LitexConfig.fir 10731:8]
  wire  _T_1318 = _T_1315 | _T_1317; // @[Monitor.scala 691:72 freechips.rocketchip.system.LitexConfig.fir 10732:8]
  wire  _T_1320 = _T_1318 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10734:8]
  wire  _T_1321 = ~_T_1320; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10735:8]
  wire [7:0] a_size_lookup = _T_1242[7:0]; // @[freechips.rocketchip.system.LitexConfig.fir 10580:4 freechips.rocketchip.system.LitexConfig.fir 10581:4 Monitor.scala 640:19 freechips.rocketchip.system.LitexConfig.fir 10590:4]
  wire [7:0] _GEN_83 = {{4'd0}, io_in_d_bits_size}; // @[Monitor.scala 693:36 freechips.rocketchip.system.LitexConfig.fir 10740:8]
  wire  _T_1322 = _GEN_83 == a_size_lookup; // @[Monitor.scala 693:36 freechips.rocketchip.system.LitexConfig.fir 10740:8]
  wire  _T_1324 = _T_1322 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10742:8]
  wire  _T_1325 = ~_T_1324; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10743:8]
  wire  _T_1327 = _T_1267 & a_first; // @[Monitor.scala 696:36 freechips.rocketchip.system.LitexConfig.fir 10751:4]
  wire  _T_1328 = _T_1327 & io_in_a_valid; // @[Monitor.scala 696:47 freechips.rocketchip.system.LitexConfig.fir 10752:4]
  wire  _T_1330 = _T_1328 & _T_1296; // @[Monitor.scala 696:65 freechips.rocketchip.system.LitexConfig.fir 10754:4]
  wire  _T_1332 = _T_1330 & _T_1269; // @[Monitor.scala 696:116 freechips.rocketchip.system.LitexConfig.fir 10756:4]
  wire  _T_1333 = ~io_in_d_ready; // @[Monitor.scala 697:15 freechips.rocketchip.system.LitexConfig.fir 10758:6]
  wire  _T_1334 = _T_1333 | io_in_a_ready; // @[Monitor.scala 697:32 freechips.rocketchip.system.LitexConfig.fir 10759:6]
  wire  _T_1336 = _T_1334 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10761:6]
  wire  _T_1337 = ~_T_1336; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10762:6]
  wire  _T_1338 = a_set_wo_ready != d_clr_wo_ready; // @[Monitor.scala 701:29 freechips.rocketchip.system.LitexConfig.fir 10768:4]
  wire  _T_1339 = |a_set_wo_ready; // @[Monitor.scala 701:67 freechips.rocketchip.system.LitexConfig.fir 10769:4]
  wire  _T_1340 = ~_T_1339; // @[Monitor.scala 701:51 freechips.rocketchip.system.LitexConfig.fir 10770:4]
  wire  _T_1341 = _T_1338 | _T_1340; // @[Monitor.scala 701:48 freechips.rocketchip.system.LitexConfig.fir 10771:4]
  wire  _T_1343 = _T_1341 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10773:4]
  wire  _T_1344 = ~_T_1343; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10774:4]
  wire [15:0] _T_1345 = inflight | a_set; // @[Monitor.scala 704:27 freechips.rocketchip.system.LitexConfig.fir 10779:4]
  wire [15:0] _T_1346 = ~d_clr; // @[Monitor.scala 704:38 freechips.rocketchip.system.LitexConfig.fir 10780:4]
  wire [15:0] _T_1347 = _T_1345 & _T_1346; // @[Monitor.scala 704:36 freechips.rocketchip.system.LitexConfig.fir 10781:4]
  wire [63:0] a_opcodes_set = _GEN_19[63:0]; // @[freechips.rocketchip.system.LitexConfig.fir 10565:4 freechips.rocketchip.system.LitexConfig.fir 10566:4 Monitor.scala 658:28 freechips.rocketchip.system.LitexConfig.fir 10633:6]
  wire [63:0] _T_1348 = inflight_opcodes | a_opcodes_set; // @[Monitor.scala 705:43 freechips.rocketchip.system.LitexConfig.fir 10783:4]
  wire [63:0] d_opcodes_clr = _GEN_23[63:0]; // @[freechips.rocketchip.system.LitexConfig.fir 10652:4 freechips.rocketchip.system.LitexConfig.fir 10653:4 Monitor.scala 679:21 freechips.rocketchip.system.LitexConfig.fir 10679:6]
  wire [63:0] _T_1349 = ~d_opcodes_clr; // @[Monitor.scala 705:62 freechips.rocketchip.system.LitexConfig.fir 10784:4]
  wire [63:0] _T_1350 = _T_1348 & _T_1349; // @[Monitor.scala 705:60 freechips.rocketchip.system.LitexConfig.fir 10785:4]
  wire [127:0] a_sizes_set = _GEN_20[127:0]; // @[freechips.rocketchip.system.LitexConfig.fir 10567:4 freechips.rocketchip.system.LitexConfig.fir 10568:4 Monitor.scala 659:28 freechips.rocketchip.system.LitexConfig.fir 10636:6]
  wire [127:0] _T_1351 = inflight_sizes | a_sizes_set; // @[Monitor.scala 706:39 freechips.rocketchip.system.LitexConfig.fir 10787:4]
  wire [127:0] d_sizes_clr = _GEN_24[127:0]; // @[freechips.rocketchip.system.LitexConfig.fir 10654:4 freechips.rocketchip.system.LitexConfig.fir 10655:4 Monitor.scala 680:21 freechips.rocketchip.system.LitexConfig.fir 10686:6]
  wire [127:0] _T_1352 = ~d_sizes_clr; // @[Monitor.scala 706:56 freechips.rocketchip.system.LitexConfig.fir 10788:4]
  wire [127:0] _T_1353 = _T_1351 & _T_1352; // @[Monitor.scala 706:54 freechips.rocketchip.system.LitexConfig.fir 10789:4]
  reg [31:0] _T_1354; // @[Monitor.scala 708:27 freechips.rocketchip.system.LitexConfig.fir 10791:4]
  wire  _T_1355 = |inflight; // @[Monitor.scala 711:26 freechips.rocketchip.system.LitexConfig.fir 10794:4]
  wire  _T_1356 = ~_T_1355; // @[Monitor.scala 711:16 freechips.rocketchip.system.LitexConfig.fir 10795:4]
  wire  _T_1357 = plusarg_reader_out == 32'h0; // @[Monitor.scala 711:39 freechips.rocketchip.system.LitexConfig.fir 10796:4]
  wire  _T_1358 = _T_1356 | _T_1357; // @[Monitor.scala 711:30 freechips.rocketchip.system.LitexConfig.fir 10797:4]
  wire  _T_1359 = _T_1354 < plusarg_reader_out; // @[Monitor.scala 711:59 freechips.rocketchip.system.LitexConfig.fir 10798:4]
  wire  _T_1360 = _T_1358 | _T_1359; // @[Monitor.scala 711:47 freechips.rocketchip.system.LitexConfig.fir 10799:4]
  wire  _T_1362 = _T_1360 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10801:4]
  wire  _T_1363 = ~_T_1362; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10802:4]
  wire [31:0] _T_1365 = _T_1354 + 32'h1; // @[Monitor.scala 713:26 freechips.rocketchip.system.LitexConfig.fir 10808:4]
  wire  _T_1368 = _T_1088 | _T_1137; // @[Monitor.scala 714:27 freechips.rocketchip.system.LitexConfig.fir 10812:4]
  reg [15:0] inflight_1; // @[Monitor.scala 725:35 freechips.rocketchip.system.LitexConfig.fir 10816:4]
  reg [127:0] inflight_sizes_1; // @[Monitor.scala 727:35 freechips.rocketchip.system.LitexConfig.fir 10818:4]
  reg [8:0] _T_1397; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 10853:4]
  wire [8:0] _T_1399 = _T_1397 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 10855:4]
  wire  d_first_1 = _T_1397 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 10856:4]
  wire [127:0] _T_1416 = inflight_sizes_1 >> _T_1235; // @[Monitor.scala 749:42 freechips.rocketchip.system.LitexConfig.fir 10889:4]
  wire [127:0] _T_1421 = _T_1416 & _GEN_75; // @[Monitor.scala 749:93 freechips.rocketchip.system.LitexConfig.fir 10894:4]
  wire [127:0] _T_1422 = {{1'd0}, _T_1421[127:1]}; // @[Monitor.scala 749:146 freechips.rocketchip.system.LitexConfig.fir 10895:4]
  wire  _T_1462 = io_in_d_valid & d_first_1; // @[Monitor.scala 781:26 freechips.rocketchip.system.LitexConfig.fir 10973:4]
  wire  _T_1464 = _T_1462 & _T_944; // @[Monitor.scala 781:71 freechips.rocketchip.system.LitexConfig.fir 10975:4]
  wire  _T_1467 = _T_1137 & d_first_1; // @[Monitor.scala 785:27 freechips.rocketchip.system.LitexConfig.fir 10981:4]
  wire  _T_1469 = _T_1467 & _T_944; // @[Monitor.scala 785:72 freechips.rocketchip.system.LitexConfig.fir 10983:4]
  wire [15:0] d_clr_1 = _T_1469 ? _T_1271 : 16'h0; // @[Monitor.scala 785:90 freechips.rocketchip.system.LitexConfig.fir 10984:4]
  wire [142:0] _GEN_69 = _T_1469 ? _T_1289 : 143'h0; // @[Monitor.scala 785:90 freechips.rocketchip.system.LitexConfig.fir 10984:4]
  wire [15:0] _T_1496 = inflight_1 >> io_in_d_bits_source; // @[Monitor.scala 793:25 freechips.rocketchip.system.LitexConfig.fir 11019:6]
  wire  _T_1500 = _T_1496[0] | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 11023:6]
  wire  _T_1501 = ~_T_1500; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 11024:6]
  wire [7:0] c_size_lookup = _T_1422[7:0]; // @[freechips.rocketchip.system.LitexConfig.fir 10877:4 freechips.rocketchip.system.LitexConfig.fir 10878:4 Monitor.scala 749:21 freechips.rocketchip.system.LitexConfig.fir 10896:4]
  wire  _T_1507 = _GEN_83 == c_size_lookup; // @[Monitor.scala 797:36 freechips.rocketchip.system.LitexConfig.fir 11042:8]
  wire  _T_1509 = _T_1507 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 11044:8]
  wire  _T_1510 = ~_T_1509; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 11045:8]
  wire [15:0] _T_1531 = ~d_clr_1; // @[Monitor.scala 811:46 freechips.rocketchip.system.LitexConfig.fir 11087:4]
  wire [15:0] _T_1532 = inflight_1 & _T_1531; // @[Monitor.scala 811:44 freechips.rocketchip.system.LitexConfig.fir 11088:4]
  wire [127:0] d_sizes_clr_1 = _GEN_69[127:0]; // @[freechips.rocketchip.system.LitexConfig.fir 10970:4 freechips.rocketchip.system.LitexConfig.fir 10971:4 Monitor.scala 788:21 freechips.rocketchip.system.LitexConfig.fir 11000:6]
  wire [127:0] _T_1537 = ~d_sizes_clr_1; // @[Monitor.scala 813:58 freechips.rocketchip.system.LitexConfig.fir 11095:4]
  wire [127:0] _T_1538 = inflight_sizes_1 & _T_1537; // @[Monitor.scala 813:56 freechips.rocketchip.system.LitexConfig.fir 11096:4]
  reg [31:0] _T_1539; // @[Monitor.scala 815:27 freechips.rocketchip.system.LitexConfig.fir 11098:4]
  wire  _T_1540 = |inflight_1; // @[Monitor.scala 818:26 freechips.rocketchip.system.LitexConfig.fir 11101:4]
  wire  _T_1541 = ~_T_1540; // @[Monitor.scala 818:16 freechips.rocketchip.system.LitexConfig.fir 11102:4]
  wire  _T_1542 = plusarg_reader_1_out == 32'h0; // @[Monitor.scala 818:39 freechips.rocketchip.system.LitexConfig.fir 11103:4]
  wire  _T_1543 = _T_1541 | _T_1542; // @[Monitor.scala 818:30 freechips.rocketchip.system.LitexConfig.fir 11104:4]
  wire  _T_1544 = _T_1539 < plusarg_reader_1_out; // @[Monitor.scala 818:59 freechips.rocketchip.system.LitexConfig.fir 11105:4]
  wire  _T_1545 = _T_1543 | _T_1544; // @[Monitor.scala 818:47 freechips.rocketchip.system.LitexConfig.fir 11106:4]
  wire  _T_1547 = _T_1545 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11108:4]
  wire  _T_1548 = ~_T_1547; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11109:4]
  wire [31:0] _T_1550 = _T_1539 + 32'h1; // @[Monitor.scala 820:26 freechips.rocketchip.system.LitexConfig.fir 11115:4]
  wire  _GEN_93 = io_in_a_valid & _T_126; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9051:10]
  wire  _GEN_109 = io_in_a_valid & _T_210; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9169:10]
  wire  _GEN_127 = io_in_a_valid & _T_298; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9275:10]
  wire  _GEN_141 = io_in_a_valid & _T_409; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9488:10]
  wire  _GEN_151 = io_in_a_valid & _T_521; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9622:10]
  wire  _GEN_161 = io_in_a_valid & _T_635; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9736:10]
  wire  _GEN_171 = io_in_a_valid & _T_725; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9848:10]
  wire  _GEN_181 = io_in_a_valid & _T_815; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9972:10]
  wire  _GEN_193 = io_in_d_valid & _T_944; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10052:10]
  wire  _GEN_203 = io_in_d_valid & _T_964; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10094:10]
  wire  _GEN_213 = io_in_d_valid & _T_992; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10152:10]
  wire  _GEN_223 = io_in_d_valid & _T_1021; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10211:10]
  wire  _GEN_229 = io_in_d_valid & _T_1038; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10246:10]
  wire  _GEN_235 = io_in_d_valid & _T_1056; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10282:10]
  wire  _GEN_241 = _T_1270 & _T_1297; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10715:10]
  wire  _GEN_245 = ~_T_1297; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10737:10]
  wire  _GEN_246 = _T_1270 & _GEN_245; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10737:10]
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader ( // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 10792:4]
    .out(plusarg_reader_out)
  );
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader_1 ( // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 11099:4]
    .out(plusarg_reader_1_out)
  );
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  _T_1097 = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  _T_1108 = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  _T_1109 = _RAND_2[2:0];
  _RAND_3 = {1{`RANDOM}};
  _T_1110 = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  _T_1111 = _RAND_4[3:0];
  _RAND_5 = {1{`RANDOM}};
  _T_1112 = _RAND_5[31:0];
  _RAND_6 = {1{`RANDOM}};
  _T_1145 = _RAND_6[8:0];
  _RAND_7 = {1{`RANDOM}};
  _T_1156 = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  _T_1157 = _RAND_8[1:0];
  _RAND_9 = {1{`RANDOM}};
  _T_1158 = _RAND_9[3:0];
  _RAND_10 = {1{`RANDOM}};
  _T_1159 = _RAND_10[3:0];
  _RAND_11 = {1{`RANDOM}};
  _T_1160 = _RAND_11[1:0];
  _RAND_12 = {1{`RANDOM}};
  _T_1161 = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  inflight = _RAND_13[15:0];
  _RAND_14 = {2{`RANDOM}};
  inflight_opcodes = _RAND_14[63:0];
  _RAND_15 = {4{`RANDOM}};
  inflight_sizes = _RAND_15[127:0];
  _RAND_16 = {1{`RANDOM}};
  _T_1199 = _RAND_16[8:0];
  _RAND_17 = {1{`RANDOM}};
  _T_1217 = _RAND_17[8:0];
  _RAND_18 = {1{`RANDOM}};
  _T_1354 = _RAND_18[31:0];
  _RAND_19 = {1{`RANDOM}};
  inflight_1 = _RAND_19[15:0];
  _RAND_20 = {4{`RANDOM}};
  inflight_sizes_1 = _RAND_20[127:0];
  _RAND_21 = {1{`RANDOM}};
  _T_1397 = _RAND_21[8:0];
  _RAND_22 = {1{`RANDOM}};
  _T_1539 = _RAND_22[31:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
  always @(posedge clock) begin
    if (reset) begin
      _T_1097 <= 9'h0;
    end else if (_T_1088) begin
      if (_T_1100) begin
        if (_T_1095) begin
          _T_1097 <= _T_25[11:3];
        end else begin
          _T_1097 <= 9'h0;
        end
      end else begin
        _T_1097 <= _T_1099;
      end
    end
    if (_T_1136) begin
      _T_1108 <= io_in_a_bits_opcode;
    end
    if (_T_1136) begin
      _T_1109 <= io_in_a_bits_param;
    end
    if (_T_1136) begin
      _T_1110 <= io_in_a_bits_size;
    end
    if (_T_1136) begin
      _T_1111 <= io_in_a_bits_source;
    end
    if (_T_1136) begin
      _T_1112 <= io_in_a_bits_address;
    end
    if (reset) begin
      _T_1145 <= 9'h0;
    end else if (_T_1137) begin
      if (_T_1148) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_1145 <= _T_1141[11:3];
        end else begin
          _T_1145 <= 9'h0;
        end
      end else begin
        _T_1145 <= _T_1147;
      end
    end
    if (_T_1189) begin
      _T_1156 <= io_in_d_bits_opcode;
    end
    if (_T_1189) begin
      _T_1157 <= io_in_d_bits_param;
    end
    if (_T_1189) begin
      _T_1158 <= io_in_d_bits_size;
    end
    if (_T_1189) begin
      _T_1159 <= io_in_d_bits_source;
    end
    if (_T_1189) begin
      _T_1160 <= io_in_d_bits_sink;
    end
    if (_T_1189) begin
      _T_1161 <= io_in_d_bits_denied;
    end
    if (reset) begin
      inflight <= 16'h0;
    end else begin
      inflight <= _T_1347;
    end
    if (reset) begin
      inflight_opcodes <= 64'h0;
    end else begin
      inflight_opcodes <= _T_1350;
    end
    if (reset) begin
      inflight_sizes <= 128'h0;
    end else begin
      inflight_sizes <= _T_1353;
    end
    if (reset) begin
      _T_1199 <= 9'h0;
    end else if (_T_1088) begin
      if (a_first) begin
        if (_T_1095) begin
          _T_1199 <= _T_25[11:3];
        end else begin
          _T_1199 <= 9'h0;
        end
      end else begin
        _T_1199 <= _T_1201;
      end
    end
    if (reset) begin
      _T_1217 <= 9'h0;
    end else if (_T_1137) begin
      if (d_first) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_1217 <= _T_1141[11:3];
        end else begin
          _T_1217 <= 9'h0;
        end
      end else begin
        _T_1217 <= _T_1219;
      end
    end
    if (reset) begin
      _T_1354 <= 32'h0;
    end else if (_T_1368) begin
      _T_1354 <= 32'h0;
    end else begin
      _T_1354 <= _T_1365;
    end
    if (reset) begin
      inflight_1 <= 16'h0;
    end else begin
      inflight_1 <= _T_1532;
    end
    if (reset) begin
      inflight_sizes_1 <= 128'h0;
    end else begin
      inflight_sizes_1 <= _T_1538;
    end
    if (reset) begin
      _T_1397 <= 9'h0;
    end else if (_T_1137) begin
      if (d_first_1) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_1397 <= _T_1141[11:3];
        end else begin
          _T_1397 <= 9'h0;
        end
      end else begin
        _T_1397 <= _T_1399;
      end
    end
    if (reset) begin
      _T_1539 <= 32'h0;
    end else if (_T_1137) begin
      _T_1539 <= 32'h0;
    end else begin
      _T_1539 <= _T_1550;
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquireBlock type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9051:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9052:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_186) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquireBlock from a client which does not support Probe (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9070:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_186) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9071:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9077:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9078:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_193) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock smaller than a beat (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9085:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_193) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9086:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9092:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9093:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_200) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock carries invalid grow param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9100:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_200) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9101:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_205) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9109:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_205) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9110:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_209) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9117:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_209) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9118:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquirePerm type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9169:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9170:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_186) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquirePerm from a client which does not support Probe (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9188:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_186) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9189:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9195:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9196:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_193) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm smaller than a beat (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9203:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_193) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9204:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9210:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9211:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_200) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm carries invalid grow param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9218:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_200) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9219:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_288) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm requests NtoB (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9226:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_288) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9227:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_205) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9235:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_205) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9236:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_209) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9243:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_209) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9244:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_323) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Get type which master claims it can't emit (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9275:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_323) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9276:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_390) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Get type which slave claims it can't support (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9346:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_390) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9347:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9353:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9354:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9360:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9361:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_400) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9368:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_400) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9369:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_404) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9376:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_404) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9377:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_209) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9384:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_209) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9385:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_141 & _T_506) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries PutFull type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9488:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_141 & _T_506) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9489:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_141 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9495:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_141 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9496:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_141 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9502:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_141 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9503:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_141 & _T_400) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9510:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_141 & _T_400) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9511:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_141 & _T_404) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9518:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_141 & _T_404) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9519:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_151 & _T_506) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries PutPartial type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9622:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_151 & _T_506) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9623:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_151 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9629:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_151 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9630:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_151 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9636:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_151 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9637:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_151 & _T_400) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9644:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_151 & _T_400) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9645:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_151 & _T_634) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9654:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_151 & _T_634) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9655:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_161 & _T_710) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Arithmetic type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9736:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_161 & _T_710) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9737:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_161 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9743:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_161 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9744:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_161 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9750:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_161 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9751:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_161 & _T_720) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic carries invalid opcode param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9758:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_161 & _T_720) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9759:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_161 & _T_404) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9766:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_161 & _T_404) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9767:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_171 & _T_710) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Logical type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9848:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_171 & _T_710) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9849:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_171 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9855:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_171 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9856:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_171 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9862:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_171 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9863:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_171 & _T_810) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical carries invalid opcode param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9870:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_171 & _T_810) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9871:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_171 & _T_404) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9878:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_171 & _T_404) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9879:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_181 & _T_902) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Hint type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9972:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_181 & _T_902) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9973:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_181 & _T_189) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9979:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_181 & _T_189) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9980:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_181 & _T_196) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9986:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_181 & _T_196) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9987:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_181 & _T_912) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint carries invalid opcode param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9994:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_181 & _T_912) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 9995:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_181 & _T_404) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10002:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_181 & _T_404) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10003:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_181 & _T_209) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10010:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_181 & _T_209) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10011:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_924) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel has invalid opcode (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10021:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_924) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10022:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_193 & _T_947) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10052:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_193 & _T_947) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10053:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_193 & _T_951) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck smaller than a beat (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10060:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_193 & _T_951) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10061:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_193 & _T_955) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseeAck carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10068:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_193 & _T_955) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10069:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_193 & _T_959) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10076:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_193 & _T_959) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10077:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_193 & _T_963) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck is denied (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10084:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_193 & _T_963) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10085:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_203 & _T_947) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10094:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_203 & _T_947) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10095:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_203 & _T_951) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant smaller than a beat (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10109:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_203 & _T_951) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10110:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_203 & _T_978) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant carries invalid cap param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10117:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_203 & _T_978) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10118:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_203 & _T_982) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant carries toN param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10125:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_203 & _T_982) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10126:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_203 & _T_959) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10133:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_203 & _T_959) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10134:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_213 & _T_947) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10152:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_213 & _T_947) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10153:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_213 & _T_951) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData smaller than a beat (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10167:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_213 & _T_951) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10168:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_213 & _T_978) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData carries invalid cap param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10175:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_213 & _T_978) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10176:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_213 & _T_982) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData carries toN param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10183:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_213 & _T_982) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10184:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_213 & _T_1015) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData is denied but not corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10192:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_213 & _T_1015) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10193:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_223 & _T_947) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAck carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10211:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_223 & _T_947) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10212:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_223 & _T_955) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAck carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10219:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_223 & _T_955) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10220:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_223 & _T_959) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAck is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10227:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_223 & _T_959) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10228:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_229 & _T_947) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10246:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_229 & _T_947) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10247:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_229 & _T_955) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAckData carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10254:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_229 & _T_955) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10255:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_229 & _T_1015) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAckData is denied but not corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10263:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_229 & _T_1015) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10264:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_235 & _T_947) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel HintAck carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10282:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_235 & _T_947) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10283:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_235 & _T_955) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel HintAck carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10290:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_235 & _T_955) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10291:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_235 & _T_959) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel HintAck is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10298:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_235 & _T_959) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10299:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1114 & _T_1118) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel opcode changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10378:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1114 & _T_1118) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10379:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1114 & _T_1122) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel param changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10386:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1114 & _T_1122) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10387:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1114 & _T_1126) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel size changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10394:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1114 & _T_1126) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10395:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1114 & _T_1130) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel source changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10402:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1114 & _T_1130) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10403:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1114 & _T_1134) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel address changed with multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10410:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1114 & _T_1134) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10411:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1163 & _T_1167) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel opcode changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10459:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1163 & _T_1167) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10460:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1163 & _T_1171) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel param changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10467:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1163 & _T_1171) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10468:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1163 & _T_1175) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel size changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10475:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1163 & _T_1175) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10476:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1163 & _T_1179) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel source changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10483:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1163 & _T_1179) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10484:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1163 & _T_1183) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel sink changed with multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10491:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1163 & _T_1183) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10492:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1163 & _T_1187) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel denied changed with multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10499:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1163 & _T_1187) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10500:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1249 & _T_1265) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel re-used a source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10644:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1249 & _T_1265) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10645:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1270 & _T_1303) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10704:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1270 & _T_1303) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10705:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_241 & _T_1309) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10715:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_241 & _T_1309) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10716:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_241 & _T_1313) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10723:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_241 & _T_1313) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10724:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_246 & _T_1321) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10737:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_246 & _T_1321) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10738:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_246 & _T_1325) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10745:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_246 & _T_1325) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10746:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1332 & _T_1337) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10764:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1332 & _T_1337) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10765:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1344) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10776:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1344) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 10777:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1363) begin
          $fwrite(32'h80000002,"Assertion failed: TileLink timeout expired (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10804:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1363) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 10805:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1464 & _T_1501) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 11026:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1464 & _T_1501) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 11027:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1464 & _T_1510) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 11047:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1464 & _T_1510) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 11048:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1548) begin
          $fwrite(32'h80000002,"Assertion failed: TileLink timeout expired (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11111:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1548) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11112:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
endmodule
module TLMonitor_3( // @[freechips.rocketchip.system.LitexConfig.fir 11142:2]
  input         clock, // @[freechips.rocketchip.system.LitexConfig.fir 11143:4]
  input         reset, // @[freechips.rocketchip.system.LitexConfig.fir 11144:4]
  input         io_in_a_ready, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input         io_in_a_valid, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [2:0]  io_in_a_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [2:0]  io_in_a_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [3:0]  io_in_a_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [1:0]  io_in_a_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [31:0] io_in_a_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [7:0]  io_in_a_bits_mask, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input         io_in_a_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input         io_in_b_ready, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input         io_in_b_valid, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [1:0]  io_in_b_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [31:0] io_in_b_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input         io_in_c_ready, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input         io_in_c_valid, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [2:0]  io_in_c_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [2:0]  io_in_c_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [3:0]  io_in_c_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [1:0]  io_in_c_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [31:0] io_in_c_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input         io_in_c_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input         io_in_d_ready, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input         io_in_d_valid, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [2:0]  io_in_d_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [1:0]  io_in_d_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [3:0]  io_in_d_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [1:0]  io_in_d_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [1:0]  io_in_d_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input         io_in_d_bits_denied, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input         io_in_d_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input         io_in_e_valid, // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
  input  [1:0]  io_in_e_bits_sink // @[freechips.rocketchip.system.LitexConfig.fir 11145:4]
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [31:0] _RAND_14;
  reg [31:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [31:0] _RAND_20;
  reg [31:0] _RAND_21;
  reg [31:0] _RAND_22;
  reg [31:0] _RAND_23;
  reg [31:0] _RAND_24;
  reg [31:0] _RAND_25;
  reg [31:0] _RAND_26;
  reg [31:0] _RAND_27;
  reg [31:0] _RAND_28;
  reg [31:0] _RAND_29;
  reg [31:0] _RAND_30;
  reg [31:0] _RAND_31;
  reg [31:0] _RAND_32;
  reg [31:0] _RAND_33;
  reg [31:0] _RAND_34;
`endif // RANDOMIZE_REG_INIT
  wire [31:0] plusarg_reader_out; // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 14301:4]
  wire [31:0] plusarg_reader_1_out; // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 14568:4]
  wire  _T_4 = io_in_a_bits_source == 2'h0; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 11156:6]
  wire  _T_5 = io_in_a_bits_source == 2'h1; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 11157:6]
  wire  _T_6 = io_in_a_bits_source == 2'h2; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 11158:6]
  wire  _T_8 = _T_4 | _T_5; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 11164:6]
  wire  _T_9 = _T_8 | _T_6; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 11165:6]
  wire [26:0] _T_11 = 27'hfff << io_in_a_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 11167:6]
  wire [11:0] _T_13 = ~_T_11[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 11169:6]
  wire [31:0] _GEN_86 = {{20'd0}, _T_13}; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 11170:6]
  wire [31:0] _T_14 = io_in_a_bits_address & _GEN_86; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 11170:6]
  wire  _T_15 = _T_14 == 32'h0; // @[Edges.scala 22:24 freechips.rocketchip.system.LitexConfig.fir 11171:6]
  wire [3:0] _T_18 = 4'h1 << io_in_a_bits_size[1:0]; // @[OneHot.scala 65:12 freechips.rocketchip.system.LitexConfig.fir 11174:6]
  wire [2:0] _T_20 = _T_18[2:0] | 3'h1; // @[Misc.scala 201:81 freechips.rocketchip.system.LitexConfig.fir 11176:6]
  wire  _T_21 = io_in_a_bits_size >= 4'h3; // @[Misc.scala 205:21 freechips.rocketchip.system.LitexConfig.fir 11177:6]
  wire  _T_24 = ~io_in_a_bits_address[2]; // @[Misc.scala 210:20 freechips.rocketchip.system.LitexConfig.fir 11180:6]
  wire  _T_26 = _T_20[2] & _T_24; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 11182:6]
  wire  _T_27 = _T_21 | _T_26; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 11183:6]
  wire  _T_29 = _T_20[2] & io_in_a_bits_address[2]; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 11185:6]
  wire  _T_30 = _T_21 | _T_29; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 11186:6]
  wire  _T_33 = ~io_in_a_bits_address[1]; // @[Misc.scala 210:20 freechips.rocketchip.system.LitexConfig.fir 11189:6]
  wire  _T_34 = _T_24 & _T_33; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 11190:6]
  wire  _T_35 = _T_20[1] & _T_34; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 11191:6]
  wire  _T_36 = _T_27 | _T_35; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 11192:6]
  wire  _T_37 = _T_24 & io_in_a_bits_address[1]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 11193:6]
  wire  _T_38 = _T_20[1] & _T_37; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 11194:6]
  wire  _T_39 = _T_27 | _T_38; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 11195:6]
  wire  _T_40 = io_in_a_bits_address[2] & _T_33; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 11196:6]
  wire  _T_41 = _T_20[1] & _T_40; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 11197:6]
  wire  _T_42 = _T_30 | _T_41; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 11198:6]
  wire  _T_43 = io_in_a_bits_address[2] & io_in_a_bits_address[1]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 11199:6]
  wire  _T_44 = _T_20[1] & _T_43; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 11200:6]
  wire  _T_45 = _T_30 | _T_44; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 11201:6]
  wire  _T_48 = ~io_in_a_bits_address[0]; // @[Misc.scala 210:20 freechips.rocketchip.system.LitexConfig.fir 11204:6]
  wire  _T_49 = _T_34 & _T_48; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 11205:6]
  wire  _T_50 = _T_20[0] & _T_49; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 11206:6]
  wire  _T_51 = _T_36 | _T_50; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 11207:6]
  wire  _T_52 = _T_34 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 11208:6]
  wire  _T_53 = _T_20[0] & _T_52; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 11209:6]
  wire  _T_54 = _T_36 | _T_53; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 11210:6]
  wire  _T_55 = _T_37 & _T_48; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 11211:6]
  wire  _T_56 = _T_20[0] & _T_55; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 11212:6]
  wire  _T_57 = _T_39 | _T_56; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 11213:6]
  wire  _T_58 = _T_37 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 11214:6]
  wire  _T_59 = _T_20[0] & _T_58; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 11215:6]
  wire  _T_60 = _T_39 | _T_59; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 11216:6]
  wire  _T_61 = _T_40 & _T_48; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 11217:6]
  wire  _T_62 = _T_20[0] & _T_61; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 11218:6]
  wire  _T_63 = _T_42 | _T_62; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 11219:6]
  wire  _T_64 = _T_40 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 11220:6]
  wire  _T_65 = _T_20[0] & _T_64; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 11221:6]
  wire  _T_66 = _T_42 | _T_65; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 11222:6]
  wire  _T_67 = _T_43 & _T_48; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 11223:6]
  wire  _T_68 = _T_20[0] & _T_67; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 11224:6]
  wire  _T_69 = _T_45 | _T_68; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 11225:6]
  wire  _T_70 = _T_43 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 11226:6]
  wire  _T_71 = _T_20[0] & _T_70; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 11227:6]
  wire  _T_72 = _T_45 | _T_71; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 11228:6]
  wire [7:0] _T_79 = {_T_72,_T_69,_T_66,_T_63,_T_60,_T_57,_T_54,_T_51}; // @[Cat.scala 29:58 freechips.rocketchip.system.LitexConfig.fir 11235:6]
  wire [32:0] _T_83 = {1'b0,$signed(io_in_a_bits_address)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 11239:6]
  wire  _T_109 = io_in_a_bits_opcode == 3'h6; // @[Monitor.scala 83:25 freechips.rocketchip.system.LitexConfig.fir 11269:6]
  wire  _T_111 = io_in_a_bits_size <= 4'hc; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 11272:8]
  wire  _T_118 = _T_111 & _T_9; // @[Parameters.scala 1195:30 freechips.rocketchip.system.LitexConfig.fir 11279:8]
  wire  _T_128 = io_in_a_bits_size <= 4'h6; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 11289:8]
  wire [31:0] _T_131 = io_in_a_bits_address ^ 32'h80000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 11292:8]
  wire [32:0] _T_132 = {1'b0,$signed(_T_131)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 11293:8]
  wire [32:0] _T_134 = $signed(_T_132) & 33'sh80000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 11295:8]
  wire  _T_135 = $signed(_T_134) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 11296:8]
  wire  _T_136 = _T_128 & _T_135; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 11297:8]
  wire  _T_139 = _T_118 & _T_136; // @[Parameters.scala 1402:195 freechips.rocketchip.system.LitexConfig.fir 11300:8]
  wire  _T_141 = _T_139 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11302:8]
  wire  _T_142 = ~_T_141; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11303:8]
  wire  _T_147 = 4'h6 == io_in_a_bits_size; // @[Parameters.scala 92:48 freechips.rocketchip.system.LitexConfig.fir 11316:8]
  wire  _T_148 = _T_4 & _T_147; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 11317:8]
  wire  _T_165 = _T_148 & _T_111; // @[Parameters.scala 1417:195 freechips.rocketchip.system.LitexConfig.fir 11335:8]
  wire  _T_167 = _T_165 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11337:8]
  wire  _T_168 = ~_T_167; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11338:8]
  wire  _T_170 = _T_9 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11344:8]
  wire  _T_171 = ~_T_170; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11345:8]
  wire  _T_174 = _T_21 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11352:8]
  wire  _T_175 = ~_T_174; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11353:8]
  wire  _T_177 = _T_15 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11359:8]
  wire  _T_178 = ~_T_177; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11360:8]
  wire  _T_179 = io_in_a_bits_param <= 3'h2; // @[Bundles.scala 110:27 freechips.rocketchip.system.LitexConfig.fir 11365:8]
  wire  _T_181 = _T_179 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11367:8]
  wire  _T_182 = ~_T_181; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11368:8]
  wire [7:0] _T_183 = ~io_in_a_bits_mask; // @[Monitor.scala 90:18 freechips.rocketchip.system.LitexConfig.fir 11373:8]
  wire  _T_184 = _T_183 == 8'h0; // @[Monitor.scala 90:31 freechips.rocketchip.system.LitexConfig.fir 11374:8]
  wire  _T_186 = _T_184 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11376:8]
  wire  _T_187 = ~_T_186; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11377:8]
  wire  _T_188 = ~io_in_a_bits_corrupt; // @[Monitor.scala 91:18 freechips.rocketchip.system.LitexConfig.fir 11382:8]
  wire  _T_190 = _T_188 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11384:8]
  wire  _T_191 = ~_T_190; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11385:8]
  wire  _T_192 = io_in_a_bits_opcode == 3'h7; // @[Monitor.scala 94:25 freechips.rocketchip.system.LitexConfig.fir 11391:6]
  wire  _T_266 = io_in_a_bits_param != 3'h0; // @[Monitor.scala 101:31 freechips.rocketchip.system.LitexConfig.fir 11495:8]
  wire  _T_268 = _T_266 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11497:8]
  wire  _T_269 = ~_T_268; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11498:8]
  wire  _T_279 = io_in_a_bits_opcode == 3'h4; // @[Monitor.scala 106:25 freechips.rocketchip.system.LitexConfig.fir 11521:6]
  wire  _T_291 = _T_118 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11534:8]
  wire  _T_292 = ~_T_291; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11535:8]
  wire [31:0] _T_297 = io_in_a_bits_address ^ 32'h2000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 11544:8]
  wire [32:0] _T_298 = {1'b0,$signed(_T_297)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 11545:8]
  wire [32:0] _T_300 = $signed(_T_298) & 33'shfa012000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 11547:8]
  wire  _T_301 = $signed(_T_300) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 11548:8]
  wire  _T_302 = _T_111 & _T_301; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 11549:8]
  wire [32:0] _T_310 = $signed(_T_83) & 33'shfa012000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 11557:8]
  wire  _T_311 = $signed(_T_310) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 11558:8]
  wire [31:0] _T_312 = io_in_a_bits_address ^ 32'h10000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 11559:8]
  wire [32:0] _T_313 = {1'b0,$signed(_T_312)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 11560:8]
  wire [32:0] _T_315 = $signed(_T_313) & 33'shfa010000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 11562:8]
  wire  _T_316 = $signed(_T_315) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 11563:8]
  wire [31:0] _T_317 = io_in_a_bits_address ^ 32'h2000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 11564:8]
  wire [32:0] _T_318 = {1'b0,$signed(_T_317)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 11565:8]
  wire [32:0] _T_320 = $signed(_T_318) & 33'shfa010000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 11567:8]
  wire  _T_321 = $signed(_T_320) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 11568:8]
  wire [31:0] _T_322 = io_in_a_bits_address ^ 32'h8000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 11569:8]
  wire [32:0] _T_323 = {1'b0,$signed(_T_322)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 11570:8]
  wire [32:0] _T_325 = $signed(_T_323) & 33'shf8000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 11572:8]
  wire  _T_326 = $signed(_T_325) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 11573:8]
  wire [31:0] _T_327 = io_in_a_bits_address ^ 32'h10000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 11574:8]
  wire [32:0] _T_328 = {1'b0,$signed(_T_327)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 11575:8]
  wire [32:0] _T_330 = $signed(_T_328) & 33'shf0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 11577:8]
  wire  _T_331 = $signed(_T_330) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 11578:8]
  wire [31:0] _T_332 = io_in_a_bits_address ^ 32'h20000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 11579:8]
  wire [32:0] _T_333 = {1'b0,$signed(_T_332)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 11580:8]
  wire [32:0] _T_335 = $signed(_T_333) & 33'she0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 11582:8]
  wire  _T_336 = $signed(_T_335) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 11583:8]
  wire [31:0] _T_337 = io_in_a_bits_address ^ 32'h40000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 11584:8]
  wire [32:0] _T_338 = {1'b0,$signed(_T_337)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 11585:8]
  wire [32:0] _T_340 = $signed(_T_338) & 33'shc0000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 11587:8]
  wire  _T_341 = $signed(_T_340) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 11588:8]
  wire  _T_347 = _T_311 | _T_316; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 11594:8]
  wire  _T_348 = _T_347 | _T_321; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 11595:8]
  wire  _T_349 = _T_348 | _T_326; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 11596:8]
  wire  _T_350 = _T_349 | _T_331; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 11597:8]
  wire  _T_351 = _T_350 | _T_336; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 11598:8]
  wire  _T_352 = _T_351 | _T_341; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 11599:8]
  wire  _T_353 = _T_352 | _T_135; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 11600:8]
  wire  _T_354 = _T_128 & _T_353; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 11601:8]
  wire  _T_356 = _T_302 | _T_354; // @[Parameters.scala 661:30 freechips.rocketchip.system.LitexConfig.fir 11603:8]
  wire  _T_358 = _T_356 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11605:8]
  wire  _T_359 = ~_T_358; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11606:8]
  wire  _T_366 = io_in_a_bits_param == 3'h0; // @[Monitor.scala 111:31 freechips.rocketchip.system.LitexConfig.fir 11625:8]
  wire  _T_368 = _T_366 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11627:8]
  wire  _T_369 = ~_T_368; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11628:8]
  wire  _T_370 = io_in_a_bits_mask == _T_79; // @[Monitor.scala 112:30 freechips.rocketchip.system.LitexConfig.fir 11633:8]
  wire  _T_372 = _T_370 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11635:8]
  wire  _T_373 = ~_T_372; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11636:8]
  wire  _T_378 = io_in_a_bits_opcode == 3'h0; // @[Monitor.scala 116:25 freechips.rocketchip.system.LitexConfig.fir 11650:6]
  wire  _T_423 = _T_311 | _T_321; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 11696:8]
  wire  _T_424 = _T_423 | _T_326; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 11697:8]
  wire  _T_425 = _T_424 | _T_135; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 11698:8]
  wire  _T_426 = _T_128 & _T_425; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 11699:8]
  wire  _T_435 = io_in_a_bits_size <= 4'h8; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 11708:8]
  wire  _T_453 = _T_331 | _T_336; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 11726:8]
  wire  _T_454 = _T_453 | _T_341; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 11727:8]
  wire  _T_455 = _T_435 & _T_454; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 11728:8]
  wire  _T_457 = _T_302 | _T_426; // @[Parameters.scala 661:30 freechips.rocketchip.system.LitexConfig.fir 11730:8]
  wire  _T_459 = _T_457 | _T_455; // @[Parameters.scala 661:30 freechips.rocketchip.system.LitexConfig.fir 11732:8]
  wire  _T_460 = _T_118 & _T_459; // @[Parameters.scala 1406:195 freechips.rocketchip.system.LitexConfig.fir 11733:8]
  wire  _T_462 = _T_460 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11735:8]
  wire  _T_463 = ~_T_462; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11736:8]
  wire  _T_478 = io_in_a_bits_opcode == 3'h1; // @[Monitor.scala 124:25 freechips.rocketchip.system.LitexConfig.fir 11772:6]
  wire [7:0] _T_574 = ~_T_79; // @[Monitor.scala 129:33 freechips.rocketchip.system.LitexConfig.fir 11885:8]
  wire [7:0] _T_575 = io_in_a_bits_mask & _T_574; // @[Monitor.scala 129:31 freechips.rocketchip.system.LitexConfig.fir 11886:8]
  wire  _T_576 = _T_575 == 8'h0; // @[Monitor.scala 129:40 freechips.rocketchip.system.LitexConfig.fir 11887:8]
  wire  _T_578 = _T_576 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11889:8]
  wire  _T_579 = ~_T_578; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11890:8]
  wire  _T_580 = io_in_a_bits_opcode == 3'h2; // @[Monitor.scala 132:25 freechips.rocketchip.system.LitexConfig.fir 11896:6]
  wire  _T_592 = io_in_a_bits_size <= 4'h3; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 11909:8]
  wire [32:0] _T_598 = $signed(_T_83) & 33'shf8010000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 11915:8]
  wire  _T_599 = $signed(_T_598) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 11916:8]
  wire  _T_605 = _T_599 | _T_326; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 11922:8]
  wire  _T_606 = _T_592 & _T_605; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 11923:8]
  wire  _T_640 = _T_118 & _T_606; // @[Parameters.scala 1403:195 freechips.rocketchip.system.LitexConfig.fir 11957:8]
  wire  _T_642 = _T_640 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11959:8]
  wire  _T_643 = ~_T_642; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11960:8]
  wire  _T_650 = io_in_a_bits_param <= 3'h4; // @[Bundles.scala 140:33 freechips.rocketchip.system.LitexConfig.fir 11979:8]
  wire  _T_652 = _T_650 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11981:8]
  wire  _T_653 = ~_T_652; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11982:8]
  wire  _T_658 = io_in_a_bits_opcode == 3'h3; // @[Monitor.scala 140:25 freechips.rocketchip.system.LitexConfig.fir 11996:6]
  wire  _T_728 = io_in_a_bits_param <= 3'h3; // @[Bundles.scala 147:30 freechips.rocketchip.system.LitexConfig.fir 12079:8]
  wire  _T_730 = _T_728 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12081:8]
  wire  _T_731 = ~_T_730; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12082:8]
  wire  _T_736 = io_in_a_bits_opcode == 3'h5; // @[Monitor.scala 148:25 freechips.rocketchip.system.LitexConfig.fir 12096:6]
  wire  _T_808 = _T_118 & _T_302; // @[Parameters.scala 1408:195 freechips.rocketchip.system.LitexConfig.fir 12169:8]
  wire  _T_810 = _T_808 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12171:8]
  wire  _T_811 = ~_T_810; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12172:8]
  wire  _T_818 = io_in_a_bits_param <= 3'h1; // @[Bundles.scala 160:28 freechips.rocketchip.system.LitexConfig.fir 12191:8]
  wire  _T_820 = _T_818 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12193:8]
  wire  _T_821 = ~_T_820; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12194:8]
  wire  _T_830 = io_in_d_bits_opcode <= 3'h6; // @[Bundles.scala 44:24 freechips.rocketchip.system.LitexConfig.fir 12218:6]
  wire  _T_832 = _T_830 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12220:6]
  wire  _T_833 = ~_T_832; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12221:6]
  wire  _T_834 = io_in_d_bits_source == 2'h0; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 12226:6]
  wire  _T_835 = io_in_d_bits_source == 2'h1; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 12227:6]
  wire  _T_836 = io_in_d_bits_source == 2'h2; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 12228:6]
  wire  _T_838 = _T_834 | _T_835; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 12234:6]
  wire  _T_839 = _T_838 | _T_836; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 12235:6]
  wire  _T_841 = io_in_d_bits_opcode == 3'h6; // @[Monitor.scala 312:25 freechips.rocketchip.system.LitexConfig.fir 12237:6]
  wire  _T_843 = _T_839 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12240:8]
  wire  _T_844 = ~_T_843; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12241:8]
  wire  _T_845 = io_in_d_bits_size >= 4'h3; // @[Monitor.scala 314:27 freechips.rocketchip.system.LitexConfig.fir 12246:8]
  wire  _T_847 = _T_845 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12248:8]
  wire  _T_848 = ~_T_847; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12249:8]
  wire  _T_849 = io_in_d_bits_param == 2'h0; // @[Monitor.scala 315:28 freechips.rocketchip.system.LitexConfig.fir 12254:8]
  wire  _T_851 = _T_849 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12256:8]
  wire  _T_852 = ~_T_851; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12257:8]
  wire  _T_853 = ~io_in_d_bits_corrupt; // @[Monitor.scala 316:15 freechips.rocketchip.system.LitexConfig.fir 12262:8]
  wire  _T_855 = _T_853 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12264:8]
  wire  _T_856 = ~_T_855; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12265:8]
  wire  _T_857 = ~io_in_d_bits_denied; // @[Monitor.scala 317:15 freechips.rocketchip.system.LitexConfig.fir 12270:8]
  wire  _T_859 = _T_857 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12272:8]
  wire  _T_860 = ~_T_859; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12273:8]
  wire  _T_861 = io_in_d_bits_opcode == 3'h4; // @[Monitor.scala 320:25 freechips.rocketchip.system.LitexConfig.fir 12279:6]
  wire  _T_872 = io_in_d_bits_param <= 2'h2; // @[Bundles.scala 104:26 freechips.rocketchip.system.LitexConfig.fir 12303:8]
  wire  _T_874 = _T_872 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12305:8]
  wire  _T_875 = ~_T_874; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12306:8]
  wire  _T_876 = io_in_d_bits_param != 2'h2; // @[Monitor.scala 325:28 freechips.rocketchip.system.LitexConfig.fir 12311:8]
  wire  _T_878 = _T_876 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12313:8]
  wire  _T_879 = ~_T_878; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12314:8]
  wire  _T_889 = io_in_d_bits_opcode == 3'h5; // @[Monitor.scala 330:25 freechips.rocketchip.system.LitexConfig.fir 12337:6]
  wire  _T_909 = _T_857 | io_in_d_bits_corrupt; // @[Monitor.scala 336:30 freechips.rocketchip.system.LitexConfig.fir 12378:8]
  wire  _T_911 = _T_909 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12380:8]
  wire  _T_912 = ~_T_911; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12381:8]
  wire  _T_918 = io_in_d_bits_opcode == 3'h0; // @[Monitor.scala 340:25 freechips.rocketchip.system.LitexConfig.fir 12396:6]
  wire  _T_935 = io_in_d_bits_opcode == 3'h1; // @[Monitor.scala 348:25 freechips.rocketchip.system.LitexConfig.fir 12431:6]
  wire  _T_953 = io_in_d_bits_opcode == 3'h2; // @[Monitor.scala 356:25 freechips.rocketchip.system.LitexConfig.fir 12467:6]
  wire [32:0] _T_977 = {1'b0,$signed(io_in_b_bits_address)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 12515:6]
  wire [31:0] _T_1003 = io_in_b_bits_address ^ 32'h3000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 12545:6]
  wire [32:0] _T_1004 = {1'b0,$signed(_T_1003)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 12546:6]
  wire [32:0] _T_1006 = $signed(_T_1004) & -33'sh1000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 12548:6]
  wire  _T_1007 = $signed(_T_1006) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 12549:6]
  wire [31:0] _T_1008 = io_in_b_bits_address ^ 32'hc000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 12550:6]
  wire [32:0] _T_1009 = {1'b0,$signed(_T_1008)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 12551:6]
  wire [32:0] _T_1011 = $signed(_T_1009) & -33'sh4000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 12553:6]
  wire  _T_1012 = $signed(_T_1011) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 12554:6]
  wire [31:0] _T_1013 = io_in_b_bits_address ^ 32'h2000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 12555:6]
  wire [32:0] _T_1014 = {1'b0,$signed(_T_1013)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 12556:6]
  wire [32:0] _T_1016 = $signed(_T_1014) & -33'sh10000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 12558:6]
  wire  _T_1017 = $signed(_T_1016) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 12559:6]
  wire [32:0] _T_1021 = $signed(_T_977) & -33'sh1000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 12563:6]
  wire  _T_1022 = $signed(_T_1021) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 12564:6]
  wire [31:0] _T_1023 = io_in_b_bits_address ^ 32'h10000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 12565:6]
  wire [32:0] _T_1024 = {1'b0,$signed(_T_1023)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 12566:6]
  wire [32:0] _T_1026 = $signed(_T_1024) & -33'sh10000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 12568:6]
  wire  _T_1027 = $signed(_T_1026) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 12569:6]
  wire [31:0] _T_1028 = io_in_b_bits_address ^ 32'h80000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 12570:6]
  wire [32:0] _T_1029 = {1'b0,$signed(_T_1028)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 12571:6]
  wire [32:0] _T_1031 = $signed(_T_1029) & -33'sh80000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 12573:6]
  wire  _T_1032 = $signed(_T_1031) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 12574:6]
  wire [31:0] _T_1033 = io_in_b_bits_address ^ 32'h10000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 12575:6]
  wire [32:0] _T_1034 = {1'b0,$signed(_T_1033)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 12576:6]
  wire [32:0] _T_1036 = $signed(_T_1034) & -33'sh10000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 12578:6]
  wire  _T_1037 = $signed(_T_1036) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 12579:6]
  wire [31:0] _T_1038 = io_in_b_bits_address ^ 32'h20000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 12580:6]
  wire [32:0] _T_1039 = {1'b0,$signed(_T_1038)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 12581:6]
  wire [32:0] _T_1041 = $signed(_T_1039) & -33'sh20000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 12583:6]
  wire  _T_1042 = $signed(_T_1041) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 12584:6]
  wire [31:0] _T_1043 = io_in_b_bits_address ^ 32'h40000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 12585:6]
  wire [32:0] _T_1044 = {1'b0,$signed(_T_1043)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 12586:6]
  wire [32:0] _T_1046 = $signed(_T_1044) & -33'sh40000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 12588:6]
  wire  _T_1047 = $signed(_T_1046) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 12589:6]
  wire  _T_1048 = _T_1037 | _T_1042; // @[Parameters.scala 590:92 freechips.rocketchip.system.LitexConfig.fir 12590:6]
  wire  _T_1049 = _T_1048 | _T_1047; // @[Parameters.scala 590:92 freechips.rocketchip.system.LitexConfig.fir 12591:6]
  wire  _T_1051 = _T_1007 | _T_1012; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 12601:6]
  wire  _T_1052 = _T_1051 | _T_1017; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 12602:6]
  wire  _T_1053 = _T_1052 | _T_1022; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 12603:6]
  wire  _T_1054 = _T_1053 | _T_1027; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 12604:6]
  wire  _T_1055 = _T_1054 | _T_1032; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 12605:6]
  wire  _T_1056 = _T_1055 | _T_1049; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 12606:6]
  wire [31:0] _T_1061 = io_in_b_bits_address & 32'h3f; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 12611:6]
  wire  _T_1062 = _T_1061 == 32'h0; // @[Edges.scala 22:24 freechips.rocketchip.system.LitexConfig.fir 12612:6]
  wire  _T_1166 = _T_1056 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12731:8]
  wire  _T_1167 = ~_T_1166; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12732:8]
  wire  _T_1172 = _T_1062 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12745:8]
  wire  _T_1173 = ~_T_1172; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12746:8]
  wire  _T_1174 = io_in_b_bits_param <= 2'h2; // @[Bundles.scala 104:26 freechips.rocketchip.system.LitexConfig.fir 12751:8]
  wire  _T_1176 = _T_1174 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12753:8]
  wire  _T_1177 = ~_T_1176; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12754:8]
  wire  _T_1394 = io_in_c_bits_source == 2'h0; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 13150:6]
  wire  _T_1395 = io_in_c_bits_source == 2'h1; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 13151:6]
  wire  _T_1396 = io_in_c_bits_source == 2'h2; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 13152:6]
  wire  _T_1398 = _T_1394 | _T_1395; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 13158:6]
  wire  _T_1399 = _T_1398 | _T_1396; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 13159:6]
  wire [26:0] _T_1401 = 27'hfff << io_in_c_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 13161:6]
  wire [11:0] _T_1403 = ~_T_1401[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 13163:6]
  wire [31:0] _GEN_87 = {{20'd0}, _T_1403}; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 13164:6]
  wire [31:0] _T_1404 = io_in_c_bits_address & _GEN_87; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 13164:6]
  wire  _T_1405 = _T_1404 == 32'h0; // @[Edges.scala 22:24 freechips.rocketchip.system.LitexConfig.fir 13165:6]
  wire [31:0] _T_1406 = io_in_c_bits_address ^ 32'h3000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 13166:6]
  wire [32:0] _T_1407 = {1'b0,$signed(_T_1406)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 13167:6]
  wire [32:0] _T_1409 = $signed(_T_1407) & -33'sh1000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 13169:6]
  wire  _T_1410 = $signed(_T_1409) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 13170:6]
  wire [31:0] _T_1411 = io_in_c_bits_address ^ 32'hc000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 13171:6]
  wire [32:0] _T_1412 = {1'b0,$signed(_T_1411)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 13172:6]
  wire [32:0] _T_1414 = $signed(_T_1412) & -33'sh4000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 13174:6]
  wire  _T_1415 = $signed(_T_1414) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 13175:6]
  wire [31:0] _T_1416 = io_in_c_bits_address ^ 32'h2000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 13176:6]
  wire [32:0] _T_1417 = {1'b0,$signed(_T_1416)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 13177:6]
  wire [32:0] _T_1419 = $signed(_T_1417) & -33'sh10000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 13179:6]
  wire  _T_1420 = $signed(_T_1419) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 13180:6]
  wire [32:0] _T_1422 = {1'b0,$signed(io_in_c_bits_address)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 13182:6]
  wire [32:0] _T_1424 = $signed(_T_1422) & -33'sh1000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 13184:6]
  wire  _T_1425 = $signed(_T_1424) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 13185:6]
  wire [31:0] _T_1426 = io_in_c_bits_address ^ 32'h10000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 13186:6]
  wire [32:0] _T_1427 = {1'b0,$signed(_T_1426)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 13187:6]
  wire [32:0] _T_1429 = $signed(_T_1427) & -33'sh10000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 13189:6]
  wire  _T_1430 = $signed(_T_1429) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 13190:6]
  wire [31:0] _T_1431 = io_in_c_bits_address ^ 32'h80000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 13191:6]
  wire [32:0] _T_1432 = {1'b0,$signed(_T_1431)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 13192:6]
  wire [32:0] _T_1434 = $signed(_T_1432) & -33'sh80000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 13194:6]
  wire  _T_1435 = $signed(_T_1434) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 13195:6]
  wire [31:0] _T_1436 = io_in_c_bits_address ^ 32'h10000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 13196:6]
  wire [32:0] _T_1437 = {1'b0,$signed(_T_1436)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 13197:6]
  wire [32:0] _T_1439 = $signed(_T_1437) & -33'sh10000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 13199:6]
  wire  _T_1440 = $signed(_T_1439) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 13200:6]
  wire [31:0] _T_1441 = io_in_c_bits_address ^ 32'h20000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 13201:6]
  wire [32:0] _T_1442 = {1'b0,$signed(_T_1441)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 13202:6]
  wire [32:0] _T_1444 = $signed(_T_1442) & -33'sh20000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 13204:6]
  wire  _T_1445 = $signed(_T_1444) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 13205:6]
  wire [31:0] _T_1446 = io_in_c_bits_address ^ 32'h40000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 13206:6]
  wire [32:0] _T_1447 = {1'b0,$signed(_T_1446)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 13207:6]
  wire [32:0] _T_1449 = $signed(_T_1447) & -33'sh40000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 13209:6]
  wire  _T_1450 = $signed(_T_1449) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 13210:6]
  wire  _T_1451 = _T_1440 | _T_1445; // @[Parameters.scala 590:92 freechips.rocketchip.system.LitexConfig.fir 13211:6]
  wire  _T_1452 = _T_1451 | _T_1450; // @[Parameters.scala 590:92 freechips.rocketchip.system.LitexConfig.fir 13212:6]
  wire  _T_1454 = _T_1410 | _T_1415; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 13222:6]
  wire  _T_1455 = _T_1454 | _T_1420; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 13223:6]
  wire  _T_1456 = _T_1455 | _T_1425; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 13224:6]
  wire  _T_1457 = _T_1456 | _T_1430; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 13225:6]
  wire  _T_1458 = _T_1457 | _T_1435; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 13226:6]
  wire  _T_1459 = _T_1458 | _T_1452; // @[Parameters.scala 614:64 freechips.rocketchip.system.LitexConfig.fir 13227:6]
  wire  _T_1489 = io_in_c_bits_opcode == 3'h4; // @[Monitor.scala 244:25 freechips.rocketchip.system.LitexConfig.fir 13261:6]
  wire  _T_1491 = _T_1459 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13264:8]
  wire  _T_1492 = ~_T_1491; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13265:8]
  wire  _T_1494 = _T_1399 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13271:8]
  wire  _T_1495 = ~_T_1494; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13272:8]
  wire  _T_1496 = io_in_c_bits_size >= 4'h3; // @[Monitor.scala 247:30 freechips.rocketchip.system.LitexConfig.fir 13277:8]
  wire  _T_1498 = _T_1496 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13279:8]
  wire  _T_1499 = ~_T_1498; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13280:8]
  wire  _T_1501 = _T_1405 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13286:8]
  wire  _T_1502 = ~_T_1501; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13287:8]
  wire  _T_1503 = io_in_c_bits_param <= 3'h5; // @[Bundles.scala 122:29 freechips.rocketchip.system.LitexConfig.fir 13292:8]
  wire  _T_1505 = _T_1503 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13294:8]
  wire  _T_1506 = ~_T_1505; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13295:8]
  wire  _T_1507 = ~io_in_c_bits_corrupt; // @[Monitor.scala 250:18 freechips.rocketchip.system.LitexConfig.fir 13300:8]
  wire  _T_1509 = _T_1507 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13302:8]
  wire  _T_1510 = ~_T_1509; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13303:8]
  wire  _T_1511 = io_in_c_bits_opcode == 3'h5; // @[Monitor.scala 253:25 freechips.rocketchip.system.LitexConfig.fir 13309:6]
  wire  _T_1529 = io_in_c_bits_opcode == 3'h6; // @[Monitor.scala 261:25 freechips.rocketchip.system.LitexConfig.fir 13349:6]
  wire  _T_1531 = io_in_c_bits_size <= 4'hc; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 13352:8]
  wire  _T_1538 = _T_1531 & _T_1399; // @[Parameters.scala 1195:30 freechips.rocketchip.system.LitexConfig.fir 13359:8]
  wire  _T_1548 = io_in_c_bits_size <= 4'h6; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 13369:8]
  wire [32:0] _T_1554 = $signed(_T_1432) & 33'sh80000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 13375:8]
  wire  _T_1555 = $signed(_T_1554) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 13376:8]
  wire  _T_1556 = _T_1548 & _T_1555; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 13377:8]
  wire  _T_1559 = _T_1538 & _T_1556; // @[Parameters.scala 1402:195 freechips.rocketchip.system.LitexConfig.fir 13380:8]
  wire  _T_1561 = _T_1559 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13382:8]
  wire  _T_1562 = ~_T_1561; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13383:8]
  wire  _T_1567 = 4'h6 == io_in_c_bits_size; // @[Parameters.scala 92:48 freechips.rocketchip.system.LitexConfig.fir 13396:8]
  wire  _T_1568 = _T_1394 & _T_1567; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 13397:8]
  wire  _T_1585 = _T_1568 & _T_1531; // @[Parameters.scala 1417:195 freechips.rocketchip.system.LitexConfig.fir 13415:8]
  wire  _T_1587 = _T_1585 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13417:8]
  wire  _T_1588 = ~_T_1587; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13418:8]
  wire  _T_1599 = io_in_c_bits_param <= 3'h2; // @[Bundles.scala 116:29 freechips.rocketchip.system.LitexConfig.fir 13445:8]
  wire  _T_1601 = _T_1599 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13447:8]
  wire  _T_1602 = ~_T_1601; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13448:8]
  wire  _T_1607 = io_in_c_bits_opcode == 3'h7; // @[Monitor.scala 271:25 freechips.rocketchip.system.LitexConfig.fir 13462:6]
  wire  _T_1681 = io_in_c_bits_opcode == 3'h0; // @[Monitor.scala 280:25 freechips.rocketchip.system.LitexConfig.fir 13567:6]
  wire  _T_1691 = io_in_c_bits_param == 3'h0; // @[Monitor.scala 284:31 freechips.rocketchip.system.LitexConfig.fir 13590:8]
  wire  _T_1693 = _T_1691 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13592:8]
  wire  _T_1694 = ~_T_1693; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13593:8]
  wire  _T_1699 = io_in_c_bits_opcode == 3'h1; // @[Monitor.scala 288:25 freechips.rocketchip.system.LitexConfig.fir 13607:6]
  wire  _T_1713 = io_in_c_bits_opcode == 3'h2; // @[Monitor.scala 295:25 freechips.rocketchip.system.LitexConfig.fir 13639:6]
  wire  _T_1735 = io_in_a_ready & io_in_a_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 13690:4]
  wire  _T_1742 = ~io_in_a_bits_opcode[2]; // @[Edges.scala 93:28 freechips.rocketchip.system.LitexConfig.fir 13697:4]
  reg [8:0] _T_1744; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 13699:4]
  wire [8:0] _T_1746 = _T_1744 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 13701:4]
  wire  _T_1747 = _T_1744 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 13702:4]
  reg [2:0] _T_1755; // @[Monitor.scala 386:22 freechips.rocketchip.system.LitexConfig.fir 13713:4]
  reg [2:0] _T_1756; // @[Monitor.scala 387:22 freechips.rocketchip.system.LitexConfig.fir 13714:4]
  reg [3:0] _T_1757; // @[Monitor.scala 388:22 freechips.rocketchip.system.LitexConfig.fir 13715:4]
  reg [1:0] _T_1758; // @[Monitor.scala 389:22 freechips.rocketchip.system.LitexConfig.fir 13716:4]
  reg [31:0] _T_1759; // @[Monitor.scala 390:22 freechips.rocketchip.system.LitexConfig.fir 13717:4]
  wire  _T_1760 = ~_T_1747; // @[Monitor.scala 391:22 freechips.rocketchip.system.LitexConfig.fir 13718:4]
  wire  _T_1761 = io_in_a_valid & _T_1760; // @[Monitor.scala 391:19 freechips.rocketchip.system.LitexConfig.fir 13719:4]
  wire  _T_1762 = io_in_a_bits_opcode == _T_1755; // @[Monitor.scala 392:32 freechips.rocketchip.system.LitexConfig.fir 13721:6]
  wire  _T_1764 = _T_1762 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13723:6]
  wire  _T_1765 = ~_T_1764; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13724:6]
  wire  _T_1766 = io_in_a_bits_param == _T_1756; // @[Monitor.scala 393:32 freechips.rocketchip.system.LitexConfig.fir 13729:6]
  wire  _T_1768 = _T_1766 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13731:6]
  wire  _T_1769 = ~_T_1768; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13732:6]
  wire  _T_1770 = io_in_a_bits_size == _T_1757; // @[Monitor.scala 394:32 freechips.rocketchip.system.LitexConfig.fir 13737:6]
  wire  _T_1772 = _T_1770 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13739:6]
  wire  _T_1773 = ~_T_1772; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13740:6]
  wire  _T_1774 = io_in_a_bits_source == _T_1758; // @[Monitor.scala 395:32 freechips.rocketchip.system.LitexConfig.fir 13745:6]
  wire  _T_1776 = _T_1774 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13747:6]
  wire  _T_1777 = ~_T_1776; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13748:6]
  wire  _T_1778 = io_in_a_bits_address == _T_1759; // @[Monitor.scala 396:32 freechips.rocketchip.system.LitexConfig.fir 13753:6]
  wire  _T_1780 = _T_1778 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13755:6]
  wire  _T_1781 = ~_T_1780; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13756:6]
  wire  _T_1783 = _T_1735 & _T_1747; // @[Monitor.scala 398:20 freechips.rocketchip.system.LitexConfig.fir 13763:4]
  wire  _T_1784 = io_in_d_ready & io_in_d_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 13771:4]
  wire [26:0] _T_1786 = 27'hfff << io_in_d_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 13773:4]
  wire [11:0] _T_1788 = ~_T_1786[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 13775:4]
  reg [8:0] _T_1792; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 13779:4]
  wire [8:0] _T_1794 = _T_1792 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 13781:4]
  wire  _T_1795 = _T_1792 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 13782:4]
  reg [2:0] _T_1803; // @[Monitor.scala 537:22 freechips.rocketchip.system.LitexConfig.fir 13793:4]
  reg [1:0] _T_1804; // @[Monitor.scala 538:22 freechips.rocketchip.system.LitexConfig.fir 13794:4]
  reg [3:0] _T_1805; // @[Monitor.scala 539:22 freechips.rocketchip.system.LitexConfig.fir 13795:4]
  reg [1:0] _T_1806; // @[Monitor.scala 540:22 freechips.rocketchip.system.LitexConfig.fir 13796:4]
  reg [1:0] _T_1807; // @[Monitor.scala 541:22 freechips.rocketchip.system.LitexConfig.fir 13797:4]
  reg  _T_1808; // @[Monitor.scala 542:22 freechips.rocketchip.system.LitexConfig.fir 13798:4]
  wire  _T_1809 = ~_T_1795; // @[Monitor.scala 543:22 freechips.rocketchip.system.LitexConfig.fir 13799:4]
  wire  _T_1810 = io_in_d_valid & _T_1809; // @[Monitor.scala 543:19 freechips.rocketchip.system.LitexConfig.fir 13800:4]
  wire  _T_1811 = io_in_d_bits_opcode == _T_1803; // @[Monitor.scala 544:29 freechips.rocketchip.system.LitexConfig.fir 13802:6]
  wire  _T_1813 = _T_1811 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13804:6]
  wire  _T_1814 = ~_T_1813; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13805:6]
  wire  _T_1815 = io_in_d_bits_param == _T_1804; // @[Monitor.scala 545:29 freechips.rocketchip.system.LitexConfig.fir 13810:6]
  wire  _T_1817 = _T_1815 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13812:6]
  wire  _T_1818 = ~_T_1817; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13813:6]
  wire  _T_1819 = io_in_d_bits_size == _T_1805; // @[Monitor.scala 546:29 freechips.rocketchip.system.LitexConfig.fir 13818:6]
  wire  _T_1821 = _T_1819 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13820:6]
  wire  _T_1822 = ~_T_1821; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13821:6]
  wire  _T_1823 = io_in_d_bits_source == _T_1806; // @[Monitor.scala 547:29 freechips.rocketchip.system.LitexConfig.fir 13826:6]
  wire  _T_1825 = _T_1823 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13828:6]
  wire  _T_1826 = ~_T_1825; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13829:6]
  wire  _T_1827 = io_in_d_bits_sink == _T_1807; // @[Monitor.scala 548:29 freechips.rocketchip.system.LitexConfig.fir 13834:6]
  wire  _T_1829 = _T_1827 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13836:6]
  wire  _T_1830 = ~_T_1829; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13837:6]
  wire  _T_1831 = io_in_d_bits_denied == _T_1808; // @[Monitor.scala 549:29 freechips.rocketchip.system.LitexConfig.fir 13842:6]
  wire  _T_1833 = _T_1831 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13844:6]
  wire  _T_1834 = ~_T_1833; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13845:6]
  wire  _T_1836 = _T_1784 & _T_1795; // @[Monitor.scala 551:20 freechips.rocketchip.system.LitexConfig.fir 13852:4]
  wire  _T_1837 = io_in_b_ready & io_in_b_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 13861:4]
  reg [8:0] _T_1846; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 13870:4]
  wire [8:0] _T_1848 = _T_1846 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 13872:4]
  wire  _T_1849 = _T_1846 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 13873:4]
  reg [1:0] _T_1858; // @[Monitor.scala 410:22 freechips.rocketchip.system.LitexConfig.fir 13885:4]
  reg [31:0] _T_1861; // @[Monitor.scala 413:22 freechips.rocketchip.system.LitexConfig.fir 13888:4]
  wire  _T_1862 = ~_T_1849; // @[Monitor.scala 414:22 freechips.rocketchip.system.LitexConfig.fir 13889:4]
  wire  _T_1863 = io_in_b_valid & _T_1862; // @[Monitor.scala 414:19 freechips.rocketchip.system.LitexConfig.fir 13890:4]
  wire  _T_1868 = io_in_b_bits_param == _T_1858; // @[Monitor.scala 416:32 freechips.rocketchip.system.LitexConfig.fir 13900:6]
  wire  _T_1870 = _T_1868 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13902:6]
  wire  _T_1871 = ~_T_1870; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13903:6]
  wire  _T_1880 = io_in_b_bits_address == _T_1861; // @[Monitor.scala 419:32 freechips.rocketchip.system.LitexConfig.fir 13924:6]
  wire  _T_1882 = _T_1880 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13926:6]
  wire  _T_1883 = ~_T_1882; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13927:6]
  wire  _T_1885 = _T_1837 & _T_1849; // @[Monitor.scala 421:20 freechips.rocketchip.system.LitexConfig.fir 13934:4]
  wire  _T_1886 = io_in_c_ready & io_in_c_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 13942:4]
  reg [8:0] _T_1894; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 13950:4]
  wire [8:0] _T_1896 = _T_1894 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 13952:4]
  wire  _T_1897 = _T_1894 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 13953:4]
  reg [2:0] _T_1905; // @[Monitor.scala 514:22 freechips.rocketchip.system.LitexConfig.fir 13964:4]
  reg [2:0] _T_1906; // @[Monitor.scala 515:22 freechips.rocketchip.system.LitexConfig.fir 13965:4]
  reg [3:0] _T_1907; // @[Monitor.scala 516:22 freechips.rocketchip.system.LitexConfig.fir 13966:4]
  reg [1:0] _T_1908; // @[Monitor.scala 517:22 freechips.rocketchip.system.LitexConfig.fir 13967:4]
  reg [31:0] _T_1909; // @[Monitor.scala 518:22 freechips.rocketchip.system.LitexConfig.fir 13968:4]
  wire  _T_1910 = ~_T_1897; // @[Monitor.scala 519:22 freechips.rocketchip.system.LitexConfig.fir 13969:4]
  wire  _T_1911 = io_in_c_valid & _T_1910; // @[Monitor.scala 519:19 freechips.rocketchip.system.LitexConfig.fir 13970:4]
  wire  _T_1912 = io_in_c_bits_opcode == _T_1905; // @[Monitor.scala 520:32 freechips.rocketchip.system.LitexConfig.fir 13972:6]
  wire  _T_1914 = _T_1912 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13974:6]
  wire  _T_1915 = ~_T_1914; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13975:6]
  wire  _T_1916 = io_in_c_bits_param == _T_1906; // @[Monitor.scala 521:32 freechips.rocketchip.system.LitexConfig.fir 13980:6]
  wire  _T_1918 = _T_1916 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13982:6]
  wire  _T_1919 = ~_T_1918; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13983:6]
  wire  _T_1920 = io_in_c_bits_size == _T_1907; // @[Monitor.scala 522:32 freechips.rocketchip.system.LitexConfig.fir 13988:6]
  wire  _T_1922 = _T_1920 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13990:6]
  wire  _T_1923 = ~_T_1922; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13991:6]
  wire  _T_1924 = io_in_c_bits_source == _T_1908; // @[Monitor.scala 523:32 freechips.rocketchip.system.LitexConfig.fir 13996:6]
  wire  _T_1926 = _T_1924 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13998:6]
  wire  _T_1927 = ~_T_1926; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13999:6]
  wire  _T_1928 = io_in_c_bits_address == _T_1909; // @[Monitor.scala 524:32 freechips.rocketchip.system.LitexConfig.fir 14004:6]
  wire  _T_1930 = _T_1928 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14006:6]
  wire  _T_1931 = ~_T_1930; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14007:6]
  wire  _T_1933 = _T_1886 & _T_1897; // @[Monitor.scala 526:20 freechips.rocketchip.system.LitexConfig.fir 14014:4]
  reg [2:0] inflight; // @[Monitor.scala 613:27 freechips.rocketchip.system.LitexConfig.fir 14022:4]
  reg [11:0] inflight_opcodes; // @[Monitor.scala 615:35 freechips.rocketchip.system.LitexConfig.fir 14023:4]
  reg [23:0] inflight_sizes; // @[Monitor.scala 617:33 freechips.rocketchip.system.LitexConfig.fir 14024:4]
  reg [8:0] _T_1943; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 14034:4]
  wire [8:0] _T_1945 = _T_1943 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 14036:4]
  wire  a_first = _T_1943 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 14037:4]
  reg [8:0] _T_1961; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 14056:4]
  wire [8:0] _T_1963 = _T_1961 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 14058:4]
  wire  d_first = _T_1961 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 14059:4]
  wire [3:0] _GEN_88 = {io_in_d_bits_source, 2'h0}; // @[Monitor.scala 636:69 freechips.rocketchip.system.LitexConfig.fir 14080:4]
  wire [4:0] _T_1971 = {{1'd0}, _GEN_88}; // @[Monitor.scala 636:69 freechips.rocketchip.system.LitexConfig.fir 14080:4]
  wire [11:0] _T_1972 = inflight_opcodes >> _T_1971; // @[Monitor.scala 636:44 freechips.rocketchip.system.LitexConfig.fir 14081:4]
  wire [15:0] _T_1976 = 16'h10 - 16'h1; // @[Monitor.scala 611:57 freechips.rocketchip.system.LitexConfig.fir 14085:4]
  wire [15:0] _GEN_89 = {{4'd0}, _T_1972}; // @[Monitor.scala 636:97 freechips.rocketchip.system.LitexConfig.fir 14086:4]
  wire [15:0] _T_1977 = _GEN_89 & _T_1976; // @[Monitor.scala 636:97 freechips.rocketchip.system.LitexConfig.fir 14086:4]
  wire [15:0] _T_1978 = {{1'd0}, _T_1977[15:1]}; // @[Monitor.scala 636:152 freechips.rocketchip.system.LitexConfig.fir 14087:4]
  wire [4:0] _T_1979 = {io_in_d_bits_source, 3'h0}; // @[Monitor.scala 640:65 freechips.rocketchip.system.LitexConfig.fir 14091:4]
  wire [23:0] _T_1980 = inflight_sizes >> _T_1979; // @[Monitor.scala 640:40 freechips.rocketchip.system.LitexConfig.fir 14092:4]
  wire [15:0] _T_1984 = 16'h100 - 16'h1; // @[Monitor.scala 611:57 freechips.rocketchip.system.LitexConfig.fir 14096:4]
  wire [23:0] _GEN_91 = {{8'd0}, _T_1984}; // @[Monitor.scala 640:91 freechips.rocketchip.system.LitexConfig.fir 14097:4]
  wire [23:0] _T_1985 = _T_1980 & _GEN_91; // @[Monitor.scala 640:91 freechips.rocketchip.system.LitexConfig.fir 14097:4]
  wire [23:0] _T_1986 = {{1'd0}, _T_1985[23:1]}; // @[Monitor.scala 640:144 freechips.rocketchip.system.LitexConfig.fir 14098:4]
  wire  _T_1989 = io_in_a_valid & a_first; // @[Monitor.scala 650:26 freechips.rocketchip.system.LitexConfig.fir 14122:4]
  wire [3:0] _T_1991 = 4'h1 << io_in_a_bits_source; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 14125:6]
  wire [3:0] _GEN_27 = _T_1989 ? _T_1991 : 4'h0; // @[Monitor.scala 650:71 freechips.rocketchip.system.LitexConfig.fir 14124:4]
  wire  _T_1993 = _T_1735 & a_first; // @[Monitor.scala 654:27 freechips.rocketchip.system.LitexConfig.fir 14129:4]
  wire [3:0] _T_1996 = {io_in_a_bits_opcode, 1'h0}; // @[Monitor.scala 656:53 freechips.rocketchip.system.LitexConfig.fir 14134:6]
  wire [3:0] _T_1997 = _T_1996 | 4'h1; // @[Monitor.scala 656:61 freechips.rocketchip.system.LitexConfig.fir 14135:6]
  wire [4:0] _T_1998 = {io_in_a_bits_size, 1'h0}; // @[Monitor.scala 657:51 freechips.rocketchip.system.LitexConfig.fir 14137:6]
  wire [4:0] _T_1999 = _T_1998 | 5'h1; // @[Monitor.scala 657:59 freechips.rocketchip.system.LitexConfig.fir 14138:6]
  wire [3:0] _GEN_93 = {io_in_a_bits_source, 2'h0}; // @[Monitor.scala 658:79 freechips.rocketchip.system.LitexConfig.fir 14140:6]
  wire [4:0] _T_2000 = {{1'd0}, _GEN_93}; // @[Monitor.scala 658:79 freechips.rocketchip.system.LitexConfig.fir 14140:6]
  wire [3:0] a_opcodes_set_interm = _T_1993 ? _T_1997 : 4'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 14131:4]
  wire [34:0] _GEN_94 = {{31'd0}, a_opcodes_set_interm}; // @[Monitor.scala 658:54 freechips.rocketchip.system.LitexConfig.fir 14141:6]
  wire [34:0] _T_2001 = _GEN_94 << _T_2000; // @[Monitor.scala 658:54 freechips.rocketchip.system.LitexConfig.fir 14141:6]
  wire [4:0] _T_2002 = {io_in_a_bits_source, 3'h0}; // @[Monitor.scala 659:77 freechips.rocketchip.system.LitexConfig.fir 14143:6]
  wire [4:0] a_sizes_set_interm = _T_1993 ? _T_1999 : 5'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 14131:4]
  wire [35:0] _GEN_95 = {{31'd0}, a_sizes_set_interm}; // @[Monitor.scala 659:52 freechips.rocketchip.system.LitexConfig.fir 14144:6]
  wire [35:0] _T_2003 = _GEN_95 << _T_2002; // @[Monitor.scala 659:52 freechips.rocketchip.system.LitexConfig.fir 14144:6]
  wire [2:0] _T_2004 = inflight >> io_in_a_bits_source; // @[Monitor.scala 660:26 freechips.rocketchip.system.LitexConfig.fir 14146:6]
  wire  _T_2006 = ~_T_2004[0]; // @[Monitor.scala 660:17 freechips.rocketchip.system.LitexConfig.fir 14148:6]
  wire  _T_2008 = _T_2006 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14150:6]
  wire  _T_2009 = ~_T_2008; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14151:6]
  wire [3:0] _GEN_28 = _T_1993 ? _T_1991 : 4'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 14131:4]
  wire [34:0] _GEN_31 = _T_1993 ? _T_2001 : 35'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 14131:4]
  wire [35:0] _GEN_32 = _T_1993 ? _T_2003 : 36'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 14131:4]
  wire  _T_2011 = io_in_d_valid & d_first; // @[Monitor.scala 673:26 freechips.rocketchip.system.LitexConfig.fir 14166:4]
  wire  _T_2013 = ~_T_841; // @[Monitor.scala 673:74 freechips.rocketchip.system.LitexConfig.fir 14168:4]
  wire  _T_2014 = _T_2011 & _T_2013; // @[Monitor.scala 673:71 freechips.rocketchip.system.LitexConfig.fir 14169:4]
  wire [3:0] _T_2015 = 4'h1 << io_in_d_bits_source; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 14171:6]
  wire [3:0] _GEN_33 = _T_2014 ? _T_2015 : 4'h0; // @[Monitor.scala 673:90 freechips.rocketchip.system.LitexConfig.fir 14170:4]
  wire  _T_2017 = _T_1784 & d_first; // @[Monitor.scala 677:27 freechips.rocketchip.system.LitexConfig.fir 14175:4]
  wire  _T_2020 = _T_2017 & _T_2013; // @[Monitor.scala 677:72 freechips.rocketchip.system.LitexConfig.fir 14178:4]
  wire [46:0] _GEN_97 = {{31'd0}, _T_1976}; // @[Monitor.scala 679:76 freechips.rocketchip.system.LitexConfig.fir 14187:6]
  wire [46:0] _T_2027 = _GEN_97 << _T_1971; // @[Monitor.scala 679:76 freechips.rocketchip.system.LitexConfig.fir 14187:6]
  wire [46:0] _GEN_98 = {{31'd0}, _T_1984}; // @[Monitor.scala 680:74 freechips.rocketchip.system.LitexConfig.fir 14194:6]
  wire [46:0] _T_2033 = _GEN_98 << _T_1979; // @[Monitor.scala 680:74 freechips.rocketchip.system.LitexConfig.fir 14194:6]
  wire [3:0] _GEN_34 = _T_2020 ? _T_2015 : 4'h0; // @[Monitor.scala 677:91 freechips.rocketchip.system.LitexConfig.fir 14179:4]
  wire [46:0] _GEN_35 = _T_2020 ? _T_2027 : 47'h0; // @[Monitor.scala 677:91 freechips.rocketchip.system.LitexConfig.fir 14179:4]
  wire [46:0] _GEN_36 = _T_2020 ? _T_2033 : 47'h0; // @[Monitor.scala 677:91 freechips.rocketchip.system.LitexConfig.fir 14179:4]
  wire  _T_2040 = io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 683:113 freechips.rocketchip.system.LitexConfig.fir 14204:6]
  wire  _T_2041 = _T_1989 & _T_2040; // @[Monitor.scala 683:88 freechips.rocketchip.system.LitexConfig.fir 14205:6]
  wire [2:0] _T_2042 = inflight >> io_in_d_bits_source; // @[Monitor.scala 684:25 freechips.rocketchip.system.LitexConfig.fir 14206:6]
  wire  _T_2044 = _T_2042[0] | _T_2041; // @[Monitor.scala 684:49 freechips.rocketchip.system.LitexConfig.fir 14208:6]
  wire  _T_2046 = _T_2044 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14210:6]
  wire  _T_2047 = ~_T_2046; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14211:6]
  wire [2:0] _GEN_39 = 3'h2 == io_in_a_bits_opcode ? 3'h1 : 3'h0; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 14217:8]
  wire [2:0] _GEN_40 = 3'h3 == io_in_a_bits_opcode ? 3'h1 : _GEN_39; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 14217:8]
  wire [2:0] _GEN_41 = 3'h4 == io_in_a_bits_opcode ? 3'h1 : _GEN_40; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 14217:8]
  wire [2:0] _GEN_42 = 3'h5 == io_in_a_bits_opcode ? 3'h2 : _GEN_41; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 14217:8]
  wire [2:0] _GEN_43 = 3'h6 == io_in_a_bits_opcode ? 3'h4 : _GEN_42; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 14217:8]
  wire [2:0] _GEN_44 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_43; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 14217:8]
  wire  _T_2048 = io_in_d_bits_opcode == _GEN_44; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 14217:8]
  wire [2:0] _GEN_51 = 3'h6 == io_in_a_bits_opcode ? 3'h5 : _GEN_42; // @[Monitor.scala 688:39 freechips.rocketchip.system.LitexConfig.fir 14218:8]
  wire [2:0] _GEN_52 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_51; // @[Monitor.scala 688:39 freechips.rocketchip.system.LitexConfig.fir 14218:8]
  wire  _T_2049 = io_in_d_bits_opcode == _GEN_52; // @[Monitor.scala 688:39 freechips.rocketchip.system.LitexConfig.fir 14218:8]
  wire  _T_2050 = _T_2048 | _T_2049; // @[Monitor.scala 687:77 freechips.rocketchip.system.LitexConfig.fir 14219:8]
  wire  _T_2052 = _T_2050 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14221:8]
  wire  _T_2053 = ~_T_2052; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14222:8]
  wire  _T_2054 = io_in_a_bits_size == io_in_d_bits_size; // @[Monitor.scala 689:36 freechips.rocketchip.system.LitexConfig.fir 14227:8]
  wire  _T_2056 = _T_2054 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14229:8]
  wire  _T_2057 = ~_T_2056; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14230:8]
  wire [3:0] a_opcode_lookup = _T_1978[3:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14078:4 freechips.rocketchip.system.LitexConfig.fir 14079:4 Monitor.scala 636:21 freechips.rocketchip.system.LitexConfig.fir 14088:4]
  wire [2:0] _GEN_55 = 3'h2 == a_opcode_lookup[2:0] ? 3'h1 : 3'h0; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 14238:8]
  wire [2:0] _GEN_56 = 3'h3 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_55; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 14238:8]
  wire [2:0] _GEN_57 = 3'h4 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_56; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 14238:8]
  wire [2:0] _GEN_58 = 3'h5 == a_opcode_lookup[2:0] ? 3'h2 : _GEN_57; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 14238:8]
  wire [2:0] _GEN_59 = 3'h6 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_58; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 14238:8]
  wire [2:0] _GEN_60 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_59; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 14238:8]
  wire  _T_2059 = io_in_d_bits_opcode == _GEN_60; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 14238:8]
  wire [2:0] _GEN_67 = 3'h6 == a_opcode_lookup[2:0] ? 3'h5 : _GEN_58; // @[Monitor.scala 692:38 freechips.rocketchip.system.LitexConfig.fir 14240:8]
  wire [2:0] _GEN_68 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_67; // @[Monitor.scala 692:38 freechips.rocketchip.system.LitexConfig.fir 14240:8]
  wire  _T_2061 = io_in_d_bits_opcode == _GEN_68; // @[Monitor.scala 692:38 freechips.rocketchip.system.LitexConfig.fir 14240:8]
  wire  _T_2062 = _T_2059 | _T_2061; // @[Monitor.scala 691:72 freechips.rocketchip.system.LitexConfig.fir 14241:8]
  wire  _T_2064 = _T_2062 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14243:8]
  wire  _T_2065 = ~_T_2064; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14244:8]
  wire [7:0] a_size_lookup = _T_1986[7:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14089:4 freechips.rocketchip.system.LitexConfig.fir 14090:4 Monitor.scala 640:19 freechips.rocketchip.system.LitexConfig.fir 14099:4]
  wire [7:0] _GEN_99 = {{4'd0}, io_in_d_bits_size}; // @[Monitor.scala 693:36 freechips.rocketchip.system.LitexConfig.fir 14249:8]
  wire  _T_2066 = _GEN_99 == a_size_lookup; // @[Monitor.scala 693:36 freechips.rocketchip.system.LitexConfig.fir 14249:8]
  wire  _T_2068 = _T_2066 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14251:8]
  wire  _T_2069 = ~_T_2068; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14252:8]
  wire  _T_2071 = _T_2011 & a_first; // @[Monitor.scala 696:36 freechips.rocketchip.system.LitexConfig.fir 14260:4]
  wire  _T_2072 = _T_2071 & io_in_a_valid; // @[Monitor.scala 696:47 freechips.rocketchip.system.LitexConfig.fir 14261:4]
  wire  _T_2074 = _T_2072 & _T_2040; // @[Monitor.scala 696:65 freechips.rocketchip.system.LitexConfig.fir 14263:4]
  wire  _T_2076 = _T_2074 & _T_2013; // @[Monitor.scala 696:116 freechips.rocketchip.system.LitexConfig.fir 14265:4]
  wire  _T_2077 = ~io_in_d_ready; // @[Monitor.scala 697:15 freechips.rocketchip.system.LitexConfig.fir 14267:6]
  wire  _T_2078 = _T_2077 | io_in_a_ready; // @[Monitor.scala 697:32 freechips.rocketchip.system.LitexConfig.fir 14268:6]
  wire  _T_2080 = _T_2078 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14270:6]
  wire  _T_2081 = ~_T_2080; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14271:6]
  wire [2:0] a_set_wo_ready = _GEN_27[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14072:4 freechips.rocketchip.system.LitexConfig.fir 14073:4 Monitor.scala 651:22 freechips.rocketchip.system.LitexConfig.fir 14126:6]
  wire [2:0] d_clr_wo_ready = _GEN_33[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14159:4 freechips.rocketchip.system.LitexConfig.fir 14160:4 Monitor.scala 674:22 freechips.rocketchip.system.LitexConfig.fir 14172:6]
  wire  _T_2082 = a_set_wo_ready != d_clr_wo_ready; // @[Monitor.scala 701:29 freechips.rocketchip.system.LitexConfig.fir 14277:4]
  wire  _T_2083 = |a_set_wo_ready; // @[Monitor.scala 701:67 freechips.rocketchip.system.LitexConfig.fir 14278:4]
  wire  _T_2084 = ~_T_2083; // @[Monitor.scala 701:51 freechips.rocketchip.system.LitexConfig.fir 14279:4]
  wire  _T_2085 = _T_2082 | _T_2084; // @[Monitor.scala 701:48 freechips.rocketchip.system.LitexConfig.fir 14280:4]
  wire  _T_2087 = _T_2085 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14282:4]
  wire  _T_2088 = ~_T_2087; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14283:4]
  wire [2:0] a_set = _GEN_28[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14070:4 freechips.rocketchip.system.LitexConfig.fir 14071:4 Monitor.scala 655:28 freechips.rocketchip.system.LitexConfig.fir 14133:6]
  wire [2:0] _T_2089 = inflight | a_set; // @[Monitor.scala 704:27 freechips.rocketchip.system.LitexConfig.fir 14288:4]
  wire [2:0] d_clr = _GEN_34[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14157:4 freechips.rocketchip.system.LitexConfig.fir 14158:4 Monitor.scala 678:21 freechips.rocketchip.system.LitexConfig.fir 14181:6]
  wire [2:0] _T_2090 = ~d_clr; // @[Monitor.scala 704:38 freechips.rocketchip.system.LitexConfig.fir 14289:4]
  wire [2:0] _T_2091 = _T_2089 & _T_2090; // @[Monitor.scala 704:36 freechips.rocketchip.system.LitexConfig.fir 14290:4]
  wire [11:0] a_opcodes_set = _GEN_31[11:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14074:4 freechips.rocketchip.system.LitexConfig.fir 14075:4 Monitor.scala 658:28 freechips.rocketchip.system.LitexConfig.fir 14142:6]
  wire [11:0] _T_2092 = inflight_opcodes | a_opcodes_set; // @[Monitor.scala 705:43 freechips.rocketchip.system.LitexConfig.fir 14292:4]
  wire [11:0] d_opcodes_clr = _GEN_35[11:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14161:4 freechips.rocketchip.system.LitexConfig.fir 14162:4 Monitor.scala 679:21 freechips.rocketchip.system.LitexConfig.fir 14188:6]
  wire [11:0] _T_2093 = ~d_opcodes_clr; // @[Monitor.scala 705:62 freechips.rocketchip.system.LitexConfig.fir 14293:4]
  wire [11:0] _T_2094 = _T_2092 & _T_2093; // @[Monitor.scala 705:60 freechips.rocketchip.system.LitexConfig.fir 14294:4]
  wire [23:0] a_sizes_set = _GEN_32[23:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14076:4 freechips.rocketchip.system.LitexConfig.fir 14077:4 Monitor.scala 659:28 freechips.rocketchip.system.LitexConfig.fir 14145:6]
  wire [23:0] _T_2095 = inflight_sizes | a_sizes_set; // @[Monitor.scala 706:39 freechips.rocketchip.system.LitexConfig.fir 14296:4]
  wire [23:0] d_sizes_clr = _GEN_36[23:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14163:4 freechips.rocketchip.system.LitexConfig.fir 14164:4 Monitor.scala 680:21 freechips.rocketchip.system.LitexConfig.fir 14195:6]
  wire [23:0] _T_2096 = ~d_sizes_clr; // @[Monitor.scala 706:56 freechips.rocketchip.system.LitexConfig.fir 14297:4]
  wire [23:0] _T_2097 = _T_2095 & _T_2096; // @[Monitor.scala 706:54 freechips.rocketchip.system.LitexConfig.fir 14298:4]
  reg [31:0] _T_2098; // @[Monitor.scala 708:27 freechips.rocketchip.system.LitexConfig.fir 14300:4]
  wire  _T_2099 = |inflight; // @[Monitor.scala 711:26 freechips.rocketchip.system.LitexConfig.fir 14303:4]
  wire  _T_2100 = ~_T_2099; // @[Monitor.scala 711:16 freechips.rocketchip.system.LitexConfig.fir 14304:4]
  wire  _T_2101 = plusarg_reader_out == 32'h0; // @[Monitor.scala 711:39 freechips.rocketchip.system.LitexConfig.fir 14305:4]
  wire  _T_2102 = _T_2100 | _T_2101; // @[Monitor.scala 711:30 freechips.rocketchip.system.LitexConfig.fir 14306:4]
  wire  _T_2103 = _T_2098 < plusarg_reader_out; // @[Monitor.scala 711:59 freechips.rocketchip.system.LitexConfig.fir 14307:4]
  wire  _T_2104 = _T_2102 | _T_2103; // @[Monitor.scala 711:47 freechips.rocketchip.system.LitexConfig.fir 14308:4]
  wire  _T_2106 = _T_2104 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14310:4]
  wire  _T_2107 = ~_T_2106; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14311:4]
  wire [31:0] _T_2109 = _T_2098 + 32'h1; // @[Monitor.scala 713:26 freechips.rocketchip.system.LitexConfig.fir 14317:4]
  wire  _T_2112 = _T_1735 | _T_1784; // @[Monitor.scala 714:27 freechips.rocketchip.system.LitexConfig.fir 14321:4]
  reg [2:0] inflight_1; // @[Monitor.scala 725:35 freechips.rocketchip.system.LitexConfig.fir 14325:4]
  reg [23:0] inflight_sizes_1; // @[Monitor.scala 727:35 freechips.rocketchip.system.LitexConfig.fir 14327:4]
  reg [8:0] _T_2121; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 14336:4]
  wire [8:0] _T_2123 = _T_2121 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 14338:4]
  wire  c_first = _T_2121 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 14339:4]
  reg [8:0] _T_2139; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 14358:4]
  wire [8:0] _T_2141 = _T_2139 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 14360:4]
  wire  d_first_1 = _T_2139 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 14361:4]
  wire [23:0] _T_2158 = inflight_sizes_1 >> _T_1979; // @[Monitor.scala 749:42 freechips.rocketchip.system.LitexConfig.fir 14394:4]
  wire [23:0] _T_2163 = _T_2158 & _GEN_91; // @[Monitor.scala 749:93 freechips.rocketchip.system.LitexConfig.fir 14399:4]
  wire [23:0] _T_2164 = {{1'd0}, _T_2163[23:1]}; // @[Monitor.scala 749:146 freechips.rocketchip.system.LitexConfig.fir 14400:4]
  wire  _T_2165 = io_in_c_valid & c_first; // @[Monitor.scala 758:26 freechips.rocketchip.system.LitexConfig.fir 14406:4]
  wire  _T_2168 = io_in_c_bits_opcode[2] & io_in_c_bits_opcode[1]; // @[Edges.scala 69:40 freechips.rocketchip.system.LitexConfig.fir 14409:4]
  wire  _T_2169 = _T_2165 & _T_2168; // @[Monitor.scala 758:37 freechips.rocketchip.system.LitexConfig.fir 14410:4]
  wire [3:0] _T_2170 = 4'h1 << io_in_c_bits_source; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 14412:6]
  wire [3:0] _GEN_72 = _T_2169 ? _T_2170 : 4'h0; // @[Monitor.scala 758:71 freechips.rocketchip.system.LitexConfig.fir 14411:4]
  wire  _T_2172 = _T_1886 & c_first; // @[Monitor.scala 762:27 freechips.rocketchip.system.LitexConfig.fir 14416:4]
  wire  _T_2176 = _T_2172 & _T_2168; // @[Monitor.scala 762:38 freechips.rocketchip.system.LitexConfig.fir 14420:4]
  wire [4:0] _T_2180 = {io_in_c_bits_size, 1'h0}; // @[Monitor.scala 765:51 freechips.rocketchip.system.LitexConfig.fir 14427:6]
  wire [4:0] _T_2181 = _T_2180 | 5'h1; // @[Monitor.scala 765:59 freechips.rocketchip.system.LitexConfig.fir 14428:6]
  wire [4:0] _T_2184 = {io_in_c_bits_source, 3'h0}; // @[Monitor.scala 767:77 freechips.rocketchip.system.LitexConfig.fir 14433:6]
  wire [4:0] c_sizes_set_interm = _T_2176 ? _T_2181 : 5'h0; // @[Monitor.scala 762:72 freechips.rocketchip.system.LitexConfig.fir 14421:4]
  wire [35:0] _GEN_107 = {{31'd0}, c_sizes_set_interm}; // @[Monitor.scala 767:52 freechips.rocketchip.system.LitexConfig.fir 14434:6]
  wire [35:0] _T_2185 = _GEN_107 << _T_2184; // @[Monitor.scala 767:52 freechips.rocketchip.system.LitexConfig.fir 14434:6]
  wire [2:0] _T_2186 = inflight_1 >> io_in_c_bits_source; // @[Monitor.scala 768:26 freechips.rocketchip.system.LitexConfig.fir 14436:6]
  wire  _T_2188 = ~_T_2186[0]; // @[Monitor.scala 768:17 freechips.rocketchip.system.LitexConfig.fir 14438:6]
  wire  _T_2190 = _T_2188 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14440:6]
  wire  _T_2191 = ~_T_2190; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14441:6]
  wire [3:0] _GEN_73 = _T_2176 ? _T_2170 : 4'h0; // @[Monitor.scala 762:72 freechips.rocketchip.system.LitexConfig.fir 14421:4]
  wire [35:0] _GEN_77 = _T_2176 ? _T_2185 : 36'h0; // @[Monitor.scala 762:72 freechips.rocketchip.system.LitexConfig.fir 14421:4]
  wire  _T_2193 = io_in_d_valid & d_first_1; // @[Monitor.scala 781:26 freechips.rocketchip.system.LitexConfig.fir 14456:4]
  wire  _T_2195 = _T_2193 & _T_841; // @[Monitor.scala 781:71 freechips.rocketchip.system.LitexConfig.fir 14458:4]
  wire [3:0] _GEN_78 = _T_2195 ? _T_2015 : 4'h0; // @[Monitor.scala 781:89 freechips.rocketchip.system.LitexConfig.fir 14459:4]
  wire  _T_2198 = _T_1784 & d_first_1; // @[Monitor.scala 785:27 freechips.rocketchip.system.LitexConfig.fir 14464:4]
  wire  _T_2200 = _T_2198 & _T_841; // @[Monitor.scala 785:72 freechips.rocketchip.system.LitexConfig.fir 14466:4]
  wire [3:0] _GEN_79 = _T_2200 ? _T_2015 : 4'h0; // @[Monitor.scala 785:90 freechips.rocketchip.system.LitexConfig.fir 14467:4]
  wire [46:0] _GEN_81 = _T_2200 ? _T_2033 : 47'h0; // @[Monitor.scala 785:90 freechips.rocketchip.system.LitexConfig.fir 14467:4]
  wire  _T_2222 = io_in_c_bits_source == io_in_d_bits_source; // @[Monitor.scala 792:113 freechips.rocketchip.system.LitexConfig.fir 14494:6]
  wire  _T_2223 = _T_2169 & _T_2222; // @[Monitor.scala 792:88 freechips.rocketchip.system.LitexConfig.fir 14495:6]
  wire [2:0] _T_2224 = inflight_1 >> io_in_d_bits_source; // @[Monitor.scala 793:25 freechips.rocketchip.system.LitexConfig.fir 14496:6]
  wire  _T_2226 = _T_2224[0] | _T_2223; // @[Monitor.scala 793:49 freechips.rocketchip.system.LitexConfig.fir 14498:6]
  wire  _T_2228 = _T_2226 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14500:6]
  wire  _T_2229 = ~_T_2228; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14501:6]
  wire  _T_2230 = io_in_d_bits_size == io_in_c_bits_size; // @[Monitor.scala 795:36 freechips.rocketchip.system.LitexConfig.fir 14507:8]
  wire  _T_2232 = _T_2230 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14509:8]
  wire  _T_2233 = ~_T_2232; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14510:8]
  wire [7:0] c_size_lookup = _T_2164[7:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14382:4 freechips.rocketchip.system.LitexConfig.fir 14383:4 Monitor.scala 749:21 freechips.rocketchip.system.LitexConfig.fir 14401:4]
  wire  _T_2234 = _GEN_99 == c_size_lookup; // @[Monitor.scala 797:36 freechips.rocketchip.system.LitexConfig.fir 14517:8]
  wire  _T_2236 = _T_2234 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14519:8]
  wire  _T_2237 = ~_T_2236; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14520:8]
  wire  _T_2239 = _T_2193 & c_first; // @[Monitor.scala 801:36 freechips.rocketchip.system.LitexConfig.fir 14528:4]
  wire  _T_2240 = _T_2239 & io_in_c_valid; // @[Monitor.scala 801:47 freechips.rocketchip.system.LitexConfig.fir 14529:4]
  wire  _T_2242 = _T_2240 & _T_2222; // @[Monitor.scala 801:65 freechips.rocketchip.system.LitexConfig.fir 14531:4]
  wire  _T_2243 = _T_2242 & _T_841; // @[Monitor.scala 801:116 freechips.rocketchip.system.LitexConfig.fir 14532:4]
  wire  _T_2245 = _T_2077 | io_in_c_ready; // @[Monitor.scala 802:32 freechips.rocketchip.system.LitexConfig.fir 14535:6]
  wire  _T_2247 = _T_2245 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14537:6]
  wire  _T_2248 = ~_T_2247; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14538:6]
  wire [2:0] c_set_wo_ready = _GEN_72[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14374:4 freechips.rocketchip.system.LitexConfig.fir 14375:4 Monitor.scala 759:22 freechips.rocketchip.system.LitexConfig.fir 14413:6]
  wire  _T_2249 = |c_set_wo_ready; // @[Monitor.scala 806:28 freechips.rocketchip.system.LitexConfig.fir 14544:4]
  wire [2:0] d_clr_wo_ready_1 = _GEN_78[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14449:4 freechips.rocketchip.system.LitexConfig.fir 14450:4 Monitor.scala 782:22 freechips.rocketchip.system.LitexConfig.fir 14461:6]
  wire  _T_2250 = c_set_wo_ready != d_clr_wo_ready_1; // @[Monitor.scala 807:31 freechips.rocketchip.system.LitexConfig.fir 14546:6]
  wire  _T_2252 = _T_2250 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14548:6]
  wire  _T_2253 = ~_T_2252; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14549:6]
  wire [2:0] c_set = _GEN_73[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14372:4 freechips.rocketchip.system.LitexConfig.fir 14373:4 Monitor.scala 763:28 freechips.rocketchip.system.LitexConfig.fir 14423:6]
  wire [2:0] _T_2254 = inflight_1 | c_set; // @[Monitor.scala 811:35 freechips.rocketchip.system.LitexConfig.fir 14555:4]
  wire [2:0] d_clr_1 = _GEN_79[2:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14447:4 freechips.rocketchip.system.LitexConfig.fir 14448:4 Monitor.scala 786:21 freechips.rocketchip.system.LitexConfig.fir 14469:6]
  wire [2:0] _T_2255 = ~d_clr_1; // @[Monitor.scala 811:46 freechips.rocketchip.system.LitexConfig.fir 14556:4]
  wire [2:0] _T_2256 = _T_2254 & _T_2255; // @[Monitor.scala 811:44 freechips.rocketchip.system.LitexConfig.fir 14557:4]
  wire [23:0] c_sizes_set = _GEN_77[23:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14378:4 freechips.rocketchip.system.LitexConfig.fir 14379:4 Monitor.scala 767:28 freechips.rocketchip.system.LitexConfig.fir 14435:6]
  wire [23:0] _T_2260 = inflight_sizes_1 | c_sizes_set; // @[Monitor.scala 813:41 freechips.rocketchip.system.LitexConfig.fir 14563:4]
  wire [23:0] d_sizes_clr_1 = _GEN_81[23:0]; // @[freechips.rocketchip.system.LitexConfig.fir 14453:4 freechips.rocketchip.system.LitexConfig.fir 14454:4 Monitor.scala 788:21 freechips.rocketchip.system.LitexConfig.fir 14483:6]
  wire [23:0] _T_2261 = ~d_sizes_clr_1; // @[Monitor.scala 813:58 freechips.rocketchip.system.LitexConfig.fir 14564:4]
  wire [23:0] _T_2262 = _T_2260 & _T_2261; // @[Monitor.scala 813:56 freechips.rocketchip.system.LitexConfig.fir 14565:4]
  reg [31:0] _T_2263; // @[Monitor.scala 815:27 freechips.rocketchip.system.LitexConfig.fir 14567:4]
  wire  _T_2264 = |inflight_1; // @[Monitor.scala 818:26 freechips.rocketchip.system.LitexConfig.fir 14570:4]
  wire  _T_2265 = ~_T_2264; // @[Monitor.scala 818:16 freechips.rocketchip.system.LitexConfig.fir 14571:4]
  wire  _T_2266 = plusarg_reader_1_out == 32'h0; // @[Monitor.scala 818:39 freechips.rocketchip.system.LitexConfig.fir 14572:4]
  wire  _T_2267 = _T_2265 | _T_2266; // @[Monitor.scala 818:30 freechips.rocketchip.system.LitexConfig.fir 14573:4]
  wire  _T_2268 = _T_2263 < plusarg_reader_1_out; // @[Monitor.scala 818:59 freechips.rocketchip.system.LitexConfig.fir 14574:4]
  wire  _T_2269 = _T_2267 | _T_2268; // @[Monitor.scala 818:47 freechips.rocketchip.system.LitexConfig.fir 14575:4]
  wire  _T_2271 = _T_2269 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14577:4]
  wire  _T_2272 = ~_T_2271; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14578:4]
  wire [31:0] _T_2274 = _T_2263 + 32'h1; // @[Monitor.scala 820:26 freechips.rocketchip.system.LitexConfig.fir 14584:4]
  wire  _T_2277 = _T_1886 | _T_1784; // @[Monitor.scala 821:27 freechips.rocketchip.system.LitexConfig.fir 14588:4]
  reg [3:0] _T_2278; // @[Monitor.scala 825:27 freechips.rocketchip.system.LitexConfig.fir 14592:4]
  reg [8:0] _T_2287; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 14601:4]
  wire [8:0] _T_2289 = _T_2287 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 14603:4]
  wire  _T_2290 = _T_2287 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 14604:4]
  wire  _T_2300 = _T_1784 & _T_2290; // @[Monitor.scala 831:27 freechips.rocketchip.system.LitexConfig.fir 14618:4]
  wire  _T_2303 = ~io_in_d_bits_opcode[1]; // @[Edges.scala 72:43 freechips.rocketchip.system.LitexConfig.fir 14621:4]
  wire  _T_2304 = io_in_d_bits_opcode[2] & _T_2303; // @[Edges.scala 72:40 freechips.rocketchip.system.LitexConfig.fir 14622:4]
  wire  _T_2305 = _T_2300 & _T_2304; // @[Monitor.scala 831:38 freechips.rocketchip.system.LitexConfig.fir 14623:4]
  wire [3:0] _T_2306 = 4'h1 << io_in_d_bits_sink; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 14625:6]
  wire [3:0] _T_2307 = _T_2278 >> io_in_d_bits_sink; // @[Monitor.scala 833:23 freechips.rocketchip.system.LitexConfig.fir 14627:6]
  wire  _T_2309 = ~_T_2307[0]; // @[Monitor.scala 833:14 freechips.rocketchip.system.LitexConfig.fir 14629:6]
  wire  _T_2311 = _T_2309 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14631:6]
  wire  _T_2312 = ~_T_2311; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14632:6]
  wire [3:0] _GEN_84 = _T_2305 ? _T_2306 : 4'h0; // @[Monitor.scala 831:72 freechips.rocketchip.system.LitexConfig.fir 14624:4]
  wire [3:0] _T_2317 = 4'h1 << io_in_e_bits_sink; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 14644:6]
  wire [3:0] _T_2318 = _GEN_84 | _T_2278; // @[Monitor.scala 839:24 freechips.rocketchip.system.LitexConfig.fir 14646:6]
  wire [3:0] _T_2319 = _T_2318 >> io_in_e_bits_sink; // @[Monitor.scala 839:35 freechips.rocketchip.system.LitexConfig.fir 14647:6]
  wire  _T_2322 = _T_2319[0] | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14650:6]
  wire  _T_2323 = ~_T_2322; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14651:6]
  wire [3:0] _GEN_85 = io_in_e_valid ? _T_2317 : 4'h0; // @[Monitor.scala 837:73 freechips.rocketchip.system.LitexConfig.fir 14643:4]
  wire [3:0] _T_2324 = _T_2278 | _GEN_84; // @[Monitor.scala 844:27 freechips.rocketchip.system.LitexConfig.fir 14657:4]
  wire [3:0] _T_2325 = ~_GEN_85; // @[Monitor.scala 844:38 freechips.rocketchip.system.LitexConfig.fir 14658:4]
  wire [3:0] _T_2326 = _T_2324 & _T_2325; // @[Monitor.scala 844:36 freechips.rocketchip.system.LitexConfig.fir 14659:4]
  wire  _GEN_112 = io_in_a_valid & _T_109; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11305:10]
  wire  _GEN_128 = io_in_a_valid & _T_192; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11427:10]
  wire  _GEN_146 = io_in_a_valid & _T_279; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11537:10]
  wire  _GEN_160 = io_in_a_valid & _T_378; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11738:10]
  wire  _GEN_170 = io_in_a_valid & _T_478; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11860:10]
  wire  _GEN_180 = io_in_a_valid & _T_580; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11962:10]
  wire  _GEN_190 = io_in_a_valid & _T_658; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12062:10]
  wire  _GEN_200 = io_in_a_valid & _T_736; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12174:10]
  wire  _GEN_212 = io_in_d_valid & _T_841; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12243:10]
  wire  _GEN_222 = io_in_d_valid & _T_861; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12285:10]
  wire  _GEN_232 = io_in_d_valid & _T_889; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12343:10]
  wire  _GEN_242 = io_in_d_valid & _T_918; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12402:10]
  wire  _GEN_248 = io_in_d_valid & _T_935; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12437:10]
  wire  _GEN_254 = io_in_d_valid & _T_953; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12473:10]
  wire  _GEN_260 = io_in_c_valid & _T_1489; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13267:10]
  wire  _GEN_272 = io_in_c_valid & _T_1511; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13315:10]
  wire  _GEN_282 = io_in_c_valid & _T_1529; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13385:10]
  wire  _GEN_296 = io_in_c_valid & _T_1607; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13498:10]
  wire  _GEN_308 = io_in_c_valid & _T_1681; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13573:10]
  wire  _GEN_318 = io_in_c_valid & _T_1699; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13613:10]
  wire  _GEN_326 = io_in_c_valid & _T_1713; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13645:10]
  wire  _GEN_336 = _T_2014 & _T_2041; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14224:10]
  wire  _GEN_340 = ~_T_2041; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14246:10]
  wire  _GEN_341 = _T_2014 & _GEN_340; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14246:10]
  wire  _GEN_348 = _T_2195 & _T_2223; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14512:10]
  wire  _GEN_350 = ~_T_2223; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14522:10]
  wire  _GEN_351 = _T_2195 & _GEN_350; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14522:10]
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader ( // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 14301:4]
    .out(plusarg_reader_out)
  );
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader_1 ( // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 14568:4]
    .out(plusarg_reader_1_out)
  );
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  _T_1744 = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  _T_1755 = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  _T_1756 = _RAND_2[2:0];
  _RAND_3 = {1{`RANDOM}};
  _T_1757 = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  _T_1758 = _RAND_4[1:0];
  _RAND_5 = {1{`RANDOM}};
  _T_1759 = _RAND_5[31:0];
  _RAND_6 = {1{`RANDOM}};
  _T_1792 = _RAND_6[8:0];
  _RAND_7 = {1{`RANDOM}};
  _T_1803 = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  _T_1804 = _RAND_8[1:0];
  _RAND_9 = {1{`RANDOM}};
  _T_1805 = _RAND_9[3:0];
  _RAND_10 = {1{`RANDOM}};
  _T_1806 = _RAND_10[1:0];
  _RAND_11 = {1{`RANDOM}};
  _T_1807 = _RAND_11[1:0];
  _RAND_12 = {1{`RANDOM}};
  _T_1808 = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  _T_1846 = _RAND_13[8:0];
  _RAND_14 = {1{`RANDOM}};
  _T_1858 = _RAND_14[1:0];
  _RAND_15 = {1{`RANDOM}};
  _T_1861 = _RAND_15[31:0];
  _RAND_16 = {1{`RANDOM}};
  _T_1894 = _RAND_16[8:0];
  _RAND_17 = {1{`RANDOM}};
  _T_1905 = _RAND_17[2:0];
  _RAND_18 = {1{`RANDOM}};
  _T_1906 = _RAND_18[2:0];
  _RAND_19 = {1{`RANDOM}};
  _T_1907 = _RAND_19[3:0];
  _RAND_20 = {1{`RANDOM}};
  _T_1908 = _RAND_20[1:0];
  _RAND_21 = {1{`RANDOM}};
  _T_1909 = _RAND_21[31:0];
  _RAND_22 = {1{`RANDOM}};
  inflight = _RAND_22[2:0];
  _RAND_23 = {1{`RANDOM}};
  inflight_opcodes = _RAND_23[11:0];
  _RAND_24 = {1{`RANDOM}};
  inflight_sizes = _RAND_24[23:0];
  _RAND_25 = {1{`RANDOM}};
  _T_1943 = _RAND_25[8:0];
  _RAND_26 = {1{`RANDOM}};
  _T_1961 = _RAND_26[8:0];
  _RAND_27 = {1{`RANDOM}};
  _T_2098 = _RAND_27[31:0];
  _RAND_28 = {1{`RANDOM}};
  inflight_1 = _RAND_28[2:0];
  _RAND_29 = {1{`RANDOM}};
  inflight_sizes_1 = _RAND_29[23:0];
  _RAND_30 = {1{`RANDOM}};
  _T_2121 = _RAND_30[8:0];
  _RAND_31 = {1{`RANDOM}};
  _T_2139 = _RAND_31[8:0];
  _RAND_32 = {1{`RANDOM}};
  _T_2263 = _RAND_32[31:0];
  _RAND_33 = {1{`RANDOM}};
  _T_2278 = _RAND_33[3:0];
  _RAND_34 = {1{`RANDOM}};
  _T_2287 = _RAND_34[8:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
  always @(posedge clock) begin
    if (reset) begin
      _T_1744 <= 9'h0;
    end else if (_T_1735) begin
      if (_T_1747) begin
        if (_T_1742) begin
          _T_1744 <= _T_13[11:3];
        end else begin
          _T_1744 <= 9'h0;
        end
      end else begin
        _T_1744 <= _T_1746;
      end
    end
    if (_T_1783) begin
      _T_1755 <= io_in_a_bits_opcode;
    end
    if (_T_1783) begin
      _T_1756 <= io_in_a_bits_param;
    end
    if (_T_1783) begin
      _T_1757 <= io_in_a_bits_size;
    end
    if (_T_1783) begin
      _T_1758 <= io_in_a_bits_source;
    end
    if (_T_1783) begin
      _T_1759 <= io_in_a_bits_address;
    end
    if (reset) begin
      _T_1792 <= 9'h0;
    end else if (_T_1784) begin
      if (_T_1795) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_1792 <= _T_1788[11:3];
        end else begin
          _T_1792 <= 9'h0;
        end
      end else begin
        _T_1792 <= _T_1794;
      end
    end
    if (_T_1836) begin
      _T_1803 <= io_in_d_bits_opcode;
    end
    if (_T_1836) begin
      _T_1804 <= io_in_d_bits_param;
    end
    if (_T_1836) begin
      _T_1805 <= io_in_d_bits_size;
    end
    if (_T_1836) begin
      _T_1806 <= io_in_d_bits_source;
    end
    if (_T_1836) begin
      _T_1807 <= io_in_d_bits_sink;
    end
    if (_T_1836) begin
      _T_1808 <= io_in_d_bits_denied;
    end
    if (reset) begin
      _T_1846 <= 9'h0;
    end else if (_T_1837) begin
      if (_T_1849) begin
        _T_1846 <= 9'h0;
      end else begin
        _T_1846 <= _T_1848;
      end
    end
    if (_T_1885) begin
      _T_1858 <= io_in_b_bits_param;
    end
    if (_T_1885) begin
      _T_1861 <= io_in_b_bits_address;
    end
    if (reset) begin
      _T_1894 <= 9'h0;
    end else if (_T_1886) begin
      if (_T_1897) begin
        if (io_in_c_bits_opcode[0]) begin
          _T_1894 <= _T_1403[11:3];
        end else begin
          _T_1894 <= 9'h0;
        end
      end else begin
        _T_1894 <= _T_1896;
      end
    end
    if (_T_1933) begin
      _T_1905 <= io_in_c_bits_opcode;
    end
    if (_T_1933) begin
      _T_1906 <= io_in_c_bits_param;
    end
    if (_T_1933) begin
      _T_1907 <= io_in_c_bits_size;
    end
    if (_T_1933) begin
      _T_1908 <= io_in_c_bits_source;
    end
    if (_T_1933) begin
      _T_1909 <= io_in_c_bits_address;
    end
    if (reset) begin
      inflight <= 3'h0;
    end else begin
      inflight <= _T_2091;
    end
    if (reset) begin
      inflight_opcodes <= 12'h0;
    end else begin
      inflight_opcodes <= _T_2094;
    end
    if (reset) begin
      inflight_sizes <= 24'h0;
    end else begin
      inflight_sizes <= _T_2097;
    end
    if (reset) begin
      _T_1943 <= 9'h0;
    end else if (_T_1735) begin
      if (a_first) begin
        if (_T_1742) begin
          _T_1943 <= _T_13[11:3];
        end else begin
          _T_1943 <= 9'h0;
        end
      end else begin
        _T_1943 <= _T_1945;
      end
    end
    if (reset) begin
      _T_1961 <= 9'h0;
    end else if (_T_1784) begin
      if (d_first) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_1961 <= _T_1788[11:3];
        end else begin
          _T_1961 <= 9'h0;
        end
      end else begin
        _T_1961 <= _T_1963;
      end
    end
    if (reset) begin
      _T_2098 <= 32'h0;
    end else if (_T_2112) begin
      _T_2098 <= 32'h0;
    end else begin
      _T_2098 <= _T_2109;
    end
    if (reset) begin
      inflight_1 <= 3'h0;
    end else begin
      inflight_1 <= _T_2256;
    end
    if (reset) begin
      inflight_sizes_1 <= 24'h0;
    end else begin
      inflight_sizes_1 <= _T_2262;
    end
    if (reset) begin
      _T_2121 <= 9'h0;
    end else if (_T_1886) begin
      if (c_first) begin
        if (io_in_c_bits_opcode[0]) begin
          _T_2121 <= _T_1403[11:3];
        end else begin
          _T_2121 <= 9'h0;
        end
      end else begin
        _T_2121 <= _T_2123;
      end
    end
    if (reset) begin
      _T_2139 <= 9'h0;
    end else if (_T_1784) begin
      if (d_first_1) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_2139 <= _T_1788[11:3];
        end else begin
          _T_2139 <= 9'h0;
        end
      end else begin
        _T_2139 <= _T_2141;
      end
    end
    if (reset) begin
      _T_2263 <= 32'h0;
    end else if (_T_2277) begin
      _T_2263 <= 32'h0;
    end else begin
      _T_2263 <= _T_2274;
    end
    if (reset) begin
      _T_2278 <= 4'h0;
    end else begin
      _T_2278 <= _T_2326;
    end
    if (reset) begin
      _T_2287 <= 9'h0;
    end else if (_T_1784) begin
      if (_T_2290) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_2287 <= _T_1788[11:3];
        end else begin
          _T_2287 <= 9'h0;
        end
      end else begin
        _T_2287 <= _T_2289;
      end
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_142) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquireBlock type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11305:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_142) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11306:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_168) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquireBlock from a client which does not support Probe (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11340:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_168) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11341:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11347:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11348:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_175) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock smaller than a beat (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11355:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_175) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11356:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11362:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11363:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_182) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock carries invalid grow param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11370:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_182) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11371:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_187) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11379:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_187) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11380:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_112 & _T_191) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11387:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_112 & _T_191) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11388:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_142) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquirePerm type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11427:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_142) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11428:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_168) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquirePerm from a client which does not support Probe (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11462:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_168) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11463:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11469:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11470:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_175) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm smaller than a beat (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11477:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_175) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11478:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11484:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11485:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_182) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm carries invalid grow param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11492:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_182) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11493:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_269) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm requests NtoB (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11500:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_269) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11501:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_187) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11509:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_187) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11510:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_128 & _T_191) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11517:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_128 & _T_191) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11518:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_146 & _T_292) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Get type which master claims it can't emit (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11537:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_146 & _T_292) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11538:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_146 & _T_359) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Get type which slave claims it can't support (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11608:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_146 & _T_359) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11609:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_146 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11615:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_146 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11616:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_146 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11622:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_146 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11623:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_146 & _T_369) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11630:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_146 & _T_369) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11631:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_146 & _T_373) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11638:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_146 & _T_373) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11639:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_146 & _T_191) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11646:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_146 & _T_191) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11647:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_160 & _T_463) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries PutFull type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11738:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_160 & _T_463) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11739:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_160 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11745:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_160 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11746:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_160 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11752:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_160 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11753:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_160 & _T_369) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11760:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_160 & _T_369) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11761:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_160 & _T_373) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11768:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_160 & _T_373) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11769:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_170 & _T_463) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries PutPartial type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11860:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_170 & _T_463) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11861:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_170 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11867:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_170 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11868:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_170 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11874:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_170 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11875:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_170 & _T_369) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11882:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_170 & _T_369) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11883:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_170 & _T_579) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11892:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_170 & _T_579) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11893:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_180 & _T_643) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Arithmetic type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11962:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_180 & _T_643) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11963:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_180 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11969:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_180 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11970:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_180 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11976:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_180 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11977:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_180 & _T_653) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic carries invalid opcode param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11984:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_180 & _T_653) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11985:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_180 & _T_373) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11992:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_180 & _T_373) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 11993:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_190 & _T_643) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Logical type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12062:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_190 & _T_643) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12063:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_190 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12069:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_190 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12070:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_190 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12076:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_190 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12077:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_190 & _T_731) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical carries invalid opcode param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12084:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_190 & _T_731) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12085:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_190 & _T_373) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12092:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_190 & _T_373) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12093:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_200 & _T_811) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Hint type which is unexpected using diplomatic parameters (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12174:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_200 & _T_811) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12175:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_200 & _T_171) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12181:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_200 & _T_171) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12182:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_200 & _T_178) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12188:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_200 & _T_178) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12189:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_200 & _T_821) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint carries invalid opcode param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12196:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_200 & _T_821) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12197:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_200 & _T_373) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint contains invalid mask (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12204:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_200 & _T_373) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12205:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_200 & _T_191) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12212:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_200 & _T_191) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 12213:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_d_valid & _T_833) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel has invalid opcode (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12223:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_d_valid & _T_833) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12224:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_212 & _T_844) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12243:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_212 & _T_844) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12244:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_212 & _T_848) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck smaller than a beat (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12251:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_212 & _T_848) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12252:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_212 & _T_852) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseeAck carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12259:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_212 & _T_852) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12260:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_212 & _T_856) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12267:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_212 & _T_856) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12268:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_212 & _T_860) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel ReleaseAck is denied (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12275:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_212 & _T_860) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12276:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_222 & _T_844) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12285:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_222 & _T_844) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12286:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_222 & _T_848) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant smaller than a beat (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12300:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_222 & _T_848) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12301:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_222 & _T_875) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant carries invalid cap param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12308:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_222 & _T_875) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12309:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_222 & _T_879) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant carries toN param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12316:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_222 & _T_879) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12317:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_222 & _T_856) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel Grant is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12324:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_222 & _T_856) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12325:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_232 & _T_844) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12343:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_232 & _T_844) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12344:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_232 & _T_848) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData smaller than a beat (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12358:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_232 & _T_848) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12359:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_232 & _T_875) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData carries invalid cap param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12366:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_232 & _T_875) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12367:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_232 & _T_879) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData carries toN param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12374:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_232 & _T_879) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12375:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_232 & _T_912) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel GrantData is denied but not corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12383:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_232 & _T_912) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12384:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_242 & _T_844) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAck carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12402:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_242 & _T_844) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12403:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_242 & _T_852) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAck carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12410:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_242 & _T_852) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12411:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_242 & _T_856) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAck is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12418:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_242 & _T_856) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12419:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_248 & _T_844) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12437:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_248 & _T_844) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12438:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_248 & _T_852) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAckData carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12445:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_248 & _T_852) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12446:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_248 & _T_912) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel AccessAckData is denied but not corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12454:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_248 & _T_912) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12455:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_254 & _T_844) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel HintAck carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12473:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_254 & _T_844) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12474:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_254 & _T_852) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel HintAck carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12481:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_254 & _T_852) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12482:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_254 & _T_856) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel HintAck is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12489:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_254 & _T_856) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12490:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & _T_1167) begin
          $fwrite(32'h80000002,"Assertion failed: 'B' channel Probe carries unmanaged address (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12734:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & _T_1167) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12735:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & _T_1173) begin
          $fwrite(32'h80000002,"Assertion failed: 'B' channel Probe address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12748:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & _T_1173) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12749:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_b_valid & _T_1177) begin
          $fwrite(32'h80000002,"Assertion failed: 'B' channel Probe carries invalid cap param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12756:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_b_valid & _T_1177) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 12757:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_260 & _T_1492) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAck carries unmanaged address (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13267:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_260 & _T_1492) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13268:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_260 & _T_1495) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAck carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13274:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_260 & _T_1495) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13275:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_260 & _T_1499) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAck smaller than a beat (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13282:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_260 & _T_1499) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13283:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_260 & _T_1502) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAck address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13289:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_260 & _T_1502) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13290:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_260 & _T_1506) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAck carries invalid report param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13297:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_260 & _T_1506) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13298:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_260 & _T_1510) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAck is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13305:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_260 & _T_1510) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13306:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_272 & _T_1492) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAckData carries unmanaged address (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13315:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_272 & _T_1492) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13316:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_272 & _T_1495) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAckData carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13322:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_272 & _T_1495) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13323:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_272 & _T_1499) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAckData smaller than a beat (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13330:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_272 & _T_1499) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13331:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_272 & _T_1502) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAckData address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13337:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_272 & _T_1502) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13338:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_272 & _T_1506) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ProbeAckData carries invalid report param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13345:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_272 & _T_1506) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13346:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_282 & _T_1562) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel carries Release type unsupported by manager (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13385:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_282 & _T_1562) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13386:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_282 & _T_1588) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel carries Release from a client which does not support Probe (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13420:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_282 & _T_1588) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13421:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_282 & _T_1495) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel Release carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13427:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_282 & _T_1495) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13428:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_282 & _T_1499) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel Release smaller than a beat (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13435:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_282 & _T_1499) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13436:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_282 & _T_1502) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel Release address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13442:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_282 & _T_1502) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13443:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_282 & _T_1602) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel Release carries invalid shrink param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13450:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_282 & _T_1602) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13451:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_282 & _T_1510) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel Release is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13458:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_282 & _T_1510) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13459:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_296 & _T_1562) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel carries ReleaseData type unsupported by manager (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13498:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_296 & _T_1562) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13499:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_296 & _T_1588) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel carries Release from a client which does not support Probe (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13533:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_296 & _T_1588) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13534:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_296 & _T_1495) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ReleaseData carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13540:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_296 & _T_1495) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13541:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_296 & _T_1499) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ReleaseData smaller than a beat (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13548:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_296 & _T_1499) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13549:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_296 & _T_1502) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ReleaseData address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13555:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_296 & _T_1502) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13556:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_296 & _T_1602) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel ReleaseData carries invalid shrink param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13563:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_296 & _T_1602) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13564:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_308 & _T_1492) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAck carries unmanaged address (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13573:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_308 & _T_1492) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13574:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_308 & _T_1495) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAck carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13580:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_308 & _T_1495) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13581:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_308 & _T_1502) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAck address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13587:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_308 & _T_1502) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13588:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_308 & _T_1694) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAck carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13595:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_308 & _T_1694) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13596:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_308 & _T_1510) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAck is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13603:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_308 & _T_1510) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13604:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_318 & _T_1492) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAckData carries unmanaged address (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13613:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_318 & _T_1492) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13614:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_318 & _T_1495) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAckData carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13620:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_318 & _T_1495) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13621:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_318 & _T_1502) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAckData address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13627:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_318 & _T_1502) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13628:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_318 & _T_1694) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel AccessAckData carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13635:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_318 & _T_1694) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13636:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_326 & _T_1492) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel HintAck carries unmanaged address (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13645:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_326 & _T_1492) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13646:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_326 & _T_1495) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel HintAck carries invalid source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13652:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_326 & _T_1495) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13653:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_326 & _T_1502) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel HintAck address not aligned to size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13659:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_326 & _T_1502) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13660:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_326 & _T_1694) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel HintAck carries invalid param (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13667:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_326 & _T_1694) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13668:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_326 & _T_1510) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel HintAck is corrupt (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13675:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_326 & _T_1510) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13676:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1761 & _T_1765) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel opcode changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13726:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1761 & _T_1765) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13727:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1761 & _T_1769) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel param changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13734:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1761 & _T_1769) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13735:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1761 & _T_1773) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel size changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13742:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1761 & _T_1773) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13743:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1761 & _T_1777) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel source changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13750:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1761 & _T_1777) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13751:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1761 & _T_1781) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel address changed with multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13758:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1761 & _T_1781) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13759:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1810 & _T_1814) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel opcode changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13807:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1810 & _T_1814) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13808:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1810 & _T_1818) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel param changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13815:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1810 & _T_1818) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13816:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1810 & _T_1822) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel size changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13823:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1810 & _T_1822) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13824:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1810 & _T_1826) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel source changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13831:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1810 & _T_1826) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13832:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1810 & _T_1830) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel sink changed with multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13839:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1810 & _T_1830) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13840:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1810 & _T_1834) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel denied changed with multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13847:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1810 & _T_1834) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 13848:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1863 & _T_1871) begin
          $fwrite(32'h80000002,"Assertion failed: 'B' channel param changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13905:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1863 & _T_1871) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13906:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1863 & _T_1883) begin
          $fwrite(32'h80000002,"Assertion failed: 'B' channel addresss changed with multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13929:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1863 & _T_1883) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13930:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1911 & _T_1915) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel opcode changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13977:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1911 & _T_1915) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13978:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1911 & _T_1919) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel param changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13985:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1911 & _T_1919) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13986:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1911 & _T_1923) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel size changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13993:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1911 & _T_1923) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 13994:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1911 & _T_1927) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel source changed within multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14001:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1911 & _T_1927) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14002:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1911 & _T_1931) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel address changed with multibeat operation (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14009:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1911 & _T_1931) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14010:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_1993 & _T_2009) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel re-used a source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14153:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_1993 & _T_2009) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14154:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2014 & _T_2047) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14213:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2014 & _T_2047) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14214:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_336 & _T_2053) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14224:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_336 & _T_2053) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14225:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_336 & _T_2057) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14232:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_336 & _T_2057) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14233:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_341 & _T_2065) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper opcode response (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14246:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_341 & _T_2065) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14247:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_341 & _T_2069) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14254:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_341 & _T_2069) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14255:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2076 & _T_2081) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14273:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2076 & _T_2081) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14274:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2088) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14285:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2088) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14286:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2107) begin
          $fwrite(32'h80000002,"Assertion failed: TileLink timeout expired (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14313:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2107) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14314:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2176 & _T_2191) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' channel re-used a source ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14443:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2176 & _T_2191) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14444:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2195 & _T_2229) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel acknowledged for nothing inflight (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14503:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2195 & _T_2229) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14504:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_348 & _T_2233) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14512:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_348 & _T_2233) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14513:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_351 & _T_2237) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel contains improper response size (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14522:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_351 & _T_2237) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14523:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2243 & _T_2248) begin
          $fwrite(32'h80000002,"Assertion failed: ready check\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14540:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2243 & _T_2248) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14541:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2249 & _T_2253) begin
          $fwrite(32'h80000002,"Assertion failed: 'C' and 'D' concurrent, despite minlatency 1 (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14551:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2249 & _T_2253) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14552:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2272) begin
          $fwrite(32'h80000002,"Assertion failed: TileLink timeout expired (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14580:6]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2272) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14581:6]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_T_2305 & _T_2312) begin
          $fwrite(32'h80000002,"Assertion failed: 'D' channel re-used a sink ID (connected at SystemBus.scala:42:96)\n    at Monitor.scala:51 assert(cond, message)\n"); // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14634:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_T_2305 & _T_2312) begin
          $fatal; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 14635:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (io_in_e_valid & _T_2323) begin
          $fwrite(32'h80000002,"Assertion failed: 'E' channel acknowledged for nothing inflight (connected at SystemBus.scala:42:96)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14653:8]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (io_in_e_valid & _T_2323) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 14654:8]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
  end
endmodule
module TLFIFOFixer( // @[freechips.rocketchip.system.LitexConfig.fir 14662:2]
  input         clock, // @[freechips.rocketchip.system.LitexConfig.fir 14663:4]
  input         reset, // @[freechips.rocketchip.system.LitexConfig.fir 14664:4]
  output        auto_in_1_a_ready, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_1_a_valid, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [2:0]  auto_in_1_a_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [2:0]  auto_in_1_a_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [3:0]  auto_in_1_a_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [1:0]  auto_in_1_a_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [31:0] auto_in_1_a_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_1_a_bits_user_amba_prot_bufferable, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_1_a_bits_user_amba_prot_modifiable, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_1_a_bits_user_amba_prot_readalloc, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_1_a_bits_user_amba_prot_writealloc, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_1_a_bits_user_amba_prot_privileged, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_1_a_bits_user_amba_prot_secure, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_1_a_bits_user_amba_prot_fetch, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [7:0]  auto_in_1_a_bits_mask, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [63:0] auto_in_1_a_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_1_a_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_1_b_ready, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_in_1_b_valid, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [1:0]  auto_in_1_b_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [31:0] auto_in_1_b_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_in_1_c_ready, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_1_c_valid, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [2:0]  auto_in_1_c_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [2:0]  auto_in_1_c_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [3:0]  auto_in_1_c_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [1:0]  auto_in_1_c_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [31:0] auto_in_1_c_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [63:0] auto_in_1_c_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_1_c_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_1_d_ready, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_in_1_d_valid, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [2:0]  auto_in_1_d_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [1:0]  auto_in_1_d_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [3:0]  auto_in_1_d_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [1:0]  auto_in_1_d_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [1:0]  auto_in_1_d_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_in_1_d_bits_denied, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [63:0] auto_in_1_d_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_in_1_d_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_1_e_valid, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [1:0]  auto_in_1_e_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_in_0_a_ready, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_0_a_valid, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [2:0]  auto_in_0_a_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [2:0]  auto_in_0_a_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [3:0]  auto_in_0_a_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [3:0]  auto_in_0_a_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [31:0] auto_in_0_a_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_0_a_bits_user_amba_prot_bufferable, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_0_a_bits_user_amba_prot_modifiable, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_0_a_bits_user_amba_prot_readalloc, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_0_a_bits_user_amba_prot_writealloc, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_0_a_bits_user_amba_prot_privileged, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_0_a_bits_user_amba_prot_secure, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_0_a_bits_user_amba_prot_fetch, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [7:0]  auto_in_0_a_bits_mask, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [63:0] auto_in_0_a_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_0_a_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_in_0_d_ready, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_in_0_d_valid, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [2:0]  auto_in_0_d_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [1:0]  auto_in_0_d_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [3:0]  auto_in_0_d_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [3:0]  auto_in_0_d_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [1:0]  auto_in_0_d_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_in_0_d_bits_denied, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [63:0] auto_in_0_d_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_in_0_d_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_out_1_a_ready, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_1_a_valid, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [2:0]  auto_out_1_a_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [2:0]  auto_out_1_a_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [3:0]  auto_out_1_a_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [1:0]  auto_out_1_a_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [31:0] auto_out_1_a_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_1_a_bits_user_amba_prot_bufferable, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_1_a_bits_user_amba_prot_modifiable, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_1_a_bits_user_amba_prot_readalloc, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_1_a_bits_user_amba_prot_writealloc, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_1_a_bits_user_amba_prot_privileged, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_1_a_bits_user_amba_prot_secure, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_1_a_bits_user_amba_prot_fetch, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [7:0]  auto_out_1_a_bits_mask, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [63:0] auto_out_1_a_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_1_a_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_1_b_ready, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_out_1_b_valid, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [1:0]  auto_out_1_b_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [31:0] auto_out_1_b_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_out_1_c_ready, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_1_c_valid, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [2:0]  auto_out_1_c_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [2:0]  auto_out_1_c_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [3:0]  auto_out_1_c_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [1:0]  auto_out_1_c_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [31:0] auto_out_1_c_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [63:0] auto_out_1_c_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_1_c_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_1_d_ready, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_out_1_d_valid, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [2:0]  auto_out_1_d_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [1:0]  auto_out_1_d_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [3:0]  auto_out_1_d_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [1:0]  auto_out_1_d_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [1:0]  auto_out_1_d_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_out_1_d_bits_denied, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [63:0] auto_out_1_d_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_out_1_d_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_1_e_valid, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [1:0]  auto_out_1_e_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_out_0_a_ready, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_0_a_valid, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [2:0]  auto_out_0_a_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [2:0]  auto_out_0_a_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [3:0]  auto_out_0_a_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [3:0]  auto_out_0_a_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [31:0] auto_out_0_a_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_0_a_bits_user_amba_prot_bufferable, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_0_a_bits_user_amba_prot_modifiable, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_0_a_bits_user_amba_prot_readalloc, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_0_a_bits_user_amba_prot_writealloc, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_0_a_bits_user_amba_prot_privileged, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_0_a_bits_user_amba_prot_secure, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_0_a_bits_user_amba_prot_fetch, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [7:0]  auto_out_0_a_bits_mask, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output [63:0] auto_out_0_a_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_0_a_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  output        auto_out_0_d_ready, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_out_0_d_valid, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [2:0]  auto_out_0_d_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [1:0]  auto_out_0_d_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [3:0]  auto_out_0_d_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [3:0]  auto_out_0_d_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [1:0]  auto_out_0_d_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_out_0_d_bits_denied, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input  [63:0] auto_out_0_d_bits_data, // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
  input         auto_out_0_d_bits_corrupt // @[freechips.rocketchip.system.LitexConfig.fir 14665:4]
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [31:0] _RAND_14;
  reg [31:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
`endif // RANDOMIZE_REG_INIT
  wire  TLMonitor_clock; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire  TLMonitor_reset; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire  TLMonitor_io_in_a_ready; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire  TLMonitor_io_in_a_valid; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire [2:0] TLMonitor_io_in_a_bits_opcode; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire [2:0] TLMonitor_io_in_a_bits_param; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire [3:0] TLMonitor_io_in_a_bits_size; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire [3:0] TLMonitor_io_in_a_bits_source; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire [31:0] TLMonitor_io_in_a_bits_address; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire [7:0] TLMonitor_io_in_a_bits_mask; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire  TLMonitor_io_in_a_bits_corrupt; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire  TLMonitor_io_in_d_ready; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire  TLMonitor_io_in_d_valid; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire [2:0] TLMonitor_io_in_d_bits_opcode; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire [1:0] TLMonitor_io_in_d_bits_param; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire [3:0] TLMonitor_io_in_d_bits_size; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire [3:0] TLMonitor_io_in_d_bits_source; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire [1:0] TLMonitor_io_in_d_bits_sink; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire  TLMonitor_io_in_d_bits_denied; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire  TLMonitor_io_in_d_bits_corrupt; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
  wire  TLMonitor_1_clock; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire  TLMonitor_1_reset; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire  TLMonitor_1_io_in_a_ready; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire  TLMonitor_1_io_in_a_valid; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [2:0] TLMonitor_1_io_in_a_bits_opcode; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [2:0] TLMonitor_1_io_in_a_bits_param; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [3:0] TLMonitor_1_io_in_a_bits_size; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [1:0] TLMonitor_1_io_in_a_bits_source; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [31:0] TLMonitor_1_io_in_a_bits_address; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [7:0] TLMonitor_1_io_in_a_bits_mask; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire  TLMonitor_1_io_in_a_bits_corrupt; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire  TLMonitor_1_io_in_b_ready; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire  TLMonitor_1_io_in_b_valid; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [1:0] TLMonitor_1_io_in_b_bits_param; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [31:0] TLMonitor_1_io_in_b_bits_address; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire  TLMonitor_1_io_in_c_ready; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire  TLMonitor_1_io_in_c_valid; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [2:0] TLMonitor_1_io_in_c_bits_opcode; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [2:0] TLMonitor_1_io_in_c_bits_param; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [3:0] TLMonitor_1_io_in_c_bits_size; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [1:0] TLMonitor_1_io_in_c_bits_source; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [31:0] TLMonitor_1_io_in_c_bits_address; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire  TLMonitor_1_io_in_c_bits_corrupt; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire  TLMonitor_1_io_in_d_ready; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire  TLMonitor_1_io_in_d_valid; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [2:0] TLMonitor_1_io_in_d_bits_opcode; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [1:0] TLMonitor_1_io_in_d_bits_param; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [3:0] TLMonitor_1_io_in_d_bits_size; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [1:0] TLMonitor_1_io_in_d_bits_source; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [1:0] TLMonitor_1_io_in_d_bits_sink; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire  TLMonitor_1_io_in_d_bits_denied; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire  TLMonitor_1_io_in_d_bits_corrupt; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire  TLMonitor_1_io_in_e_valid; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [1:0] TLMonitor_1_io_in_e_bits_sink; // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
  wire [32:0] _T_5 = {1'b0,$signed(auto_in_0_a_bits_address)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 14765:4]
  wire [31:0] _T_9 = auto_in_0_a_bits_address ^ 32'h80000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 14769:4]
  wire [32:0] _T_10 = {1'b0,$signed(_T_9)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 14770:4]
  wire [32:0] _T_12 = $signed(_T_10) & 33'sh80000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 14772:4]
  wire  _T_13 = $signed(_T_12) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 14773:4]
  wire [32:0] _T_21 = $signed(_T_5) & 33'sh70000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 14782:4]
  wire  _T_22 = $signed(_T_21) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 14783:4]
  wire [31:0] _T_23 = auto_in_0_a_bits_address ^ 32'h10000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 14784:4]
  wire [32:0] _T_24 = {1'b0,$signed(_T_23)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 14785:4]
  wire [32:0] _T_26 = $signed(_T_24) & 33'sh70000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 14787:4]
  wire  _T_27 = $signed(_T_26) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 14788:4]
  wire [31:0] _T_28 = auto_in_0_a_bits_address ^ 32'h20000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 14789:4]
  wire [32:0] _T_29 = {1'b0,$signed(_T_28)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 14790:4]
  wire [32:0] _T_31 = $signed(_T_29) & 33'sh60000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 14792:4]
  wire  _T_32 = $signed(_T_31) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 14793:4]
  wire [31:0] _T_33 = auto_in_0_a_bits_address ^ 32'h40000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 14794:4]
  wire [32:0] _T_34 = {1'b0,$signed(_T_33)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 14795:4]
  wire [32:0] _T_36 = $signed(_T_34) & 33'sh40000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 14797:4]
  wire  _T_37 = $signed(_T_36) == 33'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 14798:4]
  wire  _T_38 = _T_27 | _T_32; // @[Parameters.scala 607:89 freechips.rocketchip.system.LitexConfig.fir 14799:4]
  wire  _T_39 = _T_38 | _T_37; // @[Parameters.scala 607:89 freechips.rocketchip.system.LitexConfig.fir 14800:4]
  wire [1:0] _T_41 = _T_39 ? 2'h2 : 2'h0; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 14802:4]
  wire [1:0] _GEN_86 = {{1'd0}, _T_22}; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 14803:4]
  wire [1:0] _T_42 = _GEN_86 | _T_41; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 14803:4]
  wire  _T_44 = _T_42 == 2'h0; // @[FIFOFixer.scala 57:29 freechips.rocketchip.system.LitexConfig.fir 14806:4]
  wire  _T_96 = ~auto_in_0_a_bits_source[3]; // @[Parameters.scala 55:32 freechips.rocketchip.system.LitexConfig.fir 14887:4]
  reg [8:0] _T_54; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 14816:4]
  wire  _T_57 = _T_54 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 14819:4]
  wire  _T_106 = _T_96 & _T_57; // @[FIFOFixer.scala 82:15 freechips.rocketchip.system.LitexConfig.fir 14900:4]
  reg  _T_87_0; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  reg  _T_87_1; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  wire  _T_107 = _T_87_0 | _T_87_1; // @[FIFOFixer.scala 82:44 freechips.rocketchip.system.LitexConfig.fir 14901:4]
  reg  _T_87_2; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  wire  _T_108 = _T_107 | _T_87_2; // @[FIFOFixer.scala 82:44 freechips.rocketchip.system.LitexConfig.fir 14902:4]
  reg  _T_87_3; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  wire  _T_109 = _T_108 | _T_87_3; // @[FIFOFixer.scala 82:44 freechips.rocketchip.system.LitexConfig.fir 14903:4]
  reg  _T_87_4; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  wire  _T_110 = _T_109 | _T_87_4; // @[FIFOFixer.scala 82:44 freechips.rocketchip.system.LitexConfig.fir 14904:4]
  reg  _T_87_5; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  wire  _T_111 = _T_110 | _T_87_5; // @[FIFOFixer.scala 82:44 freechips.rocketchip.system.LitexConfig.fir 14905:4]
  reg  _T_87_6; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  wire  _T_112 = _T_111 | _T_87_6; // @[FIFOFixer.scala 82:44 freechips.rocketchip.system.LitexConfig.fir 14906:4]
  reg  _T_87_7; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  wire  _T_113 = _T_112 | _T_87_7; // @[FIFOFixer.scala 82:44 freechips.rocketchip.system.LitexConfig.fir 14907:4]
  wire  _T_114 = _T_106 & _T_113; // @[FIFOFixer.scala 82:26 freechips.rocketchip.system.LitexConfig.fir 14908:4]
  reg [1:0] _T_105; // @[Reg.scala 15:16 freechips.rocketchip.system.LitexConfig.fir 14896:4]
  wire  _T_115 = _T_105 != _T_42; // @[FIFOFixer.scala 82:71 freechips.rocketchip.system.LitexConfig.fir 14909:4]
  wire  _T_116 = _T_44 | _T_115; // @[FIFOFixer.scala 82:65 freechips.rocketchip.system.LitexConfig.fir 14910:4]
  wire  _T_117 = _T_114 & _T_116; // @[FIFOFixer.scala 82:50 freechips.rocketchip.system.LitexConfig.fir 14911:4]
  wire  _T_131 = auto_in_0_a_bits_source[3] & _T_57; // @[FIFOFixer.scala 82:15 freechips.rocketchip.system.LitexConfig.fir 14928:4]
  reg  _T_87_8; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  reg  _T_87_9; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  wire  _T_132 = _T_87_8 | _T_87_9; // @[FIFOFixer.scala 82:44 freechips.rocketchip.system.LitexConfig.fir 14929:4]
  reg  _T_87_10; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  wire  _T_133 = _T_132 | _T_87_10; // @[FIFOFixer.scala 82:44 freechips.rocketchip.system.LitexConfig.fir 14930:4]
  reg  _T_87_11; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  wire  _T_134 = _T_133 | _T_87_11; // @[FIFOFixer.scala 82:44 freechips.rocketchip.system.LitexConfig.fir 14931:4]
  reg  _T_87_12; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  wire  _T_135 = _T_134 | _T_87_12; // @[FIFOFixer.scala 82:44 freechips.rocketchip.system.LitexConfig.fir 14932:4]
  reg  _T_87_13; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  wire  _T_136 = _T_135 | _T_87_13; // @[FIFOFixer.scala 82:44 freechips.rocketchip.system.LitexConfig.fir 14933:4]
  reg  _T_87_14; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  wire  _T_137 = _T_136 | _T_87_14; // @[FIFOFixer.scala 82:44 freechips.rocketchip.system.LitexConfig.fir 14934:4]
  reg  _T_87_15; // @[FIFOFixer.scala 73:27 freechips.rocketchip.system.LitexConfig.fir 14872:4]
  wire  _T_138 = _T_137 | _T_87_15; // @[FIFOFixer.scala 82:44 freechips.rocketchip.system.LitexConfig.fir 14935:4]
  wire  _T_139 = _T_131 & _T_138; // @[FIFOFixer.scala 82:26 freechips.rocketchip.system.LitexConfig.fir 14936:4]
  reg [1:0] _T_130; // @[Reg.scala 15:16 freechips.rocketchip.system.LitexConfig.fir 14924:4]
  wire  _T_140 = _T_130 != _T_42; // @[FIFOFixer.scala 82:71 freechips.rocketchip.system.LitexConfig.fir 14937:4]
  wire  _T_141 = _T_44 | _T_140; // @[FIFOFixer.scala 82:65 freechips.rocketchip.system.LitexConfig.fir 14938:4]
  wire  _T_142 = _T_139 & _T_141; // @[FIFOFixer.scala 82:50 freechips.rocketchip.system.LitexConfig.fir 14939:4]
  wire  _T_144 = _T_117 | _T_142; // @[FIFOFixer.scala 85:49 freechips.rocketchip.system.LitexConfig.fir 14941:4]
  wire  _T_148 = ~_T_144; // @[FIFOFixer.scala 90:50 freechips.rocketchip.system.LitexConfig.fir 14948:4]
  wire  _T_149 = _T_13 | _T_148; // @[FIFOFixer.scala 90:47 freechips.rocketchip.system.LitexConfig.fir 14949:4]
  wire  _T_150 = auto_out_0_a_ready & _T_149; // @[FIFOFixer.scala 90:33 freechips.rocketchip.system.LitexConfig.fir 14950:4]
  wire  _T_45 = _T_150 & auto_in_0_a_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 14807:4]
  wire [26:0] _T_47 = 27'hfff << auto_in_0_a_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 14809:4]
  wire [11:0] _T_49 = ~_T_47[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 14811:4]
  wire  _T_52 = ~auto_in_0_a_bits_opcode[2]; // @[Edges.scala 93:28 freechips.rocketchip.system.LitexConfig.fir 14814:4]
  wire [8:0] _T_56 = _T_54 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 14818:4]
  wire  _T_65 = auto_in_0_d_ready & auto_out_0_d_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 14830:4]
  wire [26:0] _T_67 = 27'hfff << auto_out_0_d_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 14832:4]
  wire [11:0] _T_69 = ~_T_67[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 14834:4]
  reg [8:0] _T_73; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 14838:4]
  wire [8:0] _T_75 = _T_73 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 14840:4]
  wire  _T_76 = _T_73 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 14841:4]
  wire  _T_84 = auto_out_0_d_bits_opcode != 3'h6; // @[FIFOFixer.scala 69:63 freechips.rocketchip.system.LitexConfig.fir 14852:4]
  wire  _T_85 = _T_76 & _T_84; // @[FIFOFixer.scala 69:42 freechips.rocketchip.system.LitexConfig.fir 14853:4]
  wire  _T_89 = _T_57 & _T_45; // @[FIFOFixer.scala 74:21 freechips.rocketchip.system.LitexConfig.fir 14874:4]
  wire  _T_90 = ~_T_13; // @[FIFOFixer.scala 74:67 freechips.rocketchip.system.LitexConfig.fir 14876:6]
  wire  _T_92 = _T_85 & _T_65; // @[FIFOFixer.scala 75:21 freechips.rocketchip.system.LitexConfig.fir 14880:4]
  wire  _T_102 = _T_45 & _T_96; // @[FIFOFixer.scala 79:49 freechips.rocketchip.system.LitexConfig.fir 14893:4]
  wire  _T_104 = _T_102 & _T_90; // @[FIFOFixer.scala 79:58 freechips.rocketchip.system.LitexConfig.fir 14895:4]
  wire  _T_127 = _T_45 & auto_in_0_a_bits_source[3]; // @[FIFOFixer.scala 79:49 freechips.rocketchip.system.LitexConfig.fir 14921:4]
  wire  _T_129 = _T_127 & _T_90; // @[FIFOFixer.scala 79:58 freechips.rocketchip.system.LitexConfig.fir 14923:4]
  TLMonitor_2 TLMonitor ( // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14674:4]
    .clock(TLMonitor_clock),
    .reset(TLMonitor_reset),
    .io_in_a_ready(TLMonitor_io_in_a_ready),
    .io_in_a_valid(TLMonitor_io_in_a_valid),
    .io_in_a_bits_opcode(TLMonitor_io_in_a_bits_opcode),
    .io_in_a_bits_param(TLMonitor_io_in_a_bits_param),
    .io_in_a_bits_size(TLMonitor_io_in_a_bits_size),
    .io_in_a_bits_source(TLMonitor_io_in_a_bits_source),
    .io_in_a_bits_address(TLMonitor_io_in_a_bits_address),
    .io_in_a_bits_mask(TLMonitor_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(TLMonitor_io_in_a_bits_corrupt),
    .io_in_d_ready(TLMonitor_io_in_d_ready),
    .io_in_d_valid(TLMonitor_io_in_d_valid),
    .io_in_d_bits_opcode(TLMonitor_io_in_d_bits_opcode),
    .io_in_d_bits_param(TLMonitor_io_in_d_bits_param),
    .io_in_d_bits_size(TLMonitor_io_in_d_bits_size),
    .io_in_d_bits_source(TLMonitor_io_in_d_bits_source),
    .io_in_d_bits_sink(TLMonitor_io_in_d_bits_sink),
    .io_in_d_bits_denied(TLMonitor_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(TLMonitor_io_in_d_bits_corrupt)
  );
  TLMonitor_3 TLMonitor_1 ( // @[Nodes.scala 25:25 freechips.rocketchip.system.LitexConfig.fir 14704:4]
    .clock(TLMonitor_1_clock),
    .reset(TLMonitor_1_reset),
    .io_in_a_ready(TLMonitor_1_io_in_a_ready),
    .io_in_a_valid(TLMonitor_1_io_in_a_valid),
    .io_in_a_bits_opcode(TLMonitor_1_io_in_a_bits_opcode),
    .io_in_a_bits_param(TLMonitor_1_io_in_a_bits_param),
    .io_in_a_bits_size(TLMonitor_1_io_in_a_bits_size),
    .io_in_a_bits_source(TLMonitor_1_io_in_a_bits_source),
    .io_in_a_bits_address(TLMonitor_1_io_in_a_bits_address),
    .io_in_a_bits_mask(TLMonitor_1_io_in_a_bits_mask),
    .io_in_a_bits_corrupt(TLMonitor_1_io_in_a_bits_corrupt),
    .io_in_b_ready(TLMonitor_1_io_in_b_ready),
    .io_in_b_valid(TLMonitor_1_io_in_b_valid),
    .io_in_b_bits_param(TLMonitor_1_io_in_b_bits_param),
    .io_in_b_bits_address(TLMonitor_1_io_in_b_bits_address),
    .io_in_c_ready(TLMonitor_1_io_in_c_ready),
    .io_in_c_valid(TLMonitor_1_io_in_c_valid),
    .io_in_c_bits_opcode(TLMonitor_1_io_in_c_bits_opcode),
    .io_in_c_bits_param(TLMonitor_1_io_in_c_bits_param),
    .io_in_c_bits_size(TLMonitor_1_io_in_c_bits_size),
    .io_in_c_bits_source(TLMonitor_1_io_in_c_bits_source),
    .io_in_c_bits_address(TLMonitor_1_io_in_c_bits_address),
    .io_in_c_bits_corrupt(TLMonitor_1_io_in_c_bits_corrupt),
    .io_in_d_ready(TLMonitor_1_io_in_d_ready),
    .io_in_d_valid(TLMonitor_1_io_in_d_valid),
    .io_in_d_bits_opcode(TLMonitor_1_io_in_d_bits_opcode),
    .io_in_d_bits_param(TLMonitor_1_io_in_d_bits_param),
    .io_in_d_bits_size(TLMonitor_1_io_in_d_bits_size),
    .io_in_d_bits_source(TLMonitor_1_io_in_d_bits_source),
    .io_in_d_bits_sink(TLMonitor_1_io_in_d_bits_sink),
    .io_in_d_bits_denied(TLMonitor_1_io_in_d_bits_denied),
    .io_in_d_bits_corrupt(TLMonitor_1_io_in_d_bits_corrupt),
    .io_in_e_valid(TLMonitor_1_io_in_e_valid),
    .io_in_e_bits_sink(TLMonitor_1_io_in_e_bits_sink)
  );
  assign auto_in_1_a_ready = auto_out_1_a_ready; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14763:4]
  assign auto_in_1_b_valid = auto_out_1_b_valid; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14763:4]
  assign auto_in_1_b_bits_param = auto_out_1_b_bits_param; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14763:4]
  assign auto_in_1_b_bits_address = auto_out_1_b_bits_address; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14763:4]
  assign auto_in_1_c_ready = auto_out_1_c_ready; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14763:4]
  assign auto_in_1_d_valid = auto_out_1_d_valid; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14763:4]
  assign auto_in_1_d_bits_opcode = auto_out_1_d_bits_opcode; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14763:4]
  assign auto_in_1_d_bits_param = auto_out_1_d_bits_param; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14763:4]
  assign auto_in_1_d_bits_size = auto_out_1_d_bits_size; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14763:4]
  assign auto_in_1_d_bits_source = auto_out_1_d_bits_source; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14763:4]
  assign auto_in_1_d_bits_sink = auto_out_1_d_bits_sink; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14763:4]
  assign auto_in_1_d_bits_denied = auto_out_1_d_bits_denied; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14763:4]
  assign auto_in_1_d_bits_data = auto_out_1_d_bits_data; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14763:4]
  assign auto_in_1_d_bits_corrupt = auto_out_1_d_bits_corrupt; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14763:4]
  assign auto_in_0_a_ready = auto_out_0_a_ready & _T_149; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14762:4]
  assign auto_in_0_d_valid = auto_out_0_d_valid; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14762:4]
  assign auto_in_0_d_bits_opcode = auto_out_0_d_bits_opcode; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14762:4]
  assign auto_in_0_d_bits_param = auto_out_0_d_bits_param; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14762:4]
  assign auto_in_0_d_bits_size = auto_out_0_d_bits_size; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14762:4]
  assign auto_in_0_d_bits_source = auto_out_0_d_bits_source; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14762:4]
  assign auto_in_0_d_bits_sink = auto_out_0_d_bits_sink; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14762:4]
  assign auto_in_0_d_bits_denied = auto_out_0_d_bits_denied; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14762:4]
  assign auto_in_0_d_bits_data = auto_out_0_d_bits_data; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14762:4]
  assign auto_in_0_d_bits_corrupt = auto_out_0_d_bits_corrupt; // @[LazyModule.scala 303:16 freechips.rocketchip.system.LitexConfig.fir 14762:4]
  assign auto_out_1_a_valid = auto_in_1_a_valid; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_a_bits_opcode = auto_in_1_a_bits_opcode; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_a_bits_param = auto_in_1_a_bits_param; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_a_bits_size = auto_in_1_a_bits_size; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_a_bits_source = auto_in_1_a_bits_source; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_a_bits_address = auto_in_1_a_bits_address; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_a_bits_user_amba_prot_bufferable = auto_in_1_a_bits_user_amba_prot_bufferable; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_a_bits_user_amba_prot_modifiable = auto_in_1_a_bits_user_amba_prot_modifiable; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_a_bits_user_amba_prot_readalloc = auto_in_1_a_bits_user_amba_prot_readalloc; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_a_bits_user_amba_prot_writealloc = auto_in_1_a_bits_user_amba_prot_writealloc; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_a_bits_user_amba_prot_privileged = auto_in_1_a_bits_user_amba_prot_privileged; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_a_bits_user_amba_prot_secure = auto_in_1_a_bits_user_amba_prot_secure; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_a_bits_user_amba_prot_fetch = auto_in_1_a_bits_user_amba_prot_fetch; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_a_bits_mask = auto_in_1_a_bits_mask; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_a_bits_data = auto_in_1_a_bits_data; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_a_bits_corrupt = auto_in_1_a_bits_corrupt; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_b_ready = auto_in_1_b_ready; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_c_valid = auto_in_1_c_valid; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_c_bits_opcode = auto_in_1_c_bits_opcode; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_c_bits_param = auto_in_1_c_bits_param; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_c_bits_size = auto_in_1_c_bits_size; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_c_bits_source = auto_in_1_c_bits_source; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_c_bits_address = auto_in_1_c_bits_address; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_c_bits_data = auto_in_1_c_bits_data; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_c_bits_corrupt = auto_in_1_c_bits_corrupt; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_d_ready = auto_in_1_d_ready; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_e_valid = auto_in_1_e_valid; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_1_e_bits_sink = auto_in_1_e_bits_sink; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14761:4]
  assign auto_out_0_a_valid = auto_in_0_a_valid & _T_149; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_a_bits_opcode = auto_in_0_a_bits_opcode; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_a_bits_param = auto_in_0_a_bits_param; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_a_bits_size = auto_in_0_a_bits_size; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_a_bits_source = auto_in_0_a_bits_source; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_a_bits_address = auto_in_0_a_bits_address; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_a_bits_user_amba_prot_bufferable = auto_in_0_a_bits_user_amba_prot_bufferable; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_a_bits_user_amba_prot_modifiable = auto_in_0_a_bits_user_amba_prot_modifiable; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_a_bits_user_amba_prot_readalloc = auto_in_0_a_bits_user_amba_prot_readalloc; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_a_bits_user_amba_prot_writealloc = auto_in_0_a_bits_user_amba_prot_writealloc; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_a_bits_user_amba_prot_privileged = auto_in_0_a_bits_user_amba_prot_privileged; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_a_bits_user_amba_prot_secure = auto_in_0_a_bits_user_amba_prot_secure; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_a_bits_user_amba_prot_fetch = auto_in_0_a_bits_user_amba_prot_fetch; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_a_bits_mask = auto_in_0_a_bits_mask; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_a_bits_data = auto_in_0_a_bits_data; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_a_bits_corrupt = auto_in_0_a_bits_corrupt; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign auto_out_0_d_ready = auto_in_0_d_ready; // @[LazyModule.scala 305:12 freechips.rocketchip.system.LitexConfig.fir 14760:4]
  assign TLMonitor_clock = clock; // @[freechips.rocketchip.system.LitexConfig.fir 14675:4]
  assign TLMonitor_reset = reset; // @[freechips.rocketchip.system.LitexConfig.fir 14676:4]
  assign TLMonitor_io_in_a_ready = auto_out_0_a_ready & _T_149; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14703:4]
  assign TLMonitor_io_in_a_valid = auto_in_0_a_valid; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14702:4]
  assign TLMonitor_io_in_a_bits_opcode = auto_in_0_a_bits_opcode; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14701:4]
  assign TLMonitor_io_in_a_bits_param = auto_in_0_a_bits_param; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14700:4]
  assign TLMonitor_io_in_a_bits_size = auto_in_0_a_bits_size; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14699:4]
  assign TLMonitor_io_in_a_bits_source = auto_in_0_a_bits_source; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14698:4]
  assign TLMonitor_io_in_a_bits_address = auto_in_0_a_bits_address; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14697:4]
  assign TLMonitor_io_in_a_bits_mask = auto_in_0_a_bits_mask; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14689:4]
  assign TLMonitor_io_in_a_bits_corrupt = auto_in_0_a_bits_corrupt; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14687:4]
  assign TLMonitor_io_in_d_ready = auto_in_0_d_ready; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14686:4]
  assign TLMonitor_io_in_d_valid = auto_out_0_d_valid; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14685:4]
  assign TLMonitor_io_in_d_bits_opcode = auto_out_0_d_bits_opcode; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14684:4]
  assign TLMonitor_io_in_d_bits_param = auto_out_0_d_bits_param; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14683:4]
  assign TLMonitor_io_in_d_bits_size = auto_out_0_d_bits_size; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14682:4]
  assign TLMonitor_io_in_d_bits_source = auto_out_0_d_bits_source; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14681:4]
  assign TLMonitor_io_in_d_bits_sink = auto_out_0_d_bits_sink; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14680:4]
  assign TLMonitor_io_in_d_bits_denied = auto_out_0_d_bits_denied; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14679:4]
  assign TLMonitor_io_in_d_bits_corrupt = auto_out_0_d_bits_corrupt; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14677:4]
  assign TLMonitor_1_clock = clock; // @[freechips.rocketchip.system.LitexConfig.fir 14705:4]
  assign TLMonitor_1_reset = reset; // @[freechips.rocketchip.system.LitexConfig.fir 14706:4]
  assign TLMonitor_1_io_in_a_ready = auto_out_1_a_ready; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14755:4]
  assign TLMonitor_1_io_in_a_valid = auto_in_1_a_valid; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14754:4]
  assign TLMonitor_1_io_in_a_bits_opcode = auto_in_1_a_bits_opcode; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14753:4]
  assign TLMonitor_1_io_in_a_bits_param = auto_in_1_a_bits_param; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14752:4]
  assign TLMonitor_1_io_in_a_bits_size = auto_in_1_a_bits_size; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14751:4]
  assign TLMonitor_1_io_in_a_bits_source = auto_in_1_a_bits_source; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14750:4]
  assign TLMonitor_1_io_in_a_bits_address = auto_in_1_a_bits_address; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14749:4]
  assign TLMonitor_1_io_in_a_bits_mask = auto_in_1_a_bits_mask; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14741:4]
  assign TLMonitor_1_io_in_a_bits_corrupt = auto_in_1_a_bits_corrupt; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14739:4]
  assign TLMonitor_1_io_in_b_ready = auto_in_1_b_ready; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14738:4]
  assign TLMonitor_1_io_in_b_valid = auto_out_1_b_valid; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14737:4]
  assign TLMonitor_1_io_in_b_bits_param = auto_out_1_b_bits_param; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14735:4]
  assign TLMonitor_1_io_in_b_bits_address = auto_out_1_b_bits_address; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14732:4]
  assign TLMonitor_1_io_in_c_ready = auto_out_1_c_ready; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14728:4]
  assign TLMonitor_1_io_in_c_valid = auto_in_1_c_valid; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14727:4]
  assign TLMonitor_1_io_in_c_bits_opcode = auto_in_1_c_bits_opcode; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14726:4]
  assign TLMonitor_1_io_in_c_bits_param = auto_in_1_c_bits_param; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14725:4]
  assign TLMonitor_1_io_in_c_bits_size = auto_in_1_c_bits_size; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14724:4]
  assign TLMonitor_1_io_in_c_bits_source = auto_in_1_c_bits_source; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14723:4]
  assign TLMonitor_1_io_in_c_bits_address = auto_in_1_c_bits_address; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14722:4]
  assign TLMonitor_1_io_in_c_bits_corrupt = auto_in_1_c_bits_corrupt; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14720:4]
  assign TLMonitor_1_io_in_d_ready = auto_in_1_d_ready; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14719:4]
  assign TLMonitor_1_io_in_d_valid = auto_out_1_d_valid; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14718:4]
  assign TLMonitor_1_io_in_d_bits_opcode = auto_out_1_d_bits_opcode; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14717:4]
  assign TLMonitor_1_io_in_d_bits_param = auto_out_1_d_bits_param; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14716:4]
  assign TLMonitor_1_io_in_d_bits_size = auto_out_1_d_bits_size; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14715:4]
  assign TLMonitor_1_io_in_d_bits_source = auto_out_1_d_bits_source; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14714:4]
  assign TLMonitor_1_io_in_d_bits_sink = auto_out_1_d_bits_sink; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14713:4]
  assign TLMonitor_1_io_in_d_bits_denied = auto_out_1_d_bits_denied; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14712:4]
  assign TLMonitor_1_io_in_d_bits_corrupt = auto_out_1_d_bits_corrupt; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14710:4]
  assign TLMonitor_1_io_in_e_valid = auto_in_1_e_valid; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14708:4]
  assign TLMonitor_1_io_in_e_bits_sink = auto_in_1_e_bits_sink; // @[Nodes.scala 26:19 freechips.rocketchip.system.LitexConfig.fir 14707:4]
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  _T_54 = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  _T_87_0 = _RAND_1[0:0];
  _RAND_2 = {1{`RANDOM}};
  _T_87_1 = _RAND_2[0:0];
  _RAND_3 = {1{`RANDOM}};
  _T_87_2 = _RAND_3[0:0];
  _RAND_4 = {1{`RANDOM}};
  _T_87_3 = _RAND_4[0:0];
  _RAND_5 = {1{`RANDOM}};
  _T_87_4 = _RAND_5[0:0];
  _RAND_6 = {1{`RANDOM}};
  _T_87_5 = _RAND_6[0:0];
  _RAND_7 = {1{`RANDOM}};
  _T_87_6 = _RAND_7[0:0];
  _RAND_8 = {1{`RANDOM}};
  _T_87_7 = _RAND_8[0:0];
  _RAND_9 = {1{`RANDOM}};
  _T_105 = _RAND_9[1:0];
  _RAND_10 = {1{`RANDOM}};
  _T_87_8 = _RAND_10[0:0];
  _RAND_11 = {1{`RANDOM}};
  _T_87_9 = _RAND_11[0:0];
  _RAND_12 = {1{`RANDOM}};
  _T_87_10 = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  _T_87_11 = _RAND_13[0:0];
  _RAND_14 = {1{`RANDOM}};
  _T_87_12 = _RAND_14[0:0];
  _RAND_15 = {1{`RANDOM}};
  _T_87_13 = _RAND_15[0:0];
  _RAND_16 = {1{`RANDOM}};
  _T_87_14 = _RAND_16[0:0];
  _RAND_17 = {1{`RANDOM}};
  _T_87_15 = _RAND_17[0:0];
  _RAND_18 = {1{`RANDOM}};
  _T_130 = _RAND_18[1:0];
  _RAND_19 = {1{`RANDOM}};
  _T_73 = _RAND_19[8:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
  always @(posedge clock) begin
    if (reset) begin
      _T_54 <= 9'h0;
    end else if (_T_45) begin
      if (_T_57) begin
        if (_T_52) begin
          _T_54 <= _T_49[11:3];
        end else begin
          _T_54 <= 9'h0;
        end
      end else begin
        _T_54 <= _T_56;
      end
    end
    if (reset) begin
      _T_87_0 <= 1'h0;
    end else if (_T_92) begin
      if (4'h0 == auto_out_0_d_bits_source) begin
        _T_87_0 <= 1'h0;
      end else if (_T_89) begin
        if (4'h0 == auto_in_0_a_bits_source) begin
          _T_87_0 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'h0 == auto_in_0_a_bits_source) begin
        _T_87_0 <= _T_90;
      end
    end
    if (reset) begin
      _T_87_1 <= 1'h0;
    end else if (_T_92) begin
      if (4'h1 == auto_out_0_d_bits_source) begin
        _T_87_1 <= 1'h0;
      end else if (_T_89) begin
        if (4'h1 == auto_in_0_a_bits_source) begin
          _T_87_1 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'h1 == auto_in_0_a_bits_source) begin
        _T_87_1 <= _T_90;
      end
    end
    if (reset) begin
      _T_87_2 <= 1'h0;
    end else if (_T_92) begin
      if (4'h2 == auto_out_0_d_bits_source) begin
        _T_87_2 <= 1'h0;
      end else if (_T_89) begin
        if (4'h2 == auto_in_0_a_bits_source) begin
          _T_87_2 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'h2 == auto_in_0_a_bits_source) begin
        _T_87_2 <= _T_90;
      end
    end
    if (reset) begin
      _T_87_3 <= 1'h0;
    end else if (_T_92) begin
      if (4'h3 == auto_out_0_d_bits_source) begin
        _T_87_3 <= 1'h0;
      end else if (_T_89) begin
        if (4'h3 == auto_in_0_a_bits_source) begin
          _T_87_3 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'h3 == auto_in_0_a_bits_source) begin
        _T_87_3 <= _T_90;
      end
    end
    if (reset) begin
      _T_87_4 <= 1'h0;
    end else if (_T_92) begin
      if (4'h4 == auto_out_0_d_bits_source) begin
        _T_87_4 <= 1'h0;
      end else if (_T_89) begin
        if (4'h4 == auto_in_0_a_bits_source) begin
          _T_87_4 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'h4 == auto_in_0_a_bits_source) begin
        _T_87_4 <= _T_90;
      end
    end
    if (reset) begin
      _T_87_5 <= 1'h0;
    end else if (_T_92) begin
      if (4'h5 == auto_out_0_d_bits_source) begin
        _T_87_5 <= 1'h0;
      end else if (_T_89) begin
        if (4'h5 == auto_in_0_a_bits_source) begin
          _T_87_5 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'h5 == auto_in_0_a_bits_source) begin
        _T_87_5 <= _T_90;
      end
    end
    if (reset) begin
      _T_87_6 <= 1'h0;
    end else if (_T_92) begin
      if (4'h6 == auto_out_0_d_bits_source) begin
        _T_87_6 <= 1'h0;
      end else if (_T_89) begin
        if (4'h6 == auto_in_0_a_bits_source) begin
          _T_87_6 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'h6 == auto_in_0_a_bits_source) begin
        _T_87_6 <= _T_90;
      end
    end
    if (reset) begin
      _T_87_7 <= 1'h0;
    end else if (_T_92) begin
      if (4'h7 == auto_out_0_d_bits_source) begin
        _T_87_7 <= 1'h0;
      end else if (_T_89) begin
        if (4'h7 == auto_in_0_a_bits_source) begin
          _T_87_7 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'h7 == auto_in_0_a_bits_source) begin
        _T_87_7 <= _T_90;
      end
    end
    if (_T_104) begin
      _T_105 <= _T_42;
    end
    if (reset) begin
      _T_87_8 <= 1'h0;
    end else if (_T_92) begin
      if (4'h8 == auto_out_0_d_bits_source) begin
        _T_87_8 <= 1'h0;
      end else if (_T_89) begin
        if (4'h8 == auto_in_0_a_bits_source) begin
          _T_87_8 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'h8 == auto_in_0_a_bits_source) begin
        _T_87_8 <= _T_90;
      end
    end
    if (reset) begin
      _T_87_9 <= 1'h0;
    end else if (_T_92) begin
      if (4'h9 == auto_out_0_d_bits_source) begin
        _T_87_9 <= 1'h0;
      end else if (_T_89) begin
        if (4'h9 == auto_in_0_a_bits_source) begin
          _T_87_9 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'h9 == auto_in_0_a_bits_source) begin
        _T_87_9 <= _T_90;
      end
    end
    if (reset) begin
      _T_87_10 <= 1'h0;
    end else if (_T_92) begin
      if (4'ha == auto_out_0_d_bits_source) begin
        _T_87_10 <= 1'h0;
      end else if (_T_89) begin
        if (4'ha == auto_in_0_a_bits_source) begin
          _T_87_10 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'ha == auto_in_0_a_bits_source) begin
        _T_87_10 <= _T_90;
      end
    end
    if (reset) begin
      _T_87_11 <= 1'h0;
    end else if (_T_92) begin
      if (4'hb == auto_out_0_d_bits_source) begin
        _T_87_11 <= 1'h0;
      end else if (_T_89) begin
        if (4'hb == auto_in_0_a_bits_source) begin
          _T_87_11 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'hb == auto_in_0_a_bits_source) begin
        _T_87_11 <= _T_90;
      end
    end
    if (reset) begin
      _T_87_12 <= 1'h0;
    end else if (_T_92) begin
      if (4'hc == auto_out_0_d_bits_source) begin
        _T_87_12 <= 1'h0;
      end else if (_T_89) begin
        if (4'hc == auto_in_0_a_bits_source) begin
          _T_87_12 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'hc == auto_in_0_a_bits_source) begin
        _T_87_12 <= _T_90;
      end
    end
    if (reset) begin
      _T_87_13 <= 1'h0;
    end else if (_T_92) begin
      if (4'hd == auto_out_0_d_bits_source) begin
        _T_87_13 <= 1'h0;
      end else if (_T_89) begin
        if (4'hd == auto_in_0_a_bits_source) begin
          _T_87_13 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'hd == auto_in_0_a_bits_source) begin
        _T_87_13 <= _T_90;
      end
    end
    if (reset) begin
      _T_87_14 <= 1'h0;
    end else if (_T_92) begin
      if (4'he == auto_out_0_d_bits_source) begin
        _T_87_14 <= 1'h0;
      end else if (_T_89) begin
        if (4'he == auto_in_0_a_bits_source) begin
          _T_87_14 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'he == auto_in_0_a_bits_source) begin
        _T_87_14 <= _T_90;
      end
    end
    if (reset) begin
      _T_87_15 <= 1'h0;
    end else if (_T_92) begin
      if (4'hf == auto_out_0_d_bits_source) begin
        _T_87_15 <= 1'h0;
      end else if (_T_89) begin
        if (4'hf == auto_in_0_a_bits_source) begin
          _T_87_15 <= _T_90;
        end
      end
    end else if (_T_89) begin
      if (4'hf == auto_in_0_a_bits_source) begin
        _T_87_15 <= _T_90;
      end
    end
    if (_T_129) begin
      _T_130 <= _T_42;
    end
    if (reset) begin
      _T_73 <= 9'h0;
    end else if (_T_65) begin
      if (_T_76) begin
        if (auto_out_0_d_bits_opcode[0]) begin
          _T_73 <= _T_69[11:3];
        end else begin
          _T_73 <= 9'h0;
        end
      end else begin
        _T_73 <= _T_75;
      end
    end
  end
endmodule
module TLMonitor_4( // @[freechips.rocketchip.system.LitexConfig.fir 15182:2]
  input         clock, // @[freechips.rocketchip.system.LitexConfig.fir 15183:4]
  input         reset, // @[freechips.rocketchip.system.LitexConfig.fir 15184:4]
  input         io_in_a_ready, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input         io_in_a_valid, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input  [2:0]  io_in_a_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input  [2:0]  io_in_a_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input  [3:0]  io_in_a_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input  [4:0]  io_in_a_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input  [27:0] io_in_a_bits_address, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input  [7:0]  io_in_a_bits_mask, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input         io_in_a_bits_corrupt, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input         io_in_d_ready, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input         io_in_d_valid, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input  [2:0]  io_in_d_bits_opcode, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input  [1:0]  io_in_d_bits_param, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input  [3:0]  io_in_d_bits_size, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input  [4:0]  io_in_d_bits_source, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input         io_in_d_bits_sink, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input         io_in_d_bits_denied, // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
  input         io_in_d_bits_corrupt // @[freechips.rocketchip.system.LitexConfig.fir 15185:4]
);
`ifdef RANDOMIZE_REG_INIT
  reg [31:0] _RAND_0;
  reg [31:0] _RAND_1;
  reg [31:0] _RAND_2;
  reg [31:0] _RAND_3;
  reg [31:0] _RAND_4;
  reg [31:0] _RAND_5;
  reg [31:0] _RAND_6;
  reg [31:0] _RAND_7;
  reg [31:0] _RAND_8;
  reg [31:0] _RAND_9;
  reg [31:0] _RAND_10;
  reg [31:0] _RAND_11;
  reg [31:0] _RAND_12;
  reg [31:0] _RAND_13;
  reg [95:0] _RAND_14;
  reg [159:0] _RAND_15;
  reg [31:0] _RAND_16;
  reg [31:0] _RAND_17;
  reg [31:0] _RAND_18;
  reg [31:0] _RAND_19;
  reg [159:0] _RAND_20;
  reg [31:0] _RAND_21;
  reg [31:0] _RAND_22;
`endif // RANDOMIZE_REG_INIT
  wire [31:0] plusarg_reader_out; // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 17107:4]
  wire [31:0] plusarg_reader_1_out; // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 17414:4]
  wire  _T_7 = io_in_a_bits_source[4:3] == 2'h0; // @[Parameters.scala 55:32 freechips.rocketchip.system.LitexConfig.fir 15199:6]
  wire  _T_15 = io_in_a_bits_source[4:3] == 2'h1; // @[Parameters.scala 55:32 freechips.rocketchip.system.LitexConfig.fir 15207:6]
  wire  _T_20 = io_in_a_bits_source == 5'h10; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 15212:6]
  wire  _T_21 = io_in_a_bits_source == 5'h11; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 15213:6]
  wire  _T_22 = io_in_a_bits_source == 5'h12; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 15214:6]
  wire  _T_24 = _T_7 | _T_15; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 15222:6]
  wire  _T_25 = _T_24 | _T_20; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 15223:6]
  wire  _T_26 = _T_25 | _T_21; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 15224:6]
  wire  _T_27 = _T_26 | _T_22; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 15225:6]
  wire [26:0] _T_29 = 27'hfff << io_in_a_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 15227:6]
  wire [11:0] _T_31 = ~_T_29[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 15229:6]
  wire [27:0] _GEN_71 = {{16'd0}, _T_31}; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 15230:6]
  wire [27:0] _T_32 = io_in_a_bits_address & _GEN_71; // @[Edges.scala 22:16 freechips.rocketchip.system.LitexConfig.fir 15230:6]
  wire  _T_33 = _T_32 == 28'h0; // @[Edges.scala 22:24 freechips.rocketchip.system.LitexConfig.fir 15231:6]
  wire [3:0] _T_36 = 4'h1 << io_in_a_bits_size[1:0]; // @[OneHot.scala 65:12 freechips.rocketchip.system.LitexConfig.fir 15234:6]
  wire [2:0] _T_38 = _T_36[2:0] | 3'h1; // @[Misc.scala 201:81 freechips.rocketchip.system.LitexConfig.fir 15236:6]
  wire  _T_39 = io_in_a_bits_size >= 4'h3; // @[Misc.scala 205:21 freechips.rocketchip.system.LitexConfig.fir 15237:6]
  wire  _T_42 = ~io_in_a_bits_address[2]; // @[Misc.scala 210:20 freechips.rocketchip.system.LitexConfig.fir 15240:6]
  wire  _T_44 = _T_38[2] & _T_42; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 15242:6]
  wire  _T_45 = _T_39 | _T_44; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 15243:6]
  wire  _T_47 = _T_38[2] & io_in_a_bits_address[2]; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 15245:6]
  wire  _T_48 = _T_39 | _T_47; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 15246:6]
  wire  _T_51 = ~io_in_a_bits_address[1]; // @[Misc.scala 210:20 freechips.rocketchip.system.LitexConfig.fir 15249:6]
  wire  _T_52 = _T_42 & _T_51; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 15250:6]
  wire  _T_53 = _T_38[1] & _T_52; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 15251:6]
  wire  _T_54 = _T_45 | _T_53; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 15252:6]
  wire  _T_55 = _T_42 & io_in_a_bits_address[1]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 15253:6]
  wire  _T_56 = _T_38[1] & _T_55; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 15254:6]
  wire  _T_57 = _T_45 | _T_56; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 15255:6]
  wire  _T_58 = io_in_a_bits_address[2] & _T_51; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 15256:6]
  wire  _T_59 = _T_38[1] & _T_58; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 15257:6]
  wire  _T_60 = _T_48 | _T_59; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 15258:6]
  wire  _T_61 = io_in_a_bits_address[2] & io_in_a_bits_address[1]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 15259:6]
  wire  _T_62 = _T_38[1] & _T_61; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 15260:6]
  wire  _T_63 = _T_48 | _T_62; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 15261:6]
  wire  _T_66 = ~io_in_a_bits_address[0]; // @[Misc.scala 210:20 freechips.rocketchip.system.LitexConfig.fir 15264:6]
  wire  _T_67 = _T_52 & _T_66; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 15265:6]
  wire  _T_68 = _T_38[0] & _T_67; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 15266:6]
  wire  _T_69 = _T_54 | _T_68; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 15267:6]
  wire  _T_70 = _T_52 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 15268:6]
  wire  _T_71 = _T_38[0] & _T_70; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 15269:6]
  wire  _T_72 = _T_54 | _T_71; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 15270:6]
  wire  _T_73 = _T_55 & _T_66; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 15271:6]
  wire  _T_74 = _T_38[0] & _T_73; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 15272:6]
  wire  _T_75 = _T_57 | _T_74; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 15273:6]
  wire  _T_76 = _T_55 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 15274:6]
  wire  _T_77 = _T_38[0] & _T_76; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 15275:6]
  wire  _T_78 = _T_57 | _T_77; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 15276:6]
  wire  _T_79 = _T_58 & _T_66; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 15277:6]
  wire  _T_80 = _T_38[0] & _T_79; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 15278:6]
  wire  _T_81 = _T_60 | _T_80; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 15279:6]
  wire  _T_82 = _T_58 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 15280:6]
  wire  _T_83 = _T_38[0] & _T_82; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 15281:6]
  wire  _T_84 = _T_60 | _T_83; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 15282:6]
  wire  _T_85 = _T_61 & _T_66; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 15283:6]
  wire  _T_86 = _T_38[0] & _T_85; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 15284:6]
  wire  _T_87 = _T_63 | _T_86; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 15285:6]
  wire  _T_88 = _T_61 & io_in_a_bits_address[0]; // @[Misc.scala 213:27 freechips.rocketchip.system.LitexConfig.fir 15286:6]
  wire  _T_89 = _T_38[0] & _T_88; // @[Misc.scala 214:38 freechips.rocketchip.system.LitexConfig.fir 15287:6]
  wire  _T_90 = _T_63 | _T_89; // @[Misc.scala 214:29 freechips.rocketchip.system.LitexConfig.fir 15288:6]
  wire [7:0] _T_97 = {_T_90,_T_87,_T_84,_T_81,_T_78,_T_75,_T_72,_T_69}; // @[Cat.scala 29:58 freechips.rocketchip.system.LitexConfig.fir 15295:6]
  wire [28:0] _T_108 = {1'b0,$signed(io_in_a_bits_address)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 15306:6]
  wire  _T_159 = io_in_a_bits_opcode == 3'h6; // @[Monitor.scala 83:25 freechips.rocketchip.system.LitexConfig.fir 15361:6]
  wire  _T_161 = io_in_a_bits_size <= 4'hc; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 15364:8]
  wire  _T_186 = _T_161 & _T_27; // @[Parameters.scala 1195:30 freechips.rocketchip.system.LitexConfig.fir 15389:8]
  wire  _T_199 = ~reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15402:8]
  wire  _T_220 = 4'h6 == io_in_a_bits_size; // @[Parameters.scala 92:48 freechips.rocketchip.system.LitexConfig.fir 15433:8]
  wire  _T_223 = _T_20 & _T_220; // @[Mux.scala 27:72 freechips.rocketchip.system.LitexConfig.fir 15436:8]
  wire  _T_242 = _T_223 & _T_161; // @[Parameters.scala 1417:195 freechips.rocketchip.system.LitexConfig.fir 15456:8]
  wire  _T_244 = _T_242 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15458:8]
  wire  _T_245 = ~_T_244; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15459:8]
  wire  _T_247 = _T_27 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15465:8]
  wire  _T_248 = ~_T_247; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15466:8]
  wire  _T_251 = _T_39 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15473:8]
  wire  _T_252 = ~_T_251; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15474:8]
  wire  _T_254 = _T_33 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15480:8]
  wire  _T_255 = ~_T_254; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15481:8]
  wire  _T_256 = io_in_a_bits_param <= 3'h2; // @[Bundles.scala 110:27 freechips.rocketchip.system.LitexConfig.fir 15486:8]
  wire  _T_258 = _T_256 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15488:8]
  wire  _T_259 = ~_T_258; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15489:8]
  wire [7:0] _T_260 = ~io_in_a_bits_mask; // @[Monitor.scala 90:18 freechips.rocketchip.system.LitexConfig.fir 15494:8]
  wire  _T_261 = _T_260 == 8'h0; // @[Monitor.scala 90:31 freechips.rocketchip.system.LitexConfig.fir 15495:8]
  wire  _T_263 = _T_261 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15497:8]
  wire  _T_264 = ~_T_263; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15498:8]
  wire  _T_265 = ~io_in_a_bits_corrupt; // @[Monitor.scala 91:18 freechips.rocketchip.system.LitexConfig.fir 15503:8]
  wire  _T_267 = _T_265 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15505:8]
  wire  _T_268 = ~_T_267; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15506:8]
  wire  _T_269 = io_in_a_bits_opcode == 3'h7; // @[Monitor.scala 94:25 freechips.rocketchip.system.LitexConfig.fir 15512:6]
  wire  _T_370 = io_in_a_bits_param != 3'h0; // @[Monitor.scala 101:31 freechips.rocketchip.system.LitexConfig.fir 15645:8]
  wire  _T_372 = _T_370 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15647:8]
  wire  _T_373 = ~_T_372; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15648:8]
  wire  _T_383 = io_in_a_bits_opcode == 3'h4; // @[Monitor.scala 106:25 freechips.rocketchip.system.LitexConfig.fir 15671:6]
  wire  _T_413 = _T_186 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15702:8]
  wire  _T_414 = ~_T_413; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15703:8]
  wire [27:0] _T_419 = io_in_a_bits_address ^ 28'h2000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 15712:8]
  wire [28:0] _T_420 = {1'b0,$signed(_T_419)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 15713:8]
  wire [28:0] _T_422 = $signed(_T_420) & 29'sha012000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 15715:8]
  wire  _T_423 = $signed(_T_422) == 29'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 15716:8]
  wire  _T_424 = _T_161 & _T_423; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 15717:8]
  wire  _T_426 = io_in_a_bits_size <= 4'h6; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 15719:8]
  wire [28:0] _T_432 = $signed(_T_108) & 29'sha012000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 15725:8]
  wire  _T_433 = $signed(_T_432) == 29'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 15726:8]
  wire [27:0] _T_434 = io_in_a_bits_address ^ 28'h10000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 15727:8]
  wire [28:0] _T_435 = {1'b0,$signed(_T_434)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 15728:8]
  wire [28:0] _T_437 = $signed(_T_435) & 29'sha010000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 15730:8]
  wire  _T_438 = $signed(_T_437) == 29'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 15731:8]
  wire [27:0] _T_439 = io_in_a_bits_address ^ 28'h2000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 15732:8]
  wire [28:0] _T_440 = {1'b0,$signed(_T_439)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 15733:8]
  wire [28:0] _T_442 = $signed(_T_440) & 29'sha010000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 15735:8]
  wire  _T_443 = $signed(_T_442) == 29'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 15736:8]
  wire [27:0] _T_444 = io_in_a_bits_address ^ 28'h8000000; // @[Parameters.scala 138:31 freechips.rocketchip.system.LitexConfig.fir 15737:8]
  wire [28:0] _T_445 = {1'b0,$signed(_T_444)}; // @[Parameters.scala 138:49 freechips.rocketchip.system.LitexConfig.fir 15738:8]
  wire [28:0] _T_447 = $signed(_T_445) & 29'sh8000000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 15740:8]
  wire  _T_448 = $signed(_T_447) == 29'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 15741:8]
  wire  _T_449 = _T_433 | _T_438; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 15742:8]
  wire  _T_450 = _T_449 | _T_443; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 15743:8]
  wire  _T_451 = _T_450 | _T_448; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 15744:8]
  wire  _T_452 = _T_426 & _T_451; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 15745:8]
  wire  _T_454 = _T_424 | _T_452; // @[Parameters.scala 661:30 freechips.rocketchip.system.LitexConfig.fir 15747:8]
  wire  _T_456 = _T_454 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15749:8]
  wire  _T_457 = ~_T_456; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15750:8]
  wire  _T_464 = io_in_a_bits_param == 3'h0; // @[Monitor.scala 111:31 freechips.rocketchip.system.LitexConfig.fir 15769:8]
  wire  _T_466 = _T_464 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15771:8]
  wire  _T_467 = ~_T_466; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15772:8]
  wire  _T_468 = io_in_a_bits_mask == _T_97; // @[Monitor.scala 112:30 freechips.rocketchip.system.LitexConfig.fir 15777:8]
  wire  _T_470 = _T_468 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15779:8]
  wire  _T_471 = ~_T_470; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15780:8]
  wire  _T_476 = io_in_a_bits_opcode == 3'h0; // @[Monitor.scala 116:25 freechips.rocketchip.system.LitexConfig.fir 15794:6]
  wire  _T_534 = _T_433 | _T_443; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 15853:8]
  wire  _T_535 = _T_534 | _T_448; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 15854:8]
  wire  _T_536 = _T_426 & _T_535; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 15855:8]
  wire  _T_545 = _T_424 | _T_536; // @[Parameters.scala 661:30 freechips.rocketchip.system.LitexConfig.fir 15864:8]
  wire  _T_547 = _T_186 & _T_545; // @[Parameters.scala 1406:195 freechips.rocketchip.system.LitexConfig.fir 15866:8]
  wire  _T_549 = _T_547 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15868:8]
  wire  _T_550 = ~_T_549; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15869:8]
  wire  _T_565 = io_in_a_bits_opcode == 3'h1; // @[Monitor.scala 124:25 freechips.rocketchip.system.LitexConfig.fir 15905:6]
  wire [7:0] _T_650 = ~_T_97; // @[Monitor.scala 129:33 freechips.rocketchip.system.LitexConfig.fir 16007:8]
  wire [7:0] _T_651 = io_in_a_bits_mask & _T_650; // @[Monitor.scala 129:31 freechips.rocketchip.system.LitexConfig.fir 16008:8]
  wire  _T_652 = _T_651 == 8'h0; // @[Monitor.scala 129:40 freechips.rocketchip.system.LitexConfig.fir 16009:8]
  wire  _T_654 = _T_652 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16011:8]
  wire  _T_655 = ~_T_654; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16012:8]
  wire  _T_656 = io_in_a_bits_opcode == 3'h2; // @[Monitor.scala 132:25 freechips.rocketchip.system.LitexConfig.fir 16018:6]
  wire  _T_686 = io_in_a_bits_size <= 4'h3; // @[Parameters.scala 93:42 freechips.rocketchip.system.LitexConfig.fir 16049:8]
  wire [28:0] _T_692 = $signed(_T_108) & 29'sh8010000; // @[Parameters.scala 138:52 freechips.rocketchip.system.LitexConfig.fir 16055:8]
  wire  _T_693 = $signed(_T_692) == 29'sh0; // @[Parameters.scala 138:67 freechips.rocketchip.system.LitexConfig.fir 16056:8]
  wire  _T_699 = _T_693 | _T_448; // @[Parameters.scala 660:42 freechips.rocketchip.system.LitexConfig.fir 16062:8]
  wire  _T_700 = _T_686 & _T_699; // @[Parameters.scala 659:56 freechips.rocketchip.system.LitexConfig.fir 16063:8]
  wire  _T_710 = _T_186 & _T_700; // @[Parameters.scala 1403:195 freechips.rocketchip.system.LitexConfig.fir 16073:8]
  wire  _T_712 = _T_710 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16075:8]
  wire  _T_713 = ~_T_712; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16076:8]
  wire  _T_720 = io_in_a_bits_param <= 3'h4; // @[Bundles.scala 140:33 freechips.rocketchip.system.LitexConfig.fir 16095:8]
  wire  _T_722 = _T_720 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16097:8]
  wire  _T_723 = ~_T_722; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16098:8]
  wire  _T_728 = io_in_a_bits_opcode == 3'h3; // @[Monitor.scala 140:25 freechips.rocketchip.system.LitexConfig.fir 16112:6]
  wire  _T_792 = io_in_a_bits_param <= 3'h3; // @[Bundles.scala 147:30 freechips.rocketchip.system.LitexConfig.fir 16189:8]
  wire  _T_794 = _T_792 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16191:8]
  wire  _T_795 = ~_T_794; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16192:8]
  wire  _T_800 = io_in_a_bits_opcode == 3'h5; // @[Monitor.scala 148:25 freechips.rocketchip.system.LitexConfig.fir 16206:6]
  wire  _T_866 = _T_186 & _T_424; // @[Parameters.scala 1408:195 freechips.rocketchip.system.LitexConfig.fir 16273:8]
  wire  _T_868 = _T_866 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16275:8]
  wire  _T_869 = ~_T_868; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16276:8]
  wire  _T_876 = io_in_a_bits_param <= 3'h1; // @[Bundles.scala 160:28 freechips.rocketchip.system.LitexConfig.fir 16295:8]
  wire  _T_878 = _T_876 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16297:8]
  wire  _T_879 = ~_T_878; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16298:8]
  wire  _T_888 = io_in_d_bits_opcode <= 3'h6; // @[Bundles.scala 44:24 freechips.rocketchip.system.LitexConfig.fir 16322:6]
  wire  _T_890 = _T_888 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16324:6]
  wire  _T_891 = ~_T_890; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16325:6]
  wire  _T_895 = io_in_d_bits_source[4:3] == 2'h0; // @[Parameters.scala 55:32 freechips.rocketchip.system.LitexConfig.fir 16333:6]
  wire  _T_903 = io_in_d_bits_source[4:3] == 2'h1; // @[Parameters.scala 55:32 freechips.rocketchip.system.LitexConfig.fir 16341:6]
  wire  _T_908 = io_in_d_bits_source == 5'h10; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 16346:6]
  wire  _T_909 = io_in_d_bits_source == 5'h11; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 16347:6]
  wire  _T_910 = io_in_d_bits_source == 5'h12; // @[Parameters.scala 47:9 freechips.rocketchip.system.LitexConfig.fir 16348:6]
  wire  _T_912 = _T_895 | _T_903; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 16356:6]
  wire  _T_913 = _T_912 | _T_908; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 16357:6]
  wire  _T_914 = _T_913 | _T_909; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 16358:6]
  wire  _T_915 = _T_914 | _T_910; // @[Parameters.scala 1145:46 freechips.rocketchip.system.LitexConfig.fir 16359:6]
  wire  _T_917 = io_in_d_bits_opcode == 3'h6; // @[Monitor.scala 312:25 freechips.rocketchip.system.LitexConfig.fir 16361:6]
  wire  _T_919 = _T_915 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16364:8]
  wire  _T_920 = ~_T_919; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16365:8]
  wire  _T_921 = io_in_d_bits_size >= 4'h3; // @[Monitor.scala 314:27 freechips.rocketchip.system.LitexConfig.fir 16370:8]
  wire  _T_923 = _T_921 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16372:8]
  wire  _T_924 = ~_T_923; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16373:8]
  wire  _T_925 = io_in_d_bits_param == 2'h0; // @[Monitor.scala 315:28 freechips.rocketchip.system.LitexConfig.fir 16378:8]
  wire  _T_927 = _T_925 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16380:8]
  wire  _T_928 = ~_T_927; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16381:8]
  wire  _T_929 = ~io_in_d_bits_corrupt; // @[Monitor.scala 316:15 freechips.rocketchip.system.LitexConfig.fir 16386:8]
  wire  _T_931 = _T_929 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16388:8]
  wire  _T_932 = ~_T_931; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16389:8]
  wire  _T_933 = ~io_in_d_bits_denied; // @[Monitor.scala 317:15 freechips.rocketchip.system.LitexConfig.fir 16394:8]
  wire  _T_935 = _T_933 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16396:8]
  wire  _T_936 = ~_T_935; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16397:8]
  wire  _T_937 = io_in_d_bits_opcode == 3'h4; // @[Monitor.scala 320:25 freechips.rocketchip.system.LitexConfig.fir 16403:6]
  wire  _T_948 = io_in_d_bits_param <= 2'h2; // @[Bundles.scala 104:26 freechips.rocketchip.system.LitexConfig.fir 16427:8]
  wire  _T_950 = _T_948 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16429:8]
  wire  _T_951 = ~_T_950; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16430:8]
  wire  _T_952 = io_in_d_bits_param != 2'h2; // @[Monitor.scala 325:28 freechips.rocketchip.system.LitexConfig.fir 16435:8]
  wire  _T_954 = _T_952 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16437:8]
  wire  _T_955 = ~_T_954; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16438:8]
  wire  _T_965 = io_in_d_bits_opcode == 3'h5; // @[Monitor.scala 330:25 freechips.rocketchip.system.LitexConfig.fir 16461:6]
  wire  _T_985 = _T_933 | io_in_d_bits_corrupt; // @[Monitor.scala 336:30 freechips.rocketchip.system.LitexConfig.fir 16502:8]
  wire  _T_987 = _T_985 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16504:8]
  wire  _T_988 = ~_T_987; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16505:8]
  wire  _T_994 = io_in_d_bits_opcode == 3'h0; // @[Monitor.scala 340:25 freechips.rocketchip.system.LitexConfig.fir 16520:6]
  wire  _T_1011 = io_in_d_bits_opcode == 3'h1; // @[Monitor.scala 348:25 freechips.rocketchip.system.LitexConfig.fir 16555:6]
  wire  _T_1029 = io_in_d_bits_opcode == 3'h2; // @[Monitor.scala 356:25 freechips.rocketchip.system.LitexConfig.fir 16591:6]
  wire  _T_1061 = io_in_a_ready & io_in_a_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 16657:4]
  wire  _T_1068 = ~io_in_a_bits_opcode[2]; // @[Edges.scala 93:28 freechips.rocketchip.system.LitexConfig.fir 16664:4]
  reg [8:0] _T_1070; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 16666:4]
  wire [8:0] _T_1072 = _T_1070 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 16668:4]
  wire  _T_1073 = _T_1070 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 16669:4]
  reg [2:0] _T_1081; // @[Monitor.scala 386:22 freechips.rocketchip.system.LitexConfig.fir 16680:4]
  reg [2:0] _T_1082; // @[Monitor.scala 387:22 freechips.rocketchip.system.LitexConfig.fir 16681:4]
  reg [3:0] _T_1083; // @[Monitor.scala 388:22 freechips.rocketchip.system.LitexConfig.fir 16682:4]
  reg [4:0] _T_1084; // @[Monitor.scala 389:22 freechips.rocketchip.system.LitexConfig.fir 16683:4]
  reg [27:0] _T_1085; // @[Monitor.scala 390:22 freechips.rocketchip.system.LitexConfig.fir 16684:4]
  wire  _T_1086 = ~_T_1073; // @[Monitor.scala 391:22 freechips.rocketchip.system.LitexConfig.fir 16685:4]
  wire  _T_1087 = io_in_a_valid & _T_1086; // @[Monitor.scala 391:19 freechips.rocketchip.system.LitexConfig.fir 16686:4]
  wire  _T_1088 = io_in_a_bits_opcode == _T_1081; // @[Monitor.scala 392:32 freechips.rocketchip.system.LitexConfig.fir 16688:6]
  wire  _T_1090 = _T_1088 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16690:6]
  wire  _T_1091 = ~_T_1090; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16691:6]
  wire  _T_1092 = io_in_a_bits_param == _T_1082; // @[Monitor.scala 393:32 freechips.rocketchip.system.LitexConfig.fir 16696:6]
  wire  _T_1094 = _T_1092 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16698:6]
  wire  _T_1095 = ~_T_1094; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16699:6]
  wire  _T_1096 = io_in_a_bits_size == _T_1083; // @[Monitor.scala 394:32 freechips.rocketchip.system.LitexConfig.fir 16704:6]
  wire  _T_1098 = _T_1096 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16706:6]
  wire  _T_1099 = ~_T_1098; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16707:6]
  wire  _T_1100 = io_in_a_bits_source == _T_1084; // @[Monitor.scala 395:32 freechips.rocketchip.system.LitexConfig.fir 16712:6]
  wire  _T_1102 = _T_1100 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16714:6]
  wire  _T_1103 = ~_T_1102; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16715:6]
  wire  _T_1104 = io_in_a_bits_address == _T_1085; // @[Monitor.scala 396:32 freechips.rocketchip.system.LitexConfig.fir 16720:6]
  wire  _T_1106 = _T_1104 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16722:6]
  wire  _T_1107 = ~_T_1106; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16723:6]
  wire  _T_1109 = _T_1061 & _T_1073; // @[Monitor.scala 398:20 freechips.rocketchip.system.LitexConfig.fir 16730:4]
  wire  _T_1110 = io_in_d_ready & io_in_d_valid; // @[Decoupled.scala 40:37 freechips.rocketchip.system.LitexConfig.fir 16738:4]
  wire [26:0] _T_1112 = 27'hfff << io_in_d_bits_size; // @[package.scala 212:77 freechips.rocketchip.system.LitexConfig.fir 16740:4]
  wire [11:0] _T_1114 = ~_T_1112[11:0]; // @[package.scala 212:46 freechips.rocketchip.system.LitexConfig.fir 16742:4]
  reg [8:0] _T_1118; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 16746:4]
  wire [8:0] _T_1120 = _T_1118 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 16748:4]
  wire  _T_1121 = _T_1118 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 16749:4]
  reg [2:0] _T_1129; // @[Monitor.scala 537:22 freechips.rocketchip.system.LitexConfig.fir 16760:4]
  reg [1:0] _T_1130; // @[Monitor.scala 538:22 freechips.rocketchip.system.LitexConfig.fir 16761:4]
  reg [3:0] _T_1131; // @[Monitor.scala 539:22 freechips.rocketchip.system.LitexConfig.fir 16762:4]
  reg [4:0] _T_1132; // @[Monitor.scala 540:22 freechips.rocketchip.system.LitexConfig.fir 16763:4]
  reg  _T_1133; // @[Monitor.scala 541:22 freechips.rocketchip.system.LitexConfig.fir 16764:4]
  reg  _T_1134; // @[Monitor.scala 542:22 freechips.rocketchip.system.LitexConfig.fir 16765:4]
  wire  _T_1135 = ~_T_1121; // @[Monitor.scala 543:22 freechips.rocketchip.system.LitexConfig.fir 16766:4]
  wire  _T_1136 = io_in_d_valid & _T_1135; // @[Monitor.scala 543:19 freechips.rocketchip.system.LitexConfig.fir 16767:4]
  wire  _T_1137 = io_in_d_bits_opcode == _T_1129; // @[Monitor.scala 544:29 freechips.rocketchip.system.LitexConfig.fir 16769:6]
  wire  _T_1139 = _T_1137 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16771:6]
  wire  _T_1140 = ~_T_1139; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16772:6]
  wire  _T_1141 = io_in_d_bits_param == _T_1130; // @[Monitor.scala 545:29 freechips.rocketchip.system.LitexConfig.fir 16777:6]
  wire  _T_1143 = _T_1141 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16779:6]
  wire  _T_1144 = ~_T_1143; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16780:6]
  wire  _T_1145 = io_in_d_bits_size == _T_1131; // @[Monitor.scala 546:29 freechips.rocketchip.system.LitexConfig.fir 16785:6]
  wire  _T_1147 = _T_1145 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16787:6]
  wire  _T_1148 = ~_T_1147; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16788:6]
  wire  _T_1149 = io_in_d_bits_source == _T_1132; // @[Monitor.scala 547:29 freechips.rocketchip.system.LitexConfig.fir 16793:6]
  wire  _T_1151 = _T_1149 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16795:6]
  wire  _T_1152 = ~_T_1151; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16796:6]
  wire  _T_1153 = io_in_d_bits_sink == _T_1133; // @[Monitor.scala 548:29 freechips.rocketchip.system.LitexConfig.fir 16801:6]
  wire  _T_1155 = _T_1153 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16803:6]
  wire  _T_1156 = ~_T_1155; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16804:6]
  wire  _T_1157 = io_in_d_bits_denied == _T_1134; // @[Monitor.scala 549:29 freechips.rocketchip.system.LitexConfig.fir 16809:6]
  wire  _T_1159 = _T_1157 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16811:6]
  wire  _T_1160 = ~_T_1159; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16812:6]
  wire  _T_1162 = _T_1110 & _T_1121; // @[Monitor.scala 551:20 freechips.rocketchip.system.LitexConfig.fir 16819:4]
  reg [18:0] inflight; // @[Monitor.scala 613:27 freechips.rocketchip.system.LitexConfig.fir 16828:4]
  reg [75:0] inflight_opcodes; // @[Monitor.scala 615:35 freechips.rocketchip.system.LitexConfig.fir 16829:4]
  reg [151:0] inflight_sizes; // @[Monitor.scala 617:33 freechips.rocketchip.system.LitexConfig.fir 16830:4]
  reg [8:0] _T_1172; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 16840:4]
  wire [8:0] _T_1174 = _T_1172 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 16842:4]
  wire  a_first = _T_1172 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 16843:4]
  reg [8:0] _T_1190; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 16862:4]
  wire [8:0] _T_1192 = _T_1190 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 16864:4]
  wire  d_first = _T_1190 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 16865:4]
  wire [6:0] _GEN_72 = {io_in_d_bits_source, 2'h0}; // @[Monitor.scala 636:69 freechips.rocketchip.system.LitexConfig.fir 16886:4]
  wire [7:0] _T_1200 = {{1'd0}, _GEN_72}; // @[Monitor.scala 636:69 freechips.rocketchip.system.LitexConfig.fir 16886:4]
  wire [75:0] _T_1201 = inflight_opcodes >> _T_1200; // @[Monitor.scala 636:44 freechips.rocketchip.system.LitexConfig.fir 16887:4]
  wire [15:0] _T_1205 = 16'h10 - 16'h1; // @[Monitor.scala 611:57 freechips.rocketchip.system.LitexConfig.fir 16891:4]
  wire [75:0] _GEN_73 = {{60'd0}, _T_1205}; // @[Monitor.scala 636:97 freechips.rocketchip.system.LitexConfig.fir 16892:4]
  wire [75:0] _T_1206 = _T_1201 & _GEN_73; // @[Monitor.scala 636:97 freechips.rocketchip.system.LitexConfig.fir 16892:4]
  wire [75:0] _T_1207 = {{1'd0}, _T_1206[75:1]}; // @[Monitor.scala 636:152 freechips.rocketchip.system.LitexConfig.fir 16893:4]
  wire [7:0] _T_1208 = {io_in_d_bits_source, 3'h0}; // @[Monitor.scala 640:65 freechips.rocketchip.system.LitexConfig.fir 16897:4]
  wire [151:0] _T_1209 = inflight_sizes >> _T_1208; // @[Monitor.scala 640:40 freechips.rocketchip.system.LitexConfig.fir 16898:4]
  wire [15:0] _T_1213 = 16'h100 - 16'h1; // @[Monitor.scala 611:57 freechips.rocketchip.system.LitexConfig.fir 16902:4]
  wire [151:0] _GEN_75 = {{136'd0}, _T_1213}; // @[Monitor.scala 640:91 freechips.rocketchip.system.LitexConfig.fir 16903:4]
  wire [151:0] _T_1214 = _T_1209 & _GEN_75; // @[Monitor.scala 640:91 freechips.rocketchip.system.LitexConfig.fir 16903:4]
  wire [151:0] _T_1215 = {{1'd0}, _T_1214[151:1]}; // @[Monitor.scala 640:144 freechips.rocketchip.system.LitexConfig.fir 16904:4]
  wire  _T_1218 = io_in_a_valid & a_first; // @[Monitor.scala 650:26 freechips.rocketchip.system.LitexConfig.fir 16928:4]
  wire [31:0] _T_1220 = 32'h1 << io_in_a_bits_source; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 16931:6]
  wire [31:0] _GEN_15 = _T_1218 ? _T_1220 : 32'h0; // @[Monitor.scala 650:71 freechips.rocketchip.system.LitexConfig.fir 16930:4]
  wire  _T_1222 = _T_1061 & a_first; // @[Monitor.scala 654:27 freechips.rocketchip.system.LitexConfig.fir 16935:4]
  wire [3:0] _T_1225 = {io_in_a_bits_opcode, 1'h0}; // @[Monitor.scala 656:53 freechips.rocketchip.system.LitexConfig.fir 16940:6]
  wire [3:0] _T_1226 = _T_1225 | 4'h1; // @[Monitor.scala 656:61 freechips.rocketchip.system.LitexConfig.fir 16941:6]
  wire [4:0] _T_1227 = {io_in_a_bits_size, 1'h0}; // @[Monitor.scala 657:51 freechips.rocketchip.system.LitexConfig.fir 16943:6]
  wire [4:0] _T_1228 = _T_1227 | 5'h1; // @[Monitor.scala 657:59 freechips.rocketchip.system.LitexConfig.fir 16944:6]
  wire [6:0] _GEN_77 = {io_in_a_bits_source, 2'h0}; // @[Monitor.scala 658:79 freechips.rocketchip.system.LitexConfig.fir 16946:6]
  wire [7:0] _T_1229 = {{1'd0}, _GEN_77}; // @[Monitor.scala 658:79 freechips.rocketchip.system.LitexConfig.fir 16946:6]
  wire [3:0] a_opcodes_set_interm = _T_1222 ? _T_1226 : 4'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 16937:4]
  wire [258:0] _GEN_78 = {{255'd0}, a_opcodes_set_interm}; // @[Monitor.scala 658:54 freechips.rocketchip.system.LitexConfig.fir 16947:6]
  wire [258:0] _T_1230 = _GEN_78 << _T_1229; // @[Monitor.scala 658:54 freechips.rocketchip.system.LitexConfig.fir 16947:6]
  wire [7:0] _T_1231 = {io_in_a_bits_source, 3'h0}; // @[Monitor.scala 659:77 freechips.rocketchip.system.LitexConfig.fir 16949:6]
  wire [4:0] a_sizes_set_interm = _T_1222 ? _T_1228 : 5'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 16937:4]
  wire [259:0] _GEN_79 = {{255'd0}, a_sizes_set_interm}; // @[Monitor.scala 659:52 freechips.rocketchip.system.LitexConfig.fir 16950:6]
  wire [259:0] _T_1232 = _GEN_79 << _T_1231; // @[Monitor.scala 659:52 freechips.rocketchip.system.LitexConfig.fir 16950:6]
  wire [18:0] _T_1233 = inflight >> io_in_a_bits_source; // @[Monitor.scala 660:26 freechips.rocketchip.system.LitexConfig.fir 16952:6]
  wire  _T_1235 = ~_T_1233[0]; // @[Monitor.scala 660:17 freechips.rocketchip.system.LitexConfig.fir 16954:6]
  wire  _T_1237 = _T_1235 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16956:6]
  wire  _T_1238 = ~_T_1237; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16957:6]
  wire [31:0] _GEN_16 = _T_1222 ? _T_1220 : 32'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 16937:4]
  wire [258:0] _GEN_19 = _T_1222 ? _T_1230 : 259'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 16937:4]
  wire [259:0] _GEN_20 = _T_1222 ? _T_1232 : 260'h0; // @[Monitor.scala 654:72 freechips.rocketchip.system.LitexConfig.fir 16937:4]
  wire  _T_1240 = io_in_d_valid & d_first; // @[Monitor.scala 673:26 freechips.rocketchip.system.LitexConfig.fir 16972:4]
  wire  _T_1242 = ~_T_917; // @[Monitor.scala 673:74 freechips.rocketchip.system.LitexConfig.fir 16974:4]
  wire  _T_1243 = _T_1240 & _T_1242; // @[Monitor.scala 673:71 freechips.rocketchip.system.LitexConfig.fir 16975:4]
  wire [31:0] _T_1244 = 32'h1 << io_in_d_bits_source; // @[OneHot.scala 58:35 freechips.rocketchip.system.LitexConfig.fir 16977:6]
  wire [31:0] _GEN_21 = _T_1243 ? _T_1244 : 32'h0; // @[Monitor.scala 673:90 freechips.rocketchip.system.LitexConfig.fir 16976:4]
  wire  _T_1246 = _T_1110 & d_first; // @[Monitor.scala 677:27 freechips.rocketchip.system.LitexConfig.fir 16981:4]
  wire  _T_1249 = _T_1246 & _T_1242; // @[Monitor.scala 677:72 freechips.rocketchip.system.LitexConfig.fir 16984:4]
  wire [270:0] _GEN_81 = {{255'd0}, _T_1205}; // @[Monitor.scala 679:76 freechips.rocketchip.system.LitexConfig.fir 16993:6]
  wire [270:0] _T_1256 = _GEN_81 << _T_1200; // @[Monitor.scala 679:76 freechips.rocketchip.system.LitexConfig.fir 16993:6]
  wire [270:0] _GEN_82 = {{255'd0}, _T_1213}; // @[Monitor.scala 680:74 freechips.rocketchip.system.LitexConfig.fir 17000:6]
  wire [270:0] _T_1262 = _GEN_82 << _T_1208; // @[Monitor.scala 680:74 freechips.rocketchip.system.LitexConfig.fir 17000:6]
  wire [31:0] _GEN_22 = _T_1249 ? _T_1244 : 32'h0; // @[Monitor.scala 677:91 freechips.rocketchip.system.LitexConfig.fir 16985:4]
  wire [270:0] _GEN_23 = _T_1249 ? _T_1256 : 271'h0; // @[Monitor.scala 677:91 freechips.rocketchip.system.LitexConfig.fir 16985:4]
  wire [270:0] _GEN_24 = _T_1249 ? _T_1262 : 271'h0; // @[Monitor.scala 677:91 freechips.rocketchip.system.LitexConfig.fir 16985:4]
  wire  _T_1269 = io_in_a_bits_source == io_in_d_bits_source; // @[Monitor.scala 683:113 freechips.rocketchip.system.LitexConfig.fir 17010:6]
  wire  _T_1270 = _T_1218 & _T_1269; // @[Monitor.scala 683:88 freechips.rocketchip.system.LitexConfig.fir 17011:6]
  wire [18:0] _T_1271 = inflight >> io_in_d_bits_source; // @[Monitor.scala 684:25 freechips.rocketchip.system.LitexConfig.fir 17012:6]
  wire  _T_1273 = _T_1271[0] | _T_1270; // @[Monitor.scala 684:49 freechips.rocketchip.system.LitexConfig.fir 17014:6]
  wire  _T_1275 = _T_1273 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17016:6]
  wire  _T_1276 = ~_T_1275; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17017:6]
  wire [2:0] _GEN_27 = 3'h2 == io_in_a_bits_opcode ? 3'h1 : 3'h0; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 17023:8]
  wire [2:0] _GEN_28 = 3'h3 == io_in_a_bits_opcode ? 3'h1 : _GEN_27; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 17023:8]
  wire [2:0] _GEN_29 = 3'h4 == io_in_a_bits_opcode ? 3'h1 : _GEN_28; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 17023:8]
  wire [2:0] _GEN_30 = 3'h5 == io_in_a_bits_opcode ? 3'h2 : _GEN_29; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 17023:8]
  wire [2:0] _GEN_31 = 3'h6 == io_in_a_bits_opcode ? 3'h4 : _GEN_30; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 17023:8]
  wire [2:0] _GEN_32 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_31; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 17023:8]
  wire  _T_1277 = io_in_d_bits_opcode == _GEN_32; // @[Monitor.scala 687:38 freechips.rocketchip.system.LitexConfig.fir 17023:8]
  wire [2:0] _GEN_39 = 3'h6 == io_in_a_bits_opcode ? 3'h5 : _GEN_30; // @[Monitor.scala 688:39 freechips.rocketchip.system.LitexConfig.fir 17024:8]
  wire [2:0] _GEN_40 = 3'h7 == io_in_a_bits_opcode ? 3'h4 : _GEN_39; // @[Monitor.scala 688:39 freechips.rocketchip.system.LitexConfig.fir 17024:8]
  wire  _T_1278 = io_in_d_bits_opcode == _GEN_40; // @[Monitor.scala 688:39 freechips.rocketchip.system.LitexConfig.fir 17024:8]
  wire  _T_1279 = _T_1277 | _T_1278; // @[Monitor.scala 687:77 freechips.rocketchip.system.LitexConfig.fir 17025:8]
  wire  _T_1281 = _T_1279 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17027:8]
  wire  _T_1282 = ~_T_1281; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17028:8]
  wire  _T_1283 = io_in_a_bits_size == io_in_d_bits_size; // @[Monitor.scala 689:36 freechips.rocketchip.system.LitexConfig.fir 17033:8]
  wire  _T_1285 = _T_1283 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17035:8]
  wire  _T_1286 = ~_T_1285; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17036:8]
  wire [3:0] a_opcode_lookup = _T_1207[3:0]; // @[freechips.rocketchip.system.LitexConfig.fir 16884:4 freechips.rocketchip.system.LitexConfig.fir 16885:4 Monitor.scala 636:21 freechips.rocketchip.system.LitexConfig.fir 16894:4]
  wire [2:0] _GEN_43 = 3'h2 == a_opcode_lookup[2:0] ? 3'h1 : 3'h0; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 17044:8]
  wire [2:0] _GEN_44 = 3'h3 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_43; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 17044:8]
  wire [2:0] _GEN_45 = 3'h4 == a_opcode_lookup[2:0] ? 3'h1 : _GEN_44; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 17044:8]
  wire [2:0] _GEN_46 = 3'h5 == a_opcode_lookup[2:0] ? 3'h2 : _GEN_45; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 17044:8]
  wire [2:0] _GEN_47 = 3'h6 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_46; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 17044:8]
  wire [2:0] _GEN_48 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_47; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 17044:8]
  wire  _T_1288 = io_in_d_bits_opcode == _GEN_48; // @[Monitor.scala 691:38 freechips.rocketchip.system.LitexConfig.fir 17044:8]
  wire [2:0] _GEN_55 = 3'h6 == a_opcode_lookup[2:0] ? 3'h5 : _GEN_46; // @[Monitor.scala 692:38 freechips.rocketchip.system.LitexConfig.fir 17046:8]
  wire [2:0] _GEN_56 = 3'h7 == a_opcode_lookup[2:0] ? 3'h4 : _GEN_55; // @[Monitor.scala 692:38 freechips.rocketchip.system.LitexConfig.fir 17046:8]
  wire  _T_1290 = io_in_d_bits_opcode == _GEN_56; // @[Monitor.scala 692:38 freechips.rocketchip.system.LitexConfig.fir 17046:8]
  wire  _T_1291 = _T_1288 | _T_1290; // @[Monitor.scala 691:72 freechips.rocketchip.system.LitexConfig.fir 17047:8]
  wire  _T_1293 = _T_1291 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17049:8]
  wire  _T_1294 = ~_T_1293; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17050:8]
  wire [7:0] a_size_lookup = _T_1215[7:0]; // @[freechips.rocketchip.system.LitexConfig.fir 16895:4 freechips.rocketchip.system.LitexConfig.fir 16896:4 Monitor.scala 640:19 freechips.rocketchip.system.LitexConfig.fir 16905:4]
  wire [7:0] _GEN_83 = {{4'd0}, io_in_d_bits_size}; // @[Monitor.scala 693:36 freechips.rocketchip.system.LitexConfig.fir 17055:8]
  wire  _T_1295 = _GEN_83 == a_size_lookup; // @[Monitor.scala 693:36 freechips.rocketchip.system.LitexConfig.fir 17055:8]
  wire  _T_1297 = _T_1295 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17057:8]
  wire  _T_1298 = ~_T_1297; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17058:8]
  wire  _T_1300 = _T_1240 & a_first; // @[Monitor.scala 696:36 freechips.rocketchip.system.LitexConfig.fir 17066:4]
  wire  _T_1301 = _T_1300 & io_in_a_valid; // @[Monitor.scala 696:47 freechips.rocketchip.system.LitexConfig.fir 17067:4]
  wire  _T_1303 = _T_1301 & _T_1269; // @[Monitor.scala 696:65 freechips.rocketchip.system.LitexConfig.fir 17069:4]
  wire  _T_1305 = _T_1303 & _T_1242; // @[Monitor.scala 696:116 freechips.rocketchip.system.LitexConfig.fir 17071:4]
  wire  _T_1306 = ~io_in_d_ready; // @[Monitor.scala 697:15 freechips.rocketchip.system.LitexConfig.fir 17073:6]
  wire  _T_1307 = _T_1306 | io_in_a_ready; // @[Monitor.scala 697:32 freechips.rocketchip.system.LitexConfig.fir 17074:6]
  wire  _T_1309 = _T_1307 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17076:6]
  wire  _T_1310 = ~_T_1309; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17077:6]
  wire [18:0] a_set_wo_ready = _GEN_15[18:0]; // @[freechips.rocketchip.system.LitexConfig.fir 16878:4 freechips.rocketchip.system.LitexConfig.fir 16879:4 Monitor.scala 651:22 freechips.rocketchip.system.LitexConfig.fir 16932:6]
  wire [18:0] d_clr_wo_ready = _GEN_21[18:0]; // @[freechips.rocketchip.system.LitexConfig.fir 16965:4 freechips.rocketchip.system.LitexConfig.fir 16966:4 Monitor.scala 674:22 freechips.rocketchip.system.LitexConfig.fir 16978:6]
  wire  _T_1311 = a_set_wo_ready != d_clr_wo_ready; // @[Monitor.scala 701:29 freechips.rocketchip.system.LitexConfig.fir 17083:4]
  wire  _T_1312 = |a_set_wo_ready; // @[Monitor.scala 701:67 freechips.rocketchip.system.LitexConfig.fir 17084:4]
  wire  _T_1313 = ~_T_1312; // @[Monitor.scala 701:51 freechips.rocketchip.system.LitexConfig.fir 17085:4]
  wire  _T_1314 = _T_1311 | _T_1313; // @[Monitor.scala 701:48 freechips.rocketchip.system.LitexConfig.fir 17086:4]
  wire  _T_1316 = _T_1314 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17088:4]
  wire  _T_1317 = ~_T_1316; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17089:4]
  wire [18:0] a_set = _GEN_16[18:0]; // @[freechips.rocketchip.system.LitexConfig.fir 16876:4 freechips.rocketchip.system.LitexConfig.fir 16877:4 Monitor.scala 655:28 freechips.rocketchip.system.LitexConfig.fir 16939:6]
  wire [18:0] _T_1318 = inflight | a_set; // @[Monitor.scala 704:27 freechips.rocketchip.system.LitexConfig.fir 17094:4]
  wire [18:0] d_clr = _GEN_22[18:0]; // @[freechips.rocketchip.system.LitexConfig.fir 16963:4 freechips.rocketchip.system.LitexConfig.fir 16964:4 Monitor.scala 678:21 freechips.rocketchip.system.LitexConfig.fir 16987:6]
  wire [18:0] _T_1319 = ~d_clr; // @[Monitor.scala 704:38 freechips.rocketchip.system.LitexConfig.fir 17095:4]
  wire [18:0] _T_1320 = _T_1318 & _T_1319; // @[Monitor.scala 704:36 freechips.rocketchip.system.LitexConfig.fir 17096:4]
  wire [75:0] a_opcodes_set = _GEN_19[75:0]; // @[freechips.rocketchip.system.LitexConfig.fir 16880:4 freechips.rocketchip.system.LitexConfig.fir 16881:4 Monitor.scala 658:28 freechips.rocketchip.system.LitexConfig.fir 16948:6]
  wire [75:0] _T_1321 = inflight_opcodes | a_opcodes_set; // @[Monitor.scala 705:43 freechips.rocketchip.system.LitexConfig.fir 17098:4]
  wire [75:0] d_opcodes_clr = _GEN_23[75:0]; // @[freechips.rocketchip.system.LitexConfig.fir 16967:4 freechips.rocketchip.system.LitexConfig.fir 16968:4 Monitor.scala 679:21 freechips.rocketchip.system.LitexConfig.fir 16994:6]
  wire [75:0] _T_1322 = ~d_opcodes_clr; // @[Monitor.scala 705:62 freechips.rocketchip.system.LitexConfig.fir 17099:4]
  wire [75:0] _T_1323 = _T_1321 & _T_1322; // @[Monitor.scala 705:60 freechips.rocketchip.system.LitexConfig.fir 17100:4]
  wire [151:0] a_sizes_set = _GEN_20[151:0]; // @[freechips.rocketchip.system.LitexConfig.fir 16882:4 freechips.rocketchip.system.LitexConfig.fir 16883:4 Monitor.scala 659:28 freechips.rocketchip.system.LitexConfig.fir 16951:6]
  wire [151:0] _T_1324 = inflight_sizes | a_sizes_set; // @[Monitor.scala 706:39 freechips.rocketchip.system.LitexConfig.fir 17102:4]
  wire [151:0] d_sizes_clr = _GEN_24[151:0]; // @[freechips.rocketchip.system.LitexConfig.fir 16969:4 freechips.rocketchip.system.LitexConfig.fir 16970:4 Monitor.scala 680:21 freechips.rocketchip.system.LitexConfig.fir 17001:6]
  wire [151:0] _T_1325 = ~d_sizes_clr; // @[Monitor.scala 706:56 freechips.rocketchip.system.LitexConfig.fir 17103:4]
  wire [151:0] _T_1326 = _T_1324 & _T_1325; // @[Monitor.scala 706:54 freechips.rocketchip.system.LitexConfig.fir 17104:4]
  reg [31:0] _T_1327; // @[Monitor.scala 708:27 freechips.rocketchip.system.LitexConfig.fir 17106:4]
  wire  _T_1328 = |inflight; // @[Monitor.scala 711:26 freechips.rocketchip.system.LitexConfig.fir 17109:4]
  wire  _T_1329 = ~_T_1328; // @[Monitor.scala 711:16 freechips.rocketchip.system.LitexConfig.fir 17110:4]
  wire  _T_1330 = plusarg_reader_out == 32'h0; // @[Monitor.scala 711:39 freechips.rocketchip.system.LitexConfig.fir 17111:4]
  wire  _T_1331 = _T_1329 | _T_1330; // @[Monitor.scala 711:30 freechips.rocketchip.system.LitexConfig.fir 17112:4]
  wire  _T_1332 = _T_1327 < plusarg_reader_out; // @[Monitor.scala 711:59 freechips.rocketchip.system.LitexConfig.fir 17113:4]
  wire  _T_1333 = _T_1331 | _T_1332; // @[Monitor.scala 711:47 freechips.rocketchip.system.LitexConfig.fir 17114:4]
  wire  _T_1335 = _T_1333 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 17116:4]
  wire  _T_1336 = ~_T_1335; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 17117:4]
  wire [31:0] _T_1338 = _T_1327 + 32'h1; // @[Monitor.scala 713:26 freechips.rocketchip.system.LitexConfig.fir 17123:4]
  wire  _T_1341 = _T_1061 | _T_1110; // @[Monitor.scala 714:27 freechips.rocketchip.system.LitexConfig.fir 17127:4]
  reg [18:0] inflight_1; // @[Monitor.scala 725:35 freechips.rocketchip.system.LitexConfig.fir 17131:4]
  reg [151:0] inflight_sizes_1; // @[Monitor.scala 727:35 freechips.rocketchip.system.LitexConfig.fir 17133:4]
  reg [8:0] _T_1370; // @[Edges.scala 230:27 freechips.rocketchip.system.LitexConfig.fir 17168:4]
  wire [8:0] _T_1372 = _T_1370 - 9'h1; // @[Edges.scala 231:28 freechips.rocketchip.system.LitexConfig.fir 17170:4]
  wire  d_first_1 = _T_1370 == 9'h0; // @[Edges.scala 232:25 freechips.rocketchip.system.LitexConfig.fir 17171:4]
  wire [151:0] _T_1389 = inflight_sizes_1 >> _T_1208; // @[Monitor.scala 749:42 freechips.rocketchip.system.LitexConfig.fir 17204:4]
  wire [151:0] _T_1394 = _T_1389 & _GEN_75; // @[Monitor.scala 749:93 freechips.rocketchip.system.LitexConfig.fir 17209:4]
  wire [151:0] _T_1395 = {{1'd0}, _T_1394[151:1]}; // @[Monitor.scala 749:146 freechips.rocketchip.system.LitexConfig.fir 17210:4]
  wire  _T_1435 = io_in_d_valid & d_first_1; // @[Monitor.scala 781:26 freechips.rocketchip.system.LitexConfig.fir 17288:4]
  wire  _T_1437 = _T_1435 & _T_917; // @[Monitor.scala 781:71 freechips.rocketchip.system.LitexConfig.fir 17290:4]
  wire  _T_1440 = _T_1110 & d_first_1; // @[Monitor.scala 785:27 freechips.rocketchip.system.LitexConfig.fir 17296:4]
  wire  _T_1442 = _T_1440 & _T_917; // @[Monitor.scala 785:72 freechips.rocketchip.system.LitexConfig.fir 17298:4]
  wire [31:0] _GEN_67 = _T_1442 ? _T_1244 : 32'h0; // @[Monitor.scala 785:90 freechips.rocketchip.system.LitexConfig.fir 17299:4]
  wire [270:0] _GEN_69 = _T_1442 ? _T_1262 : 271'h0; // @[Monitor.scala 785:90 freechips.rocketchip.system.LitexConfig.fir 17299:4]
  wire [18:0] _T_1469 = inflight_1 >> io_in_d_bits_source; // @[Monitor.scala 793:25 freechips.rocketchip.system.LitexConfig.fir 17334:6]
  wire  _T_1473 = _T_1469[0] | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17338:6]
  wire  _T_1474 = ~_T_1473; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17339:6]
  wire [7:0] c_size_lookup = _T_1395[7:0]; // @[freechips.rocketchip.system.LitexConfig.fir 17192:4 freechips.rocketchip.system.LitexConfig.fir 17193:4 Monitor.scala 749:21 freechips.rocketchip.system.LitexConfig.fir 17211:4]
  wire  _T_1480 = _GEN_83 == c_size_lookup; // @[Monitor.scala 797:36 freechips.rocketchip.system.LitexConfig.fir 17357:8]
  wire  _T_1482 = _T_1480 | reset; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17359:8]
  wire  _T_1483 = ~_T_1482; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17360:8]
  wire [18:0] d_clr_1 = _GEN_67[18:0]; // @[freechips.rocketchip.system.LitexConfig.fir 17279:4 freechips.rocketchip.system.LitexConfig.fir 17280:4 Monitor.scala 786:21 freechips.rocketchip.system.LitexConfig.fir 17301:6]
  wire [18:0] _T_1504 = ~d_clr_1; // @[Monitor.scala 811:46 freechips.rocketchip.system.LitexConfig.fir 17402:4]
  wire [18:0] _T_1505 = inflight_1 & _T_1504; // @[Monitor.scala 811:44 freechips.rocketchip.system.LitexConfig.fir 17403:4]
  wire [151:0] d_sizes_clr_1 = _GEN_69[151:0]; // @[freechips.rocketchip.system.LitexConfig.fir 17285:4 freechips.rocketchip.system.LitexConfig.fir 17286:4 Monitor.scala 788:21 freechips.rocketchip.system.LitexConfig.fir 17315:6]
  wire [151:0] _T_1510 = ~d_sizes_clr_1; // @[Monitor.scala 813:58 freechips.rocketchip.system.LitexConfig.fir 17410:4]
  wire [151:0] _T_1511 = inflight_sizes_1 & _T_1510; // @[Monitor.scala 813:56 freechips.rocketchip.system.LitexConfig.fir 17411:4]
  reg [31:0] _T_1512; // @[Monitor.scala 815:27 freechips.rocketchip.system.LitexConfig.fir 17413:4]
  wire  _T_1513 = |inflight_1; // @[Monitor.scala 818:26 freechips.rocketchip.system.LitexConfig.fir 17416:4]
  wire  _T_1514 = ~_T_1513; // @[Monitor.scala 818:16 freechips.rocketchip.system.LitexConfig.fir 17417:4]
  wire  _T_1515 = plusarg_reader_1_out == 32'h0; // @[Monitor.scala 818:39 freechips.rocketchip.system.LitexConfig.fir 17418:4]
  wire  _T_1516 = _T_1514 | _T_1515; // @[Monitor.scala 818:30 freechips.rocketchip.system.LitexConfig.fir 17419:4]
  wire  _T_1517 = _T_1512 < plusarg_reader_1_out; // @[Monitor.scala 818:59 freechips.rocketchip.system.LitexConfig.fir 17420:4]
  wire  _T_1518 = _T_1516 | _T_1517; // @[Monitor.scala 818:47 freechips.rocketchip.system.LitexConfig.fir 17421:4]
  wire  _T_1520 = _T_1518 | reset; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 17423:4]
  wire  _T_1521 = ~_T_1520; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 17424:4]
  wire [31:0] _T_1523 = _T_1512 + 32'h1; // @[Monitor.scala 820:26 freechips.rocketchip.system.LitexConfig.fir 17430:4]
  wire  _GEN_93 = io_in_a_valid & _T_159; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15404:10]
  wire  _GEN_109 = io_in_a_valid & _T_269; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15555:10]
  wire  _GEN_127 = io_in_a_valid & _T_383; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15705:10]
  wire  _GEN_141 = io_in_a_valid & _T_476; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15871:10]
  wire  _GEN_151 = io_in_a_valid & _T_565; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15982:10]
  wire  _GEN_161 = io_in_a_valid & _T_656; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16078:10]
  wire  _GEN_171 = io_in_a_valid & _T_728; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16172:10]
  wire  _GEN_181 = io_in_a_valid & _T_800; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16278:10]
  wire  _GEN_193 = io_in_d_valid & _T_917; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16367:10]
  wire  _GEN_203 = io_in_d_valid & _T_937; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16409:10]
  wire  _GEN_215 = io_in_d_valid & _T_965; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16467:10]
  wire  _GEN_227 = io_in_d_valid & _T_994; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16526:10]
  wire  _GEN_233 = io_in_d_valid & _T_1011; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16561:10]
  wire  _GEN_239 = io_in_d_valid & _T_1029; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 16597:10]
  wire  _GEN_245 = _T_1243 & _T_1270; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17030:10]
  wire  _GEN_249 = ~_T_1270; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17052:10]
  wire  _GEN_250 = _T_1243 & _GEN_249; // @[Monitor.scala 51:11 freechips.rocketchip.system.LitexConfig.fir 17052:10]
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader ( // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 17107:4]
    .out(plusarg_reader_out)
  );
  plusarg_reader #(.FORMAT("tilelink_timeout=%d"), .DEFAULT(0), .WIDTH(32)) plusarg_reader_1 ( // @[PlusArg.scala 80:11 freechips.rocketchip.system.LitexConfig.fir 17414:4]
    .out(plusarg_reader_1_out)
  );
`ifdef RANDOMIZE_GARBAGE_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_INVALID_ASSIGN
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_REG_INIT
`define RANDOMIZE
`endif
`ifdef RANDOMIZE_MEM_INIT
`define RANDOMIZE
`endif
`ifndef RANDOM
`define RANDOM $random
`endif
`ifdef RANDOMIZE_MEM_INIT
  integer initvar;
`endif
`ifndef SYNTHESIS
`ifdef FIRRTL_BEFORE_INITIAL
`FIRRTL_BEFORE_INITIAL
`endif
initial begin
  `ifdef RANDOMIZE
    `ifdef INIT_RANDOM
      `INIT_RANDOM
    `endif
    `ifndef VERILATOR
      `ifdef RANDOMIZE_DELAY
        #`RANDOMIZE_DELAY begin end
      `else
        #0.002 begin end
      `endif
    `endif
`ifdef RANDOMIZE_REG_INIT
  _RAND_0 = {1{`RANDOM}};
  _T_1070 = _RAND_0[8:0];
  _RAND_1 = {1{`RANDOM}};
  _T_1081 = _RAND_1[2:0];
  _RAND_2 = {1{`RANDOM}};
  _T_1082 = _RAND_2[2:0];
  _RAND_3 = {1{`RANDOM}};
  _T_1083 = _RAND_3[3:0];
  _RAND_4 = {1{`RANDOM}};
  _T_1084 = _RAND_4[4:0];
  _RAND_5 = {1{`RANDOM}};
  _T_1085 = _RAND_5[27:0];
  _RAND_6 = {1{`RANDOM}};
  _T_1118 = _RAND_6[8:0];
  _RAND_7 = {1{`RANDOM}};
  _T_1129 = _RAND_7[2:0];
  _RAND_8 = {1{`RANDOM}};
  _T_1130 = _RAND_8[1:0];
  _RAND_9 = {1{`RANDOM}};
  _T_1131 = _RAND_9[3:0];
  _RAND_10 = {1{`RANDOM}};
  _T_1132 = _RAND_10[4:0];
  _RAND_11 = {1{`RANDOM}};
  _T_1133 = _RAND_11[0:0];
  _RAND_12 = {1{`RANDOM}};
  _T_1134 = _RAND_12[0:0];
  _RAND_13 = {1{`RANDOM}};
  inflight = _RAND_13[18:0];
  _RAND_14 = {3{`RANDOM}};
  inflight_opcodes = _RAND_14[75:0];
  _RAND_15 = {5{`RANDOM}};
  inflight_sizes = _RAND_15[151:0];
  _RAND_16 = {1{`RANDOM}};
  _T_1172 = _RAND_16[8:0];
  _RAND_17 = {1{`RANDOM}};
  _T_1190 = _RAND_17[8:0];
  _RAND_18 = {1{`RANDOM}};
  _T_1327 = _RAND_18[31:0];
  _RAND_19 = {1{`RANDOM}};
  inflight_1 = _RAND_19[18:0];
  _RAND_20 = {5{`RANDOM}};
  inflight_sizes_1 = _RAND_20[151:0];
  _RAND_21 = {1{`RANDOM}};
  _T_1370 = _RAND_21[8:0];
  _RAND_22 = {1{`RANDOM}};
  _T_1512 = _RAND_22[31:0];
`endif // RANDOMIZE_REG_INIT
  `endif // RANDOMIZE
end // initial
`ifdef FIRRTL_AFTER_INITIAL
`FIRRTL_AFTER_INITIAL
`endif
`endif // SYNTHESIS
  always @(posedge clock) begin
    if (reset) begin
      _T_1070 <= 9'h0;
    end else if (_T_1061) begin
      if (_T_1073) begin
        if (_T_1068) begin
          _T_1070 <= _T_31[11:3];
        end else begin
          _T_1070 <= 9'h0;
        end
      end else begin
        _T_1070 <= _T_1072;
      end
    end
    if (_T_1109) begin
      _T_1081 <= io_in_a_bits_opcode;
    end
    if (_T_1109) begin
      _T_1082 <= io_in_a_bits_param;
    end
    if (_T_1109) begin
      _T_1083 <= io_in_a_bits_size;
    end
    if (_T_1109) begin
      _T_1084 <= io_in_a_bits_source;
    end
    if (_T_1109) begin
      _T_1085 <= io_in_a_bits_address;
    end
    if (reset) begin
      _T_1118 <= 9'h0;
    end else if (_T_1110) begin
      if (_T_1121) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_1118 <= _T_1114[11:3];
        end else begin
          _T_1118 <= 9'h0;
        end
      end else begin
        _T_1118 <= _T_1120;
      end
    end
    if (_T_1162) begin
      _T_1129 <= io_in_d_bits_opcode;
    end
    if (_T_1162) begin
      _T_1130 <= io_in_d_bits_param;
    end
    if (_T_1162) begin
      _T_1131 <= io_in_d_bits_size;
    end
    if (_T_1162) begin
      _T_1132 <= io_in_d_bits_source;
    end
    if (_T_1162) begin
      _T_1133 <= io_in_d_bits_sink;
    end
    if (_T_1162) begin
      _T_1134 <= io_in_d_bits_denied;
    end
    if (reset) begin
      inflight <= 19'h0;
    end else begin
      inflight <= _T_1320;
    end
    if (reset) begin
      inflight_opcodes <= 76'h0;
    end else begin
      inflight_opcodes <= _T_1323;
    end
    if (reset) begin
      inflight_sizes <= 152'h0;
    end else begin
      inflight_sizes <= _T_1326;
    end
    if (reset) begin
      _T_1172 <= 9'h0;
    end else if (_T_1061) begin
      if (a_first) begin
        if (_T_1068) begin
          _T_1172 <= _T_31[11:3];
        end else begin
          _T_1172 <= 9'h0;
        end
      end else begin
        _T_1172 <= _T_1174;
      end
    end
    if (reset) begin
      _T_1190 <= 9'h0;
    end else if (_T_1110) begin
      if (d_first) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_1190 <= _T_1114[11:3];
        end else begin
          _T_1190 <= 9'h0;
        end
      end else begin
        _T_1190 <= _T_1192;
      end
    end
    if (reset) begin
      _T_1327 <= 32'h0;
    end else if (_T_1341) begin
      _T_1327 <= 32'h0;
    end else begin
      _T_1327 <= _T_1338;
    end
    if (reset) begin
      inflight_1 <= 19'h0;
    end else begin
      inflight_1 <= _T_1505;
    end
    if (reset) begin
      inflight_sizes_1 <= 152'h0;
    end else begin
      inflight_sizes_1 <= _T_1511;
    end
    if (reset) begin
      _T_1370 <= 9'h0;
    end else if (_T_1110) begin
      if (d_first_1) begin
        if (io_in_d_bits_opcode[0]) begin
          _T_1370 <= _T_1114[11:3];
        end else begin
          _T_1370 <= 9'h0;
        end
      end else begin
        _T_1370 <= _T_1372;
      end
    end
    if (reset) begin
      _T_1512 <= 32'h0;
    end else if (_T_1110) begin
      _T_1512 <= 32'h0;
    end else begin
      _T_1512 <= _T_1523;
    end
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_199) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquireBlock type which is unexpected using diplomatic parameters (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15404:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_199) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15405:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_245) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquireBlock from a client which does not support Probe (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15461:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_245) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15462:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_248) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15468:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_248) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15469:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_252) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock smaller than a beat (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15476:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_252) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15477:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_255) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15483:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_255) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15484:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_259) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock carries invalid grow param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15491:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_259) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15492:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_264) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock contains invalid mask (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15500:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_264) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15501:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_93 & _T_268) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquireBlock is corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15508:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_93 & _T_268) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15509:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_199) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquirePerm type which is unexpected using diplomatic parameters (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15555:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_199) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15556:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_245) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries AcquirePerm from a client which does not support Probe (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15612:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_245) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15613:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_248) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15619:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_248) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15620:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_252) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm smaller than a beat (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15627:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_252) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15628:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_255) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15634:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_255) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15635:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_259) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm carries invalid grow param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15642:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_259) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15643:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_373) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm requests NtoB (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15650:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_373) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15651:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_264) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm contains invalid mask (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15659:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_264) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15660:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_109 & _T_268) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel AcquirePerm is corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15667:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_109 & _T_268) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15668:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_414) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Get type which master claims it can't emit (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15705:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_414) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15706:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_457) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Get type which slave claims it can't support (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15752:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_457) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15753:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_248) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15759:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_248) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15760:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_255) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15766:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_255) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15767:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_467) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get carries invalid param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15774:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_467) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15775:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_471) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get contains invalid mask (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15782:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_471) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15783:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_127 & _T_268) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Get is corrupt (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15790:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_127 & _T_268) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15791:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_141 & _T_550) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries PutFull type which is unexpected using diplomatic parameters (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15871:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_141 & _T_550) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15872:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_141 & _T_248) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15878:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_141 & _T_248) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15879:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_141 & _T_255) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15885:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_141 & _T_255) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15886:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_141 & _T_467) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull carries invalid param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15893:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_141 & _T_467) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15894:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_141 & _T_471) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutFull contains invalid mask (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15901:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_141 & _T_471) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15902:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_151 & _T_550) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries PutPartial type which is unexpected using diplomatic parameters (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15982:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_151 & _T_550) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15983:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_151 & _T_248) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15989:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_151 & _T_248) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15990:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_151 & _T_255) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15996:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_151 & _T_255) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 15997:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_151 & _T_467) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial carries invalid param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16004:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_151 & _T_467) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16005:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_151 & _T_655) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel PutPartial contains invalid mask (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16014:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_151 & _T_655) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16015:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_161 & _T_713) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Arithmetic type which is unexpected using diplomatic parameters (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16078:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_161 & _T_713) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16079:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_161 & _T_248) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16085:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_161 & _T_248) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16086:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_161 & _T_255) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16092:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_161 & _T_255) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16093:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_161 & _T_723) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic carries invalid opcode param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16100:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_161 & _T_723) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16101:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_161 & _T_471) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Arithmetic contains invalid mask (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16108:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_161 & _T_471) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16109:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_171 & _T_713) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Logical type which is unexpected using diplomatic parameters (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16172:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_171 & _T_713) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16173:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_171 & _T_248) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16179:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_171 & _T_248) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16180:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_171 & _T_255) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical address not aligned to size (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16186:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_171 & _T_255) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16187:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_171 & _T_795) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical carries invalid opcode param (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16194:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_171 & _T_795) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16195:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_171 & _T_471) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Logical contains invalid mask (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16202:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_171 & _T_471) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16203:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_181 & _T_869) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel carries Hint type which is unexpected using diplomatic parameters (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16278:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef STOP_COND
      if (`STOP_COND) begin
    `endif
        if (_GEN_181 & _T_869) begin
          $fatal; // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16279:10]
        end
    `ifdef STOP_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifndef SYNTHESIS
    `ifdef PRINTF_COND
      if (`PRINTF_COND) begin
    `endif
        if (_GEN_181 & _T_248) begin
          $fwrite(32'h80000002,"Assertion failed: 'A' channel Hint carries invalid source ID (connected at BusWrapper.scala:189:97)\n    at Monitor.scala:44 assert(cond, message)\n"); // @[Monitor.scala 44:11 freechips.rocketchip.system.LitexConfig.fir 16285:10]
        end
    `ifdef PRINTF_COND
      end
    `endif
    `endif // SYNTHESIS
    `ifnde