"""
This type stub file was generated by pyright.
"""

import typing as t
from starlette.requests import Request as StarletteRequest
from werkzeug import Request as WerkzeugRequest

"""
This module defines interfaces for requests and responses used in Connexion for authentication,
validation, serialization, etc.
"""
class _RequestInterface:
    @property
    def context(self) -> t.Dict[str, t.Any]:
        """The connexion context of the current request cycle."""
        ...
    
    @property
    def content_type(self) -> str:
        """The content type included in the request headers."""
        ...
    
    @property
    def mimetype(self) -> str:
        """The content type included in the request headers stripped from any optional character
        set encoding"""
        ...
    
    @property
    def path_params(self) -> t.Dict[str, t.Any]:
        """Path parameters exposed as a dictionary"""
        ...
    
    @property
    def query_params(self) -> t.Dict[str, t.Any]:
        """Query parameters exposed as a dictionary"""
        ...
    
    def form(self) -> t.Union[t.Dict[str, t.Any], t.Awaitable[t.Dict[str, t.Any]]]:
        """Form data, including files."""
        ...
    
    def files(self) -> t.Dict[str, t.Any]:
        """Files included in the request."""
        ...
    
    def json(self) -> dict:
        """Json data included in the request."""
        ...
    
    def get_body(self) -> t.Any:
        """Get body based on the content type. This returns json data for json content types,
        form data for form content types, and bytes for all others. If the bytes data is empty,
        :code:`None` is returned instead."""
        ...
    


class WSGIRequest(_RequestInterface):
    def __init__(self, werkzeug_request: WerkzeugRequest, uri_parser=..., view_args=...) -> None:
        ...
    
    @property
    def context(self): # -> Any:
        ...
    
    @property
    def content_type(self) -> str:
        ...
    
    @property
    def mimetype(self) -> str:
        ...
    
    @property
    def path_params(self):
        ...
    
    @property
    def query_params(self):
        ...
    
    def form(self):
        ...
    
    def files(self): # -> dict[str, list[FileStorage]]:
        ...
    
    def json(self): # -> Any:
        ...
    
    def get_body(self): # -> Any | None:
        ...
    
    def __getattr__(self, item): # -> Any:
        ...
    


class ConnexionRequest(_RequestInterface):
    """
    Implementation of the Connexion :code:`_RequestInterface` representing an ASGI request.

    .. attribute:: _starlette_request
        :noindex:

        This class wraps a Starlette `Request <https://www.starlette.io/requests/#request>`_,
        and provides access to its attributes by proxy.

    """
    def __init__(self, *args, uri_parser=..., **kwargs) -> None:
        ...
    
    @classmethod
    def from_starlette_request(cls, request: StarletteRequest, uri_parser=...) -> ConnexionRequest:
        ...
    
    @property
    def context(self): # -> Any:
        ...
    
    @property
    def content_type(self): # -> Any:
        ...
    
    @property
    def mimetype(self): # -> str:
        ...
    
    @property
    def path_params(self) -> t.Dict[str, t.Any]:
        ...
    
    @property
    def query_params(self):
        ...
    
    async def form(self): # -> None:
        ...
    
    async def files(self): # -> defaultdict[Any, list[Any]] | None:
        ...
    
    async def json(self): # -> Any | None:
        ...
    
    async def get_body(self): # -> Any | None:
        ...
    
    def __getattr__(self, item): # -> Any | None:
        ...
    


class ConnexionResponse:
    """Connexion interface for a response."""
    def __init__(self, status_code=..., mimetype=..., content_type=..., body=..., headers=..., is_streamed=...) -> None:
        ...
    


