# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class V2LicenseIMEI(object):

    """Implementation of the 'V2LicenseIMEI' model.

    IMEIs of the devices to assign or remove licenses.

    Attributes:
        account_name (str): Account name.
        device_list (List[str]): Device IMEI list.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "device_list": 'deviceList',
        "account_name": 'accountName'
    }

    _optionals = [
        'account_name',
    ]

    def __init__(self,
                 device_list=None,
                 account_name=APIHelper.SKIP):
        """Constructor for the V2LicenseIMEI class"""

        # Initialize members of the class
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        self.device_list = device_list 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        device_list = dictionary.get("deviceList") if dictionary.get("deviceList") else None
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        # Return an object of this model
        return cls(device_list,
                   account_name)
