# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.firmware_upgrade import FirmwareUpgrade


class UpgradeListQueryResult(object):

    """Implementation of the 'UpgradeListQueryResult' model.

    Upgrade information.

    Attributes:
        has_more_flag (bool): True if there are more devices to retrieve.
        last_seen_upgrade_id (int): If hasMoreData=true, the startIndex to use
            for the next request. 0 if hasMoreData=false.
        report_list (List[FirmwareUpgrade]): Array of upgrade objects with the
            specified status.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "has_more_flag": 'hasMoreFlag',
        "last_seen_upgrade_id": 'lastSeenUpgradeId',
        "report_list": 'reportList'
    }

    _optionals = [
        'has_more_flag',
        'last_seen_upgrade_id',
        'report_list',
    ]

    _nullables = [
        'report_list',
    ]

    def __init__(self,
                 has_more_flag=APIHelper.SKIP,
                 last_seen_upgrade_id=APIHelper.SKIP,
                 report_list=APIHelper.SKIP):
        """Constructor for the UpgradeListQueryResult class"""

        # Initialize members of the class
        if has_more_flag is not APIHelper.SKIP:
            self.has_more_flag = has_more_flag 
        if last_seen_upgrade_id is not APIHelper.SKIP:
            self.last_seen_upgrade_id = last_seen_upgrade_id 
        if report_list is not APIHelper.SKIP:
            self.report_list = report_list 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        has_more_flag = dictionary.get("hasMoreFlag") if "hasMoreFlag" in dictionary.keys() else APIHelper.SKIP
        last_seen_upgrade_id = dictionary.get("lastSeenUpgradeId") if dictionary.get("lastSeenUpgradeId") else APIHelper.SKIP
        if 'reportList' in dictionary.keys():
            report_list = [FirmwareUpgrade.from_dictionary(x) for x in dictionary.get('reportList')] if dictionary.get('reportList') else None
        else:
            report_list = APIHelper.SKIP
        # Return an object of this model
        return cls(has_more_flag,
                   last_seen_upgrade_id,
                   report_list)
