# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.custom_fields import CustomFields


class ServicePlan(object):

    """Implementation of the 'ServicePlan' model.

    Details of the service plan.

    Attributes:
        carrier_service_plan_code (str): The code that is used by the carrier
            for the service plan.
        code (str): The code of the service plan, which may not be the same as
            the name.
        extended_attributes (List[CustomFields]): Any extended attributes for
            the service plan, as Key and Value pairs.
        name (str): The name of the service plan.
        size_kb (long|int): The size of the service plan in kilobytes.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "carrier_service_plan_code": 'carrierServicePlanCode',
        "code": 'code',
        "extended_attributes": 'extendedAttributes',
        "name": 'name',
        "size_kb": 'sizeKb'
    }

    _optionals = [
        'carrier_service_plan_code',
        'code',
        'extended_attributes',
        'name',
        'size_kb',
    ]

    def __init__(self,
                 carrier_service_plan_code=APIHelper.SKIP,
                 code=APIHelper.SKIP,
                 extended_attributes=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 size_kb=APIHelper.SKIP):
        """Constructor for the ServicePlan class"""

        # Initialize members of the class
        if carrier_service_plan_code is not APIHelper.SKIP:
            self.carrier_service_plan_code = carrier_service_plan_code 
        if code is not APIHelper.SKIP:
            self.code = code 
        if extended_attributes is not APIHelper.SKIP:
            self.extended_attributes = extended_attributes 
        if name is not APIHelper.SKIP:
            self.name = name 
        if size_kb is not APIHelper.SKIP:
            self.size_kb = size_kb 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        carrier_service_plan_code = dictionary.get("carrierServicePlanCode") if dictionary.get("carrierServicePlanCode") else APIHelper.SKIP
        code = dictionary.get("code") if dictionary.get("code") else APIHelper.SKIP
        extended_attributes = None
        if dictionary.get('extendedAttributes') is not None:
            extended_attributes = [CustomFields.from_dictionary(x) for x in dictionary.get('extendedAttributes')]
        else:
            extended_attributes = APIHelper.SKIP
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        size_kb = dictionary.get("sizeKb") if dictionary.get("sizeKb") else APIHelper.SKIP
        # Return an object of this model
        return cls(carrier_service_plan_code,
                   code,
                   extended_attributes,
                   name,
                   size_kb)
