# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.acceleration import Acceleration
from verizon.models.device_propertylocation import DevicePropertylocation


class SearchDeviceByPropertyFields(object):

    """Implementation of the 'SearchDeviceByPropertyFields' model.

    List of device sensors and their most recently reported values.

    Attributes:
        acceleration (Acceleration): TODO: type description here.
        battery (str): TODO: type description here.
        humidity (str): TODO: type description here.
        light (str): TODO: type description here.
        pressure (str): TODO: type description here.
        signal_strength (str): TODO: type description here.
        temperature (str): TODO: type description here.
        device_propertylocation (DevicePropertylocation): TODO: type
            description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "acceleration": 'acceleration',
        "battery": 'battery',
        "humidity": 'humidity',
        "light": 'light',
        "pressure": 'pressure',
        "signal_strength": 'signalStrength',
        "temperature": 'temperature',
        "device_propertylocation": 'DevicePropertylocation'
    }

    _optionals = [
        'acceleration',
        'battery',
        'humidity',
        'light',
        'pressure',
        'signal_strength',
        'temperature',
        'device_propertylocation',
    ]

    def __init__(self,
                 acceleration=APIHelper.SKIP,
                 battery=APIHelper.SKIP,
                 humidity=APIHelper.SKIP,
                 light=APIHelper.SKIP,
                 pressure=APIHelper.SKIP,
                 signal_strength=APIHelper.SKIP,
                 temperature=APIHelper.SKIP,
                 device_propertylocation=APIHelper.SKIP):
        """Constructor for the SearchDeviceByPropertyFields class"""

        # Initialize members of the class
        if acceleration is not APIHelper.SKIP:
            self.acceleration = acceleration 
        if battery is not APIHelper.SKIP:
            self.battery = battery 
        if humidity is not APIHelper.SKIP:
            self.humidity = humidity 
        if light is not APIHelper.SKIP:
            self.light = light 
        if pressure is not APIHelper.SKIP:
            self.pressure = pressure 
        if signal_strength is not APIHelper.SKIP:
            self.signal_strength = signal_strength 
        if temperature is not APIHelper.SKIP:
            self.temperature = temperature 
        if device_propertylocation is not APIHelper.SKIP:
            self.device_propertylocation = device_propertylocation 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        acceleration = Acceleration.from_dictionary(dictionary.get('acceleration')) if 'acceleration' in dictionary.keys() else APIHelper.SKIP
        battery = dictionary.get("battery") if dictionary.get("battery") else APIHelper.SKIP
        humidity = dictionary.get("humidity") if dictionary.get("humidity") else APIHelper.SKIP
        light = dictionary.get("light") if dictionary.get("light") else APIHelper.SKIP
        pressure = dictionary.get("pressure") if dictionary.get("pressure") else APIHelper.SKIP
        signal_strength = dictionary.get("signalStrength") if dictionary.get("signalStrength") else APIHelper.SKIP
        temperature = dictionary.get("temperature") if dictionary.get("temperature") else APIHelper.SKIP
        device_propertylocation = DevicePropertylocation.from_dictionary(dictionary.get('DevicePropertylocation')) if 'DevicePropertylocation' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(acceleration,
                   battery,
                   humidity,
                   light,
                   pressure,
                   signal_strength,
                   temperature,
                   device_propertylocation)
