# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.account_device_list import AccountDeviceList


class RetrieveMonitorsRequest(object):

    """Implementation of the 'RetrieveMonitorsRequest' model.

    TODO: type model description here.

    Attributes:
        account_name (str): The name of a billing account.
        devices (List[AccountDeviceList]): The devices for which you want to
            restore service, specified by device identifier.
        monitor_type (str): The name of a billing account.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "devices": 'devices',
        "monitor_type": 'monitorType'
    }

    _optionals = [
        'monitor_type',
    ]

    def __init__(self,
                 account_name=None,
                 devices=None,
                 monitor_type=APIHelper.SKIP):
        """Constructor for the RetrieveMonitorsRequest class"""

        # Initialize members of the class
        self.account_name = account_name 
        self.devices = devices 
        if monitor_type is not APIHelper.SKIP:
            self.monitor_type = monitor_type 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        devices = None
        if dictionary.get('devices') is not None:
            devices = [AccountDeviceList.from_dictionary(x) for x in dictionary.get('devices')]
        monitor_type = dictionary.get("monitorType") if dictionary.get("monitorType") else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   devices,
                   monitor_type)
