# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.ready_sim_device_id import ReadySimDeviceId
from verizon.models.usage_history import UsageHistory


class ResponseToUsageQuery(object):

    """Implementation of the 'Response to Usage Query' model.

    TODO: type model description here.

    Attributes:
        hasmoredata (bool): TODO: type description here.
        device_id (ReadySimDeviceId): TODO: type description here.
        usage_history (List[UsageHistory]): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "hasmoredata": 'hasmoredata',
        "device_id": 'deviceId',
        "usage_history": 'usageHistory'
    }

    _optionals = [
        'hasmoredata',
        'device_id',
        'usage_history',
    ]

    def __init__(self,
                 hasmoredata=APIHelper.SKIP,
                 device_id=APIHelper.SKIP,
                 usage_history=APIHelper.SKIP):
        """Constructor for the ResponseToUsageQuery class"""

        # Initialize members of the class
        if hasmoredata is not APIHelper.SKIP:
            self.hasmoredata = hasmoredata 
        if device_id is not APIHelper.SKIP:
            self.device_id = device_id 
        if usage_history is not APIHelper.SKIP:
            self.usage_history = usage_history 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        hasmoredata = dictionary.get("hasmoredata") if "hasmoredata" in dictionary.keys() else APIHelper.SKIP
        device_id = ReadySimDeviceId.from_dictionary(dictionary.get('deviceId')) if 'deviceId' in dictionary.keys() else APIHelper.SKIP
        usage_history = None
        if dictionary.get('usageHistory') is not None:
            usage_history = [UsageHistory.from_dictionary(x) for x in dictionary.get('usageHistory')]
        else:
            usage_history = APIHelper.SKIP
        # Return an object of this model
        return cls(hasmoredata,
                   device_id,
                   usage_history)
