# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class ResourcesServiceEndpoint(object):

    """Implementation of the 'ResourcesServiceEndpoint' model.

    Service Endpoint path, address, and port.

    Attributes:
        uri (str): URI of Service Endpoint if available.
        fqdn (str): FQDN of Service Endpoint if available.
        i_pv_4_address (str): IPv4 Address of Service Endpoint if available.
        i_pv_6_address (str): IPv6 Address of Service Endpoint if available.
        port (int): Port information of Service Endpoint if IPv4 or IPv6 is
            mentioned.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "uri": 'URI',
        "fqdn": 'FQDN',
        "i_pv_4_address": 'IPv4Address',
        "i_pv_6_address": 'IPv6Address',
        "port": 'port'
    }

    _optionals = [
        'uri',
        'fqdn',
        'i_pv_4_address',
        'i_pv_6_address',
        'port',
    ]

    def __init__(self,
                 uri=APIHelper.SKIP,
                 fqdn=APIHelper.SKIP,
                 i_pv_4_address=APIHelper.SKIP,
                 i_pv_6_address=APIHelper.SKIP,
                 port=APIHelper.SKIP):
        """Constructor for the ResourcesServiceEndpoint class"""

        # Initialize members of the class
        if uri is not APIHelper.SKIP:
            self.uri = uri 
        if fqdn is not APIHelper.SKIP:
            self.fqdn = fqdn 
        if i_pv_4_address is not APIHelper.SKIP:
            self.i_pv_4_address = i_pv_4_address 
        if i_pv_6_address is not APIHelper.SKIP:
            self.i_pv_6_address = i_pv_6_address 
        if port is not APIHelper.SKIP:
            self.port = port 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        uri = dictionary.get("URI") if dictionary.get("URI") else APIHelper.SKIP
        fqdn = dictionary.get("FQDN") if dictionary.get("FQDN") else APIHelper.SKIP
        i_pv_4_address = dictionary.get("IPv4Address") if dictionary.get("IPv4Address") else APIHelper.SKIP
        i_pv_6_address = dictionary.get("IPv6Address") if dictionary.get("IPv6Address") else APIHelper.SKIP
        port = dictionary.get("port") if dictionary.get("port") else APIHelper.SKIP
        # Return an object of this model
        return cls(uri,
                   fqdn,
                   i_pv_4_address,
                   i_pv_6_address,
                   port)
