# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.flow_info import FlowInfo
from verizon.models.qos_device_id import QosDeviceId


class QosDeviceInfo(object):

    """Implementation of the 'QOSdeviceInfo' model.

    TODO: type model description here.

    Attributes:
        device_id (QosDeviceId): TODO: type description here.
        device_i_pv_6_addr (str): TODO: type description here.
        flow_info (List[FlowInfo]): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "device_id": 'deviceId',
        "flow_info": 'flowInfo',
        "device_i_pv_6_addr": 'deviceIPv6Addr'
    }

    _optionals = [
        'device_i_pv_6_addr',
    ]

    def __init__(self,
                 device_id=None,
                 flow_info=None,
                 device_i_pv_6_addr=APIHelper.SKIP):
        """Constructor for the QosDeviceInfo class"""

        # Initialize members of the class
        self.device_id = device_id 
        if device_i_pv_6_addr is not APIHelper.SKIP:
            self.device_i_pv_6_addr = device_i_pv_6_addr 
        self.flow_info = flow_info 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        device_id = QosDeviceId.from_dictionary(dictionary.get('deviceId')) if dictionary.get('deviceId') else None
        flow_info = None
        if dictionary.get('flowInfo') is not None:
            flow_info = [FlowInfo.from_dictionary(x) for x in dictionary.get('flowInfo')]
        device_i_pv_6_addr = dictionary.get("deviceIPv6Addr") if dictionary.get("deviceIPv6Addr") else APIHelper.SKIP
        # Return an object of this model
        return cls(device_id,
                   flow_info,
                   device_i_pv_6_addr)
