# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.models.address import Address
from verizon.models.customer_name import CustomerName


class PlaceOfUse(object):

    """Implementation of the 'PlaceOfUse' model.

    The customer name and the address of the device's primary place of use.
    Leave these fields empty to use the account profile address as the primary
    place of use. These values will be applied to all devices in the
    request.If the account is enabled for non-geographic MDNs and the device
    supports it, the primaryPlaceOfUse address will also be used to derive the
    MDN for the device.

    Attributes:
        address (Address): The customer address for the line's primary place
            of use, for line usage taxation.
        customer_name (CustomerName): The customer name to be used for line
            usage taxation.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "address": 'address',
        "customer_name": 'customerName'
    }

    def __init__(self,
                 address=None,
                 customer_name=None):
        """Constructor for the PlaceOfUse class"""

        # Initialize members of the class
        self.address = address 
        self.customer_name = customer_name 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        address = Address.from_dictionary(dictionary.get('address')) if dictionary.get('address') else None
        customer_name = CustomerName.from_dictionary(dictionary.get('customerName')) if dictionary.get('customerName') else None
        # Return an object of this model
        return cls(address,
                   customer_name)
