# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.account_device_list import AccountDeviceList
from verizon.models.custom_fields import CustomFields
from verizon.models.device_filter import DeviceFilter


class MoveDeviceRequest(object):

    """Implementation of the 'MoveDeviceRequest' model.

    Request to move active devices from one billing account to another within
    a customer profile.

    Attributes:
        account_name (str): The name of the billing account that you want to
            move the devices to.
        filter (DeviceFilter): Specify the kind of the device identifier, the
            type of match, and the string that you want to match.
        custom_fields (List[CustomFields]): Custom field names and values, if
            you want to only include devices that have matching values.
        devices (List[AccountDeviceList]): Up to 10,000 devices that you want
            to move to a different account, specified by device identifier.
        group_name (str): The name of a device group, to only include devices
            in that group.
        carrier_ip_pool_name (str): The pool from which device IP addresses
            will be derived in the new account. If you do not include this
            element, the default pool will be used.
        service_plan (str): The service plan code that you want to assign to
            the devices in the new account. If you do not include this
            element, ThingSpace will attempt to use the current service plan,
            which will result in a error if the new account does not have that
            service plan.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "filter": 'filter',
        "custom_fields": 'customFields',
        "devices": 'devices',
        "group_name": 'groupName',
        "carrier_ip_pool_name": 'carrierIpPoolName',
        "service_plan": 'servicePlan'
    }

    _optionals = [
        'filter',
        'custom_fields',
        'devices',
        'group_name',
        'carrier_ip_pool_name',
        'service_plan',
    ]

    def __init__(self,
                 account_name=None,
                 filter=APIHelper.SKIP,
                 custom_fields=APIHelper.SKIP,
                 devices=APIHelper.SKIP,
                 group_name=APIHelper.SKIP,
                 carrier_ip_pool_name=APIHelper.SKIP,
                 service_plan=APIHelper.SKIP):
        """Constructor for the MoveDeviceRequest class"""

        # Initialize members of the class
        self.account_name = account_name 
        if filter is not APIHelper.SKIP:
            self.filter = filter 
        if custom_fields is not APIHelper.SKIP:
            self.custom_fields = custom_fields 
        if devices is not APIHelper.SKIP:
            self.devices = devices 
        if group_name is not APIHelper.SKIP:
            self.group_name = group_name 
        if carrier_ip_pool_name is not APIHelper.SKIP:
            self.carrier_ip_pool_name = carrier_ip_pool_name 
        if service_plan is not APIHelper.SKIP:
            self.service_plan = service_plan 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        filter = DeviceFilter.from_dictionary(dictionary.get('filter')) if 'filter' in dictionary.keys() else APIHelper.SKIP
        custom_fields = None
        if dictionary.get('customFields') is not None:
            custom_fields = [CustomFields.from_dictionary(x) for x in dictionary.get('customFields')]
        else:
            custom_fields = APIHelper.SKIP
        devices = None
        if dictionary.get('devices') is not None:
            devices = [AccountDeviceList.from_dictionary(x) for x in dictionary.get('devices')]
        else:
            devices = APIHelper.SKIP
        group_name = dictionary.get("groupName") if dictionary.get("groupName") else APIHelper.SKIP
        carrier_ip_pool_name = dictionary.get("carrierIpPoolName") if dictionary.get("carrierIpPoolName") else APIHelper.SKIP
        service_plan = dictionary.get("servicePlan") if dictionary.get("servicePlan") else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   filter,
                   custom_fields,
                   devices,
                   group_name,
                   carrier_ip_pool_name,
                   service_plan)
