# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class MismatchedDevice(object):

    """Implementation of the 'MismatchedDevice' model.

    4G devices with an ICCID (SIM) that was not activated with the expected
    IMEI (hardware) during a specified time frame.

    Attributes:
        account_name (str): The account that the device is associated with.
        mdn (str): The assigned phone number of the device.
        activation_date (str): The date and time when the SIM was last
            activated.
        iccid (str): The ID of the SIM.
        pre_imei (str): The IMEI of the device prior to the SIM OTA activation
            on simOtaDate.
        post_imei (str): The IMEI of the device after the SIM OTA activation
            on simOtaDate.
        sim_ota_date (str): The date and time of the SIM OTA activation.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "mdn": 'mdn',
        "activation_date": 'activationDate',
        "iccid": 'iccid',
        "pre_imei": 'preImei',
        "post_imei": 'postImei',
        "sim_ota_date": 'simOtaDate'
    }

    _optionals = [
        'account_name',
        'mdn',
        'activation_date',
        'iccid',
        'pre_imei',
        'post_imei',
        'sim_ota_date',
    ]

    def __init__(self,
                 account_name=APIHelper.SKIP,
                 mdn=APIHelper.SKIP,
                 activation_date=APIHelper.SKIP,
                 iccid=APIHelper.SKIP,
                 pre_imei=APIHelper.SKIP,
                 post_imei=APIHelper.SKIP,
                 sim_ota_date=APIHelper.SKIP):
        """Constructor for the MismatchedDevice class"""

        # Initialize members of the class
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if mdn is not APIHelper.SKIP:
            self.mdn = mdn 
        if activation_date is not APIHelper.SKIP:
            self.activation_date = activation_date 
        if iccid is not APIHelper.SKIP:
            self.iccid = iccid 
        if pre_imei is not APIHelper.SKIP:
            self.pre_imei = pre_imei 
        if post_imei is not APIHelper.SKIP:
            self.post_imei = post_imei 
        if sim_ota_date is not APIHelper.SKIP:
            self.sim_ota_date = sim_ota_date 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        mdn = dictionary.get("mdn") if dictionary.get("mdn") else APIHelper.SKIP
        activation_date = dictionary.get("activationDate") if dictionary.get("activationDate") else APIHelper.SKIP
        iccid = dictionary.get("iccid") if dictionary.get("iccid") else APIHelper.SKIP
        pre_imei = dictionary.get("preImei") if dictionary.get("preImei") else APIHelper.SKIP
        post_imei = dictionary.get("postImei") if dictionary.get("postImei") else APIHelper.SKIP
        sim_ota_date = dictionary.get("simOtaDate") if dictionary.get("simOtaDate") else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   mdn,
                   activation_date,
                   iccid,
                   pre_imei,
                   post_imei,
                   sim_ota_date)
