# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.device import Device
from verizon.models.history_search_filter_attributes import HistorySearchFilterAttributes


class HistorySearchFilter(object):

    """Implementation of the 'HistorySearchFilter' model.

    The selected device and attributes for which a request should retrieve
    data.

    Attributes:
        account_name (str): Account name identifier.
        device (Device): Identifies a particular IoT device.
        attributes (HistorySearchFilterAttributes): Streaming RF parameters
            for which you want to retrieve history data.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "device": 'device',
        "attributes": 'attributes'
    }

    _optionals = [
        'attributes',
    ]

    def __init__(self,
                 account_name=None,
                 device=None,
                 attributes=APIHelper.SKIP):
        """Constructor for the HistorySearchFilter class"""

        # Initialize members of the class
        self.account_name = account_name 
        self.device = device 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        device = Device.from_dictionary(dictionary.get('device')) if dictionary.get('device') else None
        attributes = HistorySearchFilterAttributes.from_dictionary(dictionary.get('attributes')) if 'attributes' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   device,
                   attributes)
