# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.models.coordinates import Coordinates


class GetNetworkConditionsRequest(object):

    """Implementation of the 'GetNetworkConditionsRequest' model.

    Get network conditions.

    Attributes:
        account_name (str): Account name.
        location_type (str): Type of location detail.
        coordinates (Coordinates): Coordinates information.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "location_type": 'locationType',
        "coordinates": 'coordinates'
    }

    def __init__(self,
                 account_name=None,
                 location_type=None,
                 coordinates=None):
        """Constructor for the GetNetworkConditionsRequest class"""

        # Initialize members of the class
        self.account_name = account_name 
        self.location_type = location_type 
        self.coordinates = coordinates 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        location_type = dictionary.get("locationType") if dictionary.get("locationType") else None
        coordinates = Coordinates.from_dictionary(dictionary.get('coordinates')) if dictionary.get('coordinates') else None
        # Return an object of this model
        return cls(account_name,
                   location_type,
                   coordinates)
