# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.gio_device_id import GIODeviceId


class GetDeviceListWithProfilesRequest(object):

    """Implementation of the 'GetDeviceListWithProfilesRequest' model.

    TODO: type model description here.

    Attributes:
        account_name (str): TODO: type description here.
        provisioning_status_filter (str): TODO: type description here.
        profile_status_filter (str): TODO: type description here.
        carrier_name_filter (str): TODO: type description here.
        device_filter (List[GIODeviceId]): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "provisioning_status_filter": 'provisioningStatusFilter',
        "profile_status_filter": 'profileStatusFilter',
        "carrier_name_filter": 'carrierNameFilter',
        "device_filter": 'deviceFilter'
    }

    _optionals = [
        'provisioning_status_filter',
        'profile_status_filter',
        'carrier_name_filter',
        'device_filter',
    ]

    def __init__(self,
                 account_name=None,
                 provisioning_status_filter=APIHelper.SKIP,
                 profile_status_filter=APIHelper.SKIP,
                 carrier_name_filter=APIHelper.SKIP,
                 device_filter=APIHelper.SKIP):
        """Constructor for the GetDeviceListWithProfilesRequest class"""

        # Initialize members of the class
        self.account_name = account_name 
        if provisioning_status_filter is not APIHelper.SKIP:
            self.provisioning_status_filter = provisioning_status_filter 
        if profile_status_filter is not APIHelper.SKIP:
            self.profile_status_filter = profile_status_filter 
        if carrier_name_filter is not APIHelper.SKIP:
            self.carrier_name_filter = carrier_name_filter 
        if device_filter is not APIHelper.SKIP:
            self.device_filter = device_filter 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        provisioning_status_filter = dictionary.get("provisioningStatusFilter") if dictionary.get("provisioningStatusFilter") else APIHelper.SKIP
        profile_status_filter = dictionary.get("profileStatusFilter") if dictionary.get("profileStatusFilter") else APIHelper.SKIP
        carrier_name_filter = dictionary.get("carrierNameFilter") if dictionary.get("carrierNameFilter") else APIHelper.SKIP
        device_filter = None
        if dictionary.get('deviceFilter') is not None:
            device_filter = [GIODeviceId.from_dictionary(x) for x in dictionary.get('deviceFilter')]
        else:
            device_filter = APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   provisioning_status_filter,
                   profile_status_filter,
                   carrier_name_filter,
                   device_filter)
