# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class DiagnosticsSubscription(object):

    """Implementation of the 'DiagnosticsSubscription' model.

    Status of the diagnostic services subscription.

    Attributes:
        account_name (str): Account identifier in "##########-#####". An
            account name is usually numeric, and must include any leading
            zeros.
        created_on (datetime): The date and time of when the subscription was
            created.
        last_updated (datetime): The date and time of when the subscription
            was last updated.
        total_allowed (int): Number of licenses currently assigned to
            devices.
        total_used (int): Number of licenses currently used by the devices.
        sku_name (str): Name of the SKU for the account.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "created_on": 'createdOn',
        "last_updated": 'lastUpdated',
        "total_allowed": 'totalAllowed',
        "total_used": 'totalUsed',
        "sku_name": 'skuName'
    }

    def __init__(self,
                 account_name=None,
                 created_on=None,
                 last_updated=None,
                 total_allowed=None,
                 total_used=None,
                 sku_name=None):
        """Constructor for the DiagnosticsSubscription class"""

        # Initialize members of the class
        self.account_name = account_name 
        self.created_on = APIHelper.apply_datetime_converter(created_on, APIHelper.RFC3339DateTime) if created_on else None 
        self.last_updated = APIHelper.apply_datetime_converter(last_updated, APIHelper.RFC3339DateTime) if last_updated else None 
        self.total_allowed = total_allowed 
        self.total_used = total_used 
        self.sku_name = sku_name 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        created_on = APIHelper.RFC3339DateTime.from_value(dictionary.get("createdOn")).datetime if dictionary.get("createdOn") else None
        last_updated = APIHelper.RFC3339DateTime.from_value(dictionary.get("lastUpdated")).datetime if dictionary.get("lastUpdated") else None
        total_allowed = dictionary.get("totalAllowed") if dictionary.get("totalAllowed") else None
        total_used = dictionary.get("totalUsed") if dictionary.get("totalUsed") else None
        sku_name = dictionary.get("skuName") if dictionary.get("skuName") else None
        # Return an object of this model
        return cls(account_name,
                   created_on,
                   last_updated,
                   total_allowed,
                   total_used,
                   sku_name)
