# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.gio_device_list import GIODeviceList


class DeviceProfileRequest(object):

    """Implementation of the 'DeviceProfileRequest' model.

    TODO: type model description here.

    Attributes:
        devices (List[GIODeviceList]): TODO: type description here.
        account_name (str): TODO: type description here.
        service_plan (str): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "devices": 'devices',
        "account_name": 'accountName',
        "service_plan": 'servicePlan'
    }

    _optionals = [
        'devices',
        'account_name',
        'service_plan',
    ]

    def __init__(self,
                 devices=APIHelper.SKIP,
                 account_name=APIHelper.SKIP,
                 service_plan=APIHelper.SKIP):
        """Constructor for the DeviceProfileRequest class"""

        # Initialize members of the class
        if devices is not APIHelper.SKIP:
            self.devices = devices 
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if service_plan is not APIHelper.SKIP:
            self.service_plan = service_plan 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        devices = None
        if dictionary.get('devices') is not None:
            devices = [GIODeviceList.from_dictionary(x) for x in dictionary.get('devices')]
        else:
            devices = APIHelper.SKIP
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        service_plan = dictionary.get("servicePlan") if dictionary.get("servicePlan") else APIHelper.SKIP
        # Return an object of this model
        return cls(devices,
                   account_name,
                   service_plan)
