# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class DeviceListQueryItem(object):

    """Implementation of the 'DeviceListQueryItem' model.

    The list of devices in the account.

    Attributes:
        device_id (str): Device IMEI.
        mdn (str): The MDN (phone number) of the device.
        model (str): The device model name.
        make (str): The device make.
        firmware (str): The name of the firmware image currently installed on
            the device.
        fota_eligible (bool): True if the device firmware can be upgraded over
            the air using the Software Management Services API.
        license_assigned (bool): True if an MRC license has been assigned to
            this device.
        upgrade_time (str): The date and time that the device firmware was
            last upgraded. If a device has never been upgraded, the
            upgradeTime will be 01/01/1900 0:0:0.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "device_id": 'deviceId',
        "mdn": 'mdn',
        "model": 'model',
        "make": 'make',
        "firmware": 'firmware',
        "fota_eligible": 'fotaEligible',
        "license_assigned": 'licenseAssigned',
        "upgrade_time": 'upgradeTime'
    }

    _optionals = [
        'device_id',
        'mdn',
        'model',
        'make',
        'firmware',
        'fota_eligible',
        'license_assigned',
        'upgrade_time',
    ]

    def __init__(self,
                 device_id=APIHelper.SKIP,
                 mdn=APIHelper.SKIP,
                 model=APIHelper.SKIP,
                 make=APIHelper.SKIP,
                 firmware=APIHelper.SKIP,
                 fota_eligible=APIHelper.SKIP,
                 license_assigned=APIHelper.SKIP,
                 upgrade_time=APIHelper.SKIP):
        """Constructor for the DeviceListQueryItem class"""

        # Initialize members of the class
        if device_id is not APIHelper.SKIP:
            self.device_id = device_id 
        if mdn is not APIHelper.SKIP:
            self.mdn = mdn 
        if model is not APIHelper.SKIP:
            self.model = model 
        if make is not APIHelper.SKIP:
            self.make = make 
        if firmware is not APIHelper.SKIP:
            self.firmware = firmware 
        if fota_eligible is not APIHelper.SKIP:
            self.fota_eligible = fota_eligible 
        if license_assigned is not APIHelper.SKIP:
            self.license_assigned = license_assigned 
        if upgrade_time is not APIHelper.SKIP:
            self.upgrade_time = upgrade_time 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        device_id = dictionary.get("deviceId") if dictionary.get("deviceId") else APIHelper.SKIP
        mdn = dictionary.get("mdn") if dictionary.get("mdn") else APIHelper.SKIP
        model = dictionary.get("model") if dictionary.get("model") else APIHelper.SKIP
        make = dictionary.get("make") if dictionary.get("make") else APIHelper.SKIP
        firmware = dictionary.get("firmware") if dictionary.get("firmware") else APIHelper.SKIP
        fota_eligible = dictionary.get("fotaEligible") if "fotaEligible" in dictionary.keys() else APIHelper.SKIP
        license_assigned = dictionary.get("licenseAssigned") if "licenseAssigned" in dictionary.keys() else APIHelper.SKIP
        upgrade_time = dictionary.get("upgradeTime") if dictionary.get("upgradeTime") else APIHelper.SKIP
        # Return an object of this model
        return cls(device_id,
                   mdn,
                   model,
                   make,
                   firmware,
                   fota_eligible,
                   license_assigned,
                   upgrade_time)
