# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.account_identifier import AccountIdentifier


class CreateSubscriptionRequest(object):

    """Implementation of the 'CreateSubscriptionRequest' model.

    The details of the subscription that you want to create.

    Attributes:
        accountidentifier (AccountIdentifier): The ID of the authenticating
            billing account, in the format
            `{"billingaccountid":"1234567890-12345"}`.
        description (str): Descriptive information about the subscription.
        disabled (bool): Enable or disable the subscription. A disabled
            subscription will not send any data.
        email (str): The address to which any error reports should be
            delivered.
        filter (str): String containing a $filter object with a property and
            value to filter out non-matching events.
        billingaccountid (str): TODO: type description here.
        streamkind (str): The type of event data to send via this
            subscription. This will be `ts.event` in most cases. Other event
            types are `ts.event.diagnostics` for device diagnostic data,
            `ts.event.configuration` for device configuration events, or
            `ts.event.security`. Note that the device ThingSpace client must
            support sending specific event types for anything other than
            `ts.event`.
        targetid (str): The ID of the target resource to be used when
            dispatching events. The corresponding target should have a
            “stream” addressscheme.
        name (str): Name of the subscription.
        allowaggregation (bool): Setting this value to `false` prevents the
            data returned from being aggregated and makes the data easier to
            parse.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "accountidentifier": 'accountidentifier',
        "description": 'description',
        "disabled": 'disabled',
        "email": 'email',
        "filter": 'filter',
        "billingaccountid": 'billingaccountid',
        "streamkind": 'streamkind',
        "targetid": 'targetid',
        "name": 'name',
        "allowaggregation": 'allowaggregation'
    }

    _optionals = [
        'accountidentifier',
        'description',
        'disabled',
        'email',
        'filter',
        'billingaccountid',
        'streamkind',
        'targetid',
        'name',
        'allowaggregation',
    ]

    def __init__(self,
                 accountidentifier=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 disabled=APIHelper.SKIP,
                 email=APIHelper.SKIP,
                 filter=APIHelper.SKIP,
                 billingaccountid=APIHelper.SKIP,
                 streamkind=APIHelper.SKIP,
                 targetid=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 allowaggregation=APIHelper.SKIP):
        """Constructor for the CreateSubscriptionRequest class"""

        # Initialize members of the class
        if accountidentifier is not APIHelper.SKIP:
            self.accountidentifier = accountidentifier 
        if description is not APIHelper.SKIP:
            self.description = description 
        if disabled is not APIHelper.SKIP:
            self.disabled = disabled 
        if email is not APIHelper.SKIP:
            self.email = email 
        if filter is not APIHelper.SKIP:
            self.filter = filter 
        if billingaccountid is not APIHelper.SKIP:
            self.billingaccountid = billingaccountid 
        if streamkind is not APIHelper.SKIP:
            self.streamkind = streamkind 
        if targetid is not APIHelper.SKIP:
            self.targetid = targetid 
        if name is not APIHelper.SKIP:
            self.name = name 
        if allowaggregation is not APIHelper.SKIP:
            self.allowaggregation = allowaggregation 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        accountidentifier = AccountIdentifier.from_dictionary(dictionary.get('accountidentifier')) if 'accountidentifier' in dictionary.keys() else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        disabled = dictionary.get("disabled") if "disabled" in dictionary.keys() else APIHelper.SKIP
        email = dictionary.get("email") if dictionary.get("email") else APIHelper.SKIP
        filter = dictionary.get("filter") if dictionary.get("filter") else APIHelper.SKIP
        billingaccountid = dictionary.get("billingaccountid") if dictionary.get("billingaccountid") else APIHelper.SKIP
        streamkind = dictionary.get("streamkind") if dictionary.get("streamkind") else APIHelper.SKIP
        targetid = dictionary.get("targetid") if dictionary.get("targetid") else APIHelper.SKIP
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        allowaggregation = dictionary.get("allowaggregation") if "allowaggregation" in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(accountidentifier,
                   description,
                   disabled,
                   email,
                   filter,
                   billingaccountid,
                   streamkind,
                   targetid,
                   name,
                   allowaggregation)
