# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class CreateIoTApplicationResponse(object):

    """Implementation of the 'CreateIoTApplicationResponse' model.

    A success response includes an array of all matching events. Each event
    includes the full event resource definition.

    Attributes:
        app_name (str): An application will be created under the user's Azure
            subscription with this name and of type IOT central.
        shared_secret (str): Part of the user credentials (from Azure) the
            user needs to use for calling further TS Core APIs for setting up
            Azure cloud connector.
        url (str): An IOT central endpoint the user can use to see the data
            that is being streamed.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "app_name": 'appName',
        "shared_secret": 'sharedSecret',
        "url": 'url'
    }

    _optionals = [
        'app_name',
        'shared_secret',
        'url',
    ]

    def __init__(self,
                 app_name=APIHelper.SKIP,
                 shared_secret=APIHelper.SKIP,
                 url=APIHelper.SKIP):
        """Constructor for the CreateIoTApplicationResponse class"""

        # Initialize members of the class
        if app_name is not APIHelper.SKIP:
            self.app_name = app_name 
        if shared_secret is not APIHelper.SKIP:
            self.shared_secret = shared_secret 
        if url is not APIHelper.SKIP:
            self.url = url 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        app_name = dictionary.get("appName") if dictionary.get("appName") else APIHelper.SKIP
        shared_secret = dictionary.get("sharedSecret") if dictionary.get("sharedSecret") else APIHelper.SKIP
        url = dictionary.get("url") if dictionary.get("url") else APIHelper.SKIP
        # Return an object of this model
        return cls(app_name,
                   shared_secret,
                   url)
