# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class CheckInHistoryItem(object):

    """Implementation of the 'CheckInHistoryItem' model.

    Check-in history for a device.

    Attributes:
        device_id (str): Device IMEI.
        client_type (str): Type of client.
        result (str): TODO: type description here.
        failure_type (str): TODO: type description here.
        time_completed (datetime): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "device_id": 'deviceId',
        "client_type": 'clientType',
        "result": 'result',
        "failure_type": 'failureType',
        "time_completed": 'timeCompleted'
    }

    def __init__(self,
                 device_id=None,
                 client_type=None,
                 result=None,
                 failure_type=None,
                 time_completed=None):
        """Constructor for the CheckInHistoryItem class"""

        # Initialize members of the class
        self.device_id = device_id 
        self.client_type = client_type 
        self.result = result 
        self.failure_type = failure_type 
        self.time_completed = APIHelper.apply_datetime_converter(time_completed, APIHelper.RFC3339DateTime) if time_completed else None 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        device_id = dictionary.get("deviceId") if dictionary.get("deviceId") else None
        client_type = dictionary.get("clientType") if dictionary.get("clientType") else None
        result = dictionary.get("result") if dictionary.get("result") else None
        failure_type = dictionary.get("failureType") if dictionary.get("failureType") else None
        time_completed = APIHelper.RFC3339DateTime.from_value(dictionary.get("timeCompleted")).datetime if dictionary.get("timeCompleted") else None
        # Return an object of this model
        return cls(device_id,
                   client_type,
                   result,
                   failure_type,
                   time_completed)
