# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class CarrierInformation(object):

    """Implementation of the 'CarrierInformation' model.

    Information about the carrier.

    Attributes:
        carrier_name (str): The carrier that will perform the activation. This
            parameter is only required if you have more than one carrier.
        service_plan (str): The service plan code that is assigned to the
            device.
        state (str): The device state. Valid values include: Activate,
            Suspend, Deactive, Pre-active.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "carrier_name": 'carrierName',
        "service_plan": 'servicePlan',
        "state": 'state'
    }

    _optionals = [
        'carrier_name',
        'service_plan',
        'state',
    ]

    def __init__(self,
                 carrier_name=APIHelper.SKIP,
                 service_plan=APIHelper.SKIP,
                 state=APIHelper.SKIP):
        """Constructor for the CarrierInformation class"""

        # Initialize members of the class
        if carrier_name is not APIHelper.SKIP:
            self.carrier_name = carrier_name 
        if service_plan is not APIHelper.SKIP:
            self.service_plan = service_plan 
        if state is not APIHelper.SKIP:
            self.state = state 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        carrier_name = dictionary.get("carrierName") if dictionary.get("carrierName") else APIHelper.SKIP
        service_plan = dictionary.get("servicePlan") if dictionary.get("servicePlan") else APIHelper.SKIP
        state = dictionary.get("state") if dictionary.get("state") else APIHelper.SKIP
        # Return an object of this model
        return cls(carrier_name,
                   service_plan,
                   state)
