# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.billing_cycle import BillingCycle
from verizon.models.device_list import DeviceList
from verizon.models.labels_list import LabelsList


class BilledusageListRequest(object):

    """Implementation of the 'billedusageListRequest' model.

    Information required to associate a usage segmentation label with a device
    to retrieve billing.

    Attributes:
        account_name (str): TODO: type description here.
        labels (LabelsList): TODO: type description here.
        device_ids (List[DeviceList]): TODO: type description here.
        billing_cycle (BillingCycle): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "labels": 'labels',
        "device_ids": 'deviceIds',
        "billing_cycle": 'billingCycle'
    }

    _optionals = [
        'labels',
        'device_ids',
        'billing_cycle',
    ]

    def __init__(self,
                 account_name=None,
                 labels=APIHelper.SKIP,
                 device_ids=APIHelper.SKIP,
                 billing_cycle=APIHelper.SKIP):
        """Constructor for the BilledusageListRequest class"""

        # Initialize members of the class
        self.account_name = account_name 
        if labels is not APIHelper.SKIP:
            self.labels = labels 
        if device_ids is not APIHelper.SKIP:
            self.device_ids = device_ids 
        if billing_cycle is not APIHelper.SKIP:
            self.billing_cycle = billing_cycle 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        labels = LabelsList.from_dictionary(dictionary.get('labels')) if 'labels' in dictionary.keys() else APIHelper.SKIP
        device_ids = None
        if dictionary.get('deviceIds') is not None:
            device_ids = [DeviceList.from_dictionary(x) for x in dictionary.get('deviceIds')]
        else:
            device_ids = APIHelper.SKIP
        billing_cycle = BillingCycle.from_dictionary(dictionary.get('billingCycle')) if 'billingCycle' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   labels,
                   device_ids,
                   billing_cycle)
