# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class BillUsageRequest(object):

    """Implementation of the 'BillUsageRequest' model.

    Bill usage request.

    Attributes:
        account_name (str): Account identifier.
        start_date (str): Start date to search for billable usage,
            mm-dd-yyyy.
        end_date (str): End date to search for billable usage, mm-dd-yyyy.
        usage_for_all_accounts (bool): Request usage for single or multiple
            accounts.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "start_date": 'startDate',
        "end_date": 'endDate',
        "usage_for_all_accounts": 'usageForAllAccounts'
    }

    _optionals = [
        'usage_for_all_accounts',
    ]

    def __init__(self,
                 account_name=None,
                 start_date=None,
                 end_date=None,
                 usage_for_all_accounts=APIHelper.SKIP):
        """Constructor for the BillUsageRequest class"""

        # Initialize members of the class
        self.account_name = account_name 
        self.start_date = start_date 
        self.end_date = end_date 
        if usage_for_all_accounts is not APIHelper.SKIP:
            self.usage_for_all_accounts = usage_for_all_accounts 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        start_date = dictionary.get("startDate") if dictionary.get("startDate") else None
        end_date = dictionary.get("endDate") if dictionary.get("endDate") else None
        usage_for_all_accounts = dictionary.get("usageForAllAccounts") if "usageForAllAccounts" in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   start_date,
                   end_date,
                   usage_for_all_accounts)
