# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.numerical_data import NumericalData


class AttributeSetting(object):

    """Implementation of the 'AttributeSetting' model.

    Describes an attribute being observed and the frequency with which the
    attribute is being observed.

    Attributes:
        name (AttributeIdentifierEnum): Attribute identifier.
        value (str): Attribute value.
        created_on (datetime): Date and time request was created.
        is_observable (bool): Is the attribute observable?
        is_observing (bool): Is the attribute being observed?
        frequency (NumericalData): Describes value and unit of time.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "value": 'value',
        "created_on": 'createdOn',
        "is_observable": 'isObservable',
        "is_observing": 'isObserving',
        "frequency": 'frequency'
    }

    _optionals = [
        'name',
        'value',
        'created_on',
        'is_observable',
        'is_observing',
        'frequency',
    ]

    def __init__(self,
                 name=APIHelper.SKIP,
                 value=APIHelper.SKIP,
                 created_on=APIHelper.SKIP,
                 is_observable=APIHelper.SKIP,
                 is_observing=APIHelper.SKIP,
                 frequency=APIHelper.SKIP):
        """Constructor for the AttributeSetting class"""

        # Initialize members of the class
        if name is not APIHelper.SKIP:
            self.name = name 
        if value is not APIHelper.SKIP:
            self.value = value 
        if created_on is not APIHelper.SKIP:
            self.created_on = APIHelper.apply_datetime_converter(created_on, APIHelper.RFC3339DateTime) if created_on else None 
        if is_observable is not APIHelper.SKIP:
            self.is_observable = is_observable 
        if is_observing is not APIHelper.SKIP:
            self.is_observing = is_observing 
        if frequency is not APIHelper.SKIP:
            self.frequency = frequency 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        value = dictionary.get("value") if dictionary.get("value") else APIHelper.SKIP
        created_on = APIHelper.RFC3339DateTime.from_value(dictionary.get("createdOn")).datetime if dictionary.get("createdOn") else APIHelper.SKIP
        is_observable = dictionary.get("isObservable") if "isObservable" in dictionary.keys() else APIHelper.SKIP
        is_observing = dictionary.get("isObserving") if "isObserving" in dictionary.keys() else APIHelper.SKIP
        frequency = NumericalData.from_dictionary(dictionary.get('frequency')) if 'frequency' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(name,
                   value,
                   created_on,
                   is_observable,
                   is_observing,
                   frequency)
