# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class AggregateSessionReportRequest(object):

    """Implementation of the 'AggregateSessionReportRequest' model.

    Request for getting an aggregated session report.

    Attributes:
        account_number (str): The unique identifier for the account.
        start_date (str): Start date of session to include. If not specified 
            information will be shown from the earliest available (180 days).
            Can be either date in ISO 8601 format or predefined constants.
        end_date (str): End date of session to include. If not specified 
            information will be shown to the latest available. Can be either
            date in ISO 8601 format or predefined constants.
        imei (List[str]): Devices for which return usage info. Could be 0, 1
            or more. In case of 0 will return all devices belonging to
            customer (except of filtered by other parameters).
        device_group (str): User defined group name the devices are a member
            of.
        device_label (str): Optional filter parameter.
        data_plan (str): The data plan the devices beign queried belong to.
        no_session_flag (str): Optional filter parameter which return only
            devices with no sessions.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_number": 'accountNumber',
        "imei": 'imei',
        "start_date": 'startDate',
        "end_date": 'endDate',
        "device_group": 'deviceGroup',
        "device_label": 'deviceLabel',
        "data_plan": 'dataPlan',
        "no_session_flag": 'noSessionFlag'
    }

    _optionals = [
        'start_date',
        'end_date',
        'device_group',
        'device_label',
        'data_plan',
        'no_session_flag',
    ]

    _nullables = [
        'device_group',
        'device_label',
        'data_plan',
    ]

    def __init__(self,
                 account_number=None,
                 imei=None,
                 start_date=APIHelper.SKIP,
                 end_date=APIHelper.SKIP,
                 device_group=APIHelper.SKIP,
                 device_label=APIHelper.SKIP,
                 data_plan=APIHelper.SKIP,
                 no_session_flag=APIHelper.SKIP):
        """Constructor for the AggregateSessionReportRequest class"""

        # Initialize members of the class
        self.account_number = account_number 
        if start_date is not APIHelper.SKIP:
            self.start_date = start_date 
        if end_date is not APIHelper.SKIP:
            self.end_date = end_date 
        self.imei = imei 
        if device_group is not APIHelper.SKIP:
            self.device_group = device_group 
        if device_label is not APIHelper.SKIP:
            self.device_label = device_label 
        if data_plan is not APIHelper.SKIP:
            self.data_plan = data_plan 
        if no_session_flag is not APIHelper.SKIP:
            self.no_session_flag = no_session_flag 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else None
        imei = dictionary.get("imei") if dictionary.get("imei") else None
        start_date = dictionary.get("startDate") if dictionary.get("startDate") else APIHelper.SKIP
        end_date = dictionary.get("endDate") if dictionary.get("endDate") else APIHelper.SKIP
        device_group = dictionary.get("deviceGroup") if "deviceGroup" in dictionary.keys() else APIHelper.SKIP
        device_label = dictionary.get("deviceLabel") if "deviceLabel" in dictionary.keys() else APIHelper.SKIP
        data_plan = dictionary.get("dataPlan") if "dataPlan" in dictionary.keys() else APIHelper.SKIP
        no_session_flag = dictionary.get("noSessionFlag") if dictionary.get("noSessionFlag") else APIHelper.SKIP
        # Return an object of this model
        return cls(account_number,
                   imei,
                   start_date,
                   end_date,
                   device_group,
                   device_label,
                   data_plan,
                   no_session_flag)
