# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.account_device_list import AccountDeviceList
from verizon.models.custom_fields import CustomFields


class AddDevicesRequest(object):

    """Implementation of the 'AddDevicesRequest' model.

    Request to add the devices.

    Attributes:
        state (str): The initial service state for the devices. The only valid
            state is “Preactive.”
        devices_to_add (List[AccountDeviceList]): The devices that you want to
            add.
        account_name (str): The billing account to which the devices are
            added.
        custom_fields (List[CustomFields]): The names and values for any
            custom fields that you want set for the devices as they are added
            to the account.
        group_name (str): The name of a device group to add the devices to.
            They are added to the default device group if you don't include
            this parameter.
        sku_number (str): The Stock Keeping Unit (SKU) number of a 4G device
            type with an embedded SIM.
        smsr_oid (str): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "state": 'state',
        "devices_to_add": 'devicesToAdd',
        "account_name": 'accountName',
        "custom_fields": 'customFields',
        "group_name": 'groupName',
        "sku_number": 'skuNumber',
        "smsr_oid": 'smsrOid'
    }

    _optionals = [
        'account_name',
        'custom_fields',
        'group_name',
        'sku_number',
        'smsr_oid',
    ]

    def __init__(self,
                 state=None,
                 devices_to_add=None,
                 account_name=APIHelper.SKIP,
                 custom_fields=APIHelper.SKIP,
                 group_name=APIHelper.SKIP,
                 sku_number=APIHelper.SKIP,
                 smsr_oid=APIHelper.SKIP):
        """Constructor for the AddDevicesRequest class"""

        # Initialize members of the class
        self.state = state 
        self.devices_to_add = devices_to_add 
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if custom_fields is not APIHelper.SKIP:
            self.custom_fields = custom_fields 
        if group_name is not APIHelper.SKIP:
            self.group_name = group_name 
        if sku_number is not APIHelper.SKIP:
            self.sku_number = sku_number 
        if smsr_oid is not APIHelper.SKIP:
            self.smsr_oid = smsr_oid 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        state = dictionary.get("state") if dictionary.get("state") else None
        devices_to_add = None
        if dictionary.get('devicesToAdd') is not None:
            devices_to_add = [AccountDeviceList.from_dictionary(x) for x in dictionary.get('devicesToAdd')]
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        custom_fields = None
        if dictionary.get('customFields') is not None:
            custom_fields = [CustomFields.from_dictionary(x) for x in dictionary.get('customFields')]
        else:
            custom_fields = APIHelper.SKIP
        group_name = dictionary.get("groupName") if dictionary.get("groupName") else APIHelper.SKIP
        sku_number = dictionary.get("skuNumber") if dictionary.get("skuNumber") else APIHelper.SKIP
        smsr_oid = dictionary.get("smsrOid") if dictionary.get("smsrOid") else APIHelper.SKIP
        # Return an object of this model
        return cls(state,
                   devices_to_add,
                   account_name,
                   custom_fields,
                   group_name,
                   sku_number,
                   smsr_oid)
