# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.account_license_device_list_item import AccountLicenseDeviceListItem


class AccountLicenseInfo(object):

    """Implementation of the 'AccountLicenseInfo' model.

    Account license information.

    Attributes:
        account_name (str): Account identifier in "##########-#####".
        total_licenses (int): Number of monthly licenses in an MRC
            subscription.
        assigned_licenses (int): Number of licenses currently assigned to
            devices.
        has_more_data (bool): True if there are more devices to retrieve.
        last_seen_device_id (int): If hasMoreData=true, the startIndex to use
            for the next request. 0 if hasMoreData=false.
        device_list (List[AccountLicenseDeviceListItem]): The list of devices
            that have licenses assigned, including the date and time of when
            each license was assigned.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "total_licenses": 'totalLicenses',
        "assigned_licenses": 'assignedLicenses',
        "has_more_data": 'hasMoreData',
        "last_seen_device_id": 'lastSeenDeviceId',
        "device_list": 'deviceList'
    }

    _optionals = [
        'account_name',
        'total_licenses',
        'assigned_licenses',
        'has_more_data',
        'last_seen_device_id',
        'device_list',
    ]

    def __init__(self,
                 account_name=APIHelper.SKIP,
                 total_licenses=APIHelper.SKIP,
                 assigned_licenses=APIHelper.SKIP,
                 has_more_data=APIHelper.SKIP,
                 last_seen_device_id=APIHelper.SKIP,
                 device_list=APIHelper.SKIP):
        """Constructor for the AccountLicenseInfo class"""

        # Initialize members of the class
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if total_licenses is not APIHelper.SKIP:
            self.total_licenses = total_licenses 
        if assigned_licenses is not APIHelper.SKIP:
            self.assigned_licenses = assigned_licenses 
        if has_more_data is not APIHelper.SKIP:
            self.has_more_data = has_more_data 
        if last_seen_device_id is not APIHelper.SKIP:
            self.last_seen_device_id = last_seen_device_id 
        if device_list is not APIHelper.SKIP:
            self.device_list = device_list 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        total_licenses = dictionary.get("totalLicenses") if dictionary.get("totalLicenses") else APIHelper.SKIP
        assigned_licenses = dictionary.get("assignedLicenses") if dictionary.get("assignedLicenses") else APIHelper.SKIP
        has_more_data = dictionary.get("hasMoreData") if "hasMoreData" in dictionary.keys() else APIHelper.SKIP
        last_seen_device_id = dictionary.get("lastSeenDeviceId") if dictionary.get("lastSeenDeviceId") else APIHelper.SKIP
        device_list = None
        if dictionary.get('deviceList') is not None:
            device_list = [AccountLicenseDeviceListItem.from_dictionary(x) for x in dictionary.get('deviceList')]
        else:
            device_list = APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   total_licenses,
                   assigned_licenses,
                   has_more_data,
                   last_seen_device_id,
                   device_list)
